/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.splunk.search;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.adapter.splunk.search.SearchResultListener;
import org.apache.calcite.adapter.splunk.search.SplunkConnection;
import org.apache.calcite.adapter.splunk.util.StringUtils;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.runtime.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplunkConnectionImpl
implements SplunkConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(SplunkConnectionImpl.class);
    private static final Pattern SESSION_KEY = Pattern.compile("<response>\\s*<sessionKey>([0-9a-f]+)</sessionKey>\\s*</response>");
    final URL url;
    final String username;
    final String password;
    String sessionKey;
    final Map<String, String> requestHeaders = new HashMap<String, String>();

    public SplunkConnectionImpl(String url, String username, String password) throws MalformedURLException {
        this(new URL(url), username, password);
    }

    public SplunkConnectionImpl(URL url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.connect();
    }

    private static void close(Closeable c) {
        try {
            c.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        BufferedReader rd = null;
        try {
            String line;
            String loginUrl = String.format("%s://%s:%d/services/auth/login", this.url.getProtocol(), this.url.getHost(), this.url.getPort());
            StringBuilder data = new StringBuilder();
            HttpUtils.appendURLEncodedArgs((StringBuilder)data, (CharSequence[])new CharSequence[]{"username", this.username, "password", this.password});
            rd = new BufferedReader(new InputStreamReader(HttpUtils.post((String)loginUrl, (CharSequence)data, this.requestHeaders)));
            StringBuilder reply = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                reply.append(line);
                reply.append("\n");
            }
            Matcher m = SESSION_KEY.matcher(reply);
            if (m.find()) {
                this.sessionKey = m.group(1);
                this.requestHeaders.put("Authorization", "Splunk " + this.sessionKey);
            }
            SplunkConnectionImpl.close(rd);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            SplunkConnectionImpl.close(rd);
        }
    }

    @Override
    public void getSearchResults(String search, Map<String, String> otherArgs, List<String> fieldList, SearchResultListener srl) {
        assert (srl != null);
        Enumerator<Object> x = this.getSearchResults_(search, otherArgs, fieldList, srl);
        assert (x == null);
    }

    @Override
    public Enumerator<Object> getSearchResultEnumerator(String search, Map<String, String> otherArgs, List<String> fieldList) {
        return this.getSearchResults_(search, otherArgs, fieldList, null);
    }

    private Enumerator<Object> getSearchResults_(String search, Map<String, String> otherArgs, List<String> wantedFields, SearchResultListener srl) {
        String searchUrl = String.format("%s://%s:%d/services/search/jobs/export", this.url.getProtocol(), this.url.getHost(), this.url.getPort());
        StringBuilder data = new StringBuilder();
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        if (otherArgs != null) {
            args.putAll(otherArgs);
        }
        args.put("search", search);
        args.put("output_mode", "csv");
        args.put("preview", "0");
        args.put("check_connection", "0");
        HttpUtils.appendURLEncodedArgs((StringBuilder)data, args);
        try {
            InputStream in = HttpUtils.post((String)searchUrl, (CharSequence)data, this.requestHeaders, (int)10000, (int)1800000);
            if (srl == null) {
                return new SplunkResultEnumerator(in, wantedFields);
            }
            SplunkConnectionImpl.parseResults(in, srl);
            return null;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            LOGGER.warn("{}\n{}", (Object)e.getMessage(), (Object)sw);
            return srl == null ? Linq4j.emptyEnumerator() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseResults(InputStream in, SearchResultListener srl) throws IOException {
        CSVReader csvr = new CSVReader((Reader)new InputStreamReader(in));
        try {
            String[] header = csvr.readNext();
            if (!(header == null || header.length <= 0 || header.length == 1 && header[0].isEmpty())) {
                String[] line;
                srl.setFieldNames(header);
                while ((line = csvr.readNext()) != null) {
                    if (line.length != header.length) continue;
                    srl.processSearchResult(line);
                }
            }
        }
        catch (IOException ignore) {
            StringWriter sw = new StringWriter();
            ignore.printStackTrace(new PrintWriter(sw));
            LOGGER.warn("{}\n{}", (Object)ignore.getMessage(), (Object)sw);
        }
        finally {
            HttpUtils.close((Closeable)csvr);
        }
    }

    public static void parseArgs(String[] args, Map<String, String> map) {
        for (int i = 0; i < args.length; ++i) {
            String argValue;
            String argName = args[i++];
            String string = argValue = i < args.length ? args[i] : "";
            if (!argName.startsWith("-")) {
                throw new IllegalArgumentException("invalid argument name: " + argName + ". Argument names must start with -");
            }
            map.put(argName.substring(1), argValue);
        }
    }

    public static void printUsage(String errorMsg) {
        String[] strings = new String[]{"Usage: java Connection -<arg-name> <arg-value>", "The following <arg-name> are valid", "search        - required, search string to execute", "field_list    - required, list of fields to request, comma delimited", "uri           - uri to splunk's mgmt port, default: https://localhost:8089", "username      - username to use for authentication, default: admin", "password      - password to use for authentication, default: changeme", "earliest_time - earliest time for the search, default: -24h", "latest_time   - latest time for the search, default: now", "-print        - whether to print results or just the summary"};
        System.err.println(errorMsg);
        for (String s : strings) {
            System.err.println(s);
        }
        System.exit(1);
    }

    public static void main(String[] args) throws MalformedURLException {
        HashMap<String, String> argsMap = new HashMap<String, String>();
        argsMap.put("uri", "https://localhost:8089");
        argsMap.put("username", "admin");
        argsMap.put("password", "changeme");
        argsMap.put("earliest_time", "-24h");
        argsMap.put("latest_time", "now");
        argsMap.put("-print", "true");
        SplunkConnectionImpl.parseArgs(args, argsMap);
        String search = (String)argsMap.get("search");
        String field_list = (String)argsMap.get("field_list");
        if (search == null) {
            SplunkConnectionImpl.printUsage("Missing required argument: search");
        }
        if (field_list == null) {
            SplunkConnectionImpl.printUsage("Missing required argument: field_list");
        }
        List<String> fieldList = StringUtils.decodeList(field_list, ',');
        SplunkConnectionImpl c = new SplunkConnectionImpl((String)argsMap.get("uri"), (String)argsMap.get("username"), (String)argsMap.get("password"));
        HashMap<String, String> searchArgs = new HashMap<String, String>();
        searchArgs.put("earliest_time", (String)argsMap.get("earliest_time"));
        searchArgs.put("latest_time", (String)argsMap.get("latest_time"));
        searchArgs.put("field_list", StringUtils.encodeList(fieldList, ',').toString());
        CountingSearchResultListener dummy = new CountingSearchResultListener(Boolean.valueOf((String)argsMap.get("-print")));
        long start = System.currentTimeMillis();
        c.getSearchResults(search, searchArgs, null, dummy);
        System.out.printf("received %d results in %dms\n", dummy.getResultCount(), System.currentTimeMillis() - start);
    }

    public static class SplunkResultEnumerator
    implements Enumerator<Object> {
        private final CSVReader csvReader;
        private String[] fieldNames;
        private int[] sources;
        private Object current;
        private int source;

        public SplunkResultEnumerator(InputStream in, List<String> wantedFields) {
            this.csvReader = new CSVReader((Reader)new InputStreamReader(in));
            try {
                this.fieldNames = this.csvReader.readNext();
                if (!(this.fieldNames == null || this.fieldNames.length == 0 || this.fieldNames.length == 1 && this.fieldNames[0].isEmpty())) {
                    List<String> headerList = Arrays.asList(this.fieldNames);
                    if (wantedFields.size() == 1) {
                        this.source = headerList.indexOf(wantedFields.get(0));
                        assert (this.source >= -1);
                        this.sources = null;
                    } else if (wantedFields.equals(headerList)) {
                        this.source = -2;
                    } else {
                        this.source = -3;
                        this.sources = new int[wantedFields.size()];
                        int i = 0;
                        for (String wantedField : wantedFields) {
                            this.sources[i++] = headerList.indexOf(wantedField);
                        }
                    }
                }
            }
            catch (IOException ignore) {
                StringWriter sw = new StringWriter();
                ignore.printStackTrace(new PrintWriter(sw));
                LOGGER.warn("{}\n{}", (Object)ignore.getMessage(), (Object)sw);
            }
        }

        public Object current() {
            return this.current;
        }

        public boolean moveNext() {
            try {
                String[] line;
                while ((line = this.csvReader.readNext()) != null) {
                    if (line.length != this.fieldNames.length) continue;
                    switch (this.source) {
                        case -3: {
                            String[] mapped = new String[this.sources.length];
                            for (int i = 0; i < this.sources.length; ++i) {
                                int source1 = this.sources[i];
                                mapped[i] = source1 < 0 ? null : line[source1];
                            }
                            this.current = mapped;
                            break;
                        }
                        case -2: {
                            this.current = line;
                            break;
                        }
                        case -1: {
                            this.current = null;
                            break;
                        }
                        default: {
                            this.current = line[this.source];
                        }
                    }
                    return true;
                }
            }
            catch (IOException ignore) {
                StringWriter sw = new StringWriter();
                ignore.printStackTrace(new PrintWriter(sw));
                LOGGER.warn("{}\n{}", (Object)ignore.getMessage(), (Object)sw);
            }
            return false;
        }

        public void reset() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            try {
                this.csvReader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class CountingSearchResultListener
    implements SearchResultListener {
        String[] fieldNames = null;
        int resultCount = 0;
        final boolean print;

        public CountingSearchResultListener(boolean print) {
            this.print = print;
        }

        @Override
        public void setFieldNames(String[] fieldNames) {
            this.fieldNames = fieldNames;
        }

        @Override
        public boolean processSearchResult(String[] values) {
            ++this.resultCount;
            if (this.print) {
                for (int i = 0; i < this.fieldNames.length; ++i) {
                    System.out.printf("%s=%s\n", this.fieldNames[i], values[i]);
                }
                System.out.println();
            }
            return true;
        }

        public int getResultCount() {
            return this.resultCount;
        }
    }
}

