/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.test;

import java.sql.ResultSet;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.StringAndPos;
import org.apache.calcite.sql.test.SqlTestFactory;
import org.apache.calcite.sql.test.SqlTests;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.test.DiffRepository;
import org.apache.calcite.util.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface SqlTester
extends AutoCloseable {
    public void forEachQuery(SqlTestFactory var1, String var2, Consumer<String> var3);

    public SqlNode parseQuery(SqlTestFactory var1, String var2) throws SqlParseException;

    public SqlNode parseExpression(SqlTestFactory var1, String var2) throws SqlParseException;

    public void validateAndThen(SqlTestFactory var1, StringAndPos var2, ValidatedNodeConsumer var3);

    public <R> R validateAndApply(SqlTestFactory var1, StringAndPos var2, ValidatedNodeFunction<R> var3);

    public void assertExceptionIsThrown(SqlTestFactory var1, StringAndPos var2, @Nullable String var3);

    public RelDataType getColumnType(SqlTestFactory var1, String var2);

    public RelDataType getResultType(SqlTestFactory var1, String var2);

    public void checkColumnType(SqlTestFactory var1, String var2, String var3);

    default public void check(SqlTestFactory factory, String query, TypeChecker typeChecker, ResultChecker resultChecker) {
        this.check(factory, query, typeChecker, SqlTests.ANY_PARAMETER_CHECKER, resultChecker);
    }

    public void check(SqlTestFactory var1, String var2, TypeChecker var3, ParameterChecker var4, ResultChecker var5);

    public void setFor(SqlOperator var1, VmName ... var2);

    public void checkAgg(SqlTestFactory var1, String var2, String[] var3, ResultChecker var4);

    public void checkWinAgg(SqlTestFactory var1, String var2, String[] var3, String var4, String var5, ResultChecker var6);

    public void checkAggFails(SqlTestFactory var1, String var2, String[] var3, String var4, boolean var5);

    public void checkFails(SqlTestFactory var1, StringAndPos var2, String var3, boolean var4);

    default public void checkFails(SqlTestFactory factory, String expression, String expectedError, boolean runtime) {
        this.checkFails(factory, StringAndPos.of((String)expression), expectedError, runtime);
    }

    public void checkQueryFails(SqlTestFactory var1, StringAndPos var2, String var3);

    default public RelRoot convertSqlToRel(SqlTestFactory factory, String sql, boolean decorrelate, boolean trim) {
        Pair<SqlValidator, RelRoot> pair = this.convertSqlToRel2(factory, sql, decorrelate, trim);
        return (RelRoot)Objects.requireNonNull(pair.right);
    }

    public Pair<SqlValidator, RelRoot> convertSqlToRel2(SqlTestFactory var1, String var2, boolean var3, boolean var4);

    public void assertConvertsTo(SqlTestFactory var1, DiffRepository var2, String var3, String var4, boolean var5, boolean var6, boolean var7);

    public RelNode trimRelNode(SqlTestFactory var1, RelNode var2);

    public static interface ValidatedNodeFunction<R> {
        public R apply(StringAndPos var1, SqlValidator var2, SqlNode var3);
    }

    public static interface ValidatedNodeConsumer {
        public void accept(StringAndPos var1, SqlValidator var2, SqlNode var3);
    }

    public static interface ResultChecker {
        public void checkResult(ResultSet var1) throws Exception;
    }

    public static interface ParameterChecker {
        public void checkParameters(RelDataType var1);
    }

    public static interface TypeChecker {
        public void checkType(RelDataType var1);
    }

    public static enum VmName {
        FENNEL,
        JAVA,
        EXPAND;

    }
}

