/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import org.apache.calcite.avatica.ConnectionProperty;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.plan.Strong;
import org.apache.calcite.rel.type.DelegatingTypeSystem;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.TimeFrameSet;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJdbcFunctionCall;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.dialect.AnsiSqlDialect;
import org.apache.calcite.sql.fun.SqlLibrary;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.calcite.sql.test.AbstractSqlTester;
import org.apache.calcite.sql.test.ResultCheckers;
import org.apache.calcite.sql.test.SqlOperatorFixture;
import org.apache.calcite.sql.test.SqlTestFactory;
import org.apache.calcite.sql.test.SqlTester;
import org.apache.calcite.sql.test.SqlTests;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.util.SqlString;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.ConnectionFactories;
import org.apache.calcite.test.ConnectionFactory;
import org.apache.calcite.test.SqlOperatorFixtureImpl;
import org.apache.calcite.test.SqlRuntimeTester;
import org.apache.calcite.util.DateTimeStringUtils;
import org.apache.calcite.util.Holder;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.TestUtil;
import org.apache.calcite.util.TimestampString;
import org.apache.calcite.util.TryThreadLocal;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;

public class SqlOperatorTest {
    public static final TesterImpl TESTER = new TesterImpl();
    private static final Logger LOGGER = CalciteTrace.getTestTracer(SqlOperatorTest.class);
    public static final boolean TODO = false;
    public static final Pattern TIME_PATTERN = Pattern.compile("[0-9][0-9]:[0-9][0-9]:[0-9][0-9]");
    public static final Pattern TIMESTAMP_PATTERN = Pattern.compile("[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9] [0-9][0-9]:[0-9][0-9]:[0-9][0-9]");
    public static final Pattern DATE_PATTERN = Pattern.compile("[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]");
    public static final List<String> MICROSECOND_VARIANTS = Arrays.asList("FRAC_SECOND", "MICROSECOND", "SQL_TSI_MICROSECOND");
    public static final List<String> NANOSECOND_VARIANTS = Arrays.asList("NANOSECOND", "SQL_TSI_FRAC_SECOND");
    public static final List<String> SECOND_VARIANTS = Arrays.asList("SECOND", "SQL_TSI_SECOND");
    public static final List<String> MINUTE_VARIANTS = Arrays.asList("MINUTE", "SQL_TSI_MINUTE");
    public static final List<String> HOUR_VARIANTS = Arrays.asList("HOUR", "SQL_TSI_HOUR");
    public static final List<String> DAY_VARIANTS = Arrays.asList("DAY", "SQL_TSI_DAY");
    public static final List<String> WEEK_VARIANTS = Arrays.asList("WEEK", "SQL_TSI_WEEK");
    public static final List<String> MONTH_VARIANTS = Arrays.asList("MONTH", "SQL_TSI_MONTH");
    public static final List<String> QUARTER_VARIANTS = Arrays.asList("QUARTER", "SQL_TSI_QUARTER");
    public static final List<String> YEAR_VARIANTS = Arrays.asList("YEAR", "SQL_TSI_YEAR");
    private static final boolean[] FALSE_TRUE = new boolean[]{false, true};
    private static final SqlOperatorFixture.VmName VM_FENNEL = SqlOperatorFixture.VmName.FENNEL;
    private static final SqlOperatorFixture.VmName VM_JAVA = SqlOperatorFixture.VmName.JAVA;
    private static final SqlOperatorFixture.VmName VM_EXPAND = SqlOperatorFixture.VmName.EXPAND;
    protected static final TimeZone UTC_TZ = TimeZone.getTimeZone("GMT");
    protected static final TimeZone LOCAL_TZ;
    protected static final TimeZone CURRENT_TZ;
    private static final Pattern INVALID_ARG_FOR_POWER;
    private static final Pattern CODE_2201F;
    public static final boolean DECIMAL = false;
    private static final UnaryOperator<String> DOUBLER;

    protected SqlOperatorFixture fixture() {
        return SqlOperatorFixtureImpl.DEFAULT;
    }

    @Test
    void testDummy() {
    }

    @Test
    void testSqlOperatorOverloading() {
        SqlStdOperatorTable operatorTable = SqlStdOperatorTable.instance();
        for (SqlOperator sqlOperator : operatorTable.getOperatorList()) {
            String operatorName = sqlOperator.getName();
            ArrayList<SqlOperator> routines = new ArrayList<SqlOperator>();
            SqlIdentifier id = new SqlIdentifier(operatorName, SqlParserPos.ZERO);
            operatorTable.lookupOperatorOverloads(id, null, sqlOperator.getSyntax(), routines, SqlNameMatchers.withCaseSensitive((boolean)true));
            routines.removeIf(operator -> !sqlOperator.getClass().isInstance(operator));
            MatcherAssert.assertThat((Object)routines.size(), (Matcher)CoreMatchers.equalTo((Object)1));
            MatcherAssert.assertThat((Object)sqlOperator, (Matcher)CoreMatchers.equalTo(routines.get(0)));
        }
    }

    @Test
    void testBetween() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.BETWEEN, SqlOperatorFixture.VmName.EXPAND);
        f.checkBoolean("2 between 1 and 3", true);
        f.checkBoolean("2 between 3 and 2", false);
        f.checkBoolean("2 between symmetric 3 and 2", true);
        f.checkBoolean("3 between 1 and 3", true);
        f.checkBoolean("4 between 1 and 3", false);
        f.checkBoolean("1 between 4 and -3", false);
        f.checkBoolean("1 between -1 and -3", false);
        f.checkBoolean("1 between -1 and 3", true);
        f.checkBoolean("1 between 1 and 1", true);
        f.checkBoolean("1.5 between 1 and 3", true);
        f.checkBoolean("1.2 between 1.1 and 1.3", true);
        f.checkBoolean("1.5 between 2 and 3", false);
        f.checkBoolean("1.5 between 1.6 and 1.7", false);
        f.checkBoolean("1.2e1 between 1.1 and 1.3", false);
        f.checkBoolean("1.2e0 between 1.1 and 1.3", true);
        f.checkBoolean("1.5e0 between 2 and 3", false);
        f.checkBoolean("1.5e0 between 2e0 and 3e0", false);
        f.checkBoolean("1.5e1 between 1.6e1 and 1.7e1", false);
        f.checkBoolean("x'' between x'' and x''", true);
        f.checkNull("cast(null as integer) between -1 and 2");
        f.checkNull("1 between -1 and cast(null as integer)");
        f.checkNull("1 between cast(null as integer) and cast(null as integer)");
        f.checkNull("1 between cast(null as integer) and 1");
        f.checkBoolean("x'0A00015A' between x'0A000130' and x'0A0001B0'", true);
        f.checkBoolean("x'0A00015A' between x'0A0001A0' and x'0A0001B0'", false);
    }

    @Test
    void testNotBetween() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.NOT_BETWEEN, VM_EXPAND);
        f.checkBoolean("2 not between 1 and 3", false);
        f.checkBoolean("3 not between 1 and 3", false);
        f.checkBoolean("4 not between 1 and 3", true);
        f.checkBoolean("1.2e0 not between 1.1 and 1.3", false);
        f.checkBoolean("1.2e1 not between 1.1 and 1.3", true);
        f.checkBoolean("1.5e0 not between 2 and 3", true);
        f.checkBoolean("1.5e0 not between 2e0 and 3e0", true);
        f.checkBoolean("x'0A00015A' not between x'0A000130' and x'0A0001B0'", false);
        f.checkBoolean("x'0A00015A' not between x'0A0001A0' and x'0A0001B0'", true);
    }

    @Test
    void testCastToString() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CAST, SqlOperatorFixture.VmName.EXPAND);
        f.checkCastToString("cast(cast('abc' as char(4)) as varchar(6))", null, "abc ");
        f.checkCastToString("123", "CHAR(3)", "123");
        f.checkCastToString("0", "CHAR", "0");
        f.checkCastToString("-123", "CHAR(4)", "-123");
        f.checkCastToString("123.4", "CHAR(5)", "123.4");
        f.checkCastToString("-0.0", "CHAR(2)", ".0");
        f.checkCastToString("-123.4", "CHAR(6)", "-123.4");
        f.checkString("cast(1.29 as varchar(10))", "1.29", "VARCHAR(10) NOT NULL");
        f.checkString("cast(.48 as varchar(10))", ".48", "VARCHAR(10) NOT NULL");
        f.checkString("cast(-0.29 as varchar(10))", "-.29", "VARCHAR(10) NOT NULL");
        f.checkString("cast(-1.29 as varchar(10))", "-1.29", "VARCHAR(10) NOT NULL");
        f.checkCastToString("1.23E45", "CHAR(7)", "1.23E45");
        f.checkCastToString("CAST(0 AS DOUBLE)", "CHAR(3)", "0E0");
        f.checkCastToString("-1.20e-07", "CHAR(7)", "-1.2E-7");
        f.checkCastToString("cast(0e0 as varchar(5))", "CHAR(3)", "0E0");
        f.checkCastToString("'abc'", "CHAR(1)", "a");
        f.checkCastToString("'abc'", "CHAR(3)", "abc");
        f.checkCastToString("cast('abc' as varchar(6))", "CHAR(3)", "abc");
        f.checkCastToString("cast(' abc  ' as varchar(10))", null, " abc  ");
        f.checkCastToString("cast(cast('abc' as char(4)) as varchar(6))", null, "abc ");
        f.checkString("cast(cast('a' as char(2)) as varchar(3)) || 'x' ", "a x", "VARCHAR(4) NOT NULL");
        f.checkString("cast(cast('a' as char(3)) as varchar(5)) || 'x' ", "a  x", "VARCHAR(6) NOT NULL");
        f.checkString("cast('a' as char(3)) || 'x'", "a  x", "CHAR(4) NOT NULL");
        f.checkScalar("char_length(cast(' x ' as char(4)))", 4, "INTEGER NOT NULL");
        f.checkScalar("char_length(cast(' x ' as varchar(3)))", 3, "INTEGER NOT NULL");
        f.checkScalar("char_length(cast(' x ' as varchar(4)))", 3, "INTEGER NOT NULL");
        f.checkScalar("char_length(cast(cast(' x ' as char(4)) as varchar(5)))", 4, "INTEGER NOT NULL");
        f.checkScalar("char_length(cast(' x ' as varchar(3)))", 3, "INTEGER NOT NULL");
        f.checkCastToString("date '2008-01-01'", "CHAR(10)", "2008-01-01");
        f.checkCastToString("time '1:2:3'", "CHAR(8)", "01:02:03");
        f.checkCastToString("timestamp '2008-1-1 1:2:3'", "CHAR(19)", "2008-01-01 01:02:03");
        f.checkCastToString("timestamp '2008-1-1 1:2:3'", "VARCHAR(30)", "2008-01-01 01:02:03");
        f.checkCastToString("interval '3-2' year to month", "CHAR(5)", "+3-02");
        f.checkCastToString("interval '32' month", "CHAR(3)", "+32");
        f.checkCastToString("interval '1 2:3:4' day to second", "CHAR(11)", "+1 02:03:04");
        f.checkCastToString("interval '1234.56' second(4,2)", "CHAR(8)", "+1234.56");
        f.checkCastToString("interval '60' day", "CHAR(8)", "+60     ");
        f.checkCastToString("True", "CHAR(4)", "TRUE");
        f.checkCastToString("True", "CHAR(6)", "TRUE  ");
        f.checkCastToString("True", "VARCHAR(6)", "TRUE");
        f.checkCastToString("False", "CHAR(5)", "FALSE");
    }

    @Test
    void testCastExactNumericLimits() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CAST, SqlOperatorFixture.VmName.EXPAND);
        Numeric.forEach(numeric -> {
            String type = ((Numeric)numeric).typeName;
            switch (numeric) {
                case DOUBLE: 
                case FLOAT: 
                case REAL: {
                    return;
                }
            }
            f.checkCastToScalarOkay(((Numeric)numeric).maxNumericString, type);
            f.checkCastToScalarOkay(((Numeric)numeric).minNumericString, type);
            if (numeric == Numeric.BIGINT) {
                f.checkCastFails(((Numeric)numeric).maxOverflowNumericString, type, "(?s).*Numeric literal.*out of range.*", false);
                f.checkCastFails(((Numeric)numeric).minOverflowNumericString, type, "(?s).*Numeric literal.*out of range.*", false);
            }
            f.checkCastToScalarOkay("'" + ((Numeric)numeric).maxNumericString + "'", type, ((Numeric)numeric).maxNumericString);
            f.checkCastToScalarOkay("'" + ((Numeric)numeric).minNumericString + "'", type, ((Numeric)numeric).minNumericString);
            f.checkCastToString(((Numeric)numeric).maxNumericString, null, null);
            f.checkCastToString(((Numeric)numeric).maxNumericString, type, null);
            f.checkCastToString(((Numeric)numeric).minNumericString, null, null);
            f.checkCastToString(((Numeric)numeric).minNumericString, type, null);
        });
    }

    @Test
    void testCastToExactNumeric() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CAST, SqlOperatorFixture.VmName.EXPAND);
        f.checkCastToScalarOkay("1", "BIGINT");
        f.checkCastToScalarOkay("1", "INTEGER");
        f.checkCastToScalarOkay("1", "SMALLINT");
        f.checkCastToScalarOkay("1", "TINYINT");
        f.checkCastToScalarOkay("1", "DECIMAL(4, 0)");
        f.checkCastToScalarOkay("-1", "BIGINT");
        f.checkCastToScalarOkay("-1", "INTEGER");
        f.checkCastToScalarOkay("-1", "SMALLINT");
        f.checkCastToScalarOkay("-1", "TINYINT");
        f.checkCastToScalarOkay("-1", "DECIMAL(4, 0)");
        f.checkCastToScalarOkay("1.234E3", "INTEGER", "1234");
        f.checkCastToScalarOkay("-9.99E2", "INTEGER", "-999");
        f.checkCastToScalarOkay("'1'", "INTEGER", "1");
        f.checkCastToScalarOkay("' 01 '", "INTEGER", "1");
        f.checkCastToScalarOkay("'-1'", "INTEGER", "-1");
        f.checkCastToScalarOkay("' -00 '", "INTEGER", "0");
        f.checkScalarExact("cast('6543' as integer)", 6543);
        f.checkScalarExact("cast(' -123 ' as int)", -123);
        f.checkScalarExact("cast('654342432412312' as bigint)", "BIGINT NOT NULL", "654342432412312");
    }

    @Test
    void testCastStringToDecimal() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CAST, SqlOperatorFixture.VmName.EXPAND);
    }

    @Test
    void testCastIntervalToNumeric() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CAST, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalarExact("cast(INTERVAL '1.25' second as bigint)", "BIGINT NOT NULL", "1");
        f.checkScalarExact("cast(INTERVAL '-1.29' second(1,2) as bigint)", "BIGINT NOT NULL", "-1");
        f.checkScalarExact("cast(INTERVAL '5' day as bigint)", "BIGINT NOT NULL", "5");
        f.checkScalarExact("cast(INTERVAL '1.25' second as integer)", "INTEGER NOT NULL", "1");
        f.checkScalarExact("cast(INTERVAL '-1.29' second(1,2) as integer)", "INTEGER NOT NULL", "-1");
        f.checkScalarExact("cast(INTERVAL '5' day as integer)", "INTEGER NOT NULL", "5");
        f.checkScalarExact("cast(INTERVAL '1' year as integer)", "INTEGER NOT NULL", "1");
        f.checkScalarExact("cast((INTERVAL '1' year - INTERVAL '2' year) as integer)", "INTEGER NOT NULL", "-1");
        f.checkScalarExact("cast(INTERVAL '1' month as integer)", "INTEGER NOT NULL", "1");
        f.checkScalarExact("cast((INTERVAL '1' month - INTERVAL '2' month) as integer)", "INTEGER NOT NULL", "-1");
        f.checkScalarExact("cast(INTERVAL '1' day as integer)", "INTEGER NOT NULL", "1");
        f.checkScalarExact("cast((INTERVAL '1' day - INTERVAL '2' day) as integer)", "INTEGER NOT NULL", "-1");
        f.checkScalarExact("cast(INTERVAL '1' hour as integer)", "INTEGER NOT NULL", "1");
        f.checkScalarExact("cast((INTERVAL '1' hour - INTERVAL '2' hour) as integer)", "INTEGER NOT NULL", "-1");
        f.checkScalarExact("cast(INTERVAL '1' hour as integer)", "INTEGER NOT NULL", "1");
        f.checkScalarExact("cast((INTERVAL '1' minute - INTERVAL '2' minute) as integer)", "INTEGER NOT NULL", "-1");
        f.checkScalarExact("cast(INTERVAL '1' minute as integer)", "INTEGER NOT NULL", "1");
        f.checkScalarExact("cast((INTERVAL '1' second - INTERVAL '2' second) as integer)", "INTEGER NOT NULL", "-1");
    }

    @Test
    void testCastToInterval() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CAST, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalar("cast(5 as interval second)", "+5.000000", "INTERVAL SECOND NOT NULL");
        f.checkScalar("cast(5 as interval minute)", "+5", "INTERVAL MINUTE NOT NULL");
        f.checkScalar("cast(5 as interval hour)", "+5", "INTERVAL HOUR NOT NULL");
        f.checkScalar("cast(5 as interval day)", "+5", "INTERVAL DAY NOT NULL");
        f.checkScalar("cast(5 as interval month)", "+5", "INTERVAL MONTH NOT NULL");
        f.checkScalar("cast(5 as interval year)", "+5", "INTERVAL YEAR NOT NULL");
        f.checkScalar("cast(6.2 as interval day)", "+6", "INTERVAL DAY NOT NULL");
        f.checkScalar("cast(3456 as interval month(4))", "+3456", "INTERVAL MONTH(4) NOT NULL");
        f.checkScalar("cast(-5723 as interval minute(4))", "-5723", "INTERVAL MINUTE(4) NOT NULL");
    }

    @Test
    void testCastIntervalToInterval() {
        SqlOperatorFixture f = this.fixture();
        f.checkScalar("cast(interval '2 5' day to hour as interval hour to minute)", "+53:00", "INTERVAL HOUR TO MINUTE NOT NULL");
        f.checkScalar("cast(interval '2 5' day to hour as interval day to minute)", "+2 05:00", "INTERVAL DAY TO MINUTE NOT NULL");
        f.checkScalar("cast(interval '2 5' day to hour as interval hour to second)", "+53:00:00.000000", "INTERVAL HOUR TO SECOND NOT NULL");
        f.checkScalar("cast(interval '2 5' day to hour as interval hour)", "+53", "INTERVAL HOUR NOT NULL");
        f.checkScalar("cast(interval '-29:15' hour to minute as interval day to hour)", "-1 05", "INTERVAL DAY TO HOUR NOT NULL");
    }

    @Test
    void testCastWithRoundingToScalar() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CAST, SqlOperatorFixture.VmName.EXPAND);
        f.checkFails("cast(1.25 as int)", "INTEGER", true);
        f.checkFails("cast(1.25E0 as int)", "INTEGER", true);
        if (!f.brokenTestsEnabled()) {
            return;
        }
        f.checkFails("cast(1.5 as int)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
        f.checkFails("cast(5E-1 as int)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
        f.checkFails("cast(1.75 as int)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
        f.checkFails("cast(1.75E0 as int)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
        f.checkFails("cast(-1.25 as int)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
        f.checkFails("cast(-1.25E0 as int)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
        f.checkFails("cast(-1.5 as int)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
        f.checkFails("cast(-5E-1 as int)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
        f.checkFails("cast(-1.75 as int)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
        f.checkFails("cast(-1.75E0 as int)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
        f.checkFails("cast(1.23454 as int)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
        f.checkFails("cast(1.23454E0 as int)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
        f.checkFails("cast(1.23455 as int)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
        f.checkFails("cast(5E-5 as int)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
        f.checkFails("cast(1.99995 as int)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
        f.checkFails("cast(1.99995E0 as int)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
        f.checkFails("cast(-1.23454 as int)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
        f.checkFails("cast(-1.23454E0 as int)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
        f.checkFails("cast(-1.23455 as int)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
        f.checkFails("cast(-5E-5 as int)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
        f.checkFails("cast(-1.99995 as int)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
        f.checkFails("cast(-1.99995E0 as int)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
        f.checkFails("cast(9.99 as decimal(2,1))", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
    }

    @Test
    void testCastDecimalToDoubleToInteger() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CAST, SqlOperatorFixture.VmName.EXPAND);
        f.checkFails("cast( cast(1.25 as double) as integer)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
        f.checkFails("cast( cast(-1.25 as double) as integer)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
        if (!f.brokenTestsEnabled()) {
            return;
        }
        f.checkFails("cast( cast(1.75 as double) as integer)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
        f.checkFails("cast( cast(-1.75 as double) as integer)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
        f.checkFails("cast( cast(1.5 as double) as integer)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
        f.checkFails("cast( cast(-1.5 as double) as integer)", SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
    }

    @Test
    void testCastApproxNumericLimits() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CAST, SqlOperatorFixture.VmName.EXPAND);
        Numeric.forEach(numeric -> {
            boolean isFloat;
            String type = ((Numeric)numeric).typeName;
            switch (numeric) {
                case DOUBLE: 
                case FLOAT: {
                    isFloat = false;
                    break;
                }
                case REAL: {
                    isFloat = true;
                    break;
                }
                default: {
                    return;
                }
            }
            if (!f.brokenTestsEnabled()) {
                return;
            }
            f.checkCastToApproxOkay(((Numeric)numeric).maxNumericString, type, isFloat ? ResultCheckers.isWithin(numeric.maxNumericAsDouble(), 1.0E32) : ResultCheckers.isExactly(numeric.maxNumericAsDouble()));
            f.checkCastToApproxOkay(((Numeric)numeric).minNumericString, type, ResultCheckers.isExactly(((Numeric)numeric).minNumericString));
            if (isFloat) {
                f.checkCastFails(((Numeric)numeric).maxOverflowNumericString, type, SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
            } else {
                f.checkCastFails(((Numeric)numeric).maxOverflowNumericString, type, "(?s).*Numeric literal.*out of range.*", false);
            }
            f.checkCastToApproxOkay(((Numeric)numeric).minOverflowNumericString, type, ResultCheckers.isExactly(0.0));
            f.checkCastToApproxOkay("'" + ((Numeric)numeric).maxNumericString + "'", type, isFloat ? ResultCheckers.isWithin(numeric.maxNumericAsDouble(), 1.0E32) : ResultCheckers.isExactly(numeric.maxNumericAsDouble()));
            f.checkCastToApproxOkay("'" + ((Numeric)numeric).minNumericString + "'", type, ResultCheckers.isExactly(numeric.minNumericAsDouble()));
            f.checkCastFails("'" + ((Numeric)numeric).maxOverflowNumericString + "'", type, SqlOperatorFixture.OUT_OF_RANGE_MESSAGE, true);
            f.checkCastToApproxOkay("'" + ((Numeric)numeric).minOverflowNumericString + "'", type, ResultCheckers.isExactly(0.0));
            f.checkCastToString(((Numeric)numeric).maxNumericString, null, isFloat ? null : "1.79769313486231E308");
            f.checkCastFails("'notnumeric'", type, SqlOperatorFixture.INVALID_CHAR_MESSAGE, true);
        });
    }

    @Test
    void testCastToApproxNumeric() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CAST, SqlOperatorFixture.VmName.EXPAND);
        f.checkCastToApproxOkay("1", "DOUBLE", ResultCheckers.isExactly(1.0));
        f.checkCastToApproxOkay("1.0", "DOUBLE", ResultCheckers.isExactly(1.0));
        f.checkCastToApproxOkay("-2.3", "FLOAT", ResultCheckers.isWithin(-2.3, 1.0E-6));
        f.checkCastToApproxOkay("'1'", "DOUBLE", ResultCheckers.isExactly(1.0));
        f.checkCastToApproxOkay("'  -1e-37  '", "DOUBLE", ResultCheckers.isExactly("-1.0E-37"));
        f.checkCastToApproxOkay("1e0", "DOUBLE", ResultCheckers.isExactly(1.0));
        f.checkCastToApproxOkay("0e0", "REAL", ResultCheckers.isExactly(0.0));
    }

    @Test
    void testCastNull() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CAST, SqlOperatorFixture.VmName.EXPAND);
        f.checkNull("cast(null as integer)");
        f.checkNull("cast(null as double)");
        f.checkNull("cast(null as varchar(10))");
        f.checkNull("cast(null as char(10))");
        f.checkNull("cast(null as date)");
        f.checkNull("cast(null as time)");
        f.checkNull("cast(null as timestamp)");
        f.checkNull("cast(null as interval year to month)");
        f.checkNull("cast(null as interval day to second(3))");
        f.checkNull("cast(null as boolean)");
    }

    @Test
    void testCastInvalid() {
        SqlOperatorFixture f = this.fixture();
        f.checkScalarExact("cast('15' as integer)", "INTEGER NOT NULL", "15");
    }

    @Test
    void testCastDateTime() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CAST, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalar("cast(TIMESTAMP '1945-02-24 12:42:25.34' as TIMESTAMP)", "1945-02-24 12:42:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("cast(TIME '12:42:25.34' as TIME)", "12:42:25", "TIME(0) NOT NULL");
        if (f.brokenTestsEnabled()) {
            f.checkScalar("cast(TIME '12:42:25.9' as TIME)", "12:42:26", "TIME(0) NOT NULL");
        }
        f.checkScalar("cast(DATE '1945-02-24' as DATE)", "1945-02-24", "DATE NOT NULL");
        f.checkScalar("cast(TIMESTAMP '1945-02-24 12:42:25.34' as TIME)", "12:42:25", "TIME(0) NOT NULL");
        f.checkCastToString("TIME '12:42:25'", null, "12:42:25");
        String today = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT).format(SqlOperatorTest.getCalendarNotTooNear(5).getTime());
        f.checkScalar("cast(DATE '1945-02-24' as TIMESTAMP)", "1945-02-24 00:00:00", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("cast(cast(TIMESTAMP '1945-02-24 12:42:25.34' as TIME) as TIMESTAMP)", today + " 12:42:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("cast(TIME '12:42:25.34' as TIMESTAMP)", today + " 12:42:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("cast(TIMESTAMP '1945-02-24 12:42:25.34' as DATE)", "1945-02-24", "DATE NOT NULL");
        f.checkScalar("cast(cast(TIMESTAMP '1945-02-24 12:42:25.34' as DATE) as TIMESTAMP)", "1945-02-24 00:00:00", "TIMESTAMP(0) NOT NULL");
    }

    @Test
    void testCastStringToDateTime() {
        SqlOperatorFixture f = this.fixture();
        f.checkScalar("cast('12:42:25' as TIME)", "12:42:25", "TIME(0) NOT NULL");
        f.checkScalar("cast('1:42:25' as TIME)", "01:42:25", "TIME(0) NOT NULL");
        f.checkScalar("cast('1:2:25' as TIME)", "01:02:25", "TIME(0) NOT NULL");
        f.checkScalar("cast('  12:42:25  ' as TIME)", "12:42:25", "TIME(0) NOT NULL");
        f.checkScalar("cast('12:42:25.34' as TIME)", "12:42:25", "TIME(0) NOT NULL");
        f.checkFails("cast('nottime' as TIME)", SqlOperatorFixture.BAD_DATETIME_MESSAGE, true);
        f.checkCastToString("TIMESTAMP '1945-02-24 12:42:25'", null, "1945-02-24 12:42:25");
        f.checkScalar("cast('1945-02-24 12:42:25' as TIMESTAMP)", "1945-02-24 12:42:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("cast('1945-2-2 12:2:5' as TIMESTAMP)", "1945-02-02 12:02:05", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("cast('  1945-02-24 12:42:25  ' as TIMESTAMP)", "1945-02-24 12:42:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("cast('1945-02-24 12:42:25.34' as TIMESTAMP)", "1945-02-24 12:42:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("cast('1945-12-31' as TIMESTAMP)", "1945-12-31 00:00:00", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("cast('2004-02-29' as TIMESTAMP)", "2004-02-29 00:00:00", "TIMESTAMP(0) NOT NULL");
        f.checkFails("cast('nottime' as TIMESTAMP)", SqlOperatorFixture.BAD_DATETIME_MESSAGE, true);
        f.checkCastToString("DATE '1945-02-24'", null, "1945-02-24");
        f.checkCastToString("DATE '1945-2-24'", null, "1945-02-24");
        f.checkScalar("cast('1945-02-24' as DATE)", "1945-02-24", "DATE NOT NULL");
        f.checkScalar("cast(' 1945-2-4 ' as DATE)", "1945-02-04", "DATE NOT NULL");
        f.checkScalar("cast('  1945-02-24  ' as DATE)", "1945-02-24", "DATE NOT NULL");
        f.checkFails("cast('notdate' as DATE)", SqlOperatorFixture.BAD_DATETIME_MESSAGE, true);
        f.checkNull("cast(null as date)");
        f.checkNull("cast(null as timestamp)");
        f.checkNull("cast(null as time)");
        f.checkNull("cast(cast(null as varchar(10)) as time)");
        f.checkNull("cast(cast(null as varchar(10)) as date)");
        f.checkNull("cast(cast(null as varchar(10)) as timestamp)");
        f.checkNull("cast(cast(null as date) as timestamp)");
        f.checkNull("cast(cast(null as time) as timestamp)");
        f.checkNull("cast(cast(null as timestamp) as date)");
        f.checkNull("cast(cast(null as timestamp) as time)");
    }

    private static Calendar getFixedCalendar() {
        Calendar calendar = Util.calendar();
        calendar.set(1, 2014);
        calendar.set(2, 8);
        calendar.set(5, 7);
        calendar.set(11, 17);
        calendar.set(12, 8);
        calendar.set(13, 48);
        calendar.set(14, 15);
        return calendar;
    }

    /*
     * Exception decompiling
     */
    protected static Calendar getCalendarNotTooNear(int timeUnit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    void testCastToBoolean() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CAST, SqlOperatorFixture.VmName.EXPAND);
        f.checkBoolean("cast('true' as boolean)", true);
        f.checkBoolean("cast('false' as boolean)", false);
        f.checkBoolean("cast('  trUe' as boolean)", true);
        f.checkBoolean("cast('  tr' || 'Ue' as boolean)", true);
        f.checkBoolean("cast('  fALse' as boolean)", false);
        f.checkFails("cast('unknown' as boolean)", SqlOperatorFixture.INVALID_CHAR_MESSAGE, true);
        f.checkBoolean("cast(cast('true' as varchar(10))  as boolean)", true);
        f.checkBoolean("cast(cast('false' as varchar(10)) as boolean)", false);
        f.checkFails("cast(cast('blah' as varchar(10)) as boolean)", SqlOperatorFixture.INVALID_CHAR_MESSAGE, true);
    }

    @Test
    void testChainedCast() {
        SqlOperatorFixture f = this.fixture();
        f.checkFails("CAST(CAST(CAST(123456 AS TINYINT) AS INT) AS BIGINT)", "Value out of range. Value:\"123456\"", true);
    }

    @Test
    void testCase() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CASE, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalarExact("case when 'a'='a' then 1 end", 1);
        f.checkString("case 2 when 1 then 'a' when 2 then 'bcd' end", "bcd", "CHAR(3)");
        f.checkString("case 1 when 1 then 'a' when 2 then 'bcd' end", "a  ", "CHAR(3)");
        f.checkString("case 1 when 1 then cast('a' as varchar(1)) when 2 then cast('bcd' as varchar(3)) end", "a", "VARCHAR(3)");
        f.checkScalarExact("case 'a' when 'a' then 1 end", 1);
        f.checkScalarApprox("case 1 when 1 then 11.2e0 when 2 then cast(4 as bigint) else 3 end", "DOUBLE NOT NULL", ResultCheckers.isExactly("11.2"));
        f.checkScalarApprox("case 1 when 1 then 11.2e0 when 2 then 4 else null end", "DOUBLE", ResultCheckers.isExactly("11.2"));
        f.checkScalarApprox("case 2 when 1 then 11.2e0 when 2 then 4 else null end", "DOUBLE", ResultCheckers.isExactly(4.0));
        f.checkScalarApprox("case 1 when 1 then 11.2e0 when 2 then 4.543 else null end", "DOUBLE", ResultCheckers.isExactly("11.2"));
        f.checkScalarApprox("case 2 when 1 then 11.2e0 when 2 then 4.543 else null end", "DOUBLE", ResultCheckers.isExactly("4.543"));
        f.checkNull("case 'a' when 'b' then 1 end");
        f.checkString("case cast(null as int)\nwhen cast(null as int) then 'nulls match'\nelse 'nulls do not match' end", "nulls do not match", "CHAR(18) NOT NULL");
        f.checkScalarExact("case when 'a'=cast(null as varchar(1)) then 1 else 2 end", 2);
        f.checkString("case when 'a' = cast(null as varchar(1)) then null else 'a' end", "a", "CHAR(1)");
        f.checkString("case 1 when 1, 2 then '1 or 2' when 2 then 'not possible' when 3, 2 then '3' else 'none of the above' end", "1 or 2           ", "CHAR(17) NOT NULL");
        f.checkString("case 2 when 1, 2 then '1 or 2' when 2 then 'not possible' when 3, 2 then '3' else 'none of the above' end", "1 or 2           ", "CHAR(17) NOT NULL");
        f.checkString("case 3 when 1, 2 then '1 or 2' when 2 then 'not possible' when 3, 2 then '3' else 'none of the above' end", "3                ", "CHAR(17) NOT NULL");
        f.checkString("case 4 when 1, 2 then '1 or 2' when 2 then 'not possible' when 3, 2 then '3' else 'none of the above' end", "none of the above", "CHAR(17) NOT NULL");
        SqlOperatorFixture f2 = f.withConformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003);
        f2.checkString("case 2 when 1 then 'a' when 2 then 'bcd' end", "bcd", "VARCHAR(3)");
        f2.checkString("case 1 when 1 then 'a' when 2 then 'bcd' end", "a", "VARCHAR(3)");
        f2.checkString("case 1 when 1 then cast('a' as varchar(1)) when 2 then cast('bcd' as varchar(3)) end", "a", "VARCHAR(3)");
        f2.checkString("case cast(null as int) when cast(null as int) then 'nulls match' else 'nulls do not match' end", "nulls do not match", "VARCHAR(18) NOT NULL");
        f2.checkScalarExact("case when 'a'=cast(null as varchar(1)) then 1 else 2 end", 2);
        f2.checkString("case when 'a' = cast(null as varchar(1)) then null else 'a' end", "a", "CHAR(1)");
        f2.checkString("case 1 when 1, 2 then '1 or 2' when 2 then 'not possible' when 3, 2 then '3' else 'none of the above' end", "1 or 2", "VARCHAR(17) NOT NULL");
        f2.checkString("case 2 when 1, 2 then '1 or 2' when 2 then 'not possible' when 3, 2 then '3' else 'none of the above' end", "1 or 2", "VARCHAR(17) NOT NULL");
        f2.checkString("case 3 when 1, 2 then '1 or 2' when 2 then 'not possible' when 3, 2 then '3' else 'none of the above' end", "3", "VARCHAR(17) NOT NULL");
        f2.checkString("case 4 when 1, 2 then '1 or 2' when 2 then 'not possible' when 3, 2 then '3' else 'none of the above' end", "none of the above", "VARCHAR(17) NOT NULL");
    }

    @Test
    void testCaseNull() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CASE, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalarExact("case when 1 = 1 then 10 else null end", 10);
        f.checkNull("case when 1 = 2 then 10 else null end");
    }

    @Test
    void testCaseType() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CASE, SqlOperatorFixture.VmName.EXPAND);
        f.checkType("case 1 when 1 then current_timestamp else null end", "TIMESTAMP(0)");
        f.checkType("case 1 when 1 then current_timestamp else current_timestamp end", "TIMESTAMP(0) NOT NULL");
        f.checkType("case when true then current_timestamp else null end", "TIMESTAMP(0)");
        f.checkType("case when true then current_timestamp end", "TIMESTAMP(0)");
        f.checkType("case 'x' when 'a' then 3 when 'b' then null else 4.5 end", "DECIMAL(11, 1)");
    }

    @Test
    void testJdbcFn() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)new SqlJdbcFunctionCall("dummy"), SqlOperatorFixture.VmName.EXPAND);
        f.checkScalar("{fn ABS(-3)}", 3, "INTEGER NOT NULL");
        f.checkScalarApprox("{fn ACOS(0.2)}", "DOUBLE NOT NULL", ResultCheckers.isWithin(1.36943, 0.001));
        f.checkScalarApprox("{fn ASIN(0.2)}", "DOUBLE NOT NULL", ResultCheckers.isWithin(0.20135, 0.001));
        f.checkScalarApprox("{fn ATAN(0.2)}", "DOUBLE NOT NULL", ResultCheckers.isWithin(0.19739, 0.001));
        f.checkScalarApprox("{fn ATAN2(-2, 2)}", "DOUBLE NOT NULL", ResultCheckers.isWithin(-0.78539, 0.001));
        f.checkScalar("{fn CBRT(8)}", 2.0, "DOUBLE NOT NULL");
        f.checkScalar("{fn CEILING(-2.6)}", -2, "DECIMAL(2, 0) NOT NULL");
        f.checkScalarApprox("{fn COS(0.2)}", "DOUBLE NOT NULL", ResultCheckers.isWithin(0.98007, 0.001));
        f.checkScalarApprox("{fn COT(0.2)}", "DOUBLE NOT NULL", ResultCheckers.isWithin(4.93315, 0.001));
        f.checkScalarApprox("{fn DEGREES(-1)}", "DOUBLE NOT NULL", ResultCheckers.isWithin(-57.29578, 0.001));
        f.checkScalarApprox("{fn EXP(2)}", "DOUBLE NOT NULL", ResultCheckers.isWithin(7.389, 0.001));
        f.checkScalar("{fn FLOOR(2.6)}", 2, "DECIMAL(2, 0) NOT NULL");
        f.checkScalarApprox("{fn LOG(10)}", "DOUBLE NOT NULL", ResultCheckers.isWithin(2.30258, 0.001));
        f.checkScalarApprox("{fn LOG10(100)}", "DOUBLE NOT NULL", ResultCheckers.isExactly(2.0));
        f.checkScalar("{fn MOD(19, 4)}", 3, "INTEGER NOT NULL");
        f.checkScalarApprox("{fn PI()}", "DOUBLE NOT NULL", ResultCheckers.isWithin(3.14159, 1.0E-4));
        f.checkScalarApprox("{fn POWER(2, 3)}", "DOUBLE NOT NULL", ResultCheckers.isWithin(8.0, 0.001));
        f.checkScalarApprox("{fn RADIANS(90)}", "DOUBLE NOT NULL", ResultCheckers.isWithin(1.5708, 0.001));
        f.checkScalarApprox("{fn RAND(42)}", "DOUBLE NOT NULL", ResultCheckers.isWithin(0.63708, 0.001));
        f.checkScalar("{fn ROUND(1251, -2)}", 1300, "INTEGER NOT NULL");
        f.checkFails("^{fn ROUND(1251)}^", "Cannot apply '\\{fn ROUND\\}' to arguments of type '\\{fn ROUND\\}\\(<INTEGER>\\)'.*", false);
        f.checkScalar("{fn SIGN(-1)}", -1, "INTEGER NOT NULL");
        f.checkScalarApprox("{fn SIN(0.2)}", "DOUBLE NOT NULL", ResultCheckers.isWithin(0.19867, 0.001));
        f.checkScalarApprox("{fn SQRT(4.2)}", "DOUBLE NOT NULL", ResultCheckers.isWithin(2.04939, 0.001));
        f.checkScalarApprox("{fn TAN(0.2)}", "DOUBLE NOT NULL", ResultCheckers.isWithin(0.20271, 0.001));
        f.checkScalar("{fn TRUNCATE(12.34, 1)}", 12.3, "DECIMAL(4, 2) NOT NULL");
        f.checkScalar("{fn TRUNCATE(-12.34, -1)}", -10, "DECIMAL(4, 2) NOT NULL");
        f.checkScalar("{fn ASCII('a')}", 97, "INTEGER NOT NULL");
        f.checkScalar("{fn ASCII('ABC')}", "65", "INTEGER NOT NULL");
        f.checkNull("{fn ASCII(cast(null as varchar(1)))}");
        f.checkScalar("{fn CHAR(97)}", "a", "CHAR(1)");
        f.checkScalar("{fn CONCAT('foo', 'bar')}", "foobar", "CHAR(6) NOT NULL");
        f.checkScalar("{fn DIFFERENCE('Miller', 'miller')}", "4", "INTEGER NOT NULL");
        f.checkNull("{fn DIFFERENCE('muller', cast(null as varchar(1)))}");
        f.checkString("{fn REVERSE('abc')}", "cba", "VARCHAR(3) NOT NULL");
        f.checkNull("{fn REVERSE(cast(null as varchar(1)))}");
        f.checkString("{fn LEFT('abcd', 3)}", "abc", "VARCHAR(4) NOT NULL");
        f.checkString("{fn LEFT('abcd', 4)}", "abcd", "VARCHAR(4) NOT NULL");
        f.checkString("{fn LEFT('abcd', 5)}", "abcd", "VARCHAR(4) NOT NULL");
        f.checkNull("{fn LEFT(cast(null as varchar(1)), 3)}");
        f.checkString("{fn RIGHT('abcd', 3)}", "bcd", "VARCHAR(4) NOT NULL");
        f.checkString("{fn RIGHT('abcd', 4)}", "abcd", "VARCHAR(4) NOT NULL");
        f.checkString("{fn RIGHT('abcd', 5)}", "abcd", "VARCHAR(4) NOT NULL");
        f.checkNull("{fn RIGHT(cast(null as varchar(1)), 3)}");
        f.checkScalar("{fn INSERT('abc', 1, 2, 'ABCdef')}", "ABCdefc", "VARCHAR(9) NOT NULL");
        f.checkScalar("{fn LCASE('foo' || 'bar')}", "foobar", "CHAR(6) NOT NULL");
        f.checkScalar("{fn LOCATE('ha', 'alphabet')}", 4, "INTEGER NOT NULL");
        f.checkScalar("{fn LOCATE('ha', 'alphabet', 6)}", 0, "INTEGER NOT NULL");
        f.checkScalar("{fn LTRIM(' xxx  ')}", "xxx  ", "VARCHAR(6) NOT NULL");
        f.checkScalar("{fn REPEAT('a', -100)}", "", "VARCHAR(1) NOT NULL");
        f.checkNull("{fn REPEAT('abc', cast(null as integer))}");
        f.checkNull("{fn REPEAT(cast(null as varchar(1)), cast(null as integer))}");
        f.checkString("{fn REPLACE('JACK and JUE','J','BL')}", "BLACK and BLUE", "VARCHAR(12) NOT NULL");
        f.checkString("{fn REPLACE('ciao', 'ciao', '')}", "", "VARCHAR(4) NOT NULL");
        f.checkString("{fn REPLACE('hello world', 'o', '')}", "hell wrld", "VARCHAR(11) NOT NULL");
        f.checkNull("{fn REPLACE(cast(null as varchar(5)), 'ciao', '')}");
        f.checkNull("{fn REPLACE('ciao', cast(null as varchar(3)), 'zz')}");
        f.checkNull("{fn REPLACE('ciao', 'bella', cast(null as varchar(3)))}");
        f.checkScalar("{fn RTRIM(' xxx  ')}", " xxx", "VARCHAR(6) NOT NULL");
        f.checkScalar("{fn SOUNDEX('Miller')}", "M460", "VARCHAR(4) NOT NULL");
        f.checkNull("{fn SOUNDEX(cast(null as varchar(1)))}");
        f.checkScalar("{fn SPACE(-100)}", "", "VARCHAR(2000) NOT NULL");
        f.checkNull("{fn SPACE(cast(null as integer))}");
        f.checkScalar("{fn SUBSTRING('abcdef', 2, 3)}", "bcd", "VARCHAR(6) NOT NULL");
        f.checkScalar("{fn UCASE('xxx')}", "XXX", "CHAR(3) NOT NULL");
        f.checkType("{fn CURDATE()}", "DATE NOT NULL");
        f.checkType("{fn CURTIME()}", "TIME(0) NOT NULL");
        f.checkScalar("{fn DAYNAME(DATE '2014-12-10')}", TestUtil.getJavaMajorVersion() <= 8 ? "Wednesday" : "Wed", "VARCHAR(2000) NOT NULL");
        f.checkScalar("{fn DAYOFMONTH(DATE '2014-12-10')}", 10, "BIGINT NOT NULL");
        f.checkScalar("{fn HOUR(TIMESTAMP '2014-12-10 12:34:56')}", 12, "BIGINT NOT NULL");
        f.checkScalar("{fn MINUTE(TIMESTAMP '2014-12-10 12:34:56')}", 34, "BIGINT NOT NULL");
        f.checkScalar("{fn MONTH(DATE '2014-12-10')}", 12, "BIGINT NOT NULL");
        f.checkScalar("{fn MONTHNAME(DATE '2014-12-10')}", TestUtil.getJavaMajorVersion() <= 8 ? "December" : "Dec", "VARCHAR(2000) NOT NULL");
        f.checkType("{fn NOW()}", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("{fn QUARTER(DATE '2014-12-10')}", "4", "BIGINT NOT NULL");
        f.checkScalar("{fn SECOND(TIMESTAMP '2014-12-10 12:34:56')}", 56, "BIGINT NOT NULL");
        f.checkScalar("{fn TIMESTAMPADD(HOUR, 5, TIMESTAMP '2014-03-29 12:34:56')}", "2014-03-29 17:34:56", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("{fn TIMESTAMPDIFF(HOUR, TIMESTAMP '2014-03-29 12:34:56', TIMESTAMP '2014-03-29 12:34:56')}", "0", "INTEGER NOT NULL");
        f.checkScalar("{fn TIMESTAMPDIFF(MONTH, TIMESTAMP '2019-09-01 00:00:00', TIMESTAMP '2020-03-01 00:00:00')}", "6", "INTEGER NOT NULL");
        f.checkScalar("{fn YEAR(DATE '2014-12-10')}", 2014, "BIGINT NOT NULL");
        f.checkType("{fn DATABASE()}", "VARCHAR(2000) NOT NULL");
        f.checkString("{fn IFNULL('a', 'b')}", "a", "CHAR(1) NOT NULL");
        f.checkString("{fn USER()}", "sa", "VARCHAR(2000) NOT NULL");
        f.checkScalar("{fn CONVERT('123', INTEGER)}", 123, "INTEGER NOT NULL");
        f.checkScalar("{fn CONVERT('123', SQL_INTEGER)}", 123, "INTEGER NOT NULL");
        f.checkScalar("{fn CONVERT(INTERVAL '1' DAY, SQL_INTERVAL_DAY_TO_SECOND)}", "+1 00:00:00.000000", "INTERVAL DAY TO SECOND NOT NULL");
    }

    @Test
    void testChar() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlLibraryOperators.CHR, VM_FENNEL, VM_JAVA);
        f0.checkFails("^char(97)^", "No match found for function signature CHAR\\(<NUMERIC>\\)", false);
        SqlOperatorFixture f = f0.withLibrary(SqlLibrary.MYSQL);
        f.checkScalar("char(null)", ResultCheckers.isNullValue(), "CHAR(1)");
        f.checkScalar("char(-1)", ResultCheckers.isNullValue(), "CHAR(1)");
        f.checkScalar("char(97)", "a", "CHAR(1)");
        f.checkScalar("char(48)", "0", "CHAR(1)");
        f.checkScalar("char(0)", String.valueOf('\u0000'), "CHAR(1)");
        f.checkFails("^char(97.1)^", "Cannot apply 'CHAR' to arguments of type 'CHAR\\(<DECIMAL\\(3, 1\\)>\\)'\\. Supported form\\(s\\): 'CHAR\\(<INTEGER>\\)'", false);
    }

    @Test
    void testChr() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlLibraryOperators.CHR, VM_FENNEL, VM_JAVA);
        SqlOperatorFixture f = f0.withLibrary(SqlLibrary.ORACLE);
        f.checkScalar("chr(97)", "a", "CHAR(1) NOT NULL");
        f.checkScalar("chr(48)", "0", "CHAR(1) NOT NULL");
        f.checkScalar("chr(0)", String.valueOf('\u0000'), "CHAR(1) NOT NULL");
        f0.checkFails("^chr(97.1)^", "No match found for function signature CHR\\(<NUMERIC>\\)", false);
    }

    @Test
    void testSelect() {
        SqlOperatorFixture f = this.fixture();
        f.check("select * from (values(1))", SqlTests.INTEGER_TYPE_CHECKER, (Object)1);
    }

    @Test
    void testLiteralChain() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.LITERAL_CHAIN, VM_EXPAND);
        f.checkString("'buttered'\n' toast'", "buttered toast", "CHAR(14) NOT NULL");
        f.checkString("'corned'\n' beef'\n' on'\n' rye'", "corned beef on rye", "CHAR(18) NOT NULL");
        f.checkString("_latin1'Spaghetti'\n' all''Amatriciana'", "Spaghetti all'Amatriciana", "CHAR(25) NOT NULL");
        f.checkBoolean("x'1234'\n'abcd' = x'1234abcd'", true);
        f.checkBoolean("x'1234'\n'' = x'1234'", true);
        f.checkBoolean("x''\n'ab' = x'ab'", true);
    }

    @Test
    void testComplexLiteral() {
        SqlOperatorFixture f = this.fixture();
        f.check("select 2 * 2 * x from (select 2 as x)", SqlTests.INTEGER_TYPE_CHECKER, (Object)8);
        f.check("select 1 * 2 * 3 * x from (select 2 as x)", SqlTests.INTEGER_TYPE_CHECKER, (Object)12);
        f.check("select 1 + 2 + 3 + 4 + x from (select 2 as x)", SqlTests.INTEGER_TYPE_CHECKER, (Object)12);
    }

    @Test
    void testRow() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.ROW, VM_FENNEL);
    }

    @Test
    void testAndOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.AND, SqlOperatorFixture.VmName.EXPAND);
        f.checkBoolean("true and false", false);
        f.checkBoolean("true and true", true);
        f.checkBoolean("cast(null as boolean) and false", false);
        f.checkBoolean("false and cast(null as boolean)", false);
        f.checkNull("cast(null as boolean) and true");
        f.checkBoolean("true and (not false)", true);
    }

    @Test
    void testAndOperator2() {
        SqlOperatorFixture f = this.fixture();
        f.checkBoolean("case when false then unknown else true end and true", true);
        f.checkBoolean("case when false then cast(null as boolean) else true end and true", true);
        f.checkBoolean("case when false then null else true end and true", true);
    }

    @Test
    void testAndOperatorLazy() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.AND, SqlOperatorFixture.VmName.EXPAND);
        f.check("values 1 > 2 and sqrt(-4) = -2", SqlTests.BOOLEAN_TYPE_CHECKER, SqlTests.ANY_PARAMETER_CHECKER, new ValueOrExceptionResultChecker(false, INVALID_ARG_FOR_POWER, CODE_2201F));
    }

    @Test
    void testConcatOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CONCAT, SqlOperatorFixture.VmName.EXPAND);
        f.checkString(" 'a'||'b' ", "ab", "CHAR(2) NOT NULL");
        f.checkNull(" 'a' || cast(null as char(2)) ");
        f.checkNull(" cast(null as char(2)) || 'b' ");
        f.checkNull(" cast(null as char(1)) || cast(null as char(2)) ");
        f.checkString(" x'fe'||x'df' ", "fedf", "BINARY(2) NOT NULL");
        f.checkString(" cast('fe' as char(2)) || cast('df' as varchar)", "fedf", "VARCHAR NOT NULL");
        f.checkString(" cast('fe' as char(2)) || cast('df' as varchar(65535))", "fedf", "VARCHAR NOT NULL");
        f.checkString(" cast('fe' as char(2)) || cast('df' as varchar(33333))", "fedf", "VARCHAR(33335) NOT NULL");
        f.checkNull("x'ff' || cast(null as varbinary)");
        f.checkNull(" cast(null as ANY) || cast(null as ANY) ");
        f.checkString("cast('a' as varchar) || cast('b' as varchar) || cast('c' as varchar)", "abc", "VARCHAR NOT NULL");
        f.checkScalar("array[1, 2] || array[2, 3]", "[1, 2, 2, 3]", "INTEGER NOT NULL ARRAY NOT NULL");
        f.checkScalar("array[1, 2] || array[2, null]", "[1, 2, 2, null]", "INTEGER ARRAY NOT NULL");
        f.checkScalar("array['hello', 'world'] || array['!'] || array[cast(null as char)]", "[hello, world, !, null]", "CHAR(5) ARRAY NOT NULL");
        f.checkNull("cast(null as integer array) || array[1]");
    }

    @Test
    void testConcatFunc() {
        SqlOperatorFixture f = this.fixture();
        SqlOperatorTest.checkConcatFunc(f.withLibrary(SqlLibrary.MYSQL));
        SqlOperatorTest.checkConcatFunc(f.withLibrary(SqlLibrary.POSTGRESQL));
        SqlOperatorTest.checkConcatFunc(f.withLibrary(SqlLibrary.BIG_QUERY));
        SqlOperatorTest.checkConcat2Func(f.withLibrary(SqlLibrary.ORACLE));
    }

    private static void checkConcatFunc(SqlOperatorFixture f) {
        f.setFor((SqlOperator)SqlLibraryOperators.CONCAT_FUNCTION, new SqlOperatorFixture.VmName[0]);
        f.checkString("concat('a', 'b', 'c')", "abc", "VARCHAR(3) NOT NULL");
        f.checkString("concat(cast('a' as varchar), cast('b' as varchar), cast('c' as varchar))", "abc", "VARCHAR NOT NULL");
        f.checkNull("concat('a', 'b', cast(null as char(2)))");
        f.checkNull("concat(cast(null as ANY), 'b', cast(null as char(2)))");
        f.checkString("concat('', '', 'a')", "a", "VARCHAR(1) NOT NULL");
        f.checkString("concat('', '', '')", "", "VARCHAR(0) NOT NULL");
        f.checkFails("^concat()^", "Invalid number of arguments to function .* Was expecting .* arguments", false);
    }

    private static void checkConcat2Func(SqlOperatorFixture f) {
        f.setFor((SqlOperator)SqlLibraryOperators.CONCAT2, new SqlOperatorFixture.VmName[0]);
        f.checkString("concat(cast('fe' as char(2)), cast('df' as varchar(65535)))", "fedf", "VARCHAR NOT NULL");
        f.checkString("concat(cast('fe' as char(2)), cast('df' as varchar))", "fedf", "VARCHAR NOT NULL");
        f.checkString("concat(cast('fe' as char(2)), cast('df' as varchar(33333)))", "fedf", "VARCHAR(33335) NOT NULL");
        f.checkString("concat('', '')", "", "VARCHAR(0) NOT NULL");
        f.checkString("concat('', 'a')", "a", "VARCHAR(1) NOT NULL");
        f.checkString("concat('a', 'b')", "ab", "VARCHAR(2) NOT NULL");
        f.checkNull("concat('a', cast(null as varchar))");
        f.checkFails("^concat('a', 'b', 'c')^", "Invalid number of arguments to function .* Was expecting .* arguments", false);
        f.checkFails("^concat('a')^", "Invalid number of arguments to function .* Was expecting .* arguments", false);
    }

    @Test
    void testModOperator() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlStdOperatorTable.PERCENT_REMAINDER, new SqlOperatorFixture.VmName[0]);
        Expressions.FluentList conformances = Expressions.list((Object[])new SqlConformanceEnum[]{SqlConformanceEnum.BIG_QUERY, SqlConformanceEnum.MYSQL_5});
        f0.forEachConformance((Iterable<? extends SqlConformanceEnum>)conformances, this::checkModOperator);
        f0.forEachConformance((Iterable<? extends SqlConformanceEnum>)conformances, this::checkModPrecedence);
        f0.forEachConformance((Iterable<? extends SqlConformanceEnum>)conformances, this::checkModOperatorNull);
        f0.forEachConformance((Iterable<? extends SqlConformanceEnum>)conformances, this::checkModOperatorDivByZero);
    }

    void checkModOperator(SqlOperatorFixture f) {
        f.checkScalarExact("4%2", 0);
        f.checkScalarExact("8%5", 3);
        f.checkScalarExact("-12%7", -5);
        f.checkScalarExact("-12%-7", -5);
        f.checkScalarExact("12%-7", 5);
        f.checkScalarExact("cast(12 as tinyint) % cast(-7 as tinyint)", "TINYINT NOT NULL", "5");
    }

    void checkModPrecedence(SqlOperatorFixture f) {
        f.checkScalarExact("1 + 5 % 3 % 4 * 14 % 17", 12);
        f.checkScalarExact("(1 + 5 % 3) % 4 + 14 % 17", 17);
    }

    void checkModOperatorNull(SqlOperatorFixture f) {
        f.checkNull("cast(null as integer) % 2");
        f.checkNull("4 % cast(null as tinyint)");
    }

    void checkModOperatorDivByZero(SqlOperatorFixture f) {
        f.checkFails("3 % case 'a' when 'a' then 0 end", SqlOperatorFixture.DIVISION_BY_ZERO_MESSAGE, true);
    }

    @Test
    void testDivideOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.DIVIDE, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalarExact("10 / 5", "INTEGER NOT NULL", "2");
        f.checkScalarExact("-10 / 5", "INTEGER NOT NULL", "-2");
        f.checkScalarExact("-10 / 5.0", "DECIMAL(17, 6) NOT NULL", "-2");
        f.checkScalarApprox(" cast(10.0 as double) / 5", "DOUBLE NOT NULL", ResultCheckers.isExactly(2.0));
        f.checkScalarApprox(" cast(10.0 as real) / 4", "REAL NOT NULL", ResultCheckers.isExactly("2.5"));
        f.checkScalarApprox(" 6.0 / cast(10.0 as real) ", "DOUBLE NOT NULL", ResultCheckers.isExactly("0.6"));
        f.checkScalarExact("10.0 / 5.0", "DECIMAL(9, 6) NOT NULL", "2");
        f.checkNull("1e1 / cast(null as float)");
    }

    @Test
    void testDivideOperatorIntervals() {
        SqlOperatorFixture f = this.fixture();
        f.checkScalar("interval '-2:2' hour to minute / 3", "-0:41", "INTERVAL HOUR TO MINUTE NOT NULL");
        f.checkScalar("interval '2:5:12' hour to second / 2 / -3", "-0:20:52.000000", "INTERVAL HOUR TO SECOND NOT NULL");
        f.checkNull("interval '2' day / cast(null as bigint)");
        f.checkNull("cast(null as interval month) / 2");
        f.checkScalar("interval '3-3' year to month / 15e-1", "+2-02", "INTERVAL YEAR TO MONTH NOT NULL");
        f.checkScalar("interval '3-4' year to month / 4.5", "+0-09", "INTERVAL YEAR TO MONTH NOT NULL");
    }

    @Test
    void testEqualsOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.EQUALS, SqlOperatorFixture.VmName.EXPAND);
        f.checkBoolean("1=1", true);
        f.checkBoolean("1=1.0", true);
        f.checkBoolean("1.34=1.34", true);
        f.checkBoolean("1=1.34", false);
        f.checkBoolean("1e2=100e0", true);
        f.checkBoolean("1e2=101", false);
        f.checkBoolean("cast(1e2 as real)=cast(101 as bigint)", false);
        f.checkBoolean("'a'='b'", false);
        f.checkBoolean("true = true", true);
        f.checkBoolean("true = false", false);
        f.checkBoolean("false = true", false);
        f.checkBoolean("false = false", true);
        f.checkBoolean("cast('a' as varchar(30))=cast('a' as varchar(30))", true);
        f.checkBoolean("cast('a ' as varchar(30))=cast('a' as varchar(30))", false);
        f.checkBoolean("cast(' a' as varchar(30))=cast(' a' as varchar(30))", true);
        f.checkBoolean("cast('a ' as varchar(15))=cast('a ' as varchar(30))", true);
        f.checkBoolean("cast(' ' as varchar(3))=cast(' ' as varchar(2))", true);
        f.checkBoolean("cast('abcd' as varchar(2))='ab'", true);
        f.checkBoolean("cast('a' as varchar(30))=cast('b' as varchar(30))", false);
        f.checkBoolean("cast('a' as varchar(30))=cast('a' as varchar(15))", true);
        f.checkNull("cast(null as boolean)=cast(null as boolean)");
        f.checkNull("cast(null as integer)=1");
        f.checkNull("cast(null as varchar(10))='a'");
    }

    @Test
    void testEqualsOperatorInterval() {
        SqlOperatorFixture f = this.fixture();
        f.checkBoolean("interval '2' day = interval '1' day", false);
        f.checkBoolean("interval '2' day = interval '2' day", true);
        f.checkBoolean("interval '2:2:2' hour to second = interval '2' hour", false);
        f.checkNull("cast(null as interval hour) = interval '2' minute");
    }

    @Test
    void testGreaterThanOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.GREATER_THAN, SqlOperatorFixture.VmName.EXPAND);
        f.checkBoolean("1>2", false);
        f.checkBoolean("cast(-1 as TINYINT)>cast(1 as TINYINT)", false);
        f.checkBoolean("cast(1 as SMALLINT)>cast(1 as SMALLINT)", false);
        f.checkBoolean("2>1", true);
        f.checkBoolean("1.1>1.2", false);
        f.checkBoolean("-1.1>-1.2", true);
        f.checkBoolean("1.1>1.1", false);
        f.checkBoolean("1.2>1", true);
        f.checkBoolean("1.1e1>1.2e1", false);
        f.checkBoolean("cast(-1.1 as real) > cast(-1.2 as real)", true);
        f.checkBoolean("1.1e2>1.1e2", false);
        f.checkBoolean("1.2e0>1", true);
        f.checkBoolean("cast(1.2e0 as real)>1", true);
        f.checkBoolean("true>false", true);
        f.checkBoolean("true>true", false);
        f.checkBoolean("false>false", false);
        f.checkBoolean("false>true", false);
        f.checkNull("3.0>cast(null as double)");
        f.checkBoolean("DATE '2013-02-23' > DATE '1945-02-24'", true);
        f.checkBoolean("DATE '2013-02-23' > CAST(NULL AS DATE)", null);
        f.checkBoolean("x'0A000130'>x'0A0001B0'", false);
    }

    @Test
    void testGreaterThanOperatorIntervals() {
        SqlOperatorFixture f = this.fixture();
        f.checkBoolean("interval '2' day > interval '1' day", true);
        f.checkBoolean("interval '2' day > interval '5' day", false);
        f.checkBoolean("interval '2 2:2:2' day to second > interval '2' day", true);
        f.checkBoolean("interval '2' day > interval '2' day", false);
        f.checkBoolean("interval '2' day > interval '-2' day", true);
        f.checkBoolean("interval '2' day > interval '2' hour", true);
        f.checkBoolean("interval '2' minute > interval '2' hour", false);
        f.checkBoolean("interval '2' second > interval '2' minute", false);
        f.checkNull("cast(null as interval hour) > interval '2' minute");
        f.checkNull("interval '2:2' hour to minute > cast(null as interval second)");
    }

    @Test
    void testIsDistinctFromOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.IS_DISTINCT_FROM, VM_EXPAND);
        f.checkBoolean("1 is distinct from 1", false);
        f.checkBoolean("1 is distinct from 1.0", false);
        f.checkBoolean("1 is distinct from 2", true);
        f.checkBoolean("cast(null as integer) is distinct from 2", true);
        f.checkBoolean("cast(null as integer) is distinct from cast(null as integer)", false);
        f.checkBoolean("1.23 is distinct from 1.23", false);
        f.checkBoolean("1.23 is distinct from 5.23", true);
        f.checkBoolean("-23e0 is distinct from -2.3e1", false);
        f.checkBoolean("interval '2' day is distinct from interval '1' day", true);
        f.checkBoolean("interval '10' hour is distinct from interval '10' hour", false);
    }

    @Test
    void testIsNotDistinctFromOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, VM_EXPAND);
        f.checkBoolean("1 is not distinct from 1", true);
        f.checkBoolean("1 is not distinct from 1.0", true);
        f.checkBoolean("1 is not distinct from 2", false);
        f.checkBoolean("cast(null as integer) is not distinct from 2", false);
        f.checkBoolean("cast(null as integer) is not distinct from cast(null as integer)", true);
        f.checkBoolean("1.23 is not distinct from 1.23", true);
        f.checkBoolean("1.23 is not distinct from 5.23", false);
        f.checkBoolean("-23e0 is not distinct from -2.3e1", true);
        f.checkBoolean("interval '2' day is not distinct from interval '1' day", false);
        f.checkBoolean("interval '10' hour is not distinct from interval '10' hour", true);
    }

    @Test
    void testGreaterThanOrEqualOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, SqlOperatorFixture.VmName.EXPAND);
        f.checkBoolean("1>=2", false);
        f.checkBoolean("-1>=1", false);
        f.checkBoolean("1>=1", true);
        f.checkBoolean("2>=1", true);
        f.checkBoolean("1.1>=1.2", false);
        f.checkBoolean("-1.1>=-1.2", true);
        f.checkBoolean("1.1>=1.1", true);
        f.checkBoolean("1.2>=1", true);
        f.checkBoolean("1.2e4>=1e5", false);
        f.checkBoolean("1.2e4>=cast(1e5 as real)", false);
        f.checkBoolean("1.2>=cast(1e5 as double)", false);
        f.checkBoolean("120000>=cast(1e5 as real)", true);
        f.checkBoolean("true>=false", true);
        f.checkBoolean("true>=true", true);
        f.checkBoolean("false>=false", true);
        f.checkBoolean("false>=true", false);
        f.checkNull("cast(null as real)>=999");
        f.checkBoolean("x'0A000130'>=x'0A0001B0'", false);
        f.checkBoolean("x'0A0001B0'>=x'0A0001B0'", true);
    }

    @Test
    void testGreaterThanOrEqualOperatorIntervals() {
        SqlOperatorFixture f = this.fixture();
        f.checkBoolean("interval '2' day >= interval '1' day", true);
        f.checkBoolean("interval '2' day >= interval '5' day", false);
        f.checkBoolean("interval '2 2:2:2' day to second >= interval '2' day", true);
        f.checkBoolean("interval '2' day >= interval '2' day", true);
        f.checkBoolean("interval '2' day >= interval '-2' day", true);
        f.checkBoolean("interval '2' day >= interval '2' hour", true);
        f.checkBoolean("interval '2' minute >= interval '2' hour", false);
        f.checkBoolean("interval '2' second >= interval '2' minute", false);
        f.checkNull("cast(null as interval hour) >= interval '2' minute");
        f.checkNull("interval '2:2' hour to minute >= cast(null as interval second)");
    }

    @Test
    void testInOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.IN, VM_EXPAND);
        f.checkBoolean("1 in (0, 1, 2)", true);
        f.checkBoolean("3 in (0, 1, 2)", false);
        f.checkBoolean("cast(null as integer) in (0, 1, 2)", null);
        f.checkBoolean("cast(null as integer) in (0, cast(null as integer), 2)", null);
        if (!f.brokenTestsEnabled()) {
            return;
        }
        f.checkBoolean("false and true in (false, false)", false);
    }

    @Test
    void testNotInOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.NOT_IN, VM_EXPAND);
        f.checkBoolean("1 not in (0, 1, 2)", false);
        f.checkBoolean("3 not in (0, 1, 2)", true);
        if (!f.brokenTestsEnabled()) {
            return;
        }
        f.checkBoolean("cast(null as integer) not in (0, 1, 2)", null);
        f.checkBoolean("cast(null as integer) not in (0, cast(null as integer), 2)", null);
        f.checkBoolean("true and false not in (true, true)", true);
    }

    @Test
    void testOverlapsOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.OVERLAPS, VM_EXPAND);
        f.checkBoolean("(date '1-2-3', date '1-2-3') overlaps (date '1-2-3', interval '1' year)", true);
        f.checkBoolean("(date '1-2-3', date '1-2-3') overlaps (date '4-5-6', interval '1' year)", false);
        f.checkBoolean("(date '1-2-3', date '4-5-6') overlaps (date '2-2-3', date '3-4-5')", true);
        f.checkNull("(cast(null as date), date '1-2-3') overlaps (date '1-2-3', interval '1' year)");
        f.checkNull("(date '1-2-3', date '1-2-3') overlaps (date '1-2-3', cast(null as date))");
        f.checkBoolean("(time '1:2:3', interval '1' second) overlaps (time '23:59:59', time '1:2:3')", true);
        f.checkBoolean("(time '1:2:3', interval '1' second) overlaps (time '23:59:59', time '1:2:2')", true);
        f.checkBoolean("(time '1:2:3', interval '1' second) overlaps (time '23:59:59', interval '2' hour)", false);
        f.checkNull("(time '1:2:3', cast(null as time)) overlaps (time '23:59:59', time '1:2:3')");
        f.checkNull("(time '1:2:3', interval '1' second) overlaps (time '23:59:59', cast(null as interval hour))");
        f.checkBoolean("(timestamp '1-2-3 4:5:6', timestamp '1-2-3 4:5:6' ) overlaps (timestamp '1-2-3 4:5:6', interval '1 2:3:4.5' day to second)", true);
        f.checkBoolean("(timestamp '1-2-3 4:5:6', timestamp '1-2-3 4:5:6' ) overlaps (timestamp '2-2-3 4:5:6', interval '1 2:3:4.5' day to second)", false);
        f.checkNull("(timestamp '1-2-3 4:5:6', cast(null as interval day) ) overlaps (timestamp '1-2-3 4:5:6', interval '1 2:3:4.5' day to second)");
        f.checkNull("(timestamp '1-2-3 4:5:6', timestamp '1-2-3 4:5:6' ) overlaps (cast(null as timestamp), interval '1 2:3:4.5' day to second)");
    }

    @Test
    void testPeriodOperators() {
        String[] times = new String[]{"TIME '01:00:00'", "TIME '02:00:00'", "TIME '03:00:00'", "TIME '04:00:00'"};
        String[] dates = new String[]{"DATE '1970-01-01'", "DATE '1970-02-01'", "DATE '1970-03-01'", "DATE '1970-04-01'"};
        String[] timestamps = new String[]{"TIMESTAMP '1970-01-01 00:00:00'", "TIMESTAMP '1970-02-01 00:00:00'", "TIMESTAMP '1970-03-01 00:00:00'", "TIMESTAMP '1970-04-01 00:00:00'"};
        SqlOperatorFixture f = this.fixture();
        SqlOperatorTest.checkOverlaps(new OverlapChecker(f, times));
        SqlOperatorTest.checkOverlaps(new OverlapChecker(f, dates));
        SqlOperatorTest.checkOverlaps(new OverlapChecker(f, timestamps));
    }

    static void checkOverlaps(OverlapChecker c) {
        c.isTrue("($0,$0) OVERLAPS ($0,$0)");
        c.isFalse("($0,$1) OVERLAPS ($2,$3)");
        c.isTrue("($0,$1) OVERLAPS ($1,$2)");
        c.isTrue("($0,$2) OVERLAPS ($1,$3)");
        c.isTrue("($0,$2) OVERLAPS ($3,$1)");
        c.isTrue("($2,$0) OVERLAPS ($3,$1)");
        c.isFalse("($3,$2) OVERLAPS ($1,$0)");
        c.isTrue("($2,$3) OVERLAPS ($0,$2)");
        c.isTrue("($2,$3) OVERLAPS ($2,$0)");
        c.isTrue("($3,$2) OVERLAPS ($2,$0)");
        c.isTrue("($0,$2) OVERLAPS ($2,$0)");
        c.isTrue("($0,$3) OVERLAPS ($1,$3)");
        c.isTrue("($0,$3) OVERLAPS ($3,$3)");
        c.isTrue("($0,$0) CONTAINS ($0,$0)");
        c.isFalse("($0,$1) CONTAINS ($2,$3)");
        c.isFalse("($0,$1) CONTAINS ($1,$2)");
        c.isFalse("($0,$2) CONTAINS ($1,$3)");
        c.isFalse("($0,$2) CONTAINS ($3,$1)");
        c.isFalse("($2,$0) CONTAINS ($3,$1)");
        c.isFalse("($3,$2) CONTAINS ($1,$0)");
        c.isFalse("($2,$3) CONTAINS ($0,$2)");
        c.isFalse("($2,$3) CONTAINS ($2,$0)");
        c.isFalse("($3,$2) CONTAINS ($2,$0)");
        c.isTrue("($0,$2) CONTAINS ($2,$0)");
        c.isTrue("($0,$3) CONTAINS ($1,$3)");
        c.isTrue("($0,$3) CONTAINS ($3,$3)");
        c.isTrue("($3,$0) CONTAINS ($3,$3)");
        c.isTrue("($3,$0) CONTAINS ($0,$0)");
        c.isTrue("($0,$0) CONTAINS $0");
        c.isTrue("($3,$0) CONTAINS $0");
        c.isTrue("($3,$0) CONTAINS $1");
        c.isTrue("($3,$0) CONTAINS $2");
        c.isTrue("($3,$0) CONTAINS $3");
        c.isTrue("($0,$3) CONTAINS $0");
        c.isTrue("($0,$3) CONTAINS $1");
        c.isTrue("($0,$3) CONTAINS $2");
        c.isTrue("($0,$3) CONTAINS $3");
        c.isFalse("($1,$3) CONTAINS $0");
        c.isFalse("($1,$2) CONTAINS $3");
        c.isTrue("($0,$0) EQUALS ($0,$0)");
        c.isFalse("($0,$1) EQUALS ($2,$3)");
        c.isFalse("($0,$1) EQUALS ($1,$2)");
        c.isFalse("($0,$2) EQUALS ($1,$3)");
        c.isFalse("($0,$2) EQUALS ($3,$1)");
        c.isFalse("($2,$0) EQUALS ($3,$1)");
        c.isFalse("($3,$2) EQUALS ($1,$0)");
        c.isFalse("($2,$3) EQUALS ($0,$2)");
        c.isFalse("($2,$3) EQUALS ($2,$0)");
        c.isFalse("($3,$2) EQUALS ($2,$0)");
        c.isTrue("($0,$2) EQUALS ($2,$0)");
        c.isFalse("($0,$3) EQUALS ($1,$3)");
        c.isFalse("($0,$3) EQUALS ($3,$3)");
        c.isFalse("($3,$0) EQUALS ($3,$3)");
        c.isFalse("($3,$0) EQUALS ($0,$0)");
        c.isTrue("($0,$0) PRECEDES ($0,$0)");
        c.isTrue("($0,$1) PRECEDES ($2,$3)");
        c.isTrue("($0,$1) PRECEDES ($1,$2)");
        c.isFalse("($0,$2) PRECEDES ($1,$3)");
        c.isFalse("($0,$2) PRECEDES ($3,$1)");
        c.isFalse("($2,$0) PRECEDES ($3,$1)");
        c.isFalse("($3,$2) PRECEDES ($1,$0)");
        c.isFalse("($2,$3) PRECEDES ($0,$2)");
        c.isFalse("($2,$3) PRECEDES ($2,$0)");
        c.isFalse("($3,$2) PRECEDES ($2,$0)");
        c.isFalse("($0,$2) PRECEDES ($2,$0)");
        c.isFalse("($0,$3) PRECEDES ($1,$3)");
        c.isTrue("($0,$3) PRECEDES ($3,$3)");
        c.isTrue("($3,$0) PRECEDES ($3,$3)");
        c.isFalse("($3,$0) PRECEDES ($0,$0)");
        c.isTrue("($0,$0) SUCCEEDS ($0,$0)");
        c.isFalse("($0,$1) SUCCEEDS ($2,$3)");
        c.isFalse("($0,$1) SUCCEEDS ($1,$2)");
        c.isFalse("($0,$2) SUCCEEDS ($1,$3)");
        c.isFalse("($0,$2) SUCCEEDS ($3,$1)");
        c.isFalse("($2,$0) SUCCEEDS ($3,$1)");
        c.isTrue("($3,$2) SUCCEEDS ($1,$0)");
        c.isTrue("($2,$3) SUCCEEDS ($0,$2)");
        c.isTrue("($2,$3) SUCCEEDS ($2,$0)");
        c.isTrue("($3,$2) SUCCEEDS ($2,$0)");
        c.isFalse("($0,$2) SUCCEEDS ($2,$0)");
        c.isFalse("($0,$3) SUCCEEDS ($1,$3)");
        c.isFalse("($0,$3) SUCCEEDS ($3,$3)");
        c.isFalse("($3,$0) SUCCEEDS ($3,$3)");
        c.isTrue("($3,$0) SUCCEEDS ($0,$0)");
        c.isTrue("($0,$0) IMMEDIATELY PRECEDES ($0,$0)");
        c.isFalse("($0,$1) IMMEDIATELY PRECEDES ($2,$3)");
        c.isTrue("($0,$1) IMMEDIATELY PRECEDES ($1,$2)");
        c.isFalse("($0,$2) IMMEDIATELY PRECEDES ($1,$3)");
        c.isFalse("($0,$2) IMMEDIATELY PRECEDES ($3,$1)");
        c.isFalse("($2,$0) IMMEDIATELY PRECEDES ($3,$1)");
        c.isFalse("($3,$2) IMMEDIATELY PRECEDES ($1,$0)");
        c.isFalse("($2,$3) IMMEDIATELY PRECEDES ($0,$2)");
        c.isFalse("($2,$3) IMMEDIATELY PRECEDES ($2,$0)");
        c.isFalse("($3,$2) IMMEDIATELY PRECEDES ($2,$0)");
        c.isFalse("($0,$2) IMMEDIATELY PRECEDES ($2,$0)");
        c.isFalse("($0,$3) IMMEDIATELY PRECEDES ($1,$3)");
        c.isTrue("($0,$3) IMMEDIATELY PRECEDES ($3,$3)");
        c.isTrue("($3,$0) IMMEDIATELY PRECEDES ($3,$3)");
        c.isFalse("($3,$0) IMMEDIATELY PRECEDES ($0,$0)");
        c.isTrue("($0,$0) IMMEDIATELY SUCCEEDS ($0,$0)");
        c.isFalse("($0,$1) IMMEDIATELY SUCCEEDS ($2,$3)");
        c.isFalse("($0,$1) IMMEDIATELY SUCCEEDS ($1,$2)");
        c.isFalse("($0,$2) IMMEDIATELY SUCCEEDS ($1,$3)");
        c.isFalse("($0,$2) IMMEDIATELY SUCCEEDS ($3,$1)");
        c.isFalse("($2,$0) IMMEDIATELY SUCCEEDS ($3,$1)");
        c.isFalse("($3,$2) IMMEDIATELY SUCCEEDS ($1,$0)");
        c.isTrue("($2,$3) IMMEDIATELY SUCCEEDS ($0,$2)");
        c.isTrue("($2,$3) IMMEDIATELY SUCCEEDS ($2,$0)");
        c.isTrue("($3,$2) IMMEDIATELY SUCCEEDS ($2,$0)");
        c.isFalse("($0,$2) IMMEDIATELY SUCCEEDS ($2,$0)");
        c.isFalse("($0,$3) IMMEDIATELY SUCCEEDS ($1,$3)");
        c.isFalse("($0,$3) IMMEDIATELY SUCCEEDS ($3,$3)");
        c.isFalse("($3,$0) IMMEDIATELY SUCCEEDS ($3,$3)");
        c.isTrue("($3,$0) IMMEDIATELY SUCCEEDS ($0,$0)");
    }

    @Test
    void testLessThanOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.LESS_THAN, SqlOperatorFixture.VmName.EXPAND);
        f.checkBoolean("1<2", true);
        f.checkBoolean("-1<1", true);
        f.checkBoolean("1<1", false);
        f.checkBoolean("2<1", false);
        f.checkBoolean("1.1<1.2", true);
        f.checkBoolean("-1.1<-1.2", false);
        f.checkBoolean("1.1<1.1", false);
        f.checkBoolean("cast(1.1 as real)<1", false);
        f.checkBoolean("cast(1.1 as real)<1.1", false);
        f.checkBoolean("cast(1.1 as real)<cast(1.2 as real)", true);
        f.checkBoolean("-1.1e-1<-1.2e-1", false);
        f.checkBoolean("cast(1.1 as real)<cast(1.1 as double)", false);
        f.checkBoolean("true<false", false);
        f.checkBoolean("true<true", false);
        f.checkBoolean("false<false", false);
        f.checkBoolean("false<true", true);
        f.checkNull("123<cast(null as bigint)");
        f.checkNull("cast(null as tinyint)<123");
        f.checkNull("cast(null as integer)<1.32");
        f.checkBoolean("x'0A000130'<x'0A0001B0'", true);
    }

    @Test
    void testLessThanOperatorInterval() {
    }

    @Test
    void testLessThanOrEqualOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, SqlOperatorFixture.VmName.EXPAND);
        f.checkBoolean("1<=2", true);
        f.checkBoolean("1<=1", true);
        f.checkBoolean("-1<=1", true);
        f.checkBoolean("2<=1", false);
        f.checkBoolean("1.1<=1.2", true);
        f.checkBoolean("-1.1<=-1.2", false);
        f.checkBoolean("1.1<=1.1", true);
        f.checkBoolean("1.2<=1", false);
        f.checkBoolean("1<=cast(1e2 as real)", true);
        f.checkBoolean("1000<=cast(1e2 as real)", false);
        f.checkBoolean("1.2e1<=1e2", true);
        f.checkBoolean("1.2e1<=cast(1e2 as real)", true);
        f.checkBoolean("true<=false", false);
        f.checkBoolean("true<=true", true);
        f.checkBoolean("false<=false", true);
        f.checkBoolean("false<=true", true);
        f.checkNull("cast(null as real)<=cast(1 as real)");
        f.checkNull("cast(null as integer)<=3");
        f.checkNull("3<=cast(null as smallint)");
        f.checkNull("cast(null as integer)<=1.32");
        f.checkBoolean("x'0A000130'<=x'0A0001B0'", true);
        f.checkBoolean("x'0A0001B0'<=x'0A0001B0'", true);
    }

    @Test
    void testLessThanOrEqualOperatorInterval() {
        SqlOperatorFixture f = this.fixture();
        f.checkBoolean("interval '2' day <= interval '1' day", false);
        f.checkBoolean("interval '2' day <= interval '5' day", true);
        f.checkBoolean("interval '2 2:2:2' day to second <= interval '2' day", false);
        f.checkBoolean("interval '2' day <= interval '2' day", true);
        f.checkBoolean("interval '2' day <= interval '-2' day", false);
        f.checkBoolean("interval '2' day <= interval '2' hour", false);
        f.checkBoolean("interval '2' minute <= interval '2' hour", true);
        f.checkBoolean("interval '2' second <= interval '2' minute", true);
        f.checkNull("cast(null as interval hour) <= interval '2' minute");
        f.checkNull("interval '2:2' hour to minute <= cast(null as interval second)");
    }

    @Test
    void testMinusOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.MINUS, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalarExact("-2-1", -3);
        f.checkScalarExact("-2-1-5", -8);
        f.checkScalarExact("2-1", 1);
        f.checkScalarApprox("cast(2.0 as double) -1", "DOUBLE NOT NULL", ResultCheckers.isExactly(1.0));
        f.checkScalarApprox("cast(1 as smallint)-cast(2.0 as real)", "REAL NOT NULL", ResultCheckers.isExactly(-1.0));
        f.checkScalarApprox("2.4-cast(2.0 as real)", "DOUBLE NOT NULL", ResultCheckers.isWithin(0.4, 1.0E-8));
        f.checkScalarExact("1-2", -1);
        f.checkScalarExact("10.0 - 5.0", "DECIMAL(4, 1) NOT NULL", "5.0");
        f.checkScalarExact("19.68 - 4.2", "DECIMAL(5, 2) NOT NULL", "15.48");
        f.checkNull("1e1-cast(null as double)");
        f.checkNull("cast(null as tinyint) - cast(null as smallint)");
    }

    @Test
    void testMinusIntervalOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.MINUS, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalar("interval '2' day - interval '1' day", "+1", "INTERVAL DAY NOT NULL");
        f.checkScalar("interval '2' day - interval '1' minute", "+1 23:59", "INTERVAL DAY TO MINUTE NOT NULL");
        f.checkScalar("interval '2' year - interval '1' month", "+1-11", "INTERVAL YEAR TO MONTH NOT NULL");
        f.checkScalar("interval '2' year - interval '1' month - interval '3' year", "-1-01", "INTERVAL YEAR TO MONTH NOT NULL");
        f.checkNull("cast(null as interval day) + interval '2' hour");
        f.checkScalar("time '12:03:01' - interval '1:1' hour to minute", "11:02:01", "TIME(0) NOT NULL");
        f.checkScalar("time '12:03:01' - interval '1' day", "12:03:01", "TIME(0) NOT NULL");
        f.checkScalar("time '12:03:01' - interval '25' hour", "11:03:01", "TIME(0) NOT NULL");
        f.checkScalar("time '12:03:03' - interval '25:0:1' hour to second", "11:03:02", "TIME(0) NOT NULL");
        f.checkScalar("date '2005-03-02' - interval '5' day", "2005-02-25", "DATE NOT NULL");
        f.checkScalar("date '2005-03-02' - interval '5' day", "2005-02-25", "DATE NOT NULL");
        f.checkScalar("date '2005-03-02' - interval '5' hour", "2005-03-02", "DATE NOT NULL");
        f.checkScalar("date '2005-03-02' - interval '25' hour", "2005-03-01", "DATE NOT NULL");
        f.checkScalar("date '2005-03-02' - interval '25:45' hour to minute", "2005-03-01", "DATE NOT NULL");
        f.checkScalar("date '2005-03-02' - interval '25:45:54' hour to second", "2005-03-01", "DATE NOT NULL");
        f.checkScalar("timestamp '2003-08-02 12:54:01' - interval '-4 2:4' day to minute", "2003-08-06 14:58:01", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("timestamp '2003-08-02 12:54:01' - interval '12' year", "1991-08-02 12:54:01", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("date '2003-08-02' - interval '12' year", "1991-08-02", "DATE NOT NULL");
        f.checkScalar("date '2003-08-02' - interval '12-3' year to month", "1991-05-02", "DATE NOT NULL");
    }

    @Test
    void testMinusDateOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.MINUS_DATE, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalar("(time '12:03:34' - time '11:57:23') minute to second", "+6:11.000000", "INTERVAL MINUTE TO SECOND NOT NULL");
        f.checkScalar("(time '12:03:23' - time '11:57:23') minute", "+6", "INTERVAL MINUTE NOT NULL");
        f.checkScalar("(time '12:03:34' - time '11:57:23') minute", "+6", "INTERVAL MINUTE NOT NULL");
        f.checkScalar("(timestamp '2004-05-01 12:03:34' - timestamp '2004-04-29 11:57:23') day to second", "+2 00:06:11.000000", "INTERVAL DAY TO SECOND NOT NULL");
        f.checkScalar("(timestamp '2004-05-01 12:03:34' - timestamp '2004-04-29 11:57:23') day to hour", "+2 00", "INTERVAL DAY TO HOUR NOT NULL");
        f.checkScalar("(date '2004-12-02' - date '2003-12-01') day", "+367", "INTERVAL DAY NOT NULL");
        f.checkNull("(cast(null as date) - date '2003-12-01') day");
        f.checkScalar("timestamp '1969-04-29 0:0:0' + (timestamp '2008-07-15 15:28:00' -   timestamp '1969-04-29 0:0:0') day to second / 2", "1988-12-06 07:44:00", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("date '1969-04-29' + (date '2008-07-15' -   date '1969-04-29') day / 2", "1988-12-06", "DATE NOT NULL");
        f.checkScalar("time '01:23:44' + (time '15:28:00' -   time '01:23:44') hour to second / 2", "08:25:52", "TIME(0) NOT NULL");
    }

    @Test
    void testMultiplyOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.MULTIPLY, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalarExact("2*3", 6);
        f.checkScalarExact("2*-3", -6);
        f.checkScalarExact("+2*3", 6);
        f.checkScalarExact("2*0", 0);
        f.checkScalarApprox("cast(2.0 as float)*3", "FLOAT NOT NULL", ResultCheckers.isExactly(6.0));
        f.checkScalarApprox("3*cast(2.0 as real)", "REAL NOT NULL", ResultCheckers.isExactly(6.0));
        f.checkScalarApprox("cast(2.0 as real)*3.2", "DOUBLE NOT NULL", ResultCheckers.isExactly("6.4"));
        f.checkScalarExact("10.0 * 5.0", "DECIMAL(5, 2) NOT NULL", "50.00");
        f.checkScalarExact("19.68 * 4.2", "DECIMAL(6, 3) NOT NULL", "82.656");
        f.checkNull("cast(1 as real)*cast(null as real)");
        f.checkNull("2e-3*cast(null as integer)");
        f.checkNull("cast(null as tinyint) * cast(4 as smallint)");
    }

    @Test
    void testMultiplyIntervals() {
        SqlOperatorFixture f = this.fixture();
        f.checkScalar("interval '2:2' hour to minute * 3", "+6:06", "INTERVAL HOUR TO MINUTE NOT NULL");
        f.checkScalar("3 * 2 * interval '2:5:12' hour to second", "+12:31:12.000000", "INTERVAL HOUR TO SECOND NOT NULL");
        f.checkNull("interval '2' day * cast(null as bigint)");
        f.checkNull("cast(null as interval month) * 2");
    }

    @Test
    void testDatePlusInterval() {
        SqlOperatorFixture f = this.fixture();
        f.checkScalar("date '2014-02-11' + interval '2' day", "2014-02-13", "DATE NOT NULL");
        f.checkScalar("date '2014-02-11' + interval '60' day", "2014-04-12", "DATE NOT NULL");
    }

    @Test
    void testNullOperand() {
        SqlOperatorFixture f = this.fixture();
        SqlOperatorTest.checkNullOperand(f, "=");
        SqlOperatorTest.checkNullOperand(f, ">");
        SqlOperatorTest.checkNullOperand(f, "<");
        SqlOperatorTest.checkNullOperand(f, "<=");
        SqlOperatorTest.checkNullOperand(f, ">=");
        SqlOperatorTest.checkNullOperand(f, "<>");
        SqlOperatorFixture f1 = f.withConformance((SqlConformance)SqlConformanceEnum.ORACLE_10);
        SqlOperatorTest.checkNullOperand(f1, "<>");
    }

    private static void checkNullOperand(SqlOperatorFixture f, String op) {
        f.checkBoolean("1 " + op + " null", null);
        f.checkBoolean("null " + op + " -3", null);
        f.checkBoolean("null " + op + " null", null);
    }

    @Test
    void testNotEqualsOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, SqlOperatorFixture.VmName.EXPAND);
        f.checkBoolean("1<>1", false);
        f.checkBoolean("'a'<>'A'", true);
        f.checkBoolean("1e0<>1e1", true);
        f.checkNull("'a'<>cast(null as varchar(1))");
        f.checkFails("1 ^!=^ 1", "Bang equal '!=' is not allowed under the current SQL conformance level", false);
        Consumer<SqlOperatorFixture> consumer = f1 -> {
            f1.checkBoolean("1 <> 1", false);
            f1.checkBoolean("1 != 1", false);
            f1.checkBoolean("2 != 1", true);
            f1.checkBoolean("1 != null", null);
        };
        Expressions.FluentList conformances = Expressions.list((Object[])new SqlConformanceEnum[]{SqlConformanceEnum.BIG_QUERY, SqlConformanceEnum.ORACLE_10});
        f.forEachConformance((Iterable<? extends SqlConformanceEnum>)conformances, consumer);
    }

    @Test
    void testNotEqualsOperatorIntervals() {
        SqlOperatorFixture f = this.fixture();
        f.checkBoolean("interval '2' day <> interval '1' day", true);
        f.checkBoolean("interval '2' day <> interval '2' day", false);
        f.checkBoolean("interval '2:2:2' hour to second <> interval '2' hour", true);
        f.checkNull("cast(null as interval hour) <> interval '2' minute");
    }

    @Test
    void testOrOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.OR, SqlOperatorFixture.VmName.EXPAND);
        f.checkBoolean("true or false", true);
        f.checkBoolean("false or false", false);
        f.checkBoolean("true or cast(null as boolean)", true);
        f.checkNull("false or cast(null as boolean)");
    }

    @Test
    void testOrOperatorLazy() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.OR, SqlOperatorFixture.VmName.EXPAND);
        f.check("values 1 < cast(null as integer) or sqrt(-4) = -2", SqlTests.BOOLEAN_TYPE_CHECKER, SqlTests.ANY_PARAMETER_CHECKER, new ValueOrExceptionResultChecker(null, INVALID_ARG_FOR_POWER, CODE_2201F));
        f.check("values 1 < 2 or sqrt(-4) = -2", SqlTests.BOOLEAN_TYPE_CHECKER, SqlTests.ANY_PARAMETER_CHECKER, new ValueOrExceptionResultChecker(true, INVALID_ARG_FOR_POWER, CODE_2201F));
        f.check("values 1 < cast(null as integer) or sqrt(4) = -2", SqlTests.BOOLEAN_TYPE_CHECKER, SqlTests.ANY_PARAMETER_CHECKER, new ValueOrExceptionResultChecker(null, INVALID_ARG_FOR_POWER, CODE_2201F));
        f.checkBoolean("1 < cast(null as integer) or sqrt(4) = 2", true);
    }

    @Test
    void testPlusOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.PLUS, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalarExact("1+2", 3);
        f.checkScalarExact("-1+2", 1);
        f.checkScalarExact("1+2+3", 6);
        f.checkScalarApprox("1+cast(2.0 as double)", "DOUBLE NOT NULL", ResultCheckers.isExactly(3.0));
        f.checkScalarApprox("1+cast(2.0 as double)+cast(6.0 as float)", "DOUBLE NOT NULL", ResultCheckers.isExactly(9.0));
        f.checkScalarExact("10.0 + 5.0", "DECIMAL(4, 1) NOT NULL", "15.0");
        f.checkScalarExact("19.68 + 4.2", "DECIMAL(5, 2) NOT NULL", "23.88");
        f.checkScalarExact("19.68 + 4.2 + 6", "DECIMAL(13, 2) NOT NULL", "29.88");
        f.checkScalarApprox("19.68 + cast(4.2 as float)", "DOUBLE NOT NULL", ResultCheckers.isWithin(23.88, 0.02));
        f.checkNull("cast(null as tinyint)+1");
        f.checkNull("1e-2+cast(null as double)");
    }

    @Test
    void testPlusOperatorAny() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.PLUS, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalar("1+CAST(2 AS ANY)", "3", "ANY NOT NULL");
    }

    @Test
    void testPlusIntervalOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.PLUS, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalar("interval '2' day + interval '1' day", "+3", "INTERVAL DAY NOT NULL");
        f.checkScalar("interval '2' day + interval '1' minute", "+2 00:01", "INTERVAL DAY TO MINUTE NOT NULL");
        f.checkScalar("interval '2' day + interval '5' minute + interval '-3' second", "+2 00:04:57.000000", "INTERVAL DAY TO SECOND NOT NULL");
        f.checkScalar("interval '2' year + interval '1' month", "+2-01", "INTERVAL YEAR TO MONTH NOT NULL");
        f.checkNull("interval '2' year + cast(null as interval month)");
        f.checkScalar("time '12:03:01' + interval '1:1' hour to minute", "13:04:01", "TIME(0) NOT NULL");
        f.checkScalar("time '12:03:01' + interval '1' day", "12:03:01", "TIME(0) NOT NULL");
        f.checkScalar("time '12:03:01' + interval '25' hour", "13:03:01", "TIME(0) NOT NULL");
        f.checkScalar("time '12:03:01' + interval '25:0:1' hour to second", "13:03:02", "TIME(0) NOT NULL");
        f.checkScalar("interval '5' day + date '2005-03-02'", "2005-03-07", "DATE NOT NULL");
        f.checkScalar("date '2005-03-02' + interval '5' day", "2005-03-07", "DATE NOT NULL");
        f.checkScalar("date '2005-03-02' + interval '5' hour", "2005-03-02", "DATE NOT NULL");
        f.checkScalar("date '2005-03-02' + interval '25' hour", "2005-03-03", "DATE NOT NULL");
        f.checkScalar("date '2005-03-02' + interval '25:45' hour to minute", "2005-03-03", "DATE NOT NULL");
        f.checkScalar("date '2005-03-02' + interval '25:45:54' hour to second", "2005-03-03", "DATE NOT NULL");
        f.checkScalar("timestamp '2003-08-02 12:54:01' + interval '-4 2:4' day to minute", "2003-07-29 10:50:01", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("interval '5-3' year to month + date '2005-03-02'", "2010-06-02", "DATE NOT NULL");
        f.checkScalar("timestamp '2003-08-02 12:54:01' + interval '5-3' year to month", "2008-11-02 12:54:01", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("interval '5-3' year to month + timestamp '2003-08-02 12:54:01'", "2008-11-02 12:54:01", "TIMESTAMP(0) NOT NULL");
    }

    @Test
    void testDescendingOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.DESC, VM_EXPAND);
    }

    @Test
    void testIsNotNullOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, SqlOperatorFixture.VmName.EXPAND);
        f.checkBoolean("true is not null", true);
        f.checkBoolean("cast(null as boolean) is not null", false);
    }

    @Test
    void testIsNullOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.IS_NULL, SqlOperatorFixture.VmName.EXPAND);
        f.checkBoolean("true is null", false);
        f.checkBoolean("cast(null as boolean) is null", true);
    }

    @Test
    void testIsNotTrueOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.IS_NOT_TRUE, SqlOperatorFixture.VmName.EXPAND);
        f.checkBoolean("true is not true", false);
        f.checkBoolean("false is not true", true);
        f.checkBoolean("cast(null as boolean) is not true", true);
        f.checkFails("select ^'a string' is not true^ from (values (1))", "(?s)Cannot apply 'IS NOT TRUE' to arguments of type '<CHAR\\(8\\)> IS NOT TRUE'. Supported form\\(s\\): '<BOOLEAN> IS NOT TRUE'.*", false);
    }

    @Test
    void testIsTrueOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.IS_TRUE, SqlOperatorFixture.VmName.EXPAND);
        f.checkBoolean("true is true", true);
        f.checkBoolean("false is true", false);
        f.checkBoolean("cast(null as boolean) is true", false);
    }

    @Test
    void testIsNotFalseOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.IS_NOT_FALSE, SqlOperatorFixture.VmName.EXPAND);
        f.checkBoolean("false is not false", false);
        f.checkBoolean("true is not false", true);
        f.checkBoolean("cast(null as boolean) is not false", true);
    }

    @Test
    void testIsFalseOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.IS_FALSE, SqlOperatorFixture.VmName.EXPAND);
        f.checkBoolean("false is false", true);
        f.checkBoolean("true is false", false);
        f.checkBoolean("cast(null as boolean) is false", false);
    }

    @Test
    void testIsNotUnknownOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.IS_NOT_UNKNOWN, VM_EXPAND);
        f.checkBoolean("false is not unknown", true);
        f.checkBoolean("true is not unknown", true);
        f.checkBoolean("cast(null as boolean) is not unknown", false);
        f.checkBoolean("unknown is not unknown", false);
        f.checkFails("^'abc' IS NOT UNKNOWN^", "(?s).*Cannot apply 'IS NOT UNKNOWN'.*", false);
    }

    @Test
    void testIsUnknownOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.IS_UNKNOWN, VM_EXPAND);
        f.checkBoolean("false is unknown", false);
        f.checkBoolean("true is unknown", false);
        f.checkBoolean("cast(null as boolean) is unknown", true);
        f.checkBoolean("unknown is unknown", true);
        f.checkFails("0 = 1 AND ^2 IS UNKNOWN^ AND 3 > 4", "(?s).*Cannot apply 'IS UNKNOWN'.*", false);
    }

    @Test
    void testIsASetOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.IS_A_SET, VM_EXPAND);
        f.checkBoolean("multiset[1] is a set", true);
        f.checkBoolean("multiset[1, 1] is a set", false);
        f.checkBoolean("multiset[cast(null as boolean), cast(null as boolean)] is a set", false);
        f.checkBoolean("multiset[cast(null as boolean)] is a set", true);
        f.checkBoolean("multiset['a'] is a set", true);
        f.checkBoolean("multiset['a', 'b'] is a set", true);
        f.checkBoolean("multiset['a', 'b', 'a'] is a set", false);
    }

    @Test
    void testIsNotASetOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.IS_NOT_A_SET, VM_EXPAND);
        f.checkBoolean("multiset[1] is not a set", false);
        f.checkBoolean("multiset[1, 1] is not a set", true);
        f.checkBoolean("multiset[cast(null as boolean), cast(null as boolean)] is not a set", true);
        f.checkBoolean("multiset[cast(null as boolean)] is not a set", false);
        f.checkBoolean("multiset['a'] is not a set", false);
        f.checkBoolean("multiset['a', 'b'] is not a set", false);
        f.checkBoolean("multiset['a', 'b', 'a'] is not a set", true);
    }

    @Test
    void testIntersectOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.MULTISET_INTERSECT, VM_EXPAND);
        f.checkScalar("multiset[1] multiset intersect multiset[1]", "[1]", "INTEGER NOT NULL MULTISET NOT NULL");
        f.checkScalar("multiset[2] multiset intersect all multiset[1]", "[]", "INTEGER NOT NULL MULTISET NOT NULL");
        f.checkScalar("multiset[2] multiset intersect distinct multiset[1]", "[]", "INTEGER NOT NULL MULTISET NOT NULL");
        f.checkScalar("multiset[1, 1] multiset intersect distinct multiset[1, 1]", "[1]", "INTEGER NOT NULL MULTISET NOT NULL");
        f.checkScalar("multiset[1, 1] multiset intersect all multiset[1, 1]", "[1, 1]", "INTEGER NOT NULL MULTISET NOT NULL");
        f.checkScalar("multiset[1, 1] multiset intersect distinct multiset[1, 1]", "[1]", "INTEGER NOT NULL MULTISET NOT NULL");
        f.checkScalar("multiset[cast(null as integer), cast(null as integer)] multiset intersect distinct multiset[cast(null as integer)]", "[null]", "INTEGER MULTISET NOT NULL");
        f.checkScalar("multiset[cast(null as integer), cast(null as integer)] multiset intersect all multiset[cast(null as integer)]", "[null]", "INTEGER MULTISET NOT NULL");
        f.checkScalar("multiset[cast(null as integer), cast(null as integer)] multiset intersect distinct multiset[cast(null as integer)]", "[null]", "INTEGER MULTISET NOT NULL");
    }

    @Test
    void testExceptOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.MULTISET_EXCEPT, VM_EXPAND);
        f.checkScalar("multiset[1] multiset except multiset[1]", "[]", "INTEGER NOT NULL MULTISET NOT NULL");
        f.checkScalar("multiset[1] multiset except distinct multiset[1]", "[]", "INTEGER NOT NULL MULTISET NOT NULL");
        f.checkScalar("multiset[2] multiset except multiset[1]", "[2]", "INTEGER NOT NULL MULTISET NOT NULL");
        f.checkScalar("multiset[1,2,3] multiset except multiset[1]", "[2, 3]", "INTEGER NOT NULL MULTISET NOT NULL");
        f.checkScalar("cardinality(multiset[1,2,3,2] multiset except distinct multiset[1])", "2", "INTEGER NOT NULL");
        f.checkScalar("cardinality(multiset[1,2,3,2] multiset except all multiset[1])", "3", "INTEGER NOT NULL");
        f.checkBoolean("(multiset[1,2,3,2] multiset except distinct multiset[1]) submultiset of multiset[2, 3]", true);
        f.checkBoolean("(multiset[1,2,3,2] multiset except distinct multiset[1]) submultiset of multiset[2, 3]", true);
        f.checkBoolean("(multiset[1,2,3,2] multiset except all multiset[1]) submultiset of multiset[2, 2, 3]", true);
        f.checkBoolean("(multiset[1,2,3] multiset except multiset[1]) is empty", false);
        f.checkBoolean("(multiset[1] multiset except multiset[1]) is empty", true);
    }

    @Test
    void testIsEmptyOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.IS_EMPTY, VM_EXPAND);
        f.checkBoolean("multiset[1] is empty", false);
    }

    @Test
    void testIsNotEmptyOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.IS_NOT_EMPTY, VM_EXPAND);
        f.checkBoolean("multiset[1] is not empty", true);
    }

    @Test
    void testExistsOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.EXISTS, VM_EXPAND);
    }

    @Test
    void testNotOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.NOT, SqlOperatorFixture.VmName.EXPAND);
        f.checkBoolean("not true", false);
        f.checkBoolean("not false", true);
        f.checkBoolean("not unknown", null);
        f.checkNull("not cast(null as boolean)");
    }

    @Test
    void testPrefixMinusOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.UNARY_MINUS, SqlOperatorFixture.VmName.EXPAND);
        f.enableTypeCoercion(false).checkFails("'a' + ^- 'b'^ + 'c'", "(?s)Cannot apply '-' to arguments of type '-<CHAR\\(1\\)>'.*", false);
        f.checkType("'a' + - 'b' + 'c'", "DECIMAL(19, 9) NOT NULL");
        f.checkScalarExact("-1", -1);
        f.checkScalarExact("-1.23", "DECIMAL(3, 2) NOT NULL", "-1.23");
        f.checkScalarApprox("-1.0e0", "DOUBLE NOT NULL", ResultCheckers.isExactly(-1.0));
        f.checkNull("-cast(null as integer)");
        f.checkNull("-cast(null as tinyint)");
    }

    @Test
    void testPrefixMinusOperatorIntervals() {
        SqlOperatorFixture f = this.fixture();
        f.checkScalar("-interval '-6:2:8' hour to second", "+6:02:08.000000", "INTERVAL HOUR TO SECOND NOT NULL");
        f.checkScalar("- -interval '-6:2:8' hour to second", "-6:02:08.000000", "INTERVAL HOUR TO SECOND NOT NULL");
        f.checkScalar("-interval '5' month", "-5", "INTERVAL MONTH NOT NULL");
        f.checkNull("-cast(null as interval day to minute)");
    }

    @Test
    void testPrefixPlusOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.UNARY_PLUS, VM_EXPAND);
        f.checkScalarExact("+1", 1);
        f.checkScalarExact("+1.23", "DECIMAL(3, 2) NOT NULL", "1.23");
        f.checkScalarApprox("+1.0e0", "DOUBLE NOT NULL", ResultCheckers.isExactly(1.0));
        f.checkNull("+cast(null as integer)");
        f.checkNull("+cast(null as tinyint)");
    }

    @Test
    void testPrefixPlusOperatorIntervals() {
        SqlOperatorFixture f = this.fixture();
        f.checkScalar("+interval '-6:2:8' hour to second", "-6:02:08.000000", "INTERVAL HOUR TO SECOND NOT NULL");
        f.checkScalar("++interval '-6:2:8' hour to second", "-6:02:08.000000", "INTERVAL HOUR TO SECOND NOT NULL");
        f.checkScalar("+interval '5' month", "+5", "INTERVAL MONTH NOT NULL");
        f.checkNull("+cast(null as interval day to minute)");
    }

    @Test
    void testExplicitTableOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.EXPLICIT_TABLE, VM_EXPAND);
    }

    @Test
    void testValuesOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.VALUES, VM_EXPAND);
        f.check("select 'abc' from (values(true))", "CHAR(3) NOT NULL", (Object)"abc");
    }

    @Test
    void testNotLikeOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.NOT_LIKE, VM_EXPAND);
        f.checkBoolean("'abc' not like '_b_'", false);
        f.checkBoolean("'ab\ncd' not like 'ab%'", false);
        f.checkBoolean("'123\n\n45\n' not like '%'", false);
        f.checkBoolean("'ab\ncd\nef' not like '%cd%'", false);
        f.checkBoolean("'ab\ncd\nef' not like '%cde%'", true);
    }

    @Test
    void testRlikeOperator() {
        SqlOperatorFixture f = this.fixture().setFor((SqlOperator)SqlLibraryOperators.RLIKE, VM_EXPAND);
        SqlOperatorTest.checkRlike(f.withLibrary(SqlLibrary.SPARK));
        SqlOperatorTest.checkRlike(f.withLibrary(SqlLibrary.HIVE));
        SqlOperatorTest.checkRlikeFails(f.withLibrary(SqlLibrary.MYSQL));
        SqlOperatorTest.checkRlikeFails(f.withLibrary(SqlLibrary.ORACLE));
    }

    static void checkRlike(SqlOperatorFixture f) {
        f.checkBoolean("'Merrisa@gmail.com' rlike '.+@*\\.com'", true);
        f.checkBoolean("'Merrisa@gmail.com' rlike '.com$'", true);
        f.checkBoolean("'acbd' rlike '^ac+'", true);
        f.checkBoolean("'acb' rlike 'acb|efg'", true);
        f.checkBoolean("'acb|efg' rlike 'acb\\|efg'", true);
        f.checkBoolean("'Acbd' rlike '^ac+'", false);
        f.checkBoolean("'Merrisa@gmail.com' rlike 'Merrisa_'", false);
        f.checkBoolean("'abcdef' rlike '%cd%'", false);
        f.setFor((SqlOperator)SqlLibraryOperators.NOT_RLIKE, VM_EXPAND);
        f.checkBoolean("'Merrisagmail' not rlike '.+@*\\.com'", true);
        f.checkBoolean("'acbd' not rlike '^ac+'", false);
        f.checkBoolean("'acb|efg' not rlike 'acb\\|efg'", false);
        f.checkBoolean("'Merrisa@gmail.com' not rlike 'Merrisa_'", true);
    }

    static void checkRlikeFails(SqlOperatorFixture f) {
        String noRlike = "(?s).*No match found for function signature RLIKE";
        f.checkFails("^'Merrisa@gmail.com' rlike '.+@*\\.com'^", "(?s).*No match found for function signature RLIKE", false);
        f.checkFails("^'acb' rlike 'acb|efg'^", "(?s).*No match found for function signature RLIKE", false);
        String noNotRlike = "(?s).*No match found for function signature NOT RLIKE";
        f.checkFails("^'abcdef' not rlike '%cd%'^", "(?s).*No match found for function signature NOT RLIKE", false);
        f.checkFails("^'Merrisa@gmail.com' not rlike 'Merrisa_'^", "(?s).*No match found for function signature NOT RLIKE", false);
    }

    @Test
    void testLikeEscape() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.LIKE, SqlOperatorFixture.VmName.EXPAND);
        f.checkBoolean("'a_c' like 'a#_c' escape '#'", true);
        f.checkBoolean("'axc' like 'a#_c' escape '#'", false);
        f.checkBoolean("'a_c' like 'a\\_c' escape '\\'", true);
        f.checkBoolean("'axc' like 'a\\_c' escape '\\'", false);
        f.checkBoolean("'a%c' like 'a\\%c' escape '\\'", true);
        f.checkBoolean("'a%cde' like 'a\\%c_e' escape '\\'", true);
        f.checkBoolean("'abbc' like 'a%c' escape '\\'", true);
        f.checkBoolean("'abbc' like 'a\\%c' escape '\\'", false);
    }

    @Test
    void testIlikeEscape() {
        SqlOperatorFixture f = this.fixture().setFor((SqlOperator)SqlLibraryOperators.ILIKE, SqlOperatorFixture.VmName.EXPAND).withLibrary(SqlLibrary.POSTGRESQL);
        f.checkBoolean("'a_c' ilike 'a#_C' escape '#'", true);
        f.checkBoolean("'axc' ilike 'a#_C' escape '#'", false);
        f.checkBoolean("'a_c' ilike 'a\\_C' escape '\\'", true);
        f.checkBoolean("'axc' ilike 'a\\_C' escape '\\'", false);
        f.checkBoolean("'a%c' ilike 'a\\%C' escape '\\'", true);
        f.checkBoolean("'a%cde' ilike 'a\\%C_e' escape '\\'", true);
        f.checkBoolean("'abbc' ilike 'a%C' escape '\\'", true);
        f.checkBoolean("'abbc' ilike 'a\\%C' escape '\\'", false);
    }

    @Disabled(value="[CALCITE-525] Exception-handling in built-in functions")
    @Test
    void testLikeEscape2() {
        SqlOperatorFixture f = this.fixture();
        f.checkBoolean("'x' not like 'x' escape 'x'", true);
        f.checkBoolean("'xyz' not like 'xyz' escape 'xyz'", true);
    }

    @Test
    void testLikeOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.LIKE, SqlOperatorFixture.VmName.EXPAND);
        f.checkBoolean("''  like ''", true);
        f.checkBoolean("'a' like 'a'", true);
        f.checkBoolean("'a' like 'b'", false);
        f.checkBoolean("'a' like 'A'", false);
        f.checkBoolean("'a' like 'a_'", false);
        f.checkBoolean("'a' like '_a'", false);
        f.checkBoolean("'a' like '%a'", true);
        f.checkBoolean("'a' like '%a%'", true);
        f.checkBoolean("'a' like 'a%'", true);
        f.checkBoolean("'ab'   like 'a_'", true);
        f.checkBoolean("'abc'  like 'a_'", false);
        f.checkBoolean("'abcd' like 'a%'", true);
        f.checkBoolean("'ab'   like '_b'", true);
        f.checkBoolean("'abcd' like '_d'", false);
        f.checkBoolean("'abcd' like '%d'", true);
        f.checkBoolean("'ab\ncd' like 'ab%'", true);
        f.checkBoolean("'abc\ncd' like 'ab%'", true);
        f.checkBoolean("'123\n\n45\n' like '%'", true);
        f.checkBoolean("'ab\ncd\nef' like '%cd%'", true);
        f.checkBoolean("'ab\ncd\nef' like '%cde%'", false);
    }

    @Test
    void testIlikeOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlLibraryOperators.ILIKE, SqlOperatorFixture.VmName.EXPAND);
        String noLike = "No match found for function signature ILIKE";
        f.checkFails("^'a' ilike 'b'^", "No match found for function signature ILIKE", false);
        f.checkFails("^'a' ilike 'b' escape 'c'^", "No match found for function signature ILIKE", false);
        String noNotLike = "No match found for function signature NOT ILIKE";
        f.checkFails("^'a' not ilike 'b'^", "No match found for function signature NOT ILIKE", false);
        f.checkFails("^'a' not ilike 'b' escape 'c'^", "No match found for function signature NOT ILIKE", false);
        SqlOperatorFixture f1 = f.withLibrary(SqlLibrary.POSTGRESQL);
        f1.checkBoolean("''  ilike ''", true);
        f1.checkBoolean("'a' ilike 'a'", true);
        f1.checkBoolean("'a' ilike 'b'", false);
        f1.checkBoolean("'a' ilike 'A'", true);
        f1.checkBoolean("'a' ilike 'a_'", false);
        f1.checkBoolean("'a' ilike '_a'", false);
        f1.checkBoolean("'a' ilike '%a'", true);
        f1.checkBoolean("'a' ilike '%A'", true);
        f1.checkBoolean("'a' ilike '%a%'", true);
        f1.checkBoolean("'a' ilike '%A%'", true);
        f1.checkBoolean("'a' ilike 'a%'", true);
        f1.checkBoolean("'a' ilike 'A%'", true);
        f1.checkBoolean("'ab'   ilike 'a_'", true);
        f1.checkBoolean("'ab'   ilike 'A_'", true);
        f1.checkBoolean("'abc'  ilike 'a_'", false);
        f1.checkBoolean("'abcd' ilike 'a%'", true);
        f1.checkBoolean("'abcd' ilike 'A%'", true);
        f1.checkBoolean("'ab'   ilike '_b'", true);
        f1.checkBoolean("'ab'   ilike '_B'", true);
        f1.checkBoolean("'abcd' ilike '_d'", false);
        f1.checkBoolean("'abcd' ilike '%d'", true);
        f1.checkBoolean("'abcd' ilike '%D'", true);
        f1.checkBoolean("'ab\ncd' ilike 'ab%'", true);
        f1.checkBoolean("'ab\ncd' ilike 'aB%'", true);
        f1.checkBoolean("'abc\ncd' ilike 'ab%'", true);
        f1.checkBoolean("'abc\ncd' ilike 'Ab%'", true);
        f1.checkBoolean("'123\n\n45\n' ilike '%'", true);
        f1.checkBoolean("'ab\ncd\nef' ilike '%cd%'", true);
        f1.checkBoolean("'ab\ncd\nef' ilike '%CD%'", true);
        f1.checkBoolean("'ab\ncd\nef' ilike '%cde%'", false);
    }

    @Test
    void testLikeDot() {
        SqlOperatorFixture f = this.fixture();
        f.checkBoolean("'abc' like 'a.c'", false);
        f.checkBoolean("'abcde' like '%c.e'", false);
        f.checkBoolean("'abc.e' like '%c.e'", true);
    }

    @Test
    void testIlikeDot() {
        SqlOperatorFixture f = this.fixture().setFor((SqlOperator)SqlLibraryOperators.ILIKE, SqlOperatorFixture.VmName.EXPAND).withLibrary(SqlLibrary.POSTGRESQL);
        f.checkBoolean("'abc' ilike 'a.c'", false);
        f.checkBoolean("'abcde' ilike '%c.e'", false);
        f.checkBoolean("'abc.e' ilike '%c.e'", true);
        f.checkBoolean("'abc.e' ilike '%c.E'", true);
    }

    @Test
    void testNotSimilarToOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.NOT_SIMILAR_TO, VM_EXPAND);
        f.checkBoolean("'ab' not similar to 'a_'", false);
        f.checkBoolean("'aabc' not similar to 'ab*c+d'", true);
        f.checkBoolean("'ab' not similar to 'a' || '_'", false);
        f.checkBoolean("'ab' not similar to 'ba_'", true);
        f.checkBoolean("cast(null as varchar(2)) not similar to 'a_'", null);
        f.checkBoolean("cast(null as varchar(3)) not similar to cast(null as char(2))", null);
    }

    @Test
    void testSimilarToOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.SIMILAR_TO, SqlOperatorFixture.VmName.EXPAND);
        f.checkBoolean("''  similar to ''", true);
        f.checkBoolean("'a' similar to 'a'", true);
        f.checkBoolean("'a' similar to 'b'", false);
        f.checkBoolean("'a' similar to 'A'", false);
        f.checkBoolean("'a' similar to 'a_'", false);
        f.checkBoolean("'a' similar to '_a'", false);
        f.checkBoolean("'a' similar to '%a'", true);
        f.checkBoolean("'a' similar to '%a%'", true);
        f.checkBoolean("'a' similar to 'a%'", true);
        f.checkBoolean("'ab'   similar to 'a_'", true);
        f.checkBoolean("'abc'  similar to 'a_'", false);
        f.checkBoolean("'abcd' similar to 'a%'", true);
        f.checkBoolean("'ab'   similar to '_b'", true);
        f.checkBoolean("'abcd' similar to '_d'", false);
        f.checkBoolean("'abcd' similar to '%d'", true);
        f.checkBoolean("'ab\ncd' similar to 'ab%'", true);
        f.checkBoolean("'abc\ncd' similar to 'ab%'", true);
        f.checkBoolean("'123\n\n45\n' similar to '%'", true);
        f.checkBoolean("'ab\ncd\nef' similar to '%cd%'", true);
        f.checkBoolean("'ab\ncd\nef' similar to '%cde%'", false);
        f.checkBoolean("'acd'    similar to 'ab*c+d'", true);
        f.checkBoolean("'abcd'   similar to 'ab*c+d'", true);
        f.checkBoolean("'acccd'  similar to 'ab*c+d'", true);
        f.checkBoolean("'abcccd' similar to 'ab*c+d'", true);
        f.checkBoolean("'abd'    similar to 'ab*c+d'", false);
        f.checkBoolean("'aabc'   similar to 'ab*c+d'", false);
        f.checkBoolean("'xy'      similar to 'x(ab|c)*y'", true);
        f.checkBoolean("'xccy'    similar to 'x(ab|c)*y'", true);
        f.checkBoolean("'xababcy' similar to 'x(ab|c)*y'", true);
        f.checkBoolean("'xbcy'    similar to 'x(ab|c)*y'", false);
        f.checkBoolean("'xy'      similar to 'x(ab|c)+y'", false);
        f.checkBoolean("'xccy'    similar to 'x(ab|c)+y'", true);
        f.checkBoolean("'xababcy' similar to 'x(ab|c)+y'", true);
        f.checkBoolean("'xbcy'    similar to 'x(ab|c)+y'", false);
        f.checkBoolean("'ab' similar to 'a%' ", true);
        f.checkBoolean("'a' similar to 'a%' ", true);
        f.checkBoolean("'abcd' similar to 'a_' ", false);
        f.checkBoolean("'abcd' similar to 'a%' ", true);
        f.checkBoolean("'1a' similar to '_a' ", true);
        f.checkBoolean("'123aXYZ' similar to '%a%'", true);
        f.checkBoolean("'123aXYZ' similar to '_%_a%_' ", true);
        f.checkBoolean("'xy' similar to '(xy)' ", true);
        f.checkBoolean("'abd' similar to '[ab][bcde]d' ", true);
        f.checkBoolean("'bdd' similar to '[ab][bcde]d' ", true);
        f.checkBoolean("'abd' similar to '[ab]d' ", false);
        f.checkBoolean("'cd' similar to '[a-e]d' ", true);
        f.checkBoolean("'amy' similar to 'amy|fred' ", true);
        f.checkBoolean("'fred' similar to 'amy|fred' ", true);
        f.checkBoolean("'mike' similar to 'amy|fred' ", false);
        f.checkBoolean("'acd' similar to 'ab*c+d' ", true);
        f.checkBoolean("'accccd' similar to 'ab*c+d' ", true);
        f.checkBoolean("'abd' similar to 'ab*c+d' ", false);
        f.checkBoolean("'aabc' similar to 'ab*c+d' ", false);
        f.checkBoolean("'abb' similar to 'a(b{3})' ", false);
        f.checkBoolean("'abbb' similar to 'a(b{3})' ", true);
        f.checkBoolean("'abbbbb' similar to 'a(b{3})' ", false);
        f.checkBoolean("'abbbbb' similar to 'ab{3,6}' ", true);
        f.checkBoolean("'abbbbbbbb' similar to 'ab{3,6}' ", false);
        f.checkBoolean("'' similar to 'ab?' ", false);
        f.checkBoolean("'a' similar to 'ab?' ", true);
        f.checkBoolean("'a' similar to 'a(b?)' ", true);
        f.checkBoolean("'ab' similar to 'ab?' ", true);
        f.checkBoolean("'ab' similar to 'a(b?)' ", true);
        f.checkBoolean("'abb' similar to 'ab?' ", false);
        f.checkBoolean("'ab' similar to 'a\\_' ESCAPE '\\' ", false);
        f.checkBoolean("'ab' similar to 'a\\%' ESCAPE '\\' ", false);
        f.checkBoolean("'a_' similar to 'a\\_' ESCAPE '\\' ", true);
        f.checkBoolean("'a%' similar to 'a\\%' ESCAPE '\\' ", true);
        f.checkBoolean("'a(b{3})' similar to 'a(b{3})' ", false);
        f.checkBoolean("'a(b{3})' similar to 'a\\(b\\{3\\}\\)' ESCAPE '\\' ", true);
        f.checkBoolean("'yd' similar to '[a-ey]d'", true);
        f.checkBoolean("'yd' similar to '[^a-ey]d'", false);
        f.checkBoolean("'yd' similar to '[^a-ex-z]d'", false);
        f.checkBoolean("'yd' similar to '[a-ex-z]d'", true);
        f.checkBoolean("'yd' similar to '[x-za-e]d'", true);
        f.checkBoolean("'yd' similar to '[^a-ey]?d'", false);
        f.checkBoolean("'yyyd' similar to '[a-ey]*d'", true);
        f.checkBoolean("'yd' similar to 'x-zd'", false);
        f.checkBoolean("'y' similar to 'x-z'", false);
        f.checkBoolean("'cd' similar to '([a-e])d'", true);
        f.checkBoolean("'xy' similar to 'x*?y'", true);
        f.checkBoolean("'y' similar to 'x*?y'", true);
        f.checkBoolean("'y' similar to '(x?)*y'", true);
        f.checkBoolean("'y' similar to 'x+?y'", false);
        f.checkBoolean("'y' similar to 'x?+y'", true);
        f.checkBoolean("'y' similar to 'x*+y'", true);
        f.checkBoolean("'abc' similar to 'a.c'", true);
        f.checkBoolean("'a.c' similar to 'a.c'", true);
        f.checkBoolean("'abcd' similar to 'a.*d'", true);
        f.checkBoolean("'abc' like 'a.c'", false);
        f.checkBoolean("'a.c' like 'a.c'", true);
        f.checkBoolean("'abcd' like 'a.*d'", false);
        if (f.brokenTestsEnabled()) {
            f.checkBoolean("'y' similar to 'x+*y'", true);
            f.checkBoolean("'y' similar to 'x?*y'", true);
        }
        f.checkFails("'yd' similar to '[x-ze-a]d'", "Illegal character range near index 6\n\\[x-ze-a\\]d\n      \\^", true);
        String expectedError = TestUtil.getJavaMajorVersion() >= 13 ? "Illegal repetition near index 22\n\\[\\:LOWER\\:\\]\\{2\\}\\[\\:DIGIT\\:\\]\\{,5\\}\n                      \\^" : "Illegal repetition near index 20\n\\[\\:LOWER\\:\\]\\{2\\}\\[\\:DIGIT\\:\\]\\{,5\\}\n                    \\^";
        f.checkFails("'yd3223' similar to '[:LOWER:]{2}[:DIGIT:]{,5}'", expectedError, true);
    }

    @Test
    void testEscapeOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.ESCAPE, VM_EXPAND);
    }

    @Test
    void testConvertFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CONVERT, VM_FENNEL, VM_JAVA);
    }

    @Test
    void testTranslateFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.TRANSLATE, VM_FENNEL, VM_JAVA);
    }

    @Test
    void testTranslate3Func() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlLibraryOperators.TRANSLATE3, new SqlOperatorFixture.VmName[0]);
        f0.checkFails("^translate('aabbcc', 'ab', '+-')^", "No match found for function signature TRANSLATE3\\(<CHARACTER>, <CHARACTER>, <CHARACTER>\\)", false);
        Consumer<SqlOperatorFixture> consumer = f -> {
            f.checkString("translate('aabbcc', 'ab', '+-')", "++--cc", "VARCHAR(6) NOT NULL");
            f.checkString("translate('aabbcc', 'ab', 'ba')", "bbaacc", "VARCHAR(6) NOT NULL");
            f.checkString("translate('aabbcc', 'ab', '')", "cc", "VARCHAR(6) NOT NULL");
            f.checkString("translate('aabbcc', '', '+-')", "aabbcc", "VARCHAR(6) NOT NULL");
            f.checkString("translate(cast('aabbcc' as varchar(10)), 'ab', '+-')", "++--cc", "VARCHAR(10) NOT NULL");
            f.checkNull("translate(cast(null as varchar(7)), 'ab', '+-')");
            f.checkNull("translate('aabbcc', cast(null as varchar(2)), '+-')");
            f.checkNull("translate('aabbcc', 'ab', cast(null as varchar(2)))");
        };
        ImmutableList libraries = ImmutableList.of((Object)SqlLibrary.BIG_QUERY, (Object)SqlLibrary.ORACLE, (Object)SqlLibrary.POSTGRESQL);
        f0.forEachLibrary((Iterable<? extends SqlLibrary>)libraries, consumer);
    }

    @Test
    void testOverlayFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.OVERLAY, SqlOperatorFixture.VmName.EXPAND);
        f.checkString("overlay('ABCdef' placing 'abc' from 1)", "abcdef", "VARCHAR(9) NOT NULL");
        f.checkString("overlay('ABCdef' placing 'abc' from 1 for 2)", "abcCdef", "VARCHAR(9) NOT NULL");
        if (f.brokenTestsEnabled()) {
            f.checkString("overlay(cast('ABCdef' as varchar(10)) placing cast('abc' as char(5)) from 1 for 2)", "abc  Cdef", "VARCHAR(15) NOT NULL");
        }
        if (f.brokenTestsEnabled()) {
            f.checkString("overlay(cast('ABCdef' as char(10)) placing cast('abc' as char(5)) from 1 for 2)", "abc  Cdef    ", "VARCHAR(15) NOT NULL");
        }
        f.checkNull("overlay('ABCdef' placing 'abc' from 1 for cast(null as integer))");
        f.checkNull("overlay(cast(null as varchar(1)) placing 'abc' from 1)");
        f.checkString("overlay(x'ABCdef' placing x'abcd' from 1)", "abcdef", "VARBINARY(5) NOT NULL");
        f.checkString("overlay(x'ABCDEF1234' placing x'2345' from 1 for 2)", "2345ef1234", "VARBINARY(7) NOT NULL");
        if (f.brokenTestsEnabled()) {
            f.checkString("overlay(cast(x'ABCdef' as varbinary(5)) placing cast(x'abcd' as binary(3)) from 1 for 2)", "abc  Cdef", "VARBINARY(8) NOT NULL");
        }
        if (f.brokenTestsEnabled()) {
            f.checkString("overlay(cast(x'ABCdef' as binary(5)) placing cast(x'abcd' as binary(3)) from 1 for 2)", "abc  Cdef    ", "VARBINARY(8) NOT NULL");
        }
        f.checkNull("overlay(x'ABCdef' placing x'abcd' from 1 for cast(null as integer))");
        f.checkNull("overlay(cast(null as varbinary(1)) placing x'abcd' from 1)");
        f.checkNull("overlay(x'abcd' placing x'abcd' from cast(null as integer))");
    }

    @Test
    void testPositionFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.POSITION, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalarExact("position('b' in 'abc')", 2);
        f.checkScalarExact("position('' in 'abc')", 1);
        f.checkScalarExact("position('b' in 'abcabc' FROM 3)", 5);
        f.checkScalarExact("position('b' in 'abcabc' FROM 5)", 5);
        f.checkScalarExact("position('b' in 'abcabc' FROM 6)", 0);
        f.checkScalarExact("position('b' in 'abcabc' FROM -5)", 0);
        f.checkScalarExact("position('' in 'abc' FROM 3)", 3);
        f.checkScalarExact("position('' in 'abc' FROM 10)", 0);
        f.checkScalarExact("position(x'bb' in x'aabbcc')", 2);
        f.checkScalarExact("position(x'' in x'aabbcc')", 1);
        f.checkScalarExact("position(x'bb' in x'aabbccaabbcc' FROM 3)", 5);
        f.checkScalarExact("position(x'bb' in x'aabbccaabbcc' FROM 5)", 5);
        f.checkScalarExact("position(x'bb' in x'aabbccaabbcc' FROM 6)", 0);
        f.checkScalarExact("position(x'bb' in x'aabbccaabbcc' FROM -5)", 0);
        f.checkScalarExact("position(x'cc' in x'aabbccdd' FROM 2)", 3);
        f.checkScalarExact("position(x'' in x'aabbcc' FROM 3)", 3);
        f.checkScalarExact("position(x'' in x'aabbcc' FROM 10)", 0);
        f.checkScalarExact("position('tra' in 'fdgjklewrtra')", 10);
        f.checkNull("position(cast(null as varchar(1)) in '0010')");
        f.checkNull("position('a' in cast(null as varchar(1)))");
        f.checkScalar("position(cast('a' as char) in cast('bca' as varchar))", 3, "INTEGER NOT NULL");
    }

    @Test
    void testReplaceFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.REPLACE, SqlOperatorFixture.VmName.EXPAND);
        f.checkString("REPLACE('ciao', 'ciao', '')", "", "VARCHAR(4) NOT NULL");
        f.checkString("REPLACE('hello world', 'o', '')", "hell wrld", "VARCHAR(11) NOT NULL");
        f.checkNull("REPLACE(cast(null as varchar(5)), 'ciao', '')");
        f.checkNull("REPLACE('ciao', cast(null as varchar(3)), 'zz')");
        f.checkNull("REPLACE('ciao', 'bella', cast(null as varchar(3)))");
    }

    @Test
    void testCharLengthFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CHAR_LENGTH, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalarExact("char_length('abc')", 3);
        f.checkNull("char_length(cast(null as varchar(1)))");
    }

    @Test
    void testCharacterLengthFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CHARACTER_LENGTH, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalarExact("CHARACTER_LENGTH('abc')", 3);
        f.checkNull("CHARACTER_LENGTH(cast(null as varchar(1)))");
    }

    @Test
    void testLengthFunc() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlLibraryOperators.LENGTH, new SqlOperatorFixture.VmName[0]);
        f0.checkFails("^length('hello')^", "No match found for function signature LENGTH\\(<CHARACTER>\\)", false);
        Consumer<SqlOperatorFixture> consumer = f -> {
            f.checkScalar("length('hello')", "5", "INTEGER NOT NULL");
            f.checkScalar("length('')", "0", "INTEGER NOT NULL");
            f.checkScalar("length(CAST('x' as CHAR(3)))", "3", "INTEGER NOT NULL");
            f.checkScalar("length(CAST('x' as VARCHAR(4)))", "1", "INTEGER NOT NULL");
            f.checkNull("length(CAST(NULL as CHAR(5)))");
        };
        f0.forEachLibrary((Iterable<? extends SqlLibrary>)Expressions.list((Object[])new SqlLibrary[]{SqlLibrary.BIG_QUERY}), consumer);
    }

    @Test
    void testOctetLengthFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.OCTET_LENGTH, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalarExact("OCTET_LENGTH(x'aabbcc')", 3);
        f.checkNull("OCTET_LENGTH(cast(null as varbinary(1)))");
    }

    @Test
    void testAsciiFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.ASCII, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalarExact("ASCII('')", 0);
        f.checkScalarExact("ASCII('a')", 97);
        f.checkScalarExact("ASCII('1')", 49);
        f.checkScalarExact("ASCII('abc')", 97);
        f.checkScalarExact("ASCII('ABC')", 65);
        f.checkScalarExact("ASCII(_UTF8'\u0082')", 130);
        f.checkScalarExact("ASCII(_UTF8'\u5b57')", 23383);
        f.checkScalarExact("ASCII(_UTF8'\u03a9')", 937);
        f.checkNull("ASCII(cast(null as varchar(1)))");
    }

    @Test
    void testToBase64() {
        SqlOperatorFixture f = this.fixture().withLibrary(SqlLibrary.MYSQL);
        f.setFor((SqlOperator)SqlLibraryOperators.TO_BASE64, new SqlOperatorFixture.VmName[0]);
        f.checkString("to_base64(x'546869732069732061207465737420537472696e672e')", "VGhpcyBpcyBhIHRlc3QgU3RyaW5nLg==", "VARCHAR NOT NULL");
        f.checkString("to_base64(x'546869732069732061207465737420537472696e672e20636865636b20726573756c7465206f7574206f66203736546869732069732061207465737420537472696e672e546869732069732061207465737420537472696e672e546869732069732061207465737420537472696e672e546869732069732061207465737420537472696e672e546869732069732061207465737420537472696e672e20546869732069732061207465737420537472696e672e20636865636b20726573756c7465206f7574206f66203736546869732069732061207465737420537472696e672e546869732069732061207465737420537472696e672e546869732069732061207465737420537472696e672e546869732069732061207465737420537472696e672e546869732069732061207465737420537472696e672e20546869732069732061207465737420537472696e672e20636865636b20726573756c7465206f7574206f66203736546869732069732061207465737420537472696e672e546869732069732061207465737420537472696e672e546869732069732061207465737420537472696e672e546869732069732061207465737420537472696e672e546869732069732061207465737420537472696e672e')", "VGhpcyBpcyBhIHRlc3QgU3RyaW5nLiBjaGVjayByZXN1bHRlIG91dCBvZiA3NlRoaXMgaXMgYSB0\nZXN0IFN0cmluZy5UaGlzIGlzIGEgdGVzdCBTdHJpbmcuVGhpcyBpcyBhIHRlc3QgU3RyaW5nLlRo\naXMgaXMgYSB0ZXN0IFN0cmluZy5UaGlzIGlzIGEgdGVzdCBTdHJpbmcuIFRoaXMgaXMgYSB0ZXN0\nIFN0cmluZy4gY2hlY2sgcmVzdWx0ZSBvdXQgb2YgNzZUaGlzIGlzIGEgdGVzdCBTdHJpbmcuVGhp\ncyBpcyBhIHRlc3QgU3RyaW5nLlRoaXMgaXMgYSB0ZXN0IFN0cmluZy5UaGlzIGlzIGEgdGVzdCBT\ndHJpbmcuVGhpcyBpcyBhIHRlc3QgU3RyaW5nLiBUaGlzIGlzIGEgdGVzdCBTdHJpbmcuIGNoZWNr\nIHJlc3VsdGUgb3V0IG9mIDc2VGhpcyBpcyBhIHRlc3QgU3RyaW5nLlRoaXMgaXMgYSB0ZXN0IFN0\ncmluZy5UaGlzIGlzIGEgdGVzdCBTdHJpbmcuVGhpcyBpcyBhIHRlc3QgU3RyaW5nLlRoaXMgaXMg\nYSB0ZXN0IFN0cmluZy4=", "VARCHAR NOT NULL");
        f.checkString("to_base64('This is a test String.')", "VGhpcyBpcyBhIHRlc3QgU3RyaW5nLg==", "VARCHAR NOT NULL");
        f.checkString("to_base64('This is a test String. check resulte out of 76This is a test String.This is a test String.This is a test String.This is a test String.This is a test String. This is a test String. check resulte out of 76This is a test String.This is a test String.This is a test String.This is a test String.This is a test String. This is a test String. check resulte out of 76This is a test String.This is a test String.This is a test String.This is a test String.This is a test String.')", "VGhpcyBpcyBhIHRlc3QgU3RyaW5nLiBjaGVjayByZXN1bHRlIG91dCBvZiA3NlRoaXMgaXMgYSB0\nZXN0IFN0cmluZy5UaGlzIGlzIGEgdGVzdCBTdHJpbmcuVGhpcyBpcyBhIHRlc3QgU3RyaW5nLlRo\naXMgaXMgYSB0ZXN0IFN0cmluZy5UaGlzIGlzIGEgdGVzdCBTdHJpbmcuIFRoaXMgaXMgYSB0ZXN0\nIFN0cmluZy4gY2hlY2sgcmVzdWx0ZSBvdXQgb2YgNzZUaGlzIGlzIGEgdGVzdCBTdHJpbmcuVGhp\ncyBpcyBhIHRlc3QgU3RyaW5nLlRoaXMgaXMgYSB0ZXN0IFN0cmluZy5UaGlzIGlzIGEgdGVzdCBT\ndHJpbmcuVGhpcyBpcyBhIHRlc3QgU3RyaW5nLiBUaGlzIGlzIGEgdGVzdCBTdHJpbmcuIGNoZWNr\nIHJlc3VsdGUgb3V0IG9mIDc2VGhpcyBpcyBhIHRlc3QgU3RyaW5nLlRoaXMgaXMgYSB0ZXN0IFN0\ncmluZy5UaGlzIGlzIGEgdGVzdCBTdHJpbmcuVGhpcyBpcyBhIHRlc3QgU3RyaW5nLlRoaXMgaXMg\nYSB0ZXN0IFN0cmluZy4=", "VARCHAR NOT NULL");
        f.checkString("to_base64('')", "", "VARCHAR NOT NULL");
        f.checkString("to_base64('a')", "YQ==", "VARCHAR NOT NULL");
        f.checkString("to_base64(x'61')", "YQ==", "VARCHAR NOT NULL");
    }

    @Test
    void testFromBase64() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlLibraryOperators.FROM_BASE64, new SqlOperatorFixture.VmName[0]);
        f0.checkFails("^from_base64('2fjoeiwjfoj==')^", "No match found for function signature FROM_BASE64\\(<CHARACTER>\\)", false);
        Consumer<SqlOperatorFixture> consumer = f -> {
            f.checkString("from_base64('VGhpcyBpcyBhIHRlc3QgU3RyaW5nLg==')", "546869732069732061207465737420537472696e672e", "VARBINARY NOT NULL");
            f.checkString("from_base64('VGhpcyBpcyBhIHRlc\t3QgU3RyaW5nLg==')", "546869732069732061207465737420537472696e672e", "VARBINARY NOT NULL");
            f.checkString("from_base64('VGhpcyBpcyBhIHRlc\t3QgU3\nRyaW5nLg==')", "546869732069732061207465737420537472696e672e", "VARBINARY NOT NULL");
            f.checkString("from_base64('VGhpcyB  pcyBhIHRlc3Qg\tU3Ry\naW5nLg==')", "546869732069732061207465737420537472696e672e", "VARBINARY NOT NULL");
            f.checkNull("from_base64('-1')");
            f.checkNull("from_base64('-100')");
        };
        f0.forEachLibrary((Iterable<? extends SqlLibrary>)Expressions.list((Object[])new SqlLibrary[]{SqlLibrary.BIG_QUERY, SqlLibrary.MYSQL}), consumer);
    }

    @Test
    void testMd5() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlLibraryOperators.MD5, new SqlOperatorFixture.VmName[0]);
        f0.checkFails("^md5(x'')^", "No match found for function signature MD5\\(<BINARY>\\)", false);
        ImmutableList libraries = ImmutableList.of((Object)SqlLibrary.BIG_QUERY, (Object)SqlLibrary.MYSQL, (Object)SqlLibrary.POSTGRESQL);
        Consumer<SqlOperatorFixture> consumer = f -> {
            f.checkString("md5(x'')", "d41d8cd98f00b204e9800998ecf8427e", "VARCHAR NOT NULL");
            f.checkString("md5('')", "d41d8cd98f00b204e9800998ecf8427e", "VARCHAR NOT NULL");
            f.checkString("md5('ABC')", "902fbdd2b1df0c4f70b4a5d23525e932", "VARCHAR NOT NULL");
            f.checkString("md5(x'414243')", "902fbdd2b1df0c4f70b4a5d23525e932", "VARCHAR NOT NULL");
        };
        f0.forEachLibrary((Iterable<? extends SqlLibrary>)libraries, consumer);
    }

    @Test
    void testSha1() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlLibraryOperators.SHA1, new SqlOperatorFixture.VmName[0]);
        f0.checkFails("^sha1(x'')^", "No match found for function signature SHA1\\(<BINARY>\\)", false);
        ImmutableList libraries = ImmutableList.of((Object)SqlLibrary.BIG_QUERY, (Object)SqlLibrary.MYSQL, (Object)SqlLibrary.POSTGRESQL);
        Consumer<SqlOperatorFixture> consumer = f -> {
            f.checkString("sha1(x'')", "da39a3ee5e6b4b0d3255bfef95601890afd80709", "VARCHAR NOT NULL");
            f.checkString("sha1('')", "da39a3ee5e6b4b0d3255bfef95601890afd80709", "VARCHAR NOT NULL");
            f.checkString("sha1('ABC')", "3c01bdbb26f358bab27f267924aa2c9a03fcfdb8", "VARCHAR NOT NULL");
            f.checkString("sha1(x'414243')", "3c01bdbb26f358bab27f267924aa2c9a03fcfdb8", "VARCHAR NOT NULL");
        };
        f0.forEachLibrary((Iterable<? extends SqlLibrary>)libraries, consumer);
    }

    @Test
    void testRepeatFunc() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlLibraryOperators.REPEAT, new SqlOperatorFixture.VmName[0]);
        f0.checkFails("^repeat('a', -100)^", "No match found for function signature REPEAT\\(<CHARACTER>, <NUMERIC>\\)", false);
        Consumer<SqlOperatorFixture> consumer = f -> {
            f.checkString("REPEAT('a', -100)", "", "VARCHAR(1) NOT NULL");
            f.checkString("REPEAT('a', -1)", "", "VARCHAR(1) NOT NULL");
            f.checkString("REPEAT('a', 0)", "", "VARCHAR(1) NOT NULL");
            f.checkString("REPEAT('a', 2)", "aa", "VARCHAR(1) NOT NULL");
            f.checkString("REPEAT('abc', 3)", "abcabcabc", "VARCHAR(3) NOT NULL");
            f.checkNull("REPEAT(cast(null as varchar(1)), -1)");
            f.checkNull("REPEAT(cast(null as varchar(1)), 2)");
            f.checkNull("REPEAT('abc', cast(null as integer))");
            f.checkNull("REPEAT(cast(null as varchar(1)), cast(null as integer))");
        };
        f0.forEachLibrary((Iterable<? extends SqlLibrary>)Expressions.list((Object[])new SqlLibrary[]{SqlLibrary.BIG_QUERY, SqlLibrary.MYSQL}), consumer);
    }

    @Test
    void testSpaceFunc() {
        SqlOperatorFixture f = this.fixture().setFor((SqlOperator)SqlLibraryOperators.SPACE, new SqlOperatorFixture.VmName[0]).withLibrary(SqlLibrary.MYSQL);
        f.checkString("SPACE(-100)", "", "VARCHAR(2000) NOT NULL");
        f.checkString("SPACE(-1)", "", "VARCHAR(2000) NOT NULL");
        f.checkString("SPACE(0)", "", "VARCHAR(2000) NOT NULL");
        f.checkString("SPACE(2)", "  ", "VARCHAR(2000) NOT NULL");
        f.checkString("SPACE(5)", "     ", "VARCHAR(2000) NOT NULL");
        f.checkNull("SPACE(cast(null as integer))");
    }

    @Test
    void testStrcmpFunc() {
        SqlOperatorFixture f = this.fixture().setFor((SqlOperator)SqlLibraryOperators.STRCMP, new SqlOperatorFixture.VmName[0]).withLibrary(SqlLibrary.MYSQL);
        f.checkString("STRCMP('mytesttext', 'mytesttext')", "0", "INTEGER NOT NULL");
        f.checkString("STRCMP('mytesttext', 'mytest_text')", "-1", "INTEGER NOT NULL");
        f.checkString("STRCMP('mytest_text', 'mytesttext')", "1", "INTEGER NOT NULL");
        f.checkNull("STRCMP('mytesttext', cast(null as varchar(1)))");
        f.checkNull("STRCMP(cast(null as varchar(1)), 'mytesttext')");
    }

    @Test
    void testSoundexFunc() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlLibraryOperators.SOUNDEX, new SqlOperatorFixture.VmName[0]);
        f0.checkFails("^soundex('tech on the net')^", "No match found for function signature SOUNDEX\\(<CHARACTER>\\)", false);
        ImmutableList libraries = ImmutableList.of((Object)SqlLibrary.BIG_QUERY, (Object)SqlLibrary.MYSQL, (Object)SqlLibrary.ORACLE, (Object)SqlLibrary.POSTGRESQL);
        Consumer<SqlOperatorFixture> consumer = f -> {
            f.checkString("SOUNDEX('TECH ON THE NET')", "T253", "VARCHAR(4) NOT NULL");
            f.checkString("SOUNDEX('Miller')", "M460", "VARCHAR(4) NOT NULL");
            f.checkString("SOUNDEX('miler')", "M460", "VARCHAR(4) NOT NULL");
            f.checkString("SOUNDEX('myller')", "M460", "VARCHAR(4) NOT NULL");
            f.checkString("SOUNDEX('muller')", "M460", "VARCHAR(4) NOT NULL");
            f.checkString("SOUNDEX('m')", "M000", "VARCHAR(4) NOT NULL");
            f.checkString("SOUNDEX('mu')", "M000", "VARCHAR(4) NOT NULL");
            f.checkString("SOUNDEX('mile')", "M400", "VARCHAR(4) NOT NULL");
            f.checkNull("SOUNDEX(cast(null as varchar(1)))");
            f.checkFails("SOUNDEX(_UTF8'\u5b57\u5b57')", "The character is not mapped.*", true);
        };
        f0.forEachLibrary((Iterable<? extends SqlLibrary>)libraries, consumer);
    }

    @Test
    void testDifferenceFunc() {
        SqlOperatorFixture f = this.fixture().setFor((SqlOperator)SqlLibraryOperators.DIFFERENCE, new SqlOperatorFixture.VmName[0]).withLibrary(SqlLibrary.POSTGRESQL);
        f.checkScalarExact("DIFFERENCE('Miller', 'miller')", 4);
        f.checkScalarExact("DIFFERENCE('Miller', 'myller')", 4);
        f.checkScalarExact("DIFFERENCE('muller', 'miller')", 4);
        f.checkScalarExact("DIFFERENCE('muller', 'miller')", 4);
        f.checkScalarExact("DIFFERENCE('muller', 'milk')", 2);
        f.checkScalarExact("DIFFERENCE('muller', 'mile')", 2);
        f.checkScalarExact("DIFFERENCE('muller', 'm')", 1);
        f.checkScalarExact("DIFFERENCE('muller', 'lee')", 0);
        f.checkNull("DIFFERENCE('muller', cast(null as varchar(1)))");
        f.checkNull("DIFFERENCE(cast(null as varchar(1)), 'muller')");
    }

    @Test
    void testReverseFunc() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlLibraryOperators.REVERSE, new SqlOperatorFixture.VmName[0]);
        f0.checkFails("^reverse('abc')^", "No match found for function signature REVERSE\\(<CHARACTER>\\)", false);
        Consumer<SqlOperatorFixture> consumer = f -> {
            f.checkString("reverse('')", "", "VARCHAR(0) NOT NULL");
            f.checkString("reverse('123')", "321", "VARCHAR(3) NOT NULL");
            f.checkString("reverse('abc')", "cba", "VARCHAR(3) NOT NULL");
            f.checkString("reverse('ABC')", "CBA", "VARCHAR(3) NOT NULL");
            f.checkString("reverse('Hello World')", "dlroW olleH", "VARCHAR(11) NOT NULL");
            f.checkString("reverse(_UTF8'\u4f60\u597d')", "\u597d\u4f60", "VARCHAR(2) NOT NULL");
            f.checkNull("reverse(cast(null as varchar(1)))");
        };
        f0.forEachLibrary((Iterable<? extends SqlLibrary>)Expressions.list((Object[])new SqlLibrary[]{SqlLibrary.BIG_QUERY, SqlLibrary.MYSQL}), consumer);
    }

    @Test
    void testIfFunc() {
        SqlOperatorFixture f = this.fixture();
        SqlOperatorTest.checkIf(f.withLibrary(SqlLibrary.BIG_QUERY));
        SqlOperatorTest.checkIf(f.withLibrary(SqlLibrary.HIVE));
        SqlOperatorTest.checkIf(f.withLibrary(SqlLibrary.SPARK));
    }

    private static void checkIf(SqlOperatorFixture f) {
        f.setFor((SqlOperator)SqlLibraryOperators.IF, new SqlOperatorFixture.VmName[0]);
        f.checkString("if(1 = 2, 1, 2)", "2", "INTEGER NOT NULL");
        f.checkString("if('abc'='xyz', 'abc', 'xyz')", "xyz", "CHAR(3) NOT NULL");
        f.checkString("if(substring('abc',1,2)='ab', 'abc', 'xyz')", "abc", "CHAR(3) NOT NULL");
        f.checkString("if(substring('abc',1,2)='ab', 'abc', 'wxyz')", "abc ", "CHAR(4) NOT NULL");
        f.checkScalar("if(nullif(true,false), 5, 10)", 5, "INTEGER NOT NULL");
        f.checkScalar("if(nullif(true,true), 5, 10)", 10, "INTEGER NOT NULL");
        f.checkScalar("if(nullif(true,true), 5, 10)", 10, "INTEGER NOT NULL");
    }

    @Test
    void testUpperFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.UPPER, SqlOperatorFixture.VmName.EXPAND);
        f.checkString("upper('a')", "A", "CHAR(1) NOT NULL");
        f.checkString("upper('A')", "A", "CHAR(1) NOT NULL");
        f.checkString("upper('1')", "1", "CHAR(1) NOT NULL");
        f.checkString("upper('aa')", "AA", "CHAR(2) NOT NULL");
        f.checkNull("upper(cast(null as varchar(1)))");
    }

    @Test
    void testLeftFunc() {
        SqlOperatorFixture f0 = this.fixture();
        Consumer<SqlOperatorFixture> consumer = f -> {
            f.setFor((SqlOperator)SqlLibraryOperators.LEFT, new SqlOperatorFixture.VmName[0]);
            f.checkString("left('abcd', 3)", "abc", "VARCHAR(4) NOT NULL");
            f.checkString("left('abcd', 0)", "", "VARCHAR(4) NOT NULL");
            f.checkString("left('abcd', 5)", "abcd", "VARCHAR(4) NOT NULL");
            f.checkString("left('abcd', -2)", "", "VARCHAR(4) NOT NULL");
            f.checkNull("left(cast(null as varchar(1)), -2)");
            f.checkNull("left('abcd', cast(null as Integer))");
            f.checkString("left(x'ABCdef', 1)", "ab", "VARBINARY(3) NOT NULL");
            f.checkString("left(x'ABCdef', 0)", "", "VARBINARY(3) NOT NULL");
            f.checkString("left(x'ABCdef', 4)", "abcdef", "VARBINARY(3) NOT NULL");
            f.checkString("left(x'ABCdef', -2)", "", "VARBINARY(3) NOT NULL");
            f.checkNull("left(cast(null as binary(1)), -2)");
            f.checkNull("left(x'ABCdef', cast(null as Integer))");
        };
        f0.forEachLibrary((Iterable<? extends SqlLibrary>)Expressions.list((Object[])new SqlLibrary[]{SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL}), consumer);
    }

    @Test
    void testRightFunc() {
        SqlOperatorFixture f0 = this.fixture();
        Consumer<SqlOperatorFixture> consumer = f -> {
            f.setFor((SqlOperator)SqlLibraryOperators.RIGHT, new SqlOperatorFixture.VmName[0]);
            f.checkString("right('abcd', 3)", "bcd", "VARCHAR(4) NOT NULL");
            f.checkString("right('abcd', 0)", "", "VARCHAR(4) NOT NULL");
            f.checkString("right('abcd', 5)", "abcd", "VARCHAR(4) NOT NULL");
            f.checkString("right('abcd', -2)", "", "VARCHAR(4) NOT NULL");
            f.checkNull("right(cast(null as varchar(1)), -2)");
            f.checkNull("right('abcd', cast(null as Integer))");
            f.checkString("right(x'ABCdef', 1)", "ef", "VARBINARY(3) NOT NULL");
            f.checkString("right(x'ABCdef', 0)", "", "VARBINARY(3) NOT NULL");
            f.checkString("right(x'ABCdef', 4)", "abcdef", "VARBINARY(3) NOT NULL");
            f.checkString("right(x'ABCdef', -2)", "", "VARBINARY(3) NOT NULL");
            f.checkNull("right(cast(null as binary(1)), -2)");
            f.checkNull("right(x'ABCdef', cast(null as Integer))");
        };
        f0.forEachLibrary((Iterable<? extends SqlLibrary>)Expressions.list((Object[])new SqlLibrary[]{SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL}), consumer);
    }

    @Test
    void testRegexpReplaceFunc() {
        SqlOperatorFixture f0 = this.fixture();
        Consumer<SqlOperatorFixture> consumer = f -> {
            f.setFor((SqlOperator)SqlLibraryOperators.REGEXP_REPLACE, new SqlOperatorFixture.VmName[0]);
            f.checkString("regexp_replace('a b c', 'b', 'X')", "a X c", "VARCHAR NOT NULL");
            f.checkString("regexp_replace('abc def ghi', '[a-z]+', 'X')", "X X X", "VARCHAR NOT NULL");
            f.checkString("regexp_replace('100-200', '(\\d+)', 'num')", "num-num", "VARCHAR NOT NULL");
            f.checkString("regexp_replace('100-200', '(-)', '###')", "100###200", "VARCHAR NOT NULL");
            f.checkNull("regexp_replace(cast(null as varchar), '(-)', '###')");
            f.checkNull("regexp_replace('100-200', cast(null as varchar), '###')");
            f.checkNull("regexp_replace('100-200', '(-)', cast(null as varchar))");
            f.checkString("regexp_replace('abc def ghi', '[a-z]+', 'X', 2)", "aX X X", "VARCHAR NOT NULL");
            f.checkString("regexp_replace('abc def ghi', '[a-z]+', 'X', 1, 3)", "abc def X", "VARCHAR NOT NULL");
            f.checkString("regexp_replace('abc def GHI', '[a-z]+', 'X', 1, 3, 'c')", "abc def GHI", "VARCHAR NOT NULL");
            f.checkString("regexp_replace('abc def GHI', '[a-z]+', 'X', 1, 3, 'i')", "abc def X", "VARCHAR NOT NULL");
            f.checkString("regexp_replace('abc def GHI', '[a-z]+', 'X', 1, 3, 'i')", "abc def X", "VARCHAR NOT NULL");
            f.checkString("regexp_replace('abc\t\ndef\t\nghi', '\t', '+')", "abc+\ndef+\nghi", "VARCHAR NOT NULL");
            f.checkString("regexp_replace('abc\t\ndef\t\nghi', '\t\n', '+')", "abc+def+ghi", "VARCHAR NOT NULL");
            f.checkString("regexp_replace('abc\t\ndef\t\nghi', '\\w+', '+')", "+\t\n+\t\n+", "VARCHAR NOT NULL");
            f.checkQuery("select regexp_replace('a b c', 'b', 'X')");
            f.checkQuery("select regexp_replace('a b c', 'b', 'X', 1)");
            f.checkQuery("select regexp_replace('a b c', 'b', 'X', 1, 3)");
            f.checkQuery("select regexp_replace('a b c', 'b', 'X', 1, 3, 'i')");
        };
        f0.forEachLibrary((Iterable<? extends SqlLibrary>)Expressions.list((Object[])new SqlLibrary[]{SqlLibrary.MYSQL, SqlLibrary.ORACLE}), consumer);
    }

    @Test
    void testJsonExists() {
        SqlOperatorFixture f = this.fixture();
        f.checkBoolean("json_exists('{\"foo\":\"bar\"}', '$.foo')", true);
        f.checkBoolean("json_exists('{\"foo\":\"bar\"}', 'strict $.foo' false on error)", true);
        f.checkBoolean("json_exists('{\"foo\":\"bar\"}', 'strict $.foo' true on error)", true);
        f.checkBoolean("json_exists('{\"foo\":\"bar\"}', 'strict $.foo' unknown on error)", true);
        f.checkBoolean("json_exists('{\"foo\":\"bar\"}', 'lax $.foo' false on error)", true);
        f.checkBoolean("json_exists('{\"foo\":\"bar\"}', 'lax $.foo' true on error)", true);
        f.checkBoolean("json_exists('{\"foo\":\"bar\"}', 'lax $.foo' unknown on error)", true);
        f.checkBoolean("json_exists('{}', 'invalid $.foo' false on error)", false);
        f.checkBoolean("json_exists('{}', 'invalid $.foo' true on error)", true);
        f.checkBoolean("json_exists('{}', 'invalid $.foo' unknown on error)", null);
        f.checkBoolean("json_exists('{\"foo\":\"bar\"}', 'strict $.foo1' false on error)", false);
        f.checkBoolean("json_exists('{\"foo\":\"bar\"}', 'strict $.foo1' true on error)", true);
        f.checkBoolean("json_exists('{\"foo\":\"bar\"}', 'strict $.foo1' unknown on error)", null);
        f.checkBoolean("json_exists('{\"foo\":\"bar\"}', 'lax $.foo1' true on error)", false);
        f.checkBoolean("json_exists('{\"foo\":\"bar\"}', 'lax $.foo1' false on error)", false);
        f.checkBoolean("json_exists('{\"foo\":\"bar\"}', 'lax $.foo1' error on error)", false);
        f.checkBoolean("json_exists('{\"foo\":\"bar\"}', 'lax $.foo1' unknown on error)", false);
        f.enableTypeCoercion(false).checkFails("json_exists(^null^, 'lax $' unknown on error)", "(?s).*Illegal use of 'NULL'.*", false);
        f.checkString("json_exists(null, 'lax $' unknown on error)", null, "BOOLEAN");
        f.checkNull("json_exists(cast(null as varchar), 'lax $.foo1' unknown on error)");
    }

    @Test
    public void testJsonInsert() {
        SqlOperatorFixture f = this.fixture().withLibrary(SqlLibrary.MYSQL);
        f.checkString("json_insert('10', '$.a', 10, '$.c', '[true]')", "10", "VARCHAR(2000)");
        f.checkString("json_insert('{ \"a\": 1, \"b\": [2]}', '$.a', 10, '$.c', '[true]')", "{\"a\":1,\"b\":[2],\"c\":\"[true]\"}", "VARCHAR(2000)");
        f.checkString("json_insert('{ \"a\": 1, \"b\": [2]}', '$', 10, '$', '[true]')", "{\"a\":1,\"b\":[2]}", "VARCHAR(2000)");
        f.checkString("json_insert('{ \"a\": 1, \"b\": [2]}', '$.b[1]', 10)", "{\"a\":1,\"b\":[2,10]}", "VARCHAR(2000)");
        f.checkString("json_insert('{\"a\": 1, \"b\": [2, 3, [true]]}', '$.b[3]', 'false')", "{\"a\":1,\"b\":[2,3,[true],\"false\"]}", "VARCHAR(2000)");
        f.checkFails("json_insert('{\"a\": 1, \"b\": [2, 3, [true]]}', 'a', 'false')", "(?s).*Invalid input for.*", true);
        f.checkNull("json_insert(cast(null as varchar), '$', 10)");
    }

    @Test
    public void testJsonReplace() {
        SqlOperatorFixture f = this.fixture().withLibrary(SqlLibrary.MYSQL);
        f.checkString("json_replace('10', '$.a', 10, '$.c', '[true]')", "10", "VARCHAR(2000)");
        f.checkString("json_replace('{ \"a\": 1, \"b\": [2]}', '$.a', 10, '$.c', '[true]')", "{\"a\":10,\"b\":[2]}", "VARCHAR(2000)");
        f.checkString("json_replace('{ \"a\": 1, \"b\": [2]}', '$', 10, '$.c', '[true]')", "10", "VARCHAR(2000)");
        f.checkString("json_replace('{ \"a\": 1, \"b\": [2]}', '$.b', 10, '$.c', '[true]')", "{\"a\":1,\"b\":10}", "VARCHAR(2000)");
        f.checkString("json_replace('{ \"a\": 1, \"b\": [2, 3]}', '$.b[1]', 10)", "{\"a\":1,\"b\":[2,10]}", "VARCHAR(2000)");
        f.checkFails("json_replace('{\"a\": 1, \"b\": [2, 3, [true]]}', 'a', 'false')", "(?s).*Invalid input for.*", true);
        f.checkNull("json_replace(cast(null as varchar), '$', 10)");
    }

    @Test
    public void testJsonSet() {
        SqlOperatorFixture f = this.fixture().withLibrary(SqlLibrary.MYSQL);
        f.checkString("json_set('10', '$.a', 10, '$.c', '[true]')", "10", "VARCHAR(2000)");
        f.checkString("json_set('{ \"a\": 1, \"b\": [2]}', '$.a', 10, '$.c', '[true]')", "{\"a\":10,\"b\":[2],\"c\":\"[true]\"}", "VARCHAR(2000)");
        f.checkString("json_set('{ \"a\": 1, \"b\": [2]}', '$', 10, '$.c', '[true]')", "10", "VARCHAR(2000)");
        f.checkString("json_set('{ \"a\": 1, \"b\": [2, 3]}', '$.b[1]', 10, '$.c', '[true]')", "{\"a\":1,\"b\":[2,10],\"c\":\"[true]\"}", "VARCHAR(2000)");
        f.checkFails("json_set('{\"a\": 1, \"b\": [2, 3, [true]]}', 'a', 'false')", "(?s).*Invalid input for.*", true);
        f.checkNull("json_set(cast(null as varchar), '$', 10)");
    }

    @Test
    void testJsonValue() {
        SqlOperatorFixture f = this.fixture();
        f.checkString("json_value('{\"foo\":100}', '$.foo')", "100", "VARCHAR(2000)");
        f.checkString("json_value('{\"foo\":100}', 'strict $.foo')", "100", "VARCHAR(2000)");
        f.checkScalar("json_value('{\"foo\":100}', 'strict $.foo' returning integer)", 100, "INTEGER");
        f.checkFails("json_value('{\"foo\":\"100\"}', 'strict $.foo' returning boolean)", SqlOperatorFixture.INVALID_CHAR_MESSAGE, true);
        f.checkScalar("json_value('{\"foo\":100}', 'lax $.foo1' returning integer null on empty)", ResultCheckers.isNullValue(), "INTEGER");
        f.checkScalar("json_value('{\"foo\":\"100\"}', 'strict $.foo1' returning boolean null on error)", ResultCheckers.isNullValue(), "BOOLEAN");
        f.checkString("json_value('{\"foo\":100}', 'lax $.foo' null on empty)", "100", "VARCHAR(2000)");
        f.checkString("json_value('{\"foo\":100}', 'lax $.foo' error on empty)", "100", "VARCHAR(2000)");
        f.checkString("json_value('{\"foo\":100}', 'lax $.foo' default 'empty' on empty)", "100", "VARCHAR(2000)");
        f.checkString("json_value('{\"foo\":100}', 'lax $.foo1' null on empty)", null, "VARCHAR(2000)");
        f.checkFails("json_value('{\"foo\":100}', 'lax $.foo1' error on empty)", "(?s).*Empty result of JSON_VALUE function is not allowed.*", true);
        f.checkString("json_value('{\"foo\":100}', 'lax $.foo1' default 'empty' on empty)", "empty", "VARCHAR(2000)");
        f.checkString("json_value('{\"foo\":{}}', 'lax $.foo' null on empty)", null, "VARCHAR(2000)");
        f.checkFails("json_value('{\"foo\":{}}', 'lax $.foo' error on empty)", "(?s).*Empty result of JSON_VALUE function is not allowed.*", true);
        f.checkString("json_value('{\"foo\":{}}', 'lax $.foo' default 'empty' on empty)", "empty", "VARCHAR(2000)");
        f.checkString("json_value('{\"foo\":100}', 'lax $.foo' null on error)", "100", "VARCHAR(2000)");
        f.checkString("json_value('{\"foo\":100}', 'lax $.foo' error on error)", "100", "VARCHAR(2000)");
        f.checkString("json_value('{\"foo\":100}', 'lax $.foo' default 'empty' on error)", "100", "VARCHAR(2000)");
        f.checkString("json_value('{\"foo\":100}', 'invalid $.foo' null on error)", null, "VARCHAR(2000)");
        f.checkFails("json_value('{\"foo\":100}', 'invalid $.foo' error on error)", "(?s).*Illegal jsonpath spec.*", true);
        f.checkString("json_value('{\"foo\":100}', 'invalid $.foo' default 'empty' on error)", "empty", "VARCHAR(2000)");
        f.checkString("json_value('{\"foo\":100}', 'strict $.foo' null on empty)", "100", "VARCHAR(2000)");
        f.checkString("json_value('{\"foo\":100}', 'strict $.foo' error on empty)", "100", "VARCHAR(2000)");
        f.checkString("json_value('{\"foo\":100}', 'strict $.foo' default 'empty' on empty)", "100", "VARCHAR(2000)");
        f.checkString("json_value('{\"foo\":100}', 'strict $.foo1' null on error)", null, "VARCHAR(2000)");
        f.checkFails("json_value('{\"foo\":100}', 'strict $.foo1' error on error)", "(?s).*No results for path: \\$\\['foo1'\\].*", true);
        f.checkString("json_value('{\"foo\":100}', 'strict $.foo1' default 'empty' on error)", "empty", "VARCHAR(2000)");
        f.checkString("json_value('{\"foo\":{}}', 'strict $.foo' null on error)", null, "VARCHAR(2000)");
        f.checkFails("json_value('{\"foo\":{}}', 'strict $.foo' error on error)", "(?s).*Strict jsonpath mode requires scalar value, and the actual value is: '\\{\\}'.*", true);
        f.checkString("json_value('{\"foo\":{}}', 'strict $.foo' default 'empty' on error)", "empty", "VARCHAR(2000)");
        f.enableTypeCoercion(false).checkFails("json_value(^null^, 'strict $')", "(?s).*Illegal use of 'NULL'.*", false);
        f.checkString("json_value(null, 'strict $')", null, "VARCHAR(2000)");
        f.checkNull("json_value(cast(null as varchar), 'strict $')");
    }

    @Test
    void testJsonQuery() {
        SqlOperatorFixture f = this.fixture();
        f.checkString("json_query('{\"foo\":100}', '$' null on empty)", "{\"foo\":100}", "VARCHAR(2000)");
        f.checkString("json_query('{\"foo\":100}', 'lax $' null on empty)", "{\"foo\":100}", "VARCHAR(2000)");
        f.checkString("json_query('{\"foo\":100}', 'lax $' error on empty)", "{\"foo\":100}", "VARCHAR(2000)");
        f.checkString("json_query('{\"foo\":100}', 'lax $' empty array on empty)", "{\"foo\":100}", "VARCHAR(2000)");
        f.checkString("json_query('{\"foo\":100}', 'lax $' empty object on empty)", "{\"foo\":100}", "VARCHAR(2000)");
        f.checkString("json_query('{\"foo\":100}', 'lax $.foo' null on empty)", null, "VARCHAR(2000)");
        f.checkFails("json_query('{\"foo\":100}', 'lax $.foo' error on empty)", "(?s).*Empty result of JSON_QUERY function is not allowed.*", true);
        f.checkString("json_query('{\"foo\":100}', 'lax $.foo' empty array on empty)", "[]", "VARCHAR(2000)");
        f.checkString("json_query('{\"foo\":100}', 'lax $.foo' empty object on empty)", "{}", "VARCHAR(2000)");
        f.checkString("json_query('{\"foo\":100}', 'invalid $.foo' null on error)", null, "VARCHAR(2000)");
        f.checkFails("json_query('{\"foo\":100}', 'invalid $.foo' error on error)", "(?s).*Illegal jsonpath spec.*", true);
        f.checkString("json_query('{\"foo\":100}', 'invalid $.foo' empty array on error)", "[]", "VARCHAR(2000)");
        f.checkString("json_query('{\"foo\":100}', 'invalid $.foo' empty object on error)", "{}", "VARCHAR(2000)");
        f.checkString("json_query('{\"foo\":100}', 'strict $' null on empty)", "{\"foo\":100}", "VARCHAR(2000)");
        f.checkString("json_query('{\"foo\":100}', 'strict $' error on empty)", "{\"foo\":100}", "VARCHAR(2000)");
        f.checkString("json_query('{\"foo\":100}', 'strict $' empty array on error)", "{\"foo\":100}", "VARCHAR(2000)");
        f.checkString("json_query('{\"foo\":100}', 'strict $' empty object on error)", "{\"foo\":100}", "VARCHAR(2000)");
        f.checkString("json_query('{\"foo\":100}', 'strict $.foo1' null on error)", null, "VARCHAR(2000)");
        f.checkFails("json_query('{\"foo\":100}', 'strict $.foo1' error on error)", "(?s).*No results for path: \\$\\['foo1'\\].*", true);
        f.checkString("json_query('{\"foo\":100}', 'strict $.foo1' empty array on error)", "[]", "VARCHAR(2000)");
        f.checkString("json_query('{\"foo\":100}', 'strict $.foo1' empty object on error)", "{}", "VARCHAR(2000)");
        f.checkString("json_query('{\"foo\":100}', 'strict $.foo' null on error)", null, "VARCHAR(2000)");
        f.checkFails("json_query('{\"foo\":100}', 'strict $.foo' error on error)", "(?s).*Strict jsonpath mode requires array or object value, and the actual value is: '100'.*", true);
        f.checkString("json_query('{\"foo\":100}', 'strict $.foo' empty array on error)", "[]", "VARCHAR(2000)");
        f.checkString("json_query('{\"foo\":100}', 'strict $.foo' empty object on error)", "{}", "VARCHAR(2000)");
        f.checkString("json_query('{\"foo\":100}', 'strict $.foo' without wrapper)", null, "VARCHAR(2000)");
        f.checkString("json_query('{\"foo\":100}', 'strict $.foo' without array wrapper)", null, "VARCHAR(2000)");
        f.checkString("json_query('{\"foo\":100}', 'strict $.foo' with wrapper)", "[100]", "VARCHAR(2000)");
        f.checkString("json_query('{\"foo\":100}', 'strict $.foo' with unconditional wrapper)", "[100]", "VARCHAR(2000)");
        f.checkString("json_query('{\"foo\":100}', 'strict $.foo' with conditional wrapper)", "[100]", "VARCHAR(2000)");
        f.checkString("json_query('{\"foo\":[100]}', 'strict $.foo' without wrapper)", "[100]", "VARCHAR(2000)");
        f.checkString("json_query('{\"foo\":[100]}', 'strict $.foo' without array wrapper)", "[100]", "VARCHAR(2000)");
        f.checkString("json_query('{\"foo\":[100]}', 'strict $.foo' with wrapper)", "[[100]]", "VARCHAR(2000)");
        f.checkString("json_query('{\"foo\":[100]}', 'strict $.foo' with unconditional wrapper)", "[[100]]", "VARCHAR(2000)");
        f.checkString("json_query('{\"foo\":[100]}', 'strict $.foo' with conditional wrapper)", "[100]", "VARCHAR(2000)");
        f.enableTypeCoercion(false).checkFails("json_query(^null^, 'lax $')", "(?s).*Illegal use of 'NULL'.*", false);
        f.checkString("json_query(null, 'lax $')", null, "VARCHAR(2000)");
        f.checkNull("json_query(cast(null as varchar), 'lax $')");
    }

    @Test
    void testJsonPretty() {
        SqlOperatorFixture f = this.fixture();
        f.checkString("json_pretty('{\"foo\":100}')", "{\n  \"foo\" : 100\n}", "VARCHAR(2000)");
        f.checkString("json_pretty('[1,2,3]')", "[ 1, 2, 3 ]", "VARCHAR(2000)");
        f.checkString("json_pretty('null')", "null", "VARCHAR(2000)");
        f.enableTypeCoercion(false).checkFails("json_pretty(^null^)", "(?s).*Illegal use of 'NULL'.*", false);
        f.checkString("json_pretty(null)", null, "VARCHAR(2000)");
        f.checkNull("json_pretty(cast(null as varchar))");
    }

    @Test
    void testJsonStorageSize() {
        SqlOperatorFixture f = this.fixture();
        f.checkString("json_storage_size('[100, \"sakila\", [1, 3, 5], 425.05]')", "29", "INTEGER");
        f.checkString("json_storage_size('{\"a\": 1000,\"b\": \"aa\", \"c\": \"[1, 3, 5]\"}')", "35", "INTEGER");
        f.checkString("json_storage_size('{\"a\": 1000, \"b\": \"wxyz\", \"c\": \"[1, 3]\"}')", "34", "INTEGER");
        f.checkString("json_storage_size('[100, \"json\", [[10, 20, 30], 3, 5], 425.05]')", "36", "INTEGER");
        f.checkString("json_storage_size('12')", "2", "INTEGER");
        f.checkString("json_storage_size('12' format json)", "2", "INTEGER");
        f.checkString("json_storage_size('null')", "4", "INTEGER");
        f.enableTypeCoercion(false).checkFails("json_storage_size(^null^)", "(?s).*Illegal use of 'NULL'.*", false);
        f.checkString("json_storage_size(null)", null, "INTEGER");
        f.checkNull("json_storage_size(cast(null as varchar))");
    }

    @Test
    void testJsonType() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlLibraryOperators.JSON_TYPE, SqlOperatorFixture.VmName.EXPAND);
        f.checkString("json_type('\"1\"')", "STRING", "VARCHAR(20)");
        f.checkString("json_type('1')", "INTEGER", "VARCHAR(20)");
        f.checkString("json_type('11.45')", "DOUBLE", "VARCHAR(20)");
        f.checkString("json_type('true')", "BOOLEAN", "VARCHAR(20)");
        f.checkString("json_type('null')", "NULL", "VARCHAR(20)");
        f.checkNull("json_type(cast(null as varchar(1)))");
        f.checkString("json_type('{\"a\": [10, true]}')", "OBJECT", "VARCHAR(20)");
        f.checkString("json_type('{}')", "OBJECT", "VARCHAR(20)");
        f.checkString("json_type('[10, true]')", "ARRAY", "VARCHAR(20)");
        f.checkString("json_type('\"2019-01-27 21:24:00\"')", "STRING", "VARCHAR(20)");
        f.enableTypeCoercion(false).checkFails("json_type(^null^)", "(?s).*Illegal use of 'NULL'.*", false);
        f.checkString("json_type(null)", null, "VARCHAR(20)");
        f.checkNull("json_type(cast(null as varchar))");
    }

    @Test
    void testJsonDepth() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlLibraryOperators.JSON_DEPTH, SqlOperatorFixture.VmName.EXPAND);
        f.checkString("json_depth('1')", "1", "INTEGER");
        f.checkString("json_depth('11.45')", "1", "INTEGER");
        f.checkString("json_depth('true')", "1", "INTEGER");
        f.checkString("json_depth('\"2019-01-27 21:24:00\"')", "1", "INTEGER");
        f.checkString("json_depth('{}')", "1", "INTEGER");
        f.checkString("json_depth('[]')", "1", "INTEGER");
        f.checkString("json_depth('null')", null, "INTEGER");
        f.checkString("json_depth(cast(null as varchar(1)))", null, "INTEGER");
        f.checkString("json_depth('[10, true]')", "2", "INTEGER");
        f.checkString("json_depth('[[], {}]')", "2", "INTEGER");
        f.checkString("json_depth('{\"a\": [10, true]}')", "3", "INTEGER");
        f.checkString("json_depth('[10, {\"a\": [[1,2]]}]')", "5", "INTEGER");
        f.enableTypeCoercion(false).checkFails("json_depth(^null^)", "(?s).*Illegal use of 'NULL'.*", false);
        f.checkString("json_depth(null)", null, "INTEGER");
        f.checkNull("json_depth(cast(null as varchar))");
    }

    @Test
    void testJsonLength() {
        SqlOperatorFixture f = this.fixture();
        f.checkString("json_length('{}')", "0", "INTEGER");
        f.checkString("json_length('[]')", "0", "INTEGER");
        f.checkString("json_length('{\"foo\":100}')", "1", "INTEGER");
        f.checkString("json_length('{\"a\": 1, \"b\": {\"c\": 30}}')", "2", "INTEGER");
        f.checkString("json_length('[1, 2, {\"a\": 3}]')", "3", "INTEGER");
        f.checkString("json_length('{\"foo\":100}', '$')", "1", "INTEGER");
        f.checkString("json_length('{}', 'lax $')", "0", "INTEGER");
        f.checkString("json_length('[]', 'lax $')", "0", "INTEGER");
        f.checkString("json_length('{\"foo\":100}', 'lax $')", "1", "INTEGER");
        f.checkString("json_length('{\"a\": 1, \"b\": {\"c\": 30}}', 'lax $')", "2", "INTEGER");
        f.checkString("json_length('[1, 2, {\"a\": 3}]', 'lax $')", "3", "INTEGER");
        f.checkString("json_length('{\"a\": 1, \"b\": {\"c\": 30}}', 'lax $.b')", "1", "INTEGER");
        f.checkString("json_length('{\"foo\":100}', 'lax $.foo1')", null, "INTEGER");
        f.checkString("json_length('{}', 'strict $')", "0", "INTEGER");
        f.checkString("json_length('[]', 'strict $')", "0", "INTEGER");
        f.checkString("json_length('{\"foo\":100}', 'strict $')", "1", "INTEGER");
        f.checkString("json_length('{\"a\": 1, \"b\": {\"c\": 30}}', 'strict $')", "2", "INTEGER");
        f.checkString("json_length('[1, 2, {\"a\": 3}]', 'strict $')", "3", "INTEGER");
        f.checkString("json_length('{\"a\": 1, \"b\": {\"c\": 30}}', 'strict $.b')", "1", "INTEGER");
        f.checkFails("json_length('{\"foo\":100}', 'invalid $.foo')", "(?s).*Illegal jsonpath spec.*", true);
        f.checkFails("json_length('{\"foo\":100}', 'strict $.foo1')", "(?s).*No results for path.*", true);
        f.enableTypeCoercion(false).checkFails("json_length(^null^)", "(?s).*Illegal use of 'NULL'.*", false);
        f.checkString("json_length(null)", null, "INTEGER");
        f.checkNull("json_length(cast(null as varchar))");
    }

    @Test
    void testJsonKeys() {
        SqlOperatorFixture f = this.fixture();
        f.checkString("json_keys('{}')", "[]", "VARCHAR(2000)");
        f.checkString("json_keys('[]')", "null", "VARCHAR(2000)");
        f.checkString("json_keys('{\"foo\":100}')", "[\"foo\"]", "VARCHAR(2000)");
        f.checkString("json_keys('{\"a\": 1, \"b\": {\"c\": 30}}')", "[\"a\",\"b\"]", "VARCHAR(2000)");
        f.checkString("json_keys('[1, 2, {\"a\": 3}]')", "null", "VARCHAR(2000)");
        f.checkString("json_keys('{}', 'lax $')", "[]", "VARCHAR(2000)");
        f.checkString("json_keys('[]', 'lax $')", "null", "VARCHAR(2000)");
        f.checkString("json_keys('{\"foo\":100}', 'lax $')", "[\"foo\"]", "VARCHAR(2000)");
        f.checkString("json_keys('{\"a\": 1, \"b\": {\"c\": 30}}', 'lax $')", "[\"a\",\"b\"]", "VARCHAR(2000)");
        f.checkString("json_keys('[1, 2, {\"a\": 3}]', 'lax $')", "null", "VARCHAR(2000)");
        f.checkString("json_keys('{\"a\": 1, \"b\": {\"c\": 30}}', 'lax $.b')", "[\"c\"]", "VARCHAR(2000)");
        f.checkString("json_keys('{\"foo\":100}', 'lax $.foo1')", "null", "VARCHAR(2000)");
        f.checkString("json_keys('{}', 'strict $')", "[]", "VARCHAR(2000)");
        f.checkString("json_keys('[]', 'strict $')", "null", "VARCHAR(2000)");
        f.checkString("json_keys('{\"foo\":100}', 'strict $')", "[\"foo\"]", "VARCHAR(2000)");
        f.checkString("json_keys('{\"a\": 1, \"b\": {\"c\": 30}}', 'strict $')", "[\"a\",\"b\"]", "VARCHAR(2000)");
        f.checkString("json_keys('[1, 2, {\"a\": 3}]', 'strict $')", "null", "VARCHAR(2000)");
        f.checkString("json_keys('{\"a\": 1, \"b\": {\"c\": 30}}', 'strict $.b')", "[\"c\"]", "VARCHAR(2000)");
        f.checkFails("json_keys('{\"foo\":100}', 'invalid $.foo')", "(?s).*Illegal jsonpath spec.*", true);
        f.checkFails("json_keys('{\"foo\":100}', 'strict $.foo1')", "(?s).*No results for path.*", true);
        f.enableTypeCoercion(false).checkFails("json_keys(^null^)", "(?s).*Illegal use of 'NULL'.*", false);
        f.checkString("json_keys(null)", null, "VARCHAR(2000)");
        f.checkNull("json_keys(cast(null as varchar))");
    }

    @Test
    void testJsonRemove() {
        SqlOperatorFixture f = this.fixture();
        f.checkString("json_remove('{\"foo\":100}', '$.foo')", "{}", "VARCHAR(2000)");
        f.checkString("json_remove('{\"foo\":100, \"foo1\":100}', '$.foo')", "{\"foo1\":100}", "VARCHAR(2000)");
        f.checkString("json_remove('[\"a\", [\"b\", \"c\"], \"d\"]', '$[1][0]')", "[\"a\",[\"c\"],\"d\"]", "VARCHAR(2000)");
        f.checkString("json_remove('[\"a\", [\"b\", \"c\"], \"d\"]', '$[1]')", "[\"a\",\"d\"]", "VARCHAR(2000)");
        f.checkString("json_remove('[\"a\", [\"b\", \"c\"], \"d\"]', '$[0]', '$[0]')", "[\"d\"]", "VARCHAR(2000)");
        f.checkFails("json_remove('[\"a\", [\"b\", \"c\"], \"d\"]', '$')", "(?s).*Invalid input for.*", true);
        f.enableTypeCoercion(false).checkFails("json_remove(^null^, '$')", "(?s).*Illegal use of 'NULL'.*", false);
        f.checkString("json_remove(null, '$')", null, "VARCHAR(2000)");
        f.checkNull("json_remove(cast(null as varchar), '$')");
    }

    @Test
    void testJsonObject() {
        SqlOperatorFixture f = this.fixture();
        f.checkString("json_object()", "{}", "VARCHAR(2000) NOT NULL");
        f.checkString("json_object('foo': 'bar')", "{\"foo\":\"bar\"}", "VARCHAR(2000) NOT NULL");
        f.checkString("json_object('foo': 'bar', 'foo2': 'bar2')", "{\"foo\":\"bar\",\"foo2\":\"bar2\"}", "VARCHAR(2000) NOT NULL");
        f.checkString("json_object('foo': null)", "{\"foo\":null}", "VARCHAR(2000) NOT NULL");
        f.checkString("json_object('foo': null null on null)", "{\"foo\":null}", "VARCHAR(2000) NOT NULL");
        f.checkString("json_object('foo': null absent on null)", "{}", "VARCHAR(2000) NOT NULL");
        f.checkString("json_object('foo': 100)", "{\"foo\":100}", "VARCHAR(2000) NOT NULL");
        f.checkString("json_object('foo': json_object('foo': 'bar'))", "{\"foo\":{\"foo\":\"bar\"}}", "VARCHAR(2000) NOT NULL");
        f.checkString("json_object('foo': json_object('foo': 'bar') format json)", "{\"foo\":{\"foo\":\"bar\"}}", "VARCHAR(2000) NOT NULL");
    }

    @Test
    void testJsonObjectAgg() {
        SqlOperatorFixture f = this.fixture();
        f.checkAggType("json_objectagg('foo': 'bar')", "VARCHAR(2000) NOT NULL");
        f.checkAggType("json_objectagg('foo': null)", "VARCHAR(2000) NOT NULL");
        f.checkAggType("json_objectagg(100: 'bar')", "VARCHAR(2000) NOT NULL");
        f.enableTypeCoercion(false).checkFails("^json_objectagg(100: 'bar')^", "(?s).*Cannot apply.*", false);
        String[][] values = new String[][]{{"'foo'", "'bar'"}, {"'foo2'", "cast(null as varchar(2000))"}, {"'foo3'", "'bar3'"}};
        f.checkAggWithMultipleArgs("json_objectagg(x: x2)", values, ResultCheckers.isSingle("{\"foo\":\"bar\",\"foo2\":null,\"foo3\":\"bar3\"}"));
        f.checkAggWithMultipleArgs("json_objectagg(x: x2 null on null)", values, ResultCheckers.isSingle("{\"foo\":\"bar\",\"foo2\":null,\"foo3\":\"bar3\"}"));
        f.checkAggWithMultipleArgs("json_objectagg(x: x2 absent on null)", values, ResultCheckers.isSingle("{\"foo\":\"bar\",\"foo3\":\"bar3\"}"));
    }

    @Test
    void testJsonValueExpressionOperator() {
        SqlOperatorFixture f = this.fixture();
        f.checkScalar("'{}' format json", "{}", "ANY NOT NULL");
        f.checkScalar("'[1, 2, 3]' format json", "[1,2,3]", "ANY NOT NULL");
        f.checkNull("cast(null as varchar) format json");
        f.checkScalar("'null' format json", "null", "ANY NOT NULL");
        f.enableTypeCoercion(false).checkFails("^null^ format json", "(?s).*Illegal use of .NULL.*", false);
    }

    @Test
    void testJsonArray() {
        SqlOperatorFixture f = this.fixture();
        f.checkString("json_array()", "[]", "VARCHAR(2000) NOT NULL");
        f.checkString("json_array('foo')", "[\"foo\"]", "VARCHAR(2000) NOT NULL");
        f.checkString("json_array('foo', 'bar')", "[\"foo\",\"bar\"]", "VARCHAR(2000) NOT NULL");
        f.checkString("json_array(null)", "[]", "VARCHAR(2000) NOT NULL");
        f.checkString("json_array(null null on null)", "[null]", "VARCHAR(2000) NOT NULL");
        f.checkString("json_array(null absent on null)", "[]", "VARCHAR(2000) NOT NULL");
        f.checkString("json_array(100)", "[100]", "VARCHAR(2000) NOT NULL");
        f.checkString("json_array(json_array('foo'))", "[[\"foo\"]]", "VARCHAR(2000) NOT NULL");
        f.checkString("json_array(json_array('foo') format json)", "[[\"foo\"]]", "VARCHAR(2000) NOT NULL");
    }

    @Test
    void testJsonArrayAgg() {
        SqlOperatorFixture f = this.fixture();
        f.checkAggType("json_arrayagg('foo')", "VARCHAR(2000) NOT NULL");
        f.checkAggType("json_arrayagg(null)", "VARCHAR(2000) NOT NULL");
        String[] values = new String[]{"'foo'", "cast(null as varchar(2000))", "'foo3'"};
        f.checkAgg("json_arrayagg(x)", values, ResultCheckers.isSingle("[\"foo\",\"foo3\"]"));
        f.checkAgg("json_arrayagg(x null on null)", values, ResultCheckers.isSingle("[\"foo\",null,\"foo3\"]"));
        f.checkAgg("json_arrayagg(x absent on null)", values, ResultCheckers.isSingle("[\"foo\",\"foo3\"]"));
    }

    @Test
    void testJsonPredicate() {
        SqlOperatorFixture f = this.fixture();
        f.checkBoolean("'{}' is json value", true);
        f.checkBoolean("'{]' is json value", false);
        f.checkBoolean("'{}' is json object", true);
        f.checkBoolean("'[]' is json object", false);
        f.checkBoolean("'{}' is json array", false);
        f.checkBoolean("'[]' is json array", true);
        f.checkBoolean("'100' is json scalar", true);
        f.checkBoolean("'[]' is json scalar", false);
        f.checkBoolean("'{}' is not json value", false);
        f.checkBoolean("'{]' is not json value", true);
        f.checkBoolean("'{}' is not json object", false);
        f.checkBoolean("'[]' is not json object", true);
        f.checkBoolean("'{}' is not json array", true);
        f.checkBoolean("'[]' is not json array", false);
        f.checkBoolean("'100' is not json scalar", false);
        f.checkBoolean("'[]' is not json scalar", true);
    }

    @Test
    void testCompress() {
        SqlOperatorFixture f = this.fixture().withLibrary(SqlLibrary.MYSQL);
        f.checkNull("COMPRESS(NULL)");
        f.checkString("COMPRESS('')", "", "VARBINARY NOT NULL");
        f.checkString("COMPRESS(REPEAT('a',1000))", "e8030000789c4b4c1c05a360140c770000f9d87af8", "VARBINARY NOT NULL");
        f.checkString("COMPRESS(REPEAT('a',16))", "10000000789c4b4c44050033980611", "VARBINARY NOT NULL");
        f.checkString("COMPRESS('sample')", "06000000789c2b4ecc2dc849050008de0283", "VARBINARY NOT NULL");
        f.checkString("COMPRESS('example')", "07000000789c4bad48cc2dc84905000bc002ed", "VARBINARY NOT NULL");
    }

    @Test
    void testExtractValue() {
        SqlOperatorFixture f = this.fixture().withLibrary(SqlLibrary.MYSQL);
        f.checkNull("ExtractValue(NULL, '//b')");
        f.checkNull("ExtractValue('', NULL)");
        f.checkFails("ExtractValue('<a><b/></a>', '#/a/b')", "Invalid input for EXTRACTVALUE: xml: '.*", true);
        f.checkFails("ExtractValue('<a><b/></a></a>', '/b')", "Invalid input for EXTRACTVALUE: xml: '.*", true);
        f.checkString("ExtractValue('<a>c</a>', '//a')", "c", "VARCHAR(2000)");
        f.checkString("ExtractValue('<a>ccc<b>ddd</b></a>', '/a')", "ccc", "VARCHAR(2000)");
        f.checkString("ExtractValue('<a>ccc<b>ddd</b></a>', '/a/b')", "ddd", "VARCHAR(2000)");
        f.checkString("ExtractValue('<a>ccc<b>ddd</b></a>', '/b')", "", "VARCHAR(2000)");
        f.checkString("ExtractValue('<a>ccc<b>ddd</b><b>eee</b></a>', '//b')", "ddd eee", "VARCHAR(2000)");
        f.checkString("ExtractValue('<a><b/></a>', 'count(/a/b)')", "1", "VARCHAR(2000)");
    }

    @Test
    void testXmlTransform() {
        SqlOperatorFixture f = this.fixture().withLibrary(SqlLibrary.ORACLE);
        f.checkNull("XMLTRANSFORM('', NULL)");
        f.checkNull("XMLTRANSFORM(NULL,'')");
        f.checkFails("XMLTRANSFORM('', '<')", "Illegal xslt specified : '.*", true);
        String sql = "XMLTRANSFORM('<', '<?xml version=\"1.0\"?>\n<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"></xsl:stylesheet>')";
        f.checkFails("XMLTRANSFORM('<', '<?xml version=\"1.0\"?>\n<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"></xsl:stylesheet>')", "Invalid input for XMLTRANSFORM xml: '.*", true);
        String sql2 = "XMLTRANSFORM('<?xml version=\"1.0\"?>\n<Article>\n  <Title>My Article</Title>\n  <Authors>\n    <Author>Mr. Foo</Author>\n    <Author>Mr. Bar</Author>\n  </Authors>\n  <Body>This is my article text.</Body>\n</Article>','<?xml version=\"1.0\"?>\n<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">  <xsl:output method=\"text\"/>  <xsl:template match=\"/\">    Article - <xsl:value-of select=\"/Article/Title\"/>    Authors: <xsl:apply-templates select=\"/Article/Authors/Author\"/>  </xsl:template>  <xsl:template match=\"Author\">    - <xsl:value-of select=\".\" />  </xsl:template></xsl:stylesheet>')";
        f.checkString("XMLTRANSFORM('<?xml version=\"1.0\"?>\n<Article>\n  <Title>My Article</Title>\n  <Authors>\n    <Author>Mr. Foo</Author>\n    <Author>Mr. Bar</Author>\n  </Authors>\n  <Body>This is my article text.</Body>\n</Article>','<?xml version=\"1.0\"?>\n<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">  <xsl:output method=\"text\"/>  <xsl:template match=\"/\">    Article - <xsl:value-of select=\"/Article/Title\"/>    Authors: <xsl:apply-templates select=\"/Article/Authors/Author\"/>  </xsl:template>  <xsl:template match=\"Author\">    - <xsl:value-of select=\".\" />  </xsl:template></xsl:stylesheet>')", "    Article - My Article    Authors:     - Mr. Foo    - Mr. Bar", "VARCHAR(2000)");
    }

    @Test
    void testExtractXml() {
        SqlOperatorFixture f = this.fixture().withLibrary(SqlLibrary.ORACLE);
        f.checkFails("\"EXTRACT\"('', '<','a')", "Invalid input for EXTRACT xpath: '.*", true);
        f.checkFails("\"EXTRACT\"('', '<')", "Invalid input for EXTRACT xpath: '.*", true);
        f.checkNull("\"EXTRACT\"('', NULL)");
        f.checkNull("\"EXTRACT\"(NULL,'')");
        f.checkString("\"EXTRACT\"('<Article><Title>Article1</Title><Authors><Author>Foo</Author><Author>Bar</Author></Authors><Body>article text.</Body></Article>', '/Article/Title')", "<Title>Article1</Title>", "VARCHAR(2000)");
        f.checkString("\"EXTRACT\"('<Article><Title>Article1</Title><Title>Article2</Title><Authors><Author>Foo</Author><Author>Bar</Author></Authors><Body>article text.</Body></Article>', '/Article/Title')", "<Title>Article1</Title><Title>Article2</Title>", "VARCHAR(2000)");
        f.checkString("\"EXTRACT\"(\n'<books xmlns=\"http://www.contoso.com/books\"><book><title>Title</title><author>Author Name</author><price>5.50</price></book></books>', '/books:books/books:book', 'books=\"http://www.contoso.com/books\"')", "<book xmlns=\"http://www.contoso.com/books\"><title>Title</title><author>Author Name</author><price>5.50</price></book>", "VARCHAR(2000)");
    }

    @Test
    void testExistsNode() {
        SqlOperatorFixture f = this.fixture().withLibrary(SqlLibrary.ORACLE);
        f.checkFails("EXISTSNODE('', '<','a')", "Invalid input for EXISTSNODE xpath: '.*", true);
        f.checkFails("EXISTSNODE('', '<')", "Invalid input for EXISTSNODE xpath: '.*", true);
        f.checkNull("EXISTSNODE('', NULL)");
        f.checkNull("EXISTSNODE(NULL,'')");
        f.checkString("EXISTSNODE('<Article><Title>Article1</Title><Authors><Author>Foo</Author><Author>Bar</Author></Authors><Body>article text.</Body></Article>', '/Article/Title')", "1", "INTEGER");
        f.checkString("EXISTSNODE('<Article><Title>Article1</Title><Authors><Author>Foo</Author><Author>Bar</Author></Authors><Body>article text.</Body></Article>', '/Article/Title/Books')", "0", "INTEGER");
        f.checkString("EXISTSNODE('<Article><Title>Article1</Title><Title>Article2</Title><Authors><Author>Foo</Author><Author>Bar</Author></Authors><Body>article text.</Body></Article>', '/Article/Title')", "1", "INTEGER");
        f.checkString("EXISTSNODE(\n'<books xmlns=\"http://www.contoso.com/books\"><book><title>Title</title><author>Author Name</author><price>5.50</price></book></books>', '/books:books/books:book', 'books=\"http://www.contoso.com/books\"')", "1", "INTEGER");
        f.checkString("EXISTSNODE(\n'<books xmlns=\"http://www.contoso.com/books\"><book><title>Title</title><author>Author Name</author><price>5.50</price></book></books>', '/books:books/books:book/books:title2', 'books=\"http://www.contoso.com/books\"')", "0", "INTEGER");
    }

    @Test
    void testLowerFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.LOWER, SqlOperatorFixture.VmName.EXPAND);
        f.checkString("lower('A')", "a", "CHAR(1) NOT NULL");
        f.checkString("lower('a')", "a", "CHAR(1) NOT NULL");
        f.checkString("lower('1')", "1", "CHAR(1) NOT NULL");
        f.checkString("lower('AA')", "aa", "CHAR(2) NOT NULL");
        f.checkNull("lower(cast(null as varchar(1)))");
    }

    @Test
    void testInitcapFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.INITCAP, VM_FENNEL);
        f.checkString("initcap('aA')", "Aa", "CHAR(2) NOT NULL");
        f.checkString("initcap('Aa')", "Aa", "CHAR(2) NOT NULL");
        f.checkString("initcap('1a')", "1a", "CHAR(2) NOT NULL");
        f.checkString("initcap('ab cd Ef 12')", "Ab Cd Ef 12", "CHAR(11) NOT NULL");
        f.checkNull("initcap(cast(null as varchar(1)))");
        f.enableTypeCoercion(false).checkFails("^initcap(cast(null as date))^", "Cannot apply 'INITCAP' to arguments of type 'INITCAP\\(<DATE>\\)'\\. Supported form\\(s\\): 'INITCAP\\(<CHARACTER>\\)'", false);
        f.checkType("initcap(cast(null as date))", "VARCHAR");
    }

    @Test
    void testPowerFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.POWER, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalarApprox("power(2,-2)", "DOUBLE NOT NULL", ResultCheckers.isExactly("0.25"));
        f.checkNull("power(cast(null as integer),2)");
        f.checkNull("power(2,cast(null as double))");
        f.checkFails("^pow(2,-2)^", "No match found for function signature POW\\(<NUMERIC>, <NUMERIC>\\)", false);
    }

    @Test
    void testSqrtFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.SQRT, SqlOperatorFixture.VmName.EXPAND);
        f.checkType("sqrt(2)", "DOUBLE NOT NULL");
        f.checkType("sqrt(cast(2 as float))", "DOUBLE NOT NULL");
        f.checkType("sqrt(case when false then 2 else null end)", "DOUBLE");
        f.enableTypeCoercion(false).checkFails("^sqrt('abc')^", "Cannot apply 'SQRT' to arguments of type 'SQRT\\(<CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'SQRT\\(<NUMERIC>\\)'", false);
        f.checkType("sqrt('abc')", "DOUBLE NOT NULL");
        f.checkScalarApprox("sqrt(2)", "DOUBLE NOT NULL", ResultCheckers.isWithin(1.4142, 1.0E-4));
        f.checkScalarApprox("sqrt(cast(2 as decimal(2, 0)))", "DOUBLE NOT NULL", ResultCheckers.isWithin(1.4142, 1.0E-4));
        f.checkNull("sqrt(cast(null as integer))");
        f.checkNull("sqrt(cast(null as double))");
    }

    @Test
    void testExpFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.EXP, VM_FENNEL);
        f.checkScalarApprox("exp(2)", "DOUBLE NOT NULL", ResultCheckers.isWithin(7.389056, 1.0E-6));
        f.checkScalarApprox("exp(-2)", "DOUBLE NOT NULL", ResultCheckers.isWithin(0.1353, 1.0E-4));
        f.checkNull("exp(cast(null as integer))");
        f.checkNull("exp(cast(null as double))");
    }

    @Test
    void testModFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.MOD, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalarExact("mod(4,2)", 0);
        f.checkScalarExact("mod(8,5)", 3);
        f.checkScalarExact("mod(-12,7)", -5);
        f.checkScalarExact("mod(-12,-7)", -5);
        f.checkScalarExact("mod(12,-7)", 5);
        f.checkScalarExact("mod(cast(12 as tinyint), cast(-7 as tinyint))", "TINYINT NOT NULL", "5");
    }

    @Test
    void testModFuncNull() {
        SqlOperatorFixture f = this.fixture();
        f.checkNull("mod(cast(null as integer),2)");
        f.checkNull("mod(4,cast(null as tinyint))");
    }

    @Test
    void testModFuncDivByZero() {
        SqlOperatorFixture f = this.fixture();
        f.checkFails("mod(3,case 'a' when 'a' then 0 end)", SqlOperatorFixture.DIVISION_BY_ZERO_MESSAGE, true);
    }

    @Test
    void testLnFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.LN, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalarApprox("ln(2.71828)", "DOUBLE NOT NULL", ResultCheckers.isWithin(1.0, 1.0E-6));
        f.checkScalarApprox("ln(2.71828)", "DOUBLE NOT NULL", ResultCheckers.isWithin(0.999999327, 1.0E-7));
        f.checkNull("ln(cast(null as tinyint))");
    }

    @Test
    void testLogFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.LOG10, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalarApprox("log10(10)", "DOUBLE NOT NULL", ResultCheckers.isWithin(1.0, 1.0E-6));
        f.checkScalarApprox("log10(100.0)", "DOUBLE NOT NULL", ResultCheckers.isWithin(2.0, 1.0E-6));
        f.checkScalarApprox("log10(cast(10e8 as double))", "DOUBLE NOT NULL", ResultCheckers.isWithin(9.0, 1.0E-6));
        f.checkScalarApprox("log10(cast(10e2 as float))", "DOUBLE NOT NULL", ResultCheckers.isWithin(3.0, 1.0E-6));
        f.checkScalarApprox("log10(cast(10e-3 as real))", "DOUBLE NOT NULL", ResultCheckers.isWithin(-2.0, 1.0E-6));
        f.checkNull("log10(cast(null as real))");
    }

    @Test
    void testRandFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.RAND, SqlOperatorFixture.VmName.EXPAND);
        f.checkFails("^rand^", "Column 'RAND' not found in any table", false);
        for (int i = 0; i < 100; ++i) {
            f.checkScalarApprox("rand()", "DOUBLE NOT NULL", ResultCheckers.isWithin(0.5, 0.5));
        }
    }

    @Test
    void testRandSeedFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.RAND, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalarApprox("rand(1)", "DOUBLE NOT NULL", ResultCheckers.isWithin(0.6016, 1.0E-4));
        f.checkScalarApprox("rand(2)", "DOUBLE NOT NULL", ResultCheckers.isWithin(0.4728, 1.0E-4));
    }

    @Test
    void testRandIntegerFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.RAND_INTEGER, SqlOperatorFixture.VmName.EXPAND);
        for (int i = 0; i < 100; ++i) {
            f.checkScalarApprox("rand_integer(11)", "INTEGER NOT NULL", ResultCheckers.isWithin(5.0, 5.0));
        }
    }

    @Test
    void testRandIntegerSeedFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.RAND_INTEGER, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalar("rand_integer(1, 11)", 4, "INTEGER NOT NULL");
        f.checkScalar("rand_integer(2, 11)", 1, "INTEGER NOT NULL");
    }

    @Test
    void testArrayConcat() {
        SqlOperatorFixture f = this.fixture().setFor((SqlOperator)SqlLibraryOperators.ARRAY_CONCAT, new SqlOperatorFixture.VmName[0]).withLibrary(SqlLibrary.BIG_QUERY);
        f.checkFails("^array_concat()^", "Invalid number of arguments to function .* Was expecting .* arguments", false);
        f.checkScalar("array_concat(array[1, 2], array[2, 3])", "[1, 2, 2, 3]", "INTEGER NOT NULL ARRAY NOT NULL");
        f.checkScalar("array_concat(array[1, 2], array[2, null])", "[1, 2, 2, null]", "INTEGER ARRAY NOT NULL");
        f.checkScalar("array_concat(array['hello', 'world'], array['!'], array[cast(null as char)])", "[hello, world, !, null]", "CHAR(5) ARRAY NOT NULL");
        f.checkNull("array_concat(cast(null as integer array), array[1])");
    }

    @Test
    void testArrayReverseFunc() {
        SqlOperatorFixture f = this.fixture().setFor((SqlOperator)SqlLibraryOperators.ARRAY_REVERSE, new SqlOperatorFixture.VmName[0]).withLibrary(SqlLibrary.BIG_QUERY);
        f.checkScalar("array_reverse(array[1])", "[1]", "INTEGER NOT NULL ARRAY NOT NULL");
        f.checkScalar("array_reverse(array[1, 2])", "[2, 1]", "INTEGER NOT NULL ARRAY NOT NULL");
        f.checkScalar("array_reverse(array[null, 1])", "[1, null]", "INTEGER ARRAY NOT NULL");
    }

    @Test
    void testArrayLengthFunc() {
        SqlOperatorFixture f = this.fixture().setFor((SqlOperator)SqlLibraryOperators.ARRAY_LENGTH, new SqlOperatorFixture.VmName[0]).withLibrary(SqlLibrary.BIG_QUERY);
        f.checkScalar("array_length(array[1])", "1", "INTEGER NOT NULL");
        f.checkScalar("array_length(array[1, 2, null])", "3", "INTEGER NOT NULL");
        f.checkNull("array_length(null)");
    }

    @Test
    void testUnixSecondsFunc() {
        SqlOperatorFixture f = this.fixture().setFor((SqlOperator)SqlLibraryOperators.UNIX_SECONDS, new SqlOperatorFixture.VmName[0]).withLibrary(SqlLibrary.BIG_QUERY);
        f.checkScalar("unix_seconds(timestamp '1970-01-01 00:00:00')", 0, "BIGINT NOT NULL");
        f.checkNull("unix_seconds(cast(null as timestamp))");
        f.checkNull("unix_millis(cast(null as timestamp))");
        f.checkNull("unix_micros(cast(null as timestamp))");
        f.checkScalar("timestamp_seconds(0)", "1970-01-01 00:00:00", "TIMESTAMP(0) NOT NULL");
        f.checkNull("timestamp_seconds(cast(null as bigint))");
        f.checkNull("timestamp_millis(cast(null as bigint))");
        f.checkNull("timestamp_micros(cast(null as bigint))");
        f.checkScalar("date_from_unix_date(0)", "1970-01-01", "DATE NOT NULL");
        f.checkNull("DATE(null)");
        f.checkScalar("DATE('1985-12-06')", "1985-12-06", "DATE NOT NULL");
        f.checkType("CURRENT_DATETIME()", "TIMESTAMP(0) NOT NULL");
        f.checkType("CURRENT_DATETIME('America/Los_Angeles')", "TIMESTAMP(0) NOT NULL");
        f.checkType("CURRENT_DATETIME(CAST(NULL AS VARCHAR(20)))", "TIMESTAMP(0)");
    }

    @Test
    void testAbsFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.ABS, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalarExact("abs(-1)", 1);
        f.checkScalarExact("abs(cast(10 as TINYINT))", "TINYINT NOT NULL", "10");
        f.checkScalarExact("abs(cast(-20 as SMALLINT))", "SMALLINT NOT NULL", "20");
        f.checkScalarExact("abs(cast(-100 as INT))", "INTEGER NOT NULL", "100");
        f.checkScalarExact("abs(cast(1000 as BIGINT))", "BIGINT NOT NULL", "1000");
        f.checkScalarExact("abs(54.4)", "DECIMAL(3, 1) NOT NULL", "54.4");
        f.checkScalarExact("abs(-54.4)", "DECIMAL(3, 1) NOT NULL", "54.4");
        f.checkScalarApprox("abs(-9.32E-2)", "DOUBLE NOT NULL", ResultCheckers.isExactly("0.0932"));
        f.checkScalarApprox("abs(cast(-3.5 as double))", "DOUBLE NOT NULL", ResultCheckers.isExactly("3.5"));
        f.checkScalarApprox("abs(cast(-3.5 as float))", "FLOAT NOT NULL", ResultCheckers.isExactly("3.5"));
        f.checkScalarApprox("abs(cast(3.5 as real))", "REAL NOT NULL", ResultCheckers.isExactly("3.5"));
        f.checkNull("abs(cast(null as double))");
    }

    @Test
    void testAbsFuncIntervals() {
        SqlOperatorFixture f = this.fixture();
        f.checkScalar("abs(interval '-2' day)", "+2", "INTERVAL DAY NOT NULL");
        f.checkScalar("abs(interval '-5-03' year to month)", "+5-03", "INTERVAL YEAR TO MONTH NOT NULL");
        f.checkNull("abs(cast(null as interval hour))");
    }

    @Test
    void testAcosFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.ACOS, SqlOperatorFixture.VmName.EXPAND);
        f.checkType("acos(0)", "DOUBLE NOT NULL");
        f.checkType("acos(cast(1 as float))", "DOUBLE NOT NULL");
        f.checkType("acos(case when false then 0.5 else null end)", "DOUBLE");
        f.enableTypeCoercion(false).checkFails("^acos('abc')^", "Cannot apply 'ACOS' to arguments of type 'ACOS\\(<CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'ACOS\\(<NUMERIC>\\)'", false);
        f.checkType("acos('abc')", "DOUBLE NOT NULL");
        f.checkScalarApprox("acos(0.5)", "DOUBLE NOT NULL", ResultCheckers.isWithin(1.0472, 1.0E-4));
        f.checkScalarApprox("acos(cast(0.5 as decimal(1, 1)))", "DOUBLE NOT NULL", ResultCheckers.isWithin(1.0472, 1.0E-4));
        f.checkNull("acos(cast(null as integer))");
        f.checkNull("acos(cast(null as double))");
    }

    @Test
    void testAsinFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.ASIN, SqlOperatorFixture.VmName.EXPAND);
        f.checkType("asin(0)", "DOUBLE NOT NULL");
        f.checkType("asin(cast(1 as float))", "DOUBLE NOT NULL");
        f.checkType("asin(case when false then 0.5 else null end)", "DOUBLE");
        f.enableTypeCoercion(false).checkFails("^asin('abc')^", "Cannot apply 'ASIN' to arguments of type 'ASIN\\(<CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'ASIN\\(<NUMERIC>\\)'", false);
        f.checkType("asin('abc')", "DOUBLE NOT NULL");
        f.checkScalarApprox("asin(0.5)", "DOUBLE NOT NULL", ResultCheckers.isWithin(0.5236, 1.0E-4));
        f.checkScalarApprox("asin(cast(0.5 as decimal(1, 1)))", "DOUBLE NOT NULL", ResultCheckers.isWithin(0.5236, 1.0E-4));
        f.checkNull("asin(cast(null as integer))");
        f.checkNull("asin(cast(null as double))");
    }

    @Test
    void testAtanFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.ATAN, SqlOperatorFixture.VmName.EXPAND);
        f.checkType("atan(2)", "DOUBLE NOT NULL");
        f.checkType("atan(cast(2 as float))", "DOUBLE NOT NULL");
        f.checkType("atan(case when false then 2 else null end)", "DOUBLE");
        f.enableTypeCoercion(false).checkFails("^atan('abc')^", "Cannot apply 'ATAN' to arguments of type 'ATAN\\(<CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'ATAN\\(<NUMERIC>\\)'", false);
        f.checkType("atan('abc')", "DOUBLE NOT NULL");
        f.checkScalarApprox("atan(2)", "DOUBLE NOT NULL", ResultCheckers.isWithin(1.1071, 1.0E-4));
        f.checkScalarApprox("atan(cast(2 as decimal(1, 0)))", "DOUBLE NOT NULL", ResultCheckers.isWithin(1.1071, 1.0E-4));
        f.checkNull("atan(cast(null as integer))");
        f.checkNull("atan(cast(null as double))");
    }

    @Test
    void testAtan2Func() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.ATAN2, SqlOperatorFixture.VmName.EXPAND);
        f.checkType("atan2(2, -2)", "DOUBLE NOT NULL");
        f.checkScalarApprox("atan2(cast(1 as float), -1)", "DOUBLE NOT NULL", ResultCheckers.isWithin(2.3562, 1.0E-4));
        f.checkType("atan2(case when false then 0.5 else null end, -1)", "DOUBLE");
        f.enableTypeCoercion(false).checkFails("^atan2('abc', 'def')^", "Cannot apply 'ATAN2' to arguments of type 'ATAN2\\(<CHAR\\(3\\)>, <CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'ATAN2\\(<NUMERIC>, <NUMERIC>\\)'", false);
        f.checkType("atan2('abc', 'def')", "DOUBLE NOT NULL");
        f.checkScalarApprox("atan2(0.5, -0.5)", "DOUBLE NOT NULL", ResultCheckers.isWithin(2.3562, 1.0E-4));
        f.checkScalarApprox("atan2(cast(0.5 as decimal(1, 1)), cast(-0.5 as decimal(1, 1)))", "DOUBLE NOT NULL", ResultCheckers.isWithin(2.3562, 1.0E-4));
        f.checkNull("atan2(cast(null as integer), -1)");
        f.checkNull("atan2(1, cast(null as double))");
    }

    @Test
    void testCbrtFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CBRT, SqlOperatorFixture.VmName.EXPAND);
        f.checkType("cbrt(1)", "DOUBLE NOT NULL");
        f.checkType("cbrt(cast(1 as float))", "DOUBLE NOT NULL");
        f.checkType("cbrt(case when false then 1 else null end)", "DOUBLE");
        f.enableTypeCoercion(false).checkFails("^cbrt('abc')^", "Cannot apply 'CBRT' to arguments of type 'CBRT\\(<CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'CBRT\\(<NUMERIC>\\)'", false);
        f.checkType("cbrt('abc')", "DOUBLE NOT NULL");
        f.checkScalar("cbrt(8)", "2.0", "DOUBLE NOT NULL");
        f.checkScalar("cbrt(-8)", "-2.0", "DOUBLE NOT NULL");
        f.checkScalar("cbrt(cast(1 as decimal(1, 0)))", "1.0", "DOUBLE NOT NULL");
        f.checkNull("cbrt(cast(null as integer))");
        f.checkNull("cbrt(cast(null as double))");
    }

    @Test
    void testCosFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.COS, SqlOperatorFixture.VmName.EXPAND);
        f.checkType("cos(1)", "DOUBLE NOT NULL");
        f.checkType("cos(cast(1 as float))", "DOUBLE NOT NULL");
        f.checkType("cos(case when false then 1 else null end)", "DOUBLE");
        f.enableTypeCoercion(false).checkFails("^cos('abc')^", "Cannot apply 'COS' to arguments of type 'COS\\(<CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'COS\\(<NUMERIC>\\)'", false);
        f.checkType("cos('abc')", "DOUBLE NOT NULL");
        f.checkScalarApprox("cos(1)", "DOUBLE NOT NULL", ResultCheckers.isWithin(0.5403, 1.0E-4));
        f.checkScalarApprox("cos(cast(1 as decimal(1, 0)))", "DOUBLE NOT NULL", ResultCheckers.isWithin(0.5403, 1.0E-4));
        f.checkNull("cos(cast(null as integer))");
        f.checkNull("cos(cast(null as double))");
    }

    @Test
    void testCoshFunc() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlLibraryOperators.COSH, new SqlOperatorFixture.VmName[0]);
        f0.checkFails("^cosh(1)^", "No match found for function signature COSH\\(<NUMERIC>\\)", false);
        Consumer<SqlOperatorFixture> consumer = f -> {
            f.checkType("cosh(1)", "DOUBLE NOT NULL");
            f.checkType("cosh(cast(1 as float))", "DOUBLE NOT NULL");
            f.checkType("cosh(case when false then 1 else null end)", "DOUBLE");
            f.checkType("cosh('abc')", "DOUBLE NOT NULL");
            f.checkScalarApprox("cosh(1)", "DOUBLE NOT NULL", ResultCheckers.isWithin(1.543, 1.0E-4));
            f.checkScalarApprox("cosh(cast(1 as decimal(1, 0)))", "DOUBLE NOT NULL", ResultCheckers.isWithin(1.543, 1.0E-4));
            f.checkNull("cosh(cast(null as integer))");
            f.checkNull("cosh(cast(null as double))");
        };
        f0.forEachLibrary((Iterable<? extends SqlLibrary>)Expressions.list((Object[])new SqlLibrary[]{SqlLibrary.BIG_QUERY, SqlLibrary.ORACLE}), consumer);
    }

    @Test
    void testCotFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.COT, SqlOperatorFixture.VmName.EXPAND);
        f.checkType("cot(1)", "DOUBLE NOT NULL");
        f.checkType("cot(cast(1 as float))", "DOUBLE NOT NULL");
        f.checkType("cot(case when false then 1 else null end)", "DOUBLE");
        f.enableTypeCoercion(false).checkFails("^cot('abc')^", "Cannot apply 'COT' to arguments of type 'COT\\(<CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'COT\\(<NUMERIC>\\)'", false);
        f.checkType("cot('abc')", "DOUBLE NOT NULL");
        f.checkScalarApprox("cot(1)", "DOUBLE NOT NULL", ResultCheckers.isWithin(0.6421, 1.0E-4));
        f.checkScalarApprox("cot(cast(1 as decimal(1, 0)))", "DOUBLE NOT NULL", ResultCheckers.isWithin(0.6421, 1.0E-4));
        f.checkNull("cot(cast(null as integer))");
        f.checkNull("cot(cast(null as double))");
    }

    @Test
    void testDegreesFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.DEGREES, SqlOperatorFixture.VmName.EXPAND);
        f.checkType("degrees(1)", "DOUBLE NOT NULL");
        f.checkType("degrees(cast(1 as float))", "DOUBLE NOT NULL");
        f.checkType("degrees(case when false then 1 else null end)", "DOUBLE");
        f.enableTypeCoercion(false).checkFails("^degrees('abc')^", "Cannot apply 'DEGREES' to arguments of type 'DEGREES\\(<CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'DEGREES\\(<NUMERIC>\\)'", false);
        f.checkType("degrees('abc')", "DOUBLE NOT NULL");
        f.checkScalarApprox("degrees(1)", "DOUBLE NOT NULL", ResultCheckers.isWithin(57.2958, 1.0E-4));
        f.checkScalarApprox("degrees(cast(1 as decimal(1, 0)))", "DOUBLE NOT NULL", ResultCheckers.isWithin(57.2958, 1.0E-4));
        f.checkNull("degrees(cast(null as integer))");
        f.checkNull("degrees(cast(null as double))");
    }

    @Test
    void testPiFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.PI, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalarApprox("PI", "DOUBLE NOT NULL", ResultCheckers.isWithin(3.1415, 1.0E-4));
        f.checkFails("^PI()^", "No match found for function signature PI\\(\\)", false);
        MatcherAssert.assertThat((String)"PI operator should not be identified as dynamic function", (Object)SqlStdOperatorTable.PI.isDynamicFunction(), (Matcher)Is.is((Object)false));
    }

    @Test
    void testRadiansFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.RADIANS, SqlOperatorFixture.VmName.EXPAND);
        f.checkType("radians(42)", "DOUBLE NOT NULL");
        f.checkType("radians(cast(42 as float))", "DOUBLE NOT NULL");
        f.checkType("radians(case when false then 42 else null end)", "DOUBLE");
        f.enableTypeCoercion(false).checkFails("^radians('abc')^", "Cannot apply 'RADIANS' to arguments of type 'RADIANS\\(<CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'RADIANS\\(<NUMERIC>\\)'", false);
        f.checkType("radians('abc')", "DOUBLE NOT NULL");
        f.checkScalarApprox("radians(42)", "DOUBLE NOT NULL", ResultCheckers.isWithin(0.733, 1.0E-4));
        f.checkScalarApprox("radians(cast(42 as decimal(2, 0)))", "DOUBLE NOT NULL", ResultCheckers.isWithin(0.733, 1.0E-4));
        f.checkNull("radians(cast(null as integer))");
        f.checkNull("radians(cast(null as double))");
    }

    @Test
    void testPowFunc() {
        SqlOperatorFixture f = this.fixture().setFor((SqlOperator)SqlLibraryOperators.POW, new SqlOperatorFixture.VmName[0]).withLibrary(SqlLibrary.BIG_QUERY);
        f.checkScalarApprox("pow(2,3)", "DOUBLE NOT NULL", ResultCheckers.isExactly("8.0"));
        f.checkNull("pow(2, cast(null as integer))");
        f.checkNull("pow(cast(null as integer), 2)");
    }

    @Test
    void testRoundFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.ROUND, SqlOperatorFixture.VmName.EXPAND);
        f.checkType("round(42, -1)", "INTEGER NOT NULL");
        f.checkType("round(cast(42 as float), 1)", "FLOAT NOT NULL");
        f.checkType("round(case when false then 42 else null end, -1)", "INTEGER");
        f.enableTypeCoercion(false).checkFails("^round('abc', 'def')^", "Cannot apply 'ROUND' to arguments of type 'ROUND\\(<CHAR\\(3\\)>, <CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'ROUND\\(<NUMERIC>, <INTEGER>\\)'", false);
        f.checkType("round('abc', 'def')", "DECIMAL(19, 9) NOT NULL");
        f.checkScalar("round(42, -1)", 40, "INTEGER NOT NULL");
        f.checkScalar("round(cast(42.346 as decimal(2, 3)), 2)", BigDecimal.valueOf(4235L, 2), "DECIMAL(2, 3) NOT NULL");
        f.checkScalar("round(cast(-42.346 as decimal(2, 3)), 2)", BigDecimal.valueOf(-4235L, 2), "DECIMAL(2, 3) NOT NULL");
        f.checkNull("round(cast(null as integer), 1)");
        f.checkNull("round(cast(null as double), 1)");
        f.checkNull("round(43.21, cast(null as integer))");
        f.checkNull("round(cast(null as double))");
        f.checkScalar("round(42)", 42, "INTEGER NOT NULL");
        f.checkScalar("round(cast(42.346 as decimal(2, 3)))", BigDecimal.valueOf(42L, 0), "DECIMAL(2, 3) NOT NULL");
        f.checkScalar("round(42.324)", BigDecimal.valueOf(42L, 0), "DECIMAL(5, 3) NOT NULL");
        f.checkScalar("round(42.724)", BigDecimal.valueOf(43L, 0), "DECIMAL(5, 3) NOT NULL");
    }

    @Test
    void testSignFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.SIGN, SqlOperatorFixture.VmName.EXPAND);
        f.checkType("sign(1)", "INTEGER NOT NULL");
        f.checkType("sign(cast(1 as float))", "FLOAT NOT NULL");
        f.checkType("sign(case when false then 1 else null end)", "INTEGER");
        f.enableTypeCoercion(false).checkFails("^sign('abc')^", "Cannot apply 'SIGN' to arguments of type 'SIGN\\(<CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'SIGN\\(<NUMERIC>\\)'", false);
        f.checkType("sign('abc')", "DECIMAL(19, 9) NOT NULL");
        f.checkScalar("sign(1)", 1, "INTEGER NOT NULL");
        f.checkScalar("sign(cast(-1 as decimal(1, 0)))", BigDecimal.valueOf(-1L), "DECIMAL(1, 0) NOT NULL");
        f.checkScalar("sign(cast(0 as float))", 0.0, "FLOAT NOT NULL");
        f.checkNull("sign(cast(null as integer))");
        f.checkNull("sign(cast(null as double))");
    }

    @Test
    void testSinFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.SIN, SqlOperatorFixture.VmName.EXPAND);
        f.checkType("sin(1)", "DOUBLE NOT NULL");
        f.checkType("sin(cast(1 as float))", "DOUBLE NOT NULL");
        f.checkType("sin(case when false then 1 else null end)", "DOUBLE");
        f.enableTypeCoercion(false).checkFails("^sin('abc')^", "Cannot apply 'SIN' to arguments of type 'SIN\\(<CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'SIN\\(<NUMERIC>\\)'", false);
        f.checkType("sin('abc')", "DOUBLE NOT NULL");
        f.checkScalarApprox("sin(1)", "DOUBLE NOT NULL", ResultCheckers.isWithin(0.8415, 1.0E-4));
        f.checkScalarApprox("sin(cast(1 as decimal(1, 0)))", "DOUBLE NOT NULL", ResultCheckers.isWithin(0.8415, 1.0E-4));
        f.checkNull("sin(cast(null as integer))");
        f.checkNull("sin(cast(null as double))");
    }

    @Test
    void testSinhFunc() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlLibraryOperators.SINH, new SqlOperatorFixture.VmName[0]);
        f0.checkFails("^sinh(1)^", "No match found for function signature SINH\\(<NUMERIC>\\)", false);
        Consumer<SqlOperatorFixture> consumer = f -> {
            f.checkType("sinh(1)", "DOUBLE NOT NULL");
            f.checkType("sinh(cast(1 as float))", "DOUBLE NOT NULL");
            f.checkType("sinh(case when false then 1 else null end)", "DOUBLE");
            f.checkType("sinh('abc')", "DOUBLE NOT NULL");
            f.checkScalarApprox("sinh(1)", "DOUBLE NOT NULL", ResultCheckers.isWithin(1.1752, 1.0E-4));
            f.checkScalarApprox("sinh(cast(1 as decimal(1, 0)))", "DOUBLE NOT NULL", ResultCheckers.isWithin(1.1752, 1.0E-4));
            f.checkNull("sinh(cast(null as integer))");
            f.checkNull("sinh(cast(null as double))");
        };
        f0.forEachLibrary((Iterable<? extends SqlLibrary>)Expressions.list((Object[])new SqlLibrary[]{SqlLibrary.BIG_QUERY, SqlLibrary.ORACLE}), consumer);
    }

    @Test
    void testTanFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.TAN, SqlOperatorFixture.VmName.EXPAND);
        f.checkType("tan(1)", "DOUBLE NOT NULL");
        f.checkType("tan(cast(1 as float))", "DOUBLE NOT NULL");
        f.checkType("tan(case when false then 1 else null end)", "DOUBLE");
        f.enableTypeCoercion(false).checkFails("^tan('abc')^", "Cannot apply 'TAN' to arguments of type 'TAN\\(<CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'TAN\\(<NUMERIC>\\)'", false);
        f.checkType("tan('abc')", "DOUBLE NOT NULL");
        f.checkScalarApprox("tan(1)", "DOUBLE NOT NULL", ResultCheckers.isWithin(1.5574, 1.0E-4));
        f.checkScalarApprox("tan(cast(1 as decimal(1, 0)))", "DOUBLE NOT NULL", ResultCheckers.isWithin(1.5574, 1.0E-4));
        f.checkNull("tan(cast(null as integer))");
        f.checkNull("tan(cast(null as double))");
    }

    @Test
    void testTanhFunc() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlLibraryOperators.TANH, new SqlOperatorFixture.VmName[0]);
        f0.checkFails("^tanh(1)^", "No match found for function signature TANH\\(<NUMERIC>\\)", false);
        Consumer<SqlOperatorFixture> consumer = f -> {
            f.checkType("tanh(1)", "DOUBLE NOT NULL");
            f.checkType("tanh(cast(1 as float))", "DOUBLE NOT NULL");
            f.checkType("tanh(case when false then 1 else null end)", "DOUBLE");
            f.checkType("tanh('abc')", "DOUBLE NOT NULL");
            f.checkScalarApprox("tanh(1)", "DOUBLE NOT NULL", ResultCheckers.isWithin(0.7615, 1.0E-4));
            f.checkScalarApprox("tanh(cast(1 as decimal(1, 0)))", "DOUBLE NOT NULL", ResultCheckers.isWithin(0.7615, 1.0E-4));
            f.checkNull("tanh(cast(null as integer))");
            f.checkNull("tanh(cast(null as double))");
        };
        f0.forEachLibrary((Iterable<? extends SqlLibrary>)Expressions.list((Object[])new SqlLibrary[]{SqlLibrary.BIG_QUERY, SqlLibrary.ORACLE}), consumer);
    }

    @Test
    void testTruncFunc() {
        SqlOperatorFixture f = this.fixture().setFor((SqlOperator)SqlLibraryOperators.TRUNC, new SqlOperatorFixture.VmName[0]).withLibrary(SqlLibrary.BIG_QUERY);
        f.checkType("trunc(42, -1)", "INTEGER NOT NULL");
        f.checkType("trunc(cast(42 as float), 1)", "FLOAT NOT NULL");
        f.checkType("trunc(case when false then 42 else null end, -1)", "INTEGER");
        f.enableTypeCoercion(false).checkFails("^trunc('abc', 'def')^", "Cannot apply 'TRUNC' to arguments of type 'TRUNC\\(<CHAR\\(3\\)>, <CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'TRUNC\\(<NUMERIC>, <INTEGER>\\)'", false);
        f.checkType("trunc('abc', 'def')", "DECIMAL(19, 9) NOT NULL");
        f.checkScalar("trunc(42, -1)", 40, "INTEGER NOT NULL");
        f.checkScalar("trunc(cast(42.345 as decimal(2, 3)), 2)", BigDecimal.valueOf(4234L, 2), "DECIMAL(2, 3) NOT NULL");
        f.checkScalar("trunc(cast(-42.345 as decimal(2, 3)), 2)", BigDecimal.valueOf(-4234L, 2), "DECIMAL(2, 3) NOT NULL");
        f.checkNull("trunc(cast(null as integer), 1)");
        f.checkNull("trunc(cast(null as double), 1)");
        f.checkNull("trunc(43.21, cast(null as integer))");
        f.checkScalar("trunc(42)", 42, "INTEGER NOT NULL");
        f.checkScalar("trunc(42.324)", BigDecimal.valueOf(42L, 0), "DECIMAL(5, 3) NOT NULL");
        f.checkScalar("trunc(cast(42.324 as float))", Float.valueOf(42.0f), "FLOAT NOT NULL");
        f.checkScalar("trunc(cast(42.345 as decimal(2, 3)))", BigDecimal.valueOf(42L, 0), "DECIMAL(2, 3) NOT NULL");
        f.checkNull("trunc(cast(null as integer))");
        f.checkNull("trunc(cast(null as double))");
    }

    @Test
    void testTruncateFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.TRUNCATE, SqlOperatorFixture.VmName.EXPAND);
        f.checkType("truncate(42, -1)", "INTEGER NOT NULL");
        f.checkType("truncate(cast(42 as float), 1)", "FLOAT NOT NULL");
        f.checkType("truncate(case when false then 42 else null end, -1)", "INTEGER");
        f.enableTypeCoercion(false).checkFails("^truncate('abc', 'def')^", "Cannot apply 'TRUNCATE' to arguments of type 'TRUNCATE\\(<CHAR\\(3\\)>, <CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): 'TRUNCATE\\(<NUMERIC>, <INTEGER>\\)'", false);
        f.checkType("truncate('abc', 'def')", "DECIMAL(19, 9) NOT NULL");
        f.checkScalar("truncate(42, -1)", 40, "INTEGER NOT NULL");
        f.checkScalar("truncate(cast(42.345 as decimal(2, 3)), 2)", BigDecimal.valueOf(4234L, 2), "DECIMAL(2, 3) NOT NULL");
        f.checkScalar("truncate(cast(-42.345 as decimal(2, 3)), 2)", BigDecimal.valueOf(-4234L, 2), "DECIMAL(2, 3) NOT NULL");
        f.checkNull("truncate(cast(null as integer), 1)");
        f.checkNull("truncate(cast(null as double), 1)");
        f.checkNull("truncate(43.21, cast(null as integer))");
        f.checkScalar("truncate(42)", 42, "INTEGER NOT NULL");
        f.checkScalar("truncate(42.324)", BigDecimal.valueOf(42L, 0), "DECIMAL(5, 3) NOT NULL");
        f.checkScalar("truncate(cast(42.324 as float))", Float.valueOf(42.0f), "FLOAT NOT NULL");
        f.checkScalar("truncate(cast(42.345 as decimal(2, 3)))", BigDecimal.valueOf(42L, 0), "DECIMAL(2, 3) NOT NULL");
        f.checkNull("truncate(cast(null as integer))");
        f.checkNull("truncate(cast(null as double))");
    }

    @Test
    void testNullifFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.NULLIF, VM_EXPAND);
        f.checkNull("nullif(1,1)");
        f.checkScalarExact("nullif(1.5, 13.56)", "DECIMAL(2, 1)", "1.5");
        f.checkScalarExact("nullif(13.56, 1.5)", "DECIMAL(4, 2)", "13.56");
        f.checkScalarExact("nullif(1.5, 3)", "DECIMAL(2, 1)", "1.5");
        f.checkScalarExact("nullif(3, 1.5)", "INTEGER", "3");
        f.checkScalarApprox("nullif(1.5e0, 3e0)", "DOUBLE", ResultCheckers.isExactly("1.5"));
        f.checkScalarApprox("nullif(1.5, cast(3e0 as REAL))", "DECIMAL(2, 1)", ResultCheckers.isExactly("1.5"));
        f.checkScalarExact("nullif(3, 1.5e0)", "INTEGER", "3");
        f.checkScalarExact("nullif(3, cast(1.5e0 as REAL))", "INTEGER", "3");
        f.checkScalarApprox("nullif(1.5e0, 3.4)", "DOUBLE", ResultCheckers.isExactly("1.5"));
        f.checkScalarExact("nullif(3.4, 1.5e0)", "DECIMAL(2, 1)", "3.4");
        f.checkString("nullif('a','bc')", "a", "CHAR(1)");
        f.checkString("nullif('a',cast(null as varchar(1)))", "a", "CHAR(1)");
        f.checkNull("nullif(cast(null as varchar(1)),'a')");
        f.checkNull("nullif(cast(null as numeric(4,3)), 4.3)");
        f.checkFails("1 + ^nullif(1, date '2005-8-4')^ + 2", "(?s)Cannot apply '=' to arguments of type '<INTEGER> = <DATE>'\\..*", false);
        f.checkFails("1 + ^nullif(1, 2, 3)^ + 2", "Invalid number of arguments to function 'NULLIF'\\. Was expecting 2 arguments", false);
    }

    @Test
    void testNullIfOperatorIntervals() {
        SqlOperatorFixture f = this.fixture();
        f.checkScalar("nullif(interval '2' month, interval '3' year)", "+2", "INTERVAL MONTH");
        f.checkScalar("nullif(interval '2 5' day to hour, interval '5' second)", "+2 05", "INTERVAL DAY TO HOUR");
        f.checkNull("nullif(interval '3' day, interval '3' day)");
    }

    @Test
    void testCoalesceFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.COALESCE, VM_EXPAND);
        f.checkString("coalesce('a','b')", "a", "CHAR(1) NOT NULL");
        f.checkScalarExact("coalesce(null,null,3)", 3);
        f.enableTypeCoercion(false).checkFails("1 + ^coalesce('a', 'b', 1, null)^ + 2", "Illegal mixing of types in CASE or COALESCE statement", false);
        f.checkType("1 + coalesce('a', 'b', 1, null) + 2", "INTEGER");
    }

    @Test
    void testUserFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.USER, VM_FENNEL);
        f.checkString("USER", "sa", "VARCHAR(2000) NOT NULL");
    }

    @Test
    void testCurrentUserFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CURRENT_USER, VM_FENNEL);
        f.checkString("CURRENT_USER", "sa", "VARCHAR(2000) NOT NULL");
    }

    @Test
    void testSessionUserFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.SESSION_USER, VM_FENNEL);
        f.checkString("SESSION_USER", "sa", "VARCHAR(2000) NOT NULL");
    }

    @Test
    void testSystemUserFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.SYSTEM_USER, VM_FENNEL);
        String user = System.getProperty("user.name");
        f.checkString("SYSTEM_USER", user, "VARCHAR(2000) NOT NULL");
    }

    @Test
    void testCurrentPathFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CURRENT_PATH, VM_FENNEL);
        f.checkString("CURRENT_PATH", "", "VARCHAR(2000) NOT NULL");
    }

    @Test
    void testCurrentRoleFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CURRENT_ROLE, VM_FENNEL);
        f.checkString("CURRENT_ROLE", "", "VARCHAR(2000) NOT NULL");
    }

    @Test
    void testCurrentCatalogFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CURRENT_CATALOG, VM_FENNEL);
        f.checkString("CURRENT_CATALOG", "", "VARCHAR(2000) NOT NULL");
    }

    @Tag(value="slow")
    @Test
    void testLocalTimeFuncWithCurrentTime() {
        this.testLocalTimeFunc(SqlOperatorTest.currentTimeString(LOCAL_TZ));
    }

    @Test
    void testLocalTimeFuncWithFixedTime() {
        this.testLocalTimeFunc(SqlOperatorTest.fixedTimeString(LOCAL_TZ));
    }

    private void testLocalTimeFunc(Pair<String, Hook.Closeable> pair) {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.LOCALTIME, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalar("LOCALTIME", TIME_PATTERN, "TIME(0) NOT NULL");
        f.checkFails("^LOCALTIME()^", "No match found for function signature LOCALTIME\\(\\)", false);
        f.checkScalar("LOCALTIME(1)", TIME_PATTERN, "TIME(1) NOT NULL");
        f.checkScalar("CAST(LOCALTIME AS VARCHAR(30))", Pattern.compile(((String)pair.left).substring(11) + "[0-9][0-9]:[0-9][0-9]"), "VARCHAR(30) NOT NULL");
        f.checkScalar("LOCALTIME", Pattern.compile(((String)pair.left).substring(11) + "[0-9][0-9]:[0-9][0-9]"), "TIME(0) NOT NULL");
        ((Hook.Closeable)pair.right).close();
    }

    @Tag(value="slow")
    @Test
    void testLocalTimestampFuncWithCurrentTime() {
        this.testLocalTimestampFunc(SqlOperatorTest.currentTimeString(LOCAL_TZ));
    }

    @Test
    void testLocalTimestampFuncWithFixedTime() {
        this.testLocalTimestampFunc(SqlOperatorTest.fixedTimeString(LOCAL_TZ));
    }

    private void testLocalTimestampFunc(Pair<String, Hook.Closeable> pair) {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.LOCALTIMESTAMP, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalar("LOCALTIMESTAMP", TIMESTAMP_PATTERN, "TIMESTAMP(0) NOT NULL");
        f.checkFails("^LOCALTIMESTAMP()^", "No match found for function signature LOCALTIMESTAMP\\(\\)", false);
        f.checkFails("^LOCALTIMESTAMP(4000000000)^", "(?s).*Numeric literal.*out of range.*", false);
        f.checkFails("^LOCALTIMESTAMP(9223372036854775807)^", "(?s).*Numeric literal.*out of range.*", false);
        f.checkScalar("LOCALTIMESTAMP(1)", TIMESTAMP_PATTERN, "TIMESTAMP(1) NOT NULL");
        f.checkScalar("CAST(LOCALTIMESTAMP AS VARCHAR(30))", Pattern.compile((String)pair.left + "[0-9][0-9]:[0-9][0-9]"), "VARCHAR(30) NOT NULL");
        f.checkScalar("LOCALTIMESTAMP", Pattern.compile((String)pair.left + "[0-9][0-9]:[0-9][0-9]"), "TIMESTAMP(0) NOT NULL");
        ((Hook.Closeable)pair.right).close();
    }

    @Tag(value="slow")
    @Test
    void testCurrentTimeFuncWithCurrentTime() {
        this.testCurrentTimeFunc(SqlOperatorTest.currentTimeString(CURRENT_TZ));
    }

    @Test
    void testCurrentTimeFuncWithFixedTime() {
        this.testCurrentTimeFunc(SqlOperatorTest.fixedTimeString(CURRENT_TZ));
    }

    private void testCurrentTimeFunc(Pair<String, Hook.Closeable> pair) {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CURRENT_TIME, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalar("CURRENT_TIME", TIME_PATTERN, "TIME(0) NOT NULL");
        f.checkFails("^CURRENT_TIME()^", "No match found for function signature CURRENT_TIME\\(\\)", false);
        f.checkScalar("CURRENT_TIME(1)", TIME_PATTERN, "TIME(1) NOT NULL");
        f.checkScalar("CAST(CURRENT_TIME AS VARCHAR(30))", Pattern.compile(((String)pair.left).substring(11) + "[0-9][0-9]:[0-9][0-9]"), "VARCHAR(30) NOT NULL");
        f.checkScalar("CURRENT_TIME", Pattern.compile(((String)pair.left).substring(11) + "[0-9][0-9]:[0-9][0-9]"), "TIME(0) NOT NULL");
        ((Hook.Closeable)pair.right).close();
    }

    @Tag(value="slow")
    @Test
    void testCurrentTimestampFuncWithCurrentTime() {
        this.testCurrentTimestampFunc(SqlOperatorTest.currentTimeString(CURRENT_TZ));
    }

    @Test
    void testCurrentTimestampFuncWithFixedTime() {
        this.testCurrentTimestampFunc(SqlOperatorTest.fixedTimeString(CURRENT_TZ));
    }

    private void testCurrentTimestampFunc(Pair<String, Hook.Closeable> pair) {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CURRENT_TIMESTAMP, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalar("CURRENT_TIMESTAMP", TIMESTAMP_PATTERN, "TIMESTAMP(0) NOT NULL");
        f.checkFails("^CURRENT_TIMESTAMP()^", "No match found for function signature CURRENT_TIMESTAMP\\(\\)", false);
        f.checkFails("^CURRENT_TIMESTAMP(4000000000)^", "(?s).*Numeric literal.*out of range.*", false);
        f.checkScalar("CURRENT_TIMESTAMP(1)", TIMESTAMP_PATTERN, "TIMESTAMP(1) NOT NULL");
        f.checkScalar("CAST(CURRENT_TIMESTAMP AS VARCHAR(30))", Pattern.compile((String)pair.left + "[0-9][0-9]:[0-9][0-9]"), "VARCHAR(30) NOT NULL");
        f.checkScalar("CURRENT_TIMESTAMP", Pattern.compile((String)pair.left + "[0-9][0-9]:[0-9][0-9]"), "TIMESTAMP(0) NOT NULL");
        ((Hook.Closeable)pair.right).close();
    }

    protected static Pair<String, Hook.Closeable> currentTimeString(TimeZone tz) {
        Calendar calendar = SqlOperatorTest.getCalendarNotTooNear(11);
        Hook.Closeable closeable = () -> {};
        return Pair.of((Object)SqlOperatorTest.toTimeString(tz, calendar), (Object)closeable);
    }

    private static Pair<String, Hook.Closeable> fixedTimeString(TimeZone tz) {
        Calendar calendar = SqlOperatorTest.getFixedCalendar();
        long timeInMillis = calendar.getTimeInMillis();
        Consumer<Holder> consumer = o -> o.set((Object)timeInMillis);
        Hook.Closeable closeable = Hook.CURRENT_TIME.addThread(consumer);
        return Pair.of((Object)SqlOperatorTest.toTimeString(tz, calendar), (Object)closeable);
    }

    private static String toTimeString(TimeZone tz, Calendar cal) {
        SimpleDateFormat sdf = DateTimeStringUtils.getDateFormatter((String)"yyyy-MM-dd HH:", (TimeZone)tz);
        return sdf.format(cal.getTime());
    }

    @Tag(value="slow")
    @Test
    void testCurrentDateFuncWithCurrentTime() {
        this.testCurrentDateFunc(SqlOperatorTest.currentTimeString(LOCAL_TZ));
    }

    @Test
    void testCurrentDateFuncWithFixedTime() {
        this.testCurrentDateFunc(SqlOperatorTest.fixedTimeString(LOCAL_TZ));
    }

    private void testCurrentDateFunc(Pair<String, Hook.Closeable> pair) {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CURRENT_DATE, VM_FENNEL);
        SqlOperatorFixture f1 = f.withConformance((SqlConformance)SqlConformanceEnum.LENIENT);
        f.checkScalar("CURRENT_DATE", DATE_PATTERN, "DATE NOT NULL");
        f.checkScalar("(CURRENT_DATE - CURRENT_DATE) DAY", "+0", "INTERVAL DAY NOT NULL");
        f.checkBoolean("CURRENT_DATE IS NULL", false);
        f.checkBoolean("CURRENT_DATE IS NOT NULL", true);
        f.checkBoolean("NOT (CURRENT_DATE IS NULL)", true);
        f.checkFails("^CURRENT_DATE()^", "No match found for function signature CURRENT_DATE\\(\\)", false);
        f1.checkBoolean("CURRENT_DATE() IS NULL", false);
        f1.checkBoolean("CURRENT_DATE IS NOT NULL", true);
        f1.checkBoolean("NOT (CURRENT_DATE() IS NULL)", true);
        f1.checkType("CURRENT_DATE", "DATE NOT NULL");
        f1.checkType("CURRENT_DATE()", "DATE NOT NULL");
        f1.checkType("CURRENT_TIMESTAMP()", "TIMESTAMP(0) NOT NULL");
        f1.checkType("CURRENT_TIME()", "TIME(0) NOT NULL");
        String dateString = (String)pair.left;
        try (Hook.Closeable ignore = (Hook.Closeable)pair.right;){
            f.checkScalar("CAST(CURRENT_DATE AS VARCHAR(30))", dateString.substring(0, 10), "VARCHAR(30) NOT NULL");
            f.checkScalar("CURRENT_DATE", dateString.substring(0, 10), "DATE NOT NULL");
            f1.checkScalar("CAST(CURRENT_DATE AS VARCHAR(30))", dateString.substring(0, 10), "VARCHAR(30) NOT NULL");
            f1.checkScalar("CAST(CURRENT_DATE() AS VARCHAR(30))", dateString.substring(0, 10), "VARCHAR(30) NOT NULL");
            f1.checkScalar("CURRENT_DATE", dateString.substring(0, 10), "DATE NOT NULL");
            f1.checkScalar("CURRENT_DATE()", dateString.substring(0, 10), "DATE NOT NULL");
        }
    }

    @Test
    void testLastDayFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.LAST_DAY, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalar("last_day(DATE '2019-02-10')", "2019-02-28", "DATE NOT NULL");
        f.checkScalar("last_day(DATE '2019-06-10')", "2019-06-30", "DATE NOT NULL");
        f.checkScalar("last_day(DATE '2019-07-10')", "2019-07-31", "DATE NOT NULL");
        f.checkScalar("last_day(DATE '2019-09-10')", "2019-09-30", "DATE NOT NULL");
        f.checkScalar("last_day(DATE '2019-12-10')", "2019-12-31", "DATE NOT NULL");
        f.checkScalar("last_day(DATE '9999-12-10')", "9999-12-31", "DATE NOT NULL");
        f.checkScalar("last_day(DATE '1900-01-01')", "1900-01-31", "DATE NOT NULL");
        f.checkScalar("last_day(DATE '1935-02-01')", "1935-02-28", "DATE NOT NULL");
        f.checkScalar("last_day(DATE '1965-09-01')", "1965-09-30", "DATE NOT NULL");
        f.checkScalar("last_day(DATE '1970-01-01')", "1970-01-31", "DATE NOT NULL");
        f.checkScalar("last_day(DATE '2019-02-28')", "2019-02-28", "DATE NOT NULL");
        f.checkScalar("last_day(DATE '2019-12-31')", "2019-12-31", "DATE NOT NULL");
        f.checkScalar("last_day(DATE '2019-01-01')", "2019-01-31", "DATE NOT NULL");
        f.checkScalar("last_day(DATE '2019-06-30')", "2019-06-30", "DATE NOT NULL");
        f.checkScalar("last_day(DATE '2020-02-20')", "2020-02-29", "DATE NOT NULL");
        f.checkScalar("last_day(DATE '2020-02-29')", "2020-02-29", "DATE NOT NULL");
        f.checkScalar("last_day(DATE '9999-12-31')", "9999-12-31", "DATE NOT NULL");
        f.checkNull("last_day(cast(null as date))");
        f.checkScalar("last_day(TIMESTAMP '2019-02-10 02:10:12')", "2019-02-28", "DATE NOT NULL");
        f.checkScalar("last_day(TIMESTAMP '2019-06-10 06:10:16')", "2019-06-30", "DATE NOT NULL");
        f.checkScalar("last_day(TIMESTAMP '2019-07-10 07:10:17')", "2019-07-31", "DATE NOT NULL");
        f.checkScalar("last_day(TIMESTAMP '2019-09-10 09:10:19')", "2019-09-30", "DATE NOT NULL");
        f.checkScalar("last_day(TIMESTAMP '2019-12-10 12:10:22')", "2019-12-31", "DATE NOT NULL");
        f.checkScalar("last_day(TIMESTAMP '1900-01-01 01:01:02')", "1900-01-31", "DATE NOT NULL");
        f.checkScalar("last_day(TIMESTAMP '1935-02-01 02:01:03')", "1935-02-28", "DATE NOT NULL");
        f.checkScalar("last_day(TIMESTAMP '1970-01-01 01:01:02')", "1970-01-31", "DATE NOT NULL");
        f.checkScalar("last_day(TIMESTAMP '2019-02-28 02:28:30')", "2019-02-28", "DATE NOT NULL");
        f.checkScalar("last_day(TIMESTAMP '2019-12-31 12:31:43')", "2019-12-31", "DATE NOT NULL");
        f.checkScalar("last_day(TIMESTAMP '2019-01-01 01:01:02')", "2019-01-31", "DATE NOT NULL");
        f.checkScalar("last_day(TIMESTAMP '2019-06-30 06:30:36')", "2019-06-30", "DATE NOT NULL");
        f.checkScalar("last_day(TIMESTAMP '2020-02-20 02:20:33')", "2020-02-29", "DATE NOT NULL");
        f.checkScalar("last_day(TIMESTAMP '2020-02-29 02:29:31')", "2020-02-29", "DATE NOT NULL");
        f.checkScalar("last_day(TIMESTAMP '9999-12-31 12:31:43')", "9999-12-31", "DATE NOT NULL");
        f.checkNull("last_day(cast(null as timestamp))");
    }

    @Test
    void testLpadFunction() {
        SqlOperatorFixture f = this.fixture().withLibrary(SqlLibrary.BIG_QUERY);
        f.setFor((SqlOperator)SqlLibraryOperators.LPAD, new SqlOperatorFixture.VmName[0]);
        f.check("select lpad('12345', 8, 'a')", "VARCHAR(5) NOT NULL", (Object)"aaa12345");
        f.checkString("lpad('12345', 8)", "   12345", "VARCHAR(5) NOT NULL");
        f.checkString("lpad('12345', 8, 'ab')", "aba12345", "VARCHAR(5) NOT NULL");
        f.checkString("lpad('12345', 3, 'a')", "123", "VARCHAR(5) NOT NULL");
        f.checkFails("lpad('12345', -3, 'a')", "Second argument for LPAD/RPAD must not be negative", true);
        f.checkFails("lpad('12345', -3)", "Second argument for LPAD/RPAD must not be negative", true);
        f.checkFails("lpad('12345', 3, '')", "Third argument (pad pattern) for LPAD/RPAD must not be empty", true);
        f.checkString("lpad(x'aa', 4, x'bb')", "bbbbbbaa", "VARBINARY(1) NOT NULL");
        f.checkString("lpad(x'aa', 4)", "202020aa", "VARBINARY(1) NOT NULL");
        f.checkString("lpad(x'aaaaaa', 2)", "aaaa", "VARBINARY(3) NOT NULL");
        f.checkString("lpad(x'aaaaaa', 2, x'bb')", "aaaa", "VARBINARY(3) NOT NULL");
        f.checkFails("lpad(x'aa', -3, x'bb')", "Second argument for LPAD/RPAD must not be negative", true);
        f.checkFails("lpad(x'aa', -3)", "Second argument for LPAD/RPAD must not be negative", true);
        f.checkFails("lpad(x'aa', 3, x'')", "Third argument (pad pattern) for LPAD/RPAD must not be empty", true);
    }

    @Test
    void testRpadFunction() {
        SqlOperatorFixture f = this.fixture().withLibrary(SqlLibrary.BIG_QUERY);
        f.setFor((SqlOperator)SqlLibraryOperators.RPAD, new SqlOperatorFixture.VmName[0]);
        f.check("select rpad('12345', 8, 'a')", "VARCHAR(5) NOT NULL", (Object)"12345aaa");
        f.checkString("rpad('12345', 8)", "12345   ", "VARCHAR(5) NOT NULL");
        f.checkString("rpad('12345', 8, 'ab')", "12345aba", "VARCHAR(5) NOT NULL");
        f.checkString("rpad('12345', 3, 'a')", "123", "VARCHAR(5) NOT NULL");
        f.checkFails("rpad('12345', -3, 'a')", "Second argument for LPAD/RPAD must not be negative", true);
        f.checkFails("rpad('12345', -3)", "Second argument for LPAD/RPAD must not be negative", true);
        f.checkFails("rpad('12345', 3, '')", "Third argument (pad pattern) for LPAD/RPAD must not be empty", true);
        f.checkString("rpad(x'aa', 4, x'bb')", "aabbbbbb", "VARBINARY(1) NOT NULL");
        f.checkString("rpad(x'aa', 4)", "aa202020", "VARBINARY(1) NOT NULL");
        f.checkString("rpad(x'aaaaaa', 2)", "aaaa", "VARBINARY(3) NOT NULL");
        f.checkString("rpad(x'aaaaaa', 2, x'bb')", "aaaa", "VARBINARY(3) NOT NULL");
        f.checkFails("rpad(x'aa', -3, x'bb')", "Second argument for LPAD/RPAD must not be negative", true);
        f.checkFails("rpad(x'aa', -3)", "Second argument for LPAD/RPAD must not be negative", true);
        f.checkFails("rpad(x'aa', 3, x'')", "Third argument (pad pattern) for LPAD/RPAD must not be empty", true);
    }

    @Test
    void testStartsWithFunction() {
        SqlOperatorFixture f = this.fixture().withLibrary(SqlLibrary.BIG_QUERY);
        f.setFor((SqlOperator)SqlLibraryOperators.STARTS_WITH, new SqlOperatorFixture.VmName[0]);
        f.checkBoolean("starts_with('12345', '123')", true);
        f.checkBoolean("starts_with('12345', '1243')", false);
        f.checkBoolean("starts_with(x'11', x'11')", true);
        f.checkBoolean("starts_with(x'112211', x'33')", false);
        f.checkFails("^starts_with('aabbcc', x'aa')^", "Cannot apply 'STARTS_WITH' to arguments of type 'STARTS_WITH\\(<CHAR\\(6\\)>, <BINARY\\(1\\)>\\)'\\. Supported form\\(s\\): 'STARTS_WITH\\(<STRING>, <STRING>\\)'", false);
        f.checkNull("starts_with(null, null)");
        f.checkNull("starts_with('12345', null)");
        f.checkNull("starts_with(null, '123')");
        f.checkBoolean("starts_with('', '123')", false);
        f.checkBoolean("starts_with('', '')", true);
        f.checkNull("starts_with(x'aa', null)");
        f.checkNull("starts_with(null, x'aa')");
        f.checkBoolean("starts_with(x'1234', x'')", true);
        f.checkBoolean("starts_with(x'', x'123456')", false);
        f.checkBoolean("starts_with(x'', x'')", true);
    }

    @Test
    void testEndsWithFunction() {
        SqlOperatorFixture f = this.fixture().withLibrary(SqlLibrary.BIG_QUERY);
        f.setFor((SqlOperator)SqlLibraryOperators.ENDS_WITH, new SqlOperatorFixture.VmName[0]);
        f.checkBoolean("ends_with('12345', '345')", true);
        f.checkBoolean("ends_with('12345', '123')", false);
        f.checkBoolean("ends_with(x'11', x'11')", true);
        f.checkBoolean("ends_with(x'112211', x'33')", false);
        f.checkFails("^ends_with('aabbcc', x'aa')^", "Cannot apply 'ENDS_WITH' to arguments of type 'ENDS_WITH\\(<CHAR\\(6\\)>, <BINARY\\(1\\)>\\)'\\. Supported form\\(s\\): 'ENDS_WITH\\(<STRING>, <STRING>\\)'", false);
        f.checkNull("ends_with(null, null)");
        f.checkNull("ends_with('12345', null)");
        f.checkNull("ends_with(null, '123')");
        f.checkBoolean("ends_with('', '123')", false);
        f.checkBoolean("ends_with('', '')", true);
        f.checkNull("ends_with(x'aa', null)");
        f.checkNull("ends_with(null, x'aa')");
        f.checkBoolean("ends_with(x'1234', x'')", true);
        f.checkBoolean("ends_with(x'', x'123456')", false);
        f.checkBoolean("ends_with(x'', x'')", true);
    }

    @Test
    void testSubstringFunction() {
        SqlOperatorFixture f = this.fixture();
        SqlOperatorTest.checkSubstringFunction(f);
        SqlOperatorTest.checkSubstringFunction(f.withConformance((SqlConformance)SqlConformanceEnum.BIG_QUERY));
    }

    private static void checkSubstringFunction(SqlOperatorFixture f) {
        f.setFor((SqlOperator)SqlStdOperatorTable.SUBSTRING, new SqlOperatorFixture.VmName[0]);
        f.checkString("substring('abc' from 1 for 2)", "ab", "VARCHAR(3) NOT NULL");
        f.checkString("substring(x'aabbcc' from 1 for 2)", "aabb", "VARBINARY(3) NOT NULL");
        switch (f.conformance().semantics()) {
            case BIG_QUERY: {
                f.checkString("substring('abc' from 1 for -1)", "", "VARCHAR(3) NOT NULL");
                f.checkString("substring(x'aabbcc' from 1 for -1)", "", "VARBINARY(3) NOT NULL");
                break;
            }
            default: {
                f.checkFails("substring('abc' from 1 for -1)", "Substring error: negative substring length not allowed", true);
                f.checkFails("substring(x'aabbcc' from 1 for -1)", "Substring error: negative substring length not allowed", true);
            }
        }
        f.checkNull("substring(cast(null as varchar(1)),1,2)");
        f.checkNull("substring(cast(null as varchar(1)) FROM 1 FOR 2)");
        f.checkNull("substring('abc' FROM cast(null as integer) FOR 2)");
        f.checkNull("substring('abc' FROM cast(null as integer))");
        f.checkNull("substring('abc' FROM 2 FOR cast(null as integer))");
    }

    @Test
    void testBigQuerySubstrFunction() {
        this.substrChecker(SqlLibrary.BIG_QUERY, SqlLibraryOperators.SUBSTR_BIG_QUERY).check();
    }

    @Test
    void testMysqlSubstrFunction() {
        this.substrChecker(SqlLibrary.MYSQL, SqlLibraryOperators.SUBSTR_MYSQL).check();
    }

    @Test
    void testOracleSubstrFunction() {
        this.substrChecker(SqlLibrary.ORACLE, SqlLibraryOperators.SUBSTR_ORACLE).check();
    }

    @Test
    void testPostgresqlSubstrFunction() {
        this.substrChecker(SqlLibrary.POSTGRESQL, SqlLibraryOperators.SUBSTR_POSTGRESQL).check();
    }

    @Test
    void testBigQuerySubstringFunction() {
        this.substringChecker(SqlConformanceEnum.BIG_QUERY, SqlLibrary.BIG_QUERY).check();
    }

    @Test
    void testStandardSubstringFunction() {
        this.substringChecker(SqlConformanceEnum.STRICT_2003, SqlLibrary.POSTGRESQL).check();
    }

    SubFunChecker substringChecker(SqlConformanceEnum conformance, SqlLibrary library) {
        SqlOperatorFixture f = this.fixture();
        return new SubFunChecker(f.withConnectionFactory(cf -> cf.with(ConnectionFactories.add(CalciteAssert.SchemaSpec.HR)).with((ConnectionProperty)CalciteConnectionProperty.CONFORMANCE, (Object)conformance)), library, SqlStdOperatorTable.SUBSTRING);
    }

    SubFunChecker substrChecker(SqlLibrary library, SqlFunction function) {
        return new SubFunChecker(this.fixture().withLibrary(library), library, function);
    }

    @Test
    void testTrimFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.TRIM, SqlOperatorFixture.VmName.EXPAND);
        f.checkString("trim('a' from 'aAa')", "A", "VARCHAR(3) NOT NULL");
        f.checkString("trim(both 'a' from 'aAa')", "A", "VARCHAR(3) NOT NULL");
        f.checkString("trim(leading 'a' from 'aAa')", "Aa", "VARCHAR(3) NOT NULL");
        f.checkString("trim(trailing 'a' from 'aAa')", "aA", "VARCHAR(3) NOT NULL");
        f.checkNull("trim(cast(null as varchar(1)) from 'a')");
        f.checkNull("trim('a' from cast(null as varchar(1)))");
        f.checkFails("trim('xy' from 'abcde')", "Trim error: trim character must be exactly 1 character", true);
        f.checkFails("trim('' from 'abcde')", "Trim error: trim character must be exactly 1 character", true);
        SqlOperatorFixture f1 = f.withConformance((SqlConformance)SqlConformanceEnum.MYSQL_5);
        f1.checkString("trim(leading 'eh' from 'hehe__hehe')", "__hehe", "VARCHAR(10) NOT NULL");
        f1.checkString("trim(trailing 'eh' from 'hehe__hehe')", "hehe__", "VARCHAR(10) NOT NULL");
        f1.checkString("trim('eh' from 'hehe__hehe')", "__", "VARCHAR(10) NOT NULL");
    }

    @Test
    void testRtrimFunc() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlLibraryOperators.RTRIM, SqlOperatorFixture.VmName.EXPAND);
        f0.checkFails("^rtrim(' aaa')^", "No match found for function signature RTRIM\\(<CHARACTER>\\)", false);
        Consumer<SqlOperatorFixture> consumer = f -> {
            f.checkString("rtrim(' aAa  ')", " aAa", "VARCHAR(6) NOT NULL");
            f.checkNull("rtrim(CAST(NULL AS VARCHAR(6)))");
        };
        f0.forEachLibrary((Iterable<? extends SqlLibrary>)Expressions.list((Object[])new SqlLibrary[]{SqlLibrary.BIG_QUERY, SqlLibrary.ORACLE}), consumer);
    }

    @Test
    void testLtrimFunc() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlLibraryOperators.LTRIM, SqlOperatorFixture.VmName.EXPAND);
        f0.checkFails("^ltrim('  aa')^", "No match found for function signature LTRIM\\(<CHARACTER>\\)", false);
        Consumer<SqlOperatorFixture> consumer = f -> {
            f.checkString("ltrim(' aAa  ')", "aAa  ", "VARCHAR(6) NOT NULL");
            f.checkNull("ltrim(CAST(NULL AS VARCHAR(6)))");
        };
        f0.forEachLibrary((Iterable<? extends SqlLibrary>)Expressions.list((Object[])new SqlLibrary[]{SqlLibrary.BIG_QUERY, SqlLibrary.ORACLE}), consumer);
    }

    @Test
    void testGreatestFunc() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlLibraryOperators.GREATEST, SqlOperatorFixture.VmName.EXPAND);
        f0.checkFails("^greatest('on', 'earth')^", "No match found for function signature GREATEST\\(<CHARACTER>, <CHARACTER>\\)", false);
        Consumer<SqlOperatorFixture> consumer = f -> {
            f.checkString("greatest('on', 'earth')", "on   ", "CHAR(5) NOT NULL");
            f.checkString("greatest('show', 'on', 'earth')", "show ", "CHAR(5) NOT NULL");
            f.checkScalar("greatest(12, CAST(NULL AS INTEGER), 3)", ResultCheckers.isNullValue(), "INTEGER");
            f.checkScalar("greatest(false, true)", true, "BOOLEAN NOT NULL");
            SqlOperatorFixture f12 = f.forOracle((SqlConformance)SqlConformanceEnum.ORACLE_12);
            f12.checkString("greatest('on', 'earth')", "on", "VARCHAR(5) NOT NULL");
            f12.checkString("greatest('show', 'on', 'earth')", "show", "VARCHAR(5) NOT NULL");
        };
        f0.forEachLibrary((Iterable<? extends SqlLibrary>)Expressions.list((Object[])new SqlLibrary[]{SqlLibrary.BIG_QUERY, SqlLibrary.ORACLE}), consumer);
    }

    @Test
    void testLeastFunc() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlLibraryOperators.LEAST, SqlOperatorFixture.VmName.EXPAND);
        f0.checkFails("^least('on', 'earth')^", "No match found for function signature LEAST\\(<CHARACTER>, <CHARACTER>\\)", false);
        Consumer<SqlOperatorFixture> consumer = f -> {
            f.checkString("least('on', 'earth')", "earth", "CHAR(5) NOT NULL");
            f.checkString("least('show', 'on', 'earth')", "earth", "CHAR(5) NOT NULL");
            f.checkScalar("least(12, CAST(NULL AS INTEGER), 3)", ResultCheckers.isNullValue(), "INTEGER");
            f.checkScalar("least(false, true)", false, "BOOLEAN NOT NULL");
            SqlOperatorFixture f12 = f0.forOracle((SqlConformance)SqlConformanceEnum.ORACLE_12);
            f12.checkString("least('on', 'earth')", "earth", "VARCHAR(5) NOT NULL");
            f12.checkString("least('show', 'on', 'earth')", "earth", "VARCHAR(5) NOT NULL");
        };
        f0.forEachLibrary((Iterable<? extends SqlLibrary>)Expressions.list((Object[])new SqlLibrary[]{SqlLibrary.BIG_QUERY, SqlLibrary.ORACLE}), consumer);
    }

    @Test
    void testNvlFunc() {
        SqlOperatorFixture f = this.fixture().setFor((SqlOperator)SqlLibraryOperators.NVL, SqlOperatorFixture.VmName.EXPAND).withLibrary(SqlLibrary.ORACLE);
        f.checkScalar("nvl(1, 2)", "1", "INTEGER NOT NULL");
        f.checkFails("^nvl(1, true)^", "Parameters must be of the same type", false);
        f.checkScalar("nvl(true, false)", true, "BOOLEAN NOT NULL");
        f.checkScalar("nvl(false, true)", false, "BOOLEAN NOT NULL");
        f.checkString("nvl('abc', 'de')", "abc", "CHAR(3) NOT NULL");
        f.checkString("nvl('abc', 'defg')", "abc ", "CHAR(4) NOT NULL");
        f.checkString("nvl('abc', CAST(NULL AS VARCHAR(20)))", "abc", "VARCHAR(20) NOT NULL");
        f.checkString("nvl(CAST(NULL AS VARCHAR(20)), 'abc')", "abc", "VARCHAR(20) NOT NULL");
        f.checkNull("nvl(CAST(NULL AS VARCHAR(6)), cast(NULL AS VARCHAR(4)))");
        SqlOperatorFixture f12 = f.forOracle((SqlConformance)SqlConformanceEnum.ORACLE_12);
        f12.checkString("nvl('abc', 'de')", "abc", "VARCHAR(3) NOT NULL");
        f12.checkString("nvl('abc', 'defg')", "abc", "VARCHAR(4) NOT NULL");
        f12.checkString("nvl('abc', CAST(NULL AS VARCHAR(20)))", "abc", "VARCHAR(20) NOT NULL");
        f12.checkString("nvl(CAST(NULL AS VARCHAR(20)), 'abc')", "abc", "VARCHAR(20) NOT NULL");
        f12.checkNull("nvl(CAST(NULL AS VARCHAR(6)), cast(NULL AS VARCHAR(4)))");
    }

    @Test
    void testIfnullFunc() {
        SqlOperatorFixture f = this.fixture().withLibrary(SqlLibrary.BIG_QUERY).setFor((SqlOperator)SqlLibraryOperators.IFNULL, VM_EXPAND);
        f.checkString("ifnull('a','b')", "a", "CHAR(1) NOT NULL");
        f.checkString("ifnull(null,'b')", "b", "CHAR(1) NOT NULL");
        f.checkScalar("ifnull(4,3)", 4, "INTEGER NOT NULL");
        f.checkScalar("ifnull(null, 4)", 4, "INTEGER NOT NULL");
        f.enableTypeCoercion(false).checkFails("1 + ifnull('a', 1) + 2", "Cannot infer return type for IFNULL; operand types: \\[CHAR\\(1\\), INTEGER\\]", false);
        f.checkType("1 + ifnull(1, null) + 2", "INTEGER NOT NULL");
        f.checkFails("^ifnull(1,2,3)^", "Invalid number of arguments to function 'IFNULL'. Was expecting 2 arguments", false);
        f.checkFails("^ifnull(1)^", "Invalid number of arguments to function 'IFNULL'. Was expecting 2 arguments", false);
    }

    @Test
    void testDecodeFunc() {
        SqlOperatorTest.checkDecodeFunc(this.fixture().withLibrary(SqlLibrary.ORACLE));
    }

    private static void checkDecodeFunc(SqlOperatorFixture f) {
        f.setFor((SqlOperator)SqlLibraryOperators.DECODE, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalar("decode(0, 0, 'a', 1, 'b', 2, 'c')", "a", "CHAR(1)");
        f.checkScalar("decode(1, 0, 'a', 1, 'b', 2, 'c')", "b", "CHAR(1)");
        f.checkScalar("decode(1, 0, 'a', 1, 'b', 1, 'z', 2, 'c')", "b", "CHAR(1)");
        f.checkScalar("decode(3, 0, 'a', 1, 'b', 2, 'c')", ResultCheckers.isNullValue(), "CHAR(1)");
        f.checkScalar("decode(3, 0, 'a', 1, 'b', 2, 'c', 'd')", "d", "CHAR(1) NOT NULL");
        f.checkScalar("decode(1, 0, 'a', 1, 'b', 2, 'c', 'd')", "b", "CHAR(1) NOT NULL");
        f.checkScalar("decode(cast(null as integer), 0, 'a',\n cast(null as integer), 'b', 2, 'c', 'd')", "b", "CHAR(1) NOT NULL");
    }

    @Test
    void testWindow() {
        SqlOperatorFixture f = this.fixture();
        f.check("select sum(1) over (order by x)\nfrom (select 1 as x, 2 as y\n  from (values (true)))", SqlTests.INTEGER_TYPE_CHECKER, (Object)1);
    }

    @Test
    void testElementFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.ELEMENT, VM_FENNEL, VM_JAVA);
        f.checkString("element(multiset['abc'])", "abc", "CHAR(3) NOT NULL");
        f.checkNull("element(multiset[cast(null as integer)])");
    }

    @Test
    void testCardinalityFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CARDINALITY, VM_FENNEL, VM_JAVA);
        f.checkScalarExact("cardinality(multiset[cast(null as integer),2])", 2);
        if (!f.brokenTestsEnabled()) {
            return;
        }
        f.checkScalarExact("cardinality(array['foo', 'bar'])", 2);
        f.checkScalarExact("cardinality(map['foo', 1, 'bar', 2])", 2);
    }

    @Test
    void testMemberOfOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.MEMBER_OF, VM_FENNEL, VM_JAVA);
        f.checkBoolean("1 member of multiset[1]", true);
        f.checkBoolean("'2' member of multiset['1']", false);
        f.checkBoolean("cast(null as double) member of multiset[cast(null as double)]", true);
        f.checkBoolean("cast(null as double) member of multiset[1.1]", false);
        f.checkBoolean("1.1 member of multiset[cast(null as double)]", false);
    }

    @Test
    void testMultisetUnionOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.MULTISET_UNION_DISTINCT, VM_FENNEL, VM_JAVA);
        f.checkBoolean("multiset[1,2] submultiset of (multiset[2] multiset union multiset[1])", true);
        f.checkScalar("cardinality(multiset[1, 2, 3, 4, 2] multiset union distinct multiset[1, 4, 5, 7, 8])", "7", "INTEGER NOT NULL");
        f.checkScalar("cardinality(multiset[1, 2, 3, 4, 2] multiset union distinct multiset[1, 4, 5, 7, 8])", "7", "INTEGER NOT NULL");
        f.checkBoolean("(multiset[1, 2, 3, 4, 2] multiset union distinct multiset[1, 4, 5, 7, 8]) submultiset of multiset[1, 2, 3, 4, 5, 7, 8]", true);
        f.checkBoolean("(multiset[1, 2, 3, 4, 2] multiset union distinct multiset[1, 4, 5, 7, 8]) submultiset of multiset[1, 2, 3, 4, 5, 7, 8]", true);
        f.checkScalar("cardinality(multiset['a', 'b', 'c'] multiset union distinct multiset['c', 'd', 'e'])", "5", "INTEGER NOT NULL");
        f.checkScalar("cardinality(multiset['a', 'b', 'c'] multiset union distinct multiset['c', 'd', 'e'])", "5", "INTEGER NOT NULL");
        f.checkBoolean("(multiset['a', 'b', 'c'] multiset union distinct multiset['c', 'd', 'e']) submultiset of multiset['a', 'b', 'c', 'd', 'e']", true);
        f.checkBoolean("(multiset['a', 'b', 'c'] multiset union distinct multiset['c', 'd', 'e']) submultiset of multiset['a', 'b', 'c', 'd', 'e']", true);
        f.checkScalar("multiset[cast(null as double)] multiset union multiset[cast(null as double)]", "[null, null]", "DOUBLE MULTISET NOT NULL");
        f.checkScalar("multiset[cast(null as boolean)] multiset union multiset[cast(null as boolean)]", "[null, null]", "BOOLEAN MULTISET NOT NULL");
    }

    @Test
    void testMultisetUnionAllOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.MULTISET_UNION, VM_FENNEL, VM_JAVA);
        f.checkScalar("cardinality(multiset[1, 2, 3, 4, 2] multiset union all multiset[1, 4, 5, 7, 8])", "10", "INTEGER NOT NULL");
        f.checkBoolean("(multiset[1, 2, 3, 4, 2] multiset union all multiset[1, 4, 5, 7, 8]) submultiset of multiset[1, 2, 3, 4, 5, 7, 8]", false);
        f.checkBoolean("(multiset[1, 2, 3, 4, 2] multiset union all multiset[1, 4, 5, 7, 8]) submultiset of multiset[1, 1, 2, 2, 3, 4, 4, 5, 7, 8]", true);
        f.checkScalar("cardinality(multiset['a', 'b', 'c'] multiset union all multiset['c', 'd', 'e'])", "6", "INTEGER NOT NULL");
        f.checkBoolean("(multiset['a', 'b', 'c'] multiset union all multiset['c', 'd', 'e']) submultiset of multiset['a', 'b', 'c', 'd', 'e']", false);
        f.checkBoolean("(multiset['a', 'b', 'c'] multiset union distinct multiset['c', 'd', 'e']) submultiset of multiset['a', 'b', 'c', 'd', 'e', 'c']", true);
        f.checkScalar("multiset[cast(null as double)] multiset union all multiset[cast(null as double)]", "[null, null]", "DOUBLE MULTISET NOT NULL");
        f.checkScalar("multiset[cast(null as boolean)] multiset union all multiset[cast(null as boolean)]", "[null, null]", "BOOLEAN MULTISET NOT NULL");
    }

    @Test
    void testSubMultisetOfOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.SUBMULTISET_OF, VM_FENNEL, VM_JAVA);
        f.checkBoolean("multiset[2] submultiset of multiset[1]", false);
        f.checkBoolean("multiset[1] submultiset of multiset[1]", true);
        f.checkBoolean("multiset[1, 2] submultiset of multiset[1]", false);
        f.checkBoolean("multiset[1] submultiset of multiset[1, 2]", true);
        f.checkBoolean("multiset[1, 2] submultiset of multiset[1, 2]", true);
        f.checkBoolean("multiset['a', 'b'] submultiset of multiset['c', 'd', 's', 'a']", false);
        f.checkBoolean("multiset['a', 'd'] submultiset of multiset['c', 's', 'a', 'w', 'd']", true);
        f.checkBoolean("multiset['q', 'a'] submultiset of multiset['a', 'q']", true);
    }

    @Test
    void testNotSubMultisetOfOperator() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.NOT_SUBMULTISET_OF, VM_FENNEL, VM_JAVA);
        f.checkBoolean("multiset[2] not submultiset of multiset[1]", true);
        f.checkBoolean("multiset[1] not submultiset of multiset[1]", false);
        f.checkBoolean("multiset[1, 2] not submultiset of multiset[1]", true);
        f.checkBoolean("multiset[1] not submultiset of multiset[1, 2]", false);
        f.checkBoolean("multiset[1, 2] not submultiset of multiset[1, 2]", false);
        f.checkBoolean("multiset['a', 'b'] not submultiset of multiset['c', 'd', 's', 'a']", true);
        f.checkBoolean("multiset['a', 'd'] not submultiset of multiset['c', 's', 'a', 'w', 'd']", false);
        f.checkBoolean("multiset['q', 'a'] not submultiset of multiset['a', 'q']", false);
    }

    @Test
    void testCollectFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.COLLECT, VM_FENNEL, VM_JAVA);
        f.checkFails("collect(^*^)", "Unknown identifier '\\*'", false);
        f.checkAggType("collect(1)", "INTEGER NOT NULL MULTISET NOT NULL");
        f.checkAggType("collect(1.2)", "DECIMAL(2, 1) NOT NULL MULTISET NOT NULL");
        f.checkAggType("collect(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL MULTISET NOT NULL");
        f.checkFails("^collect()^", "Invalid number of arguments to function 'COLLECT'. Was expecting 1 arguments", false);
        f.checkFails("^collect(1, 2)^", "Invalid number of arguments to function 'COLLECT'. Was expecting 1 arguments", false);
        String[] values = new String[]{"0", "CAST(null AS INTEGER)", "2", "2"};
        f.checkAgg("collect(x)", values, ResultCheckers.isSet("[0, 2, 2]"));
        f.checkAgg("collect(x) within group(order by x desc)", values, ResultCheckers.isSet("[2, 2, 0]"));
        if (!f.brokenTestsEnabled()) {
            return;
        }
        f.checkAgg("collect(CASE x WHEN 0 THEN NULL ELSE -1 END)", values, ResultCheckers.isSingle(-3));
        f.checkAgg("collect(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, ResultCheckers.isSingle(-1));
        f.checkAgg("collect(DISTINCT x)", values, ResultCheckers.isSingle(2));
    }

    @Test
    void testListAggFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.LISTAGG, VM_FENNEL, VM_JAVA);
        f.checkFails("listagg(^*^)", "Unknown identifier '\\*'", false);
        f.checkAggType("listagg(12)", "VARCHAR NOT NULL");
        f.enableTypeCoercion(false).checkFails("^listagg(12)^", "Cannot apply 'LISTAGG' to arguments of type .*'\n.*'", false);
        f.checkAggType("listagg(cast(12 as double))", "VARCHAR NOT NULL");
        f.enableTypeCoercion(false).checkFails("^listagg(cast(12 as double))^", "Cannot apply 'LISTAGG' to arguments of type .*'\n.*'", false);
        f.checkFails("^listagg()^", "Invalid number of arguments to function 'LISTAGG'. Was expecting 1 arguments", false);
        f.checkFails("^listagg('1', '2', '3')^", "Invalid number of arguments to function 'LISTAGG'. Was expecting 1 arguments", false);
        f.checkAggType("listagg('test')", "CHAR(4) NOT NULL");
        f.checkAggType("listagg('test', ', ')", "CHAR(4) NOT NULL");
        String[] values1 = new String[]{"'hello'", "CAST(null AS CHAR)", "'world'", "'!'"};
        f.checkAgg("listagg(x)", values1, ResultCheckers.isSingle("hello,world,!"));
        String[] values2 = new String[]{"0", "1", "2", "3"};
        f.checkAgg("listagg(cast(x as CHAR))", values2, ResultCheckers.isSingle("0,1,2,3"));
    }

    @Test
    void testStringAggFunc() {
        SqlOperatorFixture f = this.fixture();
        SqlOperatorTest.checkStringAggFunc(f.withLibrary(SqlLibrary.POSTGRESQL));
        SqlOperatorTest.checkStringAggFunc(f.withLibrary(SqlLibrary.BIG_QUERY));
        SqlOperatorTest.checkStringAggFuncFails(f.withLibrary(SqlLibrary.MYSQL));
    }

    private static void checkStringAggFunc(SqlOperatorFixture f) {
        String[] values = new String[]{"'x'", "null", "'yz'"};
        f.checkAgg("string_agg(x)", values, ResultCheckers.isSingle("x,yz"));
        f.checkAgg("string_agg(x,':')", values, ResultCheckers.isSingle("x:yz"));
        f.checkAgg("string_agg(x,':' order by x)", values, ResultCheckers.isSingle("x:yz"));
        f.checkAgg("string_agg(x order by char_length(x) desc)", values, ResultCheckers.isSingle("yz,x"));
        f.checkAggFails("^string_agg(x respect nulls order by x desc)^", values, "Cannot specify IGNORE NULLS or RESPECT NULLS following 'STRING_AGG'", false);
        f.checkAggFails("^string_agg(x order by x desc)^ respect nulls", values, "Cannot specify IGNORE NULLS or RESPECT NULLS following 'STRING_AGG'", false);
    }

    private static void checkStringAggFuncFails(SqlOperatorFixture f) {
        String[] values = new String[]{"'x'", "'y'"};
        f.checkAggFails("^string_agg(x)^", values, "No match found for function signature STRING_AGG\\(<CHARACTER>\\)", false);
        f.checkAggFails("^string_agg(x, ',')^", values, "No match found for function signature STRING_AGG\\(<CHARACTER>, <CHARACTER>\\)", false);
        f.checkAggFails("^string_agg(x, ',' order by x desc)^", values, "No match found for function signature STRING_AGG\\(<CHARACTER>, <CHARACTER>\\)", false);
    }

    @Test
    void testGroupConcatFunc() {
        SqlOperatorFixture f = this.fixture();
        SqlOperatorTest.checkGroupConcatFunc(f.withLibrary(SqlLibrary.MYSQL));
        SqlOperatorTest.checkGroupConcatFuncFails(f.withLibrary(SqlLibrary.BIG_QUERY));
        SqlOperatorTest.checkGroupConcatFuncFails(f.withLibrary(SqlLibrary.POSTGRESQL));
    }

    private static void checkGroupConcatFunc(SqlOperatorFixture f) {
        String[] values = new String[]{"'x'", "null", "'yz'"};
        f.checkAgg("group_concat(x)", values, ResultCheckers.isSingle("x,yz"));
        f.checkAgg("group_concat(x,':')", values, ResultCheckers.isSingle("x:yz"));
        f.checkAgg("group_concat(x,':' order by x)", values, ResultCheckers.isSingle("x:yz"));
        f.checkAgg("group_concat(x order by x separator '|')", values, ResultCheckers.isSingle("x|yz"));
        f.checkAgg("group_concat(x order by char_length(x) desc)", values, ResultCheckers.isSingle("yz,x"));
        f.checkAggFails("^group_concat(x respect nulls order by x desc)^", values, "Cannot specify IGNORE NULLS or RESPECT NULLS following 'GROUP_CONCAT'", false);
        f.checkAggFails("^group_concat(x order by x desc)^ respect nulls", values, "Cannot specify IGNORE NULLS or RESPECT NULLS following 'GROUP_CONCAT'", false);
    }

    private static void checkGroupConcatFuncFails(SqlOperatorFixture t) {
        String[] values = new String[]{"'x'", "'y'"};
        t.checkAggFails("^group_concat(x)^", values, "No match found for function signature GROUP_CONCAT\\(<CHARACTER>\\)", false);
        t.checkAggFails("^group_concat(x, ',')^", values, "No match found for function signature GROUP_CONCAT\\(<CHARACTER>, <CHARACTER>\\)", false);
        t.checkAggFails("^group_concat(x, ',' order by x desc)^", values, "No match found for function signature GROUP_CONCAT\\(<CHARACTER>, <CHARACTER>\\)", false);
    }

    @Test
    void testArrayAggFunc() {
        SqlOperatorFixture f = this.fixture();
        SqlOperatorTest.checkArrayAggFunc(f.withLibrary(SqlLibrary.POSTGRESQL));
        SqlOperatorTest.checkArrayAggFunc(f.withLibrary(SqlLibrary.BIG_QUERY));
        SqlOperatorTest.checkArrayAggFuncFails(f.withLibrary(SqlLibrary.MYSQL));
    }

    private static void checkArrayAggFunc(SqlOperatorFixture f) {
        f.setFor((SqlOperator)SqlLibraryOperators.ARRAY_CONCAT_AGG, VM_FENNEL, VM_JAVA);
        String[] values = new String[]{"'x'", "null", "'yz'"};
        f.checkAgg("array_agg(x)", values, ResultCheckers.isSingle("[x, yz]"));
        f.checkAgg("array_agg(x ignore nulls)", values, ResultCheckers.isSingle("[x, yz]"));
        f.checkAgg("array_agg(x respect nulls)", values, ResultCheckers.isSingle("[x, yz]"));
        String expectedError = "Invalid number of arguments to function 'ARRAY_AGG'. Was expecting 1 arguments";
        f.checkAggFails("^array_agg(x,':')^", values, "Invalid number of arguments to function 'ARRAY_AGG'. Was expecting 1 arguments", false);
        f.checkAggFails("^array_agg(x,':' order by x)^", values, "Invalid number of arguments to function 'ARRAY_AGG'. Was expecting 1 arguments", false);
        f.checkAgg("array_agg(x order by char_length(x) desc)", values, ResultCheckers.isSingle("[yz, x]"));
    }

    private static void checkArrayAggFuncFails(SqlOperatorFixture t) {
        t.setFor((SqlOperator)SqlLibraryOperators.ARRAY_CONCAT_AGG, VM_FENNEL, VM_JAVA);
        String[] values = new String[]{"'x'", "'y'"};
        String expectedError = "No match found for function signature ARRAY_AGG\\(<CHARACTER>\\)";
        String expectedError2 = "No match found for function signature ARRAY_AGG\\(<CHARACTER>, <CHARACTER>\\)";
        t.checkAggFails("^array_agg(x)^", values, "No match found for function signature ARRAY_AGG\\(<CHARACTER>\\)", false);
        t.checkAggFails("^array_agg(x, ',')^", values, "No match found for function signature ARRAY_AGG\\(<CHARACTER>, <CHARACTER>\\)", false);
        t.checkAggFails("^array_agg(x, ',' order by x desc)^", values, "No match found for function signature ARRAY_AGG\\(<CHARACTER>, <CHARACTER>\\)", false);
    }

    @Test
    void testArrayConcatAggFunc() {
        SqlOperatorFixture f = this.fixture();
        SqlOperatorTest.checkArrayConcatAggFunc(f.withLibrary(SqlLibrary.POSTGRESQL));
        SqlOperatorTest.checkArrayConcatAggFunc(f.withLibrary(SqlLibrary.BIG_QUERY));
        SqlOperatorTest.checkArrayConcatAggFuncFails(f.withLibrary(SqlLibrary.MYSQL));
    }

    private static void checkArrayConcatAggFunc(SqlOperatorFixture t) {
        t.setFor((SqlOperator)SqlLibraryOperators.ARRAY_CONCAT_AGG, VM_FENNEL, VM_JAVA);
        t.checkFails("array_concat_agg(^*^)", "(?s)Encountered \"\\*\" at .*", false);
        t.checkAggType("array_concat_agg(ARRAY[1,2,3])", "INTEGER NOT NULL ARRAY NOT NULL");
        String expectedError = "Cannot apply 'ARRAY_CONCAT_AGG' to arguments of type 'ARRAY_CONCAT_AGG\\(<INTEGER MULTISET>\\)'. Supported form\\(s\\): 'ARRAY_CONCAT_AGG\\(<ARRAY>\\)'";
        t.checkFails("^array_concat_agg(multiset[1,2])^", "Cannot apply 'ARRAY_CONCAT_AGG' to arguments of type 'ARRAY_CONCAT_AGG\\(<INTEGER MULTISET>\\)'. Supported form\\(s\\): 'ARRAY_CONCAT_AGG\\(<ARRAY>\\)'", false);
        String expectedError1 = "Cannot apply 'ARRAY_CONCAT_AGG' to arguments of type 'ARRAY_CONCAT_AGG\\(<INTEGER>\\)'\\. Supported form\\(s\\): 'ARRAY_CONCAT_AGG\\(<ARRAY>\\)'";
        t.checkFails("^array_concat_agg(12)^", "Cannot apply 'ARRAY_CONCAT_AGG' to arguments of type 'ARRAY_CONCAT_AGG\\(<INTEGER>\\)'\\. Supported form\\(s\\): 'ARRAY_CONCAT_AGG\\(<ARRAY>\\)'", false);
        String[] values1 = new String[]{"ARRAY[0]", "ARRAY[1]", "ARRAY[2]", "ARRAY[3]"};
        t.checkAgg("array_concat_agg(x)", values1, ResultCheckers.isSingle("[0, 1, 2, 3]"));
        String[] values2 = new String[]{"ARRAY[0,1]", "ARRAY[1, 2]"};
        t.checkAgg("array_concat_agg(x)", values2, ResultCheckers.isSingle("[0, 1, 1, 2]"));
    }

    private static void checkArrayConcatAggFuncFails(SqlOperatorFixture t) {
        t.setFor((SqlOperator)SqlLibraryOperators.ARRAY_CONCAT_AGG, VM_FENNEL, VM_JAVA);
        String[] values = new String[]{"'x'", "'y'"};
        String expectedError = "No match found for function signature ARRAY_CONCAT_AGG\\(<CHARACTER>\\)";
        String expectedError2 = "No match found for function signature ARRAY_CONCAT_AGG\\(<CHARACTER>, <CHARACTER>\\)";
        t.checkAggFails("^array_concat_agg(x)^", values, "No match found for function signature ARRAY_CONCAT_AGG\\(<CHARACTER>\\)", false);
        t.checkAggFails("^array_concat_agg(x, ',')^", values, "No match found for function signature ARRAY_CONCAT_AGG\\(<CHARACTER>, <CHARACTER>\\)", false);
        t.checkAggFails("^array_concat_agg(x, ',' order by x desc)^", values, "No match found for function signature ARRAY_CONCAT_AGG\\(<CHARACTER>, <CHARACTER>\\)", false);
    }

    @Test
    void testFusionFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.FUSION, VM_FENNEL, VM_JAVA);
        f.checkFails("fusion(^*^)", "Unknown identifier '\\*'", false);
        f.checkAggType("fusion(MULTISET[1,2,3])", "INTEGER NOT NULL MULTISET NOT NULL");
        f.enableTypeCoercion(false).checkFails("^fusion(12)^", "Cannot apply 'FUSION' to arguments of type .*", false);
        String[] values1 = new String[]{"MULTISET[0]", "MULTISET[1]", "MULTISET[2]", "MULTISET[3]"};
        f.checkAgg("fusion(x)", values1, ResultCheckers.isSingle("[0, 1, 2, 3]"));
        String[] values2 = new String[]{"MULTISET[0,1]", "MULTISET[1, 2]"};
        f.checkAgg("fusion(x)", values2, ResultCheckers.isSingle("[0, 1, 1, 2]"));
    }

    @Test
    void testIntersectionFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.INTERSECTION, VM_FENNEL, VM_JAVA);
        f.checkFails("intersection(^*^)", "Unknown identifier '\\*'", false);
        f.checkAggType("intersection(MULTISET[1,2,3])", "INTEGER NOT NULL MULTISET NOT NULL");
        f.enableTypeCoercion(false).checkFails("^intersection(12)^", "Cannot apply 'INTERSECTION' to arguments of type .*", false);
        String[] values1 = new String[]{"MULTISET[0]", "MULTISET[1]", "MULTISET[2]", "MULTISET[3]"};
        f.checkAgg("intersection(x)", values1, ResultCheckers.isSingle("[]"));
        String[] values2 = new String[]{"MULTISET[0, 1]", "MULTISET[1, 2]"};
        f.checkAgg("intersection(x)", values2, ResultCheckers.isSingle("[1]"));
        String[] values3 = new String[]{"MULTISET[0, 1, 1]", "MULTISET[0, 1, 2]"};
        f.checkAgg("intersection(x)", values3, ResultCheckers.isSingle("[0, 1, 1]"));
    }

    @Test
    void testModeFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.MODE, VM_EXPAND);
        f.checkFails("mode(^*^)", "Unknown identifier '\\*'", false);
        f.enableTypeCoercion(false).checkFails("^mode()^", "Invalid number of arguments to function 'MODE'. Was expecting 1 arguments", false);
        f.enableTypeCoercion(false).checkFails("^mode(1,2)^", "Invalid number of arguments to function 'MODE'. Was expecting 1 arguments", false);
        f.enableTypeCoercion(false).checkFails("mode(^null^)", "Illegal use of 'NULL'", false);
        f.checkType("mode('name')", "CHAR(4)");
        f.checkAggType("mode(1)", "INTEGER NOT NULL");
        f.checkAggType("mode(1.2)", "DECIMAL(2, 1) NOT NULL");
        f.checkAggType("mode(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL");
        f.checkType("mode(cast(null as varchar(2)))", "VARCHAR(2)");
        String[] values = new String[]{"0", "CAST(null AS INTEGER)", "2", "2", "3", "3", "3"};
        f.checkAgg("mode(x)", values, ResultCheckers.isSingle("3"));
        String[] values2 = new String[]{"0", null, null, null, "2", "2"};
        f.checkAgg("mode(x)", values2, ResultCheckers.isSingle("2"));
        String[] values3 = new String[]{};
        f.checkAgg("mode(x)", values3, ResultCheckers.isNullValue());
        f.checkAgg("mode(CASE x WHEN 0 THEN NULL ELSE -1 END)", values, ResultCheckers.isSingle(-1));
        f.checkAgg("mode(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, ResultCheckers.isSingle(-1));
        f.checkAgg("mode(DISTINCT x)", values, ResultCheckers.isSingle(0));
    }

    @Test
    void testYear() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.YEAR, VM_FENNEL, VM_JAVA);
        f.checkScalar("year(date '2008-1-23')", "2008", "BIGINT NOT NULL");
        f.checkNull("year(cast(null as date))");
    }

    @Test
    void testQuarter() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.QUARTER, VM_FENNEL, VM_JAVA);
        f.checkScalar("quarter(date '2008-1-23')", "1", "BIGINT NOT NULL");
        f.checkScalar("quarter(date '2008-2-23')", "1", "BIGINT NOT NULL");
        f.checkScalar("quarter(date '2008-3-23')", "1", "BIGINT NOT NULL");
        f.checkScalar("quarter(date '2008-4-23')", "2", "BIGINT NOT NULL");
        f.checkScalar("quarter(date '2008-5-23')", "2", "BIGINT NOT NULL");
        f.checkScalar("quarter(date '2008-6-23')", "2", "BIGINT NOT NULL");
        f.checkScalar("quarter(date '2008-7-23')", "3", "BIGINT NOT NULL");
        f.checkScalar("quarter(date '2008-8-23')", "3", "BIGINT NOT NULL");
        f.checkScalar("quarter(date '2008-9-23')", "3", "BIGINT NOT NULL");
        f.checkScalar("quarter(date '2008-10-23')", "4", "BIGINT NOT NULL");
        f.checkScalar("quarter(date '2008-11-23')", "4", "BIGINT NOT NULL");
        f.checkScalar("quarter(date '2008-12-23')", "4", "BIGINT NOT NULL");
        f.checkNull("quarter(cast(null as date))");
    }

    @Test
    void testMonth() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.MONTH, VM_FENNEL, VM_JAVA);
        f.checkScalar("month(date '2008-1-23')", "1", "BIGINT NOT NULL");
        f.checkNull("month(cast(null as date))");
    }

    @Test
    void testWeek() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.WEEK, VM_FENNEL, VM_JAVA);
    }

    @Test
    void testDayOfYear() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.DAYOFYEAR, VM_FENNEL, VM_JAVA);
    }

    @Test
    void testDayOfMonth() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.DAYOFMONTH, VM_FENNEL, VM_JAVA);
        f.checkScalar("dayofmonth(date '2008-1-23')", "23", "BIGINT NOT NULL");
        f.checkNull("dayofmonth(cast(null as date))");
    }

    @Test
    void testDayOfWeek() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.DAYOFWEEK, VM_FENNEL, VM_JAVA);
    }

    @Test
    void testHour() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.HOUR, VM_FENNEL, VM_JAVA);
        f.checkScalar("hour(timestamp '2008-1-23 12:34:56')", "12", "BIGINT NOT NULL");
        f.checkNull("hour(cast(null as timestamp))");
    }

    @Test
    void testMinute() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.MINUTE, VM_FENNEL, VM_JAVA);
        f.checkScalar("minute(timestamp '2008-1-23 12:34:56')", "34", "BIGINT NOT NULL");
        f.checkNull("minute(cast(null as timestamp))");
    }

    @Test
    void testSecond() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.SECOND, VM_FENNEL, VM_JAVA);
        f.checkScalar("second(timestamp '2008-1-23 12:34:56')", "56", "BIGINT NOT NULL");
        f.checkNull("second(cast(null as timestamp))");
    }

    @Test
    void testExtractIntervalYearMonth() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.EXTRACT, VM_FENNEL, VM_JAVA);
        f.checkFails("^extract(doy from interval '4-2' year to month)^", "Cannot apply 'EXTRACT' to arguments of type .*'\n.*", false);
        f.checkFails("^extract(dow from interval '4-2' year to month)^", "Cannot apply 'EXTRACT' to arguments of type .*'\n.*", false);
        f.checkFails("^extract(week from interval '4-2' year to month)^", "Cannot apply 'EXTRACT' to arguments of type .*'\n.*", false);
        f.checkFails("^extract(isodow from interval '4-2' year to month)^", "Cannot apply 'EXTRACT' to arguments of type .*'\n.*", false);
        f.checkScalar("extract(month from interval '4-2' year to month)", "2", "BIGINT NOT NULL");
        f.checkScalar("extract(quarter from interval '4-2' year to month)", "1", "BIGINT NOT NULL");
        f.checkScalar("extract(year from interval '4-2' year to month)", "4", "BIGINT NOT NULL");
        f.checkScalar("extract(decade from interval '426-3' year(3) to month)", "42", "BIGINT NOT NULL");
        f.checkScalar("extract(century from interval '426-3' year(3) to month)", "4", "BIGINT NOT NULL");
        f.checkScalar("extract(millennium from interval '2005-3' year(4) to month)", "2", "BIGINT NOT NULL");
    }

    @Test
    void testExtractIntervalDayTime() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.EXTRACT, VM_FENNEL, VM_JAVA);
        f.checkScalar("extract(millisecond from interval '2 3:4:5.678' day to second)", "5678", "BIGINT NOT NULL");
        f.checkScalar("extract(microsecond from interval '2 3:4:5.678' day to second)", "5678000", "BIGINT NOT NULL");
        f.checkScalar("extract(nanosecond from interval '2 3:4:5.678' day to second)", "5678000000", "BIGINT NOT NULL");
        f.checkScalar("extract(second from interval '2 3:4:5.678' day to second)", "5", "BIGINT NOT NULL");
        f.checkScalar("extract(minute from interval '2 3:4:5.678' day to second)", "4", "BIGINT NOT NULL");
        f.checkScalar("extract(hour from interval '2 3:4:5.678' day to second)", "3", "BIGINT NOT NULL");
        f.checkScalar("extract(day from interval '2 3:4:5.678' day to second)", "2", "BIGINT NOT NULL");
        f.checkFails("^extract(month from interval '2 3:4:5.678' day to second)^", "(?s)Cannot apply 'EXTRACT' to arguments of type 'EXTRACT\\(<INTERVAL MONTH> FROM <INTERVAL DAY TO SECOND>\\)'\\. Supported form\\(s\\):.*", false);
        f.checkFails("^extract(quarter from interval '2 3:4:5.678' day to second)^", "(?s)Cannot apply 'EXTRACT' to arguments of type 'EXTRACT\\(<INTERVAL QUARTER> FROM <INTERVAL DAY TO SECOND>\\)'\\. Supported form\\(s\\):.*", false);
        f.checkFails("^extract(year from interval '2 3:4:5.678' day to second)^", "(?s)Cannot apply 'EXTRACT' to arguments of type 'EXTRACT\\(<INTERVAL YEAR> FROM <INTERVAL DAY TO SECOND>\\)'\\. Supported form\\(s\\):.*", false);
        f.checkFails("^extract(isoyear from interval '2 3:4:5.678' day to second)^", "(?s)Cannot apply 'EXTRACT' to arguments of type 'EXTRACT\\(<INTERVAL ISOYEAR> FROM <INTERVAL DAY TO SECOND>\\)'\\. Supported form\\(s\\):.*", false);
        f.checkFails("^extract(century from interval '2 3:4:5.678' day to second)^", "(?s)Cannot apply 'EXTRACT' to arguments of type 'EXTRACT\\(<INTERVAL CENTURY> FROM <INTERVAL DAY TO SECOND>\\)'\\. Supported form\\(s\\):.*", false);
    }

    @Test
    void testExtractDate() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.EXTRACT, VM_FENNEL, VM_JAVA);
        f.checkFails("extract(^a^ from date '2008-2-23')", "'A' is not a valid time frame", false);
        f.checkScalar("extract(epoch from date '2008-2-23')", "1203724800", "BIGINT NOT NULL");
        f.checkScalar("extract(second from date '2008-2-23')", "0", "BIGINT NOT NULL");
        f.checkScalar("extract(millisecond from date '2008-2-23')", "0", "BIGINT NOT NULL");
        f.checkScalar("extract(microsecond from date '2008-2-23')", "0", "BIGINT NOT NULL");
        f.checkScalar("extract(nanosecond from date '2008-2-23')", "0", "BIGINT NOT NULL");
        f.checkScalar("extract(minute from date '9999-2-23')", "0", "BIGINT NOT NULL");
        f.checkScalar("extract(minute from date '0001-1-1')", "0", "BIGINT NOT NULL");
        f.checkScalar("extract(minute from date '2008-2-23')", "0", "BIGINT NOT NULL");
        f.checkScalar("extract(hour from date '2008-2-23')", "0", "BIGINT NOT NULL");
        f.checkScalar("extract(day from date '2008-2-23')", "23", "BIGINT NOT NULL");
        f.checkScalar("extract(month from date '2008-2-23')", "2", "BIGINT NOT NULL");
        f.checkScalar("extract(quarter from date '2008-4-23')", "2", "BIGINT NOT NULL");
        f.checkScalar("extract(year from date '2008-2-23')", "2008", "BIGINT NOT NULL");
        f.checkScalar("extract(isoyear from date '2008-2-23')", "2008", "BIGINT NOT NULL");
        f.checkScalar("extract(doy from date '2008-2-23')", "54", "BIGINT NOT NULL");
        f.checkScalar("extract(dow from date '2008-2-23')", "7", "BIGINT NOT NULL");
        f.checkScalar("extract(dow from date '2008-2-24')", "1", "BIGINT NOT NULL");
        f.checkScalar("extract(isodow from date '2008-2-23')", "6", "BIGINT NOT NULL");
        f.checkScalar("extract(isodow from date '2008-2-24')", "7", "BIGINT NOT NULL");
        f.checkScalar("extract(week from date '2008-2-23')", "8", "BIGINT NOT NULL");
        f.checkScalar("extract(week from timestamp '2008-2-23 01:23:45')", "8", "BIGINT NOT NULL");
        f.checkScalar("extract(week from cast(null as date))", ResultCheckers.isNullValue(), "BIGINT");
        f.checkScalar("extract(decade from date '2008-2-23')", "200", "BIGINT NOT NULL");
        f.checkScalar("extract(century from date '2008-2-23')", "21", "BIGINT NOT NULL");
        f.checkScalar("extract(century from date '2001-01-01')", "21", "BIGINT NOT NULL");
        f.checkScalar("extract(century from date '2000-12-31')", "20", "BIGINT NOT NULL");
        f.checkScalar("extract(century from date '1852-06-07')", "19", "BIGINT NOT NULL");
        f.checkScalar("extract(century from date '0001-02-01')", "1", "BIGINT NOT NULL");
        f.checkScalar("extract(millennium from date '2000-2-23')", "2", "BIGINT NOT NULL");
        f.checkScalar("extract(millennium from date '1969-2-23')", "2", "BIGINT NOT NULL");
        f.checkScalar("extract(millennium from date '2000-12-31')", "2", "BIGINT NOT NULL");
        f.checkScalar("extract(millennium from date '2001-01-01')", "3", "BIGINT NOT NULL");
    }

    @Test
    void testExtractTimestamp() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.EXTRACT, VM_FENNEL, VM_JAVA);
        f.checkFails("extract(^a^ from timestamp '2008-2-23 12:34:56')", "'A' is not a valid time frame", false);
        f.checkScalar("extract(epoch from timestamp '2008-2-23 12:34:56')", "1203770096", "BIGINT NOT NULL");
        f.checkScalar("extract(second from timestamp '2008-2-23 12:34:56')", "56", "BIGINT NOT NULL");
        f.checkScalar("extract(millisecond from timestamp '2008-2-23 12:34:56')", "56000", "BIGINT NOT NULL");
        f.checkScalar("extract(microsecond from timestamp '2008-2-23 12:34:56')", "56000000", "BIGINT NOT NULL");
        f.checkScalar("extract(nanosecond from timestamp '2008-2-23 12:34:56')", "56000000000", "BIGINT NOT NULL");
        f.checkScalar("extract(minute from timestamp '2008-2-23 12:34:56')", "34", "BIGINT NOT NULL");
        f.checkScalar("extract(hour from timestamp '2008-2-23 12:34:56')", "12", "BIGINT NOT NULL");
        f.checkScalar("extract(day from timestamp '2008-2-23 12:34:56')", "23", "BIGINT NOT NULL");
        f.checkScalar("extract(month from timestamp '2008-2-23 12:34:56')", "2", "BIGINT NOT NULL");
        f.checkScalar("extract(quarter from timestamp '2008-7-23 12:34:56')", "3", "BIGINT NOT NULL");
        f.checkScalar("extract(year from timestamp '2008-2-23 12:34:56')", "2008", "BIGINT NOT NULL");
        f.checkScalar("extract(isoyear from timestamp '2008-2-23 12:34:56')", "2008", "BIGINT NOT NULL");
        f.checkScalar("extract(decade from timestamp '2008-2-23 12:34:56')", "200", "BIGINT NOT NULL");
        f.checkScalar("extract(century from timestamp '2008-2-23 12:34:56')", "21", "BIGINT NOT NULL");
        f.checkScalar("extract(century from timestamp '2001-01-01 12:34:56')", "21", "BIGINT NOT NULL");
        f.checkScalar("extract(century from timestamp '2000-12-31 12:34:56')", "20", "BIGINT NOT NULL");
        f.checkScalar("extract(millennium from timestamp '2008-2-23 12:34:56')", "3", "BIGINT NOT NULL");
        f.checkScalar("extract(millennium from timestamp '2000-2-23 12:34:56')", "2", "BIGINT NOT NULL");
    }

    @Test
    void testExtractInterval() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.EXTRACT, VM_FENNEL, VM_JAVA);
        f.checkFails("extract(^a^ from interval '2 3:4:5.678' day to second)", "'A' is not a valid time frame", false);
        f.checkScalar("extract(day from interval '2 3:4:5.678' day to second)", "2", "BIGINT NOT NULL");
        f.checkScalar("extract(day from interval '23456 3:4:5.678' day(5) to second)", "23456", "BIGINT NOT NULL");
        f.checkScalar("extract(hour from interval '2 3:4:5.678' day to second)", "3", "BIGINT NOT NULL");
        f.checkScalar("extract(minute from interval '2 3:4:5.678' day to second)", "4", "BIGINT NOT NULL");
        f.checkScalar("extract(second from interval '2 3:4:5.678' day to second)", "5", "BIGINT NOT NULL");
        f.checkScalar("extract(millisecond from interval '2 3:4:5.678' day to second)", "5678", "BIGINT NOT NULL");
        f.checkScalar("extract(microsecond from interval '2 3:4:5.678' day to second)", "5678000", "BIGINT NOT NULL");
        f.checkScalar("extract(nanosecond from interval '2 3:4:5.678' day to second)", "5678000000", "BIGINT NOT NULL");
        f.checkNull("extract(month from cast(null as interval year))");
    }

    @Test
    void testExtractFuncFromDateTime() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.EXTRACT, VM_FENNEL, VM_JAVA);
        f.checkScalar("extract(year from date '2008-2-23')", "2008", "BIGINT NOT NULL");
        f.checkScalar("extract(isoyear from date '2008-2-23')", "2008", "BIGINT NOT NULL");
        f.checkScalar("extract(month from date '2008-2-23')", "2", "BIGINT NOT NULL");
        f.checkScalar("extract(month from timestamp '2008-2-23 12:34:56')", "2", "BIGINT NOT NULL");
        f.checkScalar("extract(minute from timestamp '2008-2-23 12:34:56')", "34", "BIGINT NOT NULL");
        f.checkScalar("extract(minute from time '12:23:34')", "23", "BIGINT NOT NULL");
        f.checkNull("extract(month from cast(null as timestamp))");
        f.checkNull("extract(month from cast(null as date))");
        f.checkNull("extract(second from cast(null as time))");
        f.checkNull("extract(millisecond from cast(null as time))");
        f.checkNull("extract(microsecond from cast(null as time))");
        f.checkNull("extract(nanosecond from cast(null as time))");
    }

    @Test
    void testExtractWithDatesBeforeUnixEpoch() {
        SqlOperatorFixture f = this.fixture();
        f.checkScalar("extract(millisecond from TIMESTAMP '1969-12-31 21:13:17.357')", "17357", "BIGINT NOT NULL");
        f.checkScalar("extract(year from TIMESTAMP '1970-01-01 00:00:00')", "1970", "BIGINT NOT NULL");
        f.checkScalar("extract(year from TIMESTAMP '1969-12-31 10:13:17')", "1969", "BIGINT NOT NULL");
        f.checkScalar("extract(quarter from TIMESTAMP '1969-12-31 08:13:17')", "4", "BIGINT NOT NULL");
        f.checkScalar("extract(quarter from TIMESTAMP '1969-5-31 21:13:17')", "2", "BIGINT NOT NULL");
        f.checkScalar("extract(month from TIMESTAMP '1969-12-31 00:13:17')", "12", "BIGINT NOT NULL");
        f.checkScalar("extract(day from TIMESTAMP '1969-12-31 12:13:17')", "31", "BIGINT NOT NULL");
        f.checkScalar("extract(week from TIMESTAMP '1969-2-23 01:23:45')", "8", "BIGINT NOT NULL");
        f.checkScalar("extract(doy from TIMESTAMP '1969-12-31 21:13:17.357')", "365", "BIGINT NOT NULL");
        f.checkScalar("extract(dow from TIMESTAMP '1969-12-31 01:13:17.357')", "4", "BIGINT NOT NULL");
        f.checkScalar("extract(decade from TIMESTAMP '1969-12-31 21:13:17.357')", "196", "BIGINT NOT NULL");
        f.checkScalar("extract(century from TIMESTAMP '1969-12-31 21:13:17.357')", "20", "BIGINT NOT NULL");
        f.checkScalar("extract(hour from TIMESTAMP '1969-12-31 21:13:17.357')", "21", "BIGINT NOT NULL");
        f.checkScalar("extract(minute from TIMESTAMP '1969-12-31 21:13:17.357')", "13", "BIGINT NOT NULL");
        f.checkScalar("extract(second from TIMESTAMP '1969-12-31 21:13:17.357')", "17", "BIGINT NOT NULL");
        f.checkScalar("extract(millisecond from TIMESTAMP '1969-12-31 21:13:17.357')", "17357", "BIGINT NOT NULL");
        f.checkScalar("extract(microsecond from TIMESTAMP '1969-12-31 21:13:17.357')", "17357000", "BIGINT NOT NULL");
    }

    @Test
    void testArrayValueConstructor() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalar("Array['foo', 'bar']", "[foo, bar]", "CHAR(3) NOT NULL ARRAY NOT NULL");
        f.checkFails("^Array[]^", "Require at least 1 argument", false);
    }

    @Test
    void testArrayQueryConstructor() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.ARRAY_QUERY, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalar("array(select 1)", "[1]", "INTEGER NOT NULL ARRAY NOT NULL");
        f.check("select array(select ROW(1,2))", "RecordType(INTEGER NOT NULL EXPR$0, INTEGER NOT NULL EXPR$1) NOT NULL ARRAY NOT NULL", (Object)"[{1, 2}]");
    }

    @Test
    void testMultisetQueryConstructor() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.MULTISET_QUERY, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalar("multiset(select 1)", "[1]", "INTEGER NOT NULL MULTISET NOT NULL");
        f.check("select multiset(select ROW(1,2))", "RecordType(INTEGER NOT NULL EXPR$0, INTEGER NOT NULL EXPR$1) NOT NULL MULTISET NOT NULL", (Object)"[{1, 2}]");
    }

    @Test
    void testItemOp() {
        SqlOperatorFixture f = this.fixture();
        f.setFor(SqlStdOperatorTable.ITEM, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalar("ARRAY ['foo', 'bar'][1]", "foo", "CHAR(3)");
        f.checkScalar("ARRAY ['foo', 'bar'][0]", ResultCheckers.isNullValue(), "CHAR(3)");
        f.checkScalar("ARRAY ['foo', 'bar'][2]", "bar", "CHAR(3)");
        f.checkScalar("ARRAY ['foo', 'bar'][3]", ResultCheckers.isNullValue(), "CHAR(3)");
        f.checkNull("ARRAY ['foo', 'bar'][1 + CAST(NULL AS INTEGER)]");
        f.checkFails("^ARRAY ['foo', 'bar']['baz']^", "Cannot apply 'ITEM' to arguments of type 'ITEM\\(<CHAR\\(3\\) ARRAY>, <CHAR\\(3\\)>\\)'\\. Supported form\\(s\\): <ARRAY>\\[<INTEGER>\\]\n<MAP>\\[<ANY>\\]\n<ROW>\\[<CHARACTER>\\|<INTEGER>\\]", false);
        f.checkScalar("ARRAY [2, 4, 6][2]", "4", "INTEGER");
        f.checkScalar("ARRAY [2, 4, 6][4]", ResultCheckers.isNullValue(), "INTEGER");
        f.checkScalarExact("map['foo', 3, 'bar', 7]['bar']", "INTEGER", "7");
        f.checkScalarExact("map['foo', CAST(NULL AS INTEGER), 'bar', 7]['bar']", "INTEGER", "7");
        f.checkScalarExact("map['foo', CAST(NULL AS INTEGER), 'bar', 7]['baz']", "INTEGER", ResultCheckers.isNullValue());
        f.checkColumnType("select cast(null as any)['x'] from (values(1))", "ANY");
        String intStructQuery = "select \"T\".\"X\"[1] from (VALUES (ROW(ROW(3, 7), ROW(4, 8)))) as T(x, y)";
        f.check("select \"T\".\"X\"[1] from (VALUES (ROW(ROW(3, 7), ROW(4, 8)))) as T(x, y)", SqlTests.INTEGER_TYPE_CHECKER, (Object)3);
        f.checkColumnType("select \"T\".\"X\"[1] from (VALUES (ROW(ROW(3, 7), ROW(4, 8)))) as T(x, y)", "INTEGER NOT NULL");
        f.check("select \"T\".\"X\"[1] from (VALUES (ROW(ROW(3, CAST(NULL AS INTEGER)), ROW(4, 8)))) as T(x, y)", SqlTests.INTEGER_TYPE_CHECKER, (Object)3);
        f.check("select \"T\".\"X\"[2] from (VALUES (ROW(ROW(3, CAST(NULL AS INTEGER)), ROW(4, 8)))) as T(x, y)", SqlTests.ANY_TYPE_CHECKER, (Object)ResultCheckers.isNullValue());
        f.checkFails("select \"T\".\"X\"[1 + CAST(NULL AS INTEGER)] from (VALUES (ROW(ROW(3, CAST(NULL AS INTEGER)), ROW(4, 8)))) as T(x, y)", "Cannot infer type of field at position null within ROW type: RecordType\\(INTEGER EXPR\\$0, INTEGER EXPR\\$1\\)", false);
    }

    @Test
    void testMapValueConstructor() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR, VM_JAVA);
        f.checkFails("^Map[]^", "Map requires at least 2 arguments", false);
        f.checkFails("^Map[1, 'x', 2]^", "Map requires an even number of arguments", false);
        f.checkFails("^map[1, 1, 2, 'x']^", "Parameters must be of the same type", false);
        f.checkScalar("map['washington', 1, 'obama', 44]", "{washington=1, obama=44}", "(CHAR(10) NOT NULL, INTEGER NOT NULL) MAP NOT NULL");
        SqlOperatorFixture f1 = f.withConformance((SqlConformance)SqlConformanceEnum.PRAGMATIC_2003);
        f1.checkScalar("map['washington', 1, 'obama', 44]", "{washington=1, obama=44}", "(VARCHAR(10) NOT NULL, INTEGER NOT NULL) MAP NOT NULL");
    }

    @Test
    void testCeilFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CEIL, VM_FENNEL);
        f.checkScalarApprox("ceil(10.1e0)", "DOUBLE NOT NULL", ResultCheckers.isExactly(11.0));
        f.checkScalarApprox("ceil(cast(-11.2e0 as real))", "REAL NOT NULL", ResultCheckers.isExactly(-11.0));
        f.checkScalarExact("ceil(100)", "INTEGER NOT NULL", "100");
        f.checkScalarExact("ceil(1.3)", "DECIMAL(2, 0) NOT NULL", "2");
        f.checkScalarExact("ceil(-1.7)", "DECIMAL(2, 0) NOT NULL", "-1");
        f.checkNull("ceiling(cast(null as decimal(2,0)))");
        f.checkNull("ceiling(cast(null as double))");
    }

    @Test
    void testCeilFuncInterval() {
        SqlOperatorFixture f = this.fixture();
        if (!f.brokenTestsEnabled()) {
            return;
        }
        f.checkScalar("ceil(interval '3:4:5' hour to second)", "+4:00:00.000000", "INTERVAL HOUR TO SECOND NOT NULL");
        f.checkScalar("ceil(interval '-6.3' second)", "-6.000000", "INTERVAL SECOND NOT NULL");
        f.checkScalar("ceil(interval '5-1' year to month)", "+6-00", "INTERVAL YEAR TO MONTH NOT NULL");
        f.checkScalar("ceil(interval '-5-1' year to month)", "-5-00", "INTERVAL YEAR TO MONTH NOT NULL");
        f.checkNull("ceil(cast(null as interval year))");
    }

    @Test
    void testFloorFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.FLOOR, VM_FENNEL);
        f.checkScalarApprox("floor(2.5e0)", "DOUBLE NOT NULL", ResultCheckers.isExactly(2.0));
        f.checkScalarApprox("floor(cast(-1.2e0 as real))", "REAL NOT NULL", ResultCheckers.isExactly(-2.0));
        f.checkScalarExact("floor(100)", "INTEGER NOT NULL", "100");
        f.checkScalarExact("floor(1.7)", "DECIMAL(2, 0) NOT NULL", "1");
        f.checkScalarExact("floor(-1.7)", "DECIMAL(2, 0) NOT NULL", "-2");
        f.checkNull("floor(cast(null as decimal(2,0)))");
        f.checkNull("floor(cast(null as real))");
    }

    @Test
    void testFloorFuncDateTime() {
        SqlOperatorFixture f = this.fixture();
        f.enableTypeCoercion(false).checkFails("^floor('12:34:56')^", "Cannot apply 'FLOOR' to arguments of type 'FLOOR\\(<CHAR\\(8\\)>\\)'\\. Supported form\\(s\\): 'FLOOR\\(<NUMERIC>\\)'\n'FLOOR\\(<DATETIME_INTERVAL>\\)'\n'FLOOR\\(<DATE> TO <TIME_UNIT>\\)'\n'FLOOR\\(<TIME> TO <TIME_UNIT>\\)'\n'FLOOR\\(<TIMESTAMP> TO <TIME_UNIT>\\)'", false);
        f.checkType("floor('12:34:56')", "DECIMAL(19, 0) NOT NULL");
        f.checkFails("^floor(time '12:34:56')^", "(?s)Cannot apply 'FLOOR' to arguments .*", false);
        f.checkFails("^floor(123.45 to minute)^", "(?s)Cannot apply 'FLOOR' to arguments .*", false);
        f.checkFails("^floor('abcde' to minute)^", "(?s)Cannot apply 'FLOOR' to arguments .*", false);
        f.checkScalar("floor(time '12:34:56' to minute)", "12:34:00", "TIME(0) NOT NULL");
        f.checkScalar("floor(timestamp '2015-02-19 12:34:56.78' to second)", "2015-02-19 12:34:56", "TIMESTAMP(2) NOT NULL");
        f.checkScalar("floor(timestamp '2015-02-19 12:34:56.78' to millisecond)", "2015-02-19 12:34:56", "TIMESTAMP(2) NOT NULL");
        f.checkScalar("floor(timestamp '2015-02-19 12:34:56.78' to microsecond)", "2015-02-19 12:34:56", "TIMESTAMP(2) NOT NULL");
        f.checkScalar("floor(timestamp '2015-02-19 12:34:56.78' to nanosecond)", "2015-02-19 12:34:56", "TIMESTAMP(2) NOT NULL");
        f.checkScalar("floor(timestamp '2015-02-19 12:34:56' to minute)", "2015-02-19 12:34:00", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("floor(timestamp '2015-02-19 12:34:56' to year)", "2015-01-01 00:00:00", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("floor(date '2015-02-19' to year)", "2015-01-01", "DATE NOT NULL");
        f.checkScalar("floor(timestamp '2015-02-19 12:34:56' to month)", "2015-02-01 00:00:00", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("floor(date '2015-02-19' to month)", "2015-02-01", "DATE NOT NULL");
        f.checkNull("floor(cast(null as timestamp) to month)");
        f.checkNull("floor(cast(null as date) to month)");
    }

    @Test
    void testCeilFuncDateTime() {
        SqlOperatorFixture f = this.fixture();
        f.enableTypeCoercion(false).checkFails("^ceil('12:34:56')^", "Cannot apply 'CEIL' to arguments of type 'CEIL\\(<CHAR\\(8\\)>\\)'\\. Supported form\\(s\\): 'CEIL\\(<NUMERIC>\\)'\n'CEIL\\(<DATETIME_INTERVAL>\\)'\n'CEIL\\(<DATE> TO <TIME_UNIT>\\)'\n'CEIL\\(<TIME> TO <TIME_UNIT>\\)'\n'CEIL\\(<TIMESTAMP> TO <TIME_UNIT>\\)'", false);
        f.checkType("ceil('12:34:56')", "DECIMAL(19, 0) NOT NULL");
        f.checkFails("^ceil(time '12:34:56')^", "(?s)Cannot apply 'CEIL' to arguments .*", false);
        f.checkFails("^ceil(123.45 to minute)^", "(?s)Cannot apply 'CEIL' to arguments .*", false);
        f.checkFails("^ceil('abcde' to minute)^", "(?s)Cannot apply 'CEIL' to arguments .*", false);
        f.checkScalar("ceil(time '12:34:56' to minute)", "12:35:00", "TIME(0) NOT NULL");
        f.checkScalar("ceil(time '12:59:56' to minute)", "13:00:00", "TIME(0) NOT NULL");
        f.checkScalar("ceil(timestamp '2015-02-19 12:34:56.78' to second)", "2015-02-19 12:34:57", "TIMESTAMP(2) NOT NULL");
        f.checkScalar("ceil(timestamp '2015-02-19 12:34:56.78' to millisecond)", "2015-02-19 12:34:56", "TIMESTAMP(2) NOT NULL");
        f.checkScalar("ceil(timestamp '2015-02-19 12:34:56.78' to microsecond)", "2015-02-19 12:34:56", "TIMESTAMP(2) NOT NULL");
        f.checkScalar("ceil(timestamp '2015-02-19 12:34:56.78' to nanosecond)", "2015-02-19 12:34:56", "TIMESTAMP(2) NOT NULL");
        f.checkScalar("ceil(timestamp '2015-02-19 12:34:56.00' to second)", "2015-02-19 12:34:56", "TIMESTAMP(2) NOT NULL");
        f.checkScalar("ceil(timestamp '2015-02-19 12:34:56' to minute)", "2015-02-19 12:35:00", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("ceil(timestamp '2015-02-19 12:34:56' to year)", "2016-01-01 00:00:00", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("ceil(date '2015-02-19' to year)", "2016-01-01", "DATE NOT NULL");
        f.checkScalar("ceil(timestamp '2015-02-19 12:34:56' to month)", "2015-03-01 00:00:00", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("ceil(date '2015-02-19' to month)", "2015-03-01", "DATE NOT NULL");
        f.checkNull("ceil(cast(null as timestamp) to month)");
        f.checkNull("ceil(cast(null as date) to month)");
        f.checkScalar("ceiling(timestamp '2015-02-19 12:34:56' to month)", "2015-03-01 00:00:00", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("ceiling(date '2015-02-19' to month)", "2015-03-01", "DATE NOT NULL");
        f.checkNull("ceiling(cast(null as timestamp) to month)");
    }

    @Test
    void testCustomTimeFrame() {
        SqlOperatorFixture f = this.fixture().withFactory(tf -> tf.withTypeSystem(typeSystem -> new DelegatingTypeSystem((RelDataTypeSystem)typeSystem){

            public TimeFrameSet deriveTimeFrameSet(TimeFrameSet frameSet) {
                return TimeFrameSet.builder().addAll(frameSet).addDivision("minute15", (Number)4, "HOUR").addMultiple("month4", (Number)4, "MONTH").build();
            }
        }));
        f.checkScalar("floor(timestamp '2020-06-27 12:34:56' to \"minute15\")", "2020-06-27 12:30:00", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("floor(timestamp '2020-06-27 12:34:56' to \"month4\")", "2020-05-01 00:00:00", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("floor(date '2020-06-27' to \"month4\")", "2020-05-01", "DATE NOT NULL");
        f.checkScalar("ceil(timestamp '2020-06-27 12:34:56' to \"minute15\")", "2020-06-27 12:45:00", "TIMESTAMP(0) NOT NULL");
        f.checkFails("ceil(timestamp '2020-06-27 12:34:56' to ^\"minute25\"^)", "'minute25' is not a valid time frame", false);
        f.checkScalar("timestampadd(\"minute15\", 7, timestamp '2016-02-24 12:42:25')", "2016-02-24 14:27:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("timestampadd(\"month4\", 7, timestamp '2016-02-24 12:42:25')", "2018-06-24 12:42:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("timestampadd(\"month4\", 7, date '2016-02-24')", "2018-06-24", "DATE NOT NULL");
        f.checkScalar("timestampdiff(\"minute15\", timestamp '2016-02-24 12:42:25', timestamp '2016-02-24 15:42:25')", "12", "INTEGER NOT NULL");
        f.checkScalar("timestampdiff(\"month4\", timestamp '2016-02-24 12:42:25', timestamp '2016-02-24 15:42:25')", "0", "INTEGER NOT NULL");
        f.checkScalar("timestampdiff(\"month4\", timestamp '2016-02-24 12:42:25', timestamp '2018-02-24 15:42:25')", "6", "INTEGER NOT NULL");
        f.checkScalar("timestampdiff(\"month4\", timestamp '2016-02-24 12:42:25', timestamp '2018-02-23 15:42:25')", "5", "INTEGER NOT NULL");
        f.checkScalar("timestampdiff(\"month4\", date '2016-02-24', date '2020-03-24')", "12", "INTEGER NOT NULL");
        f.checkScalar("timestampdiff(\"month4\", date '2016-02-24', date '2016-06-23')", "0", "INTEGER NOT NULL");
        f.checkScalar("timestampdiff(\"month4\", date '2016-02-24', date '2016-06-24')", "1", "INTEGER NOT NULL");
        f.checkScalar("timestampdiff(\"month4\", date '2016-02-24', date '2015-10-24')", "-1", "INTEGER NOT NULL");
        f.checkScalar("timestampdiff(\"month4\", date '2016-02-24', date '2016-02-23')", "0", "INTEGER NOT NULL");
        f.withLibrary(SqlLibrary.BIG_QUERY).setFor((SqlOperator)SqlLibraryOperators.TIMESTAMP_DIFF3, new SqlOperatorFixture.VmName[0]).checkScalar("timestamp_diff(timestamp '2008-12-25 15:30:00', timestamp '2008-12-25 16:30:00', \"minute15\")", "-4", "INTEGER NOT NULL");
    }

    @Test
    void testFloorFuncInterval() {
        SqlOperatorFixture f = this.fixture();
        if (!f.brokenTestsEnabled()) {
            return;
        }
        f.checkScalar("floor(interval '3:4:5' hour to second)", "+3:00:00.000000", "INTERVAL HOUR TO SECOND NOT NULL");
        f.checkScalar("floor(interval '-6.3' second)", "-7.000000", "INTERVAL SECOND NOT NULL");
        f.checkScalar("floor(interval '5-1' year to month)", "+5-00", "INTERVAL YEAR TO MONTH NOT NULL");
        f.checkScalar("floor(interval '-5-1' year to month)", "-6-00", "INTERVAL YEAR TO MONTH NOT NULL");
        f.checkScalar("floor(interval '-6.3' second to second)", "-7.000000", "INTERVAL SECOND NOT NULL");
        f.checkScalar("floor(interval '6-3' minute to second to minute)", "-7-0", "INTERVAL MINUTE TO SECOND NOT NULL");
        f.checkScalar("floor(interval '6-3' hour to minute to hour)", "7-0", "INTERVAL HOUR TO MINUTE NOT NULL");
        f.checkScalar("floor(interval '6 3' day to hour to day)", "7 00", "INTERVAL DAY TO HOUR NOT NULL");
        f.checkScalar("floor(interval '102-7' year to month to month)", "102-07", "INTERVAL YEAR TO MONTH NOT NULL");
        f.checkScalar("floor(interval '102-7' year to month to quarter)", "102-10", "INTERVAL YEAR TO MONTH NOT NULL");
        f.checkScalar("floor(interval '102-1' year to month to century)", "201", "INTERVAL YEAR TO MONTH NOT NULL");
        f.checkScalar("floor(interval '1004-1' year to month to millennium)", "2001-00", "INTERVAL YEAR TO MONTH NOT NULL");
        f.checkNull("floor(cast(null as interval year))");
    }

    @Test
    void testTimestampAdd() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.TIMESTAMP_ADD, SqlOperatorFixture.VmName.EXPAND);
        MICROSECOND_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", 2000000, timestamp '2016-02-24 12:42:25')", "2016-02-24 12:42:27", "TIMESTAMP(3) NOT NULL"));
        SECOND_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", 2, timestamp '2016-02-24 12:42:25')", "2016-02-24 12:42:27", "TIMESTAMP(0) NOT NULL"));
        NANOSECOND_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", 3000000000, timestamp '2016-02-24 12:42:25')", "2016-02-24 12:42:28", "TIMESTAMP(0) NOT NULL"));
        NANOSECOND_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", 2000000000, timestamp '2016-02-24 12:42:25')", "2016-02-24 12:42:27", "TIMESTAMP(0) NOT NULL"));
        MINUTE_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", 2, timestamp '2016-02-24 12:42:25')", "2016-02-24 12:44:25", "TIMESTAMP(0) NOT NULL"));
        HOUR_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", -2000, timestamp '2016-02-24 12:42:25')", "2015-12-03 04:42:25", "TIMESTAMP(0) NOT NULL"));
        HOUR_VARIANTS.forEach(s -> f.checkNull("timestampadd(" + s + ", CAST(NULL AS INTEGER), timestamp '2016-02-24 12:42:25')"));
        HOUR_VARIANTS.forEach(s -> f.checkNull("timestampadd(" + s + ", -200, CAST(NULL AS TIMESTAMP))"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", 3, timestamp '2016-02-24 12:42:25')", "2016-05-24 12:42:25", "TIMESTAMP(0) NOT NULL"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", 3, cast(null as timestamp))", ResultCheckers.isNullValue(), "TIMESTAMP(0)"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", 1, date '2016-06-15')", "2016-07-15", "DATE NOT NULL"));
        DAY_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", 1, date '2016-06-15')", "2016-06-16", "DATE NOT NULL"));
        HOUR_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", -1, date '2016-06-15')", "2016-06-14 23:00:00", "TIMESTAMP(0) NOT NULL"));
        MINUTE_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", 1, date '2016-06-15')", "2016-06-15 00:01:00", "TIMESTAMP(0) NOT NULL"));
        SECOND_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", -1, date '2016-06-15')", "2016-06-14 23:59:59", "TIMESTAMP(0) NOT NULL"));
        SECOND_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", 1, date '2016-06-15')", "2016-06-15 00:00:01", "TIMESTAMP(0) NOT NULL"));
        SECOND_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", 1, cast(null as date))", ResultCheckers.isNullValue(), "TIMESTAMP(0)"));
        DAY_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", 1, cast(null as date))", ResultCheckers.isNullValue(), "DATE"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", 1, date '2016-05-31')", "2016-06-30", "DATE NOT NULL"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", 5, date '2016-01-31')", "2016-06-30", "DATE NOT NULL"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", -1, date '2016-03-31')", "2016-02-29", "DATE NOT NULL"));
        SECOND_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", 1, time '23:59:59')", "00:00:00", "TIME(0) NOT NULL"));
        MINUTE_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", 1, time '00:00:00')", "00:01:00", "TIME(0) NOT NULL"));
        MINUTE_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", 1, time '23:59:59')", "00:00:59", "TIME(0) NOT NULL"));
        HOUR_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", 1, time '23:59:59')", "00:59:59", "TIME(0) NOT NULL"));
        DAY_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", 15, time '23:59:59')", "23:59:59", "TIME(0) NOT NULL"));
        WEEK_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", 3, time '23:59:59')", "23:59:59", "TIME(0) NOT NULL"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", 6, time '23:59:59')", "23:59:59", "TIME(0) NOT NULL"));
        QUARTER_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", 1, time '23:59:59')", "23:59:59", "TIME(0) NOT NULL"));
        YEAR_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", 10, time '23:59:59')", "23:59:59", "TIME(0) NOT NULL"));
        SECOND_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", -1, time '00:00:00')", "23:59:59", "TIME(0) NOT NULL"));
        MINUTE_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", -1, time '00:00:00')", "23:59:00", "TIME(0) NOT NULL"));
        HOUR_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", -1, time '00:00:00')", "23:00:00", "TIME(0) NOT NULL"));
        DAY_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", -1, time '23:59:59')", "23:59:59", "TIME(0) NOT NULL"));
        WEEK_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", -1, time '23:59:59')", "23:59:59", "TIME(0) NOT NULL"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", -1, time '23:59:59')", "23:59:59", "TIME(0) NOT NULL"));
        QUARTER_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", -1, time '23:59:59')", "23:59:59", "TIME(0) NOT NULL"));
        YEAR_VARIANTS.forEach(s -> f.checkScalar("timestampadd(" + s + ", -1, time '23:59:59')", "23:59:59", "TIME(0) NOT NULL"));
    }

    @Test
    void testTimestampAddFractionalSeconds() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.TIMESTAMP_ADD, SqlOperatorFixture.VmName.EXPAND);
        f.checkType("timestampadd(SQL_TSI_FRAC_SECOND, 2, timestamp '2016-02-24 12:42:25.000000')", "TIMESTAMP(3) NOT NULL");
        Assumptions.assumeTrue((f.getFactory().getTypeFactory().getTypeSystem().getMaxPrecision(SqlTypeName.TIMESTAMP) == 3 ? 1 : 0) != 0);
        f.checkType("timestampadd(MICROSECOND, 2, timestamp '2016-02-24 12:42:25.000000')", "TIMESTAMP(3) NOT NULL");
    }

    @Test
    void testTimestampAdd2() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlLibraryOperators.TIMESTAMP_ADD2, new SqlOperatorFixture.VmName[0]);
        f0.checkFails("^timestamp_add(timestamp '2008-12-25 15:30:00', interval 5 minute)^", "No match found for function signature TIMESTAMP_ADD\\(<TIMESTAMP>, <INTERVAL_DAY_TIME>\\)", false);
        SqlOperatorFixture f = f0.withLibrary(SqlLibrary.BIG_QUERY);
        f.checkScalar("timestamp_add(timestamp '2016-02-24 12:42:25', interval 2 second)", "2016-02-24 12:42:27", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("timestamp_add(timestamp '2016-02-24 12:42:25', interval 2 minute)", "2016-02-24 12:44:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("timestamp_add(timestamp '2016-02-24 12:42:25', interval -2000 hour)", "2015-12-03 04:42:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("timestamp_add(timestamp '2016-02-24 12:42:25', interval 1 day)", "2016-02-25 12:42:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("timestamp_add(timestamp '2016-02-24 12:42:25', interval 1 month)", "2016-03-24 12:42:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("timestamp_add(timestamp '2016-02-24 12:42:25', interval 1 year)", "2017-02-24 12:42:25", "TIMESTAMP(0) NOT NULL");
        f.checkNull("timestamp_add(CAST(NULL AS TIMESTAMP), interval 5 minute)");
    }

    @Test
    void testDatetimeAdd() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlLibraryOperators.DATETIME_ADD, new SqlOperatorFixture.VmName[0]);
        f0.checkFails("^datetime_add(timestamp '2008-12-25 15:30:00', interval 5 minute)^", "No match found for function signature DATETIME_ADD\\(<TIMESTAMP>, <INTERVAL_DAY_TIME>\\)", false);
        SqlOperatorFixture f = f0.withLibrary(SqlLibrary.BIG_QUERY);
        f.checkScalar("datetime_add(timestamp '2016-02-24 12:42:25', interval 2 second)", "2016-02-24 12:42:27", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("datetime_add(timestamp '2016-02-24 12:42:25', interval 2 minute)", "2016-02-24 12:44:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("datetime_add(timestamp '2016-02-24 12:42:25', interval -2000 hour)", "2015-12-03 04:42:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("datetime_add(timestamp '2016-02-24 12:42:25', interval 1 day)", "2016-02-25 12:42:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("datetime_add(timestamp '2016-02-24 12:42:25', interval 1 month)", "2016-03-24 12:42:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("datetime_add(timestamp '2016-02-24 12:42:25', interval 1 year)", "2017-02-24 12:42:25", "TIMESTAMP(0) NOT NULL");
        f.checkNull("datetime_add(CAST(NULL AS TIMESTAMP), interval 5 minute)");
    }

    @Test
    void testTimestampDiff3() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlLibraryOperators.TIMESTAMP_DIFF3, new SqlOperatorFixture.VmName[0]);
        f0.checkFails("^timestamp_diff(timestamp '2008-12-25 15:30:00', timestamp '2008-12-25 16:30:00', minute)^", "No match found for function signature TIMESTAMP_DIFF\\(<TIMESTAMP>, <TIMESTAMP>, <INTERVAL_DAY_TIME>\\)", false);
        SqlOperatorFixture f = this.fixture().withLibrary(SqlLibrary.BIG_QUERY).setFor((SqlOperator)SqlLibraryOperators.TIMESTAMP_DIFF3, new SqlOperatorFixture.VmName[0]);
        HOUR_VARIANTS.forEach(s -> f.checkScalar("timestamp_diff(timestamp '2016-02-24 12:42:25', timestamp '2016-02-24 15:42:25', " + s + ")", "-3", "INTEGER NOT NULL"));
        MICROSECOND_VARIANTS.forEach(s -> f.checkScalar("timestamp_diff(timestamp '2016-02-24 12:42:25', timestamp '2016-02-24 12:42:20', " + s + ")", "5000000", "INTEGER NOT NULL"));
        YEAR_VARIANTS.forEach(s -> f.checkScalar("timestamp_diff(timestamp '2014-02-24 12:42:25', timestamp '2016-02-24 12:42:25', " + s + ")", "-2", "INTEGER NOT NULL"));
        WEEK_VARIANTS.forEach(s -> f.checkScalar("timestamp_diff(timestamp '2014-02-24 12:42:25', timestamp '2016-02-24 12:42:25', " + s + ")", "-104", "INTEGER NOT NULL"));
        WEEK_VARIANTS.forEach(s -> f.checkScalar("timestamp_diff(timestamp '2014-02-19 12:42:25', timestamp '2016-02-24 12:42:25', " + s + ")", "-105", "INTEGER NOT NULL"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("timestamp_diff(timestamp '2014-02-24 12:42:25', timestamp '2016-02-24 12:42:25', " + s + ")", "-24", "INTEGER NOT NULL"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("timestamp_diff(timestamp '2019-09-01 12:42:25', timestamp '2020-03-01 12:42:25', " + s + ")", "-6", "INTEGER NOT NULL"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("timestamp_diff(timestamp '2019-09-01 12:42:25', timestamp '2016-08-01 12:42:25', " + s + ")", "37", "INTEGER NOT NULL"));
        QUARTER_VARIANTS.forEach(s -> f.checkScalar("timestamp_diff(timestamp '2014-02-24 12:42:25', timestamp '2016-02-24 12:42:25', " + s + ")", "-8", "INTEGER NOT NULL"));
        f.checkScalar("timestamp_diff(timestamp '2014-02-24 12:42:25', timestamp '2614-02-24 12:42:25', CENTURY)", "-6", "INTEGER NOT NULL");
        QUARTER_VARIANTS.forEach(s -> f.checkScalar("timestamp_diff(timestamp '2016-02-24 12:42:25', cast(null as timestamp), " + s + ")", ResultCheckers.isNullValue(), "INTEGER"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("timestamp_diff(date '2016-03-15', date '2016-06-14', " + s + ")", "-3", "INTEGER NOT NULL"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("timestamp_diff(date '2019-09-01', date '2020-03-01', " + s + ")", "-6", "INTEGER NOT NULL"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("timestamp_diff(date '2019-09-01', date '2016-08-01', " + s + ")", "37", "INTEGER NOT NULL"));
        DAY_VARIANTS.forEach(s -> f.checkScalar("timestamp_diff(date '2016-06-15', date '2016-06-14', " + s + ")", "1", "INTEGER NOT NULL"));
        HOUR_VARIANTS.forEach(s -> f.checkScalar("timestamp_diff(date '2016-06-15', date '2016-06-14', " + s + ")", "24", "INTEGER NOT NULL"));
        HOUR_VARIANTS.forEach(s -> f.checkScalar("timestamp_diff(date '2016-06-15',  date '2016-06-15', " + s + ")", "0", "INTEGER NOT NULL"));
        MINUTE_VARIANTS.forEach(s -> f.checkScalar("timestamp_diff(date '2016-06-15', date '2016-06-14', " + s + ")", "1440", "INTEGER NOT NULL"));
        DAY_VARIANTS.forEach(s -> f.checkScalar("timestamp_diff(date '2016-06-15', cast(null as date), " + s + ")", ResultCheckers.isNullValue(), "INTEGER"));
    }

    @Test
    void testDatetimeDiff() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlLibraryOperators.DATETIME_DIFF, new SqlOperatorFixture.VmName[0]);
        f0.checkFails("^datetime_diff(timestamp '2008-12-25 15:30:00', timestamp '2008-12-25 16:30:00', minute)^", "No match found for function signature DATETIME_DIFF\\(<TIMESTAMP>, <TIMESTAMP>, <INTERVAL_DAY_TIME>\\)", false);
        SqlOperatorFixture f = this.fixture().withLibrary(SqlLibrary.BIG_QUERY).setFor((SqlOperator)SqlLibraryOperators.DATETIME_DIFF, new SqlOperatorFixture.VmName[0]);
        HOUR_VARIANTS.forEach(s -> f.checkScalar("datetime_diff(timestamp '2016-02-24 12:42:25', timestamp '2016-02-24 15:42:25', " + s + ")", "-3", "INTEGER NOT NULL"));
        MICROSECOND_VARIANTS.forEach(s -> f.checkScalar("datetime_diff(timestamp '2016-02-24 12:42:25', timestamp '2016-02-24 12:42:20', " + s + ")", "5000000", "INTEGER NOT NULL"));
        YEAR_VARIANTS.forEach(s -> f.checkScalar("datetime_diff(timestamp '2014-02-24 12:42:25', timestamp '2016-02-24 12:42:25', " + s + ")", "-2", "INTEGER NOT NULL"));
        WEEK_VARIANTS.forEach(s -> f.checkScalar("datetime_diff(timestamp '2014-02-24 12:42:25', timestamp '2016-02-24 12:42:25', " + s + ")", "-104", "INTEGER NOT NULL"));
        WEEK_VARIANTS.forEach(s -> f.checkScalar("datetime_diff(timestamp '2014-02-19 12:42:25', timestamp '2016-02-24 12:42:25', " + s + ")", "-105", "INTEGER NOT NULL"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("datetime_diff(timestamp '2014-02-24 12:42:25', timestamp '2016-02-24 12:42:25', " + s + ")", "-24", "INTEGER NOT NULL"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("datetime_diff(timestamp '2019-09-01 12:42:25', timestamp '2020-03-01 12:42:25', " + s + ")", "-6", "INTEGER NOT NULL"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("datetime_diff(timestamp '2019-09-01 12:42:25', timestamp '2016-08-01 12:42:25', " + s + ")", "37", "INTEGER NOT NULL"));
        QUARTER_VARIANTS.forEach(s -> f.checkScalar("datetime_diff(timestamp '2014-02-24 12:42:25', timestamp '2016-02-24 12:42:25', " + s + ")", "-8", "INTEGER NOT NULL"));
        f.checkScalar("datetime_diff(timestamp '2014-02-24 12:42:25', timestamp '2614-02-24 12:42:25', CENTURY)", "-6", "INTEGER NOT NULL");
        QUARTER_VARIANTS.forEach(s -> f.checkScalar("datetime_diff(timestamp '2016-02-24 12:42:25', cast(null as timestamp), " + s + ")", ResultCheckers.isNullValue(), "INTEGER"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("datetime_diff(date '2016-03-15', date '2016-06-14', " + s + ")", "-3", "INTEGER NOT NULL"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("datetime_diff(date '2019-09-01', date '2020-03-01', " + s + ")", "-6", "INTEGER NOT NULL"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("datetime_diff(date '2019-09-01', date '2016-08-01', " + s + ")", "37", "INTEGER NOT NULL"));
        DAY_VARIANTS.forEach(s -> f.checkScalar("datetime_diff(date '2016-06-15', date '2016-06-14', " + s + ")", "1", "INTEGER NOT NULL"));
        HOUR_VARIANTS.forEach(s -> f.checkScalar("datetime_diff(date '2016-06-15', date '2016-06-14', " + s + ")", "24", "INTEGER NOT NULL"));
        HOUR_VARIANTS.forEach(s -> f.checkScalar("datetime_diff(date '2016-06-15',  date '2016-06-15', " + s + ")", "0", "INTEGER NOT NULL"));
        MINUTE_VARIANTS.forEach(s -> f.checkScalar("datetime_diff(date '2016-06-15', date '2016-06-14', " + s + ")", "1440", "INTEGER NOT NULL"));
        DAY_VARIANTS.forEach(s -> f.checkScalar("datetime_diff(date '2016-06-15', cast(null as date), " + s + ")", ResultCheckers.isNullValue(), "INTEGER"));
    }

    @ValueSource(booleans={true, false})
    @ParameterizedTest(name="CoercionEnabled: {0}")
    void testTimestampDiff(boolean coercionEnabled) {
        SqlOperatorFixture f = this.fixture().withValidatorConfig(c -> c.withTypeCoercionEnabled(coercionEnabled));
        f.setFor((SqlOperator)SqlStdOperatorTable.TIMESTAMP_DIFF, SqlOperatorFixture.VmName.EXPAND);
        HOUR_VARIANTS.forEach(s -> f.checkScalar("timestampdiff(" + s + ", timestamp '2016-02-24 12:42:25', timestamp '2016-02-24 15:42:25')", "3", "INTEGER NOT NULL"));
        MICROSECOND_VARIANTS.forEach(s -> f.checkScalar("timestampdiff(" + s + ", timestamp '2016-02-24 12:42:25', timestamp '2016-02-24 12:42:20')", "-5000000", "INTEGER NOT NULL"));
        NANOSECOND_VARIANTS.forEach(s -> f.checkScalar("timestampdiff(" + s + ", timestamp '2016-02-24 12:42:25', timestamp '2016-02-24 12:42:20')", "-5000000000", "BIGINT NOT NULL"));
        YEAR_VARIANTS.forEach(s -> f.checkScalar("timestampdiff(" + s + ", timestamp '2014-02-24 12:42:25', timestamp '2016-02-24 12:42:25')", "2", "INTEGER NOT NULL"));
        WEEK_VARIANTS.forEach(s -> f.checkScalar("timestampdiff(" + s + ", timestamp '2014-02-24 12:42:25', timestamp '2016-02-24 12:42:25')", "104", "INTEGER NOT NULL"));
        WEEK_VARIANTS.forEach(s -> f.checkScalar("timestampdiff(" + s + ", timestamp '2014-02-19 12:42:25', timestamp '2016-02-24 12:42:25')", "105", "INTEGER NOT NULL"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("timestampdiff(" + s + ", timestamp '2014-02-24 12:42:25', timestamp '2016-02-24 12:42:25')", "24", "INTEGER NOT NULL"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("timestampdiff(" + s + ", timestamp '2019-09-01 00:00:00', timestamp '2020-03-01 00:00:00')", "6", "INTEGER NOT NULL"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("timestampdiff(" + s + ", timestamp '2019-09-01 00:00:00', timestamp '2016-08-01 00:00:00')", "-37", "INTEGER NOT NULL"));
        QUARTER_VARIANTS.forEach(s -> f.checkScalar("timestampdiff(" + s + ", timestamp '2014-02-24 12:42:25', timestamp '2016-02-24 12:42:25')", "8", "INTEGER NOT NULL"));
        f.checkScalar("timestampdiff(CENTURY, timestamp '2014-02-24 12:42:25', timestamp '2614-02-24 12:42:25')", "6", "INTEGER NOT NULL");
        QUARTER_VARIANTS.forEach(s -> f.checkScalar("timestampdiff(" + s + ", timestamp '2014-02-24 12:42:25', cast(null as timestamp))", ResultCheckers.isNullValue(), "INTEGER"));
        QUARTER_VARIANTS.forEach(s -> f.checkScalar("timestampdiff(" + s + ", cast(null as timestamp), timestamp '2014-02-24 12:42:25')", ResultCheckers.isNullValue(), "INTEGER"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("timestampdiff(" + s + ", date '2016-03-15', date '2016-06-14')", "2", "INTEGER NOT NULL"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("timestampdiff(" + s + ", date '2019-09-01', date '2020-03-01')", "6", "INTEGER NOT NULL"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("timestampdiff(" + s + ", date '2019-09-01', date '2016-08-01')", "-37", "INTEGER NOT NULL"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("timestampdiff(" + s + ", time '12:42:25', time '12:42:25')", "0", "INTEGER NOT NULL"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("timestampdiff(" + s + ", time '12:42:25', date '2016-06-14')", "-1502389", "INTEGER NOT NULL"));
        MONTH_VARIANTS.forEach(s -> f.checkScalar("timestampdiff(" + s + ", date '2016-06-14', time '12:42:25')", "1502389", "INTEGER NOT NULL"));
        DAY_VARIANTS.forEach(s -> f.checkScalar("timestampdiff(" + s + ", date '2016-06-15', date '2016-06-14')", "-1", "INTEGER NOT NULL"));
        HOUR_VARIANTS.forEach(s -> f.checkScalar("timestampdiff(" + s + ", date '2016-06-15', date '2016-06-14')", "-24", "INTEGER NOT NULL"));
        HOUR_VARIANTS.forEach(s -> f.checkScalar("timestampdiff(" + s + ", date '2016-06-15',  date '2016-06-15')", "0", "INTEGER NOT NULL"));
        MINUTE_VARIANTS.forEach(s -> f.checkScalar("timestampdiff(" + s + ", date '2016-06-15', date '2016-06-14')", "-1440", "INTEGER NOT NULL"));
        SECOND_VARIANTS.forEach(s -> f.checkScalar("timestampdiff(" + s + ", cast(null as date), date '2016-06-15')", ResultCheckers.isNullValue(), "INTEGER"));
        DAY_VARIANTS.forEach(s -> f.checkScalar("timestampdiff(" + s + ", date '2016-06-15', cast(null as date))", ResultCheckers.isNullValue(), "INTEGER"));
    }

    @Test
    void testTimestampSub() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlLibraryOperators.TIMESTAMP_SUB, new SqlOperatorFixture.VmName[0]);
        f0.checkFails("^timestamp_sub(timestamp '2008-12-25 15:30:00', interval 5 minute)^", "No match found for function signature TIMESTAMP_SUB\\(<TIMESTAMP>, <INTERVAL_DAY_TIME>\\)", false);
        SqlOperatorFixture f = f0.withLibrary(SqlLibrary.BIG_QUERY);
        f.checkScalar("timestamp_sub(timestamp '2016-02-24 12:42:25', interval 2 second)", "2016-02-24 12:42:23", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("timestamp_sub(timestamp '2016-02-24 12:42:25', interval 2 minute)", "2016-02-24 12:40:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("timestamp_sub(timestamp '2016-02-24 12:42:25', interval 2000 hour)", "2015-12-03 04:42:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("timestamp_sub(timestamp '2016-02-24 12:42:25', interval 1 day)", "2016-02-23 12:42:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("timestamp_sub(timestamp '2016-02-24 12:42:25', interval 2 week)", "2016-02-10 12:42:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("timestamp_sub(timestamp '2016-02-24 12:42:25', interval 2 weeks)", "2016-02-10 12:42:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("timestamp_sub(timestamp '2016-02-24 12:42:25', interval 1 month)", "2016-01-24 12:42:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("timestamp_sub(timestamp '2016-02-24 12:42:25', interval 1 quarter)", "2015-11-24 12:42:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("timestamp_sub(timestamp '2016-02-24 12:42:25', interval 1 quarters)", "2015-11-24 12:42:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("timestamp_sub(timestamp '2016-02-24 12:42:25', interval 1 year)", "2015-02-24 12:42:25", "TIMESTAMP(0) NOT NULL");
        f.checkNull("timestamp_sub(CAST(NULL AS TIMESTAMP), interval 5 minute)");
    }

    @Test
    void testTimeSub() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlLibraryOperators.TIME_SUB, new SqlOperatorFixture.VmName[0]);
        f0.checkFails("^time_sub(time '15:30:00', interval 5 minute)^", "No match found for function signature TIME_SUB\\(<TIME>, <INTERVAL_DAY_TIME>\\)", false);
        SqlOperatorFixture f = f0.withLibrary(SqlLibrary.BIG_QUERY);
        f.checkScalar("time_sub(time '12:42:25', interval 2 second)", "12:42:23", "TIME(0) NOT NULL");
        f.checkScalar("time_sub(time '12:42:25', interval 2 minute)", "12:40:25", "TIME(0) NOT NULL");
        f.checkScalar("time_sub(time '12:42:25', interval 0 minute)", "12:42:25", "TIME(0) NOT NULL");
        f.checkScalar("time_sub(time '12:42:25', interval 20 hour)", "16:42:25", "TIME(0) NOT NULL");
        f.checkScalar("time_sub(time '12:34:45', interval -5 second)", "12:34:50", "TIME(0) NOT NULL");
        f.checkNull("time_sub(CAST(NULL AS TIME), interval 5 minute)");
    }

    @Test
    void testDateSub() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlLibraryOperators.DATE_SUB, new SqlOperatorFixture.VmName[0]);
        f0.checkFails("^date_sub(date '2008-12-25', interval 5 day)^", "No match found for function signature DATE_SUB\\(<DATE>, <INTERVAL_DAY_TIME>\\)", false);
        SqlOperatorFixture f = f0.withLibrary(SqlLibrary.BIG_QUERY);
        f.checkScalar("date_sub(date '2016-02-24', interval 2 day)", "2016-02-22", "DATE NOT NULL");
        f.checkScalar("date_sub(date '2016-02-24', interval 1 week)", "2016-02-17", "DATE NOT NULL");
        f.checkScalar("date_sub(date '2016-02-24', interval 2 weeks)", "2016-02-10", "DATE NOT NULL");
        f.checkScalar("date_sub(date '2020-10-17', interval 0 week)", "2020-10-17", "DATE NOT NULL");
        f.checkScalar("date_sub(date '2016-02-24', interval 3 month)", "2015-11-24", "DATE NOT NULL");
        f.checkScalar("date_sub(date '2016-02-24', interval 1 quarter)", "2015-11-24", "DATE NOT NULL");
        f.checkScalar("date_sub(date '2016-02-24', interval 2 quarters)", "2015-08-24", "DATE NOT NULL");
        f.checkScalar("date_sub(date '2016-02-24', interval 5 year)", "2011-02-24", "DATE NOT NULL");
        f.checkNull("date_sub(CAST(NULL AS DATE), interval 5 day)");
    }

    @Test
    void testDatetimeSub() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlLibraryOperators.DATETIME_SUB, new SqlOperatorFixture.VmName[0]);
        f0.checkFails("^datetime_sub(timestamp '2008-12-25 15:30:00', interval 5 minute)^", "No match found for function signature DATETIME_SUB\\(<TIMESTAMP>, <INTERVAL_DAY_TIME>\\)", false);
        SqlOperatorFixture f = f0.withLibrary(SqlLibrary.BIG_QUERY);
        f.checkScalar("datetime_sub(timestamp '2016-02-24 12:42:25', interval 2 second)", "2016-02-24 12:42:23", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("datetime_sub(timestamp '2016-02-24 12:42:25', interval 2 minute)", "2016-02-24 12:40:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("datetime_sub(timestamp '2016-02-24 12:42:25', interval 2000 hour)", "2015-12-03 04:42:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("datetime_sub(timestamp '2016-02-24 12:42:25', interval 1 day)", "2016-02-23 12:42:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("datetime_sub(timestamp '2016-02-24 12:42:25', interval 1 month)", "2016-01-24 12:42:25", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("datetime_sub(timestamp '2016-02-24 12:42:25', interval 1 year)", "2015-02-24 12:42:25", "TIMESTAMP(0) NOT NULL");
        f.checkNull("datetime_sub(CAST(NULL AS TIMESTAMP), interval 5 minute)");
    }

    @Test
    void testDateDiff() {
        SqlOperatorFixture f = this.fixture().setFor((SqlOperator)SqlLibraryOperators.DATEDIFF, new SqlOperatorFixture.VmName[0]);
        f.checkFails("datediff(^\"MONTH\"^, '2019-09-14',  '2019-09-15')", "(?s)Column 'MONTH' not found in any table", false);
    }

    @Test
    void testTimeAdd() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlLibraryOperators.TIME_ADD, new SqlOperatorFixture.VmName[0]);
        f0.checkFails("^time_add(time '15:30:00', interval 5 minute)^", "No match found for function signature TIME_ADD\\(<TIME>, <INTERVAL_DAY_TIME>\\)", false);
        SqlOperatorFixture f = f0.withLibrary(SqlLibrary.BIG_QUERY);
        f.checkScalar("time_add(time '23:59:59', interval 2 second)", "00:00:01", "TIME(0) NOT NULL");
        f.checkScalar("time_add(time '23:59:59', interval 86402 second)", "00:00:01", "TIME(0) NOT NULL");
        f.checkScalar("time_add(time '15:30:00', interval 5 minute)", "15:35:00", "TIME(0) NOT NULL");
        f.checkScalar("time_add(time '15:30:00', interval 1445 minute)", "15:35:00", "TIME(0) NOT NULL");
        f.checkScalar("time_add(time '15:30:00', interval 3 hour)", "18:30:00", "TIME(0) NOT NULL");
        f.checkScalar("time_add(time '15:30:00', interval 27 hour)", "18:30:00", "TIME(0) NOT NULL");
        f.checkNull("time_add(cast(null as time), interval 5 minute)");
    }

    @Test
    void testTimeDiff() {
        SqlOperatorFixture f0 = this.fixture().setFor((SqlOperator)SqlLibraryOperators.TIME_DIFF, new SqlOperatorFixture.VmName[0]);
        f0.checkFails("^time_diff(time '15:30:00', time '16:30:00', minute)^", "No match found for function signature TIME_DIFF\\(<TIME>, <TIME>, <INTERVAL_DAY_TIME>\\)", false);
        SqlOperatorFixture f = f0.withLibrary(SqlLibrary.BIG_QUERY);
        f.checkScalar("time_diff(time '15:30:00', time '15:30:05', millisecond)", "-5000", "INTEGER NOT NULL");
        MICROSECOND_VARIANTS.forEach(s -> f.checkScalar("time_diff(time '15:30:00', time '15:30:05', " + s + ")", "-5000000", "INTEGER NOT NULL"));
        SECOND_VARIANTS.forEach(s -> f.checkScalar("time_diff(time '15:30:00', time '15:29:00', " + s + ")", "60", "INTEGER NOT NULL"));
        MINUTE_VARIANTS.forEach(s -> f.checkScalar("time_diff(time '15:30:00', time '15:29:00', " + s + ")", "1", "INTEGER NOT NULL"));
        HOUR_VARIANTS.forEach(s -> f.checkScalar("time_diff(time '15:30:00', time '16:30:00', " + s + ")", "-1", "INTEGER NOT NULL"));
        MINUTE_VARIANTS.forEach(s -> f.checkScalar("time_diff(time '15:30:00', cast(null as time), " + s + ")", ResultCheckers.isNullValue(), "INTEGER"));
    }

    @Test
    void testTimeTrunc() {
        SqlOperatorFixture nonBigQuery = this.fixture().setFor((SqlOperator)SqlLibraryOperators.TIME_TRUNC, new SqlOperatorFixture.VmName[0]);
        nonBigQuery.checkFails("^time_trunc(time '15:30:00', hour)^", "No match found for function signature TIME_TRUNC\\(<TIME>, <INTERVAL_DAY_TIME>\\)", false);
        SqlOperatorFixture f = this.fixture().withLibrary(SqlLibrary.BIG_QUERY).setFor((SqlOperator)SqlLibraryOperators.TIME_TRUNC, new SqlOperatorFixture.VmName[0]);
        f.checkFails("time_trunc(time '12:34:56', ^year^)", "'YEAR' is not a valid time frame", false);
        f.checkFails("^time_trunc(123.45, minute)^", "Cannot apply 'TIME_TRUNC' to arguments of type 'TIME_TRUNC\\(<DECIMAL\\(5, 2\\)>, <INTERVAL MINUTE>\\)'\\. Supported form\\(s\\): 'TIME_TRUNC\\(<TIME>, <DATETIME_INTERVAL>\\)'", false);
        f.checkScalar("time_trunc(time '12:34:56', second)", "12:34:56", "TIME(0) NOT NULL");
        f.checkScalar("time_trunc(time '12:34:56', minute)", "12:34:00", "TIME(0) NOT NULL");
        f.checkScalar("time_trunc(time '12:34:56', hour)", "12:00:00", "TIME(0) NOT NULL");
        f.checkNull("time_trunc(cast(null as time), second)");
    }

    @Test
    void testTimestampTrunc() {
        SqlOperatorFixture nonBigQuery = this.fixture().setFor((SqlOperator)SqlLibraryOperators.TIMESTAMP_TRUNC, new SqlOperatorFixture.VmName[0]);
        nonBigQuery.checkFails("^timestamp_trunc(timestamp '2012-05-02 15:30:00', hour)^", "No match found for function signature TIMESTAMP_TRUNC\\(<TIMESTAMP>, <INTERVAL_DAY_TIME>\\)", false);
        SqlOperatorFixture f = this.fixture().withLibrary(SqlLibrary.BIG_QUERY).setFor((SqlOperator)SqlLibraryOperators.TIMESTAMP_TRUNC, new SqlOperatorFixture.VmName[0]);
        f.checkFails("^timestamp_trunc(100, hour)^", "Cannot apply 'TIMESTAMP_TRUNC' to arguments of type 'TIMESTAMP_TRUNC\\(<INTEGER>, <INTERVAL HOUR>\\)'\\. Supported form\\(s\\): 'TIMESTAMP_TRUNC\\(<TIMESTAMP>, <DATETIME_INTERVAL>\\)'", false);
        f.checkFails("^timestamp_trunc(100, foo)^", "Cannot apply 'TIMESTAMP_TRUNC' to arguments of type 'TIMESTAMP_TRUNC\\(<INTEGER>, <INTERVAL `FOO`>\\)'\\. Supported form\\(s\\): 'TIMESTAMP_TRUNC\\(<TIMESTAMP>, <DATETIME_INTERVAL>\\)'", false);
        f.checkFails("timestamp_trunc(timestamp '2015-02-19 12:34:56.78', ^microsecond^)", "'MICROSECOND' is not a valid time frame", false);
        f.checkFails("timestamp_trunc(timestamp '2015-02-19 12:34:56.78', ^nanosecond^)", "'NANOSECOND' is not a valid time frame", false);
        f.checkFails("timestamp_trunc(timestamp '2015-02-19 12:34:56.78', ^millisecond^)", "'MILLISECOND' is not a valid time frame", false);
        f.checkScalar("timestamp_trunc(timestamp '2015-02-19 12:34:56.78', second)", "2015-02-19 12:34:56", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("timestamp_trunc(timestamp '2015-02-19 12:34:56', minute)", "2015-02-19 12:34:00", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("timestamp_trunc(timestamp '2015-02-19 12:34:56', hour)", "2015-02-19 12:00:00", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("timestamp_trunc(timestamp '2015-02-19 12:34:56', day)", "2015-02-19 00:00:00", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("timestamp_trunc(timestamp '2015-02-19 12:34:56', week)", "2015-02-15 00:00:00", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("timestamp_trunc(timestamp '2015-02-19 12:34:56', month)", "2015-02-01 00:00:00", "TIMESTAMP(0) NOT NULL");
        f.checkScalar("timestamp_trunc(timestamp '2015-02-19 12:34:56', year)", "2015-01-01 00:00:00", "TIMESTAMP(0) NOT NULL");
    }

    @Test
    void testDateTrunc() {
        SqlOperatorFixture f = this.fixture().withLibrary(SqlLibrary.BIG_QUERY).setFor((SqlOperator)SqlLibraryOperators.DATE_TRUNC, new SqlOperatorFixture.VmName[0]);
        f.checkFails("date_trunc(date '2015-02-19', ^foo^)", "Column 'FOO' not found in any table", false);
        f.checkScalar("date_trunc(date '2015-02-19', day)", "2015-02-19", "DATE NOT NULL");
        f.checkScalar("date_trunc(date '2015-02-19', week)", "2015-02-15", "DATE NOT NULL");
        f.checkScalar("date_trunc(date '2015-02-19', isoweek)", "2015-02-16", "DATE NOT NULL");
        f.checkScalar("date_trunc(date '2015-02-19', week(sunday))", "2015-02-15", "DATE NOT NULL");
        f.checkScalar("date_trunc(date '2015-02-19', week(monday))", "2015-02-16", "DATE NOT NULL");
        f.checkScalar("date_trunc(date '2015-02-19', week(tuesday))", "2015-02-17", "DATE NOT NULL");
        f.checkScalar("date_trunc(date '2015-02-19', week(wednesday))", "2015-02-18", "DATE NOT NULL");
        f.checkScalar("date_trunc(date '2015-02-19', week(thursday))", "2015-02-19", "DATE NOT NULL");
        f.checkScalar("date_trunc(date '2015-02-19', week(friday))", "2015-02-13", "DATE NOT NULL");
        f.checkScalar("date_trunc(date '2015-02-19', week(saturday))", "2015-02-14", "DATE NOT NULL");
        f.checkScalar("date_trunc(date '2015-02-19', month)", "2015-02-01", "DATE NOT NULL");
        f.checkScalar("date_trunc(date '2015-02-19', quarter)", "2015-01-01", "DATE NOT NULL");
        f.checkScalar("date_trunc(date '2015-02-19', year)", "2015-01-01", "DATE NOT NULL");
        f.checkScalar("date_trunc(date '2015-02-19', isoyear)", "2014-12-29", "DATE NOT NULL");
    }

    @Test
    void testFormatTime() {
        SqlOperatorFixture f = this.fixture().withLibrary(SqlLibrary.BIG_QUERY).setFor((SqlOperator)SqlLibraryOperators.FORMAT_TIME, new SqlOperatorFixture.VmName[0]);
        f.checkFails("^FORMAT_TIME('%x', timestamp '2008-12-25 15:30:00')^", "Cannot apply 'FORMAT_TIME' to arguments of type 'FORMAT_TIME\\(<CHAR\\(2\\)>, <TIMESTAMP\\(0\\)>\\)'\\. Supported form\\(s\\): 'FORMAT_TIME\\(<CHARACTER>, <TIME>\\)'", false);
        f.checkScalar("FORMAT_TIME('%H', TIME '12:34:33')", "12", "VARCHAR(2000) NOT NULL");
        f.checkScalar("FORMAT_TIME('%R', TIME '12:34:33')", "12:34", "VARCHAR(2000) NOT NULL");
        f.checkScalar("FORMAT_TIME('The time is %M-%S', TIME '12:34:33')", "The time is 34-33", "VARCHAR(2000) NOT NULL");
    }

    @Test
    void testFormatDate() {
        SqlOperatorFixture f = this.fixture().withLibrary(SqlLibrary.BIG_QUERY).setFor((SqlOperator)SqlLibraryOperators.FORMAT_DATE, new SqlOperatorFixture.VmName[0]);
        f.checkFails("^FORMAT_DATE('%x', 123)^", "Cannot apply 'FORMAT_DATE' to arguments of type 'FORMAT_DATE\\(<CHAR\\(2\\)>, <INTEGER>\\)'\\. Supported form\\(s\\): 'FORMAT_DATE\\(<CHARACTER>, <DATE>\\)'", false);
        f.checkScalar("FORMAT_DATE('%x', timestamp '2008-12-25 15:30:00')", "12/25/08", "VARCHAR(2000) NOT NULL");
        f.checkScalar("FORMAT_DATE('%b-%d-%Y', DATE '2008-12-25')", "Dec-25-2008", "VARCHAR(2000) NOT NULL");
        f.checkScalar("FORMAT_DATE('%b %Y', DATE '2008-12-25')", "Dec 2008", "VARCHAR(2000) NOT NULL");
        f.checkScalar("FORMAT_DATE('%x', DATE '2008-12-25')", "12/25/08", "VARCHAR(2000) NOT NULL");
        f.checkScalar("FORMAT_DATE('The date is: %x', DATE '2008-12-25')", "The date is: 12/25/08", "VARCHAR(2000) NOT NULL");
    }

    @Test
    void testFormatTimestamp() {
        SqlOperatorFixture f = this.fixture().withLibrary(SqlLibrary.BIG_QUERY).setFor((SqlOperator)SqlLibraryOperators.FORMAT_TIMESTAMP, new SqlOperatorFixture.VmName[0]);
        f.checkFails("^FORMAT_TIMESTAMP('%x', 123)^", "Cannot apply 'FORMAT_TIMESTAMP' to arguments of type 'FORMAT_TIMESTAMP\\(<CHAR\\(2\\)>, <INTEGER>\\)'\\. Supported form\\(s\\): FORMAT_TIMESTAMP\\(<CHARACTER>, <TIMESTAMP WITH LOCAL TIME ZONE>\\)\nFORMAT_TIMESTAMP\\(<CHARACTER>, <TIMESTAMP WITH LOCAL TIME ZONE>, <CHARACTER>\\)", false);
        f.checkScalar("FORMAT_TIMESTAMP('%c', TIMESTAMP WITH LOCAL TIME ZONE '2008-12-25 15:30:00')", "Thu Dec 25 15:30:00 2008", "VARCHAR(2000) NOT NULL");
        f.checkScalar("FORMAT_TIMESTAMP('%b-%d-%Y', TIMESTAMP WITH LOCAL TIME ZONE '2008-12-25 15:30:00')", "Dec-25-2008", "VARCHAR(2000) NOT NULL");
        f.checkScalar("FORMAT_TIMESTAMP('%b %Y', TIMESTAMP WITH LOCAL TIME ZONE '2008-12-25 15:30:00')", "Dec 2008", "VARCHAR(2000) NOT NULL");
        f.checkScalar("FORMAT_TIMESTAMP('%x', TIMESTAMP WITH LOCAL TIME ZONE '2008-12-25 15:30:00')", "12/25/08", "VARCHAR(2000) NOT NULL");
        f.checkScalar("FORMAT_TIMESTAMP('The time is: %R', TIMESTAMP WITH LOCAL TIME ZONE '2008-12-25 15:30:00')", "The time is: 15:30", "VARCHAR(2000) NOT NULL");
        f.checkScalar("FORMAT_TIMESTAMP('The time is: %R.%E2S', TIMESTAMP WITH LOCAL TIME ZONE '2008-12-25 15:30:00.1235456')", "The time is: 15:30.123", "VARCHAR(2000) NOT NULL");
    }

    @Test
    void testDenseRankFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.DENSE_RANK, VM_FENNEL, VM_JAVA);
    }

    @Test
    void testPercentRankFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.PERCENT_RANK, VM_FENNEL, VM_JAVA);
    }

    @Test
    void testRankFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.RANK, VM_FENNEL, VM_JAVA);
    }

    @Test
    void testCumeDistFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CUME_DIST, VM_FENNEL, VM_JAVA);
    }

    @Test
    void testRowNumberFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.ROW_NUMBER, VM_FENNEL, VM_JAVA);
    }

    @Test
    void testPercentileContFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.PERCENTILE_CONT, VM_FENNEL, VM_JAVA);
        f.checkType("percentile_cont(0.25) within group (order by 1)", "INTEGER NOT NULL");
        f.checkFails("percentile_cont(0.25) within group (^order by 'a'^)", "Invalid type 'CHAR' in ORDER BY clause of 'PERCENTILE_CONT' function. Only NUMERIC types are supported", false);
        f.checkFails("percentile_cont(0.25) within group (^order by 1, 2^)", "'PERCENTILE_CONT' requires precisely one ORDER BY key", false);
        f.checkFails(" ^percentile_cont(2 + 3)^ within group (order by 1)", "Argument to function 'PERCENTILE_CONT' must be a literal", false);
        f.checkFails(" ^percentile_cont(2)^ within group (order by 1)", "Argument to function 'PERCENTILE_CONT' must be a numeric literal between 0 and 1", false);
    }

    @Test
    void testPercentileDiscFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.PERCENTILE_DISC, VM_FENNEL, VM_JAVA);
        f.checkType("percentile_disc(0.25) within group (order by 1)", "INTEGER NOT NULL");
        f.checkFails("percentile_disc(0.25) within group (^order by 'a'^)", "Invalid type 'CHAR' in ORDER BY clause of 'PERCENTILE_DISC' function. Only NUMERIC types are supported", false);
        f.checkFails("percentile_disc(0.25) within group (^order by 1, 2^)", "'PERCENTILE_DISC' requires precisely one ORDER BY key", false);
        f.checkFails(" ^percentile_disc(2 + 3)^ within group (order by 1)", "Argument to function 'PERCENTILE_DISC' must be a literal", false);
        f.checkFails(" ^percentile_disc(2)^ within group (order by 1)", "Argument to function 'PERCENTILE_DISC' must be a numeric literal between 0 and 1", false);
    }

    @Test
    void testCountFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.COUNT, VM_EXPAND);
        f.checkType("count(*)", "BIGINT NOT NULL");
        f.checkType("count('name')", "BIGINT NOT NULL");
        f.checkType("count(1)", "BIGINT NOT NULL");
        f.checkType("count(1.2)", "BIGINT NOT NULL");
        f.checkType("COUNT(DISTINCT 'x')", "BIGINT NOT NULL");
        f.checkFails("^COUNT()^", "Invalid number of arguments to function 'COUNT'. Was expecting 1 arguments", false);
        f.checkType("count(1, 2)", "BIGINT NOT NULL");
        f.checkType("count(1, 2, 'x', 'y')", "BIGINT NOT NULL");
        String[] values = new String[]{"0", "CAST(null AS INTEGER)", "1", "0"};
        f.checkAgg("COUNT(x)", values, ResultCheckers.isSingle(3));
        f.checkAgg("COUNT(CASE x WHEN 0 THEN NULL ELSE -1 END)", values, ResultCheckers.isSingle(2));
        f.checkAgg("COUNT(DISTINCT x)", values, ResultCheckers.isSingle(2));
        String[] stringValues = new String[]{"'a'", "CAST(NULL AS VARCHAR(1))", "''"};
        f.checkAgg("COUNT(*)", stringValues, ResultCheckers.isSingle(3));
        f.checkAgg("COUNT(x)", stringValues, ResultCheckers.isSingle(2));
        f.checkAgg("COUNT(DISTINCT x)", stringValues, ResultCheckers.isSingle(2));
        f.checkAgg("COUNT(DISTINCT 123)", stringValues, ResultCheckers.isSingle(1));
    }

    @Test
    void testCountifFunc() {
        SqlOperatorFixture f = this.fixture().setFor((SqlOperator)SqlLibraryOperators.COUNTIF, VM_FENNEL, VM_JAVA).withLibrary(SqlLibrary.BIG_QUERY);
        f.checkType("countif(true)", "BIGINT NOT NULL");
        f.checkType("countif(nullif(true,true))", "BIGINT NOT NULL");
        f.checkType("countif(false) filter (where true)", "BIGINT NOT NULL");
        String expectedError = "Invalid number of arguments to function 'COUNTIF'. Was expecting 1 arguments";
        f.checkFails("^COUNTIF()^", "Invalid number of arguments to function 'COUNTIF'. Was expecting 1 arguments", false);
        f.checkFails("^COUNTIF(true, false)^", "Invalid number of arguments to function 'COUNTIF'. Was expecting 1 arguments", false);
        String expectedError2 = "Cannot apply 'COUNTIF' to arguments of type 'COUNTIF\\(<INTEGER>\\)'\\. Supported form\\(s\\): 'COUNTIF\\(<BOOLEAN>\\)'";
        f.checkFails("^COUNTIF(1)^", "Cannot apply 'COUNTIF' to arguments of type 'COUNTIF\\(<INTEGER>\\)'\\. Supported form\\(s\\): 'COUNTIF\\(<BOOLEAN>\\)'", false);
        String[] values = new String[]{"1", "2", "CAST(NULL AS INTEGER)", "1"};
        f.checkAgg("countif(x > 0)", values, ResultCheckers.isSingle(3));
        f.checkAgg("countif(x < 2)", values, ResultCheckers.isSingle(2));
        f.checkAgg("countif(x is not null) filter (where x < 2)", values, ResultCheckers.isSingle(2));
        f.checkAgg("countif(x < 2) filter (where x is not null)", values, ResultCheckers.isSingle(2));
        f.checkAgg("countif(x between 1 and 2)", values, ResultCheckers.isSingle(3));
        f.checkAgg("countif(x < 0)", values, ResultCheckers.isSingle(0));
    }

    @Test
    void testApproxCountDistinctFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.COUNT, VM_EXPAND);
        f.checkFails("approx_count_distinct(^*^)", "Unknown identifier '\\*'", false);
        f.checkType("approx_count_distinct('name')", "BIGINT NOT NULL");
        f.checkType("approx_count_distinct(1)", "BIGINT NOT NULL");
        f.checkType("approx_count_distinct(1.2)", "BIGINT NOT NULL");
        f.checkType("APPROX_COUNT_DISTINCT(DISTINCT 'x')", "BIGINT NOT NULL");
        f.checkFails("^APPROX_COUNT_DISTINCT()^", "Invalid number of arguments to function 'APPROX_COUNT_DISTINCT'. Was expecting 1 arguments", false);
        f.checkType("approx_count_distinct(1, 2)", "BIGINT NOT NULL");
        f.checkType("approx_count_distinct(1, 2, 'x', 'y')", "BIGINT NOT NULL");
        String[] values = new String[]{"0", "CAST(null AS INTEGER)", "1", "0"};
        f.checkAgg("APPROX_COUNT_DISTINCT(x)", values, ResultCheckers.isSingle(2));
        f.checkAgg("APPROX_COUNT_DISTINCT(CASE x WHEN 0 THEN NULL ELSE -1 END)", values, ResultCheckers.isSingle(1));
        f.checkAgg("APPROX_COUNT_DISTINCT(DISTINCT x)", values, ResultCheckers.isSingle(2));
        String[] stringValues = new String[]{"'a'", "CAST(NULL AS VARCHAR(1))", "''"};
        f.checkAgg("APPROX_COUNT_DISTINCT(x)", stringValues, ResultCheckers.isSingle(2));
        f.checkAgg("APPROX_COUNT_DISTINCT(DISTINCT x)", stringValues, ResultCheckers.isSingle(2));
        f.checkAgg("APPROX_COUNT_DISTINCT(DISTINCT 123)", stringValues, ResultCheckers.isSingle(1));
    }

    @Test
    void testSumFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.SUM, VM_EXPAND);
        f.checkFails("sum(^*^)", "Unknown identifier '\\*'", false);
        f.enableTypeCoercion(false).checkFails("^sum('name')^", "(?s)Cannot apply 'SUM' to arguments of type 'SUM\\(<CHAR\\(4\\)>\\)'\\. Supported form\\(s\\): 'SUM\\(<NUMERIC>\\)'.*", false);
        f.checkType("sum('name')", "DECIMAL(19, 9)");
        f.checkAggType("sum(1)", "INTEGER NOT NULL");
        f.checkAggType("sum(1.2)", "DECIMAL(19, 1) NOT NULL");
        f.checkAggType("sum(DISTINCT 1.5)", "DECIMAL(19, 1) NOT NULL");
        f.checkFails("^sum()^", "Invalid number of arguments to function 'SUM'. Was expecting 1 arguments", false);
        f.checkFails("^sum(1, 2)^", "Invalid number of arguments to function 'SUM'. Was expecting 1 arguments", false);
        f.enableTypeCoercion(false).checkFails("^sum(cast(null as varchar(2)))^", "(?s)Cannot apply 'SUM' to arguments of type 'SUM\\(<VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'SUM\\(<NUMERIC>\\)'.*", false);
        f.checkType("sum(cast(null as varchar(2)))", "DECIMAL(19, 9)");
        String[] values = new String[]{"0", "CAST(null AS INTEGER)", "2", "2"};
        f.checkAgg("sum(x)", values, ResultCheckers.isSingle(4));
        if (!f.brokenTestsEnabled()) {
            return;
        }
        f.checkAgg("sum(CASE x WHEN 0 THEN NULL ELSE -1 END)", values, ResultCheckers.isSingle(-3));
        f.checkAgg("sum(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, ResultCheckers.isSingle(-1));
        f.checkAgg("sum(DISTINCT x)", values, ResultCheckers.isSingle(2));
    }

    @Test
    void testAvgFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.AVG, VM_EXPAND);
        f.checkFails("avg(^*^)", "Unknown identifier '\\*'", false);
        f.enableTypeCoercion(false).checkFails("^avg(cast(null as varchar(2)))^", "(?s)Cannot apply 'AVG' to arguments of type 'AVG\\(<VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'AVG\\(<NUMERIC>\\)'.*", false);
        f.checkType("avg(cast(null as varchar(2)))", "DECIMAL(19, 9)");
        f.checkType("AVG(CAST(NULL AS INTEGER))", "INTEGER");
        f.checkAggType("AVG(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL");
        f.checkAggType("avg(1)", "INTEGER NOT NULL");
        f.checkAggType("avg(1.2)", "DECIMAL(2, 1) NOT NULL");
        f.checkAggType("avg(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL");
        if (!f.brokenTestsEnabled()) {
            return;
        }
        String[] values = new String[]{"0", "CAST(null AS FLOAT)", "3", "3"};
        f.checkAgg("AVG(x)", values, ResultCheckers.isExactly(2.0));
        f.checkAgg("AVG(DISTINCT x)", values, ResultCheckers.isExactly(1.5));
        f.checkAgg("avg(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, ResultCheckers.isSingle(-1));
    }

    @Test
    void testCovarPopFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.COVAR_POP, VM_EXPAND);
        f.checkFails("covar_pop(^*^)", "Unknown identifier '\\*'", false);
        f.enableTypeCoercion(false).checkFails("^covar_pop(cast(null as varchar(2)), cast(null as varchar(2)))^", "(?s)Cannot apply 'COVAR_POP' to arguments of type 'COVAR_POP\\(<VARCHAR\\(2\\)>, <VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'COVAR_POP\\(<NUMERIC>, <NUMERIC>\\)'.*", false);
        f.checkType("covar_pop(cast(null as varchar(2)),cast(null as varchar(2)))", "DECIMAL(19, 9)");
        f.checkType("covar_pop(CAST(NULL AS INTEGER),CAST(NULL AS INTEGER))", "INTEGER");
        f.checkAggType("covar_pop(1.5, 2.5)", "DECIMAL(2, 1) NOT NULL");
        if (!f.brokenTestsEnabled()) {
            return;
        }
        f.checkAgg("covar_pop(x)", new String[0], ResultCheckers.isNullValue());
    }

    @Test
    void testCovarSampFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.COVAR_SAMP, VM_EXPAND);
        f.checkFails("covar_samp(^*^)", "Unknown identifier '\\*'", false);
        f.enableTypeCoercion(false).checkFails("^covar_samp(cast(null as varchar(2)), cast(null as varchar(2)))^", "(?s)Cannot apply 'COVAR_SAMP' to arguments of type 'COVAR_SAMP\\(<VARCHAR\\(2\\)>, <VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'COVAR_SAMP\\(<NUMERIC>, <NUMERIC>\\)'.*", false);
        f.checkType("covar_samp(cast(null as varchar(2)),cast(null as varchar(2)))", "DECIMAL(19, 9)");
        f.checkType("covar_samp(CAST(NULL AS INTEGER),CAST(NULL AS INTEGER))", "INTEGER");
        f.checkAggType("covar_samp(1.5, 2.5)", "DECIMAL(2, 1) NOT NULL");
        if (!f.brokenTestsEnabled()) {
            return;
        }
        f.checkAgg("covar_samp(x)", new String[0], ResultCheckers.isNullValue());
    }

    @Test
    void testRegrSxxFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.REGR_SXX, VM_EXPAND);
        f.checkFails("regr_sxx(^*^)", "Unknown identifier '\\*'", false);
        f.enableTypeCoercion(false).checkFails("^regr_sxx(cast(null as varchar(2)), cast(null as varchar(2)))^", "(?s)Cannot apply 'REGR_SXX' to arguments of type 'REGR_SXX\\(<VARCHAR\\(2\\)>, <VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'REGR_SXX\\(<NUMERIC>, <NUMERIC>\\)'.*", false);
        f.checkType("regr_sxx(cast(null as varchar(2)), cast(null as varchar(2)))", "DECIMAL(19, 9)");
        f.checkType("regr_sxx(CAST(NULL AS INTEGER), CAST(NULL AS INTEGER))", "INTEGER");
        f.checkAggType("regr_sxx(1.5, 2.5)", "DECIMAL(2, 1) NOT NULL");
        if (!f.brokenTestsEnabled()) {
            return;
        }
        f.checkAgg("regr_sxx(x)", new String[0], ResultCheckers.isNullValue());
    }

    @Test
    void testRegrSyyFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.REGR_SYY, VM_EXPAND);
        f.checkFails("regr_syy(^*^)", "Unknown identifier '\\*'", false);
        f.enableTypeCoercion(false).checkFails("^regr_syy(cast(null as varchar(2)), cast(null as varchar(2)))^", "(?s)Cannot apply 'REGR_SYY' to arguments of type 'REGR_SYY\\(<VARCHAR\\(2\\)>, <VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'REGR_SYY\\(<NUMERIC>, <NUMERIC>\\)'.*", false);
        f.checkType("regr_syy(cast(null as varchar(2)), cast(null as varchar(2)))", "DECIMAL(19, 9)");
        f.checkType("regr_syy(CAST(NULL AS INTEGER), CAST(NULL AS INTEGER))", "INTEGER");
        f.checkAggType("regr_syy(1.5, 2.5)", "DECIMAL(2, 1) NOT NULL");
        if (!f.brokenTestsEnabled()) {
            return;
        }
        f.checkAgg("regr_syy(x)", new String[0], ResultCheckers.isNullValue());
    }

    @Test
    void testStddevPopFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.STDDEV_POP, VM_EXPAND);
        f.checkFails("stddev_pop(^*^)", "Unknown identifier '\\*'", false);
        f.enableTypeCoercion(false).checkFails("^stddev_pop(cast(null as varchar(2)))^", "(?s)Cannot apply 'STDDEV_POP' to arguments of type 'STDDEV_POP\\(<VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'STDDEV_POP\\(<NUMERIC>\\)'.*", false);
        f.checkType("stddev_pop(cast(null as varchar(2)))", "DECIMAL(19, 9)");
        f.checkType("stddev_pop(CAST(NULL AS INTEGER))", "INTEGER");
        f.checkAggType("stddev_pop(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL");
        String[] values = new String[]{"0", "CAST(null AS FLOAT)", "3", "3"};
        if (f.brokenTestsEnabled()) {
            f.checkAgg("stddev_pop(x)", values, ResultCheckers.isWithin(1.414213562373095, 1.0E-15));
            f.checkAgg("stddev_pop(DISTINCT x)", values, ResultCheckers.isExactly(1.5));
            f.checkAgg("stddev_pop(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, ResultCheckers.isExactly(0.0));
        }
        f.checkAgg("stddev_pop(x)", new String[]{"5"}, ResultCheckers.isSingle(0));
        f.checkAgg("stddev_pop(x)", new String[0], ResultCheckers.isNullValue());
    }

    @Test
    void testStddevSampFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.STDDEV_SAMP, VM_EXPAND);
        f.checkFails("stddev_samp(^*^)", "Unknown identifier '\\*'", false);
        f.enableTypeCoercion(false).checkFails("^stddev_samp(cast(null as varchar(2)))^", "(?s)Cannot apply 'STDDEV_SAMP' to arguments of type 'STDDEV_SAMP\\(<VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'STDDEV_SAMP\\(<NUMERIC>\\)'.*", false);
        f.checkType("stddev_samp(cast(null as varchar(2)))", "DECIMAL(19, 9)");
        f.checkType("stddev_samp(CAST(NULL AS INTEGER))", "INTEGER");
        f.checkAggType("stddev_samp(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL");
        String[] values = new String[]{"0", "CAST(null AS FLOAT)", "3", "3"};
        if (f.brokenTestsEnabled()) {
            f.checkAgg("stddev_samp(x)", values, ResultCheckers.isWithin(1.732050807568877, 1.0E-15));
            f.checkAgg("stddev_samp(DISTINCT x)", values, ResultCheckers.isWithin(2.121320343559642, 1.0E-15));
            f.checkAgg("stddev_samp(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, ResultCheckers.isNullValue());
        }
        f.checkAgg("stddev_samp(x)", new String[]{"5"}, ResultCheckers.isNullValue());
        f.checkAgg("stddev_samp(x)", new String[0], ResultCheckers.isNullValue());
    }

    @Test
    void testStddevFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.STDDEV, VM_EXPAND);
        f.checkFails("stddev(^*^)", "Unknown identifier '\\*'", false);
        f.enableTypeCoercion(false).checkFails("^stddev(cast(null as varchar(2)))^", "(?s)Cannot apply 'STDDEV' to arguments of type 'STDDEV\\(<VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'STDDEV\\(<NUMERIC>\\)'.*", false);
        f.checkType("stddev(cast(null as varchar(2)))", "DECIMAL(19, 9)");
        f.checkType("stddev(CAST(NULL AS INTEGER))", "INTEGER");
        f.checkAggType("stddev(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL");
        f.checkAgg("stddev(x)", new String[]{"5"}, ResultCheckers.isNullValue());
        f.checkAgg("stddev(x)", new String[0], ResultCheckers.isNullValue());
    }

    @Test
    void testVarPopFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.VAR_POP, VM_EXPAND);
        f.checkFails("var_pop(^*^)", "Unknown identifier '\\*'", false);
        f.enableTypeCoercion(false).checkFails("^var_pop(cast(null as varchar(2)))^", "(?s)Cannot apply 'VAR_POP' to arguments of type 'VAR_POP\\(<VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'VAR_POP\\(<NUMERIC>\\)'.*", false);
        f.checkType("var_pop(cast(null as varchar(2)))", "DECIMAL(19, 9)");
        f.checkType("var_pop(CAST(NULL AS INTEGER))", "INTEGER");
        f.checkAggType("var_pop(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL");
        String[] values = new String[]{"0", "CAST(null AS FLOAT)", "3", "3"};
        if (!f.brokenTestsEnabled()) {
            return;
        }
        f.checkAgg("var_pop(x)", values, ResultCheckers.isExactly(2.0));
        f.checkAgg("var_pop(DISTINCT x)", values, ResultCheckers.isWithin(2.25, 1.0E-4));
        f.checkAgg("var_pop(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, ResultCheckers.isExactly(0.0));
        f.checkAgg("var_pop(x)", new String[]{"5"}, ResultCheckers.isExactly(0.0));
        f.checkAgg("var_pop(x)", new String[0], ResultCheckers.isNullValue());
    }

    @Test
    void testVarSampFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.VAR_SAMP, VM_EXPAND);
        f.checkFails("var_samp(^*^)", "Unknown identifier '\\*'", false);
        f.enableTypeCoercion(false).checkFails("^var_samp(cast(null as varchar(2)))^", "(?s)Cannot apply 'VAR_SAMP' to arguments of type 'VAR_SAMP\\(<VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'VAR_SAMP\\(<NUMERIC>\\)'.*", false);
        f.checkType("var_samp(cast(null as varchar(2)))", "DECIMAL(19, 9)");
        f.checkType("var_samp(CAST(NULL AS INTEGER))", "INTEGER");
        f.checkAggType("var_samp(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL");
        String[] values = new String[]{"0", "CAST(null AS FLOAT)", "3", "3"};
        if (!f.brokenTestsEnabled()) {
            return;
        }
        f.checkAgg("var_samp(x)", values, ResultCheckers.isExactly(3.0));
        f.checkAgg("var_samp(DISTINCT x)", values, ResultCheckers.isWithin(4.5, 1.0E-4));
        f.checkAgg("var_samp(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, ResultCheckers.isNullValue());
        f.checkAgg("var_samp(x)", new String[]{"5"}, ResultCheckers.isNullValue());
        f.checkAgg("var_samp(x)", new String[0], ResultCheckers.isNullValue());
    }

    @Test
    void testVarFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.VARIANCE, VM_EXPAND);
        f.checkFails("variance(^*^)", "Unknown identifier '\\*'", false);
        f.enableTypeCoercion(false).checkFails("^variance(cast(null as varchar(2)))^", "(?s)Cannot apply 'VARIANCE' to arguments of type 'VARIANCE\\(<VARCHAR\\(2\\)>\\)'\\. Supported form\\(s\\): 'VARIANCE\\(<NUMERIC>\\)'.*", false);
        f.checkType("variance(cast(null as varchar(2)))", "DECIMAL(19, 9)");
        f.checkType("variance(CAST(NULL AS INTEGER))", "INTEGER");
        f.checkAggType("variance(DISTINCT 1.5)", "DECIMAL(2, 1) NOT NULL");
        String[] values = new String[]{"0", "CAST(null AS FLOAT)", "3", "3"};
        if (!f.brokenTestsEnabled()) {
            return;
        }
        f.checkAgg("variance(x)", values, ResultCheckers.isExactly(3.0));
        f.checkAgg("variance(DISTINCT x)", values, ResultCheckers.isWithin(4.5, 1.0E-4));
        f.checkAgg("variance(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, ResultCheckers.isNullValue());
        f.checkAgg("variance(x)", new String[]{"5"}, ResultCheckers.isNullValue());
        f.checkAgg("variance(x)", new String[0], ResultCheckers.isNullValue());
    }

    @Test
    void testMinFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.MIN, VM_EXPAND);
        f.checkFails("min(^*^)", "Unknown identifier '\\*'", false);
        f.checkType("min(1)", "INTEGER");
        f.checkType("min(1.2)", "DECIMAL(2, 1)");
        f.checkType("min(DISTINCT 1.5)", "DECIMAL(2, 1)");
        f.checkFails("^min()^", "Invalid number of arguments to function 'MIN'. Was expecting 1 arguments", false);
        f.checkFails("^min(1, 2)^", "Invalid number of arguments to function 'MIN'. Was expecting 1 arguments", false);
        String[] values = new String[]{"0", "CAST(null AS INTEGER)", "2", "2"};
        if (!f.brokenTestsEnabled()) {
            return;
        }
        f.checkAgg("min(x)", values, ResultCheckers.isSingle("0"));
        f.checkAgg("min(CASE x WHEN 0 THEN NULL ELSE -1 END)", values, ResultCheckers.isSingle("-1"));
        f.checkAgg("min(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, ResultCheckers.isSingle("-1"));
        f.checkAgg("min(DISTINCT x)", values, ResultCheckers.isSingle("0"));
    }

    @Test
    void testMaxFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.MAX, VM_EXPAND);
        f.checkFails("max(^*^)", "Unknown identifier '\\*'", false);
        f.checkType("max(1)", "INTEGER");
        f.checkType("max(1.2)", "DECIMAL(2, 1)");
        f.checkType("max(DISTINCT 1.5)", "DECIMAL(2, 1)");
        f.checkFails("^max()^", "Invalid number of arguments to function 'MAX'. Was expecting 1 arguments", false);
        f.checkFails("^max(1, 2)^", "Invalid number of arguments to function 'MAX'. Was expecting 1 arguments", false);
        String[] values = new String[]{"0", "CAST(null AS INTEGER)", "2", "2"};
        if (!f.brokenTestsEnabled()) {
            return;
        }
        f.checkAgg("max(x)", values, ResultCheckers.isSingle("2"));
        f.checkAgg("max(CASE x WHEN 0 THEN NULL ELSE -1 END)", values, ResultCheckers.isSingle("-1"));
        f.checkAgg("max(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, ResultCheckers.isSingle("-1"));
        f.checkAgg("max(DISTINCT x)", values, ResultCheckers.isSingle("2"));
    }

    @Test
    void testLastValueFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.LAST_VALUE, VM_EXPAND);
        String[] values = new String[]{"0", "CAST(null AS INTEGER)", "3", "3"};
        if (!f.brokenTestsEnabled()) {
            return;
        }
        f.checkWinAgg("last_value(x)", values, "ROWS 3 PRECEDING", "INTEGER", ResultCheckers.isSet("3", "0"));
        String[] values2 = new String[]{"1.6", "1.2"};
        f.checkWinAgg("last_value(x)", values2, "ROWS 3 PRECEDING", "DECIMAL(2, 1) NOT NULL", ResultCheckers.isSet("1.6", "1.2"));
        String[] values3 = new String[]{"'foo'", "'bar'", "'name'"};
        f.checkWinAgg("last_value(x)", values3, "ROWS 3 PRECEDING", "CHAR(4) NOT NULL", ResultCheckers.isSet("foo ", "bar ", "name"));
    }

    @Test
    void testFirstValueFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.FIRST_VALUE, VM_EXPAND);
        String[] values = new String[]{"0", "CAST(null AS INTEGER)", "3", "3"};
        if (!f.brokenTestsEnabled()) {
            return;
        }
        f.checkWinAgg("first_value(x)", values, "ROWS 3 PRECEDING", "INTEGER", ResultCheckers.isSet("0"));
        String[] values2 = new String[]{"1.6", "1.2"};
        f.checkWinAgg("first_value(x)", values2, "ROWS 3 PRECEDING", "DECIMAL(2, 1) NOT NULL", ResultCheckers.isSet("1.6"));
        String[] values3 = new String[]{"'foo'", "'bar'", "'name'"};
        f.checkWinAgg("first_value(x)", values3, "ROWS 3 PRECEDING", "CHAR(4) NOT NULL", ResultCheckers.isSet("foo "));
    }

    @Test
    void testEveryFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.EVERY, VM_EXPAND);
        f.checkFails("every(^*^)", "Unknown identifier '\\*'", false);
        f.checkType("every(1 = 1)", "BOOLEAN");
        f.checkType("every(1.2 = 1.2)", "BOOLEAN");
        f.checkType("every(1.5 = 1.4)", "BOOLEAN");
        f.checkFails("^every()^", "Invalid number of arguments to function 'EVERY'. Was expecting 1 arguments", false);
        f.checkFails("^every(1, 2)^", "Invalid number of arguments to function 'EVERY'. Was expecting 1 arguments", false);
        String[] values = new String[]{"0", "CAST(null AS INTEGER)", "2", "2"};
        f.checkAgg("every(x = 2)", values, ResultCheckers.isSingle("false"));
    }

    @Test
    void testSomeAggFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.SOME, VM_EXPAND);
        f.checkFails("some(^*^)", "Unknown identifier '\\*'", false);
        f.checkType("some(1 = 1)", "BOOLEAN");
        f.checkType("some(1.2 = 1.2)", "BOOLEAN");
        f.checkType("some(1.5 = 1.4)", "BOOLEAN");
        f.checkFails("^some()^", "Invalid number of arguments to function 'SOME'. Was expecting 1 arguments", false);
        f.checkFails("^some(1, 2)^", "Invalid number of arguments to function 'SOME'. Was expecting 1 arguments", false);
        String[] values = new String[]{"0", "CAST(null AS INTEGER)", "2", "2"};
        f.checkAgg("some(x = 2)", values, ResultCheckers.isSingle("true"));
    }

    @Test
    void testAnyValueFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.ANY_VALUE, VM_EXPAND);
        f.checkFails("any_value(^*^)", "Unknown identifier '\\*'", false);
        f.checkType("any_value(1)", "INTEGER");
        f.checkType("any_value(1.2)", "DECIMAL(2, 1)");
        f.checkType("any_value(DISTINCT 1.5)", "DECIMAL(2, 1)");
        f.checkFails("^any_value()^", "Invalid number of arguments to function 'ANY_VALUE'. Was expecting 1 arguments", false);
        f.checkFails("^any_value(1, 2)^", "Invalid number of arguments to function 'ANY_VALUE'. Was expecting 1 arguments", false);
        String[] values = new String[]{"0", "CAST(null AS INTEGER)", "2", "2"};
        if (!f.brokenTestsEnabled()) {
            return;
        }
        f.checkAgg("any_value(x)", values, ResultCheckers.isSingle("0"));
        f.checkAgg("any_value(CASE x WHEN 0 THEN NULL ELSE -1 END)", values, ResultCheckers.isSingle("-1"));
        f.checkAgg("any_value(DISTINCT CASE x WHEN 0 THEN NULL ELSE -1 END)", values, ResultCheckers.isSingle("-1"));
        f.checkAgg("any_value(DISTINCT x)", values, ResultCheckers.isSingle("0"));
    }

    @Test
    void testBoolAndFunc() {
        SqlOperatorFixture f = this.fixture();
        String[] values = new String[]{"true", "true", "null"};
        f.checkAggFails("^bool_and(x)^", values, "No match found for function signature BOOL_AND\\(<BOOLEAN>\\)", false);
        SqlOperatorTest.checkBoolAndFunc(f.withLibrary(SqlLibrary.POSTGRESQL));
    }

    private static void checkBoolAndFunc(SqlOperatorFixture f) {
        f.setFor((SqlOperator)SqlLibraryOperators.BOOL_AND, VM_EXPAND);
        f.checkFails("bool_and(^*^)", "Unknown identifier '\\*'", false);
        f.checkType("bool_and(true)", "BOOLEAN");
        f.checkFails("^bool_and(1)^", "Cannot apply 'BOOL_AND' to arguments of type 'BOOL_AND\\(<INTEGER>\\)'\\. Supported form\\(s\\): 'BOOL_AND\\(<BOOLEAN>\\)'", false);
        f.checkFails("^bool_and()^", "Invalid number of arguments to function 'BOOL_AND'. Was expecting 1 arguments", false);
        f.checkFails("^bool_and(true, true)^", "Invalid number of arguments to function 'BOOL_AND'. Was expecting 1 arguments", false);
        String[] values1 = new String[]{"true", "true", "null"};
        f.checkAgg("bool_and(x)", values1, ResultCheckers.isSingle(true));
        String[] values2 = new String[]{"true", "false", "null"};
        f.checkAgg("bool_and(x)", values2, ResultCheckers.isSingle(false));
        String[] values3 = new String[]{"true", "false", "false"};
        f.checkAgg("bool_and(x)", values3, ResultCheckers.isSingle(false));
        String[] values4 = new String[]{"null"};
        f.checkAgg("bool_and(x)", values4, ResultCheckers.isNullValue());
    }

    @Test
    void testBoolOrFunc() {
        SqlOperatorFixture f = this.fixture();
        String[] values = new String[]{"true", "true", "null"};
        f.checkAggFails("^bool_or(x)^", values, "No match found for function signature BOOL_OR\\(<BOOLEAN>\\)", false);
        SqlOperatorTest.checkBoolOrFunc(f.withLibrary(SqlLibrary.POSTGRESQL));
    }

    private static void checkBoolOrFunc(SqlOperatorFixture f) {
        f.setFor((SqlOperator)SqlLibraryOperators.BOOL_OR, VM_EXPAND);
        f.checkFails("bool_or(^*^)", "Unknown identifier '\\*'", false);
        f.checkType("bool_or(true)", "BOOLEAN");
        f.checkFails("^bool_or(1)^", "Cannot apply 'BOOL_OR' to arguments of type 'BOOL_OR\\(<INTEGER>\\)'\\. Supported form\\(s\\): 'BOOL_OR\\(<BOOLEAN>\\)'", false);
        f.checkFails("^bool_or()^", "Invalid number of arguments to function 'BOOL_OR'. Was expecting 1 arguments", false);
        f.checkFails("^bool_or(true, true)^", "Invalid number of arguments to function 'BOOL_OR'. Was expecting 1 arguments", false);
        String[] values1 = new String[]{"true", "true", "null"};
        f.checkAgg("bool_or(x)", values1, ResultCheckers.isSingle(true));
        String[] values2 = new String[]{"true", "false", "null"};
        f.checkAgg("bool_or(x)", values2, ResultCheckers.isSingle(true));
        String[] values3 = new String[]{"false", "false", "false"};
        f.checkAgg("bool_or(x)", values3, ResultCheckers.isSingle(false));
        String[] values4 = new String[]{"null"};
        f.checkAgg("bool_or(x)", values4, ResultCheckers.isNullValue());
    }

    @Test
    void testLogicalAndFunc() {
        SqlOperatorFixture f = this.fixture();
        String[] values = new String[]{"true", "true", "null"};
        f.checkAggFails("^logical_and(x)^", values, "No match found for function signature LOGICAL_AND\\(<BOOLEAN>\\)", false);
        SqlOperatorTest.checkLogicalAndFunc(f.withLibrary(SqlLibrary.BIG_QUERY));
    }

    private static void checkLogicalAndFunc(SqlOperatorFixture f) {
        f.setFor((SqlOperator)SqlLibraryOperators.LOGICAL_AND, VM_EXPAND);
        f.checkFails("logical_and(^*^)", "Unknown identifier '\\*'", false);
        f.checkType("logical_and(true)", "BOOLEAN");
        f.checkFails("^logical_and(1)^", "Cannot apply 'LOGICAL_AND' to arguments of type 'LOGICAL_AND\\(<INTEGER>\\)'\\. Supported form\\(s\\): 'LOGICAL_AND\\(<BOOLEAN>\\)'", false);
        f.checkFails("^logical_and()^", "Invalid number of arguments to function 'LOGICAL_AND'. Was expecting 1 arguments", false);
        f.checkFails("^logical_and(true, true)^", "Invalid number of arguments to function 'LOGICAL_AND'. Was expecting 1 arguments", false);
        String[] values1 = new String[]{"true", "true", "null"};
        f.checkAgg("logical_and(x)", values1, ResultCheckers.isSingle(true));
        String[] values2 = new String[]{"true", "false", "null"};
        f.checkAgg("logical_and(x)", values2, ResultCheckers.isSingle(false));
        String[] values3 = new String[]{"true", "false", "false"};
        f.checkAgg("logical_and(x)", values3, ResultCheckers.isSingle(false));
        String[] values4 = new String[]{"null"};
        f.checkAgg("logical_and(x)", values4, ResultCheckers.isNullValue());
    }

    @Test
    void testLogicalOrFunc() {
        SqlOperatorFixture f = this.fixture();
        String[] values = new String[]{"true", "true", "null"};
        f.checkAggFails("^logical_or(x)^", values, "No match found for function signature LOGICAL_OR\\(<BOOLEAN>\\)", false);
        SqlOperatorTest.checkLogicalOrFunc(f.withLibrary(SqlLibrary.BIG_QUERY));
    }

    private static void checkLogicalOrFunc(SqlOperatorFixture f) {
        f.setFor((SqlOperator)SqlLibraryOperators.LOGICAL_OR, VM_EXPAND);
        f.checkFails("logical_or(^*^)", "Unknown identifier '\\*'", false);
        f.checkType("logical_or(true)", "BOOLEAN");
        f.checkFails("^logical_or(1)^", "Cannot apply 'LOGICAL_OR' to arguments of type 'LOGICAL_OR\\(<INTEGER>\\)'\\. Supported form\\(s\\): 'LOGICAL_OR\\(<BOOLEAN>\\)'", false);
        f.checkFails("^logical_or()^", "Invalid number of arguments to function 'LOGICAL_OR'. Was expecting 1 arguments", false);
        f.checkFails("^logical_or(true, true)^", "Invalid number of arguments to function 'LOGICAL_OR'. Was expecting 1 arguments", false);
        String[] values1 = new String[]{"true", "true", "null"};
        f.checkAgg("logical_or(x)", values1, ResultCheckers.isSingle(true));
        String[] values2 = new String[]{"true", "false", "null"};
        f.checkAgg("logical_or(x)", values2, ResultCheckers.isSingle(true));
        String[] values3 = new String[]{"false", "false", "false"};
        f.checkAgg("logical_or(x)", values3, ResultCheckers.isSingle(false));
        String[] values4 = new String[]{"null"};
        f.checkAgg("logical_or(x)", values4, ResultCheckers.isNullValue());
    }

    @Test
    void testBitAndFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.BIT_AND, VM_FENNEL, VM_JAVA);
        f.checkFails("bit_and(^*^)", "Unknown identifier '\\*'", false);
        f.checkType("bit_and(1)", "INTEGER");
        f.checkType("bit_and(CAST(2 AS TINYINT))", "TINYINT");
        f.checkType("bit_and(CAST(2 AS SMALLINT))", "SMALLINT");
        f.checkType("bit_and(distinct CAST(2 AS BIGINT))", "BIGINT");
        f.checkType("bit_and(CAST(x'02' AS BINARY(1)))", "BINARY(1)");
        f.checkFails("^bit_and(1.2)^", "Cannot apply 'BIT_AND' to arguments of type 'BIT_AND\\(<DECIMAL\\(2, 1\\)>\\)'\\. Supported form\\(s\\): 'BIT_AND\\(<INTEGER>\\)'\n'BIT_AND\\(<BINARY>\\)'", false);
        f.checkFails("^bit_and()^", "Invalid number of arguments to function 'BIT_AND'. Was expecting 1 arguments", false);
        f.checkFails("^bit_and(1, 2)^", "Invalid number of arguments to function 'BIT_AND'. Was expecting 1 arguments", false);
        String[] values = new String[]{"3", "2", "2"};
        f.checkAgg("bit_and(x)", values, ResultCheckers.isSingle("2"));
        String[] binaryValues = new String[]{"CAST(x'03' AS BINARY)", "cast(x'02' as BINARY)", "cast(x'02' AS BINARY)", "cast(null AS BINARY)"};
        f.checkAgg("bit_and(x)", binaryValues, ResultCheckers.isSingle("02"));
        f.checkAgg("bit_and(x)", new String[]{"CAST(x'02' AS BINARY)"}, ResultCheckers.isSingle("02"));
        f.checkAggFails("bit_and(x)", new String[]{"CAST(x'0201' AS VARBINARY)", "CAST(x'02' AS VARBINARY)"}, "Error while executing SQL \"SELECT bit_and\\(x\\) FROM \\(SELECT CAST\\(x'0201' AS VARBINARY\\) AS x FROM \\(VALUES \\(1\\)\\) UNION ALL SELECT CAST\\(x'02' AS VARBINARY\\) AS x FROM \\(VALUES \\(1\\)\\)\\)\": Different length for bitwise operands: the first: 2, the second: 1", true);
    }

    @Test
    void testBitOrFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.BIT_OR, VM_FENNEL, VM_JAVA);
        f.checkFails("bit_or(^*^)", "Unknown identifier '\\*'", false);
        f.checkType("bit_or(1)", "INTEGER");
        f.checkType("bit_or(CAST(2 AS TINYINT))", "TINYINT");
        f.checkType("bit_or(CAST(2 AS SMALLINT))", "SMALLINT");
        f.checkType("bit_or(distinct CAST(2 AS BIGINT))", "BIGINT");
        f.checkType("bit_or(CAST(x'02' AS BINARY(1)))", "BINARY(1)");
        f.checkFails("^bit_or(1.2)^", "Cannot apply 'BIT_OR' to arguments of type 'BIT_OR\\(<DECIMAL\\(2, 1\\)>\\)'\\. Supported form\\(s\\): 'BIT_OR\\(<INTEGER>\\)'\n'BIT_OR\\(<BINARY>\\)'", false);
        f.checkFails("^bit_or()^", "Invalid number of arguments to function 'BIT_OR'. Was expecting 1 arguments", false);
        f.checkFails("^bit_or(1, 2)^", "Invalid number of arguments to function 'BIT_OR'. Was expecting 1 arguments", false);
        String[] values = new String[]{"1", "2", "2"};
        f.checkAgg("bit_or(x)", values, ResultCheckers.isSingle(3));
        String[] binaryValues = new String[]{"CAST(x'01' AS BINARY)", "cast(x'02' as BINARY)", "cast(x'02' AS BINARY)", "cast(null AS BINARY)"};
        f.checkAgg("bit_or(x)", binaryValues, ResultCheckers.isSingle("03"));
        f.checkAgg("bit_or(x)", new String[]{"CAST(x'02' AS BINARY)"}, ResultCheckers.isSingle("02"));
    }

    @Test
    void testBitXorFunc() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.BIT_XOR, VM_FENNEL, VM_JAVA);
        f.checkFails("bit_xor(^*^)", "Unknown identifier '\\*'", false);
        f.checkType("bit_xor(1)", "INTEGER");
        f.checkType("bit_xor(CAST(2 AS TINYINT))", "TINYINT");
        f.checkType("bit_xor(CAST(2 AS SMALLINT))", "SMALLINT");
        f.checkType("bit_xor(distinct CAST(2 AS BIGINT))", "BIGINT");
        f.checkType("bit_xor(CAST(x'02' AS BINARY(1)))", "BINARY(1)");
        f.checkFails("^bit_xor(1.2)^", "Cannot apply 'BIT_XOR' to arguments of type 'BIT_XOR\\(<DECIMAL\\(2, 1\\)>\\)'\\. Supported form\\(s\\): 'BIT_XOR\\(<INTEGER>\\)'\n'BIT_XOR\\(<BINARY>\\)'", false);
        f.checkFails("^bit_xor()^", "Invalid number of arguments to function 'BIT_XOR'. Was expecting 1 arguments", false);
        f.checkFails("^bit_xor(1, 2)^", "Invalid number of arguments to function 'BIT_XOR'. Was expecting 1 arguments", false);
        String[] values = new String[]{"1", "2", "1"};
        f.checkAgg("bit_xor(x)", values, ResultCheckers.isSingle(2));
        String[] binaryValues = new String[]{"CAST(x'01' AS BINARY)", "cast(x'02' as BINARY)", "cast(x'01' AS BINARY)", "cast(null AS BINARY)"};
        f.checkAgg("bit_xor(x)", binaryValues, ResultCheckers.isSingle("02"));
        f.checkAgg("bit_xor(x)", new String[]{"CAST(x'02' AS BINARY)"}, ResultCheckers.isSingle("02"));
        f.checkAgg("bit_xor(distinct(x))", new String[]{"CAST(x'02' AS BINARY)", "CAST(x'02' AS BINARY)"}, ResultCheckers.isSingle("02"));
    }

    @Test
    void testArgMin() {
        SqlOperatorFixture f0 = this.fixture().withTester(t -> TESTER);
        String[] xValues = new String[]{"2", "3", "4", "4", "5", "7"};
        Consumer<SqlOperatorFixture> consumer = f -> {
            f.checkAgg("arg_min(mod(x, 3), x)", xValues, ResultCheckers.isSingle("2"));
            f.checkAgg("arg_max(mod(x, 3), x)", xValues, ResultCheckers.isSingle("1"));
        };
        Consumer<SqlOperatorFixture> consumer2 = f -> {
            f.checkAgg("min_by(mod(x, 3), x)", xValues, ResultCheckers.isSingle("2"));
            f.checkAgg("max_by(mod(x, 3), x)", xValues, ResultCheckers.isSingle("1"));
        };
        consumer.accept(f0);
        consumer2.accept(f0.withLibrary(SqlLibrary.SPARK));
    }

    @Test
    void testLiteralAtLimit() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CAST, SqlOperatorFixture.VmName.EXPAND);
        if (!f.brokenTestsEnabled()) {
            return;
        }
        List<RelDataType> types = SqlTests.getTypes(f.getFactory().getTypeFactory());
        for (RelDataType type : types) {
            for (Object o : this.getValues((BasicSqlType)type, true)) {
                SqlLiteral literal = type.getSqlTypeName().createLiteral(o, SqlParserPos.ZERO);
                SqlString literalString = literal.toSqlString(AnsiSqlDialect.DEFAULT);
                String expr = "CAST(" + literalString + " AS " + type + ")";
                try {
                    f.checkType(expr, type.getFullTypeString());
                    if (type.getSqlTypeName() == SqlTypeName.BINARY) continue;
                    f.checkScalar(expr + " = " + literalString, true, "BOOLEAN NOT NULL");
                }
                catch (Error | RuntimeException e) {
                    throw new RuntimeException("Failed for expr=[" + expr + "]", e);
                }
            }
        }
    }

    @Test
    void testLiteralBeyondLimit() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CAST, SqlOperatorFixture.VmName.EXPAND);
        List<RelDataType> types = SqlTests.getTypes(f.getFactory().getTypeFactory());
        for (RelDataType type : types) {
            for (Object o : this.getValues((BasicSqlType)type, false)) {
                SqlLiteral literal = type.getSqlTypeName().createLiteral(o, SqlParserPos.ZERO);
                SqlString literalString = literal.toSqlString(AnsiSqlDialect.DEFAULT);
                if (type.getSqlTypeName() == SqlTypeName.BIGINT || type.getSqlTypeName() == SqlTypeName.DECIMAL && type.getPrecision() == 19) {
                    f.checkFails("CAST(^" + literalString + "^ AS " + type + ")", "Numeric literal '.*' out of range", false);
                    continue;
                }
                if (type.getSqlTypeName() != SqlTypeName.CHAR && type.getSqlTypeName() != SqlTypeName.VARCHAR && type.getSqlTypeName() != SqlTypeName.BINARY && type.getSqlTypeName() != SqlTypeName.VARBINARY) continue;
            }
        }
    }

    @Test
    void testCastTruncates() {
        SqlOperatorFixture f = this.fixture();
        f.setFor((SqlOperator)SqlStdOperatorTable.CAST, SqlOperatorFixture.VmName.EXPAND);
        f.checkScalar("CAST('ABCD' AS CHAR(2))", "AB", "CHAR(2) NOT NULL");
        f.checkScalar("CAST('ABCD' AS VARCHAR(2))", "AB", "VARCHAR(2) NOT NULL");
        f.checkScalar("CAST('ABCD' AS VARCHAR)", "ABCD", "VARCHAR NOT NULL");
        f.checkScalar("CAST(CAST('ABCD' AS VARCHAR) AS VARCHAR(3))", "ABC", "VARCHAR(3) NOT NULL");
        f.checkScalar("CAST(x'ABCDEF12' AS BINARY(2))", "abcd", "BINARY(2) NOT NULL");
        f.checkScalar("CAST(x'ABCDEF12' AS VARBINARY(2))", "abcd", "VARBINARY(2) NOT NULL");
        f.checkScalar("CAST(x'ABCDEF12' AS VARBINARY)", "abcdef12", "VARBINARY NOT NULL");
        f.checkScalar("CAST(CAST(x'ABCDEF12' AS VARBINARY) AS VARBINARY(3))", "abcdef", "VARBINARY(3) NOT NULL");
        if (!f.brokenTestsEnabled()) {
            return;
        }
        f.checkBoolean("CAST(X'' AS BINARY(3)) = X'000000'", true);
        f.checkBoolean("CAST(X'' AS BINARY(3)) = X''", false);
    }

    @Disabled(value="Too slow and not really a unit test")
    @Tag(value="slow")
    @Test
    void testArgumentBounds() {
        SqlOperatorFixture f = this.fixture();
        SqlValidatorImpl validator = (SqlValidatorImpl)f.getFactory().createValidator();
        SqlValidatorScope scope = validator.getEmptyScope();
        RelDataTypeFactory typeFactory = validator.getTypeFactory();
        Builder builder = new Builder(typeFactory);
        builder.add0(SqlTypeName.BOOLEAN, true, false);
        builder.add0(SqlTypeName.TINYINT, 0, 1, -3, (byte)127, (byte)-128);
        builder.add0(SqlTypeName.SMALLINT, 0, 1, -4, (short)Short.MAX_VALUE, (short)Short.MIN_VALUE);
        builder.add0(SqlTypeName.INTEGER, 0, 1, -2, Integer.MIN_VALUE, Integer.MAX_VALUE);
        builder.add0(SqlTypeName.BIGINT, 0, 1, -5, Integer.MAX_VALUE, Long.MAX_VALUE, Long.MIN_VALUE);
        builder.add1(SqlTypeName.VARCHAR, 11, "", " ", "hello world");
        builder.add1(SqlTypeName.CHAR, 5, "", "e", "hello");
        builder.add0(SqlTypeName.TIMESTAMP, 0L, 86400000L);
        HashSet<Object> operatorsToSkip = new HashSet<Object>();
        operatorsToSkip.add(SqlStdOperatorTable.JSON_VALUE);
        operatorsToSkip.add(SqlStdOperatorTable.JSON_QUERY);
        operatorsToSkip.add(SqlStdOperatorTable.WITHIN_GROUP);
        operatorsToSkip.add(SqlStdOperatorTable.TRIM);
        operatorsToSkip.add(SqlStdOperatorTable.EXISTS);
        for (SqlOperator op : SqlStdOperatorTable.instance().getOperatorList()) {
            SqlOperandTypeChecker typeChecker;
            if (operatorsToSkip.contains(op) || op.getSyntax() == SqlSyntax.SPECIAL || (typeChecker = op.getOperandTypeChecker()) == null) continue;
            SqlOperandCountRange range = typeChecker.getOperandCountRange();
            int max = range.getMax();
            for (int n = range.getMin(); n <= max; ++n) {
                List<List<ValueType>> argValues = Collections.nCopies(n, builder.values);
                for (List args : Linq4j.product(argValues)) {
                    SqlNodeList nodeList = new SqlNodeList(SqlParserPos.ZERO);
                    int nullCount = 0;
                    for (ValueType arg : args) {
                        if (arg.value == null) {
                            ++nullCount;
                        }
                        nodeList.add(arg.node);
                    }
                    SqlCall call = op.createCall(nodeList);
                    SqlCallBinding binding = new SqlCallBinding((SqlValidator)validator, scope, call);
                    if (!typeChecker.checkOperandTypes(binding, false)) continue;
                    SqlPrettyWriter writer = new SqlPrettyWriter();
                    op.unparse((SqlWriter)writer, call, 0, 0);
                    String s = writer.toSqlString().toString();
                    if (s.startsWith("OVERLAY(") || s.contains(" / 0") || s.matches("MOD\\(.*, 0\\)")) continue;
                    Strong.Policy policy = Strong.policy((SqlOperator)op);
                    try {
                        if (nullCount > 0 && policy == Strong.Policy.ANY) {
                            f.checkNull(s);
                            continue;
                        }
                        String query = op instanceof SqlAggFunction ? (op.requiresOrder() ? "SELECT " + s + " OVER () FROM (VALUES (1))" : "SELECT " + s + " FROM (VALUES (1))") : AbstractSqlTester.buildQuery(s);
                        f.check(query, SqlTests.ANY_TYPE_CHECKER, SqlTests.ANY_PARAMETER_CHECKER, result -> {});
                    }
                    catch (Throwable e) {
                        Throwable cause = this.findMostDescriptiveCause(e);
                        LOGGER.info("Failed: " + s + ": " + cause);
                    }
                }
            }
        }
    }

    private Throwable findMostDescriptiveCause(Throwable ex) {
        if (ex instanceof CalciteException || ex instanceof CalciteContextException || ex instanceof SqlParseException) {
            return ex;
        }
        Throwable cause = ex.getCause();
        if (cause != null) {
            return this.findMostDescriptiveCause(cause);
        }
        return ex;
    }

    private List<Object> getValues(BasicSqlType type, boolean inBound) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (boolean sign : FALSE_TRUE) {
            for (SqlTypeName.Limit limit : SqlTypeName.Limit.values()) {
                Object o = type.getLimit(sign, limit, !inBound);
                if (o == null || values.contains(o)) continue;
                values.add(o);
            }
        }
        return values;
    }

    static {
        CURRENT_TZ = LOCAL_TZ = TimeZone.getDefault();
        INVALID_ARG_FOR_POWER = Pattern.compile("(?s).*Invalid argument\\(s\\) for 'POWER' function.*");
        CODE_2201F = Pattern.compile("(?s).*could not calculate results for the following row.*PC=5 Code=2201F.*");
        DOUBLER = new UnaryOperator<String>(){
            final Pattern pattern = Pattern.compile("(.)");

            @Override
            public String apply(String s) {
                return this.pattern.matcher(s).replaceAll("$1$1");
            }
        };
    }

    public static class CustomTimeFrameTypeSystem
    extends DelegatingTypeSystem {
        public static final TryThreadLocal<RelDataTypeSystem> DELEGATE = TryThreadLocal.of((Object)DEFAULT);

        public CustomTimeFrameTypeSystem() {
            super((RelDataTypeSystem)DELEGATE.get());
        }
    }

    static class OverlapChecker {
        final SqlOperatorFixture f;
        final String[] values;

        OverlapChecker(SqlOperatorFixture f, String ... values) {
            this.f = f;
            this.values = values;
        }

        public void isTrue(String s) {
            this.f.checkBoolean(this.sub(s), true);
        }

        public void isFalse(String s) {
            this.f.checkBoolean(this.sub(s), false);
        }

        private String sub(String s) {
            return s.replace("$0", this.values[0]).replace("$1", this.values[1]).replace("$2", this.values[2]).replace("$3", this.values[3]);
        }
    }

    static class Builder {
        final RelDataTypeFactory typeFactory;
        final List<RelDataType> types = new ArrayList<RelDataType>();
        final List<ValueType> values = new ArrayList<ValueType>();

        Builder(RelDataTypeFactory typeFactory) {
            this.typeFactory = typeFactory;
        }

        public void add0(SqlTypeName typeName, Object ... values) {
            this.add(this.typeFactory.createSqlType(typeName), values);
        }

        public void add1(SqlTypeName typeName, int precision, Object ... values) {
            this.add(this.typeFactory.createSqlType(typeName, precision), values);
        }

        private void add(RelDataType type, Object[] values) {
            this.types.add(type);
            for (Object value : values) {
                this.values.add(new ValueType(type, value));
            }
            this.values.add(new ValueType(type, null));
        }
    }

    static class ValueType {
        final RelDataType type;
        final Object value;
        final SqlNode node;

        ValueType(RelDataType type, Object value) {
            this.type = type;
            this.value = value;
            this.node = this.literal(type, value);
        }

        private SqlNode literal(RelDataType type, Object value) {
            if (value == null) {
                return SqlStdOperatorTable.CAST.createCall(SqlParserPos.ZERO, new SqlNode[]{SqlLiteral.createNull((SqlParserPos)SqlParserPos.ZERO), SqlTypeUtil.convertTypeToSpec((RelDataType)type)});
            }
            switch (type.getSqlTypeName()) {
                case BOOLEAN: {
                    return SqlLiteral.createBoolean((boolean)((Boolean)value), (SqlParserPos)SqlParserPos.ZERO);
                }
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case BIGINT: {
                    return SqlLiteral.createExactNumeric((String)value.toString(), (SqlParserPos)SqlParserPos.ZERO);
                }
                case CHAR: 
                case VARCHAR: {
                    return SqlLiteral.createCharString((String)value.toString(), (SqlParserPos)SqlParserPos.ZERO);
                }
                case TIMESTAMP: {
                    TimestampString ts = TimestampString.fromMillisSinceEpoch((long)((Long)value));
                    return SqlLiteral.createTimestamp((SqlTypeName)type.getSqlTypeName(), (TimestampString)ts, (int)type.getPrecision(), (SqlParserPos)SqlParserPos.ZERO);
                }
            }
            throw new AssertionError(type);
        }
    }

    protected static class TesterImpl
    extends SqlRuntimeTester {
        @Override
        public void check(SqlTestFactory factory, String query, SqlTester.TypeChecker typeChecker, SqlTester.ParameterChecker parameterChecker, SqlTester.ResultChecker resultChecker) {
            super.check(factory, query, typeChecker, parameterChecker, resultChecker);
            RelDataTypeSystem typeSystem = (RelDataTypeSystem)factory.typeSystemTransform.apply(RelDataTypeSystem.DEFAULT);
            ConnectionFactory connectionFactory = factory.connectionFactory.with((ConnectionProperty)CalciteConnectionProperty.TYPE_SYSTEM, (Object)CustomTimeFrameTypeSystem.class.getName());
            try (TryThreadLocal.Memo ignore = CustomTimeFrameTypeSystem.DELEGATE.push((Object)typeSystem);
                 Connection connection = connectionFactory.createConnection();
                 Statement statement = connection.createStatement();){
                ResultSet resultSet = statement.executeQuery(query);
                resultChecker.checkResult(resultSet);
            }
            catch (Exception e) {
                throw TestUtil.rethrow(e);
            }
        }
    }

    private static class ValueOrExceptionResultChecker
    implements SqlTester.ResultChecker {
        private final Object expected;
        private final Pattern[] patterns;

        ValueOrExceptionResultChecker(Object expected, Pattern ... patterns) {
            this.expected = expected;
            this.patterns = patterns;
        }

        @Override
        public void checkResult(ResultSet result) throws Exception {
            SQLException thrown = null;
            try {
                if (!result.next()) {
                    return;
                }
                Object actual = result.getObject(1);
                Assertions.assertEquals((Object)this.expected, (Object)actual);
            }
            catch (SQLException e) {
                thrown = e;
            }
            if (thrown != null) {
                String stack = Throwables.getStackTraceAsString((Throwable)thrown);
                for (Pattern pattern : this.patterns) {
                    if (!pattern.matcher(stack).matches()) continue;
                    return;
                }
                Assertions.fail((String)("Stack did not match any pattern; " + stack));
            }
        }
    }

    static class SubFunChecker {
        final SqlOperatorFixture f;
        final SqlLibrary library;
        final SqlFunction function;

        SubFunChecker(SqlOperatorFixture f, SqlLibrary library, SqlFunction function) {
            this.f = f;
            f.setFor((SqlOperator)function, new SqlOperatorFixture.VmName[0]);
            this.library = library;
            this.function = function;
        }

        void check() {
            this.assertReturns("abc", 1, "abc");
            this.assertReturns("abc", 2, "bc");
            this.assertReturns("abc", 3, "c");
            this.assertReturns("abc", 4, "");
            this.assertReturns("abc", 5, "");
            switch (this.library) {
                case BIG_QUERY: 
                case ORACLE: {
                    this.assertReturns("abc", 0, "abc");
                    this.assertReturns("abc", 0, 5, "abc");
                    this.assertReturns("abc", 0, 4, "abc");
                    this.assertReturns("abc", 0, 3, "abc");
                    this.assertReturns("abc", 0, 2, "ab");
                    break;
                }
                case POSTGRESQL: {
                    this.assertReturns("abc", 0, "abc");
                    this.assertReturns("abc", 0, 5, "abc");
                    this.assertReturns("abc", 0, 4, "abc");
                    this.assertReturns("abc", 0, 3, "ab");
                    this.assertReturns("abc", 0, 2, "a");
                    break;
                }
                case MYSQL: {
                    this.assertReturns("abc", 0, "");
                    this.assertReturns("abc", 0, 5, "");
                    this.assertReturns("abc", 0, 4, "");
                    this.assertReturns("abc", 0, 3, "");
                    this.assertReturns("abc", 0, 2, "");
                    break;
                }
                default: {
                    throw new AssertionError(this.library);
                }
            }
            this.assertReturns("abc", 0, 0, "");
            this.assertReturns("abc", 2, 8, "bc");
            this.assertReturns("abc", 1, 0, "");
            this.assertReturns("abc", 1, 2, "ab");
            this.assertReturns("abc", 1, 3, "abc");
            this.assertReturns("abc", 4, 3, "");
            this.assertReturns("abc", 4, 4, "");
            this.assertReturns("abc", 8, 2, "");
            switch (this.library) {
                case POSTGRESQL: {
                    this.assertReturns("abc", 1, -1, null);
                    this.assertReturns("abc", 4, -1, null);
                    break;
                }
                default: {
                    this.assertReturns("abc", 1, -1, "");
                    this.assertReturns("abc", 4, -1, "");
                }
            }
            switch (this.library) {
                case BIG_QUERY: 
                case ORACLE: 
                case MYSQL: {
                    this.assertReturns("abc", -2, "bc");
                    this.assertReturns("abc", -1, "c");
                    this.assertReturns("abc", -2, 1, "b");
                    this.assertReturns("abc", -2, 2, "bc");
                    this.assertReturns("abc", -2, 3, "bc");
                    this.assertReturns("abc", -2, 4, "bc");
                    this.assertReturns("abc", -2, 5, "bc");
                    this.assertReturns("abc", -2, 6, "bc");
                    this.assertReturns("abc", -2, 7, "bc");
                    this.assertReturns("abcde", -3, 2, "cd");
                    this.assertReturns("abc", -3, 3, "abc");
                    this.assertReturns("abc", -3, 8, "abc");
                    this.assertReturns("abc", -1, 4, "c");
                    break;
                }
                case POSTGRESQL: {
                    this.assertReturns("abc", -2, "abc");
                    this.assertReturns("abc", -1, "abc");
                    this.assertReturns("abc", -2, 1, "");
                    this.assertReturns("abc", -2, 2, "");
                    this.assertReturns("abc", -2, 3, "");
                    this.assertReturns("abc", -2, 4, "a");
                    this.assertReturns("abc", -2, 5, "ab");
                    this.assertReturns("abc", -2, 6, "abc");
                    this.assertReturns("abc", -2, 7, "abc");
                    this.assertReturns("abcde", -3, 2, "");
                    this.assertReturns("abc", -3, 3, "");
                    this.assertReturns("abc", -3, 8, "abc");
                    this.assertReturns("abc", -1, 4, "ab");
                    break;
                }
                default: {
                    throw new AssertionError(this.library);
                }
            }
            switch (this.library) {
                case BIG_QUERY: {
                    this.assertReturns("abc", -4, 6, "abc");
                    break;
                }
                case ORACLE: 
                case MYSQL: {
                    this.assertReturns("abc", -4, 6, "");
                    break;
                }
                case POSTGRESQL: {
                    this.assertReturns("abc", -4, 6, "a");
                    break;
                }
                default: {
                    throw new AssertionError(this.library);
                }
            }
            switch (this.library) {
                case BIG_QUERY: {
                    this.assertReturns("abc", -4, 3, "abc");
                    this.assertReturns("abc", -5, 1, "abc");
                    this.assertReturns("abc", -10, 2, "abc");
                    this.assertReturns("abc", -500, 1, "abc");
                    break;
                }
                case ORACLE: 
                case POSTGRESQL: 
                case MYSQL: {
                    this.assertReturns("abc", -4, 3, "");
                    this.assertReturns("abc", -5, 1, "");
                    this.assertReturns("abc", -10, 2, "");
                    this.assertReturns("abc", -500, 1, "");
                    break;
                }
                default: {
                    throw new AssertionError(this.library);
                }
            }
        }

        void assertReturns(String s, int start, String expected) {
            this.assertSubFunReturns(false, s, start, null, expected);
            this.assertSubFunReturns(true, s, start, null, expected);
        }

        void assertReturns(String s, int start, @Nullable Integer end, @Nullable String expected) {
            this.assertSubFunReturns(false, s, start, end, expected);
            this.assertSubFunReturns(true, s, start, end, expected);
        }

        void assertSubFunReturns(boolean binary, String s, int start, @Nullable Integer end, @Nullable String expected) {
            String v = binary ? "x'" + (String)DOUBLER.apply(s) + "'" : "'" + s + "'";
            String type = (binary ? "VARBINARY" : "VARCHAR") + "(" + s.length() + ")";
            String value = "CAST(" + v + " AS " + type + ")";
            String expression = this.function == SqlStdOperatorTable.SUBSTRING ? "substring(" + value + " FROM " + start + (end == null ? "" : " FOR " + end) + ")" : "substr(" + value + ", " + start + (end == null ? "" : ", " + end) + ")";
            if (expected == null) {
                this.f.checkFails(expression, "Substring error: negative substring length not allowed", true);
            } else {
                if (binary) {
                    expected = (String)DOUBLER.apply(expected);
                }
                this.f.checkString(expression, expected, type + " NOT NULL");
            }
        }
    }

    static enum Numeric {
        TINYINT("TINYINT", Long.toString(-128L), Long.toString(-129L), Long.toString(127L), Long.toString(128L)),
        SMALLINT("SMALLINT", Long.toString(-32768L), Long.toString(-32769L), Long.toString(32767L), Long.toString(32768L)),
        INTEGER("INTEGER", Long.toString(Integer.MIN_VALUE), Long.toString(-2147483649L), Long.toString(Integer.MAX_VALUE), Long.toString(0x80000000L)),
        BIGINT("BIGINT", Long.toString(Long.MIN_VALUE), new BigDecimal(Long.MIN_VALUE).subtract(BigDecimal.ONE).toString(), Long.toString(Long.MAX_VALUE), new BigDecimal(Long.MAX_VALUE).add(BigDecimal.ONE).toString()),
        DECIMAL5_2("DECIMAL(5, 2)", "-999.99", "-1000.00", "999.99", "1000.00"),
        REAL("REAL", "1E-37", "1e-46", "3.4028234E38", "1e39"),
        FLOAT("FLOAT", "2E-307", "1e-324", "1.79769313486231E308", "-1e309"),
        DOUBLE("DOUBLE", "2E-307", "1e-324", "1.79769313486231E308", "1e309");

        private final String typeName;
        private final String minNumericString;
        private final String minOverflowNumericString;
        private final String maxNumericString;
        private final String maxOverflowNumericString;

        private Numeric(String typeName, String minNumericString, String minOverflowNumericString, String maxNumericString, String maxOverflowNumericString) {
            this.typeName = typeName;
            this.minNumericString = minNumericString;
            this.minOverflowNumericString = minOverflowNumericString;
            this.maxNumericString = maxNumericString;
            this.maxOverflowNumericString = maxOverflowNumericString;
        }

        static void forEach(Consumer<Numeric> consumer) {
            consumer.accept(TINYINT);
            consumer.accept(SMALLINT);
            consumer.accept(INTEGER);
            consumer.accept(BIGINT);
            consumer.accept(DECIMAL5_2);
            consumer.accept(REAL);
            consumer.accept(FLOAT);
            consumer.accept(DOUBLE);
        }

        double maxNumericAsDouble() {
            return Double.parseDouble(this.maxNumericString);
        }

        double minNumericAsDouble() {
            return Double.parseDouble(this.minNumericString);
        }
    }
}

