/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test.catalog;

import java.util.Arrays;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeComparability;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.ObjectSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.test.catalog.AbstractFixture;

final class Fixture
extends AbstractFixture {
    final RelDataType intType = this.sqlType(SqlTypeName.INTEGER, new int[0]);
    final RelDataType intTypeNull = this.nullable(this.intType);
    final RelDataType bigintType = this.sqlType(SqlTypeName.BIGINT, new int[0]);
    final RelDataType decimalType = this.sqlType(SqlTypeName.DECIMAL, new int[0]);
    final RelDataType varcharType = this.sqlType(SqlTypeName.VARCHAR, new int[0]);
    final RelDataType varcharTypeNull = this.nullable(this.varcharType);
    final RelDataType varchar5Type = this.sqlType(SqlTypeName.VARCHAR, 5);
    final RelDataType varchar10Type = this.sqlType(SqlTypeName.VARCHAR, 10);
    final RelDataType varchar10TypeNull = this.nullable(this.varchar10Type);
    final RelDataType varchar20Type = this.sqlType(SqlTypeName.VARCHAR, 20);
    final RelDataType varchar20TypeNull = this.nullable(this.varchar20Type);
    final RelDataType timestampType = this.sqlType(SqlTypeName.TIMESTAMP, new int[0]);
    final RelDataType timestampTypeNull = this.nullable(this.timestampType);
    final RelDataType dateType = this.sqlType(SqlTypeName.DATE, new int[0]);
    final RelDataType booleanType = this.sqlType(SqlTypeName.BOOLEAN, new int[0]);
    final RelDataType booleanTypeNull = this.nullable(this.booleanType);
    final RelDataType rectilinearCoordType = this.typeFactory.builder().add("X", this.intType).add("Y", this.intType).build();
    final RelDataType rectilinearPeekCoordType = this.typeFactory.builder().add("X", this.intType).add("Y", this.intType).add("unit", this.varchar20Type).kind(StructKind.PEEK_FIELDS).build();
    final RelDataType rectilinearPeekCoordMultisetType = this.typeFactory.createMultisetType(this.rectilinearPeekCoordType, -1L);
    final RelDataType rectilinearPeekNoExpandCoordType = this.typeFactory.builder().add("M", this.intType).add("SUB", this.typeFactory.builder().add("A", this.intType).add("B", this.intType).kind(StructKind.PEEK_FIELDS_NO_EXPAND).build()).kind(StructKind.PEEK_FIELDS_NO_EXPAND).build();
    final RelDataType abRecordType = this.typeFactory.builder().add("A", this.varchar10Type).add("B", this.varchar10Type).build();
    final RelDataType skillRecordType = this.typeFactory.builder().add("TYPE", this.varchar10Type).add("DESC", this.varchar20Type).add("OTHERS", this.abRecordType).build();
    final RelDataType empRecordType = this.typeFactory.builder().add("EMPNO", this.intType).add("ENAME", this.varchar10Type).add("DETAIL", this.typeFactory.builder().add("SKILLS", this.array(this.skillRecordType)).build()).kind(StructKind.PEEK_FIELDS).build();
    final RelDataType empListType = this.array(this.empRecordType);
    final ObjectSqlType addressType = new ObjectSqlType(SqlTypeName.STRUCTURED, new SqlIdentifier("ADDRESS", SqlParserPos.ZERO), false, Arrays.asList(new RelDataTypeFieldImpl("STREET", 0, this.varchar20Type), new RelDataTypeFieldImpl("CITY", 1, this.varchar20Type), new RelDataTypeFieldImpl("ZIP", 2, this.intType), new RelDataTypeFieldImpl("STATE", 3, this.varchar20Type)), RelDataTypeComparability.NONE);
    final RelDataType recordType1 = this.typeFactory.createStructType(Arrays.asList(this.intType, this.varcharType), Arrays.asList("f0", "f1"));
    final RelDataType recordType2 = this.typeFactory.createStructType(Arrays.asList(this.intType, this.nullable(this.varcharType)), Arrays.asList("f0", "f1"));
    final RelDataType recordType3 = this.typeFactory.createStructType(Arrays.asList(this.nullable(this.typeFactory.createStructType(Arrays.asList(this.intType, this.varcharTypeNull), Arrays.asList("ff0", "ff1"))), this.timestampType), Arrays.asList("f0", "f1"));
    final RelDataType recordType4 = this.array(this.typeFactory.createStructType(Arrays.asList(this.bigintType, this.nullable(this.decimalType)), Arrays.asList("f0", "f1")));
    final RelDataType recordType5 = this.typeFactory.createMultisetType(this.typeFactory.createStructType(Arrays.asList(this.varcharType, this.timestampTypeNull), Arrays.asList("f0", "f1")), -1L);
    final RelDataType intArrayType = this.array(this.intType);
    final RelDataType varchar5ArrayType = this.array(this.varchar5Type);
    final RelDataType intArrayArrayType = this.array(this.intArrayType);
    final RelDataType varchar5ArrayArrayType = this.array(this.varchar5ArrayType);
    final RelDataType intMultisetType = this.typeFactory.createMultisetType(this.intType, -1L);
    final RelDataType varchar5MultisetType = this.typeFactory.createMultisetType(this.varchar5Type, -1L);
    final RelDataType intMultisetArrayType = this.array(this.intMultisetType);
    final RelDataType varchar5MultisetArrayType = this.array(this.varchar5MultisetType);
    final RelDataType intArrayMultisetType = this.typeFactory.createMultisetType(this.intArrayType, -1L);
    final RelDataType rowArrayMultisetType = this.typeFactory.createMultisetType(this.array(this.typeFactory.createStructType(Arrays.asList(this.intArrayMultisetType, this.varchar5ArrayType), Arrays.asList("f0", "f1"))), -1L);

    Fixture(RelDataTypeFactory typeFactory) {
        super(typeFactory);
    }

    private RelDataType nullable(RelDataType type) {
        return this.typeFactory.createTypeWithNullability(type, true);
    }

    private RelDataType sqlType(SqlTypeName typeName, int ... args) {
        assert (args.length < 3) : "unknown size of additional int args";
        return args.length == 2 ? this.typeFactory.createSqlType(typeName, args[0], args[1]) : (args.length == 1 ? this.typeFactory.createSqlType(typeName, args[0]) : this.typeFactory.createSqlType(typeName));
    }

    private RelDataType array(RelDataType type) {
        return this.typeFactory.createArrayType(type, -1L);
    }
}

