/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.test.SqlTestFactory;
import org.apache.calcite.sql.test.SqlTester;
import org.apache.calcite.sql.test.SqlValidatorTester;
import org.apache.calcite.sql.util.SqlOperatorTables;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.test.DiffRepository;
import org.apache.calcite.test.catalog.MockCatalogReaderDynamic;
import org.apache.calcite.test.catalog.MockCatalogReaderExtended;
import org.apache.calcite.util.TestUtil;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class SqlToRelFixture {
    public static final SqlTester TESTER = SqlValidatorTester.DEFAULT;
    public static final SqlToRelFixture DEFAULT = new SqlToRelFixture("?", true, TESTER, SqlTestFactory.INSTANCE, false, false, null).withFactory(f -> f.withValidator((opTab, catalogReader, typeFactory, config) -> {
        if (config.conformance().allowGeometry()) {
            opTab = SqlOperatorTables.chain((SqlOperatorTable[])new SqlOperatorTable[]{opTab, SqlOperatorTables.spatialInstance()});
        }
        return SqlValidatorUtil.newValidator((SqlOperatorTable)opTab, (SqlValidatorCatalogReader)catalogReader, (RelDataTypeFactory)typeFactory, (SqlValidator.Config)config.withIdentifierExpansion(true));
    }).withSqlToRelConfig(c -> c.withTrimUnusedFields(true).withExpand(true).addRelBuilderConfigTransform(b -> b.withAggregateUnique(true).withPruneInputOfAggregate(false))));
    private final String sql;
    private final @Nullable DiffRepository diffRepos;
    private final boolean decorrelate;
    private final SqlTester tester;
    private final SqlTestFactory factory;
    private final boolean trim;
    private final boolean expression;

    SqlToRelFixture(String sql, boolean decorrelate, SqlTester tester, SqlTestFactory factory, boolean trim, boolean expression, @Nullable DiffRepository diffRepos) {
        this.sql = Objects.requireNonNull(sql, "sql");
        this.tester = Objects.requireNonNull(tester, "tester");
        this.factory = Objects.requireNonNull(factory, "factory");
        this.diffRepos = diffRepos;
        if (sql.contains(" \n")) {
            throw new AssertionError((Object)"trailing whitespace");
        }
        this.decorrelate = decorrelate;
        this.trim = trim;
        this.expression = expression;
    }

    public void ok() {
        this.convertsTo("${plan}");
    }

    public void throws_(String message) {
        try {
            this.ok();
        }
        catch (Throwable throwable) {
            MatcherAssert.assertThat((Object)TestUtil.printStackTrace(throwable), (Matcher)CoreMatchers.containsString((String)message));
        }
    }

    public void convertsTo(String plan) {
        this.tester.assertConvertsTo(this.factory, this.diffRepos(), this.sql, plan, this.trim, this.expression, this.decorrelate);
    }

    public DiffRepository diffRepos() {
        return DiffRepository.castNonNull(this.diffRepos);
    }

    public SqlToRelFixture withSql(String sql) {
        return sql.equals(this.sql) ? this : new SqlToRelFixture(sql, this.decorrelate, this.tester, this.factory, this.trim, this.expression, this.diffRepos);
    }

    public SqlToRelFixture expression(boolean expression) {
        return this.expression == expression ? this : new SqlToRelFixture(this.sql, this.decorrelate, this.tester, this.factory, this.trim, expression, this.diffRepos);
    }

    public SqlToRelFixture withConfig(UnaryOperator<SqlToRelConverter.Config> transform) {
        return this.withFactory(f -> f.withSqlToRelConfig(transform));
    }

    public SqlToRelFixture withExpand(boolean expand) {
        return this.withConfig(b -> b.withExpand(expand));
    }

    public SqlToRelFixture withDecorrelate(boolean decorrelate) {
        return new SqlToRelFixture(this.sql, decorrelate, this.tester, this.factory, this.trim, this.expression, this.diffRepos);
    }

    public SqlToRelFixture withFactory(UnaryOperator<SqlTestFactory> transform) {
        SqlTestFactory factory = (SqlTestFactory)transform.apply(this.factory);
        if (factory == this.factory) {
            return this;
        }
        return new SqlToRelFixture(this.sql, this.decorrelate, this.tester, factory, this.trim, this.expression, this.diffRepos);
    }

    public SqlToRelFixture withCatalogReader(SqlTestFactory.CatalogReaderFactory catalogReaderFactory) {
        return this.withFactory(f -> f.withCatalogReader(catalogReaderFactory));
    }

    public SqlToRelFixture withExtendedTester() {
        return this.withCatalogReader(MockCatalogReaderExtended::create);
    }

    public SqlToRelFixture withDynamicTable() {
        return this.withCatalogReader(MockCatalogReaderDynamic::create);
    }

    public SqlToRelFixture withTrim(boolean trim) {
        return new SqlToRelFixture(this.sql, this.decorrelate, this.tester, this.factory, trim, this.expression, this.diffRepos);
    }

    public SqlConformance getConformance() {
        return this.factory.parserConfig().conformance();
    }

    public SqlToRelFixture withConformance(SqlConformance conformance) {
        return this.withFactory(f -> f.withParserConfig(c -> c.withConformance(conformance)).withValidatorConfig(c -> c.withConformance(conformance)));
    }

    public SqlToRelFixture withDiffRepos(DiffRepository diffRepos) {
        return new SqlToRelFixture(this.sql, this.decorrelate, this.tester, this.factory, this.trim, this.expression, diffRepos);
    }

    public RelRoot toRoot() {
        return this.tester.convertSqlToRel(this.factory, this.sql, this.decorrelate, this.trim);
    }

    public RelNode toRel() {
        return this.toRoot().rel;
    }

    public SqlToRelFixture ensuring(Predicate<SqlToRelFixture> predicate, UnaryOperator<SqlToRelFixture> remedy) {
        SqlToRelFixture f = this;
        if (!predicate.test(f)) {
            f = (SqlToRelFixture)remedy.apply(f);
            MatcherAssert.assertThat((String)"remedy failed", (Object)predicate.test(f), (Matcher)CoreMatchers.is((Object)true));
        }
        return f;
    }
}

