/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.test;

import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.sql.test.SqlTester;
import org.apache.calcite.test.Matchers;
import org.apache.calcite.util.ImmutableNullableSet;
import org.apache.calcite.util.JdbcType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;

public class ResultCheckers {
    private ResultCheckers() {
    }

    public static SqlTester.ResultChecker isExactly(double value) {
        return new MatcherResultChecker(CoreMatchers.is((Object)value), JdbcType.DOUBLE);
    }

    public static SqlTester.ResultChecker isExactly(String value) {
        return new MatcherResultChecker(CoreMatchers.is((Object)new BigDecimal(value)), JdbcType.BIG_DECIMAL);
    }

    public static SqlTester.ResultChecker isExactDateTime(LocalDateTime dateTime) {
        return new MatcherResultChecker(CoreMatchers.is((Object)BigDecimal.valueOf(dateTime.toInstant(ZoneOffset.UTC).toEpochMilli())), JdbcType.BIG_DECIMAL);
    }

    public static SqlTester.ResultChecker isExactTime(LocalTime time) {
        return new MatcherResultChecker(CoreMatchers.is((Object)((int)(time.toNanoOfDay() / 1000000L))), JdbcType.INTEGER);
    }

    public static SqlTester.ResultChecker isWithin(double value, double delta) {
        return new MatcherResultChecker<Double>(Matchers.within(value, delta), JdbcType.DOUBLE);
    }

    public static SqlTester.ResultChecker isSingle(double delta, String value) {
        assert (delta == 0.0);
        return ResultCheckers.isSingle(value);
    }

    public static SqlTester.ResultChecker isSingle(String value) {
        return new MatcherResultChecker(CoreMatchers.is((Object)value), JdbcType.STRING_NULLABLE);
    }

    public static SqlTester.ResultChecker isSingle(boolean value) {
        return new MatcherResultChecker(CoreMatchers.is((Object)value), JdbcType.BOOLEAN);
    }

    public static SqlTester.ResultChecker isSingle(int value) {
        return new MatcherResultChecker(CoreMatchers.is((Object)value), JdbcType.INTEGER);
    }

    public static SqlTester.ResultChecker isDecimal(String value) {
        return new MatcherResultChecker(CoreMatchers.is((Object)new BigDecimal(value)), JdbcType.BIG_DECIMAL);
    }

    public static SqlTester.ResultChecker isSet(String ... values) {
        return new RefSetResultChecker((Set<String>)ImmutableSet.copyOf((Object[])values));
    }

    public static SqlTester.ResultChecker isNullValue() {
        return new RefSetResultChecker(Collections.singleton(null));
    }

    static void compareResultSet(String sql, ResultSet resultSet, Set<String> refSet) throws Exception {
        HashSet<String> actualSet = new HashSet<String>();
        int columnType = resultSet.getMetaData().getColumnType(1);
        ColumnMetaData.Rep rep = ResultCheckers.rep(columnType);
        String msg = "Query: " + sql;
        while (resultSet.next()) {
            String s = resultSet.getString(1);
            String s0 = s == null ? "0" : s;
            boolean wasNull0 = resultSet.wasNull();
            actualSet.add(s);
            switch (rep) {
                case BOOLEAN: 
                case PRIMITIVE_BOOLEAN: {
                    MatcherAssert.assertThat((String)msg, (Object)resultSet.getBoolean(1), (Matcher)CoreMatchers.equalTo((Object)Boolean.valueOf(s)));
                    break;
                }
                case BYTE: 
                case PRIMITIVE_BYTE: 
                case SHORT: 
                case PRIMITIVE_SHORT: 
                case INTEGER: 
                case PRIMITIVE_INT: 
                case LONG: 
                case PRIMITIVE_LONG: {
                    long l;
                    try {
                        l = Long.parseLong(s0);
                    }
                    catch (NumberFormatException e) {
                        l = (long)Double.parseDouble(s0);
                    }
                    MatcherAssert.assertThat((String)msg, (Object)resultSet.getByte(1), (Matcher)CoreMatchers.equalTo((Object)((byte)l)));
                    MatcherAssert.assertThat((String)msg, (Object)resultSet.getShort(1), (Matcher)CoreMatchers.equalTo((Object)((short)l)));
                    MatcherAssert.assertThat((String)msg, (Object)resultSet.getInt(1), (Matcher)CoreMatchers.equalTo((Object)((int)l)));
                    MatcherAssert.assertThat((String)msg, (Object)resultSet.getLong(1), (Matcher)CoreMatchers.equalTo((Object)l));
                    break;
                }
                case FLOAT: 
                case PRIMITIVE_FLOAT: 
                case DOUBLE: 
                case PRIMITIVE_DOUBLE: {
                    double d = Double.parseDouble(s0);
                    MatcherAssert.assertThat((String)msg, (Object)Float.valueOf(resultSet.getFloat(1)), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf((float)d)));
                    MatcherAssert.assertThat((String)msg, (Object)resultSet.getDouble(1), (Matcher)CoreMatchers.equalTo((Object)d));
                    break;
                }
            }
            boolean wasNull1 = resultSet.wasNull();
            Object object = resultSet.getObject(1);
            boolean wasNull2 = resultSet.wasNull();
            MatcherAssert.assertThat((String)msg, (Object)(object == null ? 1 : 0), (Matcher)CoreMatchers.equalTo((Object)wasNull0));
            MatcherAssert.assertThat((String)msg, (Object)wasNull1, (Matcher)CoreMatchers.equalTo((Object)wasNull0));
            MatcherAssert.assertThat((String)msg, (Object)wasNull2, (Matcher)CoreMatchers.equalTo((Object)wasNull0));
        }
        resultSet.close();
        Assertions.assertEquals(refSet, actualSet, (String)msg);
    }

    private static ColumnMetaData.Rep rep(int columnType) {
        switch (columnType) {
            case 16: {
                return ColumnMetaData.Rep.BOOLEAN;
            }
            case -6: {
                return ColumnMetaData.Rep.BYTE;
            }
            case 5: {
                return ColumnMetaData.Rep.SHORT;
            }
            case 4: {
                return ColumnMetaData.Rep.INTEGER;
            }
            case -5: {
                return ColumnMetaData.Rep.LONG;
            }
            case 7: {
                return ColumnMetaData.Rep.FLOAT;
            }
            case 8: {
                return ColumnMetaData.Rep.DOUBLE;
            }
            case 92: {
                return ColumnMetaData.Rep.JAVA_SQL_TIME;
            }
            case 93: {
                return ColumnMetaData.Rep.JAVA_SQL_TIMESTAMP;
            }
            case 91: {
                return ColumnMetaData.Rep.JAVA_SQL_DATE;
            }
        }
        return ColumnMetaData.Rep.OBJECT;
    }

    static void compareResultSetWithPattern(String sql, ResultSet resultSet, Pattern pattern) throws Exception {
        if (!resultSet.next()) {
            Assertions.fail((String)("Query \"" + sql + "\"returned 0 rows, expected 1"));
        }
        String actual = resultSet.getString(1);
        if (resultSet.next()) {
            Assertions.fail((String)("Query \"" + sql + "\"returned 2 or more rows, expected 1"));
        }
        if (!pattern.matcher(actual).matches()) {
            Assertions.fail((String)("Query \"" + sql + "\"returned '" + actual + "', expected '" + pattern.pattern() + "'"));
        }
    }

    static <T> void compareResultSetWithMatcher(String sql, ResultSet resultSet, JdbcType<T> jdbcType, Matcher<T> matcher) throws Exception {
        if (!resultSet.next()) {
            Assertions.fail((String)"Query returned 0 rows, expected 1");
        }
        Object actual = jdbcType.get(1, resultSet);
        if (resultSet.next()) {
            Assertions.fail((String)"Query returned 2 or more rows, expected 1");
        }
        MatcherAssert.assertThat((String)("Query: " + sql), (Object)actual, matcher);
    }

    public static <T> SqlTester.ResultChecker createChecker(Matcher<T> matcher, JdbcType<T> jdbcType) {
        return new MatcherResultChecker<T>(matcher, jdbcType);
    }

    public static SqlTester.ResultChecker createChecker(Object result) {
        Objects.requireNonNull(result, "to check for a null result, use isNullValue()");
        if (result instanceof Pattern) {
            return new PatternResultChecker((Pattern)result);
        }
        if (result instanceof SqlTester.ResultChecker) {
            return (SqlTester.ResultChecker)result;
        }
        if (result instanceof Matcher) {
            return ResultCheckers.createChecker((Matcher)result, JdbcType.DOUBLE);
        }
        if (result instanceof Collection) {
            Collection collection = (Collection)result;
            return new RefSetResultChecker(ImmutableNullableSet.copyOf((Iterable)collection));
        }
        return ResultCheckers.isSingle(result.toString());
    }

    static class RefSetResultChecker
    implements SqlTester.ResultChecker {
        private final Set<String> expected;

        RefSetResultChecker(Set<String> expected) {
            this.expected = ImmutableNullableSet.copyOf(expected);
        }

        @Override
        public void checkResult(String sql, ResultSet resultSet) throws Exception {
            ResultCheckers.compareResultSet(sql, resultSet, this.expected);
        }
    }

    static class MatcherResultChecker<T>
    implements SqlTester.ResultChecker {
        private final Matcher<T> matcher;
        private final JdbcType<T> jdbcType;

        MatcherResultChecker(Matcher<T> matcher, JdbcType<T> jdbcType) {
            this.matcher = Objects.requireNonNull(matcher, "matcher");
            this.jdbcType = Objects.requireNonNull(jdbcType, "jdbcType");
        }

        @Override
        public void checkResult(String sql, ResultSet resultSet) throws Exception {
            ResultCheckers.compareResultSetWithMatcher(sql, resultSet, this.jdbcType, this.matcher);
        }
    }

    static class PatternResultChecker
    implements SqlTester.ResultChecker {
        final Pattern pattern;

        PatternResultChecker(Pattern pattern) {
            this.pattern = Objects.requireNonNull(pattern, "pattern");
        }

        @Override
        public void checkResult(String sql, ResultSet resultSet) throws Exception {
            ResultCheckers.compareResultSetWithPattern(sql, resultSet, this.pattern);
        }
    }
}

