/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test.catalog;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql2rel.NullInitializerExpressionFactory;
import org.apache.calcite.test.catalog.MockCatalogReader;

public class MustFilterMockCatalogReader
extends MockCatalogReader {
    MustFilterMockCatalogReader(RelDataTypeFactory typeFactory, boolean caseSensitive) {
        super(typeFactory, caseSensitive);
    }

    public static SqlValidatorCatalogReader create(RelDataTypeFactory typeFactory, boolean caseSensitive) {
        return new MustFilterMockCatalogReader(typeFactory, caseSensitive).init();
    }

    @Override
    public MockCatalogReader init() {
        MockCatalogReader.MockSchema salesSchema = new MockCatalogReader.MockSchema("SALES");
        this.registerSchema(salesSchema);
        MockCatalogReader.MustFilterMockTable empTable = MockCatalogReader.MustFilterMockTable.create((MockCatalogReader)this, salesSchema, "EMP", false, 14.0, null, NullInitializerExpressionFactory.INSTANCE, false, (Map<String, String>)ImmutableMap.of((Object)"EMPNO", (Object)"10", (Object)"JOB", (Object)"JOB_1"));
        RelDataType integerType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        RelDataType timestampType = this.typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
        RelDataType varcharType = this.typeFactory.createSqlType(SqlTypeName.VARCHAR);
        RelDataType booleanType = this.typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        empTable.addColumn("EMPNO", integerType, true);
        empTable.addColumn("ENAME", varcharType);
        empTable.addColumn("JOB", varcharType);
        empTable.addColumn("MGR", integerType);
        empTable.addColumn("HIREDATE", timestampType);
        empTable.addColumn("SAL", integerType);
        empTable.addColumn("COMM", integerType);
        empTable.addColumn("DEPTNO", integerType);
        empTable.addColumn("SLACKER", booleanType);
        this.registerTable(empTable);
        MockCatalogReader.MustFilterMockTable deptTable = MockCatalogReader.MustFilterMockTable.create((MockCatalogReader)this, salesSchema, "DEPT", false, 14.0, null, NullInitializerExpressionFactory.INSTANCE, false, (Map<String, String>)ImmutableMap.of((Object)"NAME", (Object)"ACCOUNTING_DEPT"));
        deptTable.addColumn("DEPTNO", integerType, true);
        deptTable.addColumn("NAME", varcharType);
        this.registerTable(deptTable);
        return this;
    }
}

