/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.parser;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSortedSet;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import java.util.SortedSet;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSetOption;
import org.apache.calcite.sql.SqlUnknownLiteral;
import org.apache.calcite.sql.SqlWriterConfig;
import org.apache.calcite.sql.dialect.AnsiSqlDialect;
import org.apache.calcite.sql.dialect.SparkSqlDialect;
import org.apache.calcite.sql.parser.SqlAbstractParserImpl;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserFixture;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.sql.parser.StringAndPos;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.calcite.sql.test.SqlTestFactory;
import org.apache.calcite.sql.test.SqlTests;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.test.IntervalTest;
import org.apache.calcite.tools.Hoist;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.TestUtil;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.CustomTypeSafeMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class SqlParserTest {
    private static final String[] RESERVED_KEYWORDS = new String[]{"ABS", "2011", "2014", "c", "ABSOLUTE", "92", "99", "ACTION", "92", "99", "ADD", "92", "99", "2003", "AFTER", "99", "ALL", "92", "99", "2003", "2011", "2014", "c", "ALLOCATE", "92", "99", "2003", "2011", "2014", "c", "ALLOW", "c", "ALTER", "92", "99", "2003", "2011", "2014", "c", "AND", "92", "99", "2003", "2011", "2014", "c", "ANY", "92", "99", "2003", "2011", "2014", "c", "ARE", "92", "99", "2003", "2011", "2014", "c", "ARRAY", "99", "2003", "2011", "2014", "c", "ARRAY_AGG", "2011", "ARRAY_MAX_CARDINALITY", "2014", "c", "AS", "92", "99", "2003", "2011", "2014", "c", "ASC", "92", "99", "ASENSITIVE", "99", "2003", "2011", "2014", "c", "ASOF", "c", "ASSERTION", "92", "99", "ASYMMETRIC", "99", "2003", "2011", "2014", "c", "AT", "92", "99", "2003", "2011", "2014", "c", "ATOMIC", "99", "2003", "2011", "2014", "c", "AUTHORIZATION", "92", "99", "2003", "2011", "2014", "c", "AVG", "92", "2011", "2014", "c", "BEFORE", "99", "BEGIN", "92", "99", "2003", "2011", "2014", "c", "BEGIN_FRAME", "2014", "c", "BEGIN_PARTITION", "2014", "c", "BETWEEN", "92", "99", "2003", "2011", "2014", "c", "BIGINT", "2003", "2011", "2014", "c", "BINARY", "99", "2003", "2011", "2014", "c", "BIT", "92", "99", "c", "BIT_LENGTH", "92", "BLOB", "99", "2003", "2011", "2014", "c", "BOOLEAN", "99", "2003", "2011", "2014", "c", "BOTH", "92", "99", "2003", "2011", "2014", "c", "BREADTH", "99", "BY", "92", "99", "2003", "2011", "2014", "c", "CALL", "92", "99", "2003", "2011", "2014", "c", "CALLED", "2003", "2011", "2014", "c", "CARDINALITY", "2011", "2014", "c", "CASCADE", "92", "99", "CASCADED", "92", "99", "2003", "2011", "2014", "c", "CASE", "92", "99", "2003", "2011", "2014", "c", "CAST", "92", "99", "2003", "2011", "2014", "c", "CATALOG", "92", "99", "CEIL", "2011", "2014", "c", "CEILING", "2011", "2014", "c", "CHAR", "92", "99", "2003", "2011", "2014", "c", "CHARACTER", "92", "99", "2003", "2011", "2014", "c", "CHARACTER_LENGTH", "92", "2011", "2014", "c", "CHAR_LENGTH", "92", "2011", "2014", "c", "CHECK", "92", "99", "2003", "2011", "2014", "c", "CLASSIFIER", "2014", "c", "CLOB", "99", "2003", "2011", "2014", "c", "CLOSE", "92", "99", "2003", "2011", "2014", "c", "COALESCE", "92", "2011", "2014", "c", "COLLATE", "92", "99", "2003", "2011", "2014", "c", "COLLATION", "92", "99", "COLLECT", "2011", "2014", "c", "COLUMN", "92", "99", "2003", "2011", "2014", "c", "COMMIT", "92", "99", "2003", "2011", "2014", "c", "CONDITION", "92", "99", "2003", "2011", "2014", "c", "CONNECT", "92", "99", "2003", "2011", "2014", "c", "CONNECTION", "92", "99", "CONSTRAINT", "92", "99", "2003", "2011", "2014", "c", "CONSTRAINTS", "92", "99", "CONSTRUCTOR", "99", "CONTAINS", "92", "2011", "2014", "c", "CONTINUE", "92", "99", "2003", "CONVERT", "92", "2011", "2014", "c", "CORR", "2011", "2014", "c", "CORRESPONDING", "92", "99", "2003", "2011", "2014", "c", "COUNT", "92", "2011", "2014", "c", "COVAR_POP", "2011", "2014", "c", "COVAR_SAMP", "2011", "2014", "c", "CREATE", "92", "99", "2003", "2011", "2014", "c", "CROSS", "92", "99", "2003", "2011", "2014", "c", "CUBE", "99", "2003", "2011", "2014", "c", "CUME_DIST", "2011", "2014", "c", "CURRENT", "92", "99", "2003", "2011", "2014", "c", "CURRENT_CATALOG", "2011", "2014", "c", "CURRENT_DATE", "92", "99", "2003", "2011", "2014", "c", "CURRENT_DEFAULT_TRANSFORM_GROUP", "99", "2003", "2011", "2014", "c", "CURRENT_PATH", "92", "99", "2003", "2011", "2014", "c", "CURRENT_ROLE", "99", "2003", "2011", "2014", "c", "CURRENT_ROW", "2014", "c", "CURRENT_SCHEMA", "2011", "2014", "c", "CURRENT_TIME", "92", "99", "2003", "2011", "2014", "c", "CURRENT_TIMESTAMP", "92", "99", "2003", "2011", "2014", "c", "CURRENT_TRANSFORM_GROUP_FOR_TYPE", "99", "2003", "2011", "2014", "c", "CURRENT_USER", "92", "99", "2003", "2011", "2014", "c", "CURSOR", "92", "99", "2003", "2011", "2014", "c", "CYCLE", "99", "2003", "2011", "2014", "c", "DATA", "99", "DATE", "92", "99", "2003", "2011", "2014", "c", "DATETIME", "c", "DAY", "92", "99", "2003", "2011", "2014", "c", "DAYS", "2011", "DEALLOCATE", "92", "99", "2003", "2011", "2014", "c", "DEC", "92", "99", "2003", "2011", "2014", "c", "DECIMAL", "92", "99", "2003", "2011", "2014", "c", "DECLARE", "92", "99", "2003", "2011", "2014", "c", "DEFAULT", "92", "99", "2003", "2011", "2014", "c", "DEFERRABLE", "92", "99", "DEFERRED", "92", "99", "DEFINE", "2014", "c", "DELETE", "92", "99", "2003", "2011", "2014", "c", "DENSE_RANK", "2011", "2014", "c", "DEPTH", "99", "DEREF", "99", "2003", "2011", "2014", "c", "DESC", "92", "99", "DESCRIBE", "92", "99", "2003", "2011", "2014", "c", "DESCRIPTOR", "92", "99", "DETERMINISTIC", "92", "99", "2003", "2011", "2014", "c", "DIAGNOSTICS", "92", "99", "DISALLOW", "c", "DISCONNECT", "92", "99", "2003", "2011", "2014", "c", "DISTINCT", "92", "99", "2003", "2011", "2014", "c", "DO", "92", "99", "2003", "DOMAIN", "92", "99", "DOUBLE", "92", "99", "2003", "2011", "2014", "c", "DROP", "92", "99", "2003", "2011", "2014", "c", "DYNAMIC", "99", "2003", "2011", "2014", "c", "EACH", "99", "2003", "2011", "2014", "c", "ELEMENT", "2003", "2011", "2014", "c", "ELSE", "92", "99", "2003", "2011", "2014", "c", "ELSEIF", "92", "99", "2003", "EMPTY", "2014", "c", "END", "92", "99", "2003", "2011", "2014", "c", "END-EXEC", "2011", "2014", "c", "END_FRAME", "2014", "c", "END_PARTITION", "2014", "c", "EQUALS", "99", "2014", "c", "ESCAPE", "92", "99", "2003", "2011", "2014", "c", "EVERY", "2011", "2014", "c", "EXCEPT", "92", "99", "2003", "2011", "2014", "c", "EXCEPTION", "92", "99", "EXEC", "92", "99", "2003", "2011", "2014", "c", "EXECUTE", "92", "99", "2003", "2011", "2014", "c", "EXISTS", "92", "99", "2003", "2011", "2014", "c", "EXIT", "92", "99", "2003", "EXP", "2011", "2014", "c", "EXPLAIN", "c", "EXTEND", "c", "EXTERNAL", "92", "99", "2003", "2011", "2014", "c", "EXTRACT", "92", "2011", "2014", "c", "FALSE", "92", "99", "2003", "2011", "2014", "c", "FETCH", "92", "99", "2003", "2011", "2014", "c", "FILTER", "99", "2003", "2011", "2014", "c", "FIRST", "92", "99", "FIRST_VALUE", "2011", "2014", "c", "FLOAT", "92", "99", "2003", "2011", "2014", "c", "FLOOR", "2011", "2014", "c", "FOR", "92", "99", "2003", "2011", "2014", "c", "FOREIGN", "92", "99", "2003", "2011", "2014", "c", "FOREVER", "2011", "FOUND", "92", "99", "FRAME_ROW", "2014", "c", "FREE", "99", "2003", "2011", "2014", "c", "FRIDAY", "c", "FROM", "92", "99", "2003", "2011", "2014", "c", "FULL", "92", "99", "2003", "2011", "2014", "c", "FUNCTION", "92", "99", "2003", "2011", "2014", "c", "FUSION", "2011", "2014", "c", "GENERAL", "99", "GET", "92", "99", "2003", "2011", "2014", "c", "GLOBAL", "92", "99", "2003", "2011", "2014", "c", "GO", "92", "99", "GOTO", "92", "99", "GRANT", "92", "99", "2003", "2011", "2014", "c", "GROUP", "92", "99", "2003", "2011", "2014", "c", "GROUPING", "99", "2003", "2011", "2014", "c", "GROUPS", "2014", "c", "HANDLER", "92", "99", "2003", "HAVING", "92", "99", "2003", "2011", "2014", "c", "HOLD", "99", "2003", "2011", "2014", "c", "HOUR", "92", "99", "2003", "2011", "2014", "c", "HOURS", "2011", "IDENTITY", "92", "99", "2003", "2011", "2014", "c", "IF", "92", "99", "2003", "ILIKE", "IMMEDIATE", "92", "99", "2003", "IMMEDIATELY", "IMPORT", "c", "IN", "92", "99", "2003", "2011", "2014", "c", "INDICATOR", "92", "99", "2003", "2011", "2014", "c", "INITIAL", "2014", "c", "INITIALLY", "92", "99", "INNER", "92", "99", "2003", "2011", "2014", "c", "INOUT", "92", "99", "2003", "2011", "2014", "c", "INPUT", "92", "99", "2003", "INSENSITIVE", "92", "99", "2003", "2011", "2014", "c", "INSERT", "92", "99", "2003", "2011", "2014", "c", "INT", "92", "99", "2003", "2011", "2014", "c", "INTEGER", "92", "99", "2003", "2011", "2014", "c", "INTERSECT", "92", "99", "2003", "2011", "2014", "c", "INTERSECTION", "2011", "2014", "c", "INTERVAL", "92", "99", "2003", "2011", "2014", "c", "INTO", "92", "99", "2003", "2011", "2014", "c", "IS", "92", "99", "2003", "2011", "2014", "c", "ISOLATION", "92", "99", "ITERATE", "99", "2003", "JOIN", "92", "99", "2003", "2011", "2014", "c", "JSON_ARRAY", "c", "JSON_ARRAYAGG", "c", "JSON_EXISTS", "c", "JSON_OBJECT", "c", "JSON_OBJECTAGG", "c", "JSON_QUERY", "c", "JSON_SCOPE", "c", "JSON_VALUE", "c", "KEEP", "2011", "KEY", "92", "99", "LAG", "2011", "2014", "c", "LANGUAGE", "92", "99", "2003", "2011", "2014", "c", "LARGE", "99", "2003", "2011", "2014", "c", "LAST", "92", "99", "LAST_VALUE", "2011", "2014", "c", "LATERAL", "99", "2003", "2011", "2014", "c", "LEAD", "2011", "2014", "c", "LEADING", "92", "99", "2003", "2011", "2014", "c", "LEAVE", "92", "99", "2003", "LEFT", "92", "99", "2003", "2011", "2014", "c", "LEVEL", "92", "99", "LIKE", "92", "99", "2003", "2011", "2014", "c", "LIKE_REGEX", "2011", "2014", "c", "LIMIT", "c", "LN", "2011", "2014", "c", "LOCAL", "92", "99", "2003", "2011", "2014", "c", "LOCALTIME", "99", "2003", "2011", "2014", "c", "LOCALTIMESTAMP", "99", "2003", "2011", "2014", "c", "LOCATOR", "99", "LOOP", "92", "99", "2003", "LOWER", "92", "2011", "2014", "c", "MAP", "99", "MATCH", "92", "99", "2003", "2011", "2014", "c", "MATCHES", "2014", "c", "MATCH_CONDITION", "c", "MATCH_NUMBER", "2014", "c", "MATCH_RECOGNIZE", "2014", "c", "MAX", "92", "2011", "2014", "c", "MAX_CARDINALITY", "2011", "MEASURE", "c", "MEASURES", "c", "MEMBER", "2003", "2011", "2014", "c", "MERGE", "2003", "2011", "2014", "c", "METHOD", "99", "2003", "2011", "2014", "c", "MIN", "92", "2011", "2014", "c", "MINUS", "c", "MINUTE", "92", "99", "2003", "2011", "2014", "c", "MINUTES", "2011", "MOD", "2011", "2014", "c", "MODIFIES", "99", "2003", "2011", "2014", "c", "MODULE", "92", "99", "2003", "2011", "2014", "c", "MONDAY", "c", "MONTH", "92", "99", "2003", "2011", "2014", "c", "MULTISET", "2003", "2011", "2014", "c", "NAMES", "92", "99", "NATIONAL", "92", "99", "2003", "2011", "2014", "c", "NATURAL", "92", "99", "2003", "2011", "2014", "c", "NCHAR", "92", "99", "2003", "2011", "2014", "c", "NCLOB", "99", "2003", "2011", "2014", "c", "NEW", "99", "2003", "2011", "2014", "c", "NEXT", "92", "99", "c", "NO", "92", "99", "2003", "2011", "2014", "c", "NONE", "99", "2003", "2011", "2014", "c", "NORMALIZE", "2011", "2014", "c", "NOT", "92", "99", "2003", "2011", "2014", "c", "NTH_VALUE", "2011", "2014", "c", "NTILE", "2011", "2014", "c", "NULL", "92", "99", "2003", "2011", "2014", "c", "NULLIF", "92", "2011", "2014", "c", "NUMERIC", "92", "99", "2003", "2011", "2014", "c", "OBJECT", "99", "OCCURRENCES_REGEX", "2011", "2014", "c", "OCTET_LENGTH", "92", "2011", "2014", "c", "OF", "92", "99", "2003", "2011", "2014", "c", "OFFSET", "2011", "2014", "c", "OLD", "99", "2003", "2011", "2014", "c", "OMIT", "2014", "c", "ON", "92", "99", "2003", "2011", "2014", "c", "ONE", "2014", "c", "ONLY", "92", "99", "2003", "2011", "2014", "c", "OPEN", "92", "99", "2003", "2011", "2014", "c", "OPTION", "92", "99", "OR", "92", "99", "2003", "2011", "2014", "c", "ORDER", "92", "99", "2003", "2011", "2014", "c", "ORDINAL", "c", "ORDINALITY", "99", "OUT", "92", "99", "2003", "2011", "2014", "c", "OUTER", "92", "99", "2003", "2011", "2014", "c", "OUTPUT", "92", "99", "2003", "OVER", "99", "2003", "2011", "2014", "c", "OVERLAPS", "92", "99", "2003", "2011", "2014", "c", "OVERLAY", "2011", "2014", "c", "PAD", "92", "99", "PARAMETER", "92", "99", "2003", "2011", "2014", "c", "PARTIAL", "92", "99", "PARTITION", "99", "2003", "2011", "2014", "c", "PATH", "92", "99", "PATTERN", "2014", "c", "PER", "2014", "c", "PERCENT", "2014", "c", "PERCENTILE_CONT", "2011", "2014", "c", "PERCENTILE_DISC", "2011", "2014", "c", "PERCENT_RANK", "2011", "2014", "c", "PERIOD", "2014", "c", "PERMUTE", "c", "PORTION", "2014", "c", "POSITION", "92", "2011", "2014", "c", "POSITION_REGEX", "2011", "2014", "c", "POWER", "2011", "2014", "c", "PRECEDES", "2014", "c", "PRECISION", "92", "99", "2003", "2011", "2014", "c", "PREPARE", "92", "99", "2003", "2011", "2014", "c", "PRESERVE", "92", "99", "PREV", "c", "PRIMARY", "92", "99", "2003", "2011", "2014", "c", "PRIOR", "92", "99", "PRIVILEGES", "92", "99", "PROCEDURE", "92", "99", "2003", "2011", "2014", "c", "PUBLIC", "92", "99", "QUALIFY", "c", "RANGE", "99", "2003", "2011", "2014", "c", "RANK", "2011", "2014", "c", "READ", "92", "99", "READS", "99", "2003", "2011", "2014", "c", "REAL", "92", "99", "2003", "2011", "2014", "c", "RECURSIVE", "99", "2003", "2011", "2014", "c", "REF", "99", "2003", "2011", "2014", "c", "REFERENCES", "92", "99", "2003", "2011", "2014", "c", "REFERENCING", "99", "2003", "2011", "2014", "c", "REGR_AVGX", "2011", "2014", "c", "REGR_AVGY", "2011", "2014", "c", "REGR_COUNT", "2011", "2014", "c", "REGR_INTERCEPT", "2011", "2014", "c", "REGR_R2", "2011", "2014", "c", "REGR_SLOPE", "2011", "2014", "c", "REGR_SXX", "2011", "2014", "c", "REGR_SXY", "2011", "2014", "c", "REGR_SYY", "2011", "2014", "c", "RELATIVE", "92", "99", "RELEASE", "99", "2003", "2011", "2014", "c", "REPEAT", "92", "99", "2003", "RESET", "c", "RESIGNAL", "92", "99", "2003", "RESTRICT", "92", "99", "RESULT", "99", "2003", "2011", "2014", "c", "RETURN", "92", "99", "2003", "2011", "2014", "c", "RETURNS", "92", "99", "2003", "2011", "2014", "c", "REVOKE", "92", "99", "2003", "2011", "2014", "c", "RIGHT", "92", "99", "2003", "2011", "2014", "c", "RLIKE", "ROLE", "99", "ROLLBACK", "92", "99", "2003", "2011", "2014", "c", "ROLLUP", "99", "2003", "2011", "2014", "c", "ROUTINE", "92", "99", "ROW", "99", "2003", "2011", "2014", "c", "ROWS", "92", "99", "2003", "2011", "2014", "c", "ROW_NUMBER", "2011", "2014", "c", "RUNNING", "2014", "c", "SAFE_CAST", "c", "SAFE_OFFSET", "c", "SAFE_ORDINAL", "c", "SATURDAY", "c", "SAVEPOINT", "99", "2003", "2011", "2014", "c", "SCHEMA", "92", "99", "SCOPE", "99", "2003", "2011", "2014", "c", "SCROLL", "92", "99", "2003", "2011", "2014", "c", "SEARCH", "99", "2003", "2011", "2014", "c", "SECOND", "92", "99", "2003", "2011", "2014", "c", "SECONDS", "2011", "SECTION", "92", "99", "SEEK", "2014", "c", "SELECT", "92", "99", "2003", "2011", "2014", "c", "SENSITIVE", "99", "2003", "2011", "2014", "c", "SESSION", "92", "99", "SESSION_USER", "92", "99", "2003", "2011", "2014", "c", "SET", "92", "99", "2003", "2011", "2014", "c", "SETS", "99", "SHOW", "2014", "c", "SIGNAL", "92", "99", "2003", "SIMILAR", "99", "2003", "2011", "2014", "c", "SIZE", "92", "99", "SKIP", "2014", "c", "SMALLINT", "92", "99", "2003", "2011", "2014", "c", "SOME", "92", "99", "2003", "2011", "2014", "c", "SPACE", "92", "99", "SPECIFIC", "92", "99", "2003", "2011", "2014", "c", "SPECIFICTYPE", "99", "2003", "2011", "2014", "c", "SQL", "92", "99", "2003", "2011", "2014", "c", "SQLCODE", "92", "SQLERROR", "92", "SQLEXCEPTION", "92", "99", "2003", "2011", "2014", "c", "SQLSTATE", "92", "99", "2003", "2011", "2014", "c", "SQLWARNING", "92", "99", "2003", "2011", "2014", "c", "SQRT", "2011", "2014", "c", "START", "99", "2003", "2011", "2014", "c", "STATE", "99", "STATIC", "99", "2003", "2011", "2014", "c", "STDDEV_POP", "2011", "2014", "c", "STDDEV_SAMP", "2011", "2014", "c", "STREAM", "c", "SUBMULTISET", "2003", "2011", "2014", "c", "SUBSET", "2014", "c", "SUBSTRING", "92", "2011", "2014", "c", "SUBSTRING_REGEX", "2011", "2014", "c", "SUCCEEDS", "2014", "c", "SUM", "92", "2011", "2014", "c", "SUNDAY", "c", "SYMMETRIC", "99", "2003", "2011", "2014", "c", "SYSTEM", "99", "2003", "2011", "2014", "c", "SYSTEM_TIME", "2014", "c", "SYSTEM_USER", "92", "99", "2003", "2011", "2014", "c", "TABLE", "92", "99", "2003", "2011", "2014", "c", "TABLESAMPLE", "2003", "2011", "2014", "c", "TEMPORARY", "92", "99", "THEN", "92", "99", "2003", "2011", "2014", "c", "THURSDAY", "c", "TIME", "92", "99", "2003", "2011", "2014", "c", "TIMESTAMP", "92", "99", "2003", "2011", "2014", "c", "TIMEZONE_HOUR", "92", "99", "2003", "2011", "2014", "c", "TIMEZONE_MINUTE", "92", "99", "2003", "2011", "2014", "c", "TINYINT", "c", "TO", "92", "99", "2003", "2011", "2014", "c", "TRAILING", "92", "99", "2003", "2011", "2014", "c", "TRANSACTION", "92", "99", "TRANSLATE", "92", "2011", "2014", "c", "TRANSLATE_REGEX", "2011", "2014", "c", "TRANSLATION", "92", "99", "2003", "2011", "2014", "c", "TREAT", "99", "2003", "2011", "2014", "c", "TRIGGER", "99", "2003", "2011", "2014", "c", "TRIM", "92", "2011", "2014", "c", "TRIM_ARRAY", "2011", "2014", "c", "TRUE", "92", "99", "2003", "2011", "2014", "c", "TRUNCATE", "2011", "2014", "c", "TRY_CAST", "c", "TUESDAY", "c", "UESCAPE", "2011", "2014", "c", "UNDER", "99", "UNDO", "92", "99", "2003", "UNION", "92", "99", "2003", "2011", "2014", "c", "UNIQUE", "92", "99", "2003", "2011", "2014", "c", "UNKNOWN", "92", "99", "2003", "2011", "2014", "c", "UNNEST", "99", "2003", "2011", "2014", "c", "UNTIL", "92", "99", "2003", "UPDATE", "92", "99", "2003", "2011", "2014", "c", "UPPER", "92", "2011", "2014", "c", "UPSERT", "c", "USAGE", "92", "99", "USER", "92", "99", "2003", "2011", "2014", "c", "USING", "92", "99", "2003", "2011", "2014", "c", "VALUE", "92", "99", "2003", "2011", "2014", "c", "VALUES", "92", "99", "2003", "2011", "2014", "c", "VALUE_OF", "2014", "c", "VARBINARY", "2011", "2014", "c", "VARCHAR", "92", "99", "2003", "2011", "2014", "c", "VARYING", "92", "99", "2003", "2011", "2014", "c", "VAR_POP", "2011", "2014", "c", "VAR_SAMP", "2011", "2014", "c", "VERSION", "2011", "VERSIONING", "2011", "2014", "c", "VERSIONS", "2011", "VIEW", "92", "99", "WEDNESDAY", "c", "WHEN", "92", "99", "2003", "2011", "2014", "c", "WHENEVER", "92", "99", "2003", "2011", "2014", "c", "WHERE", "92", "99", "2003", "2011", "2014", "c", "WHILE", "92", "99", "2003", "WIDTH_BUCKET", "2011", "2014", "c", "WINDOW", "99", "2003", "2011", "2014", "c", "WITH", "92", "99", "2003", "2011", "2014", "c", "WITHIN", "99", "2003", "2011", "2014", "c", "WITHOUT", "99", "2003", "2011", "2014", "c", "WORK", "92", "99", "WRITE", "92", "99", "YEAR", "92", "99", "2003", "2011", "2014", "c", "YEARS", "2011", "ZONE", "92", "99"};
    private static final String ANY = "(?s).*";
    private static final SqlWriterConfig SQL_WRITER_CONFIG = SqlPrettyWriter.config().withAlwaysUseParentheses(true).withUpdateSetListNewline(false).withFromFolding(SqlWriterConfig.LineFolding.TALL).withIndentation(0);
    protected static final SqlDialect BIG_QUERY = SqlDialect.DatabaseProduct.BIG_QUERY.getDialect();
    private static final SqlDialect CALCITE = SqlDialect.DatabaseProduct.CALCITE.getDialect();
    private static final SqlDialect MSSQL = SqlDialect.DatabaseProduct.MSSQL.getDialect();
    private static final SqlDialect MYSQL = SqlDialect.DatabaseProduct.MYSQL.getDialect();
    private static final SqlDialect ORACLE = SqlDialect.DatabaseProduct.ORACLE.getDialect();
    private static final SqlDialect POSTGRESQL = SqlDialect.DatabaseProduct.POSTGRESQL.getDialect();
    private static final SqlDialect REDSHIFT = SqlDialect.DatabaseProduct.REDSHIFT.getDialect();

    public SqlParserFixture fixture() {
        return SqlParserFixture.DEFAULT;
    }

    protected SqlParserFixture sql(String sql) {
        return this.fixture().sql(sql);
    }

    protected SqlParserFixture expr(String sql) {
        return this.sql(sql).expression(true);
    }

    static UnaryOperator<String> linux(boolean convertToLinux) {
        return convertToLinux ? Util::toLinux : UnaryOperator.identity();
    }

    protected static SqlParser sqlParser(Reader source, UnaryOperator<SqlParser.Config> transform) {
        SqlParser.Config config = (SqlParser.Config)transform.apply(SqlParser.Config.DEFAULT);
        return SqlParser.create((Reader)source, (SqlParser.Config)config);
    }

    public static Matcher<SqlNode> isDdl() {
        return new BaseMatcher<SqlNode>(){

            public boolean matches(Object item) {
                return item instanceof SqlNode && SqlKind.DDL.contains(((SqlNode)item).getKind());
            }

            public void describeTo(Description description) {
                description.appendText("isDdl");
            }
        };
    }

    private static Matcher<SqlNode> isQuoted(final int i, final boolean quoted) {
        return new CustomTypeSafeMatcher<SqlNode>("quoting"){

            protected boolean matchesSafely(SqlNode item) {
                SqlCall valuesCall = (SqlCall)item;
                SqlCall rowCall = (SqlCall)valuesCall.operand(0);
                SqlIdentifier id = (SqlIdentifier)rowCall.operand(0);
                return id.isComponentQuoted(i) == quoted;
            }
        };
    }

    public static Matcher<SqlNode> customMatches(String description, final Consumer<SqlNode> consumer) {
        return new CustomTypeSafeMatcher<SqlNode>(description){

            protected boolean matchesSafely(SqlNode sqlNode) {
                consumer.accept(sqlNode);
                return true;
            }
        };
    }

    protected SortedSet<String> getReservedKeywords() {
        return SqlParserTest.keywords("c");
    }

    protected boolean isReserved(String word) {
        SqlAbstractParserImpl.Metadata metadata = this.fixture().parser().getMetadata();
        return metadata.isReservedWord(word.toUpperCase(Locale.ROOT));
    }

    protected static SortedSet<String> keywords(@Nullable String dialect) {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        String r = null;
        String[] stringArray = RESERVED_KEYWORDS;
        int n = stringArray.length;
        block11: for (int i = 0; i < n; ++i) {
            String w;
            switch (w = stringArray[i]) {
                case "92": 
                case "99": 
                case "2003": 
                case "2011": 
                case "2014": 
                case "c": {
                    if (r == null) {
                        throw new AssertionError((Object)("word should come before year: " + w));
                    }
                    if (dialect != null && !dialect.equals(w)) continue block11;
                    builder.add((Object)r);
                    continue block11;
                }
                default: {
                    if (r != null && r.compareTo(w) >= 0) {
                        throw new AssertionError((Object)("table should be sorted: " + w));
                    }
                    r = w;
                }
            }
        }
        return builder.build();
    }

    @Test
    void testExceptionCleanup() {
        this.sql("select 0.5e1^.1^ from sales.emps").fails("(?s).*Encountered \".1\" at line 1, column 13.\nWas expecting one of:\n    <EOF> \n    \"AS\" \\.\\.\\.\n    \"EXCEPT\" \\.\\.\\.\n.*");
    }

    @Test
    void testOffset() {
        this.sql("SELECT ARRAY[2,4,6][2]").ok("SELECT (ARRAY[2, 4, 6])[2]");
        this.sql("SELECT ARRAY[2,4,6][ORDINAL(2)]").withDialect(BIG_QUERY).ok("SELECT (ARRAY[2, 4, 6])[ORDINAL(2)]");
        this.sql("SELECT ARRAY[2,4,6][OFFSET(2)]").withDialect(BIG_QUERY).ok("SELECT (ARRAY[2, 4, 6])[OFFSET(2)]");
        this.sql("SELECT ARRAY[2,4,6][SAFE_OFFSET(2)]").withDialect(BIG_QUERY).ok("SELECT (ARRAY[2, 4, 6])[SAFE_OFFSET(2)]");
        this.sql("SELECT ARRAY[2,4,6][SAFE_ORDINAL(2)]").withDialect(BIG_QUERY).ok("SELECT (ARRAY[2, 4, 6])[SAFE_ORDINAL(2)]");
        this.sql("SELECT ARRAY[2,4,6][ORDINAL(2)]").ok("SELECT (ARRAY[2, 4, 6])[ORDINAL(2)]");
        this.sql("SELECT ARRAY[2,4,6][OFFSET(2)]").ok("SELECT (ARRAY[2, 4, 6])[OFFSET(2)]");
        this.sql("SELECT ARRAY[2,4,6][SAFE_OFFSET(2)]").ok("SELECT (ARRAY[2, 4, 6])[SAFE_OFFSET(2)]");
        this.sql("SELECT ARRAY[2,4,6][SAFE_ORDINAL(2)]").ok("SELECT (ARRAY[2, 4, 6])[SAFE_ORDINAL(2)]");
    }

    @Test
    void testInvalidToken() {
        this.sql("values (a^#^b)").fails("Lexical error at line 1, column 10\\.  Encountered: \"#\" \\(35\\), after : \"\"");
    }

    @Test
    void testStarAsFails() {
        this.sql("select * as x from emp").ok("SELECT * AS `X`\nFROM `EMP`");
    }

    @Test
    void testFromStarFails() {
        this.sql("select * from sales^.^*").fails("(?s)Encountered \"\\. \\*\" at .*");
        this.sql("select emp.empno AS x from sales^.^*").fails("(?s)Encountered \"\\. \\*\" at .*");
        this.sql("select * from emp^.^*").fails("(?s)Encountered \"\\. \\*\" at .*");
        this.sql("select emp.empno AS x from emp^.^*").fails("(?s)Encountered \"\\. \\*\" at .*");
        this.sql("select emp.empno AS x from ^*^").fails("(?s)Encountered \"\\*\" at .*");
    }

    @Test
    void testPercentileCont() {
        this.sql("select percentile_cont(.5) within group (order by 3) from t").ok("SELECT PERCENTILE_CONT(0.5) WITHIN GROUP (ORDER BY 3)\nFROM `T`");
    }

    @Test
    void testPercentileDisc() {
        this.sql("select percentile_disc(.5) within group (order by 3) from t").ok("SELECT PERCENTILE_DISC(0.5) WITHIN GROUP (ORDER BY 3)\nFROM `T`");
    }

    @Test
    void testPercentileContBigQuery() {
        this.sql("select percentile_cont(x, .5) over() from unnest(array[1,2,3,4]) as x").withDialect(BIG_QUERY).ok("SELECT (PERCENTILE_CONT(x, 0.5) OVER ())\nFROM UNNEST((ARRAY[1, 2, 3, 4])) AS x");
        this.sql("select percentile_cont(x, .5 RESPECT NULLS) over() from unnest(array[1,2,3,4]) as x").withDialect(BIG_QUERY).ok("SELECT (PERCENTILE_CONT(x, 0.5) RESPECT NULLS OVER ())\nFROM UNNEST((ARRAY[1, 2, 3, 4])) AS x");
        this.sql("select percentile_cont(x, .5 IGNORE NULLS) over() from unnest(array[1,null,3,4]) as x").withDialect(BIG_QUERY).ok("SELECT (PERCENTILE_CONT(x, 0.5) IGNORE NULLS OVER ())\nFROM UNNEST((ARRAY[1, NULL, 3, 4])) AS x");
    }

    @Test
    void testPercentileDiscBigQuery() {
        this.sql("select percentile_disc(x, .5) over() from unnest(array[1,2,3,4]) as x").withDialect(BIG_QUERY).ok("SELECT (PERCENTILE_DISC(x, 0.5) OVER ())\nFROM UNNEST((ARRAY[1, 2, 3, 4])) AS x");
        this.sql("select percentile_disc(x, .5 RESPECT NULLS) over() from unnest(array[1,2,3,4]) as x").withDialect(BIG_QUERY).ok("SELECT (PERCENTILE_DISC(x, 0.5) RESPECT NULLS OVER ())\nFROM UNNEST((ARRAY[1, 2, 3, 4])) AS x");
        this.sql("select percentile_disc(x, .5 IGNORE NULLS) over() from unnest(array[1,null,3,4]) as x").withDialect(BIG_QUERY).ok("SELECT (PERCENTILE_DISC(x, 0.5) IGNORE NULLS OVER ())\nFROM UNNEST((ARRAY[1, NULL, 3, 4])) AS x");
    }

    @Test
    void testHyphenatedTableName() {
        this.sql("select * from bigquery^-^foo-bar.baz").fails("(?s)Encountered \"-\" at .*").withDialect(BIG_QUERY).ok("SELECT *\nFROM `bigquery-foo-bar`.baz");
        this.sql("select `baz`.`buzz` from foo.`baz`").withDialect(BIG_QUERY).ok("SELECT baz.buzz\nFROM foo.baz").withDialect(MYSQL).ok("SELECT `baz`.`buzz`\nFROM `foo`.`baz`");
        this.sql("select `baz`.`buzz` from foo^-^bar.`baz`").withDialect(BIG_QUERY).ok("SELECT baz.buzz\nFROM `foo-bar`.baz").withDialect(MYSQL).fails("(?s)Encountered \"-\" at .*");
        this.sql("select * from foo.baz as hyphenated^-^alias-not-allowed").withDialect(BIG_QUERY).fails("(?s)Encountered \"-\" at .*");
        this.sql("select * from foo.baz as `hyphenated-alias-allowed-if-quoted`").withDialect(BIG_QUERY).ok("SELECT *\nFROM foo.baz AS `hyphenated-alias-allowed-if-quoted`");
        this.sql("select * from foo-bar.baz cross join (select alpha-omega from t) as t").withDialect(BIG_QUERY).ok("SELECT *\nFROM `foo-bar`.baz\nCROSS JOIN (SELECT (alpha - omega)\nFROM t) AS t");
        this.sql("select * from bigquery-foo-bar.baz as hyphenated^-^alias-not-allowed").withDialect(BIG_QUERY).fails("(?s)Encountered \"-\" at .*");
        this.sql("insert into bigquery^-^public-data.foo values (1)").fails("Non-query expression encountered in illegal context").withDialect(BIG_QUERY).ok("INSERT INTO `bigquery-public-data`.foo\nVALUES (1)");
        this.sql("update bigquery^-^public-data.foo set a = b").fails("(?s)Encountered \"-\" at .*").withDialect(BIG_QUERY).ok("UPDATE `bigquery-public-data`.foo SET a = b");
        this.sql("delete from bigquery^-^public-data.foo where a = 5").fails("(?s)Encountered \"-\" at .*").withDialect(BIG_QUERY).ok("DELETE FROM `bigquery-public-data`.foo\nWHERE (a = 5)");
        String mergeSql = "merge into bigquery^-^public-data.emps e\nusing (\n  select *\n  from bigquery-public-data.tempemps\n  where deptno is null) t\non e.empno = t.empno\nwhen matched then\n  update set name = t.name, deptno = t.deptno,\n    salary = t.salary * .1\nwhen not matched then\n    insert (name, dept, salary)\n    values(t.name, 10, t.salary * .15)";
        String mergeExpected = "MERGE INTO `bigquery-public-data`.emps AS e\nUSING (SELECT *\nFROM `bigquery-public-data`.tempemps\nWHERE (deptno IS NULL)) AS t\nON (e.empno = t.empno)\nWHEN MATCHED THEN UPDATE SET name = t.name, deptno = t.deptno, salary = (t.salary * 0.1)\nWHEN NOT MATCHED THEN INSERT (name, dept, salary) VALUES (t.name, 10, (t.salary * 0.15))";
        this.sql("merge into bigquery^-^public-data.emps e\nusing (\n  select *\n  from bigquery-public-data.tempemps\n  where deptno is null) t\non e.empno = t.empno\nwhen matched then\n  update set name = t.name, deptno = t.deptno,\n    salary = t.salary * .1\nwhen not matched then\n    insert (name, dept, salary)\n    values(t.name, 10, t.salary * .15)").fails("(?s)Encountered \"-\" at .*").withDialect(BIG_QUERY).ok("MERGE INTO `bigquery-public-data`.emps AS e\nUSING (SELECT *\nFROM `bigquery-public-data`.tempemps\nWHERE (deptno IS NULL)) AS t\nON (e.empno = t.empno)\nWHEN MATCHED THEN UPDATE SET name = t.name, deptno = t.deptno, salary = (t.salary * 0.1)\nWHEN NOT MATCHED THEN INSERT (name, dept, salary) VALUES (t.name, 10, (t.salary * 0.15))");
        this.sql("select * from bigquery ^-^ foo - bar as t where x < y").fails("(?s)Encountered \"-\" at .*").withDialect(BIG_QUERY).fails("(?s)Encountered \"-\" at .*");
    }

    @Test
    void testHyphenatedColumnName() {
        String expected = "SELECT (`FOO` - `BAR`)\nFROM `EMP`";
        String expectedBigQuery = "SELECT (foo - bar)\nFROM emp";
        this.sql("select foo-bar from emp").ok("SELECT (`FOO` - `BAR`)\nFROM `EMP`").withDialect(BIG_QUERY).ok("SELECT (foo - bar)\nFROM emp");
    }

    @Test
    void testDecimalLiteral() {
        this.sql("select DECIMAL '99.999'").ok("SELECT 99.999");
        this.sql("select DECIMAL '   99.999'").ok("SELECT 99.999");
        this.sql("select DECIMAL '   99.999   '").ok("SELECT 99.999");
        this.sql("select DECIMAL '+99.999'").ok("SELECT 99.999");
        this.sql("select DECIMAL '-99.999'").ok("SELECT -99.999");
        this.sql("select DECIMAL'-99.999'").ok("SELECT -99.999");
        this.sql("select DECIMAL'99.999'").ok("SELECT 99.999");
        this.sql("select DECIMAL'.999'").ok("SELECT 0.999");
        this.sql("select DECIMAL'999.'").ok("SELECT 999");
        this.sql("select DECIMAL'999'").ok("SELECT 999");
        this.sql("select DECIMAL '2.11E-2'").ok("SELECT 0.0211");
        this.sql("select DECIMAL '2.11E2'").ok("SELECT 211");
        this.sql("select DECIMAL '.11E-2'").ok("SELECT 0.0011");
        this.sql("select DECIMAL '0.00000000000000001'").ok("SELECT 0.00000000000000001");
        this.sql("select DECIMAL ^''^").fails("(?s)Literal '' can not be parsed to type 'DECIMAL'.*");
        this.sql("select DECIMAL ^'-'^").fails("(?s)Literal '-' can not be parsed to type 'DECIMAL'.*");
        this.sql("select DECIMAL ^'foo'^").fails("(?s)Literal 'foo' can not be parsed to type 'DECIMAL'.*");
        this.sql("select DECIMAL \"2.11E-2\"").withDialect(BIG_QUERY).ok("SELECT 0.0211");
        this.sql("select DECIMAL \"999\"").withDialect(BIG_QUERY).ok("SELECT 999");
    }

    @Test
    void testDecimalWithScale() {
        this.sql("select cast(15 as decimal(3, 1))").ok("SELECT CAST(15 AS DECIMAL(3, 1))");
        this.sql("select cast(15 as decimal(3, -1))").ok("SELECT CAST(15 AS DECIMAL(3, -1))");
        this.sql("select cast(15 as decimal(3, 0))").ok("SELECT CAST(15 AS DECIMAL(3, 0))");
    }

    @Test
    void testDecimalWithPrecision() {
        this.sql("select cast(15 as decimal(1000, 1))").ok("SELECT CAST(15 AS DECIMAL(1000, 1))");
        this.sql("select cast(15 as decimal(3, 1))").ok("SELECT CAST(15 AS DECIMAL(3, 1))");
        this.sql("select cast(15 as decimal(^-^3, 1))").fails("Encountered \"-\" at line 1, column 27\\.\nWas expecting:\n    <UNSIGNED_INTEGER_LITERAL> \\.\\.\\.\n    ");
        this.sql("select cast(15 as decimal(0, 0))").ok("SELECT CAST(15 AS DECIMAL(0, 0))");
    }

    @Test
    void testDerivedColumnList() {
        this.sql("select * from emp as e (empno, gender) where true").ok("SELECT *\nFROM `EMP` AS `E` (`EMPNO`, `GENDER`)\nWHERE TRUE");
    }

    @Test
    void testDerivedColumnListInJoin() {
        String sql = "select * from emp as e (empno, gender)\n join dept as d (deptno, dname) on emp.deptno = dept.deptno";
        String expected = "SELECT *\nFROM `EMP` AS `E` (`EMPNO`, `GENDER`)\nINNER JOIN `DEPT` AS `D` (`DEPTNO`, `DNAME`) ON (`EMP`.`DEPTNO` = `DEPT`.`DEPTNO`)";
        this.sql("select * from emp as e (empno, gender)\n join dept as d (deptno, dname) on emp.deptno = dept.deptno").ok("SELECT *\nFROM `EMP` AS `E` (`EMPNO`, `GENDER`)\nINNER JOIN `DEPT` AS `D` (`DEPTNO`, `DNAME`) ON (`EMP`.`DEPTNO` = `DEPT`.`DEPTNO`)");
    }

    @Test
    void testBetweenAnd() {
        String sql = "select * from emp\nwhere deptno between - DEPTNO + 1 and 5";
        String expected = "SELECT *\nFROM `EMP`\nWHERE (`DEPTNO` BETWEEN ASYMMETRIC ((- `DEPTNO`) + 1) AND 5)";
        this.sql("select * from emp\nwhere deptno between - DEPTNO + 1 and 5").ok("SELECT *\nFROM `EMP`\nWHERE (`DEPTNO` BETWEEN ASYMMETRIC ((- `DEPTNO`) + 1) AND 5)");
    }

    @Test
    void testBetweenAnd2() {
        String sql = "select * from emp\nwhere deptno between - DEPTNO + 1 and - empno - 3";
        String expected = "SELECT *\nFROM `EMP`\nWHERE (`DEPTNO` BETWEEN ASYMMETRIC ((- `DEPTNO`) + 1) AND ((- `EMPNO`) - 3))";
        this.sql("select * from emp\nwhere deptno between - DEPTNO + 1 and - empno - 3").ok("SELECT *\nFROM `EMP`\nWHERE (`DEPTNO` BETWEEN ASYMMETRIC ((- `DEPTNO`) + 1) AND ((- `EMPNO`) - 3))");
    }

    @Disabled
    @Test
    void testDerivedColumnListNoAs() {
        this.sql("select * from emp e (empno, gender) where true").ok("foo");
    }

    @Disabled
    @Test
    void testEmbeddedCall() {
        this.expr("{call foo(?, ?)}").ok("foo");
    }

    @Disabled
    @Test
    void testEmbeddedFunction() {
        this.expr("{? = call bar (?, ?)}").ok("foo");
    }

    @Test
    void testColumnAliasWithAs() {
        this.sql("select 1 as foo from emp").ok("SELECT 1 AS `FOO`\nFROM `EMP`");
    }

    @Test
    void testColumnAliasWithoutAs() {
        this.sql("select 1 foo from emp").ok("SELECT 1 AS `FOO`\nFROM `EMP`");
    }

    @Test
    void testEmbeddedDate() {
        this.expr("{d '1998-10-22'}").ok("DATE '1998-10-22'");
    }

    @Test
    void testEmbeddedTime() {
        this.expr("{t '16:22:34'}").ok("TIME '16:22:34'");
    }

    @Test
    void testEmbeddedTimestamp() {
        this.expr("{ts '1998-10-22 16:22:34'}").ok("TIMESTAMP '1998-10-22 16:22:34'");
    }

    @Test
    void testNot() {
        this.sql("select not true, not false, not null, not unknown from t").ok("SELECT (NOT TRUE), (NOT FALSE), (NOT NULL), (NOT UNKNOWN)\nFROM `T`");
    }

    @Test
    void testBooleanPrecedenceAndAssociativity() {
        this.sql("select * from t where true and false").ok("SELECT *\nFROM `T`\nWHERE (TRUE AND FALSE)");
        this.sql("select * from t where null or unknown and unknown").ok("SELECT *\nFROM `T`\nWHERE (NULL OR (UNKNOWN AND UNKNOWN))");
        this.sql("select * from t where true and (true or true) or false").ok("SELECT *\nFROM `T`\nWHERE ((TRUE AND (TRUE OR TRUE)) OR FALSE)");
        this.sql("select * from t where 1 and true").ok("SELECT *\nFROM `T`\nWHERE (1 AND TRUE)");
    }

    @Test
    void testLessThanAssociativity() {
        this.expr("NOT a = b").ok("(NOT (`A` = `B`))");
        this.expr("x < y < z").ok("((`X` < `Y`) < `Z`)");
        this.expr("x < y <= z = a").ok("(((`X` < `Y`) <= `Z`) = `A`)");
        this.expr("a = x < y <= z = a").ok("((((`A` = `X`) < `Y`) <= `Z`) = `A`)");
        this.expr("a = x is null").ok("((`A` = `X`) IS NULL)");
        this.expr("a = x is not null").ok("((`A` = `X`) IS NOT NULL)");
        this.expr("a = x between y = b and z = c").ok("((`A` = (`X` BETWEEN ASYMMETRIC (`Y` = `B`) AND `Z`)) = `C`)");
        this.expr("a = x like y = b").ok("((`A` = (`X` LIKE `Y`)) = `B`)");
        this.expr("a = x not like y = b").ok("((`A` = (`X` NOT LIKE `Y`)) = `B`)");
        this.expr("a = x similar to y = b").ok("((`A` = (`X` SIMILAR TO `Y`)) = `B`)");
        this.expr("a = x not similar to y = b").ok("((`A` = (`X` NOT SIMILAR TO `Y`)) = `B`)");
        this.expr("a = x not in (y, z) = b").ok("((`A` = (`X` NOT IN (`Y`, `Z`))) = `B`)");
        this.expr("a like b is null").ok("((`A` LIKE `B`) IS NULL)");
        this.expr("a not like b is not null").ok("((`A` NOT LIKE `B`) IS NOT NULL)");
        this.expr("NOT a = b").ok("(NOT (`A` = `B`))");
        this.expr("NOT a = NOT b").ok("(NOT (`A` = (NOT `B`)))");
        this.expr("NOT a IS NULL").ok("(NOT (`A` IS NULL))");
        this.expr("NOT a = b IS NOT NULL").ok("(NOT ((`A` = `B`) IS NOT NULL))");
        this.expr("NOT a AND NOT b").ok("((NOT `A`) AND (NOT `B`))");
        this.expr("NOT a OR NOT b").ok("((NOT `A`) OR (NOT `B`))");
        this.expr("NOT a = b AND NOT c = d OR NOT e = f").ok("(((NOT (`A` = `B`)) AND (NOT (`C` = `D`))) OR (NOT (`E` = `F`)))");
        this.expr("NOT a = b OR NOT c = d AND NOT e = f").ok("((NOT (`A` = `B`)) OR ((NOT (`C` = `D`)) AND (NOT (`E` = `F`))))");
        this.expr("NOT NOT a = b OR NOT NOT c = d").ok("((NOT (NOT (`A` = `B`))) OR (NOT (NOT (`C` = `D`))))");
    }

    @Test
    void testIsBooleans() {
        String[] inOuts;
        for (String inOut : inOuts = new String[]{"NULL", "TRUE", "FALSE", "UNKNOWN"}) {
            this.sql("select * from t where nOt fAlSe Is " + inOut).ok("SELECT *\nFROM `T`\nWHERE (NOT (FALSE IS " + inOut + "))");
            this.sql("select * from t where c1=1.1 IS NOT " + inOut).ok("SELECT *\nFROM `T`\nWHERE ((`C1` = 1.1) IS NOT " + inOut + ")");
        }
    }

    @Test
    void testIsBooleanPrecedenceAndAssociativity() {
        this.sql("select * from t where x is unknown is not unknown").ok("SELECT *\nFROM `T`\nWHERE ((`X` IS UNKNOWN) IS NOT UNKNOWN)");
        this.sql("select 1 from t where not true is unknown").ok("SELECT 1\nFROM `T`\nWHERE (NOT (TRUE IS UNKNOWN))");
        this.sql("select * from t where x is unknown is not unknown is false is not false is true is not true is null is not null").ok("SELECT *\nFROM `T`\nWHERE ((((((((`X` IS UNKNOWN) IS NOT UNKNOWN) IS FALSE) IS NOT FALSE) IS TRUE) IS NOT TRUE) IS NULL) IS NOT NULL)");
        String sql = "select * from t where x is unknown is false and x is unknown is true or not y is unknown is not null";
        String expected = "SELECT *\nFROM `T`\nWHERE ((((`X` IS UNKNOWN) IS FALSE) AND ((`X` IS UNKNOWN) IS TRUE)) OR (NOT ((`Y` IS UNKNOWN) IS NOT NULL)))";
        this.sql("select * from t where x is unknown is false and x is unknown is true or not y is unknown is not null").ok("SELECT *\nFROM `T`\nWHERE ((((`X` IS UNKNOWN) IS FALSE) AND ((`X` IS UNKNOWN) IS TRUE)) OR (NOT ((`Y` IS UNKNOWN) IS NOT NULL)))");
    }

    @Test
    void testEqualNotEqual() {
        this.expr("'abc'=123").ok("('abc' = 123)");
        this.expr("'abc'<>123").ok("('abc' <> 123)");
        this.expr("'abc'<>123='def'<>456").ok("((('abc' <> 123) = 'def') <> 456)");
        this.expr("'abc'<>123=('def'<>456)").ok("(('abc' <> 123) = ('def' <> 456))");
    }

    @Test
    void testBangEqualIsBad() {
        this.expr("'abc'^!=^123").fails("Bang equal '!=' is not allowed under the current SQL conformance level");
    }

    @Test
    void testRecursiveQueryCloned() throws Exception {
        SqlNode sqlNode = this.sql("with RECURSIVE emp2 as (select * from emp union select * from emp2) select * from emp2").parser().parseStmt();
        SqlNode sqlNode1 = (SqlNode)sqlNode.accept((SqlVisitor)new SqlShuttle(){

            public SqlNode visit(SqlIdentifier identifier) {
                return new SqlIdentifier((List)identifier.names, identifier.getParserPosition());
            }
        });
        Assertions.assertTrue((boolean)sqlNode.equalsDeep(sqlNode1, Litmus.IGNORE));
    }

    @Test
    void testBetween() {
        this.sql("select * from t where price between 1 and 2").ok("SELECT *\nFROM `T`\nWHERE (`PRICE` BETWEEN ASYMMETRIC 1 AND 2)");
        this.sql("select * from t where price between symmetric 1 and 2").ok("SELECT *\nFROM `T`\nWHERE (`PRICE` BETWEEN SYMMETRIC 1 AND 2)");
        this.sql("select * from t where price not between symmetric 1 and 2").ok("SELECT *\nFROM `T`\nWHERE (`PRICE` NOT BETWEEN SYMMETRIC 1 AND 2)");
        this.sql("select * from t where price between ASYMMETRIC 1 and 2+2*2").ok("SELECT *\nFROM `T`\nWHERE (`PRICE` BETWEEN ASYMMETRIC 1 AND (2 + (2 * 2)))");
        String sql0 = "select * from t\n where price > 5\n and price not between 1 + 2 and 3 * 4 AnD price is null";
        String expected0 = "SELECT *\nFROM `T`\nWHERE (((`PRICE` > 5) AND (`PRICE` NOT BETWEEN ASYMMETRIC (1 + 2) AND (3 * 4))) AND (`PRICE` IS NULL))";
        this.sql("select * from t\n where price > 5\n and price not between 1 + 2 and 3 * 4 AnD price is null").ok("SELECT *\nFROM `T`\nWHERE (((`PRICE` > 5) AND (`PRICE` NOT BETWEEN ASYMMETRIC (1 + 2) AND (3 * 4))) AND (`PRICE` IS NULL))");
        String sql1 = "select * from t\nwhere price > 5\nand price between 1 + 2 and 3 * 4 + price is null";
        String expected1 = "SELECT *\nFROM `T`\nWHERE ((`PRICE` > 5) AND ((`PRICE` BETWEEN ASYMMETRIC (1 + 2) AND ((3 * 4) + `PRICE`)) IS NULL))";
        this.sql("select * from t\nwhere price > 5\nand price between 1 + 2 and 3 * 4 + price is null").ok("SELECT *\nFROM `T`\nWHERE ((`PRICE` > 5) AND ((`PRICE` BETWEEN ASYMMETRIC (1 + 2) AND ((3 * 4) + `PRICE`)) IS NULL))");
        String sql2 = "select * from t\nwhere price > 5\nand price between 1 + 2 and 3 * 4 or price is null";
        String expected2 = "SELECT *\nFROM `T`\nWHERE (((`PRICE` > 5) AND (`PRICE` BETWEEN ASYMMETRIC (1 + 2) AND (3 * 4))) OR (`PRICE` IS NULL))";
        this.sql("select * from t\nwhere price > 5\nand price between 1 + 2 and 3 * 4 or price is null").ok("SELECT *\nFROM `T`\nWHERE (((`PRICE` > 5) AND (`PRICE` BETWEEN ASYMMETRIC (1 + 2) AND (3 * 4))) OR (`PRICE` IS NULL))");
        String sql3 = "values a between c and d and e and f between g and h";
        String expected3 = "VALUES (ROW((((`A` BETWEEN ASYMMETRIC `C` AND `D`) AND `E`) AND (`F` BETWEEN ASYMMETRIC `G` AND `H`))))";
        this.sql("values a between c and d and e and f between g and h").ok("VALUES (ROW((((`A` BETWEEN ASYMMETRIC `C` AND `D`) AND `E`) AND (`F` BETWEEN ASYMMETRIC `G` AND `H`))))");
        this.sql("values a between b or c^").fails(".*BETWEEN operator has no terminating AND");
        this.sql("values a ^between^").fails("(?s).*Encountered \"between <EOF>\" at line 1, column 10.*");
        this.sql("values a between symmetric 1^").fails(".*BETWEEN operator has no terminating AND");
        this.sql("values a between b and c + 2 or d and e").ok("VALUES (ROW(((`A` BETWEEN ASYMMETRIC `B` AND (`C` + 2)) OR (`D` AND `E`))))");
        this.sql("values x = a between b and c = d = e").ok("VALUES (ROW((((`X` = (`A` BETWEEN ASYMMETRIC `B` AND `C`)) = `D`) = `E`)))");
        this.sql("values a between b or (c and d) or e and f").ok("VALUES (ROW((`A` BETWEEN ASYMMETRIC ((`B` OR (`C` AND `D`)) OR `E`) AND `F`)))");
    }

    @Test
    void testOperateOnColumn() {
        this.sql("select c1*1,c2  + 2,c3/3,c4-4,c5*c4  from t").ok("SELECT (`C1` * 1), (`C2` + 2), (`C3` / 3), (`C4` - 4), (`C5` * `C4`)\nFROM `T`");
    }

    @Test
    void testRow() {
        this.sql("select t.r.\"EXPR$1\", t.r.\"EXPR$0\" from (select (1,2) r from sales.depts) t").ok("SELECT `T`.`R`.`EXPR$1`, `T`.`R`.`EXPR$0`\nFROM (SELECT (ROW(1, 2)) AS `R`\nFROM `SALES`.`DEPTS`) AS `T`");
        this.sql("select t.r.\"EXPR$1\".\"EXPR$2\" from (select ((1,2),(3,4,5)) r from sales.depts) t").ok("SELECT `T`.`R`.`EXPR$1`.`EXPR$2`\nFROM (SELECT (ROW((ROW(1, 2)), (ROW(3, 4, 5)))) AS `R`\nFROM `SALES`.`DEPTS`) AS `T`");
        this.sql("select t.r.\"EXPR$1\".\"EXPR$2\" from (select ((1,2),(3,4,5,6)) r from sales.depts) t").ok("SELECT `T`.`R`.`EXPR$1`.`EXPR$2`\nFROM (SELECT (ROW((ROW(1, 2)), (ROW(3, 4, 5, 6)))) AS `R`\nFROM `SALES`.`DEPTS`) AS `T`");
        String selectRow = "select ^row(t1a, t2a)^ from t1";
        String expected = "SELECT (ROW(`T1A`, `T2A`))\nFROM `T1`";
        this.sql("select ^row(t1a, t2a)^ from t1").withConformance((SqlConformance)SqlConformanceEnum.DEFAULT).ok("SELECT (ROW(`T1A`, `T2A`))\nFROM `T1`");
        this.sql("select ^row(t1a, t2a)^ from t1").withConformance((SqlConformance)SqlConformanceEnum.LENIENT).ok("SELECT (ROW(`T1A`, `T2A`))\nFROM `T1`");
        String pattern = "ROW expression encountered in illegal context";
        this.sql("select ^row(t1a, t2a)^ from t1").withConformance((SqlConformance)SqlConformanceEnum.MYSQL_5).fails("ROW expression encountered in illegal context");
        this.sql("select ^row(t1a, t2a)^ from t1").withConformance((SqlConformance)SqlConformanceEnum.ORACLE_12).fails("ROW expression encountered in illegal context");
        this.sql("select ^row(t1a, t2a)^ from t1").withConformance((SqlConformance)SqlConformanceEnum.STRICT_2003).fails("ROW expression encountered in illegal context");
        this.sql("select ^row(t1a, t2a)^ from t1").withConformance((SqlConformance)SqlConformanceEnum.SQL_SERVER_2008).fails("ROW expression encountered in illegal context");
        String whereRow = "select 1 from t2 where ^row (x, y)^ < row (a, b)";
        String whereExpected = "SELECT 1\nFROM `T2`\nWHERE ((ROW(`X`, `Y`)) < (ROW(`A`, `B`)))";
        this.sql("select 1 from t2 where ^row (x, y)^ < row (a, b)").withConformance((SqlConformance)SqlConformanceEnum.DEFAULT).ok("SELECT 1\nFROM `T2`\nWHERE ((ROW(`X`, `Y`)) < (ROW(`A`, `B`)))");
        this.sql("select 1 from t2 where ^row (x, y)^ < row (a, b)").withConformance((SqlConformance)SqlConformanceEnum.SQL_SERVER_2008).fails("ROW expression encountered in illegal context");
        String whereRow2 = "select 1 from t2 where ^(x, y)^ < (a, b)";
        this.sql("select 1 from t2 where ^(x, y)^ < (a, b)").withConformance((SqlConformance)SqlConformanceEnum.DEFAULT).ok("SELECT 1\nFROM `T2`\nWHERE ((ROW(`X`, `Y`)) < (ROW(`A`, `B`)))");
        Assumptions.assumeFalse((boolean)this.fixture().tester.isUnparserTest());
        this.sql("select 1 from t2 where ^(x, y)^ < (a, b)").withConformance((SqlConformance)SqlConformanceEnum.SQL_SERVER_2008).ok("SELECT 1\nFROM `T2`\nWHERE ((ROW(`X`, `Y`)) < (ROW(`A`, `B`)))");
    }

    @Test
    void testRowValueExpression() {
        String expected0 = "INSERT INTO \"EMPS\"\nVALUES (ROW(1, 'Fred')),\n(ROW(2, 'Eric'))";
        String sql = "insert into emps values (1,'Fred'),(2, 'Eric')";
        this.sql(sql).withDialect(CALCITE).ok("INSERT INTO \"EMPS\"\nVALUES (ROW(1, 'Fred')),\n(ROW(2, 'Eric'))");
        String expected1 = "INSERT INTO `emps`\nVALUES (1, 'Fred'),\n(2, 'Eric')";
        this.sql(sql).withDialect(MYSQL).ok("INSERT INTO `emps`\nVALUES (1, 'Fred'),\n(2, 'Eric')");
        String expected2 = "INSERT INTO \"EMPS\"\nVALUES (1, 'Fred'),\n(2, 'Eric')";
        this.sql(sql).withDialect(ORACLE).ok("INSERT INTO \"EMPS\"\nVALUES (1, 'Fred'),\n(2, 'Eric')");
        String expected3 = "INSERT INTO [EMPS]\nVALUES (1, 'Fred'),\n(2, 'Eric')";
        this.sql(sql).withDialect(MSSQL).ok("INSERT INTO [EMPS]\nVALUES (1, 'Fred'),\n(2, 'Eric')");
        this.expr("ROW(EMP.EMPNO, EMP.ENAME)").ok("(ROW(`EMP`.`EMPNO`, `EMP`.`ENAME`))");
        this.expr("ROW(EMP.EMPNO + 1, EMP.ENAME)").ok("(ROW((`EMP`.`EMPNO` + 1), `EMP`.`ENAME`))");
        this.expr("ROW((select deptno from dept where dept.deptno = emp.deptno), EMP.ENAME)").ok("(ROW((SELECT `DEPTNO`\nFROM `DEPT`\nWHERE (`DEPT`.`DEPTNO` = `EMP`.`DEPTNO`)), `EMP`.`ENAME`))");
    }

    @Test
    void testRowWithDot() {
        this.sql("select (1,2).a from c.t").ok("SELECT ((ROW(1, 2)).`A`)\nFROM `C`.`T`");
        this.sql("select row(1,2).a from c.t").ok("SELECT ((ROW(1, 2)).`A`)\nFROM `C`.`T`");
        this.sql("select tbl.foo(0).col.bar from tbl").ok("SELECT ((`TBL`.`FOO`(0).`COL`).`BAR`)\nFROM `TBL`");
    }

    @Test
    void testDotAfterParenthesizedIdentifier() {
        this.sql("select (a).c.d from c.t").ok("SELECT ((`A`.`C`).`D`)\nFROM `C`.`T`");
    }

    @Test
    void testPeriod() {
        this.expr("period (date '1969-01-05', interval '2-3' year to month)").ok("(ROW(DATE '1969-01-05', INTERVAL '2-3' YEAR TO MONTH))");
    }

    @Test
    void testOverlaps() {
        String[] periods;
        String[] ops = new String[]{"overlaps", "equals", "precedes", "succeeds", "immediately precedes", "immediately succeeds"};
        for (String period : periods = new String[]{"period ", ""}) {
            for (String op : ops) {
                this.checkPeriodPredicate(new Checker(op, period));
            }
        }
    }

    void checkPeriodPredicate(Checker checker) {
        checker.checkExp("$p(x,xx) $op $p(y,yy)", "(PERIOD (`X`, `XX`) $op PERIOD (`Y`, `YY`))");
        checker.checkExp("$p(x,xx) $op $p(y,yy) or false", "((PERIOD (`X`, `XX`) $op PERIOD (`Y`, `YY`)) OR FALSE)");
        checker.checkExp("true and not $p(x,xx) $op $p(y,yy) or false", "((TRUE AND (NOT (PERIOD (`X`, `XX`) $op PERIOD (`Y`, `YY`)))) OR FALSE)");
        if (checker.period.isEmpty()) {
            checker.checkExp("$p(x,xx,xxx) $op $p(y,yy) or false", "((PERIOD (`X`, `XX`) $op PERIOD (`Y`, `YY`)) OR FALSE)");
        } else {
            checker.checkExpFails("$p(x,xx^,^xxx) $op $p(y,yy) or false", "(?s).*Encountered \",\" at .*");
        }
    }

    @Test
    void testStmtListWithSelect() {
        String expected = "SELECT *\nFROM `EMP`,\n`DEPT`";
        this.sql("select * from emp, dept").list().ok("SELECT *\nFROM `EMP`,\n`DEPT`");
    }

    @Test
    void testStmtListWithSelectAndSemicolon() {
        String expected = "SELECT *\nFROM `EMP`,\n`DEPT`";
        this.sql("select * from emp, dept;").list().ok("SELECT *\nFROM `EMP`,\n`DEPT`");
    }

    @Test
    void testStmtListWithTwoSelect() {
        String expected = "SELECT *\nFROM `EMP`,\n`DEPT`";
        this.sql("select * from emp, dept ; select * from emp, dept").list().ok("SELECT *\nFROM `EMP`,\n`DEPT`", "SELECT *\nFROM `EMP`,\n`DEPT`");
    }

    @Test
    void testStmtListWithTwoSelectSemicolon() {
        String expected = "SELECT *\nFROM `EMP`,\n`DEPT`";
        this.sql("select * from emp, dept ; select * from emp, dept;").list().ok("SELECT *\nFROM `EMP`,\n`DEPT`", "SELECT *\nFROM `EMP`,\n`DEPT`");
    }

    @Test
    void testStmtListWithSelectDelete() {
        String expected = "SELECT *\nFROM `EMP`,\n`DEPT`";
        String expected1 = "DELETE FROM `EMP`";
        this.sql("select * from emp, dept; delete from emp").list().ok("SELECT *\nFROM `EMP`,\n`DEPT`", "DELETE FROM `EMP`");
    }

    @Test
    void testStmtListWithSelectDeleteUpdate() {
        String sql = "select * from emp, dept; delete from emp; update emps set empno = empno + 1";
        String expected = "SELECT *\nFROM `EMP`,\n`DEPT`";
        String expected1 = "DELETE FROM `EMP`";
        String expected2 = "UPDATE `EMPS` SET `EMPNO` = (`EMPNO` + 1)";
        this.sql("select * from emp, dept; delete from emp; update emps set empno = empno + 1").list().ok("SELECT *\nFROM `EMP`,\n`DEPT`", "DELETE FROM `EMP`", "UPDATE `EMPS` SET `EMPNO` = (`EMPNO` + 1)");
    }

    @Test
    void testStmtListWithSemiColonInComment() {
        String sql = "select * from emp, dept; // comment with semicolon ; values 1\nvalues 2";
        String expected = "SELECT *\nFROM `EMP`,\n`DEPT`";
        String expected1 = "VALUES (ROW(2))";
        this.sql("select * from emp, dept; // comment with semicolon ; values 1\nvalues 2").list().ok("SELECT *\nFROM `EMP`,\n`DEPT`", "VALUES (ROW(2))");
    }

    @Test
    void testStmtListWithSemiColonInWhere() {
        String expected = "SELECT *\nFROM `EMP`\nWHERE (`NAME` LIKE 'toto;')";
        String expected1 = "DELETE FROM `EMP`";
        this.sql("select * from emp where name like 'toto;'; delete from emp").list().ok("SELECT *\nFROM `EMP`\nWHERE (`NAME` LIKE 'toto;')", "DELETE FROM `EMP`");
    }

    @Test
    void testStmtListWithInsertSelectInsert() {
        String sql = "insert into dept (name, deptno) values ('a', 123); select * from emp where name like 'toto;'; insert into dept (name, deptno) values ('b', 123);";
        String expected = "INSERT INTO `DEPT` (`NAME`, `DEPTNO`)\nVALUES (ROW('a', 123))";
        String expected1 = "SELECT *\nFROM `EMP`\nWHERE (`NAME` LIKE 'toto;')";
        String expected2 = "INSERT INTO `DEPT` (`NAME`, `DEPTNO`)\nVALUES (ROW('b', 123))";
        this.sql("insert into dept (name, deptno) values ('a', 123); select * from emp where name like 'toto;'; insert into dept (name, deptno) values ('b', 123);").list().ok("INSERT INTO `DEPT` (`NAME`, `DEPTNO`)\nVALUES (ROW('a', 123))", "SELECT *\nFROM `EMP`\nWHERE (`NAME` LIKE 'toto;')", "INSERT INTO `DEPT` (`NAME`, `DEPTNO`)\nVALUES (ROW('b', 123))");
    }

    @Test
    void testStmtListWithoutSemiColon1() {
        this.sql("select * from emp where name like 'toto' ^delete^ from emp").list().fails("(?s).*Encountered \"delete\" at .*");
    }

    @Test
    void testStmtListWithoutSemiColon2() {
        this.sql("select * from emp where name like 'toto'; delete from emp; insert into dept (name, deptno) values ('a', 123) ^select^ * from dept").list().fails("(?s).*Encountered \"select\" at .*");
    }

    @Test
    void testIsDistinctFrom() {
        this.sql("select x is distinct from y from t").ok("SELECT (`X` IS DISTINCT FROM `Y`)\nFROM `T`");
        this.sql("select * from t where x is distinct from y").ok("SELECT *\nFROM `T`\nWHERE (`X` IS DISTINCT FROM `Y`)");
        this.sql("select * from t where x is distinct from (4,5,6)").ok("SELECT *\nFROM `T`\nWHERE (`X` IS DISTINCT FROM (ROW(4, 5, 6)))");
        this.sql("select * from t where x is distinct from row (4,5,6)").ok("SELECT *\nFROM `T`\nWHERE (`X` IS DISTINCT FROM (ROW(4, 5, 6)))");
        this.sql("select * from t where true is distinct from true").ok("SELECT *\nFROM `T`\nWHERE (TRUE IS DISTINCT FROM TRUE)");
        this.sql("select * from t where true is distinct from true is true").ok("SELECT *\nFROM `T`\nWHERE ((TRUE IS DISTINCT FROM TRUE) IS TRUE)");
    }

    @Test
    void testIsNotDistinct() {
        this.sql("select x is not distinct from y from t").ok("SELECT (`X` IS NOT DISTINCT FROM `Y`)\nFROM `T`");
        this.sql("select * from t where true is not distinct from true").ok("SELECT *\nFROM `T`\nWHERE (TRUE IS NOT DISTINCT FROM TRUE)");
    }

    @Test
    void testFloor() {
        this.expr("floor(1.5)").ok("FLOOR(1.5)");
        this.expr("floor(x)").ok("FLOOR(`X`)");
        this.expr("floor(x to second)").ok("FLOOR(`X` TO SECOND)");
        this.expr("floor(x to epoch)").ok("FLOOR(`X` TO EPOCH)");
        this.expr("floor(x to minute)").ok("FLOOR(`X` TO MINUTE)");
        this.expr("floor(x to hour)").ok("FLOOR(`X` TO HOUR)");
        this.expr("floor(x to day)").ok("FLOOR(`X` TO DAY)");
        this.expr("floor(x to dow)").ok("FLOOR(`X` TO DOW)");
        this.expr("floor(x to doy)").ok("FLOOR(`X` TO DOY)");
        this.expr("floor(x to week)").ok("FLOOR(`X` TO WEEK)");
        this.expr("floor(x to month)").ok("FLOOR(`X` TO MONTH)");
        this.expr("floor(x to quarter)").ok("FLOOR(`X` TO QUARTER)");
        this.expr("floor(x to year)").ok("FLOOR(`X` TO YEAR)");
        this.expr("floor(x to decade)").ok("FLOOR(`X` TO DECADE)");
        this.expr("floor(x to century)").ok("FLOOR(`X` TO CENTURY)");
        this.expr("floor(x to millennium)").ok("FLOOR(`X` TO MILLENNIUM)");
        this.expr("floor(x + interval '1:20' minute to second)").ok("FLOOR((`X` + INTERVAL '1:20' MINUTE TO SECOND))");
        this.expr("floor(x + interval '1:20' minute to second to second)").ok("FLOOR((`X` + INTERVAL '1:20' MINUTE TO SECOND) TO SECOND)");
        this.expr("floor(x + interval '1:20' minute to second to epoch)").ok("FLOOR((`X` + INTERVAL '1:20' MINUTE TO SECOND) TO EPOCH)");
        this.expr("floor(x + interval '1:20' hour to minute)").ok("FLOOR((`X` + INTERVAL '1:20' HOUR TO MINUTE))");
        this.expr("floor(x + interval '1:20' hour to minute to minute)").ok("FLOOR((`X` + INTERVAL '1:20' HOUR TO MINUTE) TO MINUTE)");
        this.expr("floor(x + interval '1:20' minute to second to hour)").ok("FLOOR((`X` + INTERVAL '1:20' MINUTE TO SECOND) TO HOUR)");
        this.expr("floor(x + interval '1:20' minute to second to day)").ok("FLOOR((`X` + INTERVAL '1:20' MINUTE TO SECOND) TO DAY)");
        this.expr("floor(x + interval '1:20' minute to second to dow)").ok("FLOOR((`X` + INTERVAL '1:20' MINUTE TO SECOND) TO DOW)");
        this.expr("floor(x + interval '1:20' minute to second to doy)").ok("FLOOR((`X` + INTERVAL '1:20' MINUTE TO SECOND) TO DOY)");
        this.expr("floor(x + interval '1:20' minute to second to week)").ok("FLOOR((`X` + INTERVAL '1:20' MINUTE TO SECOND) TO WEEK)");
        this.expr("floor(x + interval '1:20' minute to second to month)").ok("FLOOR((`X` + INTERVAL '1:20' MINUTE TO SECOND) TO MONTH)");
        this.expr("floor(x + interval '1:20' minute to second to quarter)").ok("FLOOR((`X` + INTERVAL '1:20' MINUTE TO SECOND) TO QUARTER)");
        this.expr("floor(x + interval '1:20' minute to second to year)").ok("FLOOR((`X` + INTERVAL '1:20' MINUTE TO SECOND) TO YEAR)");
        this.expr("floor(x + interval '1:20' minute to second to decade)").ok("FLOOR((`X` + INTERVAL '1:20' MINUTE TO SECOND) TO DECADE)");
        this.expr("floor(x + interval '1:20' minute to second to century)").ok("FLOOR((`X` + INTERVAL '1:20' MINUTE TO SECOND) TO CENTURY)");
        this.expr("floor(x + interval '1:20' minute to second to millennium)").ok("FLOOR((`X` + INTERVAL '1:20' MINUTE TO SECOND) TO MILLENNIUM)");
    }

    @Test
    void testCeil() {
        this.expr("ceil(3453.2)").ok("CEIL(3453.2)");
        this.expr("ceil(x)").ok("CEIL(`X`)");
        this.expr("ceil(x to second)").ok("CEIL(`X` TO SECOND)");
        this.expr("ceil(x to epoch)").ok("CEIL(`X` TO EPOCH)");
        this.expr("ceil(x to minute)").ok("CEIL(`X` TO MINUTE)");
        this.expr("ceil(x to hour)").ok("CEIL(`X` TO HOUR)");
        this.expr("ceil(x to day)").ok("CEIL(`X` TO DAY)");
        this.expr("ceil(x to dow)").ok("CEIL(`X` TO DOW)");
        this.expr("ceil(x to doy)").ok("CEIL(`X` TO DOY)");
        this.expr("ceil(x to week)").ok("CEIL(`X` TO WEEK)");
        this.expr("ceil(x to month)").ok("CEIL(`X` TO MONTH)");
        this.expr("ceil(x to quarter)").ok("CEIL(`X` TO QUARTER)");
        this.expr("ceil(x to year)").ok("CEIL(`X` TO YEAR)");
        this.expr("ceil(x to decade)").ok("CEIL(`X` TO DECADE)");
        this.expr("ceil(x to century)").ok("CEIL(`X` TO CENTURY)");
        this.expr("ceil(x to millennium)").ok("CEIL(`X` TO MILLENNIUM)");
        this.expr("ceil(x + interval '1:20' minute to second)").ok("CEIL((`X` + INTERVAL '1:20' MINUTE TO SECOND))");
        this.expr("ceil(x + interval '1:20' minute to second to second)").ok("CEIL((`X` + INTERVAL '1:20' MINUTE TO SECOND) TO SECOND)");
        this.expr("ceil(x + interval '1:20' minute to second to epoch)").ok("CEIL((`X` + INTERVAL '1:20' MINUTE TO SECOND) TO EPOCH)");
        this.expr("ceil(x + interval '1:20' hour to minute)").ok("CEIL((`X` + INTERVAL '1:20' HOUR TO MINUTE))");
        this.expr("ceil(x + interval '1:20' hour to minute to minute)").ok("CEIL((`X` + INTERVAL '1:20' HOUR TO MINUTE) TO MINUTE)");
        this.expr("ceil(x + interval '1:20' minute to second to hour)").ok("CEIL((`X` + INTERVAL '1:20' MINUTE TO SECOND) TO HOUR)");
        this.expr("ceil(x + interval '1:20' minute to second to day)").ok("CEIL((`X` + INTERVAL '1:20' MINUTE TO SECOND) TO DAY)");
        this.expr("ceil(x + interval '1:20' minute to second to dow)").ok("CEIL((`X` + INTERVAL '1:20' MINUTE TO SECOND) TO DOW)");
        this.expr("ceil(x + interval '1:20' minute to second to doy)").ok("CEIL((`X` + INTERVAL '1:20' MINUTE TO SECOND) TO DOY)");
        this.expr("ceil(x + interval '1:20' minute to second to week)").ok("CEIL((`X` + INTERVAL '1:20' MINUTE TO SECOND) TO WEEK)");
        this.expr("ceil(x + interval '1:20' minute to second to month)").ok("CEIL((`X` + INTERVAL '1:20' MINUTE TO SECOND) TO MONTH)");
        this.expr("ceil(x + interval '1:20' minute to second to quarter)").ok("CEIL((`X` + INTERVAL '1:20' MINUTE TO SECOND) TO QUARTER)");
        this.expr("ceil(x + interval '1:20' minute to second to year)").ok("CEIL((`X` + INTERVAL '1:20' MINUTE TO SECOND) TO YEAR)");
        this.expr("ceil(x + interval '1:20' minute to second to decade)").ok("CEIL((`X` + INTERVAL '1:20' MINUTE TO SECOND) TO DECADE)");
        this.expr("ceil(x + interval '1:20' minute to second to century)").ok("CEIL((`X` + INTERVAL '1:20' MINUTE TO SECOND) TO CENTURY)");
        this.expr("ceil(x + interval '1:20' minute to second to millennium)").ok("CEIL((`X` + INTERVAL '1:20' MINUTE TO SECOND) TO MILLENNIUM)");
    }

    @Test
    public void testCast() {
        this.expr("cast(x as boolean)").ok("CAST(`X` AS BOOLEAN)");
        this.expr("cast(x as integer)").ok("CAST(`X` AS INTEGER)");
        this.expr("cast(x as varchar(1))").ok("CAST(`X` AS VARCHAR(1))");
        this.expr("cast(x as date)").ok("CAST(`X` AS DATE)");
        this.expr("cast(x as time)").ok("CAST(`X` AS TIME)");
        this.expr("cast(x as time without time zone)").ok("CAST(`X` AS TIME)");
        this.expr("cast(x as time with local time zone)").ok("CAST(`X` AS TIME WITH LOCAL TIME ZONE)");
        this.expr("cast(x as time with time zone)").ok("CAST(`X` AS TIME WITH TIME ZONE)");
        this.expr("cast(x as timestamp without time zone)").ok("CAST(`X` AS TIMESTAMP)");
        this.expr("cast(x as timestamp with local time zone)").ok("CAST(`X` AS TIMESTAMP WITH LOCAL TIME ZONE)");
        this.expr("cast(x as timestamp with time zone)").ok("CAST(`X` AS TIMESTAMP WITH TIME ZONE)");
        this.expr("cast(x as time(0))").ok("CAST(`X` AS TIME(0))");
        this.expr("cast(x as time(0) without time zone)").ok("CAST(`X` AS TIME(0))");
        this.expr("cast(x as time(0) with local time zone)").ok("CAST(`X` AS TIME(0) WITH LOCAL TIME ZONE)");
        this.expr("cast(x as timestamp(0))").ok("CAST(`X` AS TIMESTAMP(0))");
        this.expr("cast(x as timestamp(0) without time zone)").ok("CAST(`X` AS TIMESTAMP(0))");
        this.expr("cast(x as timestamp(0) with local time zone)").ok("CAST(`X` AS TIMESTAMP(0) WITH LOCAL TIME ZONE)");
        this.expr("cast(x as timestamp)").ok("CAST(`X` AS TIMESTAMP)");
        this.expr("cast(x as decimal(1,1))").ok("CAST(`X` AS DECIMAL(1, 1))");
        this.expr("cast(x as char(1))").ok("CAST(`X` AS CHAR(1))");
        this.expr("cast(x as binary(1))").ok("CAST(`X` AS BINARY(1))");
        this.expr("cast(x as varbinary(1))").ok("CAST(`X` AS VARBINARY(1))");
        this.expr("cast(x as tinyint)").ok("CAST(`X` AS TINYINT)");
        this.expr("cast(x as smallint)").ok("CAST(`X` AS SMALLINT)");
        this.expr("cast(x as bigint)").ok("CAST(`X` AS BIGINT)");
        this.expr("cast(x as real)").ok("CAST(`X` AS REAL)");
        this.expr("cast(x as double)").ok("CAST(`X` AS DOUBLE)");
        this.expr("cast(x as decimal)").ok("CAST(`X` AS DECIMAL)");
        this.expr("cast(x as decimal(0))").ok("CAST(`X` AS DECIMAL(0))");
        this.expr("cast(x as decimal(1,2))").ok("CAST(`X` AS DECIMAL(1, 2))");
        this.expr("cast('foo' as bar)").ok("CAST('foo' AS `BAR`)");
    }

    @Test
    void testCastFails() {
        this.expr("cast(x as varchar(10) ^with^ local time zone)").fails("(?s).*Encountered \"with\" at line 1, column 23.\n.*");
        this.expr("cast(x as varchar(10) ^without^ time zone)").fails("(?s).*Encountered \"without\" at line 1, column 23.\n.*");
    }

    @Test
    void testMssqlConvert() {
        this.expr("CONVERT(VARCHAR(5), 'xx')").same();
        this.expr("CONVERT(VARCHAR(5), 'xx')").same();
        this.expr("CONVERT(VARCHAR(5), NULL)").same();
        this.expr("CONVERT(VARCHAR(5), NULL, NULL)").same();
        this.expr("CONVERT(DATE, 'xx', 121)").same();
        this.expr("CONVERT(DATE, 'xx')").same();
    }

    @Test
    void testLikeAndSimilar() {
        this.sql("select * from t where x like '%abc%'").ok("SELECT *\nFROM `T`\nWHERE (`X` LIKE '%abc%')");
        this.sql("select * from t where x+1 not siMilaR to '%abc%' ESCAPE 'e'").ok("SELECT *\nFROM `T`\nWHERE ((`X` + 1) NOT SIMILAR TO '%abc%' ESCAPE 'e')");
        this.sql("select * from t where price > 5 and x+2*2 like y*3+2 escape (select*from t)").ok("SELECT *\nFROM `T`\nWHERE ((`PRICE` > 5) AND ((`X` + (2 * 2)) LIKE ((`Y` * 3) + 2) ESCAPE (SELECT *\nFROM `T`)))");
        this.sql("values a and b like c").ok("VALUES (ROW((`A` AND (`B` LIKE `C`))))");
        this.sql("values a and b like c escape d and e").ok("VALUES (ROW(((`A` AND (`B` LIKE `C` ESCAPE `D`)) AND `E`)))");
        this.sql("values a = b like c = d").ok("VALUES (ROW(((`A` = (`B` LIKE `C`)) = `D`)))");
        this.sql("values a like b like c escape d").ok("VALUES (ROW((`A` LIKE (`B` LIKE `C` ESCAPE `D`))))");
        this.sql("values a like b like c escape d and false").ok("VALUES (ROW(((`A` LIKE (`B` LIKE `C` ESCAPE `D`)) AND FALSE)))");
        this.sql("values a like b like c like d escape e escape f").ok("VALUES (ROW((`A` LIKE (`B` LIKE (`C` LIKE `D` ESCAPE `E`) ESCAPE `F`))))");
        this.sql("values a similar to b like c similar to d escape e escape f").ok("VALUES (ROW((`A` SIMILAR TO (`B` LIKE (`C` SIMILAR TO `D` ESCAPE `E`) ESCAPE `F`))))");
        if (this.isReserved("ESCAPE")) {
            this.sql("select * from t where ^escape^ 'e'").fails("(?s).*Encountered \"escape\" at .*");
        }
        this.sql("values a like b + c escape d").ok("VALUES (ROW((`A` LIKE (`B` + `C`) ESCAPE `D`)))");
        this.sql("values a like b || c escape d").ok("VALUES (ROW((`A` LIKE (`B` || `C`) ESCAPE `D`)))");
        if (this.isReserved("ESCAPE")) {
            this.sql("values a ^like^ escape d").fails("(?s).*Encountered \"like escape\" at .*");
        }
        if (this.isReserved("ESCAPE")) {
            this.sql("values a like b || c ^escape^ and false").fails("(?s).*Encountered \"escape and\" at line 1, column 22.*");
        }
        this.sql("select * from t where x similar to '%abc%'").ok("SELECT *\nFROM `T`\nWHERE (`X` SIMILAR TO '%abc%')");
        this.sql("select * from t where x+1 not siMilaR to '%abc%' ESCAPE 'e'").ok("SELECT *\nFROM `T`\nWHERE ((`X` + 1) NOT SIMILAR TO '%abc%' ESCAPE 'e')");
        this.sql("select * from t where price > 5 and x+2*2 SIMILAR TO y*3+2 escape (select*from t)").ok("SELECT *\nFROM `T`\nWHERE ((`PRICE` > 5) AND ((`X` + (2 * 2)) SIMILAR TO ((`Y` * 3) + 2) ESCAPE (SELECT *\nFROM `T`)))");
        this.sql("values a similar to b like c similar to d escape e escape f").ok("VALUES (ROW((`A` SIMILAR TO (`B` LIKE (`C` SIMILAR TO `D` ESCAPE `E`) ESCAPE `F`))))");
        this.sql("values a similar to (select * from t where a like b escape c) escape d").ok("VALUES (ROW((`A` SIMILAR TO (SELECT *\nFROM `T`\nWHERE (`A` LIKE `B` ESCAPE `C`)) ESCAPE `D`)))");
    }

    @Test
    void testIlike() {
        String expected = "SELECT *\nFROM `T`\nWHERE (`X` NOT ILIKE '%abc%')";
        String sql = "select * from t where x not ilike '%abc%'";
        this.sql("select * from t where x not ilike '%abc%'").ok("SELECT *\nFROM `T`\nWHERE (`X` NOT ILIKE '%abc%')");
        String sql1 = "select * from t where x ilike '%abc%'";
        String expected1 = "SELECT *\nFROM `T`\nWHERE (`X` ILIKE '%abc%')";
        this.sql("select * from t where x ilike '%abc%'").ok("SELECT *\nFROM `T`\nWHERE (`X` ILIKE '%abc%')");
    }

    @Test
    void testRlike() {
        String expected = "SELECT `COLA`\nFROM `T`\nWHERE (MAX(`EMAIL`) RLIKE '.+@.+\\\\..+')";
        String sql = "select cola from t where max(email) rlike '.+@.+\\\\..+'";
        this.sql("select cola from t where max(email) rlike '.+@.+\\\\..+'").ok("SELECT `COLA`\nFROM `T`\nWHERE (MAX(`EMAIL`) RLIKE '.+@.+\\\\..+')");
        String expected1 = "SELECT `COLA`\nFROM `T`\nWHERE (MAX(`EMAIL`) NOT RLIKE '.+@.+\\\\..+')";
        String sql1 = "select cola from t where max(email) not rlike '.+@.+\\\\..+'";
        this.sql("select cola from t where max(email) not rlike '.+@.+\\\\..+'").ok("SELECT `COLA`\nFROM `T`\nWHERE (MAX(`EMAIL`) NOT RLIKE '.+@.+\\\\..+')");
    }

    @Test
    void testArithmeticOperators() {
        this.expr("1-2+3*4/5/6-7").ok("(((1 - 2) + (((3 * 4) / 5) / 6)) - 7)");
        this.expr("power(2,3)").ok("POWER(2, 3)");
        this.expr("aBs(-2.3e-2)").ok("ABS(-2.3E-2)");
        this.expr("MOD(5             ,\t\f\r\n2)").ok("MOD(5, 2)");
        this.expr("ln(5.43  )").ok("LN(5.43)");
        this.expr("log10(- -.2  )").ok("LOG10(0.2)");
    }

    @Test
    void testExists() {
        this.sql("select * from dept where exists (select 1 from emp where emp.deptno = dept.deptno)").ok("SELECT *\nFROM `DEPT`\nWHERE (EXISTS (SELECT 1\nFROM `EMP`\nWHERE (`EMP`.`DEPTNO` = `DEPT`.`DEPTNO`)))");
    }

    @Test
    void testExistsInWhere() {
        this.sql("select * from emp where 1 = 2 and exists (select 1 from dept) and 3 = 4").ok("SELECT *\nFROM `EMP`\nWHERE (((1 = 2) AND (EXISTS (SELECT 1\nFROM `DEPT`))) AND (3 = 4))");
    }

    @Test
    void testUnique() {
        this.sql("select * from dept where unique (select 1 from emp where emp.deptno = dept.deptno)").ok("SELECT *\nFROM `DEPT`\nWHERE (UNIQUE (SELECT 1\nFROM `EMP`\nWHERE (`EMP`.`DEPTNO` = `DEPT`.`DEPTNO`)))");
    }

    @Test
    void testUniqueInWhere() {
        this.sql("select * from emp where 1 = 2 and unique (select 1 from dept) and 3 = 4").ok("SELECT *\nFROM `EMP`\nWHERE (((1 = 2) AND (UNIQUE (SELECT 1\nFROM `DEPT`))) AND (3 = 4))");
    }

    @Test
    void testNotUnique() {
        this.sql("select * from dept where not not unique (select * from emp) and true").ok("SELECT *\nFROM `DEPT`\nWHERE ((NOT (NOT (UNIQUE (SELECT *\nFROM `EMP`)))) AND TRUE)");
    }

    @Test
    void testFromWithAs() {
        this.sql("select 1 from emp as e where 1").ok("SELECT 1\nFROM `EMP` AS `E`\nWHERE 1");
    }

    @Test
    void testConcat() {
        this.expr("'a' || 'b'").ok("('a' || 'b')");
    }

    @Test
    void testCStyleEscapedString() {
        this.expr("E'Apache\\tCalcite'").ok("_UTF16'Apache\tCalcite'");
        this.expr("E'Apache\\bCalcite'").ok("_UTF16'Apache\bCalcite'");
        this.expr("E'Apache\\fCalcite'").ok("_UTF16'Apache\fCalcite'");
        this.expr("E'Apache\\nCalcite'").ok("_UTF16'Apache\nCalcite'");
        this.expr("E'Apache\\rCalcite'").ok("_UTF16'Apache\rCalcite'");
        this.expr("E'\\t\\n\\f'").ok("_UTF16'\t\n\f'");
        this.expr("E'\\Apache Calcite'").ok("_UTF16'\\Apache Calcite'");
        this.expr("E'a'").ok("_UTF16'a'");
        this.expr("E'aaa'").ok("_UTF16'aaa'");
        this.expr("E'a1'").ok("_UTF16'a1'");
        this.expr("E'\\x61'").ok("_UTF16'a'");
        this.expr("E'\\x61\\x61\\x61'").ok("_UTF16'aaa'");
        this.expr("E'\\x61\\x61\\x61'").ok("_UTF16'aaa'");
        this.expr("E'\\xDg0000'").ok("_UTF16'\rg0000'");
        this.expr("E'\\u0061'").ok("_UTF16'a'");
        this.expr("E'\\u0061\\u0061\\u0061'").ok("_UTF16'aaa'");
        this.expr("E'\\U00000061'").ok("_UTF16'a'");
        this.expr("E'\\U00000061\\U00000061\\U00000061'").ok("_UTF16'aaa'");
        this.expr("E'\\0'").ok("_UTF16'\u0000'");
        this.expr("E'\\07'").ok("_UTF16'\u0007'");
        this.expr("E'\\07'").ok("_UTF16'\u0007'");
        this.expr("E'a\\'a\\'a\\''").ok("_UTF16'a''a''a'''");
        this.expr("E'a''a''a'''").ok("_UTF16'a''a''a'''");
        this.expr("E^'\\'^").fails("(?s).*Encountered .*");
        this.expr("E^'a\\'^").fails("(?s).*Encountered.*");
        this.expr("E'a\\''^a^'").fails("(?s).*Encountered.*");
        this.expr("^E'A\\U0061'^").fails(Static.RESOURCE.unicodeEscapeMalformed(1).str());
        this.expr("^E'AB\\U0000006G'^").fails(Static.RESOURCE.unicodeEscapeMalformed(2).str());
    }

    @Test
    void testReverseSolidus() {
        this.expr("'\\'").same();
    }

    @Test
    void testSubstring() {
        this.expr("substring('a'\nFROM \t  1)").ok("SUBSTRING('a', 1)");
        this.expr("substring('a' FROM 1 FOR 3)").ok("SUBSTRING('a', 1, 3)");
        this.expr("substring('a' FROM 'reg' FOR '\\')").ok("SUBSTRING('a', 'reg', '\\')");
        this.expr("substring('a', 'reg', '\\')").ok("SUBSTRING('a', 'reg', '\\')");
        this.expr("substring('a', 1, 2)").ok("SUBSTRING('a', 1, 2)");
        this.expr("substring('a' , 1)").ok("SUBSTRING('a', 1)");
    }

    @Test
    void testFunction() {
        this.sql("select substring('Eggs and ham', 1, 3 + 2) || ' benedict' from emp").ok("SELECT (SUBSTRING('Eggs and ham', 1, (3 + 2)) || ' benedict')\nFROM `EMP`");
        this.expr("log10(1)\r\n+power(2, mod(\r\n3\n\t\t\f\n,ln(4))*log10(5)-6*log10(7/abs(8)+9))*power(10,11)").ok("(LOG10(1) + (POWER(2, ((MOD(3, LN(4)) * LOG10(5)) - (6 * LOG10(((7 / ABS(8)) + 9))))) * POWER(10, 11)))");
    }

    @Test
    void testFunctionWithDistinct() {
        this.expr("count(DISTINCT 1)").ok("COUNT(DISTINCT 1)");
        this.expr("count(ALL 1)").ok("COUNT(ALL 1)");
        this.expr("count(1)").ok("COUNT(1)");
        this.sql("select count(1), count(distinct 2) from emp").ok("SELECT COUNT(1), COUNT(DISTINCT 2)\nFROM `EMP`");
    }

    @Test
    void testFunctionCallWithDot() {
        this.expr("foo(a,b).c").ok("(`FOO`(`A`, `B`).`C`)");
    }

    @Test
    void testFunctionInFunction() {
        this.expr("ln(power(2,2))").ok("LN(POWER(2, 2))");
    }

    @Test
    void testFunctionNamedArgument() {
        this.expr("foo(x => 1)").ok("`FOO`(`X` => 1)");
        this.expr("foo(x => 1, \"y\" => 'a', z => x <= y)").ok("`FOO`(`X` => 1, `y` => 'a', `Z` => (`X` <= `Y`))");
        this.expr("foo(x.y ^=>^ 1)").fails("(?s).*Encountered \"=>\" at .*");
        this.expr("foo(a => 1, x.y ^=>^ 2, c => 3)").fails("(?s).*Encountered \"=>\" at .*");
    }

    @Test
    void testFunctionDefaultArgument() {
        this.sql("foo(1, DEFAULT, default, 'default', \"default\", 3)").expression().ok("`FOO`(1, DEFAULT, DEFAULT, 'default', `default`, 3)");
        this.sql("foo(DEFAULT)").expression().ok("`FOO`(DEFAULT)");
        this.sql("foo(x => 1, DEFAULT)").expression().ok("`FOO`(`X` => 1, DEFAULT)");
        this.sql("foo(y => DEFAULT, x => 1)").expression().ok("`FOO`(`Y` => DEFAULT, `X` => 1)");
        this.sql("foo(x => 1, y => DEFAULT)").expression().ok("`FOO`(`X` => 1, `Y` => DEFAULT)");
        this.sql("select sum(DISTINCT DEFAULT) from t group by x").ok("SELECT SUM(DISTINCT DEFAULT)\nFROM `T`\nGROUP BY `X`");
        this.expr("foo(x ^+^ DEFAULT)").fails("(?s).*Encountered \"\\+ DEFAULT\" at .*");
        this.expr("foo(0, x ^+^ DEFAULT + y)").fails("(?s).*Encountered \"\\+ DEFAULT\" at .*");
        this.expr("foo(0, DEFAULT ^+^ y)").fails("(?s).*Encountered \"\\+\" at .*");
    }

    @Test
    void testDefault() {
        this.sql("select ^DEFAULT^ from emp").fails("(?s)Incorrect syntax near the keyword 'DEFAULT' at .*");
        this.sql("select cast(empno ^+^ DEFAULT as double) from emp").fails("(?s)Encountered \"\\+ DEFAULT\" at .*");
        this.sql("select empno ^+^ DEFAULT + deptno from emp").fails("(?s)Encountered \"\\+ DEFAULT\" at .*");
        this.sql("select power(0, DEFAULT ^+^ empno) from emp").fails("(?s)Encountered \"\\+\" at .*");
        this.sql("select * from emp join dept on ^DEFAULT^").fails("(?s)Incorrect syntax near the keyword 'DEFAULT' at .*");
        this.sql("select * from emp where empno ^>^ DEFAULT or deptno < 10").fails("(?s)Encountered \"> DEFAULT\" at .*");
        this.sql("select * from emp order by ^DEFAULT^ desc").fails("(?s)Incorrect syntax near the keyword 'DEFAULT' at .*");
        String expected = "INSERT INTO `DEPT` (`NAME`, `DEPTNO`)\nVALUES (ROW('a', DEFAULT))";
        this.sql("insert into dept (name, deptno) values ('a', DEFAULT)").ok("INSERT INTO `DEPT` (`NAME`, `DEPTNO`)\nVALUES (ROW('a', DEFAULT))");
        this.sql("insert into dept (name, deptno) values ('a', 1 ^+^ DEFAULT)").fails("(?s)Encountered \"\\+ DEFAULT\" at .*");
        this.sql("insert into dept (name, deptno) select 'a', ^DEFAULT^ from (values 0)").fails("(?s)Incorrect syntax near the keyword 'DEFAULT' at .*");
    }

    @Test
    void testAggregateFilter() {
        String sql = "select\n sum(sal) filter (where gender = 'F') as femaleSal,\n sum(sal) filter (where true) allSal,\n count(distinct deptno) filter (where (deptno < 40))\nfrom emp";
        String expected = "SELECT SUM(`SAL`) FILTER (WHERE (`GENDER` = 'F')) AS `FEMALESAL`, SUM(`SAL`) FILTER (WHERE TRUE) AS `ALLSAL`, COUNT(DISTINCT `DEPTNO`) FILTER (WHERE (`DEPTNO` < 40))\nFROM `EMP`";
        this.sql("select\n sum(sal) filter (where gender = 'F') as femaleSal,\n sum(sal) filter (where true) allSal,\n count(distinct deptno) filter (where (deptno < 40))\nfrom emp").ok("SELECT SUM(`SAL`) FILTER (WHERE (`GENDER` = 'F')) AS `FEMALESAL`, SUM(`SAL`) FILTER (WHERE TRUE) AS `ALLSAL`, COUNT(DISTINCT `DEPTNO`) FILTER (WHERE (`DEPTNO` < 40))\nFROM `EMP`");
    }

    @Test
    void testGroup() {
        this.sql("select deptno, min(foo) as x from emp group by deptno, gender").ok("SELECT `DEPTNO`, MIN(`FOO`) AS `X`\nFROM `EMP`\nGROUP BY `DEPTNO`, `GENDER`");
    }

    @Test
    void testGroupEmpty() {
        this.sql("select count(*) from emp group by ()").ok("SELECT COUNT(*)\nFROM `EMP`\nGROUP BY ()");
        this.sql("select count(*) from emp group by () having 1 = 2 order by 3").ok("SELECT COUNT(*)\nFROM `EMP`\nGROUP BY ()\nHAVING (1 = 2)\nORDER BY 3");
        this.sql("select 1 from emp group by (), x").ok("SELECT 1\nFROM `EMP`\nGROUP BY (), `X`");
        this.sql("select 1 from emp group by x, ()").ok("SELECT 1\nFROM `EMP`\nGROUP BY `X`, ()");
        this.sql("select 1 from emp group by (empno + deptno)").ok("SELECT 1\nFROM `EMP`\nGROUP BY (`EMPNO` + `DEPTNO`)");
    }

    @Test
    void testHavingAfterGroup() {
        String sql = "select deptno from emp group by deptno, emp\nhaving count(*) > 5 and 1 = 2 order by 5, 2";
        String expected = "SELECT `DEPTNO`\nFROM `EMP`\nGROUP BY `DEPTNO`, `EMP`\nHAVING ((COUNT(*) > 5) AND (1 = 2))\nORDER BY 5, 2";
        this.sql("select deptno from emp group by deptno, emp\nhaving count(*) > 5 and 1 = 2 order by 5, 2").ok("SELECT `DEPTNO`\nFROM `EMP`\nGROUP BY `DEPTNO`, `EMP`\nHAVING ((COUNT(*) > 5) AND (1 = 2))\nORDER BY 5, 2");
    }

    @Test
    void testHavingBeforeGroupFails() {
        String sql = "select deptno from emp\nhaving count(*) > 5 and deptno < 4 ^group^ by deptno, emp";
        this.sql("select deptno from emp\nhaving count(*) > 5 and deptno < 4 ^group^ by deptno, emp").fails("(?s).*Encountered \"group\" at .*");
    }

    @Test
    void testHavingNoGroup() {
        this.sql("select deptno from emp having count(*) > 5").ok("SELECT `DEPTNO`\nFROM `EMP`\nHAVING (COUNT(*) > 5)");
    }

    @Test
    void testGroupingSets() {
        this.sql("select deptno from emp\ngroup by grouping sets (deptno, (deptno, gender), ())").ok("SELECT `DEPTNO`\nFROM `EMP`\nGROUP BY GROUPING SETS(`DEPTNO`, (`DEPTNO`, `GENDER`), ())");
        this.sql("select deptno from emp\ngroup by grouping sets ((deptno, gender), (deptno), (), gender)").ok("SELECT `DEPTNO`\nFROM `EMP`\nGROUP BY GROUPING SETS((`DEPTNO`, `GENDER`), `DEPTNO`, (), `GENDER`)");
        this.sql("select deptno from emp\ngroup by grouping sets ^deptno^, (deptno, gender), ()").fails("(?s).*Encountered \"deptno\" at line 2, column 24.\nWas expecting:\n    \"\\(\" .*");
        this.sql("select deptno from emp\ngroup by grouping sets (deptno, grouping sets (e, d), (),\n  cube (x, y), rollup(p, q))\norder by a").ok("SELECT `DEPTNO`\nFROM `EMP`\nGROUP BY GROUPING SETS(`DEPTNO`, GROUPING SETS(`E`, `D`), (), CUBE(`X`, `Y`), ROLLUP(`P`, `Q`))\nORDER BY `A`");
        this.sql("select deptno from emp\ngroup by grouping sets (())").ok("SELECT `DEPTNO`\nFROM `EMP`\nGROUP BY GROUPING SETS(())");
    }

    @Test
    void testGroupByCube() {
        String sql = "select deptno from emp\ngroup by cube ((a, b), (c, d))";
        String expected = "SELECT `DEPTNO`\nFROM `EMP`\nGROUP BY CUBE((`A`, `B`), (`C`, `D`))";
        this.sql("select deptno from emp\ngroup by cube ((a, b), (c, d))").ok("SELECT `DEPTNO`\nFROM `EMP`\nGROUP BY CUBE((`A`, `B`), (`C`, `D`))");
    }

    @Test
    void testGroupByAllOrDistinct() {
        String sql = "select deptno from emp\ngroup by all cube (a, b), rollup (a, b)";
        String expected = "SELECT `DEPTNO`\nFROM `EMP`\nGROUP BY CUBE(`A`, `B`), ROLLUP(`A`, `B`)";
        this.sql("select deptno from emp\ngroup by all cube (a, b), rollup (a, b)").ok("SELECT `DEPTNO`\nFROM `EMP`\nGROUP BY CUBE(`A`, `B`), ROLLUP(`A`, `B`)");
        String sql1 = "select deptno from emp\ngroup by distinct cube (a, b), rollup (a, b)";
        String expected1 = "SELECT `DEPTNO`\nFROM `EMP`\nGROUP BY DISTINCT CUBE(`A`, `B`), ROLLUP(`A`, `B`)";
        this.sql("select deptno from emp\ngroup by distinct cube (a, b), rollup (a, b)").ok("SELECT `DEPTNO`\nFROM `EMP`\nGROUP BY DISTINCT CUBE(`A`, `B`), ROLLUP(`A`, `B`)");
        String sql2 = "select deptno from emp\ngroup by cube (a, b), rollup (a, b)";
        String expected2 = "SELECT `DEPTNO`\nFROM `EMP`\nGROUP BY CUBE(`A`, `B`), ROLLUP(`A`, `B`)";
        this.sql("select deptno from emp\ngroup by cube (a, b), rollup (a, b)").ok("SELECT `DEPTNO`\nFROM `EMP`\nGROUP BY CUBE(`A`, `B`), ROLLUP(`A`, `B`)");
    }

    @Test
    void testGroupByCube2() {
        String sql = "select deptno from emp\ngroup by cube ((a, b), (c, d)) order by a";
        String expected = "SELECT `DEPTNO`\nFROM `EMP`\nGROUP BY CUBE((`A`, `B`), (`C`, `D`))\nORDER BY `A`";
        this.sql("select deptno from emp\ngroup by cube ((a, b), (c, d)) order by a").ok("SELECT `DEPTNO`\nFROM `EMP`\nGROUP BY CUBE((`A`, `B`), (`C`, `D`))\nORDER BY `A`");
        String sql2 = "select deptno from emp\ngroup by cube (^)";
        this.sql("select deptno from emp\ngroup by cube (^)").fails("(?s)Encountered \"\\)\" at .*");
    }

    @Test
    void testGroupByRollup() {
        String sql = "select deptno from emp\ngroup by rollup (deptno, deptno + 1, gender)";
        String expected = "SELECT `DEPTNO`\nFROM `EMP`\nGROUP BY ROLLUP(`DEPTNO`, (`DEPTNO` + 1), `GENDER`)";
        this.sql("select deptno from emp\ngroup by rollup (deptno, deptno + 1, gender)").ok("SELECT `DEPTNO`\nFROM `EMP`\nGROUP BY ROLLUP(`DEPTNO`, (`DEPTNO` + 1), `GENDER`)");
        String sql1 = "select deptno from emp\ngroup by rollup (deptno^, rollup(e, d))";
        this.sql("select deptno from emp\ngroup by rollup (deptno^, rollup(e, d))").fails("(?s)Encountered \", rollup\" at .*");
    }

    @Test
    void testGrouping() {
        String sql = "select deptno, grouping(deptno) from emp\ngroup by grouping sets (deptno, (deptno, gender), ())";
        String expected = "SELECT `DEPTNO`, GROUPING(`DEPTNO`)\nFROM `EMP`\nGROUP BY GROUPING SETS(`DEPTNO`, (`DEPTNO`, `GENDER`), ())";
        this.sql("select deptno, grouping(deptno) from emp\ngroup by grouping sets (deptno, (deptno, gender), ())").ok("SELECT `DEPTNO`, GROUPING(`DEPTNO`)\nFROM `EMP`\nGROUP BY GROUPING SETS(`DEPTNO`, (`DEPTNO`, `GENDER`), ())");
    }

    @Test
    void testWithRecursive() {
        String sql = "WITH RECURSIVE aux(i) AS (\n  VALUES (1)\n  UNION ALL\n  SELECT i+1 FROM aux WHERE i < 10\n  )\n  SELECT * FROM aux";
        String expected = "WITH RECURSIVE `AUX` (`I`) AS ((VALUES (ROW(1)))\nUNION ALL\nSELECT (`I` + 1)\nFROM `AUX`\nWHERE (`I` < 10)) SELECT *\nFROM `AUX`";
        this.sql("WITH RECURSIVE aux(i) AS (\n  VALUES (1)\n  UNION ALL\n  SELECT i+1 FROM aux WHERE i < 10\n  )\n  SELECT * FROM aux").ok("WITH RECURSIVE `AUX` (`I`) AS ((VALUES (ROW(1)))\nUNION ALL\nSELECT (`I` + 1)\nFROM `AUX`\nWHERE (`I` < 10)) SELECT *\nFROM `AUX`");
    }

    @Test
    void testMultipleWithRecursive() {
        String sql = "WITH RECURSIVE a(x) AS\n  (SELECT 1),\n               b(y) AS\n  (SELECT x\n   FROM a\n   UNION ALL SELECT y + 1\n   FROM b\n   WHERE y < 2),\n               c(z) AS\n  (SELECT y\n   FROM b\n   UNION ALL SELECT z * 4\n   FROM c\n   WHERE z < 4 )\nSELECT *\nFROM a,\n     b,\n     c";
        String expected = "WITH RECURSIVE `A` (`X`) AS (SELECT 1), `B` (`Y`) AS (SELECT `X`\nFROM `A`\nUNION ALL\nSELECT (`Y` + 1)\nFROM `B`\nWHERE (`Y` < 2)), `C` (`Z`) AS (SELECT `Y`\nFROM `B`\nUNION ALL\nSELECT (`Z` * 4)\nFROM `C`\nWHERE (`Z` < 4)) SELECT *\nFROM `A`,\n`B`,\n`C`";
        this.sql("WITH RECURSIVE a(x) AS\n  (SELECT 1),\n               b(y) AS\n  (SELECT x\n   FROM a\n   UNION ALL SELECT y + 1\n   FROM b\n   WHERE y < 2),\n               c(z) AS\n  (SELECT y\n   FROM b\n   UNION ALL SELECT z * 4\n   FROM c\n   WHERE z < 4 )\nSELECT *\nFROM a,\n     b,\n     c").ok("WITH RECURSIVE `A` (`X`) AS (SELECT 1), `B` (`Y`) AS (SELECT `X`\nFROM `A`\nUNION ALL\nSELECT (`Y` + 1)\nFROM `B`\nWHERE (`Y` < 2)), `C` (`Z`) AS (SELECT `Y`\nFROM `B`\nUNION ALL\nSELECT (`Z` * 4)\nFROM `C`\nWHERE (`Z` < 4)) SELECT *\nFROM `A`,\n`B`,\n`C`");
    }

    @Test
    void testWith() {
        String sql = "with femaleEmps as (select * from emps where gender = 'F')select deptno from femaleEmps";
        String expected = "WITH `FEMALEEMPS` AS (SELECT *\nFROM `EMPS`\nWHERE (`GENDER` = 'F')) SELECT `DEPTNO`\nFROM `FEMALEEMPS`";
        this.sql("with femaleEmps as (select * from emps where gender = 'F')select deptno from femaleEmps").ok("WITH `FEMALEEMPS` AS (SELECT *\nFROM `EMPS`\nWHERE (`GENDER` = 'F')) SELECT `DEPTNO`\nFROM `FEMALEEMPS`");
    }

    @Test
    void testWith2() {
        String sql = "with femaleEmps as (select * from emps where gender = 'F'),\nmarriedFemaleEmps(x, y) as (select * from femaleEmps where maritaStatus = 'M')\nselect deptno from femaleEmps";
        String expected = "WITH `FEMALEEMPS` AS (SELECT *\nFROM `EMPS`\nWHERE (`GENDER` = 'F')), `MARRIEDFEMALEEMPS` (`X`, `Y`) AS (SELECT *\nFROM `FEMALEEMPS`\nWHERE (`MARITASTATUS` = 'M')) SELECT `DEPTNO`\nFROM `FEMALEEMPS`";
        this.sql("with femaleEmps as (select * from emps where gender = 'F'),\nmarriedFemaleEmps(x, y) as (select * from femaleEmps where maritaStatus = 'M')\nselect deptno from femaleEmps").ok("WITH `FEMALEEMPS` AS (SELECT *\nFROM `EMPS`\nWHERE (`GENDER` = 'F')), `MARRIEDFEMALEEMPS` (`X`, `Y`) AS (SELECT *\nFROM `FEMALEEMPS`\nWHERE (`MARITASTATUS` = 'M')) SELECT `DEPTNO`\nFROM `FEMALEEMPS`");
    }

    @Test
    void testWithFails() {
        String sql = "with femaleEmps as ^select^ *\nfrom emps where gender = 'F'\nselect deptno from femaleEmps";
        this.sql("with femaleEmps as ^select^ *\nfrom emps where gender = 'F'\nselect deptno from femaleEmps").fails("(?s)Encountered \"select\" at .*");
    }

    @Test
    void testWithValues() {
        String sql = "with v(i,c) as (values (1, 'a'), (2, 'bb'))\nselect c, i from v";
        String expected = "WITH `V` (`I`, `C`) AS (VALUES (ROW(1, 'a')),\n(ROW(2, 'bb'))) SELECT `C`, `I`\nFROM `V`";
        this.sql("with v(i,c) as (values (1, 'a'), (2, 'bb'))\nselect c, i from v").ok("WITH `V` (`I`, `C`) AS (VALUES (ROW(1, 'a')),\n(ROW(2, 'bb'))) SELECT `C`, `I`\nFROM `V`");
    }

    @Test
    void testWithNestedFails() {
        String sql = "with emp2 as (select * from emp)\n^with^ dept2 as (select * from dept)\nselect 1 as uno from emp, dept";
        this.sql("with emp2 as (select * from emp)\n^with^ dept2 as (select * from dept)\nselect 1 as uno from emp, dept").fails("(?s)Encountered \"with\" at .*");
    }

    @Test
    void testWithSelect() {
        String sql = "with emp2 as (select * from emp)\nselect * from emp2\n";
        String expected = "WITH `EMP2` AS (SELECT *\nFROM `EMP`) SELECT *\nFROM `EMP2`";
        this.sql("with emp2 as (select * from emp)\nselect * from emp2\n").ok("WITH `EMP2` AS (SELECT *\nFROM `EMP`) SELECT *\nFROM `EMP2`");
    }

    @Test
    void testWithOrderBy() {
        String sql = "with emp2 as (select * from emp)\nselect * from emp2 order by deptno\n";
        String expected = "WITH `EMP2` AS (SELECT *\nFROM `EMP`) SELECT *\nFROM `EMP2`\nORDER BY `DEPTNO`";
        this.sql("with emp2 as (select * from emp)\nselect * from emp2 order by deptno\n").ok("WITH `EMP2` AS (SELECT *\nFROM `EMP`) SELECT *\nFROM `EMP2`\nORDER BY `DEPTNO`");
    }

    @Test
    void testWithNestedInSubQuery() {
        String sql = "with emp2 as (select * from emp)\n(\n  with dept2 as (select * from dept)\n  select 1 as uno from empDept)";
        String expected = "WITH `EMP2` AS (SELECT *\nFROM `EMP`) (WITH `DEPT2` AS (SELECT *\nFROM `DEPT`) SELECT 1 AS `UNO`\nFROM `EMPDEPT`)";
        this.sql("with emp2 as (select * from emp)\n(\n  with dept2 as (select * from dept)\n  select 1 as uno from empDept)").ok("WITH `EMP2` AS (SELECT *\nFROM `EMP`) (WITH `DEPT2` AS (SELECT *\nFROM `DEPT`) SELECT 1 AS `UNO`\nFROM `EMPDEPT`)");
    }

    @Test
    void testWithUnion() {
        String sql = "with emp2 as (select * from emp)\nselect * from emp2\nunion\nselect * from emp2\n";
        String expected = "WITH `EMP2` AS (SELECT *\nFROM `EMP`) SELECT *\nFROM `EMP2`\nUNION\nSELECT *\nFROM `EMP2`";
        this.sql("with emp2 as (select * from emp)\nselect * from emp2\nunion\nselect * from emp2\n").ok("WITH `EMP2` AS (SELECT *\nFROM `EMP`) SELECT *\nFROM `EMP2`\nUNION\nSELECT *\nFROM `EMP2`");
    }

    @Test
    void testWithAsUnion() {
        String sql = "with emp2 as (select * from emp union select * from emp)\nselect * from emp2\n";
        String expected = "WITH `EMP2` AS (SELECT *\nFROM `EMP`\nUNION\nSELECT *\nFROM `EMP`) SELECT *\nFROM `EMP2`";
        this.sql("with emp2 as (select * from emp union select * from emp)\nselect * from emp2\n").ok("WITH `EMP2` AS (SELECT *\nFROM `EMP`\nUNION\nSELECT *\nFROM `EMP`) SELECT *\nFROM `EMP2`");
    }

    @Test
    void testWithAsOrderBy() {
        String sql = "with emp2 as (select * from emp order by deptno)\nselect * from emp2\n";
        String expected = "WITH `EMP2` AS (SELECT *\nFROM `EMP`\nORDER BY `DEPTNO`) SELECT *\nFROM `EMP2`";
        this.sql("with emp2 as (select * from emp order by deptno)\nselect * from emp2\n").ok("WITH `EMP2` AS (SELECT *\nFROM `EMP`\nORDER BY `DEPTNO`) SELECT *\nFROM `EMP2`");
    }

    @Test
    void testWithAsJoin() {
        String sql = "with emp2 as (select * from emp e1 join emp e2 on e1.deptno = e2.deptno)\nselect * from emp2\n";
        String expected = "WITH `EMP2` AS (SELECT *\nFROM `EMP` AS `E1`\nINNER JOIN `EMP` AS `E2` ON (`E1`.`DEPTNO` = `E2`.`DEPTNO`)) SELECT *\nFROM `EMP2`";
        this.sql("with emp2 as (select * from emp e1 join emp e2 on e1.deptno = e2.deptno)\nselect * from emp2\n").ok("WITH `EMP2` AS (SELECT *\nFROM `EMP` AS `E1`\nINNER JOIN `EMP` AS `E2` ON (`E1`.`DEPTNO` = `E2`.`DEPTNO`)) SELECT *\nFROM `EMP2`");
    }

    @Test
    void testWithAsNestedInSubQuery() {
        String sql = "with emp3 as (with emp2 as (select * from emp) select * from emp2)\nselect * from emp3\n";
        String expected = "WITH `EMP3` AS (WITH `EMP2` AS (SELECT *\nFROM `EMP`) SELECT *\nFROM `EMP2`) SELECT *\nFROM `EMP3`";
        this.sql("with emp3 as (with emp2 as (select * from emp) select * from emp2)\nselect * from emp3\n").ok("WITH `EMP3` AS (WITH `EMP2` AS (SELECT *\nFROM `EMP`) SELECT *\nFROM `EMP2`) SELECT *\nFROM `EMP3`");
    }

    @Test
    void testIdentifier() {
        this.expr("ab").ok("`AB`");
        this.expr("     \"a  \"\" b!c\"").ok("`a  \" b!c`");
        this.expr("     ^`^a  \" b!c`").fails("(?s).*Encountered.*");
        this.expr("\"x`y`z\"").ok("`x``y``z`");
        this.expr("^`^x`y`z`").fails("(?s).*Encountered.*");
        this.expr("myMap[field] + myArray[1 + 2]").ok("(`MYMAP`[`FIELD`] + `MYARRAY`[(1 + 2)])");
        this.sql("VALUES a").node(SqlParserTest.isQuoted(0, false));
        this.sql("VALUES \"a\"").node(SqlParserTest.isQuoted(0, true));
        this.sql("VALUES \"a\".\"b\"").node(SqlParserTest.isQuoted(1, true));
        this.sql("VALUES \"a\".b").node(SqlParserTest.isQuoted(1, false));
    }

    @Test
    void testBackTickIdentifier() {
        SqlParserFixture f = this.fixture().withConfig(c -> c.withQuoting(Quoting.BACK_TICK)).expression();
        f.sql("ab").ok("`AB`");
        f.sql("     `a  \" b!c`").ok("`a  \" b!c`");
        f.sql("     ^\"^a  \"\" b!c\"").fails("(?s).*Encountered.*");
        f.sql("^\"^x`y`z\"").fails("(?s).*Encountered.*");
        f.sql("`x``y``z`").same();
        f.sql("`x\\`^y^\\`z`").fails("(?s).*Encountered.*");
        f.sql("myMap[field] + myArray[1 + 2]").ok("(`MYMAP`[`FIELD`] + `MYARRAY`[(1 + 2)])");
        f = f.expression(false);
        f.sql("VALUES a").node(SqlParserTest.isQuoted(0, false));
        f.sql("VALUES `a`").node(SqlParserTest.isQuoted(0, true));
        f.sql("VALUES `a``b`").node(SqlParserTest.isQuoted(0, true));
    }

    @Test
    void testBackTickBackslashIdentifier() {
        SqlParserFixture f = this.fixture().withConfig(c -> c.withQuoting(Quoting.BACK_TICK_BACKSLASH)).expression();
        f.sql("ab").ok("`AB`");
        f.sql("     `a  \" b!c`").ok("`a  \" b!c`");
        f.sql("     \"a  \"^\" b!c\"^").fails("(?s).*Encountered.*");
        f.sql("^\"^x`y`z\"").ok("'x`y`z'");
        f.sql("`x`^`y`^`z`").fails("(?s).*Encountered.*");
        f.sql("`x\\`y\\`z`").ok("`x``y``z`");
        f.sql("myMap[field] + myArray[1 + 2]").ok("(`MYMAP`[`FIELD`] + `MYARRAY`[(1 + 2)])");
        f = f.expression(false);
        f.sql("VALUES a").node(SqlParserTest.isQuoted(0, false));
        f.sql("VALUES `a`").node(SqlParserTest.isQuoted(0, true));
        f.sql("VALUES `a\\`b`").node(SqlParserTest.isQuoted(0, true));
    }

    @Test
    void testBracketIdentifier() {
        SqlParserFixture f = this.fixture().withConfig(c -> c.withQuoting(Quoting.BRACKET)).expression();
        f.sql("ab").ok("`AB`");
        f.sql("     [a  \" b!c]").ok("`a  \" b!c`");
        f.sql("     ^`^a  \" b!c`").fails("(?s).*Encountered.*");
        f.sql("     ^\"^a  \"\" b!c\"").fails("(?s).*Encountered.*");
        f.sql("[x`y`z]").ok("`x``y``z`");
        f.sql("^\"^x`y`z\"").fails("(?s).*Encountered.*");
        f.sql("^`^x``y``z`").fails("(?s).*Encountered.*");
        f.sql("[anything [even brackets]] is].[ok]").ok("`anything [even brackets] is`.`ok`");
        f = f.expression(false);
        f.sql("select * from myMap[field], myArray[1 + 2]").ok("SELECT *\nFROM `MYMAP` AS `field`,\n`MYARRAY` AS `1 + 2`");
        f.sql("select * from myMap [field], myArray [1 + 2]").ok("SELECT *\nFROM `MYMAP` AS `field`,\n`MYARRAY` AS `1 + 2`");
        f.sql("VALUES a").node(SqlParserTest.isQuoted(0, false));
        f.sql("VALUES [a]").node(SqlParserTest.isQuoted(0, true));
    }

    @Test
    void testBackTickQuery() {
        this.sql("select `x`.`b baz` from `emp` as `x` where `x`.deptno in (10, 20)").withConfig(c -> c.withQuoting(Quoting.BACK_TICK)).ok("SELECT `x`.`b baz`\nFROM `emp` AS `x`\nWHERE (`x`.`DEPTNO` IN (10, 20))");
    }

    @Test
    void testSingleQuotedAlias() {
        String expectingAlias = "Expecting alias, found character literal";
        String sql1 = "select 1 as ^'a b'^ from t";
        this.sql("select 1 as ^'a b'^ from t").withConformance((SqlConformance)SqlConformanceEnum.DEFAULT).fails("Expecting alias, found character literal");
        String sql1b = "SELECT 1 AS `a b`\nFROM `T`";
        this.sql("select 1 as ^'a b'^ from t").withConformance((SqlConformance)SqlConformanceEnum.MYSQL_5).ok("SELECT 1 AS `a b`\nFROM `T`");
        this.sql("select 1 as ^'a b'^ from t").withConformance((SqlConformance)SqlConformanceEnum.BIG_QUERY).ok("SELECT 1 AS `a b`\nFROM `T`");
        this.sql("select 1 as ^'a b'^ from t").withConformance((SqlConformance)SqlConformanceEnum.SQL_SERVER_2008).ok("SELECT 1 AS `a b`\nFROM `T`");
        String sql2 = "with t as (select 1 as ^'x''y'^)\nselect [x'y] from t as [u]";
        SqlParserFixture f2 = this.sql("with t as (select 1 as ^'x''y'^)\nselect [x'y] from t as [u]").withConfig(c -> c.withQuoting(Quoting.BRACKET).withConformance((SqlConformance)SqlConformanceEnum.DEFAULT));
        f2.fails("Expecting alias, found character literal");
        String sql2b = "WITH `T` AS (SELECT 1 AS `x'y`) SELECT `x'y`\nFROM `T` AS `u`";
        f2.withConformance((SqlConformance)SqlConformanceEnum.MYSQL_5).ok("WITH `T` AS (SELECT 1 AS `x'y`) SELECT `x'y`\nFROM `T` AS `u`");
        f2.withConformance((SqlConformance)SqlConformanceEnum.BIG_QUERY).ok("WITH `T` AS (SELECT 1 AS `x'y`) SELECT `x'y`\nFROM `T` AS `u`");
        f2.withConformance((SqlConformance)SqlConformanceEnum.SQL_SERVER_2008).ok("WITH `T` AS (SELECT 1 AS `x'y`) SELECT `x'y`\nFROM `T` AS `u`");
        String sql3 = "with [t] as (select 1 as [x]) select [x] from [t]";
        String sql3b = "WITH `t` AS (SELECT 1 AS `x`) SELECT `x`\nFROM `t`";
        SqlParserFixture f3 = this.sql("with [t] as (select 1 as [x]) select [x] from [t]").withConfig(c -> c.withQuoting(Quoting.BRACKET).withConformance((SqlConformance)SqlConformanceEnum.DEFAULT));
        f3.ok("WITH `t` AS (SELECT 1 AS `x`) SELECT `x`\nFROM `t`");
        f3.withConformance((SqlConformance)SqlConformanceEnum.MYSQL_5).ok("WITH `t` AS (SELECT 1 AS `x`) SELECT `x`\nFROM `t`");
        f3.withConformance((SqlConformance)SqlConformanceEnum.BIG_QUERY).ok("WITH `t` AS (SELECT 1 AS `x`) SELECT `x`\nFROM `t`");
        f3.withConformance((SqlConformance)SqlConformanceEnum.SQL_SERVER_2008).ok("WITH `t` AS (SELECT 1 AS `x`) SELECT `x`\nFROM `t`");
        String sql4 = "with t as (select 1 as x) select x from t as ^'u'^";
        String sql4b = "(?s)Encountered \"\\\\'u\\\\'\" at .*";
        SqlParserFixture f4 = this.sql("with t as (select 1 as x) select x from t as ^'u'^").withConfig(c -> c.withQuoting(Quoting.BRACKET).withConformance((SqlConformance)SqlConformanceEnum.DEFAULT));
        f4.fails("(?s)Encountered \"\\\\'u\\\\'\" at .*");
        f4.withConformance((SqlConformance)SqlConformanceEnum.MYSQL_5).fails("(?s)Encountered \"\\\\'u\\\\'\" at .*");
        f4.withConformance((SqlConformance)SqlConformanceEnum.BIG_QUERY).fails("(?s)Encountered \"\\\\'u\\\\'\" at .*");
        f4.withConformance((SqlConformance)SqlConformanceEnum.SQL_SERVER_2008).fails("(?s)Encountered \"\\\\'u\\\\'\" at .*");
        String sql5 = "with t as (select 1 as x) select x from t ^'u'^";
        String sql5b = "(?s)Encountered \"\\\\'u\\\\'\" at .*";
        SqlParserFixture f5 = this.sql("with t as (select 1 as x) select x from t ^'u'^").withConfig(c -> c.withQuoting(Quoting.BRACKET).withConformance((SqlConformance)SqlConformanceEnum.DEFAULT));
        f5.fails("(?s)Encountered \"\\\\'u\\\\'\" at .*");
        f5.withConformance((SqlConformance)SqlConformanceEnum.MYSQL_5).fails("(?s)Encountered \"\\\\'u\\\\'\" at .*");
        f5.withConformance((SqlConformance)SqlConformanceEnum.BIG_QUERY).fails("(?s)Encountered \"\\\\'u\\\\'\" at .*");
        f5.withConformance((SqlConformance)SqlConformanceEnum.SQL_SERVER_2008).fails("(?s)Encountered \"\\\\'u\\\\'\" at .*");
    }

    @Test
    void testInList() {
        this.sql("select * from emp where deptno in (10, 20) and gender = 'F'").ok("SELECT *\nFROM `EMP`\nWHERE ((`DEPTNO` IN (10, 20)) AND (`GENDER` = 'F'))");
    }

    @Test
    void testInListEmptyFails() {
        this.sql("select * from emp where deptno in (^)^ and gender = 'F'").fails("(?s).*Encountered \"\\)\" at line 1, column 36\\..*");
    }

    @Test
    void testInQuery() {
        this.sql("select * from emp where deptno in (select deptno from dept)").ok("SELECT *\nFROM `EMP`\nWHERE (`DEPTNO` IN (SELECT `DEPTNO`\nFROM `DEPT`))");
    }

    @Test
    void testSomeEveryAndIntersectionAggQuery() {
        this.sql("select some(deptno = 10), every(deptno > 0), intersection(multiset[1,2]) from dept").ok("SELECT SOME((`DEPTNO` = 10)), EVERY((`DEPTNO` > 0)), INTERSECTION((MULTISET[1, 2]))\nFROM `DEPT`");
    }

    @Test
    void testInQueryWithComma() {
        this.sql("select * from emp where deptno in (select deptno from dept group by 1, 2)").ok("SELECT *\nFROM `EMP`\nWHERE (`DEPTNO` IN (SELECT `DEPTNO`\nFROM `DEPT`\nGROUP BY 1, 2))");
    }

    @Test
    void testInSetop() {
        this.sql("select * from emp where deptno in (\n(select deptno from dept union select * from dept)except\nselect * from dept) and false").ok("SELECT *\nFROM `EMP`\nWHERE ((`DEPTNO` IN (SELECT `DEPTNO`\nFROM `DEPT`\nUNION\nSELECT *\nFROM `DEPT`\nEXCEPT\nSELECT *\nFROM `DEPT`)) AND FALSE)");
    }

    @Test
    void testSome() {
        String sql = "select * from emp\nwhere sal > some (select comm from emp)";
        String expected = "SELECT *\nFROM `EMP`\nWHERE (`SAL` > SOME (SELECT `COMM`\nFROM `EMP`))";
        this.sql("select * from emp\nwhere sal > some (select comm from emp)").ok("SELECT *\nFROM `EMP`\nWHERE (`SAL` > SOME (SELECT `COMM`\nFROM `EMP`))");
        String sql2 = "select * from emp\nwhere sal > any (select comm from emp)";
        this.sql("select * from emp\nwhere sal > any (select comm from emp)").ok("SELECT *\nFROM `EMP`\nWHERE (`SAL` > SOME (SELECT `COMM`\nFROM `EMP`))");
        String sql3 = "select * from emp\nwhere name like (select ^some^ name from emp)";
        this.sql("select * from emp\nwhere name like (select ^some^ name from emp)").fails("(?s).*Encountered \"some name\" at .*");
        String sql4 = "select * from emp\nwhere name like some (select name from emp)";
        String expected4 = "SELECT *\nFROM `EMP`\nWHERE (`NAME` LIKE SOME((SELECT `NAME`\nFROM `EMP`)))";
        this.sql("select * from emp\nwhere name like some (select name from emp)").ok("SELECT *\nFROM `EMP`\nWHERE (`NAME` LIKE SOME((SELECT `NAME`\nFROM `EMP`)))");
        String sql5 = "select * from emp where empno = any (10,20)";
        String expected5 = "SELECT *\nFROM `EMP`\nWHERE (`EMPNO` = SOME (10, 20))";
        this.sql("select * from emp where empno = any (10,20)").ok("SELECT *\nFROM `EMP`\nWHERE (`EMPNO` = SOME (10, 20))");
    }

    @Test
    void testAll() {
        String sql = "select * from emp\nwhere sal <= all (select comm from emp) or sal > 10";
        String expected = "SELECT *\nFROM `EMP`\nWHERE ((`SAL` <= ALL (SELECT `COMM`\nFROM `EMP`)) OR (`SAL` > 10))";
        this.sql("select * from emp\nwhere sal <= all (select comm from emp) or sal > 10").ok("SELECT *\nFROM `EMP`\nWHERE ((`SAL` <= ALL (SELECT `COMM`\nFROM `EMP`)) OR (`SAL` > 10))");
    }

    @Test
    void testAllList() {
        String sql = "select * from emp\nwhere sal <= all (12, 20, 30)";
        String expected = "SELECT *\nFROM `EMP`\nWHERE (`SAL` <= ALL (12, 20, 30))";
        this.sql("select * from emp\nwhere sal <= all (12, 20, 30)").ok("SELECT *\nFROM `EMP`\nWHERE (`SAL` <= ALL (12, 20, 30))");
    }

    @Test
    void testUnion() {
        this.sql("select * from a union select * from a").ok("SELECT *\nFROM `A`\nUNION\nSELECT *\nFROM `A`");
        this.sql("select * from a union all select * from a").ok("SELECT *\nFROM `A`\nUNION ALL\nSELECT *\nFROM `A`");
        this.sql("select * from a union distinct select * from a").ok("SELECT *\nFROM `A`\nUNION\nSELECT *\nFROM `A`");
    }

    @Test
    void testUnionOrder() {
        this.sql("select a, b from t union all select x, y from u order by 1 asc, 2 desc").ok("SELECT `A`, `B`\nFROM `T`\nUNION ALL\nSELECT `X`, `Y`\nFROM `U`\nORDER BY 1, 2 DESC");
    }

    @Test
    void testOrderUnion() {
        this.sql("select a from t order by a\n^union^ all\nselect b from t order by b").fails("(?s).*Encountered \"union\" at .*");
    }

    @Test
    void testLimitUnion() {
        this.sql("select a from t limit 10\n^union^ all\nselect b from t order by b").fails("(?s).*Encountered \"union\" at .*");
    }

    @Test
    void testLimitUnion2() {
        String sql = "(select a from t limit 10)\nunion all\n(select b from t offset 20)";
        String expected = "(SELECT `A`\nFROM `T`\nFETCH NEXT 10 ROWS ONLY)\nUNION ALL\n(SELECT `B`\nFROM `T`\nOFFSET 20 ROWS)";
        this.sql("(select a from t limit 10)\nunion all\n(select b from t offset 20)").ok("(SELECT `A`\nFROM `T`\nFETCH NEXT 10 ROWS ONLY)\nUNION ALL\n(SELECT `B`\nFROM `T`\nOFFSET 20 ROWS)");
    }

    @Test
    void testUnionOffset() {
        String sql = "select a from t\nunion all\n(select b from t order by b offset 3 fetch next 5 rows only)";
        String expected = "SELECT `A`\nFROM `T`\nUNION ALL\n(SELECT `B`\nFROM `T`\nORDER BY `B`\nOFFSET 3 ROWS\nFETCH NEXT 5 ROWS ONLY)";
        this.sql("select a from t\nunion all\n(select b from t order by b offset 3 fetch next 5 rows only)").ok("SELECT `A`\nFROM `T`\nUNION ALL\n(SELECT `B`\nFROM `T`\nORDER BY `B`\nOFFSET 3 ROWS\nFETCH NEXT 5 ROWS ONLY)");
        String sql2 = "select a from t\nunion all\n(select b from t order by b)";
        String expected2 = "SELECT `A`\nFROM `T`\nUNION ALL\n(SELECT `B`\nFROM `T`\nORDER BY `B`)";
        this.sql("select a from t\nunion all\n(select b from t order by b)").ok("SELECT `A`\nFROM `T`\nUNION ALL\n(SELECT `B`\nFROM `T`\nORDER BY `B`)");
        String sql3 = "select a from t\nunion all\n(select b from t offset 3)";
        String expected3 = "SELECT `A`\nFROM `T`\nUNION ALL\n(SELECT `B`\nFROM `T`\nOFFSET 3 ROWS)";
        this.sql("select a from t\nunion all\n(select b from t offset 3)").ok("SELECT `A`\nFROM `T`\nUNION ALL\n(SELECT `B`\nFROM `T`\nOFFSET 3 ROWS)");
        String sql4 = "select a from t\nunion all\n(select b from t fetch next 5 rows only)";
        String expected4 = "SELECT `A`\nFROM `T`\nUNION ALL\n(SELECT `B`\nFROM `T`\nFETCH NEXT 5 ROWS ONLY)";
        this.sql("select a from t\nunion all\n(select b from t fetch next 5 rows only)").ok("SELECT `A`\nFROM `T`\nUNION ALL\n(SELECT `B`\nFROM `T`\nFETCH NEXT 5 ROWS ONLY)");
        String sql5 = "select a from t\nunion all\n(select b from t offset 3 fetch next 5 rows only)";
        String expected5 = "SELECT `A`\nFROM `T`\nUNION ALL\n(SELECT `B`\nFROM `T`\nOFFSET 3 ROWS\nFETCH NEXT 5 ROWS ONLY)";
        this.sql("select a from t\nunion all\n(select b from t offset 3 fetch next 5 rows only)").ok("SELECT `A`\nFROM `T`\nUNION ALL\n(SELECT `B`\nFROM `T`\nOFFSET 3 ROWS\nFETCH NEXT 5 ROWS ONLY)");
        String sql6 = "select a from t\nintersect\n(select b from t offset 3 fetch next 5 rows only)";
        String expected6 = "SELECT `A`\nFROM `T`\nINTERSECT\n(SELECT `B`\nFROM `T`\nOFFSET 3 ROWS\nFETCH NEXT 5 ROWS ONLY)";
        this.sql("select a from t\nintersect\n(select b from t offset 3 fetch next 5 rows only)").ok("SELECT `A`\nFROM `T`\nINTERSECT\n(SELECT `B`\nFROM `T`\nOFFSET 3 ROWS\nFETCH NEXT 5 ROWS ONLY)");
    }

    @Test
    void testUnionIntersect() {
        String sql = "(select * from a union select * from b)\nintersect select * from c";
        String expected = "(SELECT *\nFROM `A`\nUNION\nSELECT *\nFROM `B`)\nINTERSECT\nSELECT *\nFROM `C`";
        this.sql("(select * from a union select * from b)\nintersect select * from c").ok("(SELECT *\nFROM `A`\nUNION\nSELECT *\nFROM `B`)\nINTERSECT\nSELECT *\nFROM `C`");
    }

    @Test
    void testUnionOfNonQueryFails() {
        this.sql("select 1 from emp union ^2^ + 5").fails("Non-query expression encountered in illegal context");
    }

    @Test
    void testQueryInIllegalContext() {
        this.sql("select 0, multiset[^(^select * from emp), 2] from dept").fails("Query expression encountered in illegal context");
        this.sql("select 0, multiset[1, ^(^select * from emp), 2, 3] from dept").fails("Query expression encountered in illegal context");
    }

    @Test
    void testExcept() {
        this.sql("select * from a except select * from a").ok("SELECT *\nFROM `A`\nEXCEPT\nSELECT *\nFROM `A`");
        this.sql("select * from a except all select * from a").ok("SELECT *\nFROM `A`\nEXCEPT ALL\nSELECT *\nFROM `A`");
        this.sql("select * from a except distinct select * from a").ok("SELECT *\nFROM `A`\nEXCEPT\nSELECT *\nFROM `A`");
    }

    @Test
    void testSetMinus() {
        String pattern = "MINUS is not allowed under the current SQL conformance level";
        String sql = "select col1 from table1 ^MINUS^ select col1 from table2";
        this.sql("select col1 from table1 ^MINUS^ select col1 from table2").fails("MINUS is not allowed under the current SQL conformance level");
        String expected = "SELECT `COL1`\nFROM `TABLE1`\nEXCEPT\nSELECT `COL1`\nFROM `TABLE2`";
        this.sql("select col1 from table1 ^MINUS^ select col1 from table2").withConformance((SqlConformance)SqlConformanceEnum.ORACLE_10).ok("SELECT `COL1`\nFROM `TABLE1`\nEXCEPT\nSELECT `COL1`\nFROM `TABLE2`");
        String sql2 = "select col1 from table1 MINUS ALL select col1 from table2";
        String expected2 = "SELECT `COL1`\nFROM `TABLE1`\nEXCEPT ALL\nSELECT `COL1`\nFROM `TABLE2`";
        this.sql("select col1 from table1 MINUS ALL select col1 from table2").withConformance((SqlConformance)SqlConformanceEnum.ORACLE_10).ok("SELECT `COL1`\nFROM `TABLE1`\nEXCEPT ALL\nSELECT `COL1`\nFROM `TABLE2`");
    }

    @Test
    void testMinusIsReserved() {
        this.sql("select ^minus^ from t").fails("(?s).*Encountered \"minus\" at .*");
        this.sql("select ^minus^ select").fails("(?s).*Encountered \"minus\" at .*");
        this.sql("select * from t as ^minus^ where x < y").fails("(?s).*Encountered \"minus\" at .*");
    }

    @Test
    void testIntersect() {
        this.sql("select * from a intersect select * from a").ok("SELECT *\nFROM `A`\nINTERSECT\nSELECT *\nFROM `A`");
        this.sql("select * from a intersect all select * from a").ok("SELECT *\nFROM `A`\nINTERSECT ALL\nSELECT *\nFROM `A`");
        this.sql("select * from a intersect distinct select * from a").ok("SELECT *\nFROM `A`\nINTERSECT\nSELECT *\nFROM `A`");
    }

    @Test
    void testJoinCross() {
        this.sql("select * from a as a2 cross join b").ok("SELECT *\nFROM `A` AS `A2`\nCROSS JOIN `B`");
    }

    @Test
    void testJoinCrossComma() {
        this.sql("select * from a as a2, b cross join c").node(SqlParserTest.customMatches("custom", node -> {
            MatcherAssert.assertThat((Object)node, (Matcher)CoreMatchers.instanceOf(SqlSelect.class));
            SqlSelect select = (SqlSelect)node;
            MatcherAssert.assertThat((Object)select.getFrom(), (Matcher)CoreMatchers.instanceOf(SqlJoin.class));
            SqlJoin from = Objects.requireNonNull((SqlJoin)select.getFrom());
            MatcherAssert.assertThat((Object)from.getLeft(), (Matcher)CoreMatchers.instanceOf(SqlJoin.class));
            MatcherAssert.assertThat((Object)from.getRight(), (Matcher)CoreMatchers.instanceOf(SqlIdentifier.class));
        }));
    }

    @Test
    void testInternalComma() {
        this.sql("select * from (a^,^ b) cross join c").fails("(?s)Encountered \",\" at .*");
    }

    @Test
    void testJoinOn() {
        this.sql("select * from a left join b on 1 = 1 and 2 = 2 where 3 = 3").ok("SELECT *\nFROM `A`\nLEFT JOIN `B` ON ((1 = 1) AND (2 = 2))\nWHERE (3 = 3)");
    }

    @Test
    void testJoinOnParentheses() {
    }

    @Test
    void testJoinOnParenthesesPlus() {
    }

    @Test
    void testExplicitTableInJoin() {
        this.sql("select * from a left join (table b) on 2 = 2 where 3 = 3").ok("SELECT *\nFROM `A`\nLEFT JOIN (TABLE `B`) ON (2 = 2)\nWHERE (3 = 3)");
    }

    @Test
    void testSubQueryInJoin() {
    }

    @Test
    void testOuterJoinNoiseWord() {
        this.sql("select * from a left outer join b on 1 = 1 and 2 = 2 where 3 = 3").ok("SELECT *\nFROM `A`\nLEFT JOIN `B` ON ((1 = 1) AND (2 = 2))\nWHERE (3 = 3)");
    }

    @Test
    void testJoinQuery() {
        this.sql("select * from a join (select * from b) as b2 on true").ok("SELECT *\nFROM `A`\nINNER JOIN (SELECT *\nFROM `B`) AS `B2` ON TRUE");
    }

    @Test
    void testFullInnerJoinFails() {
        this.sql("select * from a ^full^ inner join b").fails("(?s).*Encountered \"full inner\" at line .*");
    }

    @Test
    void testFullOuterJoin() {
        this.sql("select * from a full outer join b").ok("SELECT *\nFROM `A`\nFULL JOIN `B`");
    }

    @Test
    void testInnerOuterJoinFails() {
        this.sql("select * from a ^inner^ outer join b").fails("(?s).*Encountered \"inner outer\" at line .*");
    }

    @Test
    void testJoinAssociativity() {
        String expected = "SELECT *\nFROM `A`\nNATURAL LEFT JOIN `B`\nLEFT JOIN `C` ON (`B`.`C1` = `C`.`C1`)";
        this.sql("select * from (a natural left join b) left join c on b.c1 = c.c1").ok(expected);
        String expected2 = "SELECT *\nFROM `A`\nNATURAL LEFT JOIN (`B` LEFT JOIN `C` ON (`B`.`C1` = `C`.`C1`))";
        this.sql("select * from a natural left join (b left join c on b.c1 = c.c1)").ok(expected2);
        this.sql("select * from a natural left join b left join c on b.c1 = c.c1").ok(expected);
        String sql4 = "select *\nfrom (a cross join b)\ncross join (c cross join d)";
        String expected4 = "SELECT *\nFROM `A`\nCROSS JOIN `B`\nCROSS JOIN (`C` CROSS JOIN `D`)";
        this.sql(sql4).ok(expected4);
    }

    @Test
    void testNaturalCrossJoin() {
        this.sql("select * from a natural cross join b").ok("SELECT *\nFROM `A`\nNATURAL CROSS JOIN `B`");
    }

    @Test
    void testJoinUsing() {
        this.sql("select * from a join b using (x)").ok("SELECT *\nFROM `A`\nINNER JOIN `B` USING (`X`)");
        this.sql("select * from a join b using (^)^ where c = d").fails("(?s).*Encountered \"[)]\" at line 1, column 31.*");
    }

    @Test
    void testApply() {
        String pattern = "APPLY operator is not allowed under the current SQL conformance level";
        String sql = "select * from dept\ncross apply table(ramp(deptno)) as t(a^)^";
        this.sql("select * from dept\ncross apply table(ramp(deptno)) as t(a^)^").fails("APPLY operator is not allowed under the current SQL conformance level");
        String expected = "SELECT *\nFROM `DEPT`\nCROSS JOIN LATERAL TABLE(`RAMP`(`DEPTNO`)) AS `T` (`A`)";
        this.sql("select * from dept\ncross apply table(ramp(deptno)) as t(a^)^").withConformance((SqlConformance)SqlConformanceEnum.SQL_SERVER_2008).ok("SELECT *\nFROM `DEPT`\nCROSS JOIN LATERAL TABLE(`RAMP`(`DEPTNO`)) AS `T` (`A`)");
        this.sql("select * from dept\ncross apply table(ramp(deptno)) as t(a^)^").withConformance((SqlConformance)SqlConformanceEnum.ORACLE_10).fails("APPLY operator is not allowed under the current SQL conformance level");
        this.sql("select * from dept\ncross apply table(ramp(deptno)) as t(a^)^").withConformance((SqlConformance)SqlConformanceEnum.ORACLE_12).ok("SELECT *\nFROM `DEPT`\nCROSS JOIN LATERAL TABLE(`RAMP`(`DEPTNO`)) AS `T` (`A`)");
    }

    @Test
    void testOuterApply() {
        String sql = "select * from dept outer apply table(ramp(deptno))";
        String expected = "SELECT *\nFROM `DEPT`\nLEFT JOIN LATERAL TABLE(`RAMP`(`DEPTNO`)) ON TRUE";
        this.sql("select * from dept outer apply table(ramp(deptno))").withConformance((SqlConformance)SqlConformanceEnum.SQL_SERVER_2008).ok("SELECT *\nFROM `DEPT`\nLEFT JOIN LATERAL TABLE(`RAMP`(`DEPTNO`)) ON TRUE");
    }

    @Test
    void testOuterApplySubQuery() {
        String sql = "select * from dept\nouter apply (select * from emp where emp.deptno = dept.deptno)";
        String expected = "SELECT *\nFROM `DEPT`\nLEFT JOIN LATERAL (SELECT *\nFROM `EMP`\nWHERE (`EMP`.`DEPTNO` = `DEPT`.`DEPTNO`)) ON TRUE";
        this.sql("select * from dept\nouter apply (select * from emp where emp.deptno = dept.deptno)").withConformance((SqlConformance)SqlConformanceEnum.SQL_SERVER_2008).ok("SELECT *\nFROM `DEPT`\nLEFT JOIN LATERAL (SELECT *\nFROM `EMP`\nWHERE (`EMP`.`DEPTNO` = `DEPT`.`DEPTNO`)) ON TRUE");
    }

    @Test
    void testOuterApplyValues() {
        String sql = "select * from dept\nouter apply (select * from emp where emp.deptno = dept.deptno)";
        String expected = "SELECT *\nFROM `DEPT`\nLEFT JOIN LATERAL (SELECT *\nFROM `EMP`\nWHERE (`EMP`.`DEPTNO` = `DEPT`.`DEPTNO`)) ON TRUE";
        this.sql("select * from dept\nouter apply (select * from emp where emp.deptno = dept.deptno)").withConformance((SqlConformance)SqlConformanceEnum.SQL_SERVER_2008).ok("SELECT *\nFROM `DEPT`\nLEFT JOIN LATERAL (SELECT *\nFROM `EMP`\nWHERE (`EMP`.`DEPTNO` = `DEPT`.`DEPTNO`)) ON TRUE");
    }

    @Test
    void testOuterApplyFunctionFails() {
        String sql = "select * from dept outer apply ramp(deptno)^)^";
        this.sql("select * from dept outer apply ramp(deptno)^)^").withConformance((SqlConformance)SqlConformanceEnum.SQL_SERVER_2008).fails("(?s).*Encountered \"\\)\" at .*");
    }

    @Test
    void testCrossOuterApply() {
        String sql = "select * from dept\ncross apply table(ramp(deptno)) as t(a)\nouter apply table(ramp2(a))";
        String expected = "SELECT *\nFROM `DEPT`\nCROSS JOIN LATERAL TABLE(`RAMP`(`DEPTNO`)) AS `T` (`A`)\nLEFT JOIN LATERAL TABLE(`RAMP2`(`A`)) ON TRUE";
        this.sql("select * from dept\ncross apply table(ramp(deptno)) as t(a)\nouter apply table(ramp2(a))").withConformance((SqlConformance)SqlConformanceEnum.SQL_SERVER_2008).ok("SELECT *\nFROM `DEPT`\nCROSS JOIN LATERAL TABLE(`RAMP`(`DEPTNO`)) AS `T` (`A`)\nLEFT JOIN LATERAL TABLE(`RAMP2`(`A`)) ON TRUE");
    }

    @Test
    void testTableSample() {
        String sql0 = "select * from (  select *   from emp   join dept on emp.deptno = dept.deptno  where gender = 'F'  order by sal) tablesample substitute('medium')";
        String expected0 = "SELECT *\nFROM (SELECT *\nFROM `EMP`\nINNER JOIN `DEPT` ON (`EMP`.`DEPTNO` = `DEPT`.`DEPTNO`)\nWHERE (`GENDER` = 'F')\nORDER BY `SAL`) TABLESAMPLE SUBSTITUTE('MEDIUM')";
        this.sql("select * from (  select *   from emp   join dept on emp.deptno = dept.deptno  where gender = 'F'  order by sal) tablesample substitute('medium')").ok("SELECT *\nFROM (SELECT *\nFROM `EMP`\nINNER JOIN `DEPT` ON (`EMP`.`DEPTNO` = `DEPT`.`DEPTNO`)\nWHERE (`GENDER` = 'F')\nORDER BY `SAL`) TABLESAMPLE SUBSTITUTE('MEDIUM')");
        String sql1 = "select * from emp as x tablesample substitute('medium') join dept tablesample substitute('lar' /* split */ 'ge') on x.deptno = dept.deptno";
        String expected1 = "SELECT *\nFROM `EMP` AS `X` TABLESAMPLE SUBSTITUTE('MEDIUM')\nINNER JOIN `DEPT` TABLESAMPLE SUBSTITUTE('LARGE') ON (`X`.`DEPTNO` = `DEPT`.`DEPTNO`)";
        this.sql("select * from emp as x tablesample substitute('medium') join dept tablesample substitute('lar' /* split */ 'ge') on x.deptno = dept.deptno").ok("SELECT *\nFROM `EMP` AS `X` TABLESAMPLE SUBSTITUTE('MEDIUM')\nINNER JOIN `DEPT` TABLESAMPLE SUBSTITUTE('LARGE') ON (`X`.`DEPTNO` = `DEPT`.`DEPTNO`)");
        String sql2 = "select * from emp as x tablesample bernoulli(50)";
        String expected2 = "SELECT *\nFROM `EMP` AS `X` TABLESAMPLE BERNOULLI(50.0)";
        this.sql("select * from emp as x tablesample bernoulli(50)").ok("SELECT *\nFROM `EMP` AS `X` TABLESAMPLE BERNOULLI(50.0)");
        String sql3 = "select * from emp as x tablesample bernoulli(50) REPEATABLE(10) ";
        String expected3 = "SELECT *\nFROM `EMP` AS `X` TABLESAMPLE BERNOULLI(50.0) REPEATABLE(10)";
        this.sql("select * from emp as x tablesample bernoulli(50) REPEATABLE(10) ").ok("SELECT *\nFROM `EMP` AS `X` TABLESAMPLE BERNOULLI(50.0) REPEATABLE(10)");
        this.sql("select * from emp as x tablesample bernoulli(50) REPEATABLE(^100000000000000000000^) ").fails("Literal '100000000000000000000' can not be parsed to type 'java\\.lang\\.Integer'");
        this.sql("select * from emp as x tablesample bernoulli(50) REPEATABLE(-^100000000000000000000^) ").fails("Literal '100000000000000000000' can not be parsed to type 'java\\.lang\\.Integer'");
        String sql4 = "select * from emp as x tablesample bernoulli(0)";
        String expected4 = "SELECT *\nFROM `EMP` AS `X` TABLESAMPLE BERNOULLI(0)";
        this.sql("select * from emp as x tablesample bernoulli(0)").ok("SELECT *\nFROM `EMP` AS `X` TABLESAMPLE BERNOULLI(0)");
        String sql5 = "select * from emp as x tablesample system(0)";
        String expected5 = "SELECT *\nFROM `EMP` AS `X` TABLESAMPLE SYSTEM(0)";
        this.sql("select * from emp as x tablesample system(0)").ok("SELECT *\nFROM `EMP` AS `X` TABLESAMPLE SYSTEM(0)");
    }

    @Test
    void testLiteral() {
        this.expr("'foo'").same();
        this.expr("100").same();
        this.sql("select 1 as uno, 'x' as x, null as n from emp").ok("SELECT 1 AS `UNO`, 'x' AS `X`, NULL AS `N`\nFROM `EMP`");
        this.expr("'2004-06-01'").same();
        this.expr("-.25").ok("-0.25");
        this.expr("TIMESTAMP '2004-06-01 15:55:55'").same();
        this.expr("TIMESTAMP '2004-06-01 15:55:55.900'").same();
        this.expr("TIMESTAMP '2004-06-01 15:55:55.1234'").same();
        this.expr("TIMESTAMP '2004-06-01 15:55:55.1236'").same();
        this.expr("TIMESTAMP '2004-06-01 15:55:55.9999'").same();
        this.expr("NULL").same();
    }

    @Test
    void testContinuedLiteral() {
        this.expr("'abba'\n'abba'").same();
        this.expr("'abba'\n'0001'").same();
        this.expr("N'yabba'\n'dabba'\n'doo'").ok("_ISO-8859-1'yabba'\n'dabba'\n'doo'");
        this.expr("_iso-8859-1'yabba'\n'dabba'\n'don''t'").ok("_ISO-8859-1'yabba'\n'dabba'\n'don''t'");
        this.expr("x'01aa'\n'03ff'").ok("X'01AA'\n'03FF'");
        this.sql("x'01aa'\n^'vvvv'^").fails("Binary literal string must contain only characters '0' - '9', 'A' - 'F'");
    }

    @Test
    void testContinuedLiteralAlias() {
        String expectingAlias = "Expecting alias, found character literal";
        String sql0 = "select 1 an_alias,\n  x'01'\n  'ab' as x\nfrom t";
        String sql0b = "SELECT 1 AS `AN_ALIAS`, X'01'\n'AB' AS `X`\nFROM `T`";
        this.sql("select 1 an_alias,\n  x'01'\n  'ab' as x\nfrom t").withConformance((SqlConformance)SqlConformanceEnum.DEFAULT).ok("SELECT 1 AS `AN_ALIAS`, X'01'\n'AB' AS `X`\nFROM `T`");
        this.sql("select 1 an_alias,\n  x'01'\n  'ab' as x\nfrom t").withConformance((SqlConformance)SqlConformanceEnum.MYSQL_5).ok("SELECT 1 AS `AN_ALIAS`, X'01'\n'AB' AS `X`\nFROM `T`");
        this.sql("select 1 an_alias,\n  x'01'\n  'ab' as x\nfrom t").withConformance((SqlConformance)SqlConformanceEnum.BIG_QUERY).ok("SELECT 1 AS `AN_ALIAS`, X'01'\n'AB' AS `X`\nFROM `T`");
        String sql1 = "select 1 ^'an alias'^,\n  x'01'\n  'ab'\nfrom t";
        String sql1b = "SELECT 1 AS `an alias`, X'01'\n'AB'\nFROM `T`";
        this.sql("select 1 ^'an alias'^,\n  x'01'\n  'ab'\nfrom t").withConformance((SqlConformance)SqlConformanceEnum.DEFAULT).fails("Expecting alias, found character literal");
        this.sql("select 1 ^'an alias'^,\n  x'01'\n  'ab'\nfrom t").withConformance((SqlConformance)SqlConformanceEnum.MYSQL_5).ok("SELECT 1 AS `an alias`, X'01'\n'AB'\nFROM `T`");
        this.sql("select 1 ^'an alias'^,\n  x'01'\n  'ab'\nfrom t").withConformance((SqlConformance)SqlConformanceEnum.BIG_QUERY).ok("SELECT 1 AS `an alias`, X'01'\n'AB'\nFROM `T`");
        String sql2 = "select 'continued'\n  'char literal, not alias',\n  x'01'\n  'ab'\nfrom t";
        String sql2b = "SELECT 'continued'\n'char literal, not alias', X'01'\n'AB'\nFROM `T`";
        this.sql("select 'continued'\n  'char literal, not alias',\n  x'01'\n  'ab'\nfrom t").withConformance((SqlConformance)SqlConformanceEnum.DEFAULT).ok("SELECT 'continued'\n'char literal, not alias', X'01'\n'AB'\nFROM `T`");
        this.sql("select 'continued'\n  'char literal, not alias',\n  x'01'\n  'ab'\nfrom t").withConformance((SqlConformance)SqlConformanceEnum.MYSQL_5).ok("SELECT 'continued'\n'char literal, not alias', X'01'\n'AB'\nFROM `T`");
        this.sql("select 'continued'\n  'char literal, not alias',\n  x'01'\n  'ab'\nfrom t").withConformance((SqlConformance)SqlConformanceEnum.BIG_QUERY).ok("SELECT 'continued'\n'char literal, not alias', X'01'\n'AB'\nFROM `T`");
    }

    @Test
    void testMixedFrom() {
        this.sql("select * from a join b using (x), c join d using (y)").ok("SELECT *\nFROM `A`\nINNER JOIN `B` USING (`X`),\n`C`\nINNER JOIN `D` USING (`Y`)");
    }

    @Test
    void testMixedStar() {
        this.sql("select emp.*, 1 as foo from emp, dept").ok("SELECT `EMP`.*, 1 AS `FOO`\nFROM `EMP`,\n`DEPT`");
    }

    @Test
    void testSchemaTableStar() {
        this.sql("select schem.emp.*, emp.empno * dept.deptno\nfrom schem.emp, dept").ok("SELECT `SCHEM`.`EMP`.*, (`EMP`.`EMPNO` * `DEPT`.`DEPTNO`)\nFROM `SCHEM`.`EMP`,\n`DEPT`");
    }

    @Test
    void testCatalogSchemaTableStar() {
        this.sql("select cat.schem.emp.* from cat.schem.emp").ok("SELECT `CAT`.`SCHEM`.`EMP`.*\nFROM `CAT`.`SCHEM`.`EMP`");
    }

    @Test
    void testAliasedStar() {
        this.sql("select emp.* as foo from emp").ok("SELECT `EMP`.* AS `FOO`\nFROM `EMP`");
    }

    @Test
    void testNotExists() {
        this.sql("select * from dept where not not exists (select * from emp) and true").ok("SELECT *\nFROM `DEPT`\nWHERE ((NOT (NOT (EXISTS (SELECT *\nFROM `EMP`)))) AND TRUE)");
    }

    @Test
    void testOrder() {
        this.sql("select * from emp order by empno, gender desc, deptno asc, empno asc, name desc").ok("SELECT *\nFROM `EMP`\nORDER BY `EMPNO`, `GENDER` DESC, `DEPTNO`, `EMPNO`, `NAME` DESC");
    }

    @Test
    void testOrderNullsFirst() {
        String sql = "select * from emp\norder by gender desc nulls last,\n deptno asc nulls first,\n empno nulls last";
        String expected = "SELECT *\nFROM `EMP`\nORDER BY `GENDER` DESC NULLS LAST, `DEPTNO` NULLS FIRST, `EMPNO` NULLS LAST";
        this.sql("select * from emp\norder by gender desc nulls last,\n deptno asc nulls first,\n empno nulls last").ok("SELECT *\nFROM `EMP`\nORDER BY `GENDER` DESC NULLS LAST, `DEPTNO` NULLS FIRST, `EMPNO` NULLS LAST");
    }

    @Test
    void testOrderInternal() {
        this.sql("(select * from emp order by empno) union select * from emp").ok("(SELECT *\nFROM `EMP`\nORDER BY `EMPNO`)\nUNION\nSELECT *\nFROM `EMP`");
        this.sql("select * from (select * from t order by x, y) where a = b").ok("SELECT *\nFROM (SELECT *\nFROM `T`\nORDER BY `X`, `Y`)\nWHERE (`A` = `B`)");
    }

    @Test
    void testOrderIllegalInExpression() {
        this.sql("select (select 1 from foo order by x,y) from t where a = b").ok("SELECT (SELECT 1\nFROM `FOO`\nORDER BY `X`, `Y`)\nFROM `T`\nWHERE (`A` = `B`)");
        this.sql("select (1 ^order^ by x, y) from t where a = b").fails("ORDER BY unexpected");
    }

    @Test
    void testOrderOffsetFetch() {
        this.sql("select a from foo order by b, c offset 1 row fetch first 2 row only").ok("SELECT `A`\nFROM `FOO`\nORDER BY `B`, `C`\nOFFSET 1 ROWS\nFETCH NEXT 2 ROWS ONLY");
        this.sql("select a from foo order by b, c offset 1 rows fetch first 2 rows only").ok("SELECT `A`\nFROM `FOO`\nORDER BY `B`, `C`\nOFFSET 1 ROWS\nFETCH NEXT 2 ROWS ONLY");
        this.sql("select a from foo order by b, c offset 1 rows fetch next 3 rows only").ok("SELECT `A`\nFROM `FOO`\nORDER BY `B`, `C`\nOFFSET 1 ROWS\nFETCH NEXT 3 ROWS ONLY");
        this.sql("select a from foo order by b, c offset 1 fetch next 3 rows only").ok("SELECT `A`\nFROM `FOO`\nORDER BY `B`, `C`\nOFFSET 1 ROWS\nFETCH NEXT 3 ROWS ONLY");
        this.sql("select a from foo order by b, c fetch next 3 rows only").ok("SELECT `A`\nFROM `FOO`\nORDER BY `B`, `C`\nFETCH NEXT 3 ROWS ONLY");
        this.sql("select a from foo fetch next 4 rows only").ok("SELECT `A`\nFROM `FOO`\nFETCH NEXT 4 ROWS ONLY");
        this.sql("select a from foo offset 1 row").ok("SELECT `A`\nFROM `FOO`\nOFFSET 1 ROWS");
        this.sql("select a from foo offset 1 row fetch next 3 rows only").ok("SELECT `A`\nFROM `FOO`\nOFFSET 1 ROWS\nFETCH NEXT 3 ROWS ONLY");
        this.sql("select a from foo offset ? row fetch next ? rows only").ok("SELECT `A`\nFROM `FOO`\nOFFSET ? ROWS\nFETCH NEXT ? ROWS ONLY");
        this.sql("select a from foo offset 1 fetch next 3 ^only^").fails("(?s).*Encountered \"only\" at .*");
        this.sql("select a from foo fetch next 3 rows only ^offset^ 1").fails("(?s).*Encountered \"offset\" at .*");
    }

    @Test
    void testLimit() {
        this.sql("select a from foo order by b, c limit 2 offset 1").ok("SELECT `A`\nFROM `FOO`\nORDER BY `B`, `C`\nOFFSET 1 ROWS\nFETCH NEXT 2 ROWS ONLY");
        this.sql("select a from foo order by b, c limit 2").ok("SELECT `A`\nFROM `FOO`\nORDER BY `B`, `C`\nFETCH NEXT 2 ROWS ONLY");
        this.sql("select a from foo order by b, c offset 1").ok("SELECT `A`\nFROM `FOO`\nORDER BY `B`, `C`\nOFFSET 1 ROWS");
    }

    @Test
    void testLimitSpark() {
        String sql1 = "select a from foo order by b, c limit 2 offset 1";
        String expected1 = "SELECT `A`\nFROM `FOO`\nORDER BY `B`, `C`\nLIMIT 2\nOFFSET 1";
        this.sql("select a from foo order by b, c limit 2 offset 1").withDialect(SparkSqlDialect.DEFAULT).ok("SELECT `A`\nFROM `FOO`\nORDER BY `B`, `C`\nLIMIT 2\nOFFSET 1");
        String sql2 = "select a from foo order by b, c limit 2";
        String expected2 = "SELECT `A`\nFROM `FOO`\nORDER BY `B`, `C`\nLIMIT 2";
        this.sql("select a from foo order by b, c limit 2").withDialect(SparkSqlDialect.DEFAULT).ok("SELECT `A`\nFROM `FOO`\nORDER BY `B`, `C`\nLIMIT 2");
        String sql3 = "select a from foo order by b, c offset 1";
        String expected3 = "SELECT `A`\nFROM `FOO`\nORDER BY `B`, `C`\nOFFSET 1";
        this.sql("select a from foo order by b, c offset 1").withDialect(SparkSqlDialect.DEFAULT).ok("SELECT `A`\nFROM `FOO`\nORDER BY `B`, `C`\nOFFSET 1");
        String sql4 = "select a from foo offset 10";
        String expected4 = "SELECT `A`\nFROM `FOO`\nOFFSET 10";
        this.sql("select a from foo offset 10").withDialect(SparkSqlDialect.DEFAULT).ok("SELECT `A`\nFROM `FOO`\nOFFSET 10");
        String sql5 = "select a from foo\nunion\nselect b from baz\nlimit 3";
        String expected5 = "SELECT `A`\nFROM `FOO`\nUNION\nSELECT `B`\nFROM `BAZ`\nLIMIT 3";
        this.sql("select a from foo\nunion\nselect b from baz\nlimit 3").withDialect(SparkSqlDialect.DEFAULT).ok("SELECT `A`\nFROM `FOO`\nUNION\nSELECT `B`\nFROM `BAZ`\nLIMIT 3");
    }

    @Test
    void testLimitWithoutOrder() {
        String expected = "SELECT `A`\nFROM `FOO`\nFETCH NEXT 2 ROWS ONLY";
        this.sql("select a from foo limit 2").ok("SELECT `A`\nFROM `FOO`\nFETCH NEXT 2 ROWS ONLY");
    }

    @Test
    void testLimitOffsetWithoutOrder() {
        String expected = "SELECT `A`\nFROM `FOO`\nOFFSET 1 ROWS\nFETCH NEXT 2 ROWS ONLY";
        this.sql("select a from foo limit 2 offset 1").ok("SELECT `A`\nFROM `FOO`\nOFFSET 1 ROWS\nFETCH NEXT 2 ROWS ONLY");
    }

    @Test
    void testLimitStartCount() {
        String error = "'LIMIT start, count' is not allowed under the current SQL conformance level";
        this.sql("select a from foo ^limit 1,2^").withConformance((SqlConformance)SqlConformanceEnum.DEFAULT).fails("'LIMIT start, count' is not allowed under the current SQL conformance level");
        String expected0 = "SELECT `A`\nFROM `FOO`";
        this.sql("select a from foo limit all").withConformance((SqlConformance)SqlConformanceEnum.DEFAULT).ok("SELECT `A`\nFROM `FOO`");
        String expected1 = "SELECT `A`\nFROM `FOO`\nORDER BY `X`";
        this.sql("select a from foo order by x limit all").withConformance((SqlConformance)SqlConformanceEnum.DEFAULT).ok("SELECT `A`\nFROM `FOO`\nORDER BY `X`");
        String expected2 = "SELECT `A`\nFROM `FOO`\nOFFSET 2 ROWS\nFETCH NEXT 3 ROWS ONLY";
        this.sql("select a from foo limit 2,3").withConformance((SqlConformance)SqlConformanceEnum.LENIENT).ok("SELECT `A`\nFROM `FOO`\nOFFSET 2 ROWS\nFETCH NEXT 3 ROWS ONLY");
        String expected3 = "SELECT `A`\nFROM `FOO`\nOFFSET 4 ROWS\nFETCH NEXT 3 ROWS ONLY";
        this.sql("select a from foo limit 2,3 offset 4").withConformance((SqlConformance)SqlConformanceEnum.LENIENT).ok("SELECT `A`\nFROM `FOO`\nOFFSET 4 ROWS\nFETCH NEXT 3 ROWS ONLY");
        this.sql("select a from foo limit 2,3 ^fetch^ next 4 rows only").withConformance((SqlConformance)SqlConformanceEnum.LENIENT).fails("(?s).*Encountered \"fetch\" at line 1.*");
    }

    @Test
    void testOffsetStartLimitCount() {
        String error = "'OFFSET start LIMIT count' is not allowed under the current SQL conformance level";
        this.sql("select a from foo order by b, c offset 1 limit 2").withConformance((SqlConformance)SqlConformanceEnum.LENIENT).ok("SELECT `A`\nFROM `FOO`\nORDER BY `B`, `C`\nOFFSET 1 ROWS\nFETCH NEXT 2 ROWS ONLY");
        this.sql("select a from foo order by b, c ^offset 1 limit 2^").withConformance((SqlConformance)SqlConformanceEnum.DEFAULT).fails("'OFFSET start LIMIT count' is not allowed under the current SQL conformance level");
        String expected3 = "SELECT `A`\nFROM `FOO`\nOFFSET 2 ROWS\nFETCH NEXT 3 ROWS ONLY";
        this.sql("select a from foo offset 4 limit 2,3").withConformance((SqlConformance)SqlConformanceEnum.LENIENT).ok("SELECT `A`\nFROM `FOO`\nOFFSET 2 ROWS\nFETCH NEXT 3 ROWS ONLY");
        this.sql("select a from foo offset 2 limit 3 ^fetch^ next 4 rows only").withConformance((SqlConformance)SqlConformanceEnum.LENIENT).fails("(?s).*Encountered \"fetch\" at line 1.*");
    }

    @Test
    void testLimitStartAll() {
        String expected = "SELECT `A`\nFROM `FOO`\nOFFSET 2 ROWS";
        this.sql("select a from foo ^limit 2, all^").withConformance((SqlConformance)SqlConformanceEnum.DEFAULT).fails("'LIMIT start, ALL' is not allowed under the current SQL conformance level").withConformance((SqlConformance)SqlConformanceEnum.MYSQL_5).ok(expected).withConformance((SqlConformance)SqlConformanceEnum.LENIENT).ok(expected);
        this.sql("select a from foo ^offset 1 limit 2, all^").withConformance((SqlConformance)SqlConformanceEnum.DEFAULT).fails("'LIMIT start, ALL' is not allowed under the current SQL conformance level").withConformance((SqlConformance)SqlConformanceEnum.MYSQL_5).fails("'OFFSET start LIMIT count' is not allowed under the current SQL conformance level").withConformance((SqlConformance)SqlConformanceEnum.LENIENT).ok(expected);
        String expected2 = "SELECT `A`\nFROM `FOO`\nOFFSET 1 ROWS";
        this.sql("select a from foo limit 2, all offset 1").withConformance((SqlConformance)SqlConformanceEnum.LENIENT).ok(expected2);
    }

    @Test
    void testSqlInlineComment() {
        this.sql("select 1 from t --this is a comment\n").ok("SELECT 1\nFROM `T`");
        this.sql("select 1 from t--\n").ok("SELECT 1\nFROM `T`");
        this.sql("select 1 from t--this is a comment\nwhere a>b-- this is comment\n").ok("SELECT 1\nFROM `T`\nWHERE (`A` > `B`)");
        this.sql("select 1 from t\n--select").ok("SELECT 1\nFROM `T`");
    }

    @Test
    void testMultilineComment() {
        this.sql("select 1 /* , 2 */, 3 from t").ok("SELECT 1, 3\nFROM `T`");
        this.sql("select /* 1,\n 2,\n */ 3 from t").ok("SELECT 3\nFROM `T`");
        this.sql("values ( /** 1, 2 + ** */ 3)").ok("VALUES (ROW(3))");
        this.sql("values ('a string with /* a comment */ in it')").ok("VALUES (ROW('a string with /* a comment */ in it'))");
        this.sql("values (- -1\n)").ok("VALUES (ROW(1))");
        this.sql("values (--1+\n2)").ok("VALUES (ROW(2))");
        this.sql("values (1 + /* comment -- rest of line\n rest of comment */ 2)").ok("VALUES (ROW((1 + 2)))");
        this.sql("values -- rest of line /* a comment */\n(1)").ok("VALUES (ROW(1))");
        this.sql("values -- rest of line /* a comment\n(1)").ok("VALUES (ROW(1))");
        this.sql("values ('abc'/* a comment*/'def')").ok("VALUES (ROW('abc'\n'def'))");
        this.sql("values /**/ (1)").ok("VALUES (ROW(1))");
    }

    @Test
    void testParseNumber() {
        this.expr("1").same();
        this.expr("+1.").ok("1");
        this.expr("-1").same();
        this.expr("- -1").ok("1");
        this.expr("1.0").same();
        this.expr("-3.2").same();
        this.expr("1.").ok("1");
        this.expr(".1").ok("0.1");
        this.expr("2500000000").same();
        this.expr("5000000000").same();
        this.expr("1e1").ok("1E1");
        this.expr("+1e1").ok("1E1");
        this.expr("1.1e1").ok("1.1E1");
        this.expr("1.1e+1").ok("1.1E1");
        this.expr("1.1e-1").ok("1.1E-1");
        this.expr("+1.1e-1").ok("1.1E-1");
        this.expr("1.E3").ok("1E3");
        this.expr("1.e-3").ok("1E-3");
        this.expr("1.e+3").ok("1E3");
        this.expr(".5E3").ok("5E2");
        this.expr("+.5e3").ok("5E2");
        this.expr("-.5E3").ok("-5E2");
        this.expr(".5e-32").ok("5E-33");
        this.expr("3. + 2").ok("(3 + 2)");
        this.expr("1++2+3").ok("((1 + 2) + 3)");
        this.expr("1- -2").ok("(1 - -2)");
        this.expr("1++2.3e-4++.5e-6++.7++8").ok("((((1 + 2.3E-4) + 5E-7) + 0.7) + 8)");
        this.expr("1- -2.3e-4 - -.5e-6  -\n-.7++8").ok("((((1 - -2.3E-4) - -5E-7) - -0.7) + 8)");
        this.expr("1+-2.*-3.e-1/-4").ok("(1 + ((-2 * -3E-1) / -4))");
    }

    @Test
    void testParseNumberFails() {
        this.sql("SELECT 0.5e1^.1^ from t").fails("(?s).*Encountered .*\\.1.* at line 1.*");
    }

    @Test
    void testMinusPrefixInExpression() {
        this.expr("-(1+2)").ok("(- (1 + 2))");
    }

    @Test
    void testPrecedence0() {
        this.expr("1 + 2 * 3 * 4 + 5").ok("((1 + ((2 * 3) * 4)) + 5)");
    }

    @Test
    void testPrecedence1() {
        this.expr("1 + 2 * (3 * (4 + 5))").ok("(1 + (2 * (3 * (4 + 5))))");
    }

    @Test
    void testPrecedence2() {
        this.expr("- - 1").ok("1");
    }

    @Test
    void testPrecedence2b() {
        this.expr("not not 1").ok("(NOT (NOT 1))");
    }

    @Test
    void testPrecedence3() {
        this.expr("- 1 is null").ok("(-1 IS NULL)");
    }

    @Test
    void testPrecedence4() {
        this.expr("1 - -2").ok("(1 - -2)");
    }

    @Test
    void testPrecedence5() {
        this.expr("1++2").ok("(1 + 2)");
        this.expr("1+ +2").ok("(1 + 2)");
    }

    @Test
    void testPrecedenceSetOps() {
        String sql = "select * from a union select * from b intersect select * from c intersect select * from d except select * from e except select * from f union select * from g";
        String expected = "SELECT *\nFROM `A`\nUNION\nSELECT *\nFROM `B`\nINTERSECT\nSELECT *\nFROM `C`\nINTERSECT\nSELECT *\nFROM `D`\nEXCEPT\nSELECT *\nFROM `E`\nEXCEPT\nSELECT *\nFROM `F`\nUNION\nSELECT *\nFROM `G`";
        this.sql("select * from a union select * from b intersect select * from c intersect select * from d except select * from e except select * from f union select * from g").ok("SELECT *\nFROM `A`\nUNION\nSELECT *\nFROM `B`\nINTERSECT\nSELECT *\nFROM `C`\nINTERSECT\nSELECT *\nFROM `D`\nEXCEPT\nSELECT *\nFROM `E`\nEXCEPT\nSELECT *\nFROM `F`\nUNION\nSELECT *\nFROM `G`");
    }

    @Test
    void testQueryInFrom() {
        this.sql("select * from (select * from emp) as e join (select * from dept) d").ok("SELECT *\nFROM (SELECT *\nFROM `EMP`) AS `E`\nINNER JOIN (SELECT *\nFROM `DEPT`) AS `D`");
    }

    @Test
    void testQuotesInString() {
        this.expr("'a''b'").same();
        this.expr("'''x'").same();
        this.expr("''").same();
        this.expr("'Quoted strings aren''t \"hard\"'").same();
    }

    @Test
    void testScalarQueryInWhere() {
        this.sql("select * from emp where 3 = (select count(*) from dept where dept.deptno = emp.deptno)").ok("SELECT *\nFROM `EMP`\nWHERE (3 = (SELECT COUNT(*)\nFROM `DEPT`\nWHERE (`DEPT`.`DEPTNO` = `EMP`.`DEPTNO`)))");
    }

    @Test
    void testScalarQueryInSelect() {
        this.sql("select x, (select count(*) from dept where dept.deptno = emp.deptno) from emp").ok("SELECT `X`, (SELECT COUNT(*)\nFROM `DEPT`\nWHERE (`DEPT`.`DEPTNO` = `EMP`.`DEPTNO`))\nFROM `EMP`");
    }

    @Test
    void testSelectList() {
        this.sql("select * from emp, dept").ok("SELECT *\nFROM `EMP`,\n`DEPT`");
    }

    @Test
    void testSelectWithoutFrom() {
        this.sql("select 2+2").ok("SELECT (2 + 2)");
    }

    @Test
    void testSelectWithoutFrom2() {
        this.sql("select 2+2 as x, 'a' as y").ok("SELECT (2 + 2) AS `X`, 'a' AS `Y`");
    }

    @Test
    void testSelectDistinctWithoutFrom() {
        this.sql("select distinct 2+2 as x, 'a' as y").ok("SELECT DISTINCT (2 + 2) AS `X`, 'a' AS `Y`");
    }

    @Test
    void testSelectWithoutFromWhereFails() {
        this.sql("select 2+2 as x ^where^ 1 > 2").fails("(?s).*Encountered \"where\" at line .*");
    }

    @Test
    void testSelectWithoutFromGroupByFails() {
        this.sql("select 2+2 as x ^group^ by 1, 2").fails("(?s).*Encountered \"group\" at line .*");
    }

    @Test
    void testSelectWithoutFromHavingFails() {
        this.sql("select 2+2 as x ^having^ 1 > 2").fails("(?s).*Encountered \"having\" at line .*");
    }

    @Test
    void testSelectList3() {
        this.sql("select 1, emp.*, 2 from emp").ok("SELECT 1, `EMP`.*, 2\nFROM `EMP`");
    }

    @Test
    void testSelectList4() {
        this.sql("select ^from^ emp").fails("(?s).*Encountered \"from\" at line .*");
    }

    @Test
    void testStar() {
        this.sql("select * from emp").ok("SELECT *\nFROM `EMP`");
    }

    @Test
    void testCompoundStar() {
        String sql = "select sales.emp.address.zipcode,\n sales.emp.address.*\nfrom sales.emp";
        String expected = "SELECT `SALES`.`EMP`.`ADDRESS`.`ZIPCODE`, `SALES`.`EMP`.`ADDRESS`.*\nFROM `SALES`.`EMP`";
        this.sql("select sales.emp.address.zipcode,\n sales.emp.address.*\nfrom sales.emp").ok("SELECT `SALES`.`EMP`.`ADDRESS`.`ZIPCODE`, `SALES`.`EMP`.`ADDRESS`.*\nFROM `SALES`.`EMP`");
    }

    @Test
    void testSelectDistinct() {
        this.sql("select distinct foo from bar").ok("SELECT DISTINCT `FOO`\nFROM `BAR`");
    }

    @Test
    void testSelectAll() {
        this.sql("select * from (select all foo from bar) as xyz").ok("SELECT *\nFROM (SELECT ALL `FOO`\nFROM `BAR`) AS `XYZ`");
    }

    @Test
    void testSelectStream() {
        this.sql("select stream foo from bar").ok("SELECT STREAM `FOO`\nFROM `BAR`");
    }

    @Test
    void testSelectStreamDistinct() {
        this.sql("select stream distinct foo from bar").ok("SELECT STREAM DISTINCT `FOO`\nFROM `BAR`");
    }

    @Test
    void testWhere() {
        this.sql("select * from emp where empno > 5 and gender = 'F'").ok("SELECT *\nFROM `EMP`\nWHERE ((`EMPNO` > 5) AND (`GENDER` = 'F'))");
    }

    @Test
    void testNestedSelect() {
        this.sql("select * from (select * from emp)").ok("SELECT *\nFROM (SELECT *\nFROM `EMP`)");
    }

    @Test
    void testValues() {
        String expected = "VALUES (ROW(1, 'two'))";
        String pattern = "VALUE is not allowed under the current SQL conformance level";
        this.sql("values(1,'two')").ok("VALUES (ROW(1, 'two'))");
        this.sql("value(1,'two')").withConformance((SqlConformance)SqlConformanceEnum.MYSQL_5).ok("VALUES (ROW(1, 'two'))").node((Matcher<SqlNode>)CoreMatchers.not(SqlParserTest.isDdl()));
        this.sql("^value^(1,'two')").fails("VALUE is not allowed under the current SQL conformance level");
    }

    @Test
    void testValuesExplicitRow() {
        this.sql("values row(1,'two')").ok("VALUES (ROW(1, 'two'))");
    }

    @Test
    void testFromValues() {
        this.sql("select * from (values(1,'two'), 3, (4, 'five'))").ok("SELECT *\nFROM (VALUES (ROW(1, 'two')),\n(ROW(3)),\n(ROW(4, 'five')))");
    }

    @Test
    void testFromValuesWithoutParens() {
        this.sql("select 1 from ^values^('x')").fails("(?s)Encountered \"values\" at line 1, column 15\\.\nWas expecting one of:\n    \"LATERAL\" \\.\\.\\.\n    \"TABLE\" \\.\\.\\.\n    <IDENTIFIER> \\.\\.\\.\n    <HYPHENATED_IDENTIFIER> \\.\\.\\.\n    <QUOTED_IDENTIFIER> \\.\\.\\.\n    <BACK_QUOTED_IDENTIFIER> \\.\\.\\.\n    <BIG_QUERY_BACK_QUOTED_IDENTIFIER> \\.\\.\\.\n    <BRACKET_QUOTED_IDENTIFIER> \\.\\.\\.\n    <UNICODE_QUOTED_IDENTIFIER> \\.\\.\\.\n    \"\\(\" \\.\\.\\.\n.*    \"UNNEST\" \\.\\.\\.\n.*");
    }

    @Test
    void testEmptyValues() {
        this.sql("select * from (values(^)^)").fails("(?s).*Encountered \"\\)\" at .*");
    }

    @Test
    void testTableExtend() {
        this.sql("select * from emp extend (x int, y varchar(10) not null)").ok("SELECT *\nFROM `EMP` EXTEND (`X` INTEGER, `Y` VARCHAR(10))");
        this.sql("select * from emp extend (x int, y varchar(10) not null) where true").ok("SELECT *\nFROM `EMP` EXTEND (`X` INTEGER, `Y` VARCHAR(10))\nWHERE TRUE");
        this.sql("select * from emp extend (x int, y varchar(10) not null) as t").ok("SELECT *\nFROM `EMP` EXTEND (`X` INTEGER, `Y` VARCHAR(10)) AS `T`");
        this.sql("select * from emp extend (x int, y varchar(10) not null) t").ok("SELECT *\nFROM `EMP` EXTEND (`X` INTEGER, `Y` VARCHAR(10)) AS `T`");
        this.sql("select * from emp extend (x int, y varchar(10) not null) as t(a, b)").ok("SELECT *\nFROM `EMP` EXTEND (`X` INTEGER, `Y` VARCHAR(10)) AS `T` (`A`, `B`)");
        this.sql("select * from emp extend (x int, y varchar(10) not null) t(a, b)").ok("SELECT *\nFROM `EMP` EXTEND (`X` INTEGER, `Y` VARCHAR(10)) AS `T` (`A`, `B`)");
        this.sql("select * from emp (x int, y varchar(10) not null) t(a, b)").ok("SELECT *\nFROM `EMP` EXTEND (`X` INTEGER, `Y` VARCHAR(10)) AS `T` (`A`, `B`)");
        this.sql("select * from emp (x int, y varchar(10) not null) where x = y").ok("SELECT *\nFROM `EMP` EXTEND (`X` INTEGER, `Y` VARCHAR(10))\nWHERE (`X` = `Y`)");
    }

    @Test
    void testExplicitTable() {
        this.sql("table emp").ok("(TABLE `EMP`)");
        this.sql("table ^123^").fails("(?s)Encountered \"123\" at line 1, column 7\\.\n.*");
    }

    @Test
    void testExplicitTableOrdered() {
        this.sql("table emp order by name").ok("(TABLE `EMP`)\nORDER BY `NAME`");
    }

    @Test
    void testSelectFromExplicitTable() {
        this.sql("select * from (table emp)").ok("SELECT *\nFROM (TABLE `EMP`)");
    }

    @Test
    void testSelectFromBareExplicitTableFails() {
        this.sql("select * from table ^emp^").fails("(?s).*Encountered \"emp\" at .*");
        this.sql("select * from (table (^select^ empno from emp))").fails("(?s)Encountered \"select\".*");
    }

    @Test
    void testCollectionTable() {
        this.sql("select * from table(ramp(3, 4))").ok("SELECT *\nFROM TABLE(`RAMP`(3, 4))");
    }

    @Test
    void testDescriptor() {
        this.sql("select * from table(ramp(descriptor(column_name)))").ok("SELECT *\nFROM TABLE(`RAMP`(DESCRIPTOR(`COLUMN_NAME`)))");
        this.sql("select * from table(ramp(descriptor(\"COLUMN_NAME\")))").ok("SELECT *\nFROM TABLE(`RAMP`(DESCRIPTOR(`COLUMN_NAME`)))");
        this.sql("select * from table(ramp(descriptor(column_name1, column_name2, column_name3)))").ok("SELECT *\nFROM TABLE(`RAMP`(DESCRIPTOR(`COLUMN_NAME1`, `COLUMN_NAME2`, `COLUMN_NAME3`)))");
    }

    @Test
    void testCollectionTableWithCursorParam() {
        this.sql("select * from table(dedup(cursor(select * from emps),'name'))").ok("SELECT *\nFROM TABLE(`DEDUP`((CURSOR ((SELECT *\nFROM `EMPS`))), 'name'))");
    }

    @Test
    void testCollectionTableWithColumnListParam() {
        this.sql("select * from table(dedup(cursor(select * from emps),row(empno, name)))").ok("SELECT *\nFROM TABLE(`DEDUP`((CURSOR ((SELECT *\nFROM `EMPS`))), (ROW(`EMPNO`, `NAME`))))");
    }

    @Test
    void testLateral() {
        this.sql("select * from lateral ^emp^").fails("(?s)Encountered \"emp\" at .*");
        this.sql("select * from lateral table ^emp^ as e").fails("(?s)Encountered \"emp\" at .*");
        this.sql("select * from lateral table ^scott^.emp").fails("(?s)Encountered \"scott\" at .*");
        String expected = "SELECT *\nFROM LATERAL TABLE(`RAMP`(1))";
        this.sql("select * from lateral table(ramp(1))").ok("SELECT *\nFROM LATERAL TABLE(`RAMP`(1))");
        this.sql("select * from lateral table(ramp(1)) as t").ok("SELECT *\nFROM LATERAL TABLE(`RAMP`(1)) AS `T`");
        this.sql("select * from lateral table(ramp(1)) as t(x)").ok("SELECT *\nFROM LATERAL TABLE(`RAMP`(1)) AS `T` (`X`)");
        this.sql("select * from lateral (^table (ramp(1))^)").fails("Expected query or join");
        String expected2 = "SELECT *\nFROM LATERAL (SELECT *\nFROM `EMP`)";
        this.sql("select * from lateral (select * from emp)").ok("SELECT *\nFROM LATERAL (SELECT *\nFROM `EMP`)");
        this.sql("select * from lateral (select * from emp) as t").ok("SELECT *\nFROM LATERAL (SELECT *\nFROM `EMP`) AS `T`");
        this.sql("select * from lateral (select * from emp) as t(x)").ok("SELECT *\nFROM LATERAL (SELECT *\nFROM `EMP`) AS `T` (`X`)");
    }

    @Test
    void testTemporalTable() {
        String sql0 = "select stream * from orders, products\nfor system_time as of TIMESTAMP '2011-01-02 00:00:00'";
        String expected0 = "SELECT STREAM *\nFROM `ORDERS`,\n`PRODUCTS` FOR SYSTEM_TIME AS OF TIMESTAMP '2011-01-02 00:00:00'";
        this.sql("select stream * from orders, products\nfor system_time as of TIMESTAMP '2011-01-02 00:00:00'").ok("SELECT STREAM *\nFROM `ORDERS`,\n`PRODUCTS` FOR SYSTEM_TIME AS OF TIMESTAMP '2011-01-02 00:00:00'");
        String sql1 = "select stream * from orders, LATERAL ^products_temporal^\nfor system_time as of TIMESTAMP '2011-01-02 00:00:00'";
        String error = "(?s)Encountered \"products_temporal\" at line .*";
        this.sql("select stream * from orders, LATERAL ^products_temporal^\nfor system_time as of TIMESTAMP '2011-01-02 00:00:00'").fails("(?s)Encountered \"products_temporal\" at line .*");
        String sql2 = "select stream * from orders join products_temporal\nfor system_time as of timestamp '2011-01-02 00:00:00'\non orders.productid = products_temporal.productid";
        String expected2 = "SELECT STREAM *\nFROM `ORDERS`\nINNER JOIN `PRODUCTS_TEMPORAL` FOR SYSTEM_TIME AS OF TIMESTAMP '2011-01-02 00:00:00' ON (`ORDERS`.`PRODUCTID` = `PRODUCTS_TEMPORAL`.`PRODUCTID`)";
        this.sql("select stream * from orders join products_temporal\nfor system_time as of timestamp '2011-01-02 00:00:00'\non orders.productid = products_temporal.productid").ok("SELECT STREAM *\nFROM `ORDERS`\nINNER JOIN `PRODUCTS_TEMPORAL` FOR SYSTEM_TIME AS OF TIMESTAMP '2011-01-02 00:00:00' ON (`ORDERS`.`PRODUCTID` = `PRODUCTS_TEMPORAL`.`PRODUCTID`)");
        String sql3 = "select stream * from orders left join products_temporal\nfor system_time as of orders.rowtime on orders.productid = products_temporal.productid";
        String expected3 = "SELECT STREAM *\nFROM `ORDERS`\nLEFT JOIN `PRODUCTS_TEMPORAL` FOR SYSTEM_TIME AS OF `ORDERS`.`ROWTIME` ON (`ORDERS`.`PRODUCTID` = `PRODUCTS_TEMPORAL`.`PRODUCTID`)";
        this.sql("select stream * from orders left join products_temporal\nfor system_time as of orders.rowtime on orders.productid = products_temporal.productid").ok("SELECT STREAM *\nFROM `ORDERS`\nLEFT JOIN `PRODUCTS_TEMPORAL` FOR SYSTEM_TIME AS OF `ORDERS`.`ROWTIME` ON (`ORDERS`.`PRODUCTID` = `PRODUCTS_TEMPORAL`.`PRODUCTID`)");
        String sql4 = "select stream * from orders left join products_temporal\nfor system_time as of orders.rowtime - INTERVAL '3' DAY on orders.productid = products_temporal.productid";
        String expected4 = "SELECT STREAM *\nFROM `ORDERS`\nLEFT JOIN `PRODUCTS_TEMPORAL` FOR SYSTEM_TIME AS OF (`ORDERS`.`ROWTIME` - INTERVAL '3' DAY) ON (`ORDERS`.`PRODUCTID` = `PRODUCTS_TEMPORAL`.`PRODUCTID`)";
        this.sql("select stream * from orders left join products_temporal\nfor system_time as of orders.rowtime - INTERVAL '3' DAY on orders.productid = products_temporal.productid").ok("SELECT STREAM *\nFROM `ORDERS`\nLEFT JOIN `PRODUCTS_TEMPORAL` FOR SYSTEM_TIME AS OF (`ORDERS`.`ROWTIME` - INTERVAL '3' DAY) ON (`ORDERS`.`PRODUCTID` = `PRODUCTS_TEMPORAL`.`PRODUCTID`)");
    }

    @Test
    void testAsofJoinTable() {
        String sql0 = "select * from orders asof join products\nmatch_condition orders.ts <= products.expiry\non orders.productid = products.productid";
        String expected0 = "SELECT *\nFROM (`ORDERS` ASOF JOIN `PRODUCTS` MATCH_CONDITION (`ORDERS`.`TS` <= `PRODUCTS`.`EXPIRY`) ON (`ORDERS`.`PRODUCTID` = `PRODUCTS`.`PRODUCTID`))";
        this.sql("select * from orders asof join products\nmatch_condition orders.ts <= products.expiry\non orders.productid = products.productid").ok("SELECT *\nFROM (`ORDERS` ASOF JOIN `PRODUCTS` MATCH_CONDITION (`ORDERS`.`TS` <= `PRODUCTS`.`EXPIRY`) ON (`ORDERS`.`PRODUCTID` = `PRODUCTS`.`PRODUCTID`))");
        String sql1 = "select * from orders left asof join products\nmatch_condition orders.ts <= products.expiry\non orders.productid = products.productid";
        String expected1 = "SELECT *\nFROM (`ORDERS` LEFT ASOF JOIN `PRODUCTS` MATCH_CONDITION (`ORDERS`.`TS` <= `PRODUCTS`.`EXPIRY`) ON (`ORDERS`.`PRODUCTID` = `PRODUCTS`.`PRODUCTID`))";
        this.sql("select * from orders left asof join products\nmatch_condition orders.ts <= products.expiry\non orders.productid = products.productid").ok("SELECT *\nFROM (`ORDERS` LEFT ASOF JOIN `PRODUCTS` MATCH_CONDITION (`ORDERS`.`TS` <= `PRODUCTS`.`EXPIRY`) ON (`ORDERS`.`PRODUCTID` = `PRODUCTS`.`PRODUCTID`))");
        this.sql("select * from orders asof join products\non orders.productid = products.^productid^").fails("ASOF JOIN missing MATCH_CONDITION");
        this.sql("select * from orders join products\nmatch_condition orders.ts <= products.expiry\non orders.productid = products_temporal.^productid^").fails("MATCH_CONDITION only allowed with ASOF JOIN");
    }

    @Test
    void testCollectionTableWithLateral() {
        String sql = "select * from dept, lateral table(ramp(dept.deptno))";
        String expected = "SELECT *\nFROM `DEPT`,\nLATERAL TABLE(`RAMP`(`DEPT`.`DEPTNO`))";
        this.sql("select * from dept, lateral table(ramp(dept.deptno))").ok("SELECT *\nFROM `DEPT`,\nLATERAL TABLE(`RAMP`(`DEPT`.`DEPTNO`))");
    }

    @Test
    void testCollectionTableWithLateral2() {
        String sql = "select * from dept as d\ncross join lateral table(ramp(dept.deptno)) as r";
        String expected = "SELECT *\nFROM `DEPT` AS `D`\nCROSS JOIN LATERAL TABLE(`RAMP`(`DEPT`.`DEPTNO`)) AS `R`";
        this.sql("select * from dept as d\ncross join lateral table(ramp(dept.deptno)) as r").ok("SELECT *\nFROM `DEPT` AS `D`\nCROSS JOIN LATERAL TABLE(`RAMP`(`DEPT`.`DEPTNO`)) AS `R`");
    }

    @Test
    void testCollectionTableWithLateral3() {
        String sql = "select * from lateral table(ramp(dept.deptno)), dept";
        String expected = "SELECT *\nFROM LATERAL TABLE(`RAMP`(`DEPT`.`DEPTNO`)),\n`DEPT`";
        this.sql("select * from lateral table(ramp(dept.deptno)), dept").ok("SELECT *\nFROM LATERAL TABLE(`RAMP`(`DEPT`.`DEPTNO`)),\n`DEPT`");
    }

    @Test
    void testTableFunctionWithTableWrapper() {
        String sql = "select * from table(score(table orders))";
        String expected = "SELECT *\nFROM TABLE(`SCORE`((TABLE `ORDERS`)))";
        this.sql("select * from table(score(table orders))").ok("SELECT *\nFROM TABLE(`SCORE`((TABLE `ORDERS`)))");
    }

    @Test
    void testTableFunctionWithoutTableWrapper() {
        String sql = "select * from score(table orders)";
        String expected = "SELECT *\nFROM TABLE(`SCORE`((TABLE `ORDERS`)))";
        this.sql("select * from score(table orders)").ok("SELECT *\nFROM TABLE(`SCORE`((TABLE `ORDERS`)))");
    }

    @Test
    void testTableFunctionWithPartitionKey() {
        String sql = "select * from table(topn(table orders partition by productid, 3))";
        String expected = "SELECT *\nFROM TABLE(`TOPN`(((TABLE `ORDERS`) PARTITION BY `PRODUCTID`), 3))";
        this.sql("select * from table(topn(table orders partition by productid, 3))").ok("SELECT *\nFROM TABLE(`TOPN`(((TABLE `ORDERS`) PARTITION BY `PRODUCTID`), 3))");
    }

    @Test
    void testTableFunctionWithMultiplePartitionKeys() {
        String sql = "select * from table(topn(table orders partition by (orderId, productid), 3))";
        String expected = "SELECT *\nFROM TABLE(`TOPN`(((TABLE `ORDERS`) PARTITION BY `ORDERID`, `PRODUCTID`), 3))";
        this.sql("select * from table(topn(table orders partition by (orderId, productid), 3))").ok("SELECT *\nFROM TABLE(`TOPN`(((TABLE `ORDERS`) PARTITION BY `ORDERID`, `PRODUCTID`), 3))");
    }

    @Test
    void testTableFunctionWithOrderKey() {
        String sql = "select * from table(topn(table orders order by orderId, 3))";
        String expected = "SELECT *\nFROM TABLE(`TOPN`(((TABLE `ORDERS`) ORDER BY `ORDERID`), 3))";
        this.sql("select * from table(topn(table orders order by orderId, 3))").ok("SELECT *\nFROM TABLE(`TOPN`(((TABLE `ORDERS`) ORDER BY `ORDERID`), 3))");
    }

    @Test
    void testTableFunctionWithMultipleOrderKeys() {
        String sql = "select * from table(topn(table orders order by (orderId, productid), 3))";
        String expected = "SELECT *\nFROM TABLE(`TOPN`(((TABLE `ORDERS`) ORDER BY `ORDERID`, `PRODUCTID`), 3))";
        this.sql("select * from table(topn(table orders order by (orderId, productid), 3))").ok("SELECT *\nFROM TABLE(`TOPN`(((TABLE `ORDERS`) ORDER BY `ORDERID`, `PRODUCTID`), 3))");
    }

    @Test
    void testTableFunctionWithComplexOrderBy() {
        String sql = "select * from table(topn(table orders order by (orderId desc, productid asc), 3))";
        String expected = "SELECT *\nFROM TABLE(`TOPN`(((TABLE `ORDERS`) ORDER BY `ORDERID` DESC, `PRODUCTID`), 3))";
        this.sql("select * from table(topn(table orders order by (orderId desc, productid asc), 3))").ok("SELECT *\nFROM TABLE(`TOPN`(((TABLE `ORDERS`) ORDER BY `ORDERID` DESC, `PRODUCTID`), 3))");
    }

    @Test
    void testTableFunctionWithPartitionKeyAndOrderKey() {
        String sql = "select * from table(topn(table orders partition by productid order by orderId, 3))";
        String expected = "SELECT *\nFROM TABLE(`TOPN`(((TABLE `ORDERS`) PARTITION BY `PRODUCTID` ORDER BY `ORDERID`), 3))";
        this.sql("select * from table(topn(table orders partition by productid order by orderId, 3))").ok("SELECT *\nFROM TABLE(`TOPN`(((TABLE `ORDERS`) PARTITION BY `PRODUCTID` ORDER BY `ORDERID`), 3))");
    }

    @Test
    void testTableFunctionWithSubQuery() {
        String sql = "select * from table(topn(select * from Orders partition by productid order by orderId, 3))";
        String expected = "SELECT *\nFROM TABLE(`TOPN`(((SELECT *\nFROM `ORDERS`) PARTITION BY `PRODUCTID` ORDER BY `ORDERID`), 3))";
        this.sql("select * from table(topn(select * from Orders partition by productid order by orderId, 3))").ok("SELECT *\nFROM TABLE(`TOPN`(((SELECT *\nFROM `ORDERS`) PARTITION BY `PRODUCTID` ORDER BY `ORDERID`), 3))");
    }

    @Test
    void testTableFunctionWithMultipleInputTables() {
        String sql = "select * from table(similarlity(table emp, table emp_b))";
        String expected = "SELECT *\nFROM TABLE(`SIMILARLITY`((TABLE `EMP`), (TABLE `EMP_B`)))";
        this.sql("select * from table(similarlity(table emp, table emp_b))").ok("SELECT *\nFROM TABLE(`SIMILARLITY`((TABLE `EMP`), (TABLE `EMP_B`)))");
    }

    @Test
    void testTableFunctionWithMultipleInputTablesAndSubClauses() {
        String sql = "select * from table(similarlity(  table emp partition by deptno order by empno,   table emp_b partition by deptno order by empno))";
        String expected = "SELECT *\nFROM TABLE(`SIMILARLITY`(((TABLE `EMP`) PARTITION BY `DEPTNO` ORDER BY `EMPNO`), ((TABLE `EMP_B`) PARTITION BY `DEPTNO` ORDER BY `EMPNO`)))";
        this.sql("select * from table(similarlity(  table emp partition by deptno order by empno,   table emp_b partition by deptno order by empno))").ok("SELECT *\nFROM TABLE(`SIMILARLITY`(((TABLE `EMP`) PARTITION BY `DEPTNO` ORDER BY `EMPNO`), ((TABLE `EMP_B`) PARTITION BY `DEPTNO` ORDER BY `EMPNO`)))");
    }

    @Test
    void testIllegalCursors() {
        this.sql("select ^cursor^(select * from emps) from emps").fails("CURSOR expression encountered in illegal context");
        this.sql("call list(^cursor^(select * from emps))").fails("CURSOR expression encountered in illegal context");
        this.sql("select f(^cursor^(select * from emps)) from emps").fails("CURSOR expression encountered in illegal context");
    }

    @Test
    void testExplain() {
        String sql = "explain plan for select * from emps";
        String expected = "EXPLAIN PLAN INCLUDING ATTRIBUTES WITH IMPLEMENTATION FOR\nSELECT *\nFROM `EMPS`";
        this.sql("explain plan for select * from emps").ok("EXPLAIN PLAN INCLUDING ATTRIBUTES WITH IMPLEMENTATION FOR\nSELECT *\nFROM `EMPS`");
    }

    @Test
    void testExplainAsXml() {
        String sql = "explain plan as xml for select * from emps";
        String expected = "EXPLAIN PLAN INCLUDING ATTRIBUTES WITH IMPLEMENTATION AS XML FOR\nSELECT *\nFROM `EMPS`";
        this.sql("explain plan as xml for select * from emps").ok("EXPLAIN PLAN INCLUDING ATTRIBUTES WITH IMPLEMENTATION AS XML FOR\nSELECT *\nFROM `EMPS`");
    }

    @Test
    void testExplainAsDot() {
        String sql = "explain plan as dot for select * from emps";
        String expected = "EXPLAIN PLAN INCLUDING ATTRIBUTES WITH IMPLEMENTATION AS DOT FOR\nSELECT *\nFROM `EMPS`";
        this.sql("explain plan as dot for select * from emps").ok("EXPLAIN PLAN INCLUDING ATTRIBUTES WITH IMPLEMENTATION AS DOT FOR\nSELECT *\nFROM `EMPS`");
    }

    @Test
    void testExplainAsJson() {
        String sql = "explain plan as json for select * from emps";
        String expected = "EXPLAIN PLAN INCLUDING ATTRIBUTES WITH IMPLEMENTATION AS JSON FOR\nSELECT *\nFROM `EMPS`";
        this.sql("explain plan as json for select * from emps").ok("EXPLAIN PLAN INCLUDING ATTRIBUTES WITH IMPLEMENTATION AS JSON FOR\nSELECT *\nFROM `EMPS`");
    }

    @Test
    void testExplainWithImpl() {
        this.sql("explain plan with implementation for select * from emps").ok("EXPLAIN PLAN INCLUDING ATTRIBUTES WITH IMPLEMENTATION FOR\nSELECT *\nFROM `EMPS`");
    }

    @Test
    void testExplainWithoutImpl() {
        this.sql("explain plan without implementation for select * from emps").ok("EXPLAIN PLAN INCLUDING ATTRIBUTES WITHOUT IMPLEMENTATION FOR\nSELECT *\nFROM `EMPS`");
    }

    @Test
    void testExplainWithType() {
        this.sql("explain plan with type for (values (true))").ok("EXPLAIN PLAN INCLUDING ATTRIBUTES WITH TYPE FOR\n(VALUES (ROW(TRUE)))");
    }

    @Test
    void testExplainJsonFormat() {
        SqlExplain sqlExplain = (SqlExplain)this.sql("explain plan as json for select * from emps").node();
        MatcherAssert.assertThat((Object)sqlExplain.isJson(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void testDescribeSchema() {
        this.sql("describe schema A").ok("DESCRIBE SCHEMA `A`");
        this.sql("describe database A").ok("DESCRIBE SCHEMA `A`");
        this.sql("describe catalog A").ok("DESCRIBE SCHEMA `A`");
    }

    @Test
    void testDescribeTable() {
        this.sql("describe emps").ok("DESCRIBE TABLE `EMPS`");
        this.sql("describe \"emps\"").ok("DESCRIBE TABLE `emps`");
        this.sql("describe s.emps").ok("DESCRIBE TABLE `S`.`EMPS`");
        this.sql("describe db.c.s.emps").ok("DESCRIBE TABLE `DB`.`C`.`S`.`EMPS`");
        this.sql("describe emps col1").ok("DESCRIBE TABLE `EMPS` `COL1`");
        this.sql("describe foo-bar.baz").withDialect(BIG_QUERY).ok("DESCRIBE TABLE `foo-bar`.baz");
        this.sql("describe table foo-bar.baz").withDialect(BIG_QUERY).ok("DESCRIBE TABLE `foo-bar`.baz");
        this.sql("describe table emps col1").ok("DESCRIBE TABLE `EMPS` `COL1`");
        this.sql("describe emps ^'col_'^").fails("(?s).*Encountered \"\\\\'col_\\\\'\" at .*");
        this.sql("describe emps c1^.^c2").fails("(?s).*Encountered \"\\.\" at .*");
    }

    @Test
    void testDescribeStatement() {
        String expected0 = "EXPLAIN PLAN INCLUDING ATTRIBUTES WITH IMPLEMENTATION FOR\nSELECT *\nFROM `EMPS`";
        this.sql("describe statement select * from emps").ok("EXPLAIN PLAN INCLUDING ATTRIBUTES WITH IMPLEMENTATION FOR\nSELECT *\nFROM `EMPS`");
        String expected1 = "EXPLAIN PLAN INCLUDING ATTRIBUTES WITH IMPLEMENTATION FOR\n(SELECT *\nFROM `EMPS`\nORDER BY 2)";
        this.sql("describe statement select * from emps order by 2").ok("EXPLAIN PLAN INCLUDING ATTRIBUTES WITH IMPLEMENTATION FOR\n(SELECT *\nFROM `EMPS`\nORDER BY 2)");
        this.sql("describe select * from emps").ok("EXPLAIN PLAN INCLUDING ATTRIBUTES WITH IMPLEMENTATION FOR\nSELECT *\nFROM `EMPS`");
        this.sql("describe (select * from emps)").ok("EXPLAIN PLAN INCLUDING ATTRIBUTES WITH IMPLEMENTATION FOR\nSELECT *\nFROM `EMPS`");
        this.sql("describe statement (select * from emps)").ok("EXPLAIN PLAN INCLUDING ATTRIBUTES WITH IMPLEMENTATION FOR\nSELECT *\nFROM `EMPS`");
        String expected2 = "EXPLAIN PLAN INCLUDING ATTRIBUTES WITH IMPLEMENTATION FOR\nSELECT `DEPTNO`\nFROM `EMPS`\nUNION\nSELECT `DEPTNO`\nFROM `DEPTS`";
        this.sql("describe select deptno from emps union select deptno from depts").ok("EXPLAIN PLAN INCLUDING ATTRIBUTES WITH IMPLEMENTATION FOR\nSELECT `DEPTNO`\nFROM `EMPS`\nUNION\nSELECT `DEPTNO`\nFROM `DEPTS`");
        String expected3 = "EXPLAIN PLAN INCLUDING ATTRIBUTES WITH IMPLEMENTATION FOR\nINSERT INTO `EMPS`\nVALUES (ROW(1, 'a'))";
        this.sql("describe insert into emps values (1, 'a')").ok("EXPLAIN PLAN INCLUDING ATTRIBUTES WITH IMPLEMENTATION FOR\nINSERT INTO `EMPS`\nVALUES (ROW(1, 'a'))");
        this.sql("describe ^explain^ plan for select * from emps").fails("(?s).*Encountered \"explain\" at .*");
        this.sql("describe statement ^explain^ plan for select * from emps").fails("(?s).*Encountered \"explain\" at .*");
    }

    @Test
    void testSelectIsNotDdl() {
        this.sql("select 1 from t").node((Matcher<SqlNode>)CoreMatchers.not(SqlParserTest.isDdl()));
    }

    @Test
    void testInsertSelect() {
        String expected = "INSERT INTO `EMPS`\nSELECT *\nFROM `EMPS`";
        this.sql("insert into emps select * from emps").ok("INSERT INTO `EMPS`\nSELECT *\nFROM `EMPS`").node((Matcher<SqlNode>)CoreMatchers.not(SqlParserTest.isDdl()));
    }

    @Test
    void testInsertUnion() {
        String expected = "INSERT INTO `EMPS`\nSELECT *\nFROM `EMPS1`\nUNION\nSELECT *\nFROM `EMPS2`";
        this.sql("insert into emps select * from emps1 union select * from emps2").ok("INSERT INTO `EMPS`\nSELECT *\nFROM `EMPS1`\nUNION\nSELECT *\nFROM `EMPS2`");
    }

    @Test
    void testInsertValues() {
        String expected = "INSERT INTO `EMPS`\nVALUES (ROW(1, 'Fredkin'))";
        String pattern = "VALUE is not allowed under the current SQL conformance level";
        this.sql("insert into emps values (1,'Fredkin')").ok("INSERT INTO `EMPS`\nVALUES (ROW(1, 'Fredkin'))").node((Matcher<SqlNode>)CoreMatchers.not(SqlParserTest.isDdl()));
        this.sql("insert into emps value (1, 'Fredkin')").withConformance((SqlConformance)SqlConformanceEnum.MYSQL_5).ok("INSERT INTO `EMPS`\nVALUES (ROW(1, 'Fredkin'))").node((Matcher<SqlNode>)CoreMatchers.not(SqlParserTest.isDdl()));
        this.sql("insert into emps ^value^ (1, 'Fredkin')").fails("VALUE is not allowed under the current SQL conformance level");
    }

    @Test
    void testInsertValuesDefault() {
        String expected = "INSERT INTO `EMPS`\nVALUES (ROW(1, DEFAULT, 'Fredkin'))";
        this.sql("insert into emps values (1,DEFAULT,'Fredkin')").ok("INSERT INTO `EMPS`\nVALUES (ROW(1, DEFAULT, 'Fredkin'))").node((Matcher<SqlNode>)CoreMatchers.not(SqlParserTest.isDdl()));
    }

    @Test
    void testInsertValuesRawDefault() {
        String expected = "INSERT INTO `EMPS`\nVALUES (ROW(DEFAULT))";
        this.sql("insert into emps values ^default^").fails("(?s).*Encountered \"default\" at .*");
        this.sql("insert into emps values (default)").ok("INSERT INTO `EMPS`\nVALUES (ROW(DEFAULT))").node((Matcher<SqlNode>)CoreMatchers.not(SqlParserTest.isDdl()));
    }

    @Test
    void testInsertColumnList() {
        String expected = "INSERT INTO `EMPS` (`X`, `Y`)\nSELECT *\nFROM `EMPS`";
        this.sql("insert into emps(x,y) select * from emps").ok("INSERT INTO `EMPS` (`X`, `Y`)\nSELECT *\nFROM `EMPS`");
    }

    @Test
    void testInsertCaseSensitiveColumnList() {
        String expected = "INSERT INTO `emps` (`x`, `y`)\nSELECT *\nFROM `EMPS`";
        this.sql("insert into \"emps\"(\"x\",\"y\") select * from emps").ok("INSERT INTO `emps` (`x`, `y`)\nSELECT *\nFROM `EMPS`");
    }

    @Test
    void testInsertExtendedColumnList() {
        String expected = "INSERT INTO `EMPS` EXTEND (`Z` BOOLEAN) (`X`, `Y`)\nSELECT *\nFROM `EMPS`";
        this.sql("insert into emps(z boolean)(x,y) select * from emps").ok(expected);
        expected = "INSERT INTO `EMPS` EXTEND (`Z` BOOLEAN) (`X`, `Y`, `Z`)\nSELECT *\nFROM `EMPS`";
        this.sql("insert into emps(x, y, z boolean) select * from emps").withConformance((SqlConformance)SqlConformanceEnum.LENIENT).ok(expected);
    }

    @Test
    void testUpdateExtendedColumnList() {
        String expected = "UPDATE `EMPDEFAULTS` EXTEND (`EXTRA` BOOLEAN, `NOTE` VARCHAR) SET `DEPTNO` = 1, `EXTRA` = TRUE, `EMPNO` = 20, `ENAME` = 'Bob', `NOTE` = 'legion'\nWHERE (`DEPTNO` = 10)";
        this.sql("update empdefaults(extra BOOLEAN, note VARCHAR) set deptno = 1, extra = true, empno = 20, ename = 'Bob', note = 'legion' where deptno = 10").ok("UPDATE `EMPDEFAULTS` EXTEND (`EXTRA` BOOLEAN, `NOTE` VARCHAR) SET `DEPTNO` = 1, `EXTRA` = TRUE, `EMPNO` = 20, `ENAME` = 'Bob', `NOTE` = 'legion'\nWHERE (`DEPTNO` = 10)");
    }

    @Test
    void testUpdateCaseSensitiveExtendedColumnList() {
        String expected = "UPDATE `EMPDEFAULTS` EXTEND (`extra` BOOLEAN, `NOTE` VARCHAR) SET `DEPTNO` = 1, `extra` = TRUE, `EMPNO` = 20, `ENAME` = 'Bob', `NOTE` = 'legion'\nWHERE (`DEPTNO` = 10)";
        this.sql("update empdefaults(\"extra\" BOOLEAN, note VARCHAR) set deptno = 1, \"extra\" = true, empno = 20, ename = 'Bob', note = 'legion' where deptno = 10").ok("UPDATE `EMPDEFAULTS` EXTEND (`extra` BOOLEAN, `NOTE` VARCHAR) SET `DEPTNO` = 1, `extra` = TRUE, `EMPNO` = 20, `ENAME` = 'Bob', `NOTE` = 'legion'\nWHERE (`DEPTNO` = 10)");
    }

    @Test
    void testInsertCaseSensitiveExtendedColumnList() {
        String expected = "INSERT INTO `emps` EXTEND (`z` BOOLEAN) (`x`, `y`)\nSELECT *\nFROM `EMPS`";
        this.sql("insert into \"emps\"(\"z\" boolean)(\"x\",\"y\") select * from emps").ok(expected);
        expected = "INSERT INTO `emps` EXTEND (`z` BOOLEAN) (`x`, `y`, `z`)\nSELECT *\nFROM `EMPS`";
        this.sql("insert into \"emps\"(\"x\", \"y\", \"z\" boolean) select * from emps").withConformance((SqlConformance)SqlConformanceEnum.LENIENT).ok(expected);
    }

    @Test
    void testExplainInsert() {
        String expected = "EXPLAIN PLAN INCLUDING ATTRIBUTES WITH IMPLEMENTATION FOR\nINSERT INTO `EMPS1`\nSELECT *\nFROM `EMPS2`";
        this.sql("explain plan for insert into emps1 select * from emps2").ok("EXPLAIN PLAN INCLUDING ATTRIBUTES WITH IMPLEMENTATION FOR\nINSERT INTO `EMPS1`\nSELECT *\nFROM `EMPS2`").node((Matcher<SqlNode>)CoreMatchers.not(SqlParserTest.isDdl()));
    }

    @Test
    void testUpsertValues() {
        String expected = "UPSERT INTO `EMPS`\nVALUES (ROW(1, 'Fredkin'))";
        String sql = "upsert into emps values (1,'Fredkin')";
        if (this.isReserved("UPSERT")) {
            this.sql("upsert into emps values (1,'Fredkin')").ok("UPSERT INTO `EMPS`\nVALUES (ROW(1, 'Fredkin'))").node((Matcher<SqlNode>)CoreMatchers.not(SqlParserTest.isDdl()));
        }
    }

    @Test
    void testUpsertSelect() {
        String sql = "upsert into emps select * from emp as e";
        String expected = "UPSERT INTO `EMPS`\nSELECT *\nFROM `EMP` AS `E`";
        if (this.isReserved("UPSERT")) {
            this.sql("upsert into emps select * from emp as e").ok("UPSERT INTO `EMPS`\nSELECT *\nFROM `EMP` AS `E`");
        }
    }

    @Test
    void testExplainUpsert() {
        String sql = "explain plan for upsert into emps1 values (1, 2)";
        String expected = "EXPLAIN PLAN INCLUDING ATTRIBUTES WITH IMPLEMENTATION FOR\nUPSERT INTO `EMPS1`\nVALUES (ROW(1, 2))";
        if (this.isReserved("UPSERT")) {
            this.sql("explain plan for upsert into emps1 values (1, 2)").ok("EXPLAIN PLAN INCLUDING ATTRIBUTES WITH IMPLEMENTATION FOR\nUPSERT INTO `EMPS1`\nVALUES (ROW(1, 2))");
        }
    }

    @Test
    void testDelete() {
        this.sql("delete from emps").ok("DELETE FROM `EMPS`").node((Matcher<SqlNode>)CoreMatchers.not(SqlParserTest.isDdl()));
    }

    @Test
    void testDeleteWhere() {
        this.sql("delete from emps where empno=12").ok("DELETE FROM `EMPS`\nWHERE (`EMPNO` = 12)");
    }

    @Test
    void testUpdate() {
        this.sql("update emps set empno = empno + 1, sal = sal - 1 where empno=12").ok("UPDATE `EMPS` SET `EMPNO` = (`EMPNO` + 1), `SAL` = (`SAL` - 1)\nWHERE (`EMPNO` = 12)");
    }

    @Test
    void testUpdateTableAlias() {
        String sql = "UPDATE mytable AS t SET t.ID=1";
        String expected = "UPDATE `MYTABLE` AS `T` SET `T`.`ID` = 1";
        this.sql("UPDATE mytable AS t SET t.ID=1").ok("UPDATE `MYTABLE` AS `T` SET `T`.`ID` = 1");
        String sql2 = "UPDATE scott.mytable SET scott.mytable.ID=1";
        String expected2 = "UPDATE `SCOTT`.`MYTABLE` SET `SCOTT`.`MYTABLE`.`ID` = 1";
        this.sql("UPDATE scott.mytable SET scott.mytable.ID=1").ok("UPDATE `SCOTT`.`MYTABLE` SET `SCOTT`.`MYTABLE`.`ID` = 1");
    }

    @Test
    void testMergeSelectSource() {
        String sql = "merge into emps e using (select * from tempemps where deptno is null) t on e.empno = t.empno when matched then update set name = t.name, deptno = t.deptno, salary = t.salary * .1 when not matched then insert (name, dept, salary) values(t.name, 10, t.salary * .15)";
        String expected = "MERGE INTO `EMPS` AS `E`\nUSING (SELECT *\nFROM `TEMPEMPS`\nWHERE (`DEPTNO` IS NULL)) AS `T`\nON (`E`.`EMPNO` = `T`.`EMPNO`)\nWHEN MATCHED THEN UPDATE SET `NAME` = `T`.`NAME`, `DEPTNO` = `T`.`DEPTNO`, `SALARY` = (`T`.`SALARY` * 0.1)\nWHEN NOT MATCHED THEN INSERT (`NAME`, `DEPT`, `SALARY`) VALUES (ROW(`T`.`NAME`, 10, (`T`.`SALARY` * 0.15)))";
        this.sql("merge into emps e using (select * from tempemps where deptno is null) t on e.empno = t.empno when matched then update set name = t.name, deptno = t.deptno, salary = t.salary * .1 when not matched then insert (name, dept, salary) values(t.name, 10, t.salary * .15)").ok("MERGE INTO `EMPS` AS `E`\nUSING (SELECT *\nFROM `TEMPEMPS`\nWHERE (`DEPTNO` IS NULL)) AS `T`\nON (`E`.`EMPNO` = `T`.`EMPNO`)\nWHEN MATCHED THEN UPDATE SET `NAME` = `T`.`NAME`, `DEPTNO` = `T`.`DEPTNO`, `SALARY` = (`T`.`SALARY` * 0.1)\nWHEN NOT MATCHED THEN INSERT (`NAME`, `DEPT`, `SALARY`) VALUES (ROW(`T`.`NAME`, 10, (`T`.`SALARY` * 0.15)))").node((Matcher<SqlNode>)CoreMatchers.not(SqlParserTest.isDdl()));
    }

    @Test
    void testMergeSelectSource2() {
        String sql = "merge into emps e using (select * from tempemps where deptno is null) t on e.empno = t.empno when matched then update set e.name = t.name, e.deptno = t.deptno, e.salary = t.salary * .1 when not matched then insert (name, dept, salary) values(t.name, 10, t.salary * .15)";
        String expected = "MERGE INTO `EMPS` AS `E`\nUSING (SELECT *\nFROM `TEMPEMPS`\nWHERE (`DEPTNO` IS NULL)) AS `T`\nON (`E`.`EMPNO` = `T`.`EMPNO`)\nWHEN MATCHED THEN UPDATE SET `E`.`NAME` = `T`.`NAME`, `E`.`DEPTNO` = `T`.`DEPTNO`, `E`.`SALARY` = (`T`.`SALARY` * 0.1)\nWHEN NOT MATCHED THEN INSERT (`NAME`, `DEPT`, `SALARY`) VALUES (ROW(`T`.`NAME`, 10, (`T`.`SALARY` * 0.15)))";
        this.sql("merge into emps e using (select * from tempemps where deptno is null) t on e.empno = t.empno when matched then update set e.name = t.name, e.deptno = t.deptno, e.salary = t.salary * .1 when not matched then insert (name, dept, salary) values(t.name, 10, t.salary * .15)").ok("MERGE INTO `EMPS` AS `E`\nUSING (SELECT *\nFROM `TEMPEMPS`\nWHERE (`DEPTNO` IS NULL)) AS `T`\nON (`E`.`EMPNO` = `T`.`EMPNO`)\nWHEN MATCHED THEN UPDATE SET `E`.`NAME` = `T`.`NAME`, `E`.`DEPTNO` = `T`.`DEPTNO`, `E`.`SALARY` = (`T`.`SALARY` * 0.1)\nWHEN NOT MATCHED THEN INSERT (`NAME`, `DEPT`, `SALARY`) VALUES (ROW(`T`.`NAME`, 10, (`T`.`SALARY` * 0.15)))").node((Matcher<SqlNode>)CoreMatchers.not(SqlParserTest.isDdl()));
    }

    @Test
    void testMergeTableRefSource() {
        String sql = "merge into emps e using tempemps as t on e.empno = t.empno when matched then update set name = t.name, deptno = t.deptno, salary = t.salary * .1 when not matched then insert (name, dept, salary) values(t.name, 10, t.salary * .15)";
        String expected = "MERGE INTO `EMPS` AS `E`\nUSING `TEMPEMPS` AS `T`\nON (`E`.`EMPNO` = `T`.`EMPNO`)\nWHEN MATCHED THEN UPDATE SET `NAME` = `T`.`NAME`, `DEPTNO` = `T`.`DEPTNO`, `SALARY` = (`T`.`SALARY` * 0.1)\nWHEN NOT MATCHED THEN INSERT (`NAME`, `DEPT`, `SALARY`) VALUES (ROW(`T`.`NAME`, 10, (`T`.`SALARY` * 0.15)))";
        this.sql("merge into emps e using tempemps as t on e.empno = t.empno when matched then update set name = t.name, deptno = t.deptno, salary = t.salary * .1 when not matched then insert (name, dept, salary) values(t.name, 10, t.salary * .15)").ok("MERGE INTO `EMPS` AS `E`\nUSING `TEMPEMPS` AS `T`\nON (`E`.`EMPNO` = `T`.`EMPNO`)\nWHEN MATCHED THEN UPDATE SET `NAME` = `T`.`NAME`, `DEPTNO` = `T`.`DEPTNO`, `SALARY` = (`T`.`SALARY` * 0.1)\nWHEN NOT MATCHED THEN INSERT (`NAME`, `DEPT`, `SALARY`) VALUES (ROW(`T`.`NAME`, 10, (`T`.`SALARY` * 0.15)))");
    }

    @Test
    void testMergeTableRefSource2() {
        String sql = "merge into emps e using tempemps as t on e.empno = t.empno when matched then update set e.name = t.name, e.deptno = t.deptno, e.salary = t.salary * .1 when not matched then insert (name, dept, salary) values(t.name, 10, t.salary * .15)";
        String expected = "MERGE INTO `EMPS` AS `E`\nUSING `TEMPEMPS` AS `T`\nON (`E`.`EMPNO` = `T`.`EMPNO`)\nWHEN MATCHED THEN UPDATE SET `E`.`NAME` = `T`.`NAME`, `E`.`DEPTNO` = `T`.`DEPTNO`, `E`.`SALARY` = (`T`.`SALARY` * 0.1)\nWHEN NOT MATCHED THEN INSERT (`NAME`, `DEPT`, `SALARY`) VALUES (ROW(`T`.`NAME`, 10, (`T`.`SALARY` * 0.15)))";
        this.sql("merge into emps e using tempemps as t on e.empno = t.empno when matched then update set e.name = t.name, e.deptno = t.deptno, e.salary = t.salary * .1 when not matched then insert (name, dept, salary) values(t.name, 10, t.salary * .15)").ok("MERGE INTO `EMPS` AS `E`\nUSING `TEMPEMPS` AS `T`\nON (`E`.`EMPNO` = `T`.`EMPNO`)\nWHEN MATCHED THEN UPDATE SET `E`.`NAME` = `T`.`NAME`, `E`.`DEPTNO` = `T`.`DEPTNO`, `E`.`SALARY` = (`T`.`SALARY` * 0.1)\nWHEN NOT MATCHED THEN INSERT (`NAME`, `DEPT`, `SALARY`) VALUES (ROW(`T`.`NAME`, 10, (`T`.`SALARY` * 0.15)))");
    }

    @Test
    void testMergeMismatchedParentheses() {
        String sql1 = "merge into emps as e\nusing temps as t on e.empno = t.empno\nwhen not matched\nthen insert (a, b) (values (1, 2^)^";
        this.sql("merge into emps as e\nusing temps as t on e.empno = t.empno\nwhen not matched\nthen insert (a, b) (values (1, 2^)^").fails("(?s)Encountered \"<EOF>\" at .*");
        String sql1b = "merge into emps as e\nusing temps as t on e.empno = t.empno\nwhen not matched\nthen insert (a, b) values (1, 2)^)^";
        this.sql("merge into emps as e\nusing temps as t on e.empno = t.empno\nwhen not matched\nthen insert (a, b) values (1, 2)^)^").fails("(?s)Encountered \"\\)\" at .*");
        String sql2 = "merge into emps as e\nusing temps as t on e.empno = t.empno\nwhen not matched\nthen insert (a, b) (values (1, 2))";
        String expected = "MERGE INTO `EMPS` AS `E`\nUSING `TEMPS` AS `T`\nON (`E`.`EMPNO` = `T`.`EMPNO`)\nWHEN NOT MATCHED THEN INSERT (`A`, `B`) VALUES (ROW(1, 2))";
        this.sql("merge into emps as e\nusing temps as t on e.empno = t.empno\nwhen not matched\nthen insert (a, b) (values (1, 2))").ok("MERGE INTO `EMPS` AS `E`\nUSING `TEMPS` AS `T`\nON (`E`.`EMPNO` = `T`.`EMPNO`)\nWHEN NOT MATCHED THEN INSERT (`A`, `B`) VALUES (ROW(1, 2))");
        String sql3 = "merge into emps as e\nusing temps as t on e.empno = t.empno\nwhen not matched\nthen insert (a, b) values (1, 2)";
        this.sql("merge into emps as e\nusing temps as t on e.empno = t.empno\nwhen not matched\nthen insert (a, b) values (1, 2)").ok("MERGE INTO `EMPS` AS `E`\nUSING `TEMPS` AS `T`\nON (`E`.`EMPNO` = `T`.`EMPNO`)\nWHEN NOT MATCHED THEN INSERT (`A`, `B`) VALUES (ROW(1, 2))");
    }

    @Test
    void testBitStringNotImplemented() {
        this.sql("select (B^'1011'^ || 'foobar') from (values (true))").fails("(?s).*Encountered \"\\\\'1011\\\\'\" at .*");
    }

    @Test
    void testHexAndBinaryString() {
        this.expr("x''=X'2'").ok("(X'' = X'2')");
        this.expr("x'fffff'=X''").ok("(X'FFFFF' = X'')");
        this.expr("x'1' \t\t\f\r\n'2'--hi this is a comment'FF'\r\r\t\f\n'34'").ok("X'1'\n'2'\n'34'");
        this.expr("x'1' \t\t\f\r\n'000'--\n'01'").ok("X'1'\n'000'\n'01'");
        this.expr("x'1234567890abcdef'=X'fFeEdDcCbBaA'").ok("(X'1234567890ABCDEF' = X'FFEEDDCCBBAA')");
        this.expr("x'001'=X'000102'").ok("(X'001' = X'000102')");
    }

    @Test
    void testHexAndBinaryStringFails() {
        this.sql("select ^x'FeedGoats'^ from t").fails("Binary literal string must contain only characters '0' - '9', 'A' - 'F'");
        this.sql("select ^x'abcdefG'^ from t").fails("Binary literal string must contain only characters '0' - '9', 'A' - 'F'");
        this.sql("select x'1' ^x'2'^ from t").fails("(?s).*Encountered .x.*2.* at line 1, column 13.*");
        this.sql("select x'1' '2' from t").ok("SELECT X'1'\n'2'\nFROM `T`");
    }

    @Test
    void testStringLiteral() {
        this.expr("_latin1'hi'").ok("_LATIN1'hi'");
        this.expr("N'is it a plane? no it''s superman!'").ok("_ISO-8859-1'is it a plane? no it''s superman!'");
        this.expr("n'lowercase n'").ok("_ISO-8859-1'lowercase n'");
        this.expr("'boring string'").same();
        this.expr("_iSo-8859-1'bye'").ok("_ISO-8859-1'bye'");
        this.expr("'three'\n' blind'\n' mice'").same();
        this.expr("'three' -- comment\n' blind'\n' mice'").ok("'three'\n' blind'\n' mice'");
        this.expr("N'bye' \t\r\f\f\n' bye'").ok("_ISO-8859-1'bye'\n' bye'");
        this.expr("_iso-8859-1'bye'\n\n--\n-- this is a comment\n' bye'").ok("_ISO-8859-1'bye'\n' bye'");
        this.expr("_utf8'hi'").ok("_UTF8'hi'");
        this.expr("'foo\rbar'").same();
        this.expr("'foo\nbar'").same();
        this.expr("'foo\r\nbar'").withConvertToLinux(false).same();
    }

    @Test
    void testStringLiteralFails() {
        this.sql("select (N ^'space'^)").fails("(?s).*Encountered .*space.* at line 1, column ...*");
        this.sql("select (_latin1\n^'newline'^)").fails("(?s).*Encountered.*newline.* at line 2, column ...*");
        this.sql("select ^_unknown-charset''^ from (values(true))").fails("Unknown character set 'unknown-charset'");
        this.sql("select (N'1' '2') from t").ok("SELECT _ISO-8859-1'1'\n'2'\nFROM `T`");
    }

    @Test
    void testStringLiteralChain() {
        String fooBar = "'foo'\n'bar'";
        String fooBarBaz = "'foo'\n'bar'\n'baz'";
        this.expr("   'foo'\r'bar'").ok("'foo'\n'bar'");
        this.expr("   'foo'\r\n'bar'").ok("'foo'\n'bar'");
        this.expr("   'foo'\r\n\r\n'bar'\n'baz'").ok("'foo'\n'bar'\n'baz'");
        this.expr("   'foo' /* a comment */ 'bar'").ok("'foo'\n'bar'");
        this.expr("   'foo' -- a comment\r\n 'bar'").ok("'foo'\n'bar'");
        this.expr("   'foo' 'bar'").ok("'foo'\n'bar'");
    }

    @Test
    void testStringLiteralDoubleQuoted() {
        this.sql("select `deptno` as d, ^\"^deptno\" as d2 from emp").withDialect(MYSQL).fails("(?s)Encountered \"\\\\\"\" at .*").withDialect(BIG_QUERY).ok("SELECT deptno AS d, 'deptno' AS d2\nFROM emp");
        this.sql("select 'Let''s call the dog \"Elvis\"!'").withDialect(MYSQL).node(SqlParserTest.isCharLiteral("Let's call the dog \"Elvis\"!"));
        this.sql("select 'Let\\'\\'s call the dog \"Elvis\"!'").withDialect(BIG_QUERY).node(SqlParserTest.isCharLiteral("Let''s call the dog \"Elvis\"!"));
        this.sql("select 'Let\\'s ^call^ the dog \"Elvis\"!'").withDialect(MYSQL).fails("(?s)Encountered \"call\" at .*").withDialect(BIG_QUERY).node(SqlParserTest.isCharLiteral("Let's call the dog \"Elvis\"!"));
        this.sql("select \"Let's call the dog \\\"Elvis^\\^\"!\"").withDialect(ORACLE).fails("(?s)Lexical error at line 1, column 35\\.  Encountered: \"\\\\\\\\\" \\(92\\), after : \"\".*").withDialect(BIG_QUERY).node(SqlParserTest.isCharLiteral("Let's call the dog \"Elvis\"!"));
    }

    private static Matcher<SqlNode> isCharLiteral(final String s) {
        return new CustomTypeSafeMatcher<SqlNode>(s){

            protected boolean matchesSafely(SqlNode item) {
                SqlNodeList selectList;
                return item instanceof SqlSelect && (selectList = ((SqlSelect)item).getSelectList()).size() == 1 && selectList.get(0) instanceof SqlLiteral && ((String)((SqlLiteral)selectList.get(0)).getValueAs(String.class)).equals(s);
            }
        };
    }

    @Test
    @VisibleForTesting
    public void testCaseExpression() {
        this.expr("case \t col1 when 1 then 'one' end").ok("(CASE WHEN (`COL1` = 1) THEN 'one' ELSE NULL END)");
        this.expr("case when nbr is false then 'one' end").ok("(CASE WHEN (`NBR` IS FALSE) THEN 'one' ELSE NULL END)");
        this.expr("case col1 when\n1.2 then 'one' when 2 then 'two' else 'three' end").ok("(CASE WHEN (`COL1` = 1.2) THEN 'one' WHEN (`COL1` = 2) THEN 'two' ELSE 'three' END)");
        this.expr("case (select * from emp) when 1 then 2 end").ok("(CASE WHEN ((SELECT *\nFROM `EMP`) = 1) THEN 2 ELSE NULL END)");
        this.expr("case 1 when (select * from emp) then 2 end").ok("(CASE WHEN (1 = (SELECT *\nFROM `EMP`)) THEN 2 ELSE NULL END)");
        this.expr("case 1 when 2 then (select * from emp) end").ok("(CASE WHEN (1 = 2) THEN (SELECT *\nFROM `EMP`) ELSE NULL END)");
        this.expr("case 1 when 2 then 3 else (select * from emp) end").ok("(CASE WHEN (1 = 2) THEN 3 ELSE (SELECT *\nFROM `EMP`) END)");
        this.expr("case x when 2, 4 then 3 else 4 end").ok("(CASE WHEN (`X` IN (2, 4)) THEN 3 ELSE 4 END)");
        this.sql("case x when 2, 4 then 3 when ^then^ 5 else 4 end").fails("(?s)Encountered \"then\" at .*");
        this.sql("case when b1, b2 ^when^ 2, 4 then 3 else 4 end").fails("(?s)Encountered \"when\" at .*");
    }

    @Test
    void testCaseExpressionFails() {
        this.sql("select case col1 when 1 then 'one' ^from^ t").fails("(?s).*from.*");
        this.sql("select case col1 ^when1^ then 'one' end from t").fails("(?s).*when1.*");
    }

    @Test
    void testIf() {
        this.expr("if(true, 1, 0)").ok("`IF`(TRUE, 1, 0)");
        this.sql("select 1 as if").ok("SELECT 1 AS `IF`");
    }

    @Test
    void testNullIf() {
        this.expr("nullif(v1,v2)").ok("NULLIF(`V1`, `V2`)");
        if (this.isReserved("NULLIF")) {
            this.expr("1 + ^nullif^ + 3").fails("(?s)Encountered \"nullif \\+\" at line 1, column 5.*");
        }
    }

    @Test
    void testCoalesce() {
        this.expr("coalesce(v1)").ok("COALESCE(`V1`)");
        this.expr("coalesce(v1,v2)").ok("COALESCE(`V1`, `V2`)");
        this.expr("coalesce(v1,v2,v3)").ok("COALESCE(`V1`, `V2`, `V3`)");
    }

    @Test
    void testLiteralCollate() {
    }

    @Test
    void testCharLength() {
        this.expr("char_length('string')").ok("CHAR_LENGTH('string')");
        this.expr("character_length('string')").ok("CHARACTER_LENGTH('string')");
    }

    @Test
    void testPosition() {
        this.expr("posiTion('mouse' in 'house')").ok("POSITION('mouse' IN 'house')");
    }

    @Test
    void testReplace() {
        this.expr("replace('x', 'y', 'z')").ok("REPLACE('x', 'y', 'z')");
    }

    @Test
    void testDateLiteral() {
        String expected = "SELECT DATE '1980-01-01'\nFROM `T`";
        this.sql("select date '1980-01-01' from t").ok("SELECT DATE '1980-01-01'\nFROM `T`");
        String expected1 = "SELECT TIME '00:00:00'\nFROM `T`";
        this.sql("select time '00:00:00' from t").ok("SELECT TIME '00:00:00'\nFROM `T`");
        String expected2 = "SELECT TIMESTAMP '1980-01-01 00:00:00'\nFROM `T`";
        this.sql("select timestamp '1980-01-01 00:00:00' from t").ok("SELECT TIMESTAMP '1980-01-01 00:00:00'\nFROM `T`");
        String expected3 = "SELECT INTERVAL '3' DAY\nFROM `T`";
        this.sql("select interval '3' day from t").ok("SELECT INTERVAL '3' DAY\nFROM `T`");
        String expected4 = "SELECT INTERVAL '5:6' HOUR TO MINUTE\nFROM `T`";
        this.sql("select interval '5:6' hour to minute from t").ok("SELECT INTERVAL '5:6' HOUR TO MINUTE\nFROM `T`");
    }

    @Test
    void testDateLiteralBigQuery() {
        SqlParserFixture f = this.fixture().withDialect(BIG_QUERY);
        f.sql("select date '2020-10-10'").ok("SELECT DATE '2020-10-10'");
        f.sql("select date\"2020-10-10\"").ok("SELECT DATE '2020-10-10'");
        f.sql("select timestamp '2018-02-17 13:22:04'").ok("SELECT TIMESTAMP '2018-02-17 13:22:04'");
        f.sql("select timestamp \"2018-02-17 13:22:04\"").ok("SELECT TIMESTAMP '2018-02-17 13:22:04'");
        f.sql("select time '13:22:04'").ok("SELECT TIME '13:22:04'");
        f.sql("select time \"13:22:04\"").ok("SELECT TIME '13:22:04'");
    }

    @Test
    void testIntervalLiteralBigQuery() {
        SqlParserFixture f = this.fixture().withDialect(BIG_QUERY).expression(true);
        f.sql("interval '1' day").ok("INTERVAL '1' DAY");
        f.sql("interval \"1\" day").ok("INTERVAL '1' DAY");
        f.sql("interval '1:2:3' hour to second").ok("INTERVAL '1:2:3' HOUR TO SECOND");
        f.sql("interval \"1:2:3\" hour to second").ok("INTERVAL '1:2:3' HOUR TO SECOND");
    }

    @Test
    void testTimeDate() {
        this.expr("CURRENT_TIME(3)").same();
        this.expr("CURRENT_TIME").same();
        this.expr("CURRENT_TIME(x+y)").ok("CURRENT_TIME((`X` + `Y`))");
        this.expr("LOCALTIME(3)").same();
        this.expr("LOCALTIME").same();
        this.expr("LOCALTIME(x+y)").ok("LOCALTIME((`X` + `Y`))");
        this.expr("LOCALTIMESTAMP(3)").same();
        this.expr("LOCALTIMESTAMP").same();
        this.expr("LOCALTIMESTAMP(x+y)").ok("LOCALTIMESTAMP((`X` + `Y`))");
        this.expr("CURRENT_DATE(3)").same();
        this.expr("CURRENT_DATE").same();
        this.expr("CURRENT_TIMESTAMP(3)").same();
        this.expr("CURRENT_TIMESTAMP").same();
        this.expr("CURRENT_TIMESTAMP(x+y)").ok("CURRENT_TIMESTAMP((`X` + `Y`))");
        this.expr("DATE '2004-12-01'").same();
        this.expr("TIME '12:01:01'").same();
        this.expr("TIME '12:01:01.'").same();
        this.expr("TIME '12:01:01.000'").same();
        this.expr("TIME '12:01:01.001'").same();
        this.expr("TIME '12:01:01.01023456789'").same();
        this.expr("TIMESTAMP '2004-12-01 12:01:01'").same();
        this.expr("TIMESTAMP '2004-12-01 12:01:01.1'").same();
        this.expr("TIMESTAMP '2004-12-01 12:01:01.'").same();
        this.expr("TIMESTAMP  '2004-12-01 12:01:01.010234567890'").ok("TIMESTAMP '2004-12-01 12:01:01.010234567890'");
        this.expr("TIMESTAMP '2004-12-01 12:01:01.01023456789'").same();
        this.expr("DATETIME '2004-12-01 12:01:01'").same();
        this.expr("^DATE '12/21/99'^").same();
        this.expr("^TIME '1230:33'^").same();
        this.expr("^TIME '12:00:00 PM'^").same();
        this.expr("^TIME WITH LOCAL TIME ZONE '12:00:00 PM'^").same();
        this.expr("^TIME WITH TIME ZONE '12:00:00 PM GMT+0:00'^").same();
        this.expr("TIMESTAMP '12-21-99, 12:30:00'").same();
        this.expr("TIMESTAMP WITH LOCAL TIME ZONE '12-21-99, 12:30:00'").same();
        this.expr("TIMESTAMP WITH TIME ZONE '12-21-99, 12:30:00 GMT+0:00'").same();
        this.expr("DATETIME '12-21-99, 12:30:00'").same();
    }

    @Test
    void testDateTimeCast() {
        this.expr("CAST('2001-12-21' AS DATE)").same();
        this.expr("CAST(12 AS DATE)").same();
        this.sql("CAST('2000-12-21' AS DATE ^NOT^ NULL)").fails("(?s).*Encountered \"NOT\" at line 1, column 27.*");
        this.sql("CAST('foo' as ^1^)").fails("(?s).*Encountered \"1\" at line 1, column 15.*");
        this.expr("Cast(DATE '2004-12-21' AS VARCHAR(10))").ok("CAST(DATE '2004-12-21' AS VARCHAR(10))");
    }

    @Test
    void testTrim() {
        this.expr("trim('mustache' FROM 'beard')").ok("TRIM(BOTH 'mustache' FROM 'beard')");
        this.expr("trim('mustache')").ok("TRIM(BOTH ' ' FROM 'mustache')");
        this.expr("trim(TRAILING FROM 'mustache')").ok("TRIM(TRAILING ' ' FROM 'mustache')");
        this.expr("trim(bOth 'mustache' FROM 'beard')").ok("TRIM(BOTH 'mustache' FROM 'beard')");
        this.expr("trim( lEaDing       'mustache' FROM 'beard')").ok("TRIM(LEADING 'mustache' FROM 'beard')");
        this.expr("trim(\r\n\ttrailing\n  'mustache' FROM 'beard')").ok("TRIM(TRAILING 'mustache' FROM 'beard')");
        this.expr("trim (coalesce(cast(null as varchar(2)))||' '||coalesce('junk ',''))").ok("TRIM(BOTH ' ' FROM ((COALESCE(CAST(NULL AS VARCHAR(2))) || ' ') || COALESCE('junk ', '')))");
        this.sql("trim(^from^ 'beard')").fails("(?s).*'FROM' without operands preceding it is illegal.*");
    }

    @Test
    void testConvertAndTranslate() {
        this.expr("convert('abc', utf8, utf16)").ok("CONVERT('abc', `UTF8`, `UTF16`)");
        this.sql("select convert(name, latin1, gbk) as newName from t").ok("SELECT CONVERT(`NAME`, `LATIN1`, `GBK`) AS `NEWNAME`\nFROM `T`");
        this.expr("convert('abc' using utf8)").ok("TRANSLATE('abc' USING `UTF8`)");
        this.sql("select convert(name using gbk) as newName from t").ok("SELECT TRANSLATE(`NAME` USING `GBK`) AS `NEWNAME`\nFROM `T`");
        this.expr("translate('abc' using lazy_translation)").ok("TRANSLATE('abc' USING `LAZY_TRANSLATION`)");
        this.sql("select translate(name using utf8) as newName from t").ok("SELECT TRANSLATE(`NAME` USING `UTF8`) AS `NEWNAME`\nFROM `T`");
        this.sql("select translate(col using utf8)\nfrom (select 'a' as col\n from (values(true)))\n").ok("SELECT TRANSLATE(`COL` USING `UTF8`)\nFROM (SELECT 'a' AS `COL`\nFROM (VALUES (ROW(TRUE))))");
    }

    @Test
    void testTranslate3() {
        this.expr("translate('aaabbbccc', 'ab', '+-')").ok("TRANSLATE('aaabbbccc', 'ab', '+-')");
    }

    @Test
    void testOverlay() {
        this.expr("overlay('ABCdef' placing 'abc' from 1)").ok("OVERLAY('ABCdef' PLACING 'abc' FROM 1)");
        this.expr("overlay('ABCdef' placing 'abc' from 1 for 3)").ok("OVERLAY('ABCdef' PLACING 'abc' FROM 1 FOR 3)");
    }

    @Test
    void testJdbcFunctionCall() {
        this.expr("{fn apa(1,'1')}").ok("{fn APA(1, '1') }");
        this.expr("{ Fn apa(log10(ln(1))+2)}").ok("{fn APA((LOG10(LN(1)) + 2)) }");
        this.expr("{fN apa(*)}").ok("{fn APA(*) }");
        this.expr("{   FN\t\r\n apa()}").ok("{fn APA() }");
        this.expr("{fn insert()}").ok("{fn INSERT() }");
        this.expr("{fn convert(foo, SQL_VARCHAR)}").ok("{fn CONVERT(`FOO`, SQL_VARCHAR) }");
        this.expr("{fn convert(log10(100), integer)}").ok("{fn CONVERT(LOG10(100), SQL_INTEGER) }");
        this.expr("{fn convert(1, SQL_INTERVAL_YEAR)}").ok("{fn CONVERT(1, SQL_INTERVAL_YEAR) }");
        this.expr("{fn convert(1, SQL_INTERVAL_YEAR_TO_MONTH)}").ok("{fn CONVERT(1, SQL_INTERVAL_YEAR_TO_MONTH) }");
        this.expr("{fn convert(1, ^sql_interval_year_to_day^)}").fails("(?s)Encountered \"sql_interval_year_to_day\" at line 1, column 16\\.\n.*");
        this.expr("{fn convert(1, sql_interval_day)}").ok("{fn CONVERT(1, SQL_INTERVAL_DAY) }");
        this.expr("{fn convert(1, sql_interval_day_to_minute)}").ok("{fn CONVERT(1, SQL_INTERVAL_DAY_TO_MINUTE) }");
        this.expr("{fn convert(^)^}").fails("(?s)Encountered \"\\)\" at.*");
        this.expr("{fn convert(\"123\", SMALLINT^(^3)}").fails("(?s)Encountered \"\\(\" at.*");
        this.expr("{fn convert(1, INTEGER)}").ok("{fn CONVERT(1, SQL_INTEGER) }");
        this.expr("{fn convert(1, VARCHAR)}").ok("{fn CONVERT(1, SQL_VARCHAR) }");
        this.expr("{fn convert(1, VARCHAR^(^5))}").fails("(?s)Encountered \"\\(\" at.*");
        this.expr("{fn convert(1, ^INTERVAL^ YEAR TO MONTH)}").fails("(?s)Encountered \"INTERVAL\" at.*");
        this.expr("{fn convert(1, ^INTERVAL^ YEAR)}").fails("(?s)Encountered \"INTERVAL\" at.*");
    }

    @Test
    void testWindowReference() {
        this.expr("sum(sal) over (w)").ok("(SUM(`SAL`) OVER (`W`))");
        this.expr("sum(sal) over (w ^w1^ partition by deptno)").fails("(?s)Encountered \"w1\" at.*");
    }

    @Test
    void testWindowInSubQuery() {
        String sql = "select * from (\n select sum(x) over w, sum(y) over w\n from s\n window w as (range interval '1' minute preceding))";
        String expected = "SELECT *\nFROM (SELECT (SUM(`X`) OVER `W`), (SUM(`Y`) OVER `W`)\nFROM `S`\nWINDOW `W` AS (RANGE INTERVAL '1' MINUTE PRECEDING))";
        this.sql("select * from (\n select sum(x) over w, sum(y) over w\n from s\n window w as (range interval '1' minute preceding))").ok("SELECT *\nFROM (SELECT (SUM(`X`) OVER `W`), (SUM(`Y`) OVER `W`)\nFROM `S`\nWINDOW `W` AS (RANGE INTERVAL '1' MINUTE PRECEDING))");
    }

    @Test
    void testWindowSpec() {
        String sql1 = "select count(z) over w as foo\nfrom Bids\nwindow w as (partition by y + yy, yyy\n order by x\n rows between 2 preceding and 2 following)";
        String expected1 = "SELECT (COUNT(`Z`) OVER `W`) AS `FOO`\nFROM `BIDS`\nWINDOW `W` AS (PARTITION BY (`Y` + `YY`), `YYY` ORDER BY `X` ROWS BETWEEN 2 PRECEDING AND 2 FOLLOWING)";
        this.sql("select count(z) over w as foo\nfrom Bids\nwindow w as (partition by y + yy, yyy\n order by x\n rows between 2 preceding and 2 following)").ok("SELECT (COUNT(`Z`) OVER `W`) AS `FOO`\nFROM `BIDS`\nWINDOW `W` AS (PARTITION BY (`Y` + `YY`), `YYY` ORDER BY `X` ROWS BETWEEN 2 PRECEDING AND 2 FOLLOWING)");
        String sql2 = "select count(*) over w\nfrom emp window w as (rows 2 preceding)";
        String expected2 = "SELECT (COUNT(*) OVER `W`)\nFROM `EMP`\nWINDOW `W` AS (ROWS 2 PRECEDING)";
        this.sql("select count(*) over w\nfrom emp window w as (rows 2 preceding)").ok("SELECT (COUNT(*) OVER `W`)\nFROM `EMP`\nWINDOW `W` AS (ROWS 2 PRECEDING)");
        String sql3 = "select count(*) over w from emp window w as (\n  rows 'foo' 'bar'\n       'baz' preceding)";
        String expected3 = "SELECT (COUNT(*) OVER `W`)\nFROM `EMP`\nWINDOW `W` AS (ROWS 'foo'\n'bar'\n'baz' PRECEDING)";
        this.sql("select count(*) over w from emp window w as (\n  rows 'foo' 'bar'\n       'baz' preceding)").ok("SELECT (COUNT(*) OVER `W`)\nFROM `EMP`\nWINDOW `W` AS (ROWS 'foo'\n'bar'\n'baz' PRECEDING)");
        String sql4 = "select count(z) over w as foo\nfrom Bids\nwindow w as (partition by y order by x ^partition^ by y)";
        this.sql("select count(z) over w as foo\nfrom Bids\nwindow w as (partition by y order by x ^partition^ by y)").fails("(?s).*Encountered \"partition\".*");
        String sql5 = "select count(z) over w as foo\nfrom Bids window w as (order by x ^partition^ by y)";
        this.sql("select count(z) over w as foo\nfrom Bids window w as (order by x ^partition^ by y)").fails("(?s).*Encountered \"partition\".*");
        this.sql("select sum(a) over (partition by ^(^select 1 from t), x) from t2").fails("Query expression encountered in illegal context");
        String sql7 = "select sum(x) over\n (order by x range between unbounded preceding ^unbounded^ following)";
        this.sql("select sum(x) over\n (order by x range between unbounded preceding ^unbounded^ following)").fails("(?s).*Encountered \"unbounded\".*");
        this.sql("select sum(x) over ^window^ (order by x) from bids").fails("(?s).*Encountered \"window\".*");
        this.sql("select sum(x) over (rows 2 preceding ^order^ by x) from emp").fails("(?s).*Encountered \"order\".*");
    }

    @Test
    void testWindowSpecPartial() {
        this.sql("select sum(x) over (order by x allow partial) from bids").ok("SELECT (SUM(`X`) OVER (ORDER BY `X`))\nFROM `BIDS`");
        this.sql("select sum(x) over (order by x) from bids").ok("SELECT (SUM(`X`) OVER (ORDER BY `X`))\nFROM `BIDS`");
        this.sql("select sum(x) over (order by x disallow partial) from bids").ok("SELECT (SUM(`X`) OVER (ORDER BY `X` DISALLOW PARTIAL))\nFROM `BIDS`");
        this.sql("select sum(x) over (order by x) from bids").ok("SELECT (SUM(`X`) OVER (ORDER BY `X`))\nFROM `BIDS`");
    }

    @Test
    void testWindowSpecExclusion() {
        this.sql("select sum(x) over (order by x rows between 2 preceding and 2 following exclude group) from emp").ok("SELECT (SUM(`X`) OVER (ORDER BY `X` ROWS BETWEEN 2 PRECEDING AND 2 FOLLOWING EXCLUDE GROUP))\nFROM `EMP`");
        this.sql("select sum(x) over (order by x ^exclude^ current row) from bids").fails("(?s).*Encountered \"exclude\".*");
        this.sql("select sum(x) over (order by x rows between 2 preceding and 2 following exclude no others) from emp").ok("SELECT (SUM(`X`) OVER (ORDER BY `X` ROWS BETWEEN 2 PRECEDING AND 2 FOLLOWING))\nFROM `EMP`");
    }

    @Test
    void testQualify() {
        String sql = "SELECT empno, ename,\n ROW_NUMBER() over (partition by ename order by deptno) as rn\nFROM emp\nQUALIFY rn = 1";
        String expected = "SELECT `EMPNO`, `ENAME`, (ROW_NUMBER() OVER (PARTITION BY `ENAME` ORDER BY `DEPTNO`)) AS `RN`\nFROM `EMP`\nQUALIFY (`RN` = 1)";
        this.sql("SELECT empno, ename,\n ROW_NUMBER() over (partition by ename order by deptno) as rn\nFROM emp\nQUALIFY rn = 1").ok("SELECT `EMPNO`, `ENAME`, (ROW_NUMBER() OVER (PARTITION BY `ENAME` ORDER BY `DEPTNO`)) AS `RN`\nFROM `EMP`\nQUALIFY (`RN` = 1)");
    }

    @Test
    void testQualifyWithoutAlias() {
        String sql = "SELECT empno, ename\nFROM emp\nQUALIFY ROW_NUMBER() over (partition by ename order by deptno) = 1";
        String expected = "SELECT `EMPNO`, `ENAME`\nFROM `EMP`\nQUALIFY ((ROW_NUMBER() OVER (PARTITION BY `ENAME` ORDER BY `DEPTNO`)) = 1)";
        this.sql("SELECT empno, ename\nFROM emp\nQUALIFY ROW_NUMBER() over (partition by ename order by deptno) = 1").ok("SELECT `EMPNO`, `ENAME`\nFROM `EMP`\nQUALIFY ((ROW_NUMBER() OVER (PARTITION BY `ENAME` ORDER BY `DEPTNO`)) = 1)");
    }

    @Test
    void testQualifyWithWindowClause() {
        String sql = "SELECT empno, ename,\n SUM(deptno) OVER myWindow as sumDeptNo\nFROM emp\nWINDOW myWindow AS (PARTITION BY ename ORDER BY empno)\nQUALIFY sumDeptNo = 1";
        String expected = "SELECT `EMPNO`, `ENAME`, (SUM(`DEPTNO`) OVER `MYWINDOW`) AS `SUMDEPTNO`\nFROM `EMP`\nWINDOW `MYWINDOW` AS (PARTITION BY `ENAME` ORDER BY `EMPNO`)\nQUALIFY (`SUMDEPTNO` = 1)";
        this.sql("SELECT empno, ename,\n SUM(deptno) OVER myWindow as sumDeptNo\nFROM emp\nWINDOW myWindow AS (PARTITION BY ename ORDER BY empno)\nQUALIFY sumDeptNo = 1").ok("SELECT `EMPNO`, `ENAME`, (SUM(`DEPTNO`) OVER `MYWINDOW`) AS `SUMDEPTNO`\nFROM `EMP`\nWINDOW `MYWINDOW` AS (PARTITION BY `ENAME` ORDER BY `EMPNO`)\nQUALIFY (`SUMDEPTNO` = 1)");
    }

    @Test
    void testQualifyWithEverything() {
        String sql = "SELECT DISTINCT ename,\n SUM(deptno) OVER (PARTITION BY ename) as r\nFROM emp\nWHERE deptno > 3\nGROUP BY ename, deptno\nHAVING SUM(empno) > 4\nQUALIFY sumDeptNo = 1\nORDER BY ename\nLIMIT 5\n";
        String expected = "SELECT DISTINCT `ENAME`, (SUM(`DEPTNO`) OVER (PARTITION BY `ENAME`)) AS `R`\nFROM `EMP`\nWHERE (`DEPTNO` > 3)\nGROUP BY `ENAME`, `DEPTNO`\nHAVING (SUM(`EMPNO`) > 4)\nQUALIFY (`SUMDEPTNO` = 1)\nORDER BY `ENAME`\nFETCH NEXT 5 ROWS ONLY";
        this.sql("SELECT DISTINCT ename,\n SUM(deptno) OVER (PARTITION BY ename) as r\nFROM emp\nWHERE deptno > 3\nGROUP BY ename, deptno\nHAVING SUM(empno) > 4\nQUALIFY sumDeptNo = 1\nORDER BY ename\nLIMIT 5\n").ok("SELECT DISTINCT `ENAME`, (SUM(`DEPTNO`) OVER (PARTITION BY `ENAME`)) AS `R`\nFROM `EMP`\nWHERE (`DEPTNO` > 3)\nGROUP BY `ENAME`, `DEPTNO`\nHAVING (SUM(`EMPNO`) > 4)\nQUALIFY (`SUMDEPTNO` = 1)\nORDER BY `ENAME`\nFETCH NEXT 5 ROWS ONLY");
    }

    @Test
    void testQualifyIllegalAfterOrder() {
        String sql = "SELECT x\nFROM t\nORDER BY 1 DESC\n^QUALIFY^ x = 1";
        this.sql("SELECT x\nFROM t\nORDER BY 1 DESC\n^QUALIFY^ x = 1").fails("(?s).*Encountered \"QUALIFY\" at .*");
    }

    @Test
    void testNullTreatment() {
        this.sql("select lead(x) respect nulls over (w) from t").ok("SELECT (LEAD(`X`) RESPECT NULLS OVER (`W`))\nFROM `T`");
        this.sql("select deptno, sum(sal) respect nulls from emp group by deptno").ok("SELECT `DEPTNO`, SUM(`SAL`) RESPECT NULLS\nFROM `EMP`\nGROUP BY `DEPTNO`");
        this.sql("select deptno, sum(sal) ignore nulls from emp group by deptno").ok("SELECT `DEPTNO`, SUM(`SAL`) IGNORE NULLS\nFROM `EMP`\nGROUP BY `DEPTNO`");
        String sql = "select col1,\n collect(col2) ignore nulls\n   within group (order by col3)\n   filter (where 1 = 0)\n   over (rows 10 preceding)\n as c\nfrom t\norder by col1 limit 10";
        String expected = "SELECT `COL1`, (COLLECT(`COL2`) IGNORE NULLS WITHIN GROUP (ORDER BY `COL3`) FILTER (WHERE (1 = 0)) OVER (ROWS 10 PRECEDING)) AS `C`\nFROM `T`\nORDER BY `COL1`\nFETCH NEXT 10 ROWS ONLY";
        this.sql("select col1,\n collect(col2) ignore nulls\n   within group (order by col3)\n   filter (where 1 = 0)\n   over (rows 10 preceding)\n as c\nfrom t\norder by col1 limit 10").ok("SELECT `COL1`, (COLLECT(`COL2`) IGNORE NULLS WITHIN GROUP (ORDER BY `COL3`) FILTER (WHERE (1 = 0)) OVER (ROWS 10 PRECEDING)) AS `C`\nFROM `T`\nORDER BY `COL1`\nFETCH NEXT 10 ROWS ONLY");
        this.sql("select lead(x) ignore from t").ok("SELECT LEAD(`X`) AS `IGNORE`\nFROM `T`");
        this.sql("select lead(x) respect from t").ok("SELECT LEAD(`X`) AS `RESPECT`\nFROM `T`");
    }

    @Test
    void testAs() {
        this.sql("select x y from t").ok("SELECT `X` AS `Y`\nFROM `T`");
        this.sql("select x AS y from t").ok("SELECT `X` AS `Y`\nFROM `T`");
        this.sql("select sum(x) y from t group by z").ok("SELECT SUM(`X`) AS `Y`\nFROM `T`\nGROUP BY `Z`");
        this.sql("select count(z) over w foo from Bids window w as (order by x)").ok("SELECT (COUNT(`Z`) OVER `W`) AS `FOO`\nFROM `BIDS`\nWINDOW `W` AS (ORDER BY `X`)");
        String expected = "SELECT `X`\nFROM `T` AS `T1`";
        this.sql("select x from t as t1").ok("SELECT `X`\nFROM `T` AS `T1`");
        this.sql("select x from t t1").ok("SELECT `X`\nFROM `T` AS `T1`");
        this.sql("select sum(x) over w from bids window w ^(order by x)").fails("(?s).*Encountered \"\\(\".*");
        this.sql("select count(*) as foo ^over^ w from Bids window w (order by x)").fails("(?s).*Encountered \"over\".*");
    }

    @Test
    void testAsAliases() {
        this.sql("select x from t as t1 (a, b) where foo").ok("SELECT `X`\nFROM `T` AS `T1` (`A`, `B`)\nWHERE `FOO`");
        this.sql("select x from (values (1, 2), (3, 4)) as t1 (\"a\", b) where \"a\" > b").ok("SELECT `X`\nFROM (VALUES (ROW(1, 2)),\n(ROW(3, 4))) AS `T1` (`a`, `B`)\nWHERE (`a` > `B`)");
        this.sql("select x from (values (1, 2), (3, 4)) as t1 (^)^").fails("(?s).*Encountered \"\\)\" at .*");
        this.sql("select x from t as t1 (x ^+^ y)").fails("(?s).*Was expecting one of:\n    \"\\)\" \\.\\.\\.\n    \",\" \\.\\.\\..*");
        this.sql("select x from t as t1 (x^.^y)").fails("(?s).*Was expecting one of:\n    \"\\)\" \\.\\.\\.\n    \",\" \\.\\.\\..*");
    }

    @Test
    void testOver() {
        this.expr("sum(sal) over ()").ok("(SUM(`SAL`) OVER ())");
        this.expr("sum(sal) over (partition by x, y)").ok("(SUM(`SAL`) OVER (PARTITION BY `X`, `Y`))");
        this.expr("sum(sal) over (order by x desc, y asc)").ok("(SUM(`SAL`) OVER (ORDER BY `X` DESC, `Y`))");
        this.expr("sum(sal) over (rows 5 preceding)").ok("(SUM(`SAL`) OVER (ROWS 5 PRECEDING))");
        this.expr("sum(sal) over (range between interval '1' second preceding\n and interval '1' second following)").ok("(SUM(`SAL`) OVER (RANGE BETWEEN INTERVAL '1' SECOND PRECEDING AND INTERVAL '1' SECOND FOLLOWING))");
        this.expr("sum(sal) over (range between interval '1:03' hour preceding\n and interval '2' minute following)").ok("(SUM(`SAL`) OVER (RANGE BETWEEN INTERVAL '1:03' HOUR PRECEDING AND INTERVAL '2' MINUTE FOLLOWING))");
        this.expr("sum(sal) over (range between interval '5' day preceding\n and current row)").ok("(SUM(`SAL`) OVER (RANGE BETWEEN INTERVAL '5' DAY PRECEDING AND CURRENT ROW))");
        this.expr("sum(sal) over (range interval '5' day preceding)").ok("(SUM(`SAL`) OVER (RANGE INTERVAL '5' DAY PRECEDING))");
        this.expr("sum(sal) over (range between unbounded preceding and current row)").ok("(SUM(`SAL`) OVER (RANGE BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW))");
        this.expr("sum(sal) over (range unbounded preceding)").ok("(SUM(`SAL`) OVER (RANGE UNBOUNDED PRECEDING))");
        this.expr("sum(sal) over (range between current row and unbounded preceding)").ok("(SUM(`SAL`) OVER (RANGE BETWEEN CURRENT ROW AND UNBOUNDED PRECEDING))");
        this.expr("sum(sal) over (range between current row and unbounded following)").ok("(SUM(`SAL`) OVER (RANGE BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING))");
        this.expr("sum(sal) over (range between 6 preceding\n and interval '1:03' hour preceding)").ok("(SUM(`SAL`) OVER (RANGE BETWEEN 6 PRECEDING AND INTERVAL '1:03' HOUR PRECEDING))");
        this.expr("sum(sal) over (range between interval '1' second following\n and interval '5' day following)").ok("(SUM(`SAL`) OVER (RANGE BETWEEN INTERVAL '1' SECOND FOLLOWING AND INTERVAL '5' DAY FOLLOWING))");
    }

    @Test
    void testElementFunc() {
        this.expr("element(a)").ok("ELEMENT(`A`)");
    }

    @Test
    void testCardinalityFunc() {
        this.expr("cardinality(a)").ok("CARDINALITY(`A`)");
    }

    @Test
    void testMemberOf() {
        this.expr("a member of b").ok("(`A` MEMBER OF `B`)");
        this.expr("a member of multiset[b]").ok("(`A` MEMBER OF (MULTISET[`B`]))");
    }

    @Test
    void testSubMultisetrOf() {
        this.expr("a submultiset of b").ok("(`A` SUBMULTISET OF `B`)");
    }

    @Test
    void testIsASet() {
        this.expr("b is a set").ok("(`B` IS A SET)");
        this.expr("a is a set").ok("(`A` IS A SET)");
    }

    @Test
    void testMultiset() {
        this.expr("multiset[1]").ok("(MULTISET[1])");
        this.expr("multiset[1,2.3]").ok("(MULTISET[1, 2.3])");
        this.expr("multiset[1,    '2']").ok("(MULTISET[1, '2'])");
        this.expr("multiset[ROW(1,2)]").ok("(MULTISET[(ROW(1, 2))])");
        this.expr("multiset[ROW(1,2),ROW(3,4)]").ok("(MULTISET[(ROW(1, 2)), (ROW(3, 4))])");
        this.expr("multiset(select*from T)").ok("(MULTISET ((SELECT *\nFROM `T`)))");
    }

    @Test
    void testMultisetQueryConstructor() {
        this.sql("SELECT multiset(SELECT x FROM (VALUES(1)) x)").ok("SELECT (MULTISET ((SELECT `X`\nFROM (VALUES (ROW(1))) AS `X`)))");
        this.sql("SELECT multiset(SELECT x FROM (VALUES(1)) x ^ORDER^ BY x)").fails("(?s)Encountered \"ORDER\" at.*");
        this.sql("SELECT multiset(SELECT x FROM (VALUES(1)) x^,^ SELECT x FROM (VALUES(1)) x)").fails("(?s)Encountered \", SELECT\" at.*");
        this.sql("SELECT multiset(^1^, SELECT x FROM (VALUES(1)) x)").fails("(?s)Non-query expression encountered in illegal context");
    }

    @Test
    void testMultisetUnion() {
        this.expr("a multiset union b").ok("(`A` MULTISET UNION ALL `B`)");
        this.expr("a multiset union all b").ok("(`A` MULTISET UNION ALL `B`)");
        this.expr("a multiset union distinct b").ok("(`A` MULTISET UNION DISTINCT `B`)");
    }

    @Test
    void testMultisetExcept() {
        this.expr("a multiset EXCEPT b").ok("(`A` MULTISET EXCEPT ALL `B`)");
        this.expr("a multiset EXCEPT all b").ok("(`A` MULTISET EXCEPT ALL `B`)");
        this.expr("a multiset EXCEPT distinct b").ok("(`A` MULTISET EXCEPT DISTINCT `B`)");
    }

    @Test
    void testMultisetIntersect() {
        this.expr("a multiset INTERSECT b").ok("(`A` MULTISET INTERSECT ALL `B`)");
        this.expr("a multiset INTERSECT all b").ok("(`A` MULTISET INTERSECT ALL `B`)");
        this.expr("a multiset INTERSECT distinct b").ok("(`A` MULTISET INTERSECT DISTINCT `B`)");
    }

    @Test
    void testMultisetMixed() {
        this.expr("multiset[1] MULTISET union b").ok("((MULTISET[1]) MULTISET UNION ALL `B`)");
        String sql = "a MULTISET union b multiset intersect c multiset except d multiset union e";
        String expected = "(((`A` MULTISET UNION ALL (`B` MULTISET INTERSECT ALL `C`)) MULTISET EXCEPT ALL `D`) MULTISET UNION ALL `E`)";
        this.expr("a MULTISET union b multiset intersect c multiset except d multiset union e").ok("(((`A` MULTISET UNION ALL (`B` MULTISET INTERSECT ALL `C`)) MULTISET EXCEPT ALL `D`) MULTISET UNION ALL `E`)");
    }

    @Test
    void testMapItem() {
        this.expr("a['foo']").ok("`A`['foo']");
        this.expr("a['x' || 'y']").ok("`A`[('x' || 'y')]");
        this.expr("a['foo'] ['bar']").ok("`A`['foo']['bar']");
        this.expr("a['foo']['bar']").ok("`A`['foo']['bar']");
    }

    @Test
    void testMapItemPrecedence() {
        this.expr("1 + a['foo'] * 3").ok("(1 + (`A`['foo'] * 3))");
        this.expr("1 * a['foo'] + 3").ok("((1 * `A`['foo']) + 3)");
        this.expr("a['foo']['bar']").ok("`A`['foo']['bar']");
        this.expr("a[b['foo' || 'bar']]").ok("`A`[`B`[('foo' || 'bar')]]");
    }

    @Test
    void testArrayElement() {
        this.expr("a[1]").ok("`A`[1]");
        this.expr("a[b[1]]").ok("`A`[`B`[1]]");
        this.expr("a[b[1 + 2] + 3]").ok("`A`[(`B`[(1 + 2)] + 3)]");
    }

    @Test
    void testArrayElementWithDot() {
        this.expr("a[1+2].b.c[2].d").ok("(((`A`[(1 + 2)].`B`).`C`)[2].`D`)");
        this.expr("a[b[1]].c.f0[d[1]]").ok("((`A`[`B`[1]].`C`).`F0`)[`D`[1]]");
    }

    @Test
    void testArrayValueConstructor() {
        this.expr("array[1, 2]").ok("(ARRAY[1, 2])");
        this.expr("array [1, 2]").ok("(ARRAY[1, 2])");
        this.expr("array[]").ok("(ARRAY[])");
        this.expr("array[(1, 'a'), (2, 'b')]").ok("(ARRAY[(ROW(1, 'a')), (ROW(2, 'b'))])");
        this.expr("array[(select 1)]").ok("(ARRAY[(SELECT 1)])");
        this.expr("array[(select 1), 2]").ok("(ARRAY[(SELECT 1), 2])");
        this.expr("array[^select^ 1]").fails("(?s)Encountered \"select\".*");
    }

    @Test
    void testArrayFunction() {
        this.expr("array()").ok("ARRAY()");
        this.expr("array(1)").ok("ARRAY(1)");
    }

    @Test
    void testArrayQueryConstructor() {
        this.sql("SELECT array(SELECT x FROM (VALUES(1)) x)").ok("SELECT (ARRAY ((SELECT `X`\nFROM (VALUES (ROW(1))) AS `X`)))");
        this.sql("SELECT array(SELECT x FROM (VALUES(1)) x ORDER BY x)").ok("SELECT (ARRAY (SELECT `X`\nFROM (VALUES (ROW(1))) AS `X`\nORDER BY `X`))");
        this.sql("SELECT array(SELECT x FROM (VALUES(1)) x^,^ SELECT x FROM (VALUES(1)) x)").fails("(?s)Encountered \", SELECT\" at.*");
        this.sql("SELECT array(1, ^SELECT^ x FROM (VALUES(1)) x)").fails("(?s)Incorrect syntax near the keyword 'SELECT'.*");
    }

    @Test
    void testCastAsCollectionType() {
        this.expr("cast(a as int array)").ok("CAST(`A` AS INTEGER ARRAY)");
        this.expr("cast(a as varchar(5) array)").ok("CAST(`A` AS VARCHAR(5) ARRAY)");
        this.expr("cast(a as int array array)").ok("CAST(`A` AS INTEGER ARRAY ARRAY)");
        this.expr("cast(a as varchar(5) array array)").ok("CAST(`A` AS VARCHAR(5) ARRAY ARRAY)");
        this.expr("cast(a as int array^<^10>)").fails("(?s).*Encountered \"<\" at line 1, column 20.\n.*");
        this.expr("cast(a as int multiset)").ok("CAST(`A` AS INTEGER MULTISET)");
        this.expr("cast(a as varchar(5) multiset)").ok("CAST(`A` AS VARCHAR(5) MULTISET)");
        this.expr("cast(a as int multiset array)").ok("CAST(`A` AS INTEGER MULTISET ARRAY)");
        this.expr("cast(a as varchar(5) multiset array)").ok("CAST(`A` AS VARCHAR(5) MULTISET ARRAY)");
        this.expr("cast(a as row(f0 int array multiset, f1 varchar(5) array) array multiset)").ok("CAST(`A` AS ROW(`F0` INTEGER ARRAY MULTISET, `F1` VARCHAR(5) ARRAY) ARRAY MULTISET)");
        this.expr("cast(a as MyUDT array multiset)").ok("CAST(`A` AS `MYUDT` ARRAY MULTISET)");
    }

    @Test
    void testCastAsRowType() {
        this.expr("cast(a as row(f0 int, f1 varchar))").ok("CAST(`A` AS ROW(`F0` INTEGER, `F1` VARCHAR))");
        this.expr("cast(a as row(f0 int not null, f1 varchar null))").ok("CAST(`A` AS ROW(`F0` INTEGER, `F1` VARCHAR NULL))");
        this.expr("cast(a as row(f0 row(ff0 int not null, ff1 varchar null) null, f1 timestamp not null))").ok("CAST(`A` AS ROW(`F0` ROW(`FF0` INTEGER, `FF1` VARCHAR NULL) NULL, `F1` TIMESTAMP))");
        this.expr("cast(a as row(f0 bigint not null, f1 decimal null) array)").ok("CAST(`A` AS ROW(`F0` BIGINT, `F1` DECIMAL NULL) ARRAY)");
        this.expr("cast(a as row(f0 varchar not null, f1 timestamp null) multiset)").ok("CAST(`A` AS ROW(`F0` VARCHAR, `F1` TIMESTAMP NULL) MULTISET)");
    }

    @Test
    void testCastAsMapType() {
        this.expr("cast(a as map<int, int>)").ok("CAST(`A` AS MAP< INTEGER, INTEGER >)");
        this.expr("cast(a as map<int, varchar array>)").ok("CAST(`A` AS MAP< INTEGER, VARCHAR ARRAY >)");
        this.expr("cast(a as map<varchar multiset, map<int, int>>)").ok("CAST(`A` AS MAP< VARCHAR MULTISET, MAP< INTEGER, INTEGER > >)");
    }

    @Test
    void testFormatClauseInCast() {
        this.expr("cast(date '2001-01-01' as varchar FORMAT 'YYYY Q MM')").ok("CAST(DATE '2001-01-01' AS VARCHAR FORMAT 'YYYY Q MM')");
        this.expr("cast(time '1:30:00' as varchar format 'HH24')").ok("CAST(TIME '1:30:00' AS VARCHAR FORMAT 'HH24')");
        this.expr("cast(timestamp '2008-12-25 12:15:00' as varchar format 'MON, YYYY')").ok("CAST(TIMESTAMP '2008-12-25 12:15:00' AS VARCHAR FORMAT 'MON, YYYY')");
        this.expr("cast('18-12-03' as date format 'YY-MM-DD')").ok("CAST('18-12-03' AS DATE FORMAT 'YY-MM-DD')");
        this.expr("cast('01:05:07.16' as time format 'HH24:MI:SS.FF4')").ok("CAST('01:05:07.16' AS TIME FORMAT 'HH24:MI:SS.FF4')");
        this.expr("cast('2020.06.03 12:42:53' as timestamp format 'YYYY.MM.DD HH:MI:SS')").ok("CAST('2020.06.03 12:42:53' AS TIMESTAMP FORMAT 'YYYY.MM.DD HH:MI:SS')");
    }

    @Test
    void testMapValueConstructor() {
        this.expr("map[1, 'x', 2, 'y']").ok("(MAP[1, 'x', 2, 'y'])");
        this.expr("map [1, 'x', 2, 'y']").ok("(MAP[1, 'x', 2, 'y'])");
        this.expr("map[]").ok("(MAP[])");
    }

    @Test
    void testMapFunction() {
        this.expr("map()").ok("MAP()");
        this.expr("MAP()").same();
        this.expr("map(1)").ok("MAP(1)");
        this.expr("map(1, 'x', 2, 'y')").ok("MAP(1, 'x', 2, 'y')");
        this.expr("MAP(1, 'x', 2, 'y')").same();
        this.expr("map (1, 'x', 2, 'y')").ok("MAP(1, 'x', 2, 'y')");
    }

    @Test
    void testMapQueryConstructor() {
        this.sql("SELECT map(SELECT 1)").ok("SELECT (MAP ((SELECT 1)))");
        this.sql("SELECT map(SELECT 1, 2)").ok("SELECT (MAP ((SELECT 1, 2)))");
        this.sql("SELECT MAP(SELECT 1, 2)").ok("SELECT (MAP ((SELECT 1, 2)))");
        this.sql("SELECT map (SELECT 1, 2)").ok("SELECT (MAP ((SELECT 1, 2)))");
        this.sql("SELECT map(SELECT T.x, T.y FROM (VALUES(1, 2)) AS T(x, y))").ok("SELECT (MAP ((SELECT `T`.`X`, `T`.`Y`\nFROM (VALUES (ROW(1, 2))) AS `T` (`X`, `Y`))))");
        this.sql("SELECT map(SELECT T.x, T.y FROM (VALUES(1, 2) ORDER BY T.x) AS T(x, y))").ok("SELECT (MAP ((SELECT `T`.`X`, `T`.`Y`\nFROM (VALUES (ROW(1, 2))\nORDER BY `T`.`X`) AS `T` (`X`, `Y`))))");
        this.sql("SELECT map(1, ^SELECT^ x FROM (VALUES(1)) x)").fails("(?s)Incorrect syntax near the keyword 'SELECT'.*");
        this.sql("SELECT map(SELECT x FROM (VALUES(1)) x^,^ SELECT x FROM (VALUES(1)) x)").fails("(?s)Encountered \", SELECT\" at.*");
    }

    @Test
    void testVisitSqlInsertWithSqlShuttle() {
        String sql = "insert into emps select * from emps";
        SqlNode sqlNode = this.sql("insert into emps select * from emps").node();
        SqlNode sqlNodeVisited = (SqlNode)sqlNode.accept((SqlVisitor)new SqlShuttle(){

            public SqlNode visit(SqlIdentifier identifier) {
                return identifier.clone(identifier.getParserPosition());
            }
        });
        Assertions.assertNotSame((Object)sqlNodeVisited, (Object)sqlNode);
        MatcherAssert.assertThat((Object)sqlNodeVisited.getKind(), (Matcher)CoreMatchers.is((Object)SqlKind.INSERT));
    }

    @Test
    void testSqlInsertSqlBasicCallToString() {
        String sql0 = "insert into emps select * from emps";
        SqlNode sqlNode0 = this.sql("insert into emps select * from emps").node();
        SqlNode sqlNodeVisited0 = (SqlNode)sqlNode0.accept((SqlVisitor)new SqlShuttle(){

            public SqlNode visit(SqlIdentifier identifier) {
                return identifier.clone(identifier.getParserPosition());
            }
        });
        String str0 = "INSERT INTO `EMPS`\nSELECT *\nFROM `EMPS`";
        MatcherAssert.assertThat((Object)"INSERT INTO `EMPS`\nSELECT *\nFROM `EMPS`", (Matcher)CoreMatchers.is((Object)Util.toLinux((String)sqlNodeVisited0.toString())));
        String sql1 = "insert into emps select empno from emps";
        SqlNode sqlNode1 = this.sql("insert into emps select empno from emps").node();
        SqlNode sqlNodeVisited1 = (SqlNode)sqlNode1.accept((SqlVisitor)new SqlShuttle(){

            public SqlNode visit(SqlIdentifier identifier) {
                return identifier.clone(identifier.getParserPosition());
            }
        });
        String str1 = "INSERT INTO `EMPS`\nSELECT `EMPNO`\nFROM `EMPS`";
        MatcherAssert.assertThat((Object)"INSERT INTO `EMPS`\nSELECT `EMPNO`\nFROM `EMPS`", (Matcher)CoreMatchers.is((Object)Util.toLinux((String)sqlNodeVisited1.toString())));
    }

    @Test
    void testVisitSqlMatchRecognizeWithSqlShuttle() {
        String sql = "select *\nfrom emp \nmatch_recognize (\n  pattern (strt down+ up+)\n  define\n    down as down.sal < PREV(down.sal),\n    up as up.sal > PREV(up.sal)\n) mr";
        SqlNode sqlNode = this.sql("select *\nfrom emp \nmatch_recognize (\n  pattern (strt down+ up+)\n  define\n    down as down.sal < PREV(down.sal),\n    up as up.sal > PREV(up.sal)\n) mr").node();
        SqlNode sqlNodeVisited = (SqlNode)sqlNode.accept((SqlVisitor)new SqlShuttle(){

            public SqlNode visit(SqlIdentifier identifier) {
                return identifier.clone(identifier.getParserPosition());
            }
        });
        Assertions.assertNotSame((Object)sqlNodeVisited, (Object)sqlNode);
    }

    @Test
    void testIntervalLiterals() {
        final SqlParserFixture f = this.fixture();
        IntervalTest.Fixture intervalFixture = new IntervalTest.Fixture(){

            @Override
            public IntervalTest.Fixture2 expr(String sql) {
                SqlParserFixture f2 = f.sql(sql).expression(true);
                return this.getFixture2(f2, f2.sap.sql);
            }

            @Override
            public IntervalTest.Fixture2 wholeExpr(String sql) {
                return this.expr(sql);
            }

            private IntervalTest.Fixture2 getFixture2(final SqlParserFixture f2, final String expectedSql) {
                return new IntervalTest.Fixture2(){

                    @Override
                    public void fails(String message) {
                        f2.compare(expectedSql);
                    }

                    @Override
                    public void columnType(String expectedType) {
                        f2.compare(expectedSql);
                    }

                    @Override
                    public IntervalTest.Fixture2 assertParse(String expectedSql2) {
                        return this.getFixture2(f2, expectedSql2);
                    }
                };
            }
        };
        new IntervalTest(intervalFixture).testAll();
    }

    @Test
    void testUnparseableIntervalQualifiers() {
        this.expr("interval '1^'^").fails("Encountered \"<EOF>\" at line 1, column 12\\.\nWas expecting one of:\n    \"DAY\" \\.\\.\\.\n    \"DAYS\" \\.\\.\\.\n    \"HOUR\" \\.\\.\\.\n    \"HOURS\" \\.\\.\\.\n    \"MINUTE\" \\.\\.\\.\n    \"MINUTES\" \\.\\.\\.\n    \"MONTH\" \\.\\.\\.\n    \"MONTHS\" \\.\\.\\.\n    \"QUARTER\" \\.\\.\\.\n    \"QUARTERS\" \\.\\.\\.\n    \"SECOND\" \\.\\.\\.\n    \"SECONDS\" \\.\\.\\.\n    \"WEEK\" \\.\\.\\.\n    \"WEEKS\" \\.\\.\\.\n    \"YEAR\" \\.\\.\\.\n    \"YEARS\" \\.\\.\\.\n    ");
        this.expr("interval '1' year ^to^ year").fails("(?s)Encountered \"to year\" at line 1, column 19.\nWas expecting one of:\n    <EOF> \n    \"\\(\" \\.\\.\\.\n    \"\\.\" \\.\\.\\..*");
        this.expr("interval '1-2' year ^to^ day").fails(ANY);
        this.expr("interval '1-2' year ^to^ hour").fails(ANY);
        this.expr("interval '1-2' year ^to^ minute").fails(ANY);
        this.expr("interval '1-2' year ^to^ second").fails(ANY);
        this.expr("interval '1-2' month ^to^ year").fails(ANY);
        this.expr("interval '1-2' month ^to^ month").fails(ANY);
        this.expr("interval '1-2' month ^to^ day").fails(ANY);
        this.expr("interval '1-2' month ^to^ hour").fails(ANY);
        this.expr("interval '1-2' month ^to^ minute").fails(ANY);
        this.expr("interval '1-2' month ^to^ second").fails(ANY);
        this.expr("interval '1-2' day ^to^ year").fails(ANY);
        this.expr("interval '1-2' day ^to^ month").fails(ANY);
        this.expr("interval '1-2' day ^to^ day").fails(ANY);
        this.expr("interval '1-2' hour ^to^ year").fails(ANY);
        this.expr("interval '1-2' hour ^to^ month").fails(ANY);
        this.expr("interval '1-2' hour ^to^ day").fails(ANY);
        this.expr("interval '1-2' hour ^to^ hour").fails(ANY);
        this.expr("interval '1-2' minute ^to^ year").fails(ANY);
        this.expr("interval '1-2' minute ^to^ month").fails(ANY);
        this.expr("interval '1-2' minute ^to^ day").fails(ANY);
        this.expr("interval '1-2' minute ^to^ hour").fails(ANY);
        this.expr("interval '1-2' minute ^to^ minute").fails(ANY);
        this.expr("interval '1-2' second ^to^ year").fails(ANY);
        this.expr("interval '1-2' second ^to^ month").fails(ANY);
        this.expr("interval '1-2' second ^to^ day").fails(ANY);
        this.expr("interval '1-2' second ^to^ hour").fails(ANY);
        this.expr("interval '1-2' second ^to^ minute").fails(ANY);
        this.expr("interval '1-2' second ^to^ second").fails(ANY);
        this.expr("interval '1' year(3) ^to^ year").fails(ANY);
        this.expr("interval '1-2' year(3) ^to^ day").fails(ANY);
        this.expr("interval '1-2' year(3) ^to^ hour").fails(ANY);
        this.expr("interval '1-2' year(3) ^to^ minute").fails(ANY);
        this.expr("interval '1-2' year(3) ^to^ second").fails(ANY);
        this.expr("interval '1-2' month(3) ^to^ year").fails(ANY);
        this.expr("interval '1-2' month(3) ^to^ month").fails(ANY);
        this.expr("interval '1-2' month(3) ^to^ day").fails(ANY);
        this.expr("interval '1-2' month(3) ^to^ hour").fails(ANY);
        this.expr("interval '1-2' month(3) ^to^ minute").fails(ANY);
        this.expr("interval '1-2' month(3) ^to^ second").fails(ANY);
        this.expr("interval '1-2' day(3) ^to^ year").fails(ANY);
        this.expr("interval '1-2' day(3) ^to^ month").fails(ANY);
        this.expr("interval '1-2' hour(3) ^to^ year").fails(ANY);
        this.expr("interval '1-2' hour(3) ^to^ month").fails(ANY);
        this.expr("interval '1-2' hour(3) ^to^ day").fails(ANY);
        this.expr("interval '1-2' minute(3) ^to^ year").fails(ANY);
        this.expr("interval '1-2' minute(3) ^to^ month").fails(ANY);
        this.expr("interval '1-2' minute(3) ^to^ day").fails(ANY);
        this.expr("interval '1-2' minute(3) ^to^ hour").fails(ANY);
        this.expr("interval '1-2' second(3) ^to^ year").fails(ANY);
        this.expr("interval '1-2' second(3) ^to^ month").fails(ANY);
        this.expr("interval '1-2' second(3) ^to^ day").fails(ANY);
        this.expr("interval '1-2' second(3) ^to^ hour").fails(ANY);
        this.expr("interval '1-2' second(3) ^to^ minute").fails(ANY);
        this.expr("interval '1' year ^to^ year(2)").fails(ANY);
        this.expr("interval '1-2' year to month^(^2)").fails(ANY);
        this.expr("interval '1-2' year ^to^ day(2)").fails(ANY);
        this.expr("interval '1-2' year ^to^ hour(2)").fails(ANY);
        this.expr("interval '1-2' year ^to^ minute(2)").fails(ANY);
        this.expr("interval '1-2' year ^to^ second(2)").fails(ANY);
        this.expr("interval '1-2' year ^to^ second(2,6)").fails(ANY);
        this.expr("interval '1-2' month ^to^ year(2)").fails(ANY);
        this.expr("interval '1-2' month ^to^ month(2)").fails(ANY);
        this.expr("interval '1-2' month ^to^ day(2)").fails(ANY);
        this.expr("interval '1-2' month ^to^ hour(2)").fails(ANY);
        this.expr("interval '1-2' month ^to^ minute(2)").fails(ANY);
        this.expr("interval '1-2' month ^to^ second(2)").fails(ANY);
        this.expr("interval '1-2' month ^to^ second(2,6)").fails(ANY);
        this.expr("interval '1-2' day ^to^ year(2)").fails(ANY);
        this.expr("interval '1-2' day ^to^ month(2)").fails(ANY);
        this.expr("interval '1-2' day ^to^ day(2)").fails(ANY);
        this.expr("interval '1-2' day to hour^(^2)").fails(ANY);
        this.expr("interval '1-2' day to minute^(^2)").fails(ANY);
        this.expr("interval '1-2' day to second(2^,^6)").fails(ANY);
        this.expr("interval '1-2' hour ^to^ year(2)").fails(ANY);
        this.expr("interval '1-2' hour ^to^ month(2)").fails(ANY);
        this.expr("interval '1-2' hour ^to^ day(2)").fails(ANY);
        this.expr("interval '1-2' hour ^to^ hour(2)").fails(ANY);
        this.expr("interval '1-2' hour to minute^(^2)").fails(ANY);
        this.expr("interval '1-2' hour to second(2^,^6)").fails(ANY);
        this.expr("interval '1-2' minute ^to^ year(2)").fails(ANY);
        this.expr("interval '1-2' minute ^to^ month(2)").fails(ANY);
        this.expr("interval '1-2' minute ^to^ day(2)").fails(ANY);
        this.expr("interval '1-2' minute ^to^ hour(2)").fails(ANY);
        this.expr("interval '1-2' minute ^to^ minute(2)").fails(ANY);
        this.expr("interval '1-2' minute to second(2^,^6)").fails(ANY);
        this.expr("interval '1-2' second ^to^ year(2)").fails(ANY);
        this.expr("interval '1-2' second ^to^ month(2)").fails(ANY);
        this.expr("interval '1-2' second ^to^ day(2)").fails(ANY);
        this.expr("interval '1-2' second ^to^ hour(2)").fails(ANY);
        this.expr("interval '1-2' second ^to^ minute(2)").fails(ANY);
        this.expr("interval '1-2' second ^to^ second(2)").fails(ANY);
        this.expr("interval '1-2' second ^to^ second(2,6)").fails(ANY);
        this.expr("interval '1' year(3) ^to^ year(2)").fails(ANY);
        this.expr("interval '1-2' year(3) to month^(^2)").fails(ANY);
        this.expr("interval '1-2' year(3) ^to^ day(2)").fails(ANY);
        this.expr("interval '1-2' year(3) ^to^ hour(2)").fails(ANY);
        this.expr("interval '1-2' year(3) ^to^ minute(2)").fails(ANY);
        this.expr("interval '1-2' year(3) ^to^ second(2)").fails(ANY);
        this.expr("interval '1-2' year(3) ^to^ second(2,6)").fails(ANY);
        this.expr("interval '1-2' month(3) ^to^ year(2)").fails(ANY);
        this.expr("interval '1-2' month(3) ^to^ month(2)").fails(ANY);
        this.expr("interval '1-2' month(3) ^to^ day(2)").fails(ANY);
        this.expr("interval '1-2' month(3) ^to^ hour(2)").fails(ANY);
        this.expr("interval '1-2' month(3) ^to^ minute(2)").fails(ANY);
        this.expr("interval '1-2' month(3) ^to^ second(2)").fails(ANY);
        this.expr("interval '1-2' month(3) ^to^ second(2,6)").fails(ANY);
    }

    @Test
    void testUnparseableIntervalQualifiers2() {
        this.expr("interval '1-2' day(3) ^to^ year(2)").fails(ANY);
        this.expr("interval '1-2' day(3) ^to^ month(2)").fails(ANY);
        this.expr("interval '1-2' day(3) ^to^ day(2)").fails(ANY);
        this.expr("interval '1-2' day(3) to hour^(^2)").fails(ANY);
        this.expr("interval '1-2' day(3) to minute^(^2)").fails(ANY);
        this.expr("interval '1-2' day(3) to second(2^,^6)").fails(ANY);
        this.expr("interval '1-2' hour(3) ^to^ year(2)").fails(ANY);
        this.expr("interval '1-2' hour(3) ^to^ month(2)").fails(ANY);
        this.expr("interval '1-2' hour(3) ^to^ day(2)").fails(ANY);
        this.expr("interval '1-2' hour(3) ^to^ hour(2)").fails(ANY);
        this.expr("interval '1-2' hour(3) to minute^(^2)").fails(ANY);
        this.expr("interval '1-2' hour(3) to second(2^,^6)").fails(ANY);
        this.expr("interval '1-2' minute(3) ^to^ year(2)").fails(ANY);
        this.expr("interval '1-2' minute(3) ^to^ month(2)").fails(ANY);
        this.expr("interval '1-2' minute(3) ^to^ day(2)").fails(ANY);
        this.expr("interval '1-2' minute(3) ^to^ hour(2)").fails(ANY);
        this.expr("interval '1-2' minute(3) ^to^ minute(2)").fails(ANY);
        this.expr("interval '1-2' minute(3) to second(2^,^6)").fails(ANY);
        this.expr("interval '1-2' second(3) ^to^ year(2)").fails(ANY);
        this.expr("interval '1-2' second(3) ^to^ month(2)").fails(ANY);
        this.expr("interval '1-2' second(3) ^to^ day(2)").fails(ANY);
        this.expr("interval '1-2' second(3) ^to^ hour(2)").fails(ANY);
        this.expr("interval '1-2' second(3) ^to^ minute(2)").fails(ANY);
        this.expr("interval '1-2' second(3) ^to^ second(2)").fails(ANY);
        this.expr("interval '1-2' second(3) ^to^ second(2,6)").fails(ANY);
        this.expr("INTERVAL '0' YEAR(^-^1)").fails(ANY);
        this.expr("INTERVAL '0-0' YEAR(^-^1) TO MONTH").fails(ANY);
        this.expr("INTERVAL '0' MONTH(^-^1)").fails(ANY);
        this.expr("INTERVAL '0' DAY(^-^1)").fails(ANY);
        this.expr("INTERVAL '0 0' DAY(^-^1) TO HOUR").fails(ANY);
        this.expr("INTERVAL '0 0' DAY(^-^1) TO MINUTE").fails(ANY);
        this.expr("INTERVAL '0 0:0:0' DAY(^-^1) TO SECOND").fails(ANY);
        this.expr("INTERVAL '0 0:0:0' DAY TO SECOND(^-^1)").fails(ANY);
        this.expr("INTERVAL '0' HOUR(^-^1)").fails(ANY);
        this.expr("INTERVAL '0:0' HOUR(^-^1) TO MINUTE").fails(ANY);
        this.expr("INTERVAL '0:0:0' HOUR(^-^1) TO SECOND").fails(ANY);
        this.expr("INTERVAL '0:0:0' HOUR TO SECOND(^-^1)").fails(ANY);
        this.expr("INTERVAL '0' MINUTE(^-^1)").fails(ANY);
        this.expr("INTERVAL '0:0' MINUTE(^-^1) TO SECOND").fails(ANY);
        this.expr("INTERVAL '0:0' MINUTE TO SECOND(^-^1)").fails(ANY);
        this.expr("INTERVAL '0' SECOND(^-^1)").fails(ANY);
        this.expr("INTERVAL '0' SECOND(1, ^-^1)").fails(ANY);
        this.expr("interval '1' day(3) ^to^ day").fails(ANY);
        this.expr("interval '1' hour(3) ^to^ hour").fails(ANY);
        this.expr("interval '1' minute(3) ^to^ minute").fails(ANY);
        this.expr("interval '1' second(3) ^to^ second").fails(ANY);
        this.expr("interval '1' second(3,1) ^to^ second").fails(ANY);
        this.expr("interval '1' second(2,3) ^to^ second").fails(ANY);
        this.expr("interval '1' second(2,2) ^to^ second(3)").fails(ANY);
        this.expr("INTERVAL '2' ^MILLENNIUM^").fails(ANY);
        this.expr("INTERVAL '1-2' ^MILLENNIUM^ TO CENTURY").fails(ANY);
        this.expr("INTERVAL '10' ^CENTURY^").fails(ANY);
        this.expr("INTERVAL '10' ^DECADE^").fails(ANY);
    }

    @Test
    void testIntervalPluralUnits() {
        this.expr("interval '2' years").hasWarning(SqlParserTest.checkWarnings("YEARS")).ok("INTERVAL '2' YEAR");
        this.expr("interval '2:1' years to months").hasWarning(SqlParserTest.checkWarnings("YEARS", "MONTHS")).ok("INTERVAL '2:1' YEAR TO MONTH");
        this.expr("interval '2' days").hasWarning(SqlParserTest.checkWarnings("DAYS")).ok("INTERVAL '2' DAY");
        this.expr("interval '2:1' days to hours").hasWarning(SqlParserTest.checkWarnings("DAYS", "HOURS")).ok("INTERVAL '2:1' DAY TO HOUR");
        this.expr("interval '2:1' day to hours").hasWarning(SqlParserTest.checkWarnings("HOURS")).ok("INTERVAL '2:1' DAY TO HOUR");
        this.expr("interval '2:1' days to hour").hasWarning(SqlParserTest.checkWarnings("DAYS")).ok("INTERVAL '2:1' DAY TO HOUR");
        this.expr("interval '1:1' minutes to seconds").hasWarning(SqlParserTest.checkWarnings("MINUTES", "SECONDS")).ok("INTERVAL '1:1' MINUTE TO SECOND");
    }

    private static Consumer<List<? extends Throwable>> checkWarnings(String ... tokens) {
        ArrayList<String> messages = new ArrayList<String>();
        for (String token : tokens) {
            messages.add("Warning: use of non-standard feature '" + token + "'");
        }
        return throwables -> {
            MatcherAssert.assertThat((Object)throwables, (Matcher)Matchers.hasSize((int)messages.size()));
            for (Pair pair : Pair.zip((List)throwables, (List)messages)) {
                MatcherAssert.assertThat((Object)((Throwable)pair.left).getMessage(), (Matcher)CoreMatchers.containsString((String)((String)pair.right)));
            }
        };
    }

    @Test
    void testMiscIntervalQualifier() {
        this.expr("interval '-' day").ok("INTERVAL '-' DAY");
        this.expr("interval '1 2:3:4.567' day to hour ^to^ second").fails("(?s)Encountered \"to\" at.*");
        this.expr("interval '1:2' minute to second(2^,^ 2)").fails("(?s)Encountered \",\" at.*");
        this.expr("interval '1:x' hour to minute").ok("INTERVAL '1:x' HOUR TO MINUTE");
        this.expr("interval '1:x:2' hour to second").ok("INTERVAL '1:x:2' HOUR TO SECOND");
    }

    @Test
    void testIntervalExpression() {
        this.expr("interval 0 day").ok("INTERVAL 0 DAY");
        this.expr("interval 0 days").ok("INTERVAL 0 DAY");
        this.expr("interval -10 days").ok("INTERVAL (- 10) DAY");
        this.expr("interval -10 days").ok("INTERVAL (- 10) DAY");
        this.expr("interval 1 ^+^ x.y days").fails("(?s)Encountered \"\\+\" at .*");
        this.expr("interval (1 + x.y) days").ok("INTERVAL (1 + `X`.`Y`) DAY");
        this.expr("interval -x second(3)").ok("INTERVAL (- `X`) SECOND(3)");
        this.expr("interval -x.y second(3)").ok("INTERVAL (- `X`.`Y`) SECOND(3)");
        this.expr("interval 1 day ^to^ hour").fails("(?s)Encountered \"to\" at .*");
        this.expr("interval '1 1' day to hour").ok("INTERVAL '1 1' DAY TO HOUR");
    }

    @Test
    void testIntervalOperators() {
        this.expr("-interval '1' day").ok("(- INTERVAL '1' DAY)");
        this.expr("interval '1' day + interval '1' day").ok("(INTERVAL '1' DAY + INTERVAL '1' DAY)");
        this.expr("interval '1' day - interval '1:2:3' hour to second").ok("(INTERVAL '1' DAY - INTERVAL '1:2:3' HOUR TO SECOND)");
        this.expr("interval -'1' day").ok("INTERVAL -'1' DAY");
        this.expr("interval '-1' day").ok("INTERVAL '-1' DAY");
        this.expr("interval 'wael was here^'^").fails("(?s)Encountered \"<EOF>\".*");
        this.expr("interval 'wael was here' HOUR").ok("INTERVAL 'wael was here' HOUR");
    }

    @Test
    void testDateMinusDate() {
        this.expr("(date1 - date2) HOUR").ok("((`DATE1` - `DATE2`) HOUR)");
        this.expr("(date1 - date2) YEAR TO MONTH").ok("((`DATE1` - `DATE2`) YEAR TO MONTH)");
        this.expr("(date1 - date2) HOUR > interval '1' HOUR").ok("(((`DATE1` - `DATE2`) HOUR) > INTERVAL '1' HOUR)");
        this.expr("^(date1 + date2) second^").fails("(?s).*Illegal expression. Was expecting ..DATETIME - DATETIME. INTERVALQUALIFIER.*");
        this.expr("^(date1,date2,date2) second^").fails("(?s).*Illegal expression. Was expecting ..DATETIME - DATETIME. INTERVALQUALIFIER.*");
    }

    @Test
    void testExtract() {
        this.expr("extract(year from x)").ok("EXTRACT(YEAR FROM `X`)");
        this.expr("extract(month from x)").ok("EXTRACT(MONTH FROM `X`)");
        this.expr("extract(day from x)").ok("EXTRACT(DAY FROM `X`)");
        this.expr("extract(hour from x)").ok("EXTRACT(HOUR FROM `X`)");
        this.expr("extract(minute from x)").ok("EXTRACT(MINUTE FROM `X`)");
        this.expr("extract(second from x)").ok("EXTRACT(SECOND FROM `X`)");
        this.expr("extract(dow from x)").ok("EXTRACT(DOW FROM `X`)");
        this.expr("extract(doy from x)").ok("EXTRACT(DOY FROM `X`)");
        this.expr("extract(week from x)").ok("EXTRACT(WEEK FROM `X`)");
        this.expr("extract(epoch from x)").ok("EXTRACT(EPOCH FROM `X`)");
        this.expr("extract(quarter from x)").ok("EXTRACT(QUARTER FROM `X`)");
        this.expr("extract(decade from x)").ok("EXTRACT(DECADE FROM `X`)");
        this.expr("extract(century from x)").ok("EXTRACT(CENTURY FROM `X`)");
        this.expr("extract(millennium from x)").ok("EXTRACT(MILLENNIUM FROM `X`)");
        this.expr("extract(day ^to^ second from x)").fails("(?s)Encountered \"to\".*");
    }

    @Test
    protected void testTimeUnitCodes() {
        this.expr("floor(d to year)").ok("FLOOR(`D` TO YEAR)");
        this.expr("floor(d to y)").ok("FLOOR(`D` TO `Y`)");
        this.expr("ceil(d to year)").ok("CEIL(`D` TO YEAR)");
        this.expr("ceil(d to y)").ok("CEIL(`D` TO `Y`)");
        this.expr("ceiling(d to year)").ok("CEIL(`D` TO YEAR)");
        this.expr("ceiling(d to y)").ok("CEIL(`D` TO `Y`)");
        this.expr("extract(year from d)").ok("EXTRACT(YEAR FROM `D`)");
        this.expr("extract(y from d)").ok("EXTRACT(`Y` FROM `D`)");
        this.expr("floor(d to nanosecond)").ok("FLOOR(`D` TO NANOSECOND)");
        this.expr("floor(d to microsecond)").ok("FLOOR(`D` TO MICROSECOND)");
        this.expr("ceil(d to nanosecond)").ok("CEIL(`D` TO NANOSECOND)");
        this.expr("ceiling(d to microsecond)").ok("CEIL(`D` TO MICROSECOND)");
        this.expr("extract(nanosecond from d)").ok("EXTRACT(NANOSECOND FROM `D`)");
        this.expr("extract(microsecond from d)").ok("EXTRACT(MICROSECOND FROM `D`)");
        this.expr("date_trunc(d , year)").ok("(DATE_TRUNC(`D`, YEAR))");
        this.expr("date_trunc(d , y)").ok("(DATE_TRUNC(`D`, `Y`))");
        this.expr("date_trunc(d , week(tuesday))").ok("(DATE_TRUNC(`D`, `WEEK_TUESDAY`))");
    }

    @Test
    void testGeometry() {
        this.expr("cast(null as ^geometry^)").fails("Geo-spatial extensions and the GEOMETRY data type are not enabled");
        this.expr("cast(null as geometry)").withConformance((SqlConformance)SqlConformanceEnum.LENIENT).ok("CAST(NULL AS GEOMETRY)");
    }

    @Test
    void testIntervalArithmetics() {
        this.expr("TIME '23:59:59' - interval '1' hour ").ok("(TIME '23:59:59' - INTERVAL '1' HOUR)");
        this.expr("TIMESTAMP '2000-01-01 23:59:59.1' - interval '1' hour ").ok("(TIMESTAMP '2000-01-01 23:59:59.1' - INTERVAL '1' HOUR)");
        this.expr("DATE '2000-01-01' - interval '1' hour ").ok("(DATE '2000-01-01' - INTERVAL '1' HOUR)");
        this.expr("TIME '23:59:59' + interval '1' hour ").ok("(TIME '23:59:59' + INTERVAL '1' HOUR)");
        this.expr("TIMESTAMP '2000-01-01 23:59:59.1' + interval '1' hour ").ok("(TIMESTAMP '2000-01-01 23:59:59.1' + INTERVAL '1' HOUR)");
        this.expr("DATE '2000-01-01' + interval '1' hour ").ok("(DATE '2000-01-01' + INTERVAL '1' HOUR)");
        this.expr("interval '1' hour + TIME '23:59:59' ").ok("(INTERVAL '1' HOUR + TIME '23:59:59')");
        this.expr("interval '1' hour * 8").ok("(INTERVAL '1' HOUR * 8)");
        this.expr("1 * interval '1' hour").ok("(1 * INTERVAL '1' HOUR)");
        this.expr("interval '1' hour / 8").ok("(INTERVAL '1' HOUR / 8)");
    }

    @Test
    void testIntervalCompare() {
        this.expr("interval '1' hour = interval '1' second").ok("(INTERVAL '1' HOUR = INTERVAL '1' SECOND)");
        this.expr("interval '1' hour <> interval '1' second").ok("(INTERVAL '1' HOUR <> INTERVAL '1' SECOND)");
        this.expr("interval '1' hour < interval '1' second").ok("(INTERVAL '1' HOUR < INTERVAL '1' SECOND)");
        this.expr("interval '1' hour <= interval '1' second").ok("(INTERVAL '1' HOUR <= INTERVAL '1' SECOND)");
        this.expr("interval '1' hour > interval '1' second").ok("(INTERVAL '1' HOUR > INTERVAL '1' SECOND)");
        this.expr("interval '1' hour >= interval '1' second").ok("(INTERVAL '1' HOUR >= INTERVAL '1' SECOND)");
    }

    @Test
    void testCastToInterval() {
        this.expr("cast(x as interval year)").ok("CAST(`X` AS INTERVAL YEAR)");
        this.expr("cast(x as interval month)").ok("CAST(`X` AS INTERVAL MONTH)");
        this.expr("cast(x as interval year to month)").ok("CAST(`X` AS INTERVAL YEAR TO MONTH)");
        this.expr("cast(x as interval day)").ok("CAST(`X` AS INTERVAL DAY)");
        this.expr("cast(x as interval hour)").ok("CAST(`X` AS INTERVAL HOUR)");
        this.expr("cast(x as interval minute)").ok("CAST(`X` AS INTERVAL MINUTE)");
        this.expr("cast(x as interval second)").ok("CAST(`X` AS INTERVAL SECOND)");
        this.expr("cast(x as interval day to hour)").ok("CAST(`X` AS INTERVAL DAY TO HOUR)");
        this.expr("cast(x as interval day to minute)").ok("CAST(`X` AS INTERVAL DAY TO MINUTE)");
        this.expr("cast(x as interval day to second)").ok("CAST(`X` AS INTERVAL DAY TO SECOND)");
        this.expr("cast(x as interval hour to minute)").ok("CAST(`X` AS INTERVAL HOUR TO MINUTE)");
        this.expr("cast(x as interval hour to second)").ok("CAST(`X` AS INTERVAL HOUR TO SECOND)");
        this.expr("cast(x as interval minute to second)").ok("CAST(`X` AS INTERVAL MINUTE TO SECOND)");
        this.expr("cast(interval '3-2' year to month as CHAR(5))").ok("CAST(INTERVAL '3-2' YEAR TO MONTH AS CHAR(5))");
    }

    @Test
    void testCastToVarchar() {
        this.expr("cast(x as varchar(5))").ok("CAST(`X` AS VARCHAR(5))");
        this.expr("cast(x as varchar)").ok("CAST(`X` AS VARCHAR)");
        this.expr("cast(x as varBINARY(5))").ok("CAST(`X` AS VARBINARY(5))");
        this.expr("cast(x as varbinary)").ok("CAST(`X` AS VARBINARY)");
    }

    @Test
    void testTimestampAdd() {
        String sql = "select * from t\nwhere timestampadd(month, 5, hiredate) < curdate";
        String expected = "SELECT *\nFROM `T`\nWHERE (TIMESTAMPADD(MONTH, 5, `HIREDATE`) < `CURDATE`)";
        this.sql("select * from t\nwhere timestampadd(month, 5, hiredate) < curdate").ok("SELECT *\nFROM `T`\nWHERE (TIMESTAMPADD(MONTH, 5, `HIREDATE`) < `CURDATE`)");
        String sql2 = "select * from t\nwhere timestampadd(sql_tsi_month, 5, hiredate) < curdate";
        String expected2 = "SELECT *\nFROM `T`\nWHERE (TIMESTAMPADD(`SQL_TSI_MONTH`, 5, `HIREDATE`) < `CURDATE`)";
        this.sql("select * from t\nwhere timestampadd(sql_tsi_month, 5, hiredate) < curdate").ok("SELECT *\nFROM `T`\nWHERE (TIMESTAMPADD(`SQL_TSI_MONTH`, 5, `HIREDATE`) < `CURDATE`)");
        this.expr("timestampadd(incorrect, 1, current_timestamp)").ok("TIMESTAMPADD(`INCORRECT`, 1, CURRENT_TIMESTAMP)");
    }

    @Test
    void testTimestampDiff() {
        String sql = "select * from t\nwhere timestampdiff(microsecond, 5, hiredate) < curdate";
        String expected = "SELECT *\nFROM `T`\nWHERE (TIMESTAMPDIFF(MICROSECOND, 5, `HIREDATE`) < `CURDATE`)";
        this.sql("select * from t\nwhere timestampdiff(microsecond, 5, hiredate) < curdate").ok("SELECT *\nFROM `T`\nWHERE (TIMESTAMPDIFF(MICROSECOND, 5, `HIREDATE`) < `CURDATE`)");
        String sql2 = "select * from t\nwhere timestampdiff(frac_second, 5, hiredate) < curdate";
        String expected2 = "SELECT *\nFROM `T`\nWHERE (TIMESTAMPDIFF(`FRAC_SECOND`, 5, `HIREDATE`) < `CURDATE`)";
        this.sql("select * from t\nwhere timestampdiff(frac_second, 5, hiredate) < curdate").ok("SELECT *\nFROM `T`\nWHERE (TIMESTAMPDIFF(`FRAC_SECOND`, 5, `HIREDATE`) < `CURDATE`)");
        this.expr("timestampdiff(incorrect, current_timestamp, current_timestamp)").ok("TIMESTAMPDIFF(`INCORRECT`, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP)");
    }

    @Test
    void testTimeTrunc() {
        String sql = "select time_trunc(TIME '15:30:00', hour) from t";
        String expected = "SELECT TIME_TRUNC(TIME '15:30:00', HOUR)\nFROM `T`";
        this.sql("select time_trunc(TIME '15:30:00', hour) from t").ok("SELECT TIME_TRUNC(TIME '15:30:00', HOUR)\nFROM `T`");
        String sql2 = "select time_trunc(time '15:30:00', week) from t";
        String expected2 = "SELECT TIME_TRUNC(TIME '15:30:00', WEEK)\nFROM `T`";
        this.sql("select time_trunc(time '15:30:00', week) from t").ok("SELECT TIME_TRUNC(TIME '15:30:00', WEEK)\nFROM `T`");
        String sql3 = "select time_trunc(time '15:30:00', incorrect) from t";
        String expected3 = "SELECT TIME_TRUNC(TIME '15:30:00', `INCORRECT`)\nFROM `T`";
        this.sql("select time_trunc(time '15:30:00', incorrect) from t").ok("SELECT TIME_TRUNC(TIME '15:30:00', `INCORRECT`)\nFROM `T`");
    }

    @Test
    void testTimestampTrunc() {
        String sql = "select timestamp_trunc(timestamp '2008-12-25 15:30:00', week) from t";
        String expected = "SELECT TIMESTAMP_TRUNC(TIMESTAMP '2008-12-25 15:30:00', WEEK)\nFROM `T`";
        this.sql("select timestamp_trunc(timestamp '2008-12-25 15:30:00', week) from t").ok("SELECT TIMESTAMP_TRUNC(TIMESTAMP '2008-12-25 15:30:00', WEEK)\nFROM `T`");
        String sql3 = "select timestamp_trunc(time '15:30:00', incorrect) from t";
        String expected3 = "SELECT TIMESTAMP_TRUNC(TIME '15:30:00', `INCORRECT`)\nFROM `T`";
        this.sql("select timestamp_trunc(time '15:30:00', incorrect) from t").ok(expected3);
    }

    @Test
    void testUnnest() {
        this.sql("select*from unnest(x)").ok("SELECT *\nFROM UNNEST(`X`)");
        this.sql("select*from unnest(x) AS T").ok("SELECT *\nFROM UNNEST(`X`) AS `T`");
        this.sql("^unnest^(x)").fails("(?s)Encountered \"unnest\" at.*");
        String sql = "select * from dept,\nunnest(dept.employees, dept.managers)";
        String expected = "SELECT *\nFROM `DEPT`,\nUNNEST(`DEPT`.`EMPLOYEES`, `DEPT`.`MANAGERS`)";
        this.sql("select * from dept,\nunnest(dept.employees, dept.managers)").ok("SELECT *\nFROM `DEPT`,\nUNNEST(`DEPT`.`EMPLOYEES`, `DEPT`.`MANAGERS`)");
        this.sql("select * from dept, lateral unnest(dept.employees)").ok("SELECT *\nFROM `DEPT`,\nUNNEST(`DEPT`.`EMPLOYEES`)");
        this.sql("select * from dept, unnest(dept.employees)").ok("SELECT *\nFROM `DEPT`,\nUNNEST(`DEPT`.`EMPLOYEES`)");
        String sql1 = "SELECT\n  item.name,\n  relations.*\nFROM dfs.tmp item\nJOIN (\n  SELECT * FROM UNNEST(item.related) i(rels)\n) relations\nON TRUE";
        String expected1 = "SELECT `ITEM`.`NAME`, `RELATIONS`.*\nFROM `DFS`.`TMP` AS `ITEM`\nINNER JOIN (SELECT *\nFROM UNNEST(`ITEM`.`RELATED`) AS `I` (`RELS`)) AS `RELATIONS` ON TRUE";
        this.sql("SELECT\n  item.name,\n  relations.*\nFROM dfs.tmp item\nJOIN (\n  SELECT * FROM UNNEST(item.related) i(rels)\n) relations\nON TRUE").ok("SELECT `ITEM`.`NAME`, `RELATIONS`.*\nFROM `DFS`.`TMP` AS `ITEM`\nINNER JOIN (SELECT *\nFROM UNNEST(`ITEM`.`RELATED`) AS `I` (`RELS`)) AS `RELATIONS` ON TRUE");
    }

    @Test
    void testUnnestWithOrdinality() {
        this.sql("select * from unnest(x) with ordinality").ok("SELECT *\nFROM UNNEST(`X`) WITH ORDINALITY");
        this.sql("select*from unnest(x) with ordinality AS T").ok("SELECT *\nFROM UNNEST(`X`) WITH ORDINALITY AS `T`");
        this.sql("select*from unnest(x) with ordinality AS T(c, o)").ok("SELECT *\nFROM UNNEST(`X`) WITH ORDINALITY AS `T` (`C`, `O`)");
        this.sql("select*from unnest(x) as T ^with^ ordinality").fails("(?s)Encountered \"with\" at .*");
    }

    @Test
    void testParensInFrom() {
        this.sql("select *from (^unnest(x)^)").fails("Expected query or join");
        this.sql("select * from (^emp^)").fails("(?s)Expected query or join.*");
        this.sql("select * from (^emp as x^)").fails("Expected query or join");
        this.sql("select * from (^emp^) as x").fails("Expected query or join");
        String sql1 = "select *\nfrom (emp join dept using (deptno))";
        String expected = "SELECT *\nFROM `EMP`\nINNER JOIN `DEPT` USING (`DEPTNO`)";
        this.sql(sql1).ok(expected);
        String sql2 = "select *\nfrom (emp join dept using (deptno))\njoin foo using (x)";
        String expected2 = "SELECT *\nFROM `EMP`\nINNER JOIN `DEPT` USING (`DEPTNO`)\nINNER JOIN `FOO` USING (`X`)";
        this.sql(sql2).ok(expected2);
        this.sql("select * from (t cross ^join^ u) as x").fails("Join expression encountered in illegal context");
        this.sql("select *\nfrom (t cross ^join^ u)\n  tablesample substitute('medium')").fails("Join expression encountered in illegal context");
        this.sql("select *\nfrom (t cross ^join^ u)\nPIVOT (sum(sal) AS sal FOR job in ('CLERK' AS c))").fails("Join expression encountered in illegal context");
    }

    @Test
    void testParenthesizedJoins() {
        String sql = "SELECT * FROM (((S.C c INNER JOIN S.N n ON n.id = c.id) INNER JOIN S.A a ON (NOT a.isactive)) INNER JOIN S.T t ON t.id = a.id)";
        String expected = "SELECT *\nFROM `S`.`C` AS `C`\nINNER JOIN `S`.`N` AS `N` ON (`N`.`ID` = `C`.`ID`)\nINNER JOIN `S`.`A` AS `A` ON (NOT `A`.`ISACTIVE`)\nINNER JOIN `S`.`T` AS `T` ON (`T`.`ID` = `A`.`ID`)";
        this.sql("SELECT * FROM (((S.C c INNER JOIN S.N n ON n.id = c.id) INNER JOIN S.A a ON (NOT a.isactive)) INNER JOIN S.T t ON t.id = a.id)").ok("SELECT *\nFROM `S`.`C` AS `C`\nINNER JOIN `S`.`N` AS `N` ON (`N`.`ID` = `C`.`ID`)\nINNER JOIN `S`.`A` AS `A` ON (NOT `A`.`ISACTIVE`)\nINNER JOIN `S`.`T` AS `T` ON (`T`.`ID` = `A`.`ID`)");
        String sql2 = "select *\nfrom a\n join (b join c on b.x = c.x)\n on a.y = c.y";
        String expected2 = "SELECT *\nFROM `A`\nINNER JOIN (`B` INNER JOIN `C` ON (`B`.`X` = `C`.`X`)) ON (`A`.`Y` = `C`.`Y`)";
        this.sql("select *\nfrom a\n join (b join c on b.x = c.x)\n on a.y = c.y").ok("SELECT *\nFROM `A`\nINNER JOIN (`B` INNER JOIN `C` ON (`B`.`X` = `C`.`X`)) ON (`A`.`Y` = `C`.`Y`)");
    }

    @Test
    void testParenthesizedUnionInFrom() {
        String sql = "select *\nfrom (\n  (select x from a)\n  union\n  (select y from b))";
        String expected = "SELECT *\nFROM (SELECT `X`\nFROM `A`\nUNION\nSELECT `Y`\nFROM `B`)";
        this.sql("select *\nfrom (\n  (select x from a)\n  union\n  (select y from b))").ok("SELECT *\nFROM (SELECT `X`\nFROM `A`\nUNION\nSELECT `Y`\nFROM `B`)");
    }

    @Test
    void testParenthesizedUnionAndJoinInFrom() {
        String sql = "select *\nfrom (\n  (select x from a) as a  cross join\n  (select x from a\n  union\n  select y from b) as b)";
        String expected = "SELECT *\nFROM (SELECT `X`\nFROM `A`) AS `A`\nCROSS JOIN (SELECT `X`\nFROM `A`\nUNION\nSELECT `Y`\nFROM `B`) AS `B`";
        this.sql("select *\nfrom (\n  (select x from a) as a  cross join\n  (select x from a\n  union\n  select y from b) as b)").ok("SELECT *\nFROM (SELECT `X`\nFROM `A`) AS `A`\nCROSS JOIN (SELECT `X`\nFROM `A`\nUNION\nSELECT `Y`\nFROM `B`) AS `B`");
    }

    @Test
    void testParenthesizedUnionAndJoinInFrom2() {
        String sql = "select *\nfrom (\n  (select x from a\n  union\n  select y from b) as b\n  cross join\n  (select x from a) as a)";
        String expected = "SELECT *\nFROM (SELECT `X`\nFROM `A`\nUNION\nSELECT `Y`\nFROM `B`) AS `B`\nCROSS JOIN (SELECT `X`\nFROM `A`) AS `A`";
        this.sql("select *\nfrom (\n  (select x from a\n  union\n  select y from b) as b\n  cross join\n  (select x from a) as a)").ok("SELECT *\nFROM (SELECT `X`\nFROM `A`\nUNION\nSELECT `Y`\nFROM `B`) AS `B`\nCROSS JOIN (SELECT `X`\nFROM `A`) AS `A`");
    }

    @Test
    void testParenthesizedUnionAndJoinInFrom3() {
        String sql = "select *\nfrom (\n  (select x from a\n  union\n  select y from b) as b\n  join\n  (select x from a) as a on b.x = a.x)";
        String expected = "SELECT *\nFROM (SELECT `X`\nFROM `A`\nUNION\nSELECT `Y`\nFROM `B`) AS `B`\nINNER JOIN (SELECT `X`\nFROM `A`) AS `A` ON (`B`.`X` = `A`.`X`)";
        this.sql("select *\nfrom (\n  (select x from a\n  union\n  select y from b) as b\n  join\n  (select x from a) as a on b.x = a.x)").ok("SELECT *\nFROM (SELECT `X`\nFROM `A`\nUNION\nSELECT `Y`\nFROM `B`) AS `B`\nINNER JOIN (SELECT `X`\nFROM `A`) AS `A` ON (`B`.`X` = `A`.`X`)");
    }

    @Test
    void testParenthesizedUnion() {
        String sql = "(select x from a\n  union\n  select y from b)\nexcept\n(select z from c)";
        String expected = "SELECT `X`\nFROM `A`\nUNION\nSELECT `Y`\nFROM `B`\nEXCEPT\nSELECT `Z`\nFROM `C`";
        this.sql("(select x from a\n  union\n  select y from b)\nexcept\n(select z from c)").ok("SELECT `X`\nFROM `A`\nUNION\nSELECT `Y`\nFROM `B`\nEXCEPT\nSELECT `Z`\nFROM `C`");
    }

    @Test
    void testFromExpr() {
        String sql0 = "select * from a cross join b";
        String sql1 = "select * from (a cross join b)";
        String expected = "SELECT *\nFROM `A`\nCROSS JOIN `B`";
        this.sql(sql0).ok(expected);
        this.sql(sql1).ok(expected);
    }

    @Test
    void testParenthesizedQueries() {
        String expected = "SELECT *\nFROM (SELECT *\nFROM `TAB`) AS `X`";
        String sql1 = "SELECT *\nFROM (((SELECT * FROM tab))) X";
        String sql2 = "SELECT *\nFROM ((((((((((((SELECT * FROM tab)))))))))))) X";
        this.sql("SELECT *\nFROM (((SELECT * FROM tab))) X").ok("SELECT *\nFROM (SELECT *\nFROM `TAB`) AS `X`");
        this.sql("SELECT *\nFROM ((((((((((((SELECT * FROM tab)))))))))))) X").ok("SELECT *\nFROM (SELECT *\nFROM `TAB`) AS `X`");
        String sql3 = "SELECT *\nFROM ((((((((((((SELECT * FROM t)))\n  cross join ((table t2)))))))))))";
        String expected3 = "SELECT *\nFROM (SELECT *\nFROM `T`)\nCROSS JOIN (TABLE `T2`)";
        this.sql("SELECT *\nFROM ((((((((((((SELECT * FROM t)))\n  cross join ((table t2)))))))))))").ok("SELECT *\nFROM (SELECT *\nFROM `T`)\nCROSS JOIN (TABLE `T2`)");
        String sql4 = "SELECT *\nFROM ((((((((((((SELECT * FROM t)))\n  cross ^join^ ((table t2))))))))))) X";
        String sql5 = "SELECT *\nFROM ((((((((((((SELECT * FROM t)))\n  cross ^join^ ((table t2))))))))))) as X";
        String sql6 = "SELECT *\nFROM ((((((((((((SELECT * FROM t)))\n  cross ^join^ ((table t2))))))))))) as X (a, b, c)";
        String message = "Join expression encountered in illegal context";
        this.sql("SELECT *\nFROM ((((((((((((SELECT * FROM t)))\n  cross ^join^ ((table t2))))))))))) X").fails("Join expression encountered in illegal context");
        this.sql("SELECT *\nFROM ((((((((((((SELECT * FROM t)))\n  cross ^join^ ((table t2))))))))))) as X").fails("Join expression encountered in illegal context");
        this.sql("SELECT *\nFROM ((((((((((((SELECT * FROM t)))\n  cross ^join^ ((table t2))))))))))) as X (a, b, c)").fails("Join expression encountered in illegal context");
    }

    @Test
    void testProcedureCall() {
        this.sql("call blubber(5)").ok("CALL `BLUBBER`(5)");
        this.sql("call \"blubber\"(5)").ok("CALL `blubber`(5)");
        this.sql("call whale.blubber(5)").ok("CALL `WHALE`.`BLUBBER`(5)");
    }

    @Test
    void testNewSpecification() {
        this.expr("new udt()").ok("(NEW `UDT`())");
        this.expr("new my.udt(1, 'hey')").ok("(NEW `MY`.`UDT`(1, 'hey'))");
        this.expr("new udt() is not null").ok("((NEW `UDT`()) IS NOT NULL)");
        this.expr("1 + new udt()").ok("(1 + (NEW `UDT`()))");
    }

    @Test
    void testMultisetCast() {
        this.expr("cast(multiset[1] as double multiset)").ok("CAST((MULTISET[1]) AS DOUBLE MULTISET)");
    }

    @Test
    void testAddCarets() {
        MatcherAssert.assertThat((Object)SqlParserUtil.addCarets((String)"values (foo)", (int)1, (int)9, (int)1, (int)12), (Matcher)CoreMatchers.is((Object)"values (^foo^)"));
        MatcherAssert.assertThat((Object)SqlParserUtil.addCarets((String)"abcdef", (int)1, (int)4, (int)1, (int)4), (Matcher)CoreMatchers.is((Object)"abc^def"));
        MatcherAssert.assertThat((Object)SqlParserUtil.addCarets((String)"abcdef", (int)1, (int)7, (int)1, (int)7), (Matcher)CoreMatchers.is((Object)"abcdef^"));
    }

    @Test
    void testSnapshotForSystemTimeWithAlias() {
        this.sql("SELECT * FROM orders LEFT JOIN products FOR SYSTEM_TIME AS OF orders.proctime as products ON orders.product_id = products.pro_id").ok("SELECT *\nFROM `ORDERS`\nLEFT JOIN `PRODUCTS` FOR SYSTEM_TIME AS OF `ORDERS`.`PROCTIME` AS `PRODUCTS` ON (`ORDERS`.`PRODUCT_ID` = `PRODUCTS`.`PRO_ID`)");
    }

    @Test
    protected void testMetadata() {
        SqlAbstractParserImpl.Metadata metadata = this.sql("").parser().getMetadata();
        MatcherAssert.assertThat((Object)metadata.isReservedFunctionName("ABS"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)metadata.isReservedFunctionName("FOO"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)metadata.isContextVariableName("CURRENT_USER"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)metadata.isContextVariableName("CURRENT_CATALOG"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)metadata.isContextVariableName("CURRENT_SCHEMA"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)metadata.isContextVariableName("ABS"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)metadata.isContextVariableName("FOO"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)metadata.isNonReservedKeyword("A"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)metadata.isNonReservedKeyword("KEY"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)metadata.isNonReservedKeyword("SELECT"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)metadata.isNonReservedKeyword("FOO"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)metadata.isNonReservedKeyword("ABS"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)metadata.isKeyword("ABS"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)metadata.isKeyword("CURRENT_USER"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)metadata.isKeyword("CURRENT_CATALOG"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)metadata.isKeyword("CURRENT_SCHEMA"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)metadata.isKeyword("KEY"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)metadata.isKeyword("SELECT"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)metadata.isKeyword("HAVING"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)metadata.isKeyword("A"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)metadata.isKeyword("BAR"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)metadata.isReservedWord("SELECT"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)metadata.isReservedWord("CURRENT_CATALOG"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)metadata.isReservedWord("CURRENT_SCHEMA"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)metadata.isReservedWord("KEY"), (Matcher)CoreMatchers.is((Object)false));
        String jdbcKeywords = metadata.getJdbcKeywords();
        MatcherAssert.assertThat((Object)jdbcKeywords.contains(",COLLECT,"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)(!jdbcKeywords.contains(",SELECT,") ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    void testTabStop() {
        this.sql("SELECT *\n\tFROM mytable").ok("SELECT *\nFROM `MYTABLE`");
        this.sql("SELECT *\tFROM mytable\t\tWHERE x ^=^ = y AND b = 1").fails("(?s).*Encountered \"= =\" at line 1, column 32\\..*");
    }

    @Test
    void testLongIdentifiers() {
        StringBuilder ident128Builder = new StringBuilder();
        for (int i = 0; i < 128; ++i) {
            ident128Builder.append((char)(97 + i % 26));
        }
        String ident128 = ident128Builder.toString();
        String ident128Upper = ident128.toUpperCase(Locale.US);
        String ident129 = "x" + ident128;
        String ident129Upper = ident129.toUpperCase(Locale.US);
        this.sql("select * from " + ident128).ok("SELECT *\nFROM `" + ident128Upper + "`");
        this.sql("select * from ^" + ident129 + "^").fails("Length of identifier '" + ident129Upper + "' must be less than or equal to 128 characters");
        this.sql("select " + ident128 + " from mytable").ok("SELECT `" + ident128Upper + "`\nFROM `MYTABLE`");
        this.sql("select ^" + ident129 + "^ from mytable").fails("Length of identifier '" + ident129Upper + "' must be less than or equal to 128 characters");
    }

    @Test
    void testQuotedFunction() {
        this.expr("\"CAST\"(1 ^as^ double)").fails("(?s).*Encountered \"as\" at .*");
        this.expr("\"POSITION\"('b' ^in^ 'alphabet')").fails("(?s).*Encountered \"in \\\\'alphabet\\\\'\" at .*");
        this.expr("\"OVERLAY\"('a' ^PLAcing^ 'b' from 1)").fails("(?s).*Encountered \"PLAcing\" at.*");
        this.expr("\"SUBSTRING\"('a' ^from^ 1)").fails("(?s).*Encountered \"from\" at .*");
    }

    @Test
    void testMemberFunction() {
        this.sql("SELECT myColumn.func(a, b) FROM tbl").ok("SELECT `MYCOLUMN`.`FUNC`(`A`, `B`)\nFROM `TBL`");
        this.sql("SELECT myColumn.mySubField.func() FROM tbl").ok("SELECT `MYCOLUMN`.`MYSUBFIELD`.`FUNC`()\nFROM `TBL`");
        this.sql("SELECT tbl.myColumn.mySubField.func() FROM tbl").ok("SELECT `TBL`.`MYCOLUMN`.`MYSUBFIELD`.`FUNC`()\nFROM `TBL`");
        this.sql("SELECT tbl.foo(0).col.bar(2, 3) FROM tbl").ok("SELECT ((`TBL`.`FOO`(0).`COL`).`BAR`(2, 3))\nFROM `TBL`");
    }

    @Test
    void testUnicodeLiteral() {
        String in1 = "values _UTF16'\u03b1\u03bd\u03b8\u03c1\u03c9\u03c0\u03bf\u03c2'";
        String out1 = "VALUES (ROW(_UTF16'\u03b1\u03bd\u03b8\u03c1\u03c9\u03c0\u03bf\u03c2'))";
        this.sql(in1).ok(out1);
        String in2 = "values '\\03B1\\03BD\\03B8\\03C1\\03C9\\03C0\\03BF\\03C2'";
        String out2 = "VALUES (ROW('\\03B1\\03BD\\03B8\\03C1\\03C9\\03C0\\03BF\\03C2'))";
        this.sql(in2).ok(out2);
        String in3 = "values U&'\\03B1\\03BD\\03B8\\03C1\\03C9\\03C0\\03BF\\03C2' UESCAPE '!'";
        String out3 = "VALUES (ROW(_UTF16'\\03B1\\03BD\\03B8\\03C1\\03C9\\03C0\\03BF\\03C2'))";
        this.sql(in3).ok(out3);
    }

    @Test
    void testUnicodeEscapedLiteral() {
        String in = "values U&'\\03B1\\03BD\\03B8\\03C1\\03C9\\03C0\\03BF\\03C2'";
        String out = "VALUES (ROW(_UTF16'\u03b1\u03bd\u03b8\u03c1\u03c9\u03c0\u03bf\u03c2'))";
        this.sql(in).ok(out);
        this.sql(in.replace("\\", "!") + "UESCAPE '!'").ok(out);
    }

    @Test
    void testIllegalUnicodeEscape() {
        this.expr("U&'abc' UESCAPE '!!'").fails(".*must be exactly one character.*");
        this.expr("U&'abc' UESCAPE ''").fails(".*must be exactly one character.*");
        this.expr("U&'abc' UESCAPE '0'").fails(".*hex digit.*");
        this.expr("U&'abc' UESCAPE 'a'").fails(".*hex digit.*");
        this.expr("U&'abc' UESCAPE 'F'").fails(".*hex digit.*");
        this.expr("U&'abc' UESCAPE ' '").fails(".*whitespace.*");
        this.expr("U&'abc' UESCAPE '+'").fails(".*plus sign.*");
        this.expr("U&'abc' UESCAPE '\"'").fails(".*double quote.*");
        this.expr("'abc' UESCAPE ^'!'^").fails(".*without Unicode literal introducer.*");
        this.expr("^U&'\\0A'^").fails(".*is not exactly four hex digits.*");
        this.expr("^U&'\\wxyz'^").fails(".*is not exactly four hex digits.*");
    }

    @Test
    void testSqlOptions() {
        SqlNode node = this.sql("alter system set schema = true").node();
        SqlSetOption opt = (SqlSetOption)node;
        MatcherAssert.assertThat((Object)opt.getScope(), (Matcher)CoreMatchers.equalTo((Object)"SYSTEM"));
        SqlPrettyWriter writer = new SqlPrettyWriter();
        MatcherAssert.assertThat((Object)writer.format((SqlNode)opt.getName()), (Matcher)CoreMatchers.equalTo((Object)"\"SCHEMA\""));
        writer = new SqlPrettyWriter();
        MatcherAssert.assertThat((Object)writer.format(opt.getValue()), (Matcher)CoreMatchers.equalTo((Object)"TRUE"));
        writer = new SqlPrettyWriter();
        MatcherAssert.assertThat((Object)writer.format((SqlNode)opt), (Matcher)CoreMatchers.equalTo((Object)"ALTER SYSTEM SET \"SCHEMA\" = TRUE"));
        this.sql("alter system set \"a number\" = 1").ok("ALTER SYSTEM SET `a number` = 1").node(SqlParserTest.isDdl());
        this.sql("alter system set flag = false").ok("ALTER SYSTEM SET `FLAG` = FALSE");
        this.sql("alter system set approx = -12.3450").ok("ALTER SYSTEM SET `APPROX` = -12.3450");
        this.sql("alter system set onOff = on").ok("ALTER SYSTEM SET `ONOFF` = `ON`");
        this.sql("alter system set onOff = off").ok("ALTER SYSTEM SET `ONOFF` = `OFF`");
        this.sql("alter system set baz = foo").ok("ALTER SYSTEM SET `BAZ` = `FOO`");
        this.sql("alter system set \"a\".\"number\" = 1").ok("ALTER SYSTEM SET `a`.`number` = 1");
        this.sql("set approx = -12.3450").ok("SET `APPROX` = -12.3450").node(SqlParserTest.isDdl());
        node = this.sql("reset schema").node();
        opt = (SqlSetOption)node;
        MatcherAssert.assertThat((Object)opt.getScope(), (Matcher)CoreMatchers.equalTo(null));
        writer = new SqlPrettyWriter();
        MatcherAssert.assertThat((Object)writer.format((SqlNode)opt.getName()), (Matcher)CoreMatchers.equalTo((Object)"\"SCHEMA\""));
        MatcherAssert.assertThat((Object)opt.getValue(), (Matcher)CoreMatchers.equalTo(null));
        writer = new SqlPrettyWriter();
        MatcherAssert.assertThat((Object)writer.format((SqlNode)opt), (Matcher)CoreMatchers.equalTo((Object)"RESET \"SCHEMA\""));
        this.sql("alter system RESET flag").ok("ALTER SYSTEM RESET `FLAG`");
        this.sql("reset onOff").ok("RESET `ONOFF`").node(SqlParserTest.isDdl());
        this.sql("reset \"this\".\"is\".\"sparta\"").ok("RESET `this`.`is`.`sparta`");
        this.sql("alter system reset all").ok("ALTER SYSTEM RESET `ALL`");
        this.sql("reset all").ok("RESET `ALL`");
        this.sql("alter system set aString = 'abc' ^||^ 'def' ").fails("(?s)Encountered \"\\|\\|\" at line 1, column 34\\..*");
        this.sql("alter system set x = 1^,^ y = 2").fails("(?s)Encountered \",\" at line 1, column 23\\..*");
    }

    @Test
    void testSequence() {
        this.sql("select next value for my_schema.my_seq from t").ok("SELECT (NEXT VALUE FOR `MY_SCHEMA`.`MY_SEQ`)\nFROM `T`");
        this.sql("select next value for my_schema.my_seq as s from t").ok("SELECT (NEXT VALUE FOR `MY_SCHEMA`.`MY_SEQ`) AS `S`\nFROM `T`");
        this.sql("select next value for my_seq as s from t").ok("SELECT (NEXT VALUE FOR `MY_SEQ`) AS `S`\nFROM `T`");
        this.sql("select 1 + next value for s + current value for s from t").ok("SELECT ((1 + (NEXT VALUE FOR `S`)) + (CURRENT VALUE FOR `S`))\nFROM `T`");
        this.sql("select 1 from t where next value for my_seq < 10").ok("SELECT 1\nFROM `T`\nWHERE ((NEXT VALUE FOR `MY_SEQ`) < 10)");
        this.sql("select 1 from t\nwhere next value for my_seq < 10 fetch next 3 rows only").ok("SELECT 1\nFROM `T`\nWHERE ((NEXT VALUE FOR `MY_SEQ`) < 10)\nFETCH NEXT 3 ROWS ONLY");
        this.sql("insert into t values next value for my_seq, current value for my_seq").ok("INSERT INTO `T`\nVALUES (ROW((NEXT VALUE FOR `MY_SEQ`))),\n(ROW((CURRENT VALUE FOR `MY_SEQ`)))");
        this.sql("insert into t values (1, current value for my_seq)").ok("INSERT INTO `T`\nVALUES (ROW(1, (CURRENT VALUE FOR `MY_SEQ`)))");
    }

    @Test
    void testPivot() {
        String sql = "SELECT * FROM emp\nPIVOT (sum(sal) AS sal FOR job in ('CLERK' AS c))";
        String expected = "SELECT *\nFROM `EMP` PIVOT (SUM(`SAL`) AS `SAL` FOR `JOB` IN ('CLERK' AS `C`))";
        this.sql("SELECT * FROM emp\nPIVOT (sum(sal) AS sal FOR job in ('CLERK' AS c))").ok("SELECT *\nFROM `EMP` PIVOT (SUM(`SAL`) AS `SAL` FOR `JOB` IN ('CLERK' AS `C`))");
        String sql2 = "SELECT * FROM emp\nPIVOT (sum(sal) AS sal FOR (job) in ('CLERK' AS c))";
        this.sql("SELECT * FROM emp\nPIVOT (sum(sal) AS sal FOR (job) in ('CLERK' AS c))").ok("SELECT *\nFROM `EMP` PIVOT (SUM(`SAL`) AS `SAL` FOR `JOB` IN ('CLERK' AS `C`))");
    }

    @Test
    void testPivotComposite() {
        String sql = "SELECT * FROM emp\nPIVOT (sum(sal) AS sal FOR (job, deptno) IN\n (('CLERK', 10) AS c10, ('MANAGER', 20) AS m20))";
        String expected = "SELECT *\nFROM `EMP` PIVOT (SUM(`SAL`) AS `SAL` FOR (`JOB`, `DEPTNO`) IN (('CLERK', 10) AS `C10`, ('MANAGER', 20) AS `M20`))";
        this.sql("SELECT * FROM emp\nPIVOT (sum(sal) AS sal FOR (job, deptno) IN\n (('CLERK', 10) AS c10, ('MANAGER', 20) AS m20))").ok("SELECT *\nFROM `EMP` PIVOT (SUM(`SAL`) AS `SAL` FOR (`JOB`, `DEPTNO`) IN (('CLERK', 10) AS `C10`, ('MANAGER', 20) AS `M20`))");
    }

    @Test
    void testPivotWithoutValues() {
        String sql = "SELECT * FROM emp\nPIVOT (sum(sal) AS sal FOR job IN ())";
        String expected = "SELECT *\nFROM `EMP` PIVOT (SUM(`SAL`) AS `SAL` FOR `JOB` IN ())";
        this.sql("SELECT * FROM emp\nPIVOT (sum(sal) AS sal FOR job IN ())").ok("SELECT *\nFROM `EMP` PIVOT (SUM(`SAL`) AS `SAL` FOR `JOB` IN ())");
    }

    @Test
    void testPivotWithoutAlias() {
        String sql = "SELECT * FROM emp\nPIVOT (sum(sal) FOR job in ('CLERK'))";
        String expected = "SELECT *\nFROM `EMP` PIVOT (SUM(`SAL`) FOR `JOB` IN ('CLERK'))";
        this.sql("SELECT * FROM emp\nPIVOT (sum(sal) FOR job in ('CLERK'))").ok("SELECT *\nFROM `EMP` PIVOT (SUM(`SAL`) FOR `JOB` IN ('CLERK'))");
    }

    @Test
    void testPivotErrorExpressionInFor() {
        String sql = "SELECT * FROM emp\nPIVOT (sum(sal) AS sal FOR deptno ^-^10 IN (10, 20)";
        this.sql("SELECT * FROM emp\nPIVOT (sum(sal) AS sal FOR deptno ^-^10 IN (10, 20)").fails("(?s)Encountered \"-\" at .*");
    }

    @Test
    void testPivotErrorExpressionInCompositeFor() {
        String sql = "SELECT * FROM emp\nPIVOT (sum(sal) AS sal FOR (job, deptno ^-^10)\n IN (('CLERK', 10), ('MANAGER', 20))";
        this.sql("SELECT * FROM emp\nPIVOT (sum(sal) AS sal FOR (job, deptno ^-^10)\n IN (('CLERK', 10), ('MANAGER', 20))").fails("(?s)Encountered \"-\" at .*");
    }

    @Test
    void testPivot2() {
        String sql = "SELECT *\nFROM (SELECT deptno, job, sal\n    FROM   emp)\nPIVOT (SUM(sal) AS sum_sal, COUNT(*) AS \"COUNT\"\n    FOR (job, deptno)\n    IN (('CLERK', 10),\n        ('MANAGER', 20) mgr20,\n        ('ANALYST', 10) AS \"a10\"))\nORDER BY deptno";
        String expected = "SELECT *\nFROM (SELECT `DEPTNO`, `JOB`, `SAL`\nFROM `EMP`) PIVOT (SUM(`SAL`) AS `SUM_SAL`, COUNT(*) AS `COUNT` FOR (`JOB`, `DEPTNO`) IN (('CLERK', 10), ('MANAGER', 20) AS `MGR20`, ('ANALYST', 10) AS `a10`))\nORDER BY `DEPTNO`";
        this.sql("SELECT *\nFROM (SELECT deptno, job, sal\n    FROM   emp)\nPIVOT (SUM(sal) AS sum_sal, COUNT(*) AS \"COUNT\"\n    FOR (job, deptno)\n    IN (('CLERK', 10),\n        ('MANAGER', 20) mgr20,\n        ('ANALYST', 10) AS \"a10\"))\nORDER BY deptno").ok("SELECT *\nFROM (SELECT `DEPTNO`, `JOB`, `SAL`\nFROM `EMP`) PIVOT (SUM(`SAL`) AS `SUM_SAL`, COUNT(*) AS `COUNT` FOR (`JOB`, `DEPTNO`) IN (('CLERK', 10), ('MANAGER', 20) AS `MGR20`, ('ANALYST', 10) AS `a10`))\nORDER BY `DEPTNO`");
    }

    @Test
    void testUnpivot() {
        String sql = "SELECT *\nFROM emp_pivoted\nUNPIVOT (\n  (sum_sal, count_star)\n  FOR (job, deptno)\n  IN ((c10_ss, c10_c) AS ('CLERK', 10),\n      (c20_ss, c20_c) AS ('CLERK', 20),\n      (a20_ss, a20_c) AS ('ANALYST', 20)))";
        String expected = "SELECT *\nFROM `EMP_PIVOTED` UNPIVOT EXCLUDE NULLS ((`SUM_SAL`, `COUNT_STAR`) FOR (`JOB`, `DEPTNO`) IN ((`C10_SS`, `C10_C`) AS ('CLERK', 10), (`C20_SS`, `C20_C`) AS ('CLERK', 20), (`A20_SS`, `A20_C`) AS ('ANALYST', 20)))";
        this.sql("SELECT *\nFROM emp_pivoted\nUNPIVOT (\n  (sum_sal, count_star)\n  FOR (job, deptno)\n  IN ((c10_ss, c10_c) AS ('CLERK', 10),\n      (c20_ss, c20_c) AS ('CLERK', 20),\n      (a20_ss, a20_c) AS ('ANALYST', 20)))").ok("SELECT *\nFROM `EMP_PIVOTED` UNPIVOT EXCLUDE NULLS ((`SUM_SAL`, `COUNT_STAR`) FOR (`JOB`, `DEPTNO`) IN ((`C10_SS`, `C10_C`) AS ('CLERK', 10), (`C20_SS`, `C20_C`) AS ('CLERK', 20), (`A20_SS`, `A20_C`) AS ('ANALYST', 20)))");
    }

    @Test
    void testPivotThroughShuttle() {
        String sql = "SELECT *\nFROM (SELECT job, deptno FROM \"EMP\")\nPIVOT (COUNT(*) AS \"COUNT\" FOR deptno IN (10, 50, 20))";
        String expected = "SELECT *\nFROM (SELECT `JOB`, `DEPTNO`\nFROM `EMP`) PIVOT (COUNT(*) AS `COUNT` FOR `DEPTNO` IN (10, 50, 20))";
        SqlNode sqlNode = this.sql("SELECT *\nFROM (SELECT job, deptno FROM \"EMP\")\nPIVOT (COUNT(*) AS \"COUNT\" FOR deptno IN (10, 50, 20))").node();
        SqlNode shuttled = (SqlNode)sqlNode.accept((SqlVisitor)new SqlShuttle(){

            public @Nullable SqlNode visit(SqlCall call) {
                SqlShuttle.CallCopyingArgHandler argHandler = new SqlShuttle.CallCopyingArgHandler((SqlShuttle)this, call, true);
                call.getOperator().acceptCall((SqlVisitor)this, call, false, (SqlBasicVisitor.ArgHandler)argHandler);
                return argHandler.result();
            }
        });
        MatcherAssert.assertThat((Object)Util.toLinux((String)shuttled.toString()), (Matcher)CoreMatchers.is((Object)"SELECT *\nFROM (SELECT `JOB`, `DEPTNO`\nFROM `EMP`) PIVOT (COUNT(*) AS `COUNT` FOR `DEPTNO` IN (10, 50, 20))"));
    }

    @Test
    void testMatchRecognize1() {
        String sql = "select *\n  from t match_recognize\n  (\n    partition by type, price\n    order by type asc, price desc\n    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPARTITION BY `TYPE`, `PRICE`\nORDER BY `TYPE`, `PRICE` DESC\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n    partition by type, price\n    order by type asc, price desc\n    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPARTITION BY `TYPE`, `PRICE`\nORDER BY `TYPE`, `PRICE` DESC\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognize2() {
        String sql = "select *\n  from t match_recognize\n  (\n    pattern (strt down+ up+$)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)) $)\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n    pattern (strt down+ up+$)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)) $)\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognize3() {
        String sql = "select *\n  from t match_recognize\n  (\n    pattern (^^strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN (^ ((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n    pattern (^^strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN (^ ((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognize4() {
        String sql = "select *\n  from t match_recognize\n  (\n    pattern (^^strt down+ up+$)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN (^ ((`STRT` (`DOWN` +)) (`UP` +)) $)\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n    pattern (^^strt down+ up+$)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN (^ ((`STRT` (`DOWN` +)) (`UP` +)) $)\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognize5() {
        String sql = "select *\n  from (select * from t) match_recognize\n  (\n    pattern (strt down* up?)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM (SELECT *\nFROM `T`) MATCH_RECOGNIZE(\nPATTERN (((`STRT` (`DOWN` *)) (`UP` ?)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from (select * from t) match_recognize\n  (\n    pattern (strt down* up?)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr").ok("SELECT *\nFROM (SELECT *\nFROM `T`) MATCH_RECOGNIZE(\nPATTERN (((`STRT` (`DOWN` *)) (`UP` ?)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognize6() {
        String sql = "select *\n  from t match_recognize\n  (\n    pattern (strt {-down-} up?)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN (((`STRT` ({- `DOWN` -})) (`UP` ?)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n    pattern (strt {-down-} up?)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN (((`STRT` ({- `DOWN` -})) (`UP` ?)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognize7() {
        String sql = "select *\n  from t match_recognize\n  (\n    pattern (strt down{2} up{3,})\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN (((`STRT` (`DOWN` { 2 })) (`UP` { 3, })))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n    pattern (strt down{2} up{3,})\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN (((`STRT` (`DOWN` { 2 })) (`UP` { 3, })))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognize8() {
        String sql = "select *\n  from t match_recognize\n  (\n    pattern (strt down{,2} up{3,5})\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN (((`STRT` (`DOWN` { , 2 })) (`UP` { 3, 5 })))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n    pattern (strt down{,2} up{3,5})\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN (((`STRT` (`DOWN` { , 2 })) (`UP` { 3, 5 })))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognize9() {
        String sql = "select *\n  from t match_recognize\n  (\n    pattern (strt {-down+-} {-up*-})\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN (((`STRT` ({- (`DOWN` +) -})) ({- (`UP` *) -})))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n    pattern (strt {-down+-} {-up*-})\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN (((`STRT` ({- (`DOWN` +) -})) ({- (`UP` *) -})))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognize10() {
        String sql = "select *\n  from t match_recognize\n  (\n    pattern ( A B C | A C B | B A C | B C A | C A B | C B A)\n    define\n      A as A.price > PREV(A.price),\n      B as B.price < prev(B.price),\n      C as C.price > prev(C.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN ((((((((`A` `B`) `C`) | ((`A` `C`) `B`)) | ((`B` `A`) `C`)) | ((`B` `C`) `A`)) | ((`C` `A`) `B`)) | ((`C` `B`) `A`)))\nDEFINE `A` AS (`A`.`PRICE` > PREV(`A`.`PRICE`, 1)), `B` AS (`B`.`PRICE` < PREV(`B`.`PRICE`, 1)), `C` AS (`C`.`PRICE` > PREV(`C`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n    pattern ( A B C | A C B | B A C | B C A | C A B | C B A)\n    define\n      A as A.price > PREV(A.price),\n      B as B.price < prev(B.price),\n      C as C.price > prev(C.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN ((((((((`A` `B`) `C`) | ((`A` `C`) `B`)) | ((`B` `A`) `C`)) | ((`B` `C`) `A`)) | ((`C` `A`) `B`)) | ((`C` `B`) `A`)))\nDEFINE `A` AS (`A`.`PRICE` > PREV(`A`.`PRICE`, 1)), `B` AS (`B`.`PRICE` < PREV(`B`.`PRICE`, 1)), `C` AS (`C`.`PRICE` > PREV(`C`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognize11() {
        String sql = "select *\n  from t match_recognize (\n    pattern ( \"a\" \"b c\")\n    define\n      \"A\" as A.price > PREV(A.price),\n      \"b c\" as \"b c\".foo\n  ) as mr(c1, c2) join e as x on foo = baz";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN ((`a` `b c`))\nDEFINE `A` AS (`A`.`PRICE` > PREV(`A`.`PRICE`, 1)), `b c` AS `b c`.`FOO`) AS `MR` (`C1`, `C2`)\nINNER JOIN `E` AS `X` ON (`FOO` = `BAZ`)";
        this.sql("select *\n  from t match_recognize (\n    pattern ( \"a\" \"b c\")\n    define\n      \"A\" as A.price > PREV(A.price),\n      \"b c\" as \"b c\".foo\n  ) as mr(c1, c2) join e as x on foo = baz").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN ((`a` `b c`))\nDEFINE `A` AS (`A`.`PRICE` > PREV(`A`.`PRICE`, 1)), `b c` AS `b c`.`FOO`) AS `MR` (`C1`, `C2`)\nINNER JOIN `E` AS `X` ON (`FOO` = `BAZ`)");
    }

    @Test
    void testMatchRecognizeDefineClause() {
        String sql = "select *\n  from t match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > NEXT(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > NEXT(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > NEXT(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > NEXT(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognizeDefineClause2() {
        String sql = "select *\n  from t match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.price < FIRST(down.price),\n      up as up.price > LAST(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < FIRST(`DOWN`.`PRICE`, 0)), `UP` AS (`UP`.`PRICE` > LAST(`UP`.`PRICE`, 0))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.price < FIRST(down.price),\n      up as up.price > LAST(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < FIRST(`DOWN`.`PRICE`, 0)), `UP` AS (`UP`.`PRICE` > LAST(`UP`.`PRICE`, 0))) AS `MR`");
    }

    @Test
    void testMatchRecognizeDefineClause3() {
        String sql = "select *\n  from t match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price,1),\n      up as up.price > LAST(up.price + up.TAX)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > LAST((`UP`.`PRICE` + `UP`.`TAX`), 0))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price,1),\n      up as up.price > LAST(up.price + up.TAX)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > LAST((`UP`.`PRICE` + `UP`.`TAX`), 0))) AS `MR`");
    }

    @Test
    void testMatchRecognizeDefineClause4() {
        String sql = "select *\n  from t match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price,1),\n      up as up.price > PREV(LAST(up.price + up.TAX),3)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(LAST((`UP`.`PRICE` + `UP`.`TAX`), 0), 3))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price,1),\n      up as up.price > PREV(LAST(up.price + up.TAX),3)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(LAST((`UP`.`PRICE` + `UP`.`TAX`), 0), 3))) AS `MR`");
    }

    @Test
    void testMatchRecognizeMeasures1() {
        String sql = "select *\n  from t match_recognize\n  (\n   measures    MATCH_NUMBER() as match_num,   CLASSIFIER() as var_match,   STRT.ts as start_ts,   LAST(DOWN.ts) as bottom_ts,   LAST(up.ts) as end_ts    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nMEASURES (MATCH_NUMBER()) AS `MATCH_NUM`, (CLASSIFIER()) AS `VAR_MATCH`, `STRT`.`TS` AS `START_TS`, LAST(`DOWN`.`TS`, 0) AS `BOTTOM_TS`, LAST(`UP`.`TS`, 0) AS `END_TS`\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n   measures    MATCH_NUMBER() as match_num,   CLASSIFIER() as var_match,   STRT.ts as start_ts,   LAST(DOWN.ts) as bottom_ts,   LAST(up.ts) as end_ts    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nMEASURES (MATCH_NUMBER()) AS `MATCH_NUM`, (CLASSIFIER()) AS `VAR_MATCH`, `STRT`.`TS` AS `START_TS`, LAST(`DOWN`.`TS`, 0) AS `BOTTOM_TS`, LAST(`UP`.`TS`, 0) AS `END_TS`\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognizeMeasures2() {
        String sql = "select *\n  from t match_recognize\n  (\n   measures STRT.ts as start_ts,  FINAL LAST(DOWN.ts) as bottom_ts,   LAST(up.ts) as end_ts    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nMEASURES `STRT`.`TS` AS `START_TS`, FINAL LAST(`DOWN`.`TS`, 0) AS `BOTTOM_TS`, LAST(`UP`.`TS`, 0) AS `END_TS`\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n   measures STRT.ts as start_ts,  FINAL LAST(DOWN.ts) as bottom_ts,   LAST(up.ts) as end_ts    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nMEASURES `STRT`.`TS` AS `START_TS`, FINAL LAST(`DOWN`.`TS`, 0) AS `BOTTOM_TS`, LAST(`UP`.`TS`, 0) AS `END_TS`\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognizeMeasures3() {
        String sql = "select *\n  from t match_recognize\n  (\n   measures STRT.ts as start_ts,  RUNNING LAST(DOWN.ts) as bottom_ts,   LAST(up.ts) as end_ts    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nMEASURES `STRT`.`TS` AS `START_TS`, RUNNING LAST(`DOWN`.`TS`, 0) AS `BOTTOM_TS`, LAST(`UP`.`TS`, 0) AS `END_TS`\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n   measures STRT.ts as start_ts,  RUNNING LAST(DOWN.ts) as bottom_ts,   LAST(up.ts) as end_ts    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nMEASURES `STRT`.`TS` AS `START_TS`, RUNNING LAST(`DOWN`.`TS`, 0) AS `BOTTOM_TS`, LAST(`UP`.`TS`, 0) AS `END_TS`\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognizeMeasures4() {
        String sql = "select *\n  from t match_recognize\n  (\n   measures   FINAL count(up.ts) as up_ts,  FINAL count(ts) as total_ts,  RUNNING count(ts) as cnt_ts,  price - strt.price as price_dif    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nMEASURES FINAL COUNT(`UP`.`TS`) AS `UP_TS`, FINAL COUNT(`TS`) AS `TOTAL_TS`, RUNNING COUNT(`TS`) AS `CNT_TS`, (`PRICE` - `STRT`.`PRICE`) AS `PRICE_DIF`\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n   measures   FINAL count(up.ts) as up_ts,  FINAL count(ts) as total_ts,  RUNNING count(ts) as cnt_ts,  price - strt.price as price_dif    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nMEASURES FINAL COUNT(`UP`.`TS`) AS `UP_TS`, FINAL COUNT(`TS`) AS `TOTAL_TS`, RUNNING COUNT(`TS`) AS `CNT_TS`, (`PRICE` - `STRT`.`PRICE`) AS `PRICE_DIF`\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognizeMeasures5() {
        String sql = "select *\n  from t match_recognize\n  (\n   measures   FIRST(STRT.ts) as strt_ts,  LAST(DOWN.ts) as down_ts,  AVG(DOWN.ts) as avg_down_ts    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nMEASURES FIRST(`STRT`.`TS`, 0) AS `STRT_TS`, LAST(`DOWN`.`TS`, 0) AS `DOWN_TS`, AVG(`DOWN`.`TS`) AS `AVG_DOWN_TS`\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n   measures   FIRST(STRT.ts) as strt_ts,  LAST(DOWN.ts) as down_ts,  AVG(DOWN.ts) as avg_down_ts    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nMEASURES FIRST(`STRT`.`TS`, 0) AS `STRT_TS`, LAST(`DOWN`.`TS`, 0) AS `DOWN_TS`, AVG(`DOWN`.`TS`) AS `AVG_DOWN_TS`\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognizeMeasures6() {
        String sql = "select *\n  from t match_recognize\n  (\n   measures   FIRST(STRT.ts) as strt_ts,  LAST(DOWN.ts) as down_ts,  FINAL SUM(DOWN.ts) as sum_down_ts    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nMEASURES FIRST(`STRT`.`TS`, 0) AS `STRT_TS`, LAST(`DOWN`.`TS`, 0) AS `DOWN_TS`, FINAL SUM(`DOWN`.`TS`) AS `SUM_DOWN_TS`\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n   measures   FIRST(STRT.ts) as strt_ts,  LAST(DOWN.ts) as down_ts,  FINAL SUM(DOWN.ts) as sum_down_ts    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nMEASURES FIRST(`STRT`.`TS`, 0) AS `STRT_TS`, LAST(`DOWN`.`TS`, 0) AS `DOWN_TS`, FINAL SUM(`DOWN`.`TS`) AS `SUM_DOWN_TS`\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognizePatternSkip1() {
        String sql = "select *\n  from t match_recognize\n  (\n     after match skip to next row\n    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n     after match skip to next row\n    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nAFTER MATCH SKIP TO NEXT ROW\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognizePatternSkip2() {
        String sql = "select *\n  from t match_recognize\n  (\n     after match skip past last row\n    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nAFTER MATCH SKIP PAST LAST ROW\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n     after match skip past last row\n    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nAFTER MATCH SKIP PAST LAST ROW\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognizePatternSkip3() {
        String sql = "select *\n  from t match_recognize\n  (\n     after match skip to FIRST down\n    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nAFTER MATCH SKIP TO FIRST `DOWN`\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n     after match skip to FIRST down\n    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nAFTER MATCH SKIP TO FIRST `DOWN`\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognizePatternSkip4() {
        String sql = "select *\n  from t match_recognize\n  (\n     after match skip to LAST down\n    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nAFTER MATCH SKIP TO LAST `DOWN`\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n     after match skip to LAST down\n    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nAFTER MATCH SKIP TO LAST `DOWN`\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognizePatternSkip5() {
        String sql = "select *\n  from t match_recognize\n  (\n     after match skip to down\n    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nAFTER MATCH SKIP TO LAST `DOWN`\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n     after match skip to down\n    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nAFTER MATCH SKIP TO LAST `DOWN`\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognizePatternSkip6() {
        String sql = "select *\n  from t match_recognize\n  (\n     after match skip to last\n    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nAFTER MATCH SKIP TO LAST `LAST`\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n     after match skip to last\n    pattern (strt down+ up+)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nAFTER MATCH SKIP TO LAST `LAST`\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognizeSubset1() {
        String sql = "select *\n  from t match_recognize\n  (\n    pattern (strt down+ up+)\n    subset stdn = (strt, down)    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nSUBSET (`STDN` = (`STRT`, `DOWN`))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n    pattern (strt down+ up+)\n    subset stdn = (strt, down)    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nSUBSET (`STDN` = (`STRT`, `DOWN`))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognizeSubset2() {
        String sql = "select *\n  from t match_recognize\n  (\n   measures STRT.ts as start_ts,   LAST(DOWN.ts) as bottom_ts,   AVG(stdn.price) as stdn_avg    pattern (strt down+ up+)\n    subset stdn = (strt, down)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nMEASURES `STRT`.`TS` AS `START_TS`, LAST(`DOWN`.`TS`, 0) AS `BOTTOM_TS`, AVG(`STDN`.`PRICE`) AS `STDN_AVG`\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nSUBSET (`STDN` = (`STRT`, `DOWN`))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n   measures STRT.ts as start_ts,   LAST(DOWN.ts) as bottom_ts,   AVG(stdn.price) as stdn_avg    pattern (strt down+ up+)\n    subset stdn = (strt, down)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nMEASURES `STRT`.`TS` AS `START_TS`, LAST(`DOWN`.`TS`, 0) AS `BOTTOM_TS`, AVG(`STDN`.`PRICE`) AS `STDN_AVG`\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nSUBSET (`STDN` = (`STRT`, `DOWN`))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognizeSubset3() {
        String sql = "select *\n  from t match_recognize\n  (\n   measures STRT.ts as start_ts,   LAST(DOWN.ts) as bottom_ts,   AVG(stdn.price) as stdn_avg    pattern (strt down+ up+)\n    subset stdn = (strt, down), stdn2 = (strt, down)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nMEASURES `STRT`.`TS` AS `START_TS`, LAST(`DOWN`.`TS`, 0) AS `BOTTOM_TS`, AVG(`STDN`.`PRICE`) AS `STDN_AVG`\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nSUBSET (`STDN` = (`STRT`, `DOWN`)), (`STDN2` = (`STRT`, `DOWN`))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n   measures STRT.ts as start_ts,   LAST(DOWN.ts) as bottom_ts,   AVG(stdn.price) as stdn_avg    pattern (strt down+ up+)\n    subset stdn = (strt, down), stdn2 = (strt, down)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nMEASURES `STRT`.`TS` AS `START_TS`, LAST(`DOWN`.`TS`, 0) AS `BOTTOM_TS`, AVG(`STDN`.`PRICE`) AS `STDN_AVG`\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nSUBSET (`STDN` = (`STRT`, `DOWN`)), (`STDN2` = (`STRT`, `DOWN`))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognizeRowsPerMatch1() {
        String sql = "select *\n  from t match_recognize\n  (\n   measures STRT.ts as start_ts,   LAST(DOWN.ts) as bottom_ts,   AVG(stdn.price) as stdn_avg   ONE ROW PER MATCH    pattern (strt down+ up+)\n    subset stdn = (strt, down), stdn2 = (strt, down)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nMEASURES `STRT`.`TS` AS `START_TS`, LAST(`DOWN`.`TS`, 0) AS `BOTTOM_TS`, AVG(`STDN`.`PRICE`) AS `STDN_AVG`\nONE ROW PER MATCH\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nSUBSET (`STDN` = (`STRT`, `DOWN`)), (`STDN2` = (`STRT`, `DOWN`))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n   measures STRT.ts as start_ts,   LAST(DOWN.ts) as bottom_ts,   AVG(stdn.price) as stdn_avg   ONE ROW PER MATCH    pattern (strt down+ up+)\n    subset stdn = (strt, down), stdn2 = (strt, down)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nMEASURES `STRT`.`TS` AS `START_TS`, LAST(`DOWN`.`TS`, 0) AS `BOTTOM_TS`, AVG(`STDN`.`PRICE`) AS `STDN_AVG`\nONE ROW PER MATCH\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nSUBSET (`STDN` = (`STRT`, `DOWN`)), (`STDN2` = (`STRT`, `DOWN`))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognizeRowsPerMatch2() {
        String sql = "select *\n  from t match_recognize\n  (\n   measures STRT.ts as start_ts,   LAST(DOWN.ts) as bottom_ts,   AVG(stdn.price) as stdn_avg   ALL ROWS PER MATCH    pattern (strt down+ up+)\n    subset stdn = (strt, down), stdn2 = (strt, down)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nMEASURES `STRT`.`TS` AS `START_TS`, LAST(`DOWN`.`TS`, 0) AS `BOTTOM_TS`, AVG(`STDN`.`PRICE`) AS `STDN_AVG`\nALL ROWS PER MATCH\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nSUBSET (`STDN` = (`STRT`, `DOWN`)), (`STDN2` = (`STRT`, `DOWN`))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n   measures STRT.ts as start_ts,   LAST(DOWN.ts) as bottom_ts,   AVG(stdn.price) as stdn_avg   ALL ROWS PER MATCH    pattern (strt down+ up+)\n    subset stdn = (strt, down), stdn2 = (strt, down)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nMEASURES `STRT`.`TS` AS `START_TS`, LAST(`DOWN`.`TS`, 0) AS `BOTTOM_TS`, AVG(`STDN`.`PRICE`) AS `STDN_AVG`\nALL ROWS PER MATCH\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +)))\nSUBSET (`STDN` = (`STRT`, `DOWN`)), (`STDN2` = (`STRT`, `DOWN`))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testMatchRecognizeWithin() {
        String sql = "select *\n  from t match_recognize\n  (\n    order by rowtime\n    measures STRT.ts as start_ts,\n      LAST(DOWN.ts) as bottom_ts,\n      AVG(stdn.price) as stdn_avg\n    pattern (strt down+ up+) within interval '3' second\n    subset stdn = (strt, down), stdn2 = (strt, down)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr";
        String expected = "SELECT *\nFROM `T` MATCH_RECOGNIZE(\nORDER BY `ROWTIME`\nMEASURES `STRT`.`TS` AS `START_TS`, LAST(`DOWN`.`TS`, 0) AS `BOTTOM_TS`, AVG(`STDN`.`PRICE`) AS `STDN_AVG`\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +))) WITHIN INTERVAL '3' SECOND\nSUBSET (`STDN` = (`STRT`, `DOWN`)), (`STDN2` = (`STRT`, `DOWN`))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`";
        this.sql("select *\n  from t match_recognize\n  (\n    order by rowtime\n    measures STRT.ts as start_ts,\n      LAST(DOWN.ts) as bottom_ts,\n      AVG(stdn.price) as stdn_avg\n    pattern (strt down+ up+) within interval '3' second\n    subset stdn = (strt, down), stdn2 = (strt, down)\n    define\n      down as down.price < PREV(down.price),\n      up as up.price > prev(up.price)\n  ) mr").ok("SELECT *\nFROM `T` MATCH_RECOGNIZE(\nORDER BY `ROWTIME`\nMEASURES `STRT`.`TS` AS `START_TS`, LAST(`DOWN`.`TS`, 0) AS `BOTTOM_TS`, AVG(`STDN`.`PRICE`) AS `STDN_AVG`\nPATTERN (((`STRT` (`DOWN` +)) (`UP` +))) WITHIN INTERVAL '3' SECOND\nSUBSET (`STDN` = (`STRT`, `DOWN`)), (`STDN2` = (`STRT`, `DOWN`))\nDEFINE `DOWN` AS (`DOWN`.`PRICE` < PREV(`DOWN`.`PRICE`, 1)), `UP` AS (`UP`.`PRICE` > PREV(`UP`.`PRICE`, 1))) AS `MR`");
    }

    @Test
    void testWithinGroupClause1() {
        String sql = "select col1,\n collect(col2) within group (order by col3)\nfrom t\norder by col1 limit 10";
        String expected = "SELECT `COL1`, COLLECT(`COL2`) WITHIN GROUP (ORDER BY `COL3`)\nFROM `T`\nORDER BY `COL1`\nFETCH NEXT 10 ROWS ONLY";
        this.sql("select col1,\n collect(col2) within group (order by col3)\nfrom t\norder by col1 limit 10").ok("SELECT `COL1`, COLLECT(`COL2`) WITHIN GROUP (ORDER BY `COL3`)\nFROM `T`\nORDER BY `COL1`\nFETCH NEXT 10 ROWS ONLY");
    }

    @Test
    void testWithinGroupClause2() {
        String sql = "select collect(col2) within group (order by col3)\nfrom t\norder by col1 limit 10";
        String expected = "SELECT COLLECT(`COL2`) WITHIN GROUP (ORDER BY `COL3`)\nFROM `T`\nORDER BY `COL1`\nFETCH NEXT 10 ROWS ONLY";
        this.sql("select collect(col2) within group (order by col3)\nfrom t\norder by col1 limit 10").ok("SELECT COLLECT(`COL2`) WITHIN GROUP (ORDER BY `COL3`)\nFROM `T`\nORDER BY `COL1`\nFETCH NEXT 10 ROWS ONLY");
    }

    @Test
    void testWithinGroupClause3() {
        String sql = "select collect(col2) within group (^)^ from t order by col1 limit 10";
        this.sql("select collect(col2) within group (^)^ from t order by col1 limit 10").fails("(?s).*Encountered \"\\)\" at line 1, column 36\\..*");
    }

    @Test
    void testWithinGroupClause4() {
        String sql = "select col1,\n collect(col2) within group (order by col3, col4)\nfrom t\norder by col1 limit 10";
        String expected = "SELECT `COL1`, COLLECT(`COL2`) WITHIN GROUP (ORDER BY `COL3`, `COL4`)\nFROM `T`\nORDER BY `COL1`\nFETCH NEXT 10 ROWS ONLY";
        this.sql("select col1,\n collect(col2) within group (order by col3, col4)\nfrom t\norder by col1 limit 10").ok("SELECT `COL1`, COLLECT(`COL2`) WITHIN GROUP (ORDER BY `COL3`, `COL4`)\nFROM `T`\nORDER BY `COL1`\nFETCH NEXT 10 ROWS ONLY");
    }

    @Test
    void testWithinGroupClause5() {
        String sql = "select col1,\n collect(col2) within group (\n  order by col3 desc nulls first, col4 asc nulls last)\nfrom t\norder by col1 limit 10";
        String expected = "SELECT `COL1`, COLLECT(`COL2`) WITHIN GROUP (ORDER BY `COL3` DESC NULLS FIRST, `COL4` NULLS LAST)\nFROM `T`\nORDER BY `COL1`\nFETCH NEXT 10 ROWS ONLY";
        this.sql("select col1,\n collect(col2) within group (\n  order by col3 desc nulls first, col4 asc nulls last)\nfrom t\norder by col1 limit 10").ok("SELECT `COL1`, COLLECT(`COL2`) WITHIN GROUP (ORDER BY `COL3` DESC NULLS FIRST, `COL4` NULLS LAST)\nFROM `T`\nORDER BY `COL1`\nFETCH NEXT 10 ROWS ONLY");
    }

    @Test
    void testStringAgg() {
        String sql = "select\n  string_agg(ename order by deptno, ename) as c1,\n  string_agg(ename, '; ' order by deptno, ename desc) as c2,\n  string_agg(ename) as c3,\n  string_agg(ename, ':') as c4,\n  string_agg(ename, ':' ignore nulls) as c5\nfrom emp group by gender";
        String expected = "SELECT STRING_AGG(`ENAME` ORDER BY `DEPTNO`, `ENAME`) AS `C1`, STRING_AGG(`ENAME`, '; ' ORDER BY `DEPTNO`, `ENAME` DESC) AS `C2`, STRING_AGG(`ENAME`) AS `C3`, STRING_AGG(`ENAME`, ':') AS `C4`, STRING_AGG(`ENAME`, ':') IGNORE NULLS AS `C5`\nFROM `EMP`\nGROUP BY `GENDER`";
        this.sql("select\n  string_agg(ename order by deptno, ename) as c1,\n  string_agg(ename, '; ' order by deptno, ename desc) as c2,\n  string_agg(ename) as c3,\n  string_agg(ename, ':') as c4,\n  string_agg(ename, ':' ignore nulls) as c5\nfrom emp group by gender").ok("SELECT STRING_AGG(`ENAME` ORDER BY `DEPTNO`, `ENAME`) AS `C1`, STRING_AGG(`ENAME`, '; ' ORDER BY `DEPTNO`, `ENAME` DESC) AS `C2`, STRING_AGG(`ENAME`) AS `C3`, STRING_AGG(`ENAME`, ':') AS `C4`, STRING_AGG(`ENAME`, ':') IGNORE NULLS AS `C5`\nFROM `EMP`\nGROUP BY `GENDER`");
    }

    @Test
    void testArrayAgg() {
        String sql = "select\n  array_agg(ename respect nulls order by deptno, ename) as c1,\n  array_concat_agg(ename order by deptno, ename desc) as c2,\n  array_agg(ename) as c3,\n  array_concat_agg(ename) within group (order by ename) as c4\nfrom emp group by gender";
        String expected = "SELECT ARRAY_AGG(`ENAME` ORDER BY `DEPTNO`, `ENAME`) RESPECT NULLS AS `C1`, ARRAY_CONCAT_AGG(`ENAME` ORDER BY `DEPTNO`, `ENAME` DESC) AS `C2`, ARRAY_AGG(`ENAME`) AS `C3`, ARRAY_CONCAT_AGG(`ENAME`) WITHIN GROUP (ORDER BY `ENAME`) AS `C4`\nFROM `EMP`\nGROUP BY `GENDER`";
        this.sql("select\n  array_agg(ename respect nulls order by deptno, ename) as c1,\n  array_concat_agg(ename order by deptno, ename desc) as c2,\n  array_agg(ename) as c3,\n  array_concat_agg(ename) within group (order by ename) as c4\nfrom emp group by gender").ok("SELECT ARRAY_AGG(`ENAME` ORDER BY `DEPTNO`, `ENAME`) RESPECT NULLS AS `C1`, ARRAY_CONCAT_AGG(`ENAME` ORDER BY `DEPTNO`, `ENAME` DESC) AS `C2`, ARRAY_AGG(`ENAME`) AS `C3`, ARRAY_CONCAT_AGG(`ENAME`) WITHIN GROUP (ORDER BY `ENAME`) AS `C4`\nFROM `EMP`\nGROUP BY `GENDER`");
    }

    @Test
    void testGroupConcat() {
        String sql = "select\n  group_concat(ename order by deptno, ename desc) as c2,\n  group_concat(ename) as c3,\n  group_concat(ename order by deptno, ename desc separator ',') as c4\nfrom emp group by gender";
        String expected = "SELECT GROUP_CONCAT(`ENAME` ORDER BY `DEPTNO`, `ENAME` DESC) AS `C2`, GROUP_CONCAT(`ENAME`) AS `C3`, GROUP_CONCAT(`ENAME` ORDER BY `DEPTNO`, `ENAME` DESC SEPARATOR ',') AS `C4`\nFROM `EMP`\nGROUP BY `GENDER`";
        this.sql("select\n  group_concat(ename order by deptno, ename desc) as c2,\n  group_concat(ename) as c3,\n  group_concat(ename order by deptno, ename desc separator ',') as c4\nfrom emp group by gender").ok("SELECT GROUP_CONCAT(`ENAME` ORDER BY `DEPTNO`, `ENAME` DESC) AS `C2`, GROUP_CONCAT(`ENAME`) AS `C3`, GROUP_CONCAT(`ENAME` ORDER BY `DEPTNO`, `ENAME` DESC SEPARATOR ',') AS `C4`\nFROM `EMP`\nGROUP BY `GENDER`");
    }

    @Test
    void testWithinDistinct() {
        String sql = "select col1,\n sum(col2) within distinct (col3 + col4, col5)\nfrom t\norder by col1 limit 10";
        String expected = "SELECT `COL1`, (SUM(`COL2`) WITHIN DISTINCT ((`COL3` + `COL4`), `COL5`))\nFROM `T`\nORDER BY `COL1`\nFETCH NEXT 10 ROWS ONLY";
        this.sql("select col1,\n sum(col2) within distinct (col3 + col4, col5)\nfrom t\norder by col1 limit 10").ok("SELECT `COL1`, (SUM(`COL2`) WITHIN DISTINCT ((`COL3` + `COL4`), `COL5`))\nFROM `T`\nORDER BY `COL1`\nFETCH NEXT 10 ROWS ONLY");
    }

    @Test
    void testWithinDistinct2() {
        String sql = "select col1,\n sum(col2) within distinct (col3 + col4, col5)\n   within group (order by col6 desc)\n   filter (where col7 < col8) as sum2\nfrom t\ngroup by col9";
        String expected = "SELECT `COL1`, (SUM(`COL2`) WITHIN DISTINCT ((`COL3` + `COL4`), `COL5`)) WITHIN GROUP (ORDER BY `COL6` DESC) FILTER (WHERE (`COL7` < `COL8`)) AS `SUM2`\nFROM `T`\nGROUP BY `COL9`";
        this.sql("select col1,\n sum(col2) within distinct (col3 + col4, col5)\n   within group (order by col6 desc)\n   filter (where col7 < col8) as sum2\nfrom t\ngroup by col9").ok("SELECT `COL1`, (SUM(`COL2`) WITHIN DISTINCT ((`COL3` + `COL4`), `COL5`)) WITHIN GROUP (ORDER BY `COL6` DESC) FILTER (WHERE (`COL7` < `COL8`)) AS `SUM2`\nFROM `T`\nGROUP BY `COL9`");
    }

    @Test
    void testMeasure() {
        String sql = "select deptno,\n  job as myJob,\n  sum(comm) / sum(sal) as measure commRatio\nfrom emp";
        String expected = "SELECT `DEPTNO`, `JOB` AS `MYJOB`, (SUM(`COMM`) / SUM(`SAL`)) AS MEASURE `COMMRATIO`\nFROM `EMP`";
        this.sql("select deptno,\n  job as myJob,\n  sum(comm) / sum(sal) as measure commRatio\nfrom emp").ok("SELECT `DEPTNO`, `JOB` AS `MYJOB`, (SUM(`COMM`) / SUM(`SAL`)) AS MEASURE `COMMRATIO`\nFROM `EMP`");
    }

    @Test
    void testJsonValueExpressionOperator() {
        this.expr("foo format json").ok("`FOO` FORMAT JSON");
        this.expr("foo format json encoding utf8").ok("`FOO` FORMAT JSON");
        this.expr("foo format json encoding utf16").ok("`FOO` FORMAT JSON");
        this.expr("foo format json encoding utf32").ok("`FOO` FORMAT JSON");
        this.expr("null format json").ok("NULL FORMAT JSON");
        this.sql("select foo format from tab").ok("SELECT `FOO` AS `FORMAT`\nFROM `TAB`");
        this.sql("select foo format json encoding from tab").ok("SELECT `FOO` FORMAT JSON AS `ENCODING`\nFROM `TAB`");
    }

    @Test
    void testJsonExists() {
        this.expr("json_exists('{\"foo\": \"bar\"}', 'lax $.foo')").ok("JSON_EXISTS('{\"foo\": \"bar\"}', 'lax $.foo')");
        this.expr("json_exists('{\"foo\": \"bar\"}', 'lax $.foo' error on error)").ok("JSON_EXISTS('{\"foo\": \"bar\"}', 'lax $.foo' ERROR ON ERROR)");
    }

    @Test
    void testJsonValue() {
        this.expr("json_value('{\"foo\": \"100\"}', 'lax $.foo' returning integer)").ok("JSON_VALUE('{\"foo\": \"100\"}', 'lax $.foo' RETURNING INTEGER)");
        this.expr("json_value('{\"foo\": \"100\"}', 'lax $.foo' returning integer default 10 on empty error on error)").ok("JSON_VALUE('{\"foo\": \"100\"}', 'lax $.foo' RETURNING INTEGER DEFAULT 10 ON EMPTY ERROR ON ERROR)");
    }

    @Test
    void testJsonQuery() {
        this.expr("json_query('{\"foo\": \"bar\"}', 'lax $' WITHOUT ARRAY WRAPPER)").ok("JSON_QUERY('{\"foo\": \"bar\"}', 'lax $' WITHOUT ARRAY WRAPPER NULL ON EMPTY NULL ON ERROR)");
        this.expr("json_query('{\"foo\": \"bar\"}', 'lax $' WITH WRAPPER)").ok("JSON_QUERY('{\"foo\": \"bar\"}', 'lax $' WITH UNCONDITIONAL ARRAY WRAPPER NULL ON EMPTY NULL ON ERROR)");
        this.expr("json_query('{\"foo\": \"bar\"}', 'lax $' WITH UNCONDITIONAL WRAPPER)").ok("JSON_QUERY('{\"foo\": \"bar\"}', 'lax $' WITH UNCONDITIONAL ARRAY WRAPPER NULL ON EMPTY NULL ON ERROR)");
        this.expr("json_query('{\"foo\": \"bar\"}', 'lax $' WITH CONDITIONAL WRAPPER)").ok("JSON_QUERY('{\"foo\": \"bar\"}', 'lax $' WITH CONDITIONAL ARRAY WRAPPER NULL ON EMPTY NULL ON ERROR)");
        this.expr("json_query('{\"foo\": \"bar\"}', 'lax $' NULL ON EMPTY)").ok("JSON_QUERY('{\"foo\": \"bar\"}', 'lax $' WITHOUT ARRAY WRAPPER NULL ON EMPTY NULL ON ERROR)");
        this.expr("json_query('{\"foo\": \"bar\"}', 'lax $' ERROR ON EMPTY)").ok("JSON_QUERY('{\"foo\": \"bar\"}', 'lax $' WITHOUT ARRAY WRAPPER ERROR ON EMPTY NULL ON ERROR)");
        this.expr("json_query('{\"foo\": \"bar\"}', 'lax $' EMPTY ARRAY ON EMPTY)").ok("JSON_QUERY('{\"foo\": \"bar\"}', 'lax $' WITHOUT ARRAY WRAPPER EMPTY ARRAY ON EMPTY NULL ON ERROR)");
        this.expr("json_query('{\"foo\": \"bar\"}', 'lax $' EMPTY OBJECT ON EMPTY)").ok("JSON_QUERY('{\"foo\": \"bar\"}', 'lax $' WITHOUT ARRAY WRAPPER EMPTY OBJECT ON EMPTY NULL ON ERROR)");
        this.expr("json_query('{\"foo\": \"bar\"}', 'lax $' NULL ON ERROR)").ok("JSON_QUERY('{\"foo\": \"bar\"}', 'lax $' WITHOUT ARRAY WRAPPER NULL ON EMPTY NULL ON ERROR)");
        this.expr("json_query('{\"foo\": \"bar\"}', 'lax $' ERROR ON ERROR)").ok("JSON_QUERY('{\"foo\": \"bar\"}', 'lax $' WITHOUT ARRAY WRAPPER NULL ON EMPTY ERROR ON ERROR)");
        this.expr("json_query('{\"foo\": \"bar\"}', 'lax $' EMPTY ARRAY ON ERROR)").ok("JSON_QUERY('{\"foo\": \"bar\"}', 'lax $' WITHOUT ARRAY WRAPPER NULL ON EMPTY EMPTY ARRAY ON ERROR)");
        this.expr("json_query('{\"foo\": \"bar\"}', 'lax $' EMPTY OBJECT ON ERROR)").ok("JSON_QUERY('{\"foo\": \"bar\"}', 'lax $' WITHOUT ARRAY WRAPPER NULL ON EMPTY EMPTY OBJECT ON ERROR)");
        this.expr("json_query('{\"foo\": \"bar\"}', 'lax $' EMPTY ARRAY ON EMPTY EMPTY OBJECT ON ERROR)").ok("JSON_QUERY('{\"foo\": \"bar\"}', 'lax $' WITHOUT ARRAY WRAPPER EMPTY ARRAY ON EMPTY EMPTY OBJECT ON ERROR)");
        this.expr("json_query('{\"foo\": \"bar\"}', 'lax $' RETURNING VARCHAR ARRAY WITHOUT ARRAY WRAPPER)").ok("JSON_QUERY('{\"foo\": \"bar\"}', 'lax $' RETURNING VARCHAR ARRAY WITHOUT ARRAY WRAPPER NULL ON EMPTY NULL ON ERROR)");
    }

    @Test
    void testJsonObject() {
        this.expr("json_object('foo': 'bar')").ok("JSON_OBJECT(KEY 'foo' VALUE 'bar' NULL ON NULL)");
        this.expr("json_object('foo': 'bar', 'foo2': 'bar2')").ok("JSON_OBJECT(KEY 'foo' VALUE 'bar', KEY 'foo2' VALUE 'bar2' NULL ON NULL)");
        this.expr("json_object('foo' value 'bar')").ok("JSON_OBJECT(KEY 'foo' VALUE 'bar' NULL ON NULL)");
        this.expr("json_object(key 'foo' value 'bar')").ok("JSON_OBJECT(KEY 'foo' VALUE 'bar' NULL ON NULL)");
        this.expr("json_object('foo': null)").ok("JSON_OBJECT(KEY 'foo' VALUE NULL NULL ON NULL)");
        this.expr("json_object('foo': null absent on null)").ok("JSON_OBJECT(KEY 'foo' VALUE NULL ABSENT ON NULL)");
        this.expr("json_object('foo': json_object('foo': 'bar') format json)").ok("JSON_OBJECT(KEY 'foo' VALUE JSON_OBJECT(KEY 'foo' VALUE 'bar' NULL ON NULL) FORMAT JSON NULL ON NULL)");
        this.expr("json_object('foo', 'bar')").ok("JSON_OBJECT(KEY 'foo' VALUE 'bar' NULL ON NULL)");
        this.expr("json_object('foo', 'bar', 'baz', 'qux')").ok("JSON_OBJECT(KEY 'foo' VALUE 'bar', KEY 'baz' VALUE 'qux' NULL ON NULL)");
        this.expr("json_object('foo', json_object('bar': 'baz') format json)").ok("JSON_OBJECT(KEY 'foo' VALUE JSON_OBJECT(KEY 'bar' VALUE 'baz' NULL ON NULL) FORMAT JSON NULL ON NULL)");
        this.expr("json_object('foo', 'bar', 'baz'^)^").fails("(?s)Encountered \"\\)\".*Was expecting.*");
    }

    @Test
    void testJsonType() {
        this.expr("json_type('11.56')").ok("JSON_TYPE('11.56')");
        this.expr("json_type('{}')").ok("JSON_TYPE('{}')");
        this.expr("json_type(null)").ok("JSON_TYPE(NULL)");
        this.expr("json_type('[\"foo\",null]')").ok("JSON_TYPE('[\"foo\",null]')");
        this.expr("json_type('{\"foo\": \"100\"}')").ok("JSON_TYPE('{\"foo\": \"100\"}')");
    }

    @Test
    void testJsonDepth() {
        this.expr("json_depth('11.56')").ok("JSON_DEPTH('11.56')");
        this.expr("json_depth('{}')").ok("JSON_DEPTH('{}')");
        this.expr("json_depth(null)").ok("JSON_DEPTH(NULL)");
        this.expr("json_depth('[\"foo\",null]')").ok("JSON_DEPTH('[\"foo\",null]')");
        this.expr("json_depth('{\"foo\": \"100\"}')").ok("JSON_DEPTH('{\"foo\": \"100\"}')");
    }

    @Test
    void testJsonLength() {
        this.expr("json_length('{\"foo\": \"bar\"}')").ok("JSON_LENGTH('{\"foo\": \"bar\"}')");
        this.expr("json_length('{\"foo\": \"bar\"}', 'lax $')").ok("JSON_LENGTH('{\"foo\": \"bar\"}', 'lax $')");
        this.expr("json_length('{\"foo\": \"bar\"}', 'strict $')").ok("JSON_LENGTH('{\"foo\": \"bar\"}', 'strict $')");
        this.expr("json_length('{\"foo\": \"bar\"}', 'invalid $')").ok("JSON_LENGTH('{\"foo\": \"bar\"}', 'invalid $')");
    }

    @Test
    void testJsonKeys() {
        this.expr("json_keys('{\"foo\": \"bar\"}', 'lax $')").ok("JSON_KEYS('{\"foo\": \"bar\"}', 'lax $')");
        this.expr("json_keys('{\"foo\": \"bar\"}', 'strict $')").ok("JSON_KEYS('{\"foo\": \"bar\"}', 'strict $')");
        this.expr("json_keys('{\"foo\": \"bar\"}', 'invalid $')").ok("JSON_KEYS('{\"foo\": \"bar\"}', 'invalid $')");
    }

    @Test
    void testJsonRemove() {
        this.expr("json_remove('[\"a\", [\"b\", \"c\"], \"d\"]', '$')").ok("JSON_REMOVE('[\"a\", [\"b\", \"c\"], \"d\"]', '$')");
        this.expr("json_remove('[\"a\", [\"b\", \"c\"], \"d\"]', '$[1]', '$[0]')").ok("JSON_REMOVE('[\"a\", [\"b\", \"c\"], \"d\"]', '$[1]', '$[0]')");
    }

    @Test
    void testJsonObjectAgg() {
        this.expr("json_objectagg(k_column: v_column)").ok("JSON_OBJECTAGG(KEY `K_COLUMN` VALUE `V_COLUMN` NULL ON NULL)");
        this.expr("json_objectagg(k_column value v_column)").ok("JSON_OBJECTAGG(KEY `K_COLUMN` VALUE `V_COLUMN` NULL ON NULL)");
        this.expr("json_objectagg(key k_column value v_column)").ok("JSON_OBJECTAGG(KEY `K_COLUMN` VALUE `V_COLUMN` NULL ON NULL)");
        this.expr("json_objectagg(k_column: null)").ok("JSON_OBJECTAGG(KEY `K_COLUMN` VALUE NULL NULL ON NULL)");
        this.expr("json_objectagg(k_column: null absent on null)").ok("JSON_OBJECTAGG(KEY `K_COLUMN` VALUE NULL ABSENT ON NULL)");
        this.expr("json_objectagg(k_column: json_object(k_column: v_column) format json)").ok("JSON_OBJECTAGG(KEY `K_COLUMN` VALUE JSON_OBJECT(KEY `K_COLUMN` VALUE `V_COLUMN` NULL ON NULL) FORMAT JSON NULL ON NULL)");
    }

    @Test
    void testEmptyJsonArray() {
        this.expr("json_array()").ok("JSON_ARRAY()");
    }

    @Test
    void testJsonArray() {
        this.expr("json_array('foo')").ok("JSON_ARRAY('foo' ABSENT ON NULL)");
        this.expr("json_array(null)").ok("JSON_ARRAY(NULL ABSENT ON NULL)");
        this.expr("json_array(null null on null)").ok("JSON_ARRAY(NULL NULL ON NULL)");
        this.expr("json_array(json_array('foo', 'bar') format json)").ok("JSON_ARRAY(JSON_ARRAY('foo', 'bar' ABSENT ON NULL) FORMAT JSON ABSENT ON NULL)");
    }

    @Test
    void testJsonPretty() {
        this.expr("json_pretty('foo')").ok("JSON_PRETTY('foo')");
        this.expr("json_pretty(null)").ok("JSON_PRETTY(NULL)");
    }

    @Test
    void testJsonStorageSize() {
        this.expr("json_storage_size('foo')").ok("JSON_STORAGE_SIZE('foo')");
        this.expr("json_storage_size(null)").ok("JSON_STORAGE_SIZE(NULL)");
    }

    @Test
    void testJsonArrayAgg1() {
        this.expr("json_arrayagg(\"column\")").ok("JSON_ARRAYAGG(`column` ABSENT ON NULL)");
        this.expr("json_arrayagg(\"column\" null on null)").ok("JSON_ARRAYAGG(`column` NULL ON NULL)");
        this.expr("json_arrayagg(json_array(\"column\") format json)").ok("JSON_ARRAYAGG(JSON_ARRAY(`column` ABSENT ON NULL) FORMAT JSON ABSENT ON NULL)");
    }

    @Test
    void testJsonArrayAgg2() {
        this.expr("json_arrayagg(\"column\" order by \"column\")").ok("JSON_ARRAYAGG(`column` ABSENT ON NULL) WITHIN GROUP (ORDER BY `column`)");
        this.expr("json_arrayagg(\"column\") within group (order by \"column\")").ok("JSON_ARRAYAGG(`column` ABSENT ON NULL) WITHIN GROUP (ORDER BY `column`)");
        this.sql("^json_arrayagg(\"column\" order by \"column\") within group (order by \"column\")^").fails("(?s).*Including both WITHIN GROUP\\(\\.\\.\\.\\) and inside ORDER BY in a single JSON_ARRAYAGG call is not allowed.*");
    }

    @Test
    void testJsonPredicate() {
        this.expr("'{}' is json").ok("('{}' IS JSON VALUE)");
        this.expr("'{}' is json value").ok("('{}' IS JSON VALUE)");
        this.expr("'{}' is json object").ok("('{}' IS JSON OBJECT)");
        this.expr("'[]' is json array").ok("('[]' IS JSON ARRAY)");
        this.expr("'100' is json scalar").ok("('100' IS JSON SCALAR)");
        this.expr("'{}' is not json").ok("('{}' IS NOT JSON VALUE)");
        this.expr("'{}' is not json value").ok("('{}' IS NOT JSON VALUE)");
        this.expr("'{}' is not json object").ok("('{}' IS NOT JSON OBJECT)");
        this.expr("'[]' is not json array").ok("('[]' IS NOT JSON ARRAY)");
        this.expr("'100' is not json scalar").ok("('100' IS NOT JSON SCALAR)");
    }

    @Test
    void testParseWithReader() throws Exception {
        String query = "select * from dual";
        SqlParser sqlParserReader = SqlParserTest.sqlParser(new StringReader(query), b -> b);
        SqlNode node1 = sqlParserReader.parseQuery();
        SqlNode node2 = this.sql(query).node();
        MatcherAssert.assertThat((Object)node1, (Matcher)Matchers.hasToString((String)node2.toString()));
    }

    @Test
    void testConfigureFromDialect() {
        this.sql("select unquotedColumn from \"double\"\"QuotedTable\"").withDialect(CALCITE).ok("SELECT \"UNQUOTEDCOLUMN\"\nFROM \"double\"\"QuotedTable\"");
        this.sql("select unquotedColumn from `double``QuotedTable`").withDialect(MYSQL).ok("SELECT `unquotedColumn`\nFROM `double``QuotedTable`");
        this.sql("select unquotedColumn from \"double\"\"QuotedTable\"").withDialect(ORACLE).ok("SELECT \"UNQUOTEDCOLUMN\"\nFROM \"double\"\"QuotedTable\"");
        this.sql("select unquotedColumn from \"double\"\"QuotedTable\"").withDialect(POSTGRESQL).ok("SELECT \"unquotedcolumn\"\nFROM \"double\"\"QuotedTable\"");
        this.sql("select unquotedColumn from \"double\"\"QuotedTable\"").withDialect(REDSHIFT).ok("SELECT \"unquotedcolumn\"\nFROM \"double\"\"quotedtable\"");
        this.sql("select unquotedColumn from `double\\`QuotedTable`").withDialect(BIG_QUERY).ok("SELECT unquotedColumn\nFROM `double\\`QuotedTable`");
    }

    @Test
    void testSplitIdentifier() {
        String sql = "select *\nfrom `bigquery-public-data.samples.natality`";
        String sql2 = "select *\nfrom `bigquery-public-data`.`samples`.`natality`";
        String expectedSplit = "SELECT *\nFROM `bigquery-public-data`.samples.natality";
        String expectedNoSplit = "SELECT *\nFROM `bigquery-public-data.samples.natality`";
        String expectedSplitMysql = "SELECT *\nFROM `bigquery-public-data`.`samples`.`natality`";
        this.sql("select *\nfrom `bigquery-public-data.samples.natality`").withDialect(BIG_QUERY).ok("SELECT *\nFROM `bigquery-public-data`.samples.natality");
        this.sql("select *\nfrom `bigquery-public-data.samples.natality`").withDialect(MYSQL).ok("SELECT *\nFROM `bigquery-public-data.samples.natality`");
        this.sql("select *\nfrom `bigquery-public-data`.`samples`.`natality`").withDialect(BIG_QUERY).ok("SELECT *\nFROM `bigquery-public-data`.samples.natality");
        this.sql("select *\nfrom `bigquery-public-data`.`samples`.`natality`").withDialect(MYSQL).ok("SELECT *\nFROM `bigquery-public-data`.`samples`.`natality`");
    }

    @Test
    void testParenthesizedSubQueries() {
        String expected = "SELECT *\nFROM (SELECT *\nFROM `TAB`) AS `X`";
        String sql1 = "SELECT * FROM (((SELECT * FROM tab))) X";
        this.sql("SELECT * FROM (((SELECT * FROM tab))) X").ok("SELECT *\nFROM (SELECT *\nFROM `TAB`) AS `X`");
        String sql2 = "SELECT * FROM ((((((((((((SELECT * FROM tab)))))))))))) X";
        this.sql("SELECT * FROM ((((((((((((SELECT * FROM tab)))))))))))) X").ok("SELECT *\nFROM (SELECT *\nFROM `TAB`) AS `X`");
    }

    @Test
    void testQueryHint() {
        String sql1 = "select /*+ properties(k1='v1', k2='v2', 'a.b.c'='v3'), no_hash_join, Index(idx1, idx2), repartition(3) */ empno, ename, deptno from emps";
        String expected1 = "SELECT\n/*+ `PROPERTIES`(`K1` = 'v1', `K2` = 'v2', 'a.b.c' = 'v3'), `NO_HASH_JOIN`, `INDEX`(`IDX1`, `IDX2`), `REPARTITION`(3) */\n`EMPNO`, `ENAME`, `DEPTNO`\nFROM `EMPS`";
        this.sql("select /*+ properties(k1='v1', k2='v2', 'a.b.c'='v3'), no_hash_join, Index(idx1, idx2), repartition(3) */ empno, ename, deptno from emps").ok("SELECT\n/*+ `PROPERTIES`(`K1` = 'v1', `K2` = 'v2', 'a.b.c' = 'v3'), `NO_HASH_JOIN`, `INDEX`(`IDX1`, `IDX2`), `REPARTITION`(3) */\n`EMPNO`, `ENAME`, `DEPTNO`\nFROM `EMPS`");
        String sql2 = "select /*+properties(k1='v1', k2='v2')*/ empno from emps";
        String expected2 = "SELECT\n/*+ `PROPERTIES`(`K1` = 'v1', `K2` = 'v2') */\n`EMPNO`\nFROM `EMPS`";
        this.sql("select /*+properties(k1='v1', k2='v2')*/ empno from emps").ok("SELECT\n/*+ `PROPERTIES`(`K1` = 'v1', `K2` = 'v2') */\n`EMPNO`\nFROM `EMPS`");
        String sql3 = "select /*+ simple_hint */ empno, ename, deptno from emps limit 2";
        String expected3 = "SELECT\n/*+ `SIMPLE_HINT` */\n`EMPNO`, `ENAME`, `DEPTNO`\nFROM `EMPS`\nFETCH NEXT 2 ROWS ONLY";
        this.sql("select /*+ simple_hint */ empno, ename, deptno from emps limit 2").ok("SELECT\n/*+ `SIMPLE_HINT` */\n`EMPNO`, `ENAME`, `DEPTNO`\nFROM `EMPS`\nFETCH NEXT 2 ROWS ONLY");
    }

    @Test
    void testTableHintsInQuery() {
        String hint = "/*+ PROPERTIES(K1 ='v1', K2 ='v2'), INDEX(IDX0, IDX1) */";
        String sql1 = String.format(Locale.ROOT, "select * from t %s", "/*+ PROPERTIES(K1 ='v1', K2 ='v2'), INDEX(IDX0, IDX1) */");
        String expected1 = "SELECT *\nFROM `T`\n/*+ `PROPERTIES`(`K1` = 'v1', `K2` = 'v2'), `INDEX`(`IDX0`, `IDX1`) */";
        this.sql(sql1).ok("SELECT *\nFROM `T`\n/*+ `PROPERTIES`(`K1` = 'v1', `K2` = 'v2'), `INDEX`(`IDX0`, `IDX1`) */");
        String sql2 = String.format(Locale.ROOT, "select * from\n(select * from t %s union all select * from t %s )", "/*+ PROPERTIES(K1 ='v1', K2 ='v2'), INDEX(IDX0, IDX1) */", "/*+ PROPERTIES(K1 ='v1', K2 ='v2'), INDEX(IDX0, IDX1) */");
        String expected2 = "SELECT *\nFROM (SELECT *\nFROM `T`\n/*+ `PROPERTIES`(`K1` = 'v1', `K2` = 'v2'), `INDEX`(`IDX0`, `IDX1`) */\nUNION ALL\nSELECT *\nFROM `T`\n/*+ `PROPERTIES`(`K1` = 'v1', `K2` = 'v2'), `INDEX`(`IDX0`, `IDX1`) */)";
        this.sql(sql2).ok("SELECT *\nFROM (SELECT *\nFROM `T`\n/*+ `PROPERTIES`(`K1` = 'v1', `K2` = 'v2'), `INDEX`(`IDX0`, `IDX1`) */\nUNION ALL\nSELECT *\nFROM `T`\n/*+ `PROPERTIES`(`K1` = 'v1', `K2` = 'v2'), `INDEX`(`IDX0`, `IDX1`) */)");
        String sql3 = String.format(Locale.ROOT, "select * from t %s join t %s", "/*+ PROPERTIES(K1 ='v1', K2 ='v2'), INDEX(IDX0, IDX1) */", "/*+ PROPERTIES(K1 ='v1', K2 ='v2'), INDEX(IDX0, IDX1) */");
        String expected3 = "SELECT *\nFROM `T`\n/*+ `PROPERTIES`(`K1` = 'v1', `K2` = 'v2'), `INDEX`(`IDX0`, `IDX1`) */\nINNER JOIN `T`\n/*+ `PROPERTIES`(`K1` = 'v1', `K2` = 'v2'), `INDEX`(`IDX0`, `IDX1`) */";
        this.sql(sql3).ok("SELECT *\nFROM `T`\n/*+ `PROPERTIES`(`K1` = 'v1', `K2` = 'v2'), `INDEX`(`IDX0`, `IDX1`) */\nINNER JOIN `T`\n/*+ `PROPERTIES`(`K1` = 'v1', `K2` = 'v2'), `INDEX`(`IDX0`, `IDX1`) */");
    }

    @Test
    void testTableHintsInInsert() {
        String sql = "insert into emps\n/*+ PROPERTIES(k1='v1', k2='v2'), INDEX(idx0, idx1) */\nselect * from emps";
        String expected = "INSERT INTO `EMPS`\n/*+ `PROPERTIES`(`K1` = 'v1', `K2` = 'v2'), `INDEX`(`IDX0`, `IDX1`) */\nSELECT *\nFROM `EMPS`";
        this.sql("insert into emps\n/*+ PROPERTIES(k1='v1', k2='v2'), INDEX(idx0, idx1) */\nselect * from emps").ok("INSERT INTO `EMPS`\n/*+ `PROPERTIES`(`K1` = 'v1', `K2` = 'v2'), `INDEX`(`IDX0`, `IDX1`) */\nSELECT *\nFROM `EMPS`");
    }

    @Test
    void testTableHintsInDelete() {
        String sql = "delete from emps\n/*+ properties(k1='v1', k2='v2'), index(idx1, idx2), no_hash_join */\nwhere empno=12";
        String expected = "DELETE FROM `EMPS`\n/*+ `PROPERTIES`(`K1` = 'v1', `K2` = 'v2'), `INDEX`(`IDX1`, `IDX2`), `NO_HASH_JOIN` */\nWHERE (`EMPNO` = 12)";
        this.sql("delete from emps\n/*+ properties(k1='v1', k2='v2'), index(idx1, idx2), no_hash_join */\nwhere empno=12").ok("DELETE FROM `EMPS`\n/*+ `PROPERTIES`(`K1` = 'v1', `K2` = 'v2'), `INDEX`(`IDX1`, `IDX2`), `NO_HASH_JOIN` */\nWHERE (`EMPNO` = 12)");
    }

    @Test
    void testTableHintsInUpdate() {
        String sql = "update emps\n/*+ properties(k1='v1', k2='v2'), index(idx1, idx2), no_hash_join */\nset empno = empno + 1, sal = sal - 1\nwhere empno=12";
        String expected = "UPDATE `EMPS`\n/*+ `PROPERTIES`(`K1` = 'v1', `K2` = 'v2'), `INDEX`(`IDX1`, `IDX2`), `NO_HASH_JOIN` */ SET `EMPNO` = (`EMPNO` + 1), `SAL` = (`SAL` - 1)\nWHERE (`EMPNO` = 12)";
        this.sql("update emps\n/*+ properties(k1='v1', k2='v2'), index(idx1, idx2), no_hash_join */\nset empno = empno + 1, sal = sal - 1\nwhere empno=12").ok("UPDATE `EMPS`\n/*+ `PROPERTIES`(`K1` = 'v1', `K2` = 'v2'), `INDEX`(`IDX1`, `IDX2`), `NO_HASH_JOIN` */ SET `EMPNO` = (`EMPNO` + 1), `SAL` = (`SAL` - 1)\nWHERE (`EMPNO` = 12)");
    }

    @Test
    void testTableHintsInMerge() {
        String sql = "merge into emps\n/*+ properties(k1='v1', k2='v2'), index(idx1, idx2), no_hash_join */ e\nusing tempemps as t\non e.empno = t.empno\nwhen matched then update\nset name = t.name, deptno = t.deptno, salary = t.salary * .1\nwhen not matched then insert (name, dept, salary)\nvalues(t.name, 10, t.salary * .15)";
        String expected = "MERGE INTO `EMPS`\n/*+ `PROPERTIES`(`K1` = 'v1', `K2` = 'v2'), `INDEX`(`IDX1`, `IDX2`), `NO_HASH_JOIN` */ AS `E`\nUSING `TEMPEMPS` AS `T`\nON (`E`.`EMPNO` = `T`.`EMPNO`)\nWHEN MATCHED THEN UPDATE SET `NAME` = `T`.`NAME`, `DEPTNO` = `T`.`DEPTNO`, `SALARY` = (`T`.`SALARY` * 0.1)\nWHEN NOT MATCHED THEN INSERT (`NAME`, `DEPT`, `SALARY`) VALUES (ROW(`T`.`NAME`, 10, (`T`.`SALARY` * 0.15)))";
        this.sql("merge into emps\n/*+ properties(k1='v1', k2='v2'), index(idx1, idx2), no_hash_join */ e\nusing tempemps as t\non e.empno = t.empno\nwhen matched then update\nset name = t.name, deptno = t.deptno, salary = t.salary * .1\nwhen not matched then insert (name, dept, salary)\nvalues(t.name, 10, t.salary * .15)").ok("MERGE INTO `EMPS`\n/*+ `PROPERTIES`(`K1` = 'v1', `K2` = 'v2'), `INDEX`(`IDX1`, `IDX2`), `NO_HASH_JOIN` */ AS `E`\nUSING `TEMPEMPS` AS `T`\nON (`E`.`EMPNO` = `T`.`EMPNO`)\nWHEN MATCHED THEN UPDATE SET `NAME` = `T`.`NAME`, `DEPTNO` = `T`.`DEPTNO`, `SALARY` = (`T`.`SALARY` * 0.1)\nWHEN NOT MATCHED THEN INSERT (`NAME`, `DEPT`, `SALARY`) VALUES (ROW(`T`.`NAME`, 10, (`T`.`SALARY` * 0.15)))");
    }

    @Test
    void testHintThroughShuttle() {
        String sql = "select * from emp /*+ options('key1' = 'val1') */";
        SqlNode sqlNode = this.sql("select * from emp /*+ options('key1' = 'val1') */").node();
        SqlNode shuttled = (SqlNode)sqlNode.accept((SqlVisitor)new SqlShuttle(){

            public SqlNode visit(SqlIdentifier identifier) {
                return identifier.clone(identifier.getParserPosition());
            }
        });
        String expected = "SELECT *\nFROM `EMP`\n/*+ `OPTIONS`('key1' = 'val1') */";
        MatcherAssert.assertThat((Object)Util.toLinux((String)shuttled.toString()), (Matcher)CoreMatchers.is((Object)"SELECT *\nFROM `EMP`\n/*+ `OPTIONS`('key1' = 'val1') */"));
    }

    @Test
    void testInvalidHintFormat() {
        String sql1 = "select /*+ properties(^k1^=123, k2='v2'), no_hash_join() */ empno, ename, deptno from emps";
        this.sql("select /*+ properties(^k1^=123, k2='v2'), no_hash_join() */ empno, ename, deptno from emps").fails("(?s).*Encountered \"k1 = 123\" at .*");
        String sql2 = "select /*+ properties(k1, k2^=^'v2'), no_hash_join */ empno, ename, deptno from emps";
        this.sql("select /*+ properties(k1, k2^=^'v2'), no_hash_join */ empno, ename, deptno from emps").fails("(?s).*Encountered \"=\" at line 1, column 29.\n.*");
        String sql3 = "select /*+ no_hash_join() */ empno, ename, deptno from emps";
        String expected3 = "SELECT\n/*+ `NO_HASH_JOIN` */\n`EMPNO`, `ENAME`, `DEPTNO`\nFROM `EMPS`";
        this.sql("select /*+ no_hash_join() */ empno, ename, deptno from emps").ok("SELECT\n/*+ `NO_HASH_JOIN` */\n`EMPNO`, `ENAME`, `DEPTNO`\nFROM `EMPS`");
        String sql4 = "select /*+ properties(^a^.b.c=123, k2='v2') */empno, ename, deptno from emps";
        this.sql("select /*+ properties(^a^.b.c=123, k2='v2') */empno, ename, deptno from emps").fails("(?s).*Encountered \"a .\" at .*");
    }

    @Test
    protected void testHoist() {
        String sql = "select 1 as x,\n  'ab' || 'c' as y\nfrom emp /* comment with 'quoted string'? */ as e\nwhere deptno < 40\nand hiredate > date '2010-05-06'";
        Hoist.Hoisted hoisted = Hoist.create((Hoist.Config)Hoist.config()).hoist("select 1 as x,\n  'ab' || 'c' as y\nfrom emp /* comment with 'quoted string'? */ as e\nwhere deptno < 40\nand hiredate > date '2010-05-06'");
        String expected = "select ?0 as x,\n  ?1 || ?2 as y\nfrom emp /* comment with 'quoted string'? */ as e\nwhere deptno < ?3\nand hiredate > ?4";
        MatcherAssert.assertThat((Object)hoisted, (Matcher)Matchers.hasToString((String)"select ?0 as x,\n  ?1 || ?2 as y\nfrom emp /* comment with 'quoted string'? */ as e\nwhere deptno < ?3\nand hiredate > ?4"));
        MatcherAssert.assertThat((Object)hoisted.substitute(Hoist::ordinalString), (Matcher)CoreMatchers.is((Object)"select ?0 as x,\n  ?1 || ?2 as y\nfrom emp /* comment with 'quoted string'? */ as e\nwhere deptno < ?3\nand hiredate > ?4"));
        String expected1 = "select 1 as x,\n  ?1 || ?2 as y\nfrom emp /* comment with 'quoted string'? */ as e\nwhere deptno < 40\nand hiredate > date '2010-05-06'";
        MatcherAssert.assertThat((Object)hoisted.substitute(Hoist::ordinalStringIfChar), (Matcher)CoreMatchers.is((Object)"select 1 as x,\n  ?1 || ?2 as y\nfrom emp /* comment with 'quoted string'? */ as e\nwhere deptno < 40\nand hiredate > date '2010-05-06'"));
        String expected2 = "select [0:DECIMAL:1] as x,\n  [1:CHAR:ab] || [2:CHAR:c] as y\nfrom emp /* comment with 'quoted string'? */ as e\nwhere deptno < [3:DECIMAL:40]\nand hiredate > [4:DATE:2010-05-06]";
        MatcherAssert.assertThat((Object)hoisted.substitute(SqlParserTest::varToStr), (Matcher)CoreMatchers.is((Object)"select [0:DECIMAL:1] as x,\n  [1:CHAR:ab] || [2:CHAR:c] as y\nfrom emp /* comment with 'quoted string'? */ as e\nwhere deptno < [3:DECIMAL:40]\nand hiredate > [4:DATE:2010-05-06]"));
    }

    @Test
    public void testLambdaExpression() {
        this.sql("select higher_order_func(1, (x, y) -> (x + y)) from t").ok("SELECT `HIGHER_ORDER_FUNC`(1, (`X`, `Y`) -> (`X` + `Y`))\nFROM `T`");
        this.sql("select higher_order_func(1, (x, y) -> x + char_length(y)) from t").ok("SELECT `HIGHER_ORDER_FUNC`(1, (`X`, `Y`) -> (`X` + CHAR_LENGTH(`Y`)))\nFROM `T`");
        this.sql("select higher_order_func(a -> a + 1, 1) from t").ok("SELECT `HIGHER_ORDER_FUNC`(`A` -> (`A` + 1), 1)\nFROM `T`");
        this.sql("select higher_order_func((a) -> 1, 1) from t").ok("SELECT `HIGHER_ORDER_FUNC`(`A` -> 1, 1)\nFROM `T`");
        this.sql("select higher_order_func(() -> 1 + 1, 1) from t").ok("SELECT `HIGHER_ORDER_FUNC`(() -> (1 + 1), 1)\nFROM `T`");
        String errorMessage1 = "(?s).*Encountered \"\\)\" at .*";
        this.sql("select (^)^ -> 1").fails("(?s).*Encountered \"\\)\" at .*");
        this.sql("select * from t where (^)^ -> a = 1").fails("(?s).*Encountered \"\\)\" at .*");
        String errorMessage2 = "(?s).*Encountered \"->\" at .*";
        this.sql("select (a, b) ^->^ a + b").fails("(?s).*Encountered \"->\" at .*");
        this.sql("select * from t where (a, b) ^->^ a = 1").fails("(?s).*Encountered \"->\" at .*");
        this.sql("select 1 || (a, b) ^->^ a + b").fails("(?s).*Encountered \"->\" at .*");
    }

    protected static String varToStr(Hoist.Variable v) {
        if (v.node instanceof SqlLiteral) {
            SqlLiteral literal = (SqlLiteral)v.node;
            SqlTypeName typeName = literal.getTypeName();
            return "[" + v.ordinal + ":" + (typeName == SqlTypeName.UNKNOWN ? ((SqlUnknownLiteral)literal).tag : typeName.getName()) + ":" + literal.toValue() + "]";
        }
        return "[" + v.ordinal + "]";
    }

    private class Checker {
        final String op;
        final String period;

        Checker(String op, String period) {
            this.op = op;
            this.period = period;
        }

        public void checkExp(String sql, String expected) {
            SqlParserTest.this.expr(sql.replace("$op", this.op).replace("$p", this.period)).ok(expected.replace("$op", this.op.toUpperCase(Locale.ROOT)));
        }

        public void checkExpFails(String sql, String expected) {
            SqlParserTest.this.expr(sql.replace("$op", this.op).replace("$p", this.period)).fails(expected.replace("$op", this.op));
        }
    }

    public static class UnparsingTesterImpl
    extends TesterImpl {
        @Override
        public boolean isUnparserTest() {
            return true;
        }

        static UnaryOperator<SqlWriterConfig> simple() {
            return c -> c.withSelectListItemsOnSeparateLines(false).withUpdateSetListNewline(false).withIndentation(0).withFromFolding(SqlWriterConfig.LineFolding.TALL);
        }

        static SqlWriterConfig simpleWithParens(SqlWriterConfig c) {
            return UnparsingTesterImpl.simple().andThen(UnparsingTesterImpl::withParens).apply(c);
        }

        static SqlWriterConfig simpleWithParensAnsi(SqlWriterConfig c) {
            return UnparsingTesterImpl.withAnsi(UnparsingTesterImpl.simpleWithParens(c));
        }

        static SqlWriterConfig withParens(SqlWriterConfig c) {
            return c.withAlwaysUseParentheses(true);
        }

        static SqlWriterConfig withAnsi(SqlWriterConfig c) {
            return c.withDialect(AnsiSqlDialect.DEFAULT);
        }

        static UnaryOperator<SqlWriterConfig> randomize(Random random) {
            return c -> c.withFoldLength(random.nextInt(5) * 20 + 3).withHavingFolding(UnparsingTesterImpl.nextLineFolding(random)).withWhereFolding(UnparsingTesterImpl.nextLineFolding(random)).withSelectFolding(UnparsingTesterImpl.nextLineFolding(random)).withFromFolding(UnparsingTesterImpl.nextLineFolding(random)).withGroupByFolding(UnparsingTesterImpl.nextLineFolding(random)).withClauseStartsLine(random.nextBoolean()).withClauseEndsLine(random.nextBoolean());
        }

        static String toSqlString(SqlNodeList sqlNodeList, UnaryOperator<SqlWriterConfig> transform) {
            return sqlNodeList.stream().map(node -> node.toSqlString(transform).getSql()).collect(Collectors.joining(";"));
        }

        static SqlWriterConfig.LineFolding nextLineFolding(Random random) {
            return UnparsingTesterImpl.nextEnum(random, SqlWriterConfig.LineFolding.class);
        }

        static <E extends Enum<E>> E nextEnum(Random random, Class<E> enumClass) {
            Enum[] constants = (Enum[])enumClass.getEnumConstants();
            return (E)constants[random.nextInt(constants.length)];
        }

        static void checkList(SqlNodeList sqlNodeList, UnaryOperator<String> converter, List<String> expected) {
            MatcherAssert.assertThat((Object)sqlNodeList, (Matcher)Matchers.hasSize((int)expected.size()));
            for (int i = 0; i < sqlNodeList.size(); ++i) {
                SqlNode sqlNode = sqlNodeList.get(i);
                String actual = sqlNode.toSqlString(UnparsingTesterImpl::simpleWithParensAnsi).getSql();
                MatcherAssert.assertThat(converter.apply(actual), (Matcher)CoreMatchers.is((Object)expected.get(i)));
            }
        }

        @Override
        public void checkList(SqlTestFactory factory, StringAndPos sap, @Nullable SqlDialect dialect, UnaryOperator<String> converter, List<String> expected) {
            SqlNodeList sqlNodeList = this.parseStmtsAndHandleEx(factory, sap.sql);
            UnparsingTesterImpl.checkList(sqlNodeList, converter, expected);
            String sql1 = UnparsingTesterImpl.toSqlString(sqlNodeList, UnparsingTesterImpl.simple());
            SqlNodeList sqlNodeList2 = this.parseStmtsAndHandleEx(factory.withParserConfig(c -> c.withQuoting(Quoting.DOUBLE_QUOTE)), sql1);
            String sql2 = UnparsingTesterImpl.toSqlString(sqlNodeList2, UnparsingTesterImpl.simple());
            MatcherAssert.assertThat((Object)sql2, (Matcher)CoreMatchers.is((Object)sql1));
            UnparsingTesterImpl.checkList(sqlNodeList2, converter, expected);
            Random random = new Random();
            String sql3 = UnparsingTesterImpl.toSqlString(sqlNodeList, UnparsingTesterImpl.randomize(random));
            MatcherAssert.assertThat((Object)sql3, (Matcher)CoreMatchers.notNullValue());
        }

        @Override
        public void check(SqlTestFactory factory, StringAndPos sap, @Nullable SqlDialect dialect, UnaryOperator<String> converter, String expected, Consumer<SqlParser> parserChecker) {
            SqlNode sqlNode = this.parseStmtAndHandleEx(factory, sap.sql, parserChecker);
            SqlDialect dialect2 = (SqlDialect)Util.first((Object)dialect, (Object)AnsiSqlDialect.DEFAULT);
            UnaryOperator writerTransform = c -> UnparsingTesterImpl.simpleWithParens(c).withDialect(dialect2);
            String actual = sqlNode.toSqlString(writerTransform).getSql();
            MatcherAssert.assertThat(converter.apply(actual), (Matcher)CoreMatchers.is((Object)expected));
            String sql1 = sqlNode.toSqlString(UnparsingTesterImpl.simple()).getSql();
            SqlTestFactory factory2 = factory.withParserConfig(c -> c.withQuoting(Quoting.DOUBLE_QUOTE));
            SqlNode sqlNode2 = this.parseStmtAndHandleEx(factory2, sql1, parser -> {});
            String sql2 = sqlNode2.toSqlString(UnparsingTesterImpl.simple()).getSql();
            MatcherAssert.assertThat((Object)sql2, (Matcher)CoreMatchers.is((Object)sql1));
            String actual2 = sqlNode.toSqlString(writerTransform).getSql();
            MatcherAssert.assertThat(converter.apply(actual2), (Matcher)CoreMatchers.is((Object)expected));
            Random random = new Random();
            String sql3 = sqlNode.toSqlString(UnparsingTesterImpl.randomize(random)).getSql();
            MatcherAssert.assertThat((Object)sql3, (Matcher)CoreMatchers.notNullValue());
            SqlNode sqlNode4 = this.parseStmtAndHandleEx(factory2, sql1, parser -> {});
            String sql4 = sqlNode4.toSqlString(UnparsingTesterImpl.simple()).getSql();
            MatcherAssert.assertThat((Object)sql4, (Matcher)CoreMatchers.is((Object)sql1));
        }

        @Override
        public void checkExp(SqlTestFactory factory, StringAndPos sap, UnaryOperator<String> converter, String expected, Consumer<SqlParser> parserChecker) {
            SqlNode sqlNode = this.parseExpressionAndHandleEx(factory, sap.sql, parserChecker);
            UnaryOperator writerTransform = c -> UnparsingTesterImpl.simpleWithParens(c).withDialect(AnsiSqlDialect.DEFAULT);
            String actual = sqlNode.toSqlString(writerTransform).getSql();
            MatcherAssert.assertThat(converter.apply(actual), (Matcher)CoreMatchers.is((Object)expected));
            String sql1 = sqlNode.toSqlString(UnaryOperator.identity()).getSql();
            Consumer<SqlParser> nullChecker = parser -> {};
            SqlTestFactory dqFactory = factory.withParserConfig(c -> c.withQuoting(Quoting.DOUBLE_QUOTE));
            SqlNode sqlNode2 = this.parseExpressionAndHandleEx(dqFactory, sql1, nullChecker);
            String sql2 = sqlNode2.toSqlString(UnaryOperator.identity()).getSql();
            MatcherAssert.assertThat((Object)sql2, (Matcher)CoreMatchers.is((Object)sql1));
            String actual2 = sqlNode2.toSqlString(null, true).getSql();
            MatcherAssert.assertThat(converter.apply(actual2), (Matcher)CoreMatchers.is((Object)expected));
        }

        @Override
        public void checkFails(SqlTestFactory factory, StringAndPos sap, boolean list, String expectedMsgPattern) {
        }

        @Override
        public void checkExpFails(SqlTestFactory factory, StringAndPos sap, String expectedMsgPattern) {
        }
    }

    protected static class TesterImpl
    implements Tester {
        static final TesterImpl DEFAULT = new TesterImpl();

        protected TesterImpl() {
        }

        private static void check0(SqlNode sqlNode, SqlWriterConfig sqlWriterConfig, UnaryOperator<String> converter, String expected) {
            String actual = sqlNode.toSqlString(c -> sqlWriterConfig).getSql();
            TestUtil.assertEqualsVerbose(expected, (String)converter.apply(actual));
        }

        @Override
        public void checkList(SqlTestFactory factory, StringAndPos sap, @Nullable SqlDialect dialect, UnaryOperator<String> converter, List<String> expected) {
            SqlNodeList sqlNodeList = this.parseStmtsAndHandleEx(factory, sap.sql);
            MatcherAssert.assertThat((Object)sqlNodeList, (Matcher)Matchers.hasSize((int)expected.size()));
            SqlWriterConfig sqlWriterConfig = SQL_WRITER_CONFIG.withDialect((SqlDialect)Util.first((Object)dialect, (Object)AnsiSqlDialect.DEFAULT));
            for (int i = 0; i < sqlNodeList.size(); ++i) {
                SqlNode sqlNode = sqlNodeList.get(i);
                TesterImpl.check0(sqlNode, sqlWriterConfig, converter, expected.get(i));
            }
        }

        @Override
        public void check(SqlTestFactory factory, StringAndPos sap, @Nullable SqlDialect dialect, UnaryOperator<String> converter, String expected, Consumer<SqlParser> parserChecker) {
            SqlNode sqlNode = this.parseStmtAndHandleEx(factory, sap.sql, parserChecker);
            SqlWriterConfig sqlWriterConfig = SQL_WRITER_CONFIG.withDialect((SqlDialect)Util.first((Object)dialect, (Object)AnsiSqlDialect.DEFAULT));
            TesterImpl.check0(sqlNode, sqlWriterConfig, converter, expected);
        }

        protected SqlNode parseStmtAndHandleEx(SqlTestFactory factory, String sql, Consumer<SqlParser> parserChecker) {
            SqlNode sqlNode;
            SqlParser parser = factory.createParser(sql);
            try {
                sqlNode = parser.parseStmt();
                parserChecker.accept(parser);
            }
            catch (SqlParseException e) {
                throw new RuntimeException("Error while parsing SQL: " + sql, e);
            }
            return sqlNode;
        }

        protected SqlNodeList parseStmtsAndHandleEx(SqlTestFactory factory, String sql) {
            SqlNodeList sqlNodeList;
            SqlParser parser = factory.createParser(sql);
            try {
                sqlNodeList = parser.parseStmtList();
            }
            catch (SqlParseException e) {
                throw new RuntimeException("Error while parsing SQL: " + sql, e);
            }
            return sqlNodeList;
        }

        @Override
        public void checkExp(SqlTestFactory factory, StringAndPos sap, UnaryOperator<String> converter, String expected, Consumer<SqlParser> parserChecker) {
            SqlNode sqlNode = this.parseExpressionAndHandleEx(factory, sap.sql, parserChecker);
            String actual = sqlNode.toSqlString(null, true).getSql();
            TestUtil.assertEqualsVerbose(expected, (String)converter.apply(actual));
        }

        protected SqlNode parseExpressionAndHandleEx(SqlTestFactory factory, String sql, Consumer<SqlParser> parserChecker) {
            SqlNode sqlNode;
            try {
                SqlParser parser = factory.createParser(sql);
                sqlNode = parser.parseExpression();
                parserChecker.accept(parser);
            }
            catch (SqlParseException e) {
                throw new RuntimeException("Error while parsing expression: " + sql, e);
            }
            return sqlNode;
        }

        @Override
        public void checkFails(SqlTestFactory factory, StringAndPos sap, boolean list, String expectedMsgPattern) {
            Throwable thrown = null;
            try {
                SqlParser parser = factory.createParser(sap.sql);
                Object sqlNode = list ? parser.parseStmtList() : parser.parseStmt();
                Util.discard((Object)sqlNode);
            }
            catch (Throwable ex) {
                thrown = ex;
            }
            this.checkEx(expectedMsgPattern, sap, thrown);
        }

        @Override
        public void checkNode(SqlTestFactory factory, StringAndPos sap, Matcher<SqlNode> matcher) {
            try {
                SqlParser parser = factory.createParser(sap.sql);
                SqlNode sqlNode = parser.parseStmt();
                MatcherAssert.assertThat((Object)sqlNode, matcher);
            }
            catch (SqlParseException e) {
                throw TestUtil.rethrow(e);
            }
        }

        @Override
        public void checkExpFails(SqlTestFactory factory, StringAndPos sap, String expectedMsgPattern) {
            Throwable thrown = null;
            try {
                SqlParser parser = factory.createParser(sap.sql);
                SqlNode sqlNode = parser.parseExpression();
                Util.discard((Object)sqlNode);
            }
            catch (Throwable ex) {
                thrown = ex;
            }
            this.checkEx(expectedMsgPattern, sap, thrown);
        }

        protected void checkEx(String expectedMsgPattern, StringAndPos sap, @Nullable Throwable thrown) {
            SqlTests.checkEx(thrown, expectedMsgPattern, sap, SqlTests.Stage.VALIDATE);
        }
    }

    protected static interface Tester {
        public void checkList(SqlTestFactory var1, StringAndPos var2, @Nullable SqlDialect var3, UnaryOperator<String> var4, List<String> var5);

        public void check(SqlTestFactory var1, StringAndPos var2, @Nullable SqlDialect var3, UnaryOperator<String> var4, String var5, Consumer<SqlParser> var6);

        public void checkExp(SqlTestFactory var1, StringAndPos var2, UnaryOperator<String> var3, String var4, Consumer<SqlParser> var5);

        public void checkFails(SqlTestFactory var1, StringAndPos var2, boolean var3, String var4);

        public void checkExpFails(SqlTestFactory var1, StringAndPos var2, String var3);

        public void checkNode(SqlTestFactory var1, StringAndPos var2, Matcher<SqlNode> var3);

        default public boolean isUnparserTest() {
            return false;
        }
    }
}

