/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.test;

import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.apache.calcite.avatica.ConnectionProperty;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.config.Lex;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.fun.SqlLibrary;
import org.apache.calcite.sql.fun.SqlLibraryOperatorTableFactory;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.StringAndPos;
import org.apache.calcite.sql.test.AbstractSqlTester;
import org.apache.calcite.sql.test.ResultCheckers;
import org.apache.calcite.sql.test.SqlTestFactory;
import org.apache.calcite.sql.test.SqlTester;
import org.apache.calcite.sql.test.SqlTests;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.ConnectionFactories;
import org.apache.calcite.test.ConnectionFactory;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface SqlOperatorFixture
extends AutoCloseable {
    public static final String INVALID_CHAR_MESSAGE = "(?s).*";
    public static final String OUT_OF_RANGE_MESSAGE = ".* out of range.*";
    public static final String WRONG_FORMAT_MESSAGE = "Number has wrong format.*";
    public static final String DIVISION_BY_ZERO_MESSAGE = "(?s).*";
    public static final String STRING_TRUNC_MESSAGE = "(?s).*";
    public static final String BAD_DATETIME_MESSAGE = "(?s).*";
    public static final String LITERAL_OUT_OF_RANGE_MESSAGE = "(?s).*Numeric literal.*out of range.*";
    public static final String INVALID_ARGUMENTS_NUMBER = "Invalid number of arguments to function .* Was expecting .* arguments";
    public static final String INVALID_ARGUMENTS_TYPE_VALIDATION_ERROR = "Cannot apply '.*' to arguments of type .*";

    public SqlTestFactory getFactory();

    public SqlOperatorFixture withFactory(UnaryOperator<SqlTestFactory> var1);

    public SqlTester getTester();

    public SqlOperatorFixture withTester(UnaryOperator<SqlTester> var1);

    default public SqlOperatorFixture withParserConfig(UnaryOperator<SqlParser.Config> transform) {
        return this.withFactory(f -> f.withParserConfig(transform));
    }

    default public SqlOperatorFixture withQuoting(Quoting quoting) {
        return this.withParserConfig(c -> c.withQuoting(quoting));
    }

    default public SqlOperatorFixture withQuotedCasing(Casing casing) {
        return this.withParserConfig(c -> c.withQuotedCasing(casing));
    }

    default public SqlOperatorFixture withUnquotedCasing(Casing casing) {
        return this.withParserConfig(c -> c.withUnquotedCasing(casing));
    }

    default public SqlOperatorFixture withCaseSensitive(boolean sensitive) {
        return this.withParserConfig(c -> c.withCaseSensitive(sensitive));
    }

    default public SqlOperatorFixture withLex(Lex lex) {
        return this.withParserConfig(c -> c.withLex(lex));
    }

    default public SqlOperatorFixture withConformance(SqlConformance conformance) {
        return this.withParserConfig(c -> c.withConformance(conformance)).withValidatorConfig(c -> c.withConformance(conformance)).withConnectionFactory(cf -> cf.with("conformance", (Object)conformance));
    }

    default public SqlConformance conformance() {
        return this.getFactory().parserConfig().conformance();
    }

    default public SqlOperatorFixture withValidatorConfig(UnaryOperator<SqlValidator.Config> transform) {
        return this.withFactory(f -> f.withValidatorConfig(transform));
    }

    default public SqlOperatorFixture enableTypeCoercion(boolean enabled) {
        return this.withValidatorConfig(c -> c.withTypeCoercionEnabled(enabled));
    }

    default public SqlOperatorFixture withLenientOperatorLookup(boolean lenient) {
        return this.withValidatorConfig(c -> c.withLenientOperatorLookup(lenient));
    }

    default public SqlOperatorFixture withConnectionFactory(UnaryOperator<ConnectionFactory> transform) {
        return this.withFactory(f -> f.withConnectionFactory(transform));
    }

    default public SqlOperatorFixture withOperatorTable(SqlOperatorTable operatorTable) {
        return this.withFactory(f -> f.withOperatorTable(o -> operatorTable));
    }

    public boolean brokenTestsEnabled();

    public SqlOperatorFixture withBrokenTestsEnabled(boolean var1);

    public void checkScalar(String var1, SqlTester.TypeChecker var2, SqlTester.ResultChecker var3);

    default public void checkScalar(String expression, Object result, String resultType) {
        this.checkType(expression, resultType);
        this.checkScalar(expression, SqlTests.ANY_TYPE_CHECKER, ResultCheckers.createChecker(result));
    }

    default public void checkScalarExact(String expression, int result) {
        this.checkScalar(expression, SqlTests.INTEGER_TYPE_CHECKER, ResultCheckers.isSingle(result));
    }

    default public void checkScalarExact(String expression, String expectedType, String result) {
        this.checkScalarExact(expression, expectedType, ResultCheckers.isSingle(result));
    }

    public void checkScalarExact(String var1, String var2, SqlTester.ResultChecker var3);

    public void checkScalarApprox(String var1, String var2, Object var3);

    public void checkBoolean(String var1, @Nullable Boolean var2);

    public void checkString(String var1, String var2, String var3);

    public void checkNull(String var1);

    public void checkType(String var1, String var2);

    default public SqlOperatorFixture checkAggType(String expr, String type) {
        this.checkColumnType(AbstractSqlTester.buildQueryAgg(expr), type);
        return this;
    }

    public void checkColumnType(String var1, String var2);

    default public void check(String query, SqlTester.TypeChecker typeChecker, Object result) {
        this.check(query, typeChecker, SqlTests.ANY_PARAMETER_CHECKER, ResultCheckers.createChecker(result));
    }

    default public void check(String query, String expectedType, Object result) {
        this.check(query, new SqlTests.StringTypeChecker(expectedType), result);
    }

    default public void check(String query, SqlTester.TypeChecker typeChecker, SqlTester.ParameterChecker parameterChecker, SqlTester.ResultChecker resultChecker) {
        this.getTester().check(this.getFactory(), query, typeChecker, parameterChecker, resultChecker);
    }

    public SqlOperatorFixture setFor(SqlOperator var1, VmName ... var2);

    public void checkAgg(String var1, String[] var2, SqlTester.ResultChecker var3);

    public void checkAgg(String var1, String[] var2, String var3, SqlTester.ResultChecker var4);

    public void checkAggWithMultipleArgs(String var1, String[][] var2, SqlTester.ResultChecker var3);

    public void checkWinAgg(String var1, String[] var2, String var3, String var4, SqlTester.ResultChecker var5);

    public void checkAggFails(String var1, String[] var2, String var3, boolean var4);

    public void checkFails(StringAndPos var1, String var2, boolean var3);

    default public void checkFails(String expression, String expectedError, boolean runtime) {
        this.checkFails(StringAndPos.of((String)expression), expectedError, runtime);
    }

    public void checkQueryFails(StringAndPos var1, String var2);

    public void checkQuery(String var1);

    default public SqlOperatorFixture withLibrary(SqlLibrary library) {
        return this.withOperatorTable(SqlLibraryOperatorTableFactory.INSTANCE.getOperatorTable(new SqlLibrary[]{SqlLibrary.STANDARD, library})).withConnectionFactory(cf -> cf.with(ConnectionFactories.add(CalciteAssert.SchemaSpec.HR)).with((ConnectionProperty)CalciteConnectionProperty.FUN, (Object)library.fun));
    }

    default public SqlOperatorFixture withLibraries(SqlLibrary ... libraries) {
        ArrayList<String> names = new ArrayList<String>();
        for (SqlLibrary lib : libraries) {
            names.add(lib.fun);
        }
        return this.withOperatorTable(SqlLibraryOperatorTableFactory.INSTANCE.getOperatorTable(libraries)).withConnectionFactory(cf -> cf.with(ConnectionFactories.add(CalciteAssert.SchemaSpec.HR)).with((ConnectionProperty)CalciteConnectionProperty.FUN, (Object)String.join((CharSequence)",", names)));
    }

    default public void forEachLibrary(Iterable<? extends SqlLibrary> libraries, Consumer<SqlOperatorFixture> consumer) {
        SqlLibrary.expand(libraries).forEach(library -> {
            try {
                consumer.accept(this.withLibrary((SqlLibrary)library));
            }
            catch (Exception e) {
                throw new RuntimeException("for library " + library, e);
            }
        });
    }

    default public void forEachConformance(Iterable<? extends SqlConformanceEnum> conformances, Consumer<SqlOperatorFixture> consumer) {
        conformances.forEach(conformance -> {
            try {
                consumer.accept(this.withConformance((SqlConformance)conformance));
            }
            catch (Exception e) {
                throw new RuntimeException("for conformance " + conformance, e);
            }
        });
    }

    default public SqlOperatorFixture forOracle(SqlConformance conformance) {
        return this.withConformance(conformance).withOperatorTable(SqlLibraryOperatorTableFactory.INSTANCE.getOperatorTable(new SqlLibrary[]{SqlLibrary.STANDARD, SqlLibrary.ORACLE})).withConnectionFactory(cf -> cf.with(ConnectionFactories.add(CalciteAssert.SchemaSpec.HR)).with("fun", (Object)"oracle"));
    }

    default public String getCastString(String value, String targetType, boolean errorLoc, CastType castType) {
        if (errorLoc) {
            value = "^" + value + "^";
        }
        String function = castType.name;
        return function + "(" + value + " as " + targetType + ")";
    }

    default public void checkCastToApproxOkay(String value, String targetType, Object expected, CastType castType) {
        this.checkScalarApprox(this.getCastString(value, targetType, false, castType), this.getTargetType(targetType, castType), expected);
    }

    default public void checkCastToStringOkay(String value, String targetType, String expected, CastType castType) {
        String castString = this.getCastString(value, targetType, false, castType);
        this.checkString(castString, expected, this.getTargetType(targetType, castType));
    }

    default public void checkCastToScalarOkay(String value, String targetType, String expected, CastType castType) {
        String castString = this.getCastString(value, targetType, false, castType);
        this.checkScalarExact(castString, this.getTargetType(targetType, castType), expected);
    }

    default public String getTargetType(String targetType, CastType castType) {
        return castType == CastType.CAST ? targetType + " NOT NULL" : targetType;
    }

    default public void checkCastToScalarOkay(String value, String targetType, CastType castType) {
        this.checkCastToScalarOkay(value, targetType, value, castType);
    }

    default public void checkCastFails(String value, String targetType, String expectedError, boolean runtime, CastType castType) {
        boolean shouldFail = castType == CastType.CAST;
        String castString = this.getCastString(value, targetType, shouldFail && !runtime, castType);
        if (shouldFail) {
            this.checkFails(castString, expectedError, runtime);
        } else {
            this.checkNull(castString);
        }
    }

    default public void checkCastToString(String value, @Nullable String type, @Nullable String expected, CastType castType) {
        String spaces = "     ";
        if (expected == null) {
            expected = value.trim();
        }
        int len = expected.length();
        if (type != null) {
            value = this.getCastString(value, type, false, castType);
        }
        this.checkCastToStringOkay(value, "VARCHAR(" + len + ")", expected, castType);
        this.checkCastToStringOkay(value, "VARCHAR(" + (len + 5) + ")", expected, castType);
        this.checkCastToStringOkay(value, "CHAR(" + len + ")", expected, castType);
        this.checkCastToStringOkay(value, "CHAR(" + (len + 5) + ")", expected + spaces, castType);
    }

    public static enum CastType {
        CAST("cast"),
        SAFE_CAST("safe_cast"),
        TRY_CAST("try_cast");

        final String name;

        private CastType(String name) {
            this.name = name;
        }
    }

    public static enum VmName {
        JAVA,
        EXPAND;

    }
}

