/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.test;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.sql.parser.StringAndPos;
import org.apache.calcite.sql.test.SqlTester;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.TestUtil;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;

public abstract class SqlTests {
    public static final SqlTester.TypeChecker INTEGER_TYPE_CHECKER = new SqlTypeChecker(SqlTypeName.INTEGER);
    public static final SqlTester.TypeChecker BOOLEAN_TYPE_CHECKER = new SqlTypeChecker(SqlTypeName.BOOLEAN);
    public static final SqlTester.TypeChecker ANY_TYPE_CHECKER = (sql, type) -> {};
    public static final SqlTester.ParameterChecker ANY_PARAMETER_CHECKER = parameterRowType -> {};
    public static final SqlTester.ResultChecker ANY_RESULT_CHECKER = (sql, result) -> {
        while (result.next()) {
        }
    };
    private static final Pattern LINE_COL_PATTERN = Pattern.compile("At line ([0-9]+), column ([0-9]+)");
    private static final Pattern LINE_COL_TWICE_PATTERN = Pattern.compile("(?s)From line ([0-9]+), column ([0-9]+) to line ([0-9]+), column ([0-9]+): (.*)");

    public static String getTypeString(RelDataType sqlType) {
        switch (sqlType.getSqlTypeName()) {
            case VARCHAR: 
            case CHAR: {
                String actual = sqlType.getSqlTypeName().name();
                if (sqlType.getPrecision() != -1) {
                    actual = actual + "(" + sqlType.getPrecision() + ")";
                }
                if (!sqlType.isNullable()) {
                    actual = actual + " NOT NULL";
                }
                return actual;
            }
        }
        return sqlType.getFullTypeString();
    }

    public static List<RelDataType> getTypes(RelDataTypeFactory typeFactory) {
        int maxPrecision = typeFactory.getTypeSystem().getMaxPrecision(SqlTypeName.DECIMAL);
        return ImmutableList.of((Object)typeFactory.createSqlType(SqlTypeName.BOOLEAN), (Object)typeFactory.createSqlType(SqlTypeName.TINYINT), (Object)typeFactory.createSqlType(SqlTypeName.SMALLINT), (Object)typeFactory.createSqlType(SqlTypeName.INTEGER), (Object)typeFactory.createSqlType(SqlTypeName.BIGINT), (Object)typeFactory.createSqlType(SqlTypeName.DECIMAL), (Object)typeFactory.createSqlType(SqlTypeName.DECIMAL, 5), (Object)typeFactory.createSqlType(SqlTypeName.DECIMAL, 6, 2), (Object)typeFactory.createSqlType(SqlTypeName.DECIMAL, maxPrecision, 0), (Object)typeFactory.createSqlType(SqlTypeName.DECIMAL, maxPrecision, 5), (Object)typeFactory.createSqlType(SqlTypeName.CHAR, 5), (Object)typeFactory.createSqlType(SqlTypeName.VARCHAR, 1), (Object[])new RelDataType[]{typeFactory.createSqlType(SqlTypeName.VARCHAR, 20), typeFactory.createSqlType(SqlTypeName.BINARY, 3), typeFactory.createSqlType(SqlTypeName.VARBINARY, 4), typeFactory.createSqlType(SqlTypeName.DATE), typeFactory.createSqlType(SqlTypeName.TIME, 0), typeFactory.createSqlType(SqlTypeName.TIMESTAMP, 0)});
    }

    public static String generateAggQuery(String expr, String[] inputValues) {
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT ").append(expr).append(" FROM ");
        if (inputValues.length == 0) {
            buf.append("(VALUES 1) AS t(x) WHERE false");
        } else {
            buf.append("(");
            for (int i = 0; i < inputValues.length; ++i) {
                if (i > 0) {
                    buf.append(" UNION ALL ");
                }
                buf.append("SELECT ");
                String inputValue = inputValues[i];
                buf.append(inputValue).append(" AS x FROM (VALUES (1))");
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public static String generateAggQueryWithMultipleArgs(String expr, String[][] inputValues) {
        int argCount = -1;
        for (Object[] objectArray : inputValues) {
            if (argCount == -1) {
                argCount = objectArray.length;
                continue;
            }
            if (argCount == objectArray.length) continue;
            throw new IllegalArgumentException("invalid test input: " + Arrays.toString(objectArray));
        }
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT ").append(expr).append(" FROM ");
        if (inputValues.length == 0) {
            buf.append("(VALUES 1) AS t(x) WHERE false");
        } else {
            buf.append("(");
            for (int i = 0; i < inputValues.length; ++i) {
                if (i > 0) {
                    buf.append(" UNION ALL ");
                }
                buf.append("SELECT ");
                for (int j = 0; j < argCount; ++j) {
                    if (j != 0) {
                        buf.append(", ");
                    }
                    String string = inputValues[i][j];
                    buf.append(string).append(" AS x");
                    if (j == 0) continue;
                    buf.append(j + 1);
                }
                buf.append(" FROM (VALUES (1))");
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public static String generateWinAggQuery(String expr, String windowSpec, String[] inputValues) {
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT ").append(expr).append(" OVER (").append(windowSpec).append(") FROM (");
        for (int i = 0; i < inputValues.length; ++i) {
            if (i > 0) {
                buf.append(" UNION ALL ");
            }
            buf.append("SELECT ");
            String inputValue = inputValues[i];
            buf.append(inputValue).append(" AS x FROM (VALUES (1))");
        }
        buf.append(")");
        return buf.toString();
    }

    public static void checkEx(@Nullable Throwable ex, @Nullable String expectedMsgPattern, StringAndPos sap, Stage stage) {
        String sqlWithCarets;
        if (null == ex) {
            if (expectedMsgPattern == null) {
                return;
            }
            throw new AssertionError((Object)("Expected query to throw exception, but it did not; query [" + sap.sql + "]; expected [" + expectedMsgPattern + "]"));
        }
        Throwable actualException = ex;
        String actualMessage = actualException.getMessage();
        int actualLine = -1;
        int actualColumn = -1;
        int actualEndLine = 100;
        int actualEndColumn = 99;
        if (ex instanceof ExceptionInInitializerError) {
            ex = ((ExceptionInInitializerError)ex).getException();
        }
        CalciteContextException ece = null;
        for (Throwable x = ex; x != null; x = x.getCause()) {
            if (x instanceof CalciteContextException) {
                ece = (CalciteContextException)x;
                break;
            }
            if (x.getCause() == x) break;
        }
        IllegalStateException ise = null;
        for (Throwable x = ex; x != null; x = x.getCause()) {
            if (x instanceof IllegalStateException) {
                ise = (IllegalStateException)x;
                break;
            }
            if (x.getCause() == x) break;
        }
        SqlParseException spe = null;
        for (Throwable x = ex; x != null; x = x.getCause()) {
            if (x instanceof SqlParseException && ((SqlParseException)x).getPos() != null) {
                spe = (SqlParseException)x;
                break;
            }
            if (x.getCause() == x) break;
        }
        if (ece != null) {
            actualLine = ece.getPosLine();
            actualColumn = ece.getPosColumn();
            actualEndLine = ece.getEndPosLine();
            actualEndColumn = ece.getEndPosColumn();
            if (ece.getCause() != null) {
                actualException = ece.getCause();
                actualMessage = actualException.getMessage();
            }
        } else if (spe != null) {
            actualLine = spe.getPos().getLineNum();
            actualColumn = spe.getPos().getColumnNum();
            actualEndLine = spe.getPos().getEndLineNum();
            actualEndColumn = spe.getPos().getEndColumnNum();
            if (spe.getCause() != null) {
                actualException = spe.getCause();
                actualMessage = actualException.getMessage();
            }
        } else if (ise != null) {
            Throwable[] suppressed = ise.getSuppressed();
            if (suppressed.length > 0) {
                actualException = suppressed[0];
                actualMessage = actualException.getMessage();
            }
        } else {
            actualMessage = ex.getMessage();
            if (ex instanceof NumberFormatException) {
                actualMessage = "Number has wrong format " + actualMessage;
            }
            if (actualMessage != null) {
                java.util.regex.Matcher matcher = LINE_COL_TWICE_PATTERN.matcher(actualMessage);
                if (matcher.matches()) {
                    actualLine = Integer.parseInt(matcher.group(1));
                    actualColumn = Integer.parseInt(matcher.group(2));
                    actualEndLine = Integer.parseInt(matcher.group(3));
                    actualEndColumn = Integer.parseInt(matcher.group(4));
                    actualMessage = matcher.group(5);
                } else {
                    matcher = LINE_COL_PATTERN.matcher(actualMessage);
                    if (matcher.matches()) {
                        actualLine = Integer.parseInt(matcher.group(1));
                        actualColumn = Integer.parseInt(matcher.group(2));
                    } else if (expectedMsgPattern != null && actualMessage.matches(expectedMsgPattern)) {
                        return;
                    }
                }
            }
        }
        if (null == expectedMsgPattern) {
            actualException.printStackTrace();
            Assertions.fail((String)(stage.componentName + " threw unexpected exception; query [" + sap.sql + "]; exception [" + actualMessage + "]; class [" + actualException.getClass() + "]; pos [line " + actualLine + " col " + actualColumn + " thru line " + actualLine + " col " + actualColumn + "]"));
        }
        if (actualColumn <= 0 || actualLine <= 0 || actualEndColumn <= 0 || actualEndLine <= 0) {
            if (sap.pos != null) {
                throw new AssertionError("Expected error to have position, but actual error did not:  actual pos [line " + actualLine + " col " + actualColumn + " thru line " + actualEndLine + " col " + actualEndColumn + "]", actualException);
            }
            sqlWithCarets = sap.sql;
        } else {
            sqlWithCarets = SqlParserUtil.addCarets((String)sap.sql, (int)actualLine, (int)actualColumn, (int)actualEndLine, (int)(actualEndColumn + 1));
            if (sap.pos == null) {
                throw new AssertionError((Object)("Actual error had a position, but expected error did not. Add error position carets to sql:\n" + sqlWithCarets));
            }
        }
        if (actualMessage != null) {
            actualMessage = Util.toLinux((String)actualMessage);
        }
        if (actualMessage == null || !actualMessage.matches(expectedMsgPattern)) {
            actualException.printStackTrace();
            String actualJavaRegexp = actualMessage == null ? "null" : TestUtil.quoteForJava(TestUtil.quotePattern(actualMessage));
            Assertions.fail((String)(stage.componentName + " threw different exception than expected; query [" + sap.sql + "];\n expected pattern [" + expectedMsgPattern + "];\n actual [" + actualMessage + "];\n actual as java regexp [" + actualJavaRegexp + "]; pos [" + actualLine + " col " + actualColumn + " thru line " + actualEndLine + " col " + actualEndColumn + "]; sql [" + sqlWithCarets + "]"));
        } else if (sap.pos != null && (actualLine != sap.pos.getLineNum() || actualColumn != sap.pos.getColumnNum() || actualEndLine != sap.pos.getEndLineNum() || actualEndColumn != sap.pos.getEndColumnNum())) {
            Assertions.fail((String)(stage.componentName + " threw expected exception [" + actualMessage + "];\nbut at pos [line " + actualLine + " col " + actualColumn + " thru line " + actualEndLine + " col " + actualEndColumn + "];\nsql [" + sqlWithCarets + "]"));
        }
    }

    public static class StringTypeChecker
    implements SqlTester.TypeChecker {
        private final String expected;

        public StringTypeChecker(String expected) {
            this.expected = expected;
        }

        @Override
        public void checkType(Supplier<String> sql, RelDataType type) {
            String actual = SqlTests.getTypeString(type);
            MatcherAssert.assertThat((String)sql.get(), (Object)actual, (Matcher)CoreMatchers.is((Object)this.expected));
        }
    }

    private static class SqlTypeChecker
    implements SqlTester.TypeChecker {
        private final SqlTypeName typeName;

        SqlTypeChecker(SqlTypeName typeName) {
            this.typeName = typeName;
        }

        @Override
        public void checkType(Supplier<String> sql, RelDataType type) {
            MatcherAssert.assertThat((String)sql.get(), (Object)type, (Matcher)Matchers.hasToString((String)this.typeName.toString()));
        }
    }

    public static enum Stage {
        PARSE("Parser"),
        VALIDATE("Validator"),
        RUNTIME("Executor");

        public final String componentName;

        private Stage(String componentName) {
            this.componentName = componentName;
        }
    }
}

