/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import java.math.RoundingMode;
import java.util.function.Function;
import org.apache.calcite.rel.type.DelegatingTypeSystem;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.type.SqlTypeName;

public final class CustomTypeSystems {
    public static final RelDataTypeSystem ROUNDING_MODE_HALF_UP = CustomTypeSystems.withRoundingMode(RelDataTypeSystem.DEFAULT, RoundingMode.HALF_UP);
    public static final RelDataTypeSystem NEGATIVE_SCALE = CustomTypeSystems.withMinScale(RelDataTypeSystem.DEFAULT, sqlTypeName -> -1000);
    public static final RelDataTypeSystem NEGATIVE_SCALE_ROUNDING_MODE_HALF_UP = CustomTypeSystems.withMinScale(ROUNDING_MODE_HALF_UP, sqlTypeName -> -1000);

    private CustomTypeSystems() {
    }

    public static RelDataTypeSystem withRoundingMode(RelDataTypeSystem typeSystem, final RoundingMode roundingMode) {
        return new DelegatingTypeSystem(typeSystem){

            public RoundingMode roundingMode() {
                return roundingMode;
            }
        };
    }

    public static RelDataTypeSystem withMaxPrecision(RelDataTypeSystem typeSystem, final Function<SqlTypeName, Integer> maxPrecision) {
        return new DelegatingTypeSystem(typeSystem){

            public int getMaxPrecision(SqlTypeName typeName) {
                return (Integer)maxPrecision.apply(typeName);
            }
        };
    }

    public static RelDataTypeSystem withMaxScale(RelDataTypeSystem typeSystem, final Function<SqlTypeName, Integer> maxScale) {
        return new DelegatingTypeSystem(typeSystem){

            public int getMaxScale(SqlTypeName typeName) {
                return (Integer)maxScale.apply(typeName);
            }
        };
    }

    public static RelDataTypeSystem withMinScale(RelDataTypeSystem typeSystem, final Function<SqlTypeName, Integer> minNumericScale) {
        return new DelegatingTypeSystem(typeSystem){

            public int getMinScale(SqlTypeName typeName) {
                return (Integer)minNumericScale.apply(typeName);
            }
        };
    }
}

