/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.calcite.avatica.util.Spaces;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.test.DiffTestCase;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Sources;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.XmlOutput;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.opentest4j.AssertionFailedError;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class DiffRepository {
    private static final String ROOT_TAG = "Root";
    private static final String TEST_CASE_TAG = "TestCase";
    private static final String TEST_CASE_NAME_ATTR = "name";
    private static final String TEST_CASE_OVERRIDES_ATTR = "overrides";
    private static final String RESOURCE_TAG = "Resource";
    private static final String RESOURCE_NAME_ATTR = "name";
    private static final LoadingCache<Key, DiffRepository> REPOSITORY_CACHE = CacheBuilder.newBuilder().build(CacheLoader.from(Key::toRepo));
    private static final ThreadLocal<DocumentBuilderFactory> DOCUMENT_BUILDER_FACTORY = ThreadLocal.withInitial(() -> {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setXIncludeAware(false);
        documentBuilderFactory.setExpandEntityReferences(false);
        documentBuilderFactory.setNamespaceAware(true);
        try {
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Document Builder configuration failed", e);
        }
        return documentBuilderFactory;
    });
    private final @Nullable DiffRepository baseRepository;
    private final int indent;
    private final ImmutableSortedSet<String> outOfOrderTests;
    private Document doc;
    private final Element root;
    private final URL refFile;
    private final File logFile;
    private final @Nullable Filter filter;
    private int modCount;
    private int modCountAtLastWrite;

    private DiffRepository(URL refFile, File logFile, @Nullable DiffRepository baseRepository, @Nullable Filter filter, int indent) {
        this.baseRepository = baseRepository;
        this.filter = filter;
        this.indent = indent;
        this.refFile = Objects.requireNonNull(refFile, "refFile");
        this.logFile = logFile;
        this.modCountAtLastWrite = 0;
        this.modCount = 0;
        try {
            DocumentBuilder docBuilder = DOCUMENT_BUILDER_FACTORY.get().newDocumentBuilder();
            try (InputStream inputStream = refFile.openStream();){
                this.doc = docBuilder.parse(inputStream);
            }
            catch (IOException e) {
                this.doc = docBuilder.newDocument();
                this.doc.appendChild(this.doc.createElement(ROOT_TAG));
                this.flushDoc();
            }
            this.root = this.doc.getDocumentElement();
            this.outOfOrderTests = DiffRepository.validate(this.root);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new RuntimeException("error while creating xml parser", e);
        }
    }

    public void checkActualAndReferenceFiles() {
        if (!this.logFile.exists()) {
            return;
        }
        String resourceFile = Sources.of((URL)this.refFile).file().getPath().replace(String.join((CharSequence)File.separator, "build", "resources", "test"), String.join((CharSequence)File.separator, "src", "test", "resources"));
        String diff = DiffTestCase.diff(new File(resourceFile), this.logFile);
        if (!diff.isEmpty()) {
            throw new IllegalArgumentException("Actual and reference files differ. If you are adding new tests, replace the reference file with the current actual file, after checking its content.\ndiff " + this.logFile.getAbsolutePath() + " " + resourceFile + "\n" + diff);
        }
    }

    private static URL findFile(Class<?> clazz, String suffix) {
        String rest = "/" + clazz.getName().replace('.', File.separatorChar) + suffix;
        return Objects.requireNonNull(clazz.getResource(rest));
    }

    public static DiffRepository castNonNull(@Nullable DiffRepository diffRepos) {
        if (diffRepos != null) {
            return (DiffRepository)Nullness.castNonNull((Object)diffRepos);
        }
        throw new IllegalArgumentException("diffRepos is null; if you require a DiffRepository, set it in your test's fixture() method");
    }

    public String expand(String tag, String text) {
        Objects.requireNonNull(tag, "tag");
        Objects.requireNonNull(text, "text");
        if (text.startsWith("${") && text.endsWith("}")) {
            String testCaseName = DiffRepository.getCurrentTestCaseName();
            String token = text.substring(2, text.length() - 1);
            assert (token.startsWith(tag)) : "token '" + token + "' does not match tag '" + tag + "'";
            String expanded = this.get(testCaseName, token);
            if (expanded == null) {
                return text;
            }
            if (this.filter != null) {
                expanded = this.filter.filter(this, testCaseName, tag, text, expanded);
            }
            return expanded;
        }
        String testCaseName = DiffRepository.getCurrentTestCaseName();
        if (this.baseRepository == null || this.baseRepository.get(testCaseName, tag) == null) {
            this.set(tag, text);
        }
        return text;
    }

    public synchronized void set(String resourceName, String value) {
        Objects.requireNonNull(resourceName, "resourceName");
        String testCaseName = DiffRepository.getCurrentTestCaseName();
        this.update(testCaseName, resourceName, value);
    }

    public void amend(String expected, String actual) {
        if (expected.startsWith("${") && expected.endsWith("}")) {
            String token = expected.substring(2, expected.length() - 1);
            this.set(token, actual);
        }
    }

    private synchronized @Nullable String get(String testCaseName, String resourceName) {
        Element testCaseElement = this.getTestCaseElement(testCaseName, true, null);
        if (testCaseElement == null) {
            if (this.baseRepository != null) {
                return this.baseRepository.get(testCaseName, resourceName);
            }
            return null;
        }
        @Nullable Element resourceElement = DiffRepository.getResourceElement(testCaseElement, resourceName);
        if (resourceElement != null) {
            return DiffRepository.getText(resourceElement);
        }
        return null;
    }

    private static String getText(Element element) {
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!(node instanceof CDATASection)) continue;
            return node.getNodeValue();
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!(node instanceof Text)) continue;
            buf.append(((Text)node).getWholeText());
        }
        return buf.toString();
    }

    private synchronized @Nullable Element getTestCaseElement(String testCaseName, boolean checkOverride, @Nullable List<Pair<String, Element>> elements) {
        NodeList childNodes = this.root.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (!child.getNodeName().equals(TEST_CASE_TAG)) continue;
            Element testCase = (Element)child;
            String name = testCase.getAttribute("name");
            if (testCaseName.equals(name)) {
                if (checkOverride && this.baseRepository != null && this.baseRepository.getTestCaseElement(testCaseName, false, null) != null && !"true".equals(testCase.getAttribute(TEST_CASE_OVERRIDES_ATTR))) {
                    throw new RuntimeException("TestCase  '" + testCaseName + "' overrides a test case in the base repository, but does not specify 'overrides=true'");
                }
                if (this.outOfOrderTests.contains((Object)testCaseName)) {
                    ++this.modCount;
                    this.flushDoc();
                    throw new IllegalArgumentException("TestCase '" + testCaseName + "' is out of order in the reference file: " + Sources.of((URL)this.refFile).file() + "\nTo fix, copy the generated log file: " + this.logFile + "\n");
                }
                return testCase;
            }
            if (elements == null) continue;
            elements.add((Pair<String, Element>)Pair.of((Object)name, (Object)testCase));
        }
        return null;
    }

    private static @Nullable String getCurrentTestCaseName(boolean fail) {
        StackTraceElement[] stackTrace;
        Throwable runtimeException = new Throwable();
        runtimeException.fillInStackTrace();
        for (StackTraceElement stackTraceElement : stackTrace = runtimeException.getStackTrace()) {
            String methodName = stackTraceElement.getMethodName();
            if (!methodName.startsWith("test")) continue;
            return methodName;
        }
        if (fail) {
            throw new RuntimeException("no test case on current call stack");
        }
        return null;
    }

    private static String getCurrentTestCaseName() {
        return Objects.requireNonNull(DiffRepository.getCurrentTestCaseName(true));
    }

    public void assertEquals(String tag, String expected, String actual) {
        String testCaseName = DiffRepository.getCurrentTestCaseName(true);
        String expected2 = this.expand(tag, expected);
        if (expected2 == null) {
            this.update(testCaseName, expected, actual);
            throw new AssertionError((Object)("reference file does not contain resource '" + expected + "' for test case '" + testCaseName + "'"));
        }
        try {
            String expected2Canonical = expected2.replace(Util.LINE_SEPARATOR, "\n");
            String actualCanonical = actual.replace(Util.LINE_SEPARATOR, "\n");
            MatcherAssert.assertThat((String)tag, (Object)actualCanonical, (Matcher)CoreMatchers.is((Object)expected2Canonical));
        }
        catch (AssertionFailedError e) {
            this.amend(expected, actual);
            throw e;
        }
    }

    private synchronized void update(String testCaseName, String resourceName, String value) {
        Element resourceElement;
        ArrayList<Pair<String, Element>> map = new ArrayList<Pair<String, Element>>();
        Element testCaseElement = this.getTestCaseElement(testCaseName, true, map);
        if (testCaseElement == null) {
            testCaseElement = this.doc.createElement(TEST_CASE_TAG);
            testCaseElement.setAttribute("name", testCaseName);
            Node refElement = DiffRepository.ref(testCaseName, map);
            this.root.insertBefore(testCaseElement, refElement);
            ++this.modCount;
        }
        if ((resourceElement = DiffRepository.getResourceElement(testCaseElement, resourceName, true)) == null) {
            resourceElement = this.doc.createElement(RESOURCE_TAG);
            resourceElement.setAttribute("name", resourceName);
            testCaseElement.appendChild(resourceElement);
            ++this.modCount;
            if (!value.isEmpty()) {
                resourceElement.appendChild(this.doc.createCDATASection(value));
            }
        } else {
            ImmutableList newChildList = value.isEmpty() ? ImmutableList.of() : ImmutableList.of((Object)this.doc.createCDATASection(value));
            if (DiffRepository.replaceChildren(resourceElement, (List<Node>)newChildList)) {
                ++this.modCount;
            }
        }
        this.flushDoc();
    }

    private static @Nullable Node ref(String testCaseName, List<Pair<String, Element>> map) {
        if (map.isEmpty()) {
            return null;
        }
        int i = 0;
        List names = Pair.left(map);
        for (String s : names) {
            if (s.compareToIgnoreCase(testCaseName) > 0) continue;
            ++i;
        }
        while (i < map.size() && ((String)names.get(i)).compareToIgnoreCase(testCaseName) < 0) {
            ++i;
        }
        if (i >= map.size() - 1) {
            return null;
        }
        while (i >= 0 && ((String)names.get(i)).compareToIgnoreCase(testCaseName) > 0) {
            --i;
        }
        return (Node)map.get((int)(i + 1)).right;
    }

    private synchronized void flushDoc() {
        if (this.modCount == this.modCountAtLastWrite) {
            return;
        }
        try {
            boolean b = this.logFile.getParentFile().mkdirs();
            Util.discard((boolean)b);
            try (PrintWriter w = Util.printWriter((File)this.logFile);){
                DiffRepository.write(this.doc, w, this.indent);
            }
        }
        catch (IOException e) {
            throw Util.throwAsRuntime((String)("error while writing test reference log '" + this.logFile + "'"), (Throwable)e);
        }
        this.modCountAtLastWrite = this.modCount;
    }

    private static ImmutableSortedSet<String> validate(Element root) {
        if (!root.getNodeName().equals(ROOT_TAG)) {
            throw new RuntimeException("expected root element of type 'Root', but found '" + root.getNodeName() + "'");
        }
        TreeMap<String, Element> testCases = new TreeMap<String, Element>();
        NodeList childNodes = root.getChildNodes();
        ArrayList<String> outOfOrderNames = new ArrayList<String>();
        String previousName = null;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (!child.getNodeName().equals(TEST_CASE_TAG)) continue;
            Element testCase = (Element)child;
            String name = testCase.getAttribute("name");
            if (testCases.put(name, testCase) != null) {
                throw new RuntimeException("TestCase '" + name + "' is duplicate");
            }
            if (previousName != null && previousName.compareTo(name) > 0) {
                outOfOrderNames.add(name);
            }
            previousName = name;
        }
        if (!outOfOrderNames.isEmpty()) {
            for (Node testCase : testCases.values()) {
                root.removeChild(testCase);
            }
            for (Node testCase : testCases.values()) {
                root.appendChild(testCase);
            }
        }
        return ImmutableSortedSet.copyOf(outOfOrderNames);
    }

    private static @Nullable Element getResourceElement(Element testCaseElement, String resourceName) {
        return DiffRepository.getResourceElement(testCaseElement, resourceName, false);
    }

    private static @Nullable Element getResourceElement(Element testCaseElement, String resourceName, boolean killYoungerSiblings) {
        NodeList childNodes = testCaseElement.getChildNodes();
        Element found = null;
        ArrayList<Node> kills = new ArrayList<Node>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (!child.getNodeName().equals(RESOURCE_TAG) || !resourceName.equals(((Element)child).getAttribute("name"))) continue;
            if (found == null) {
                found = (Element)child;
                continue;
            }
            if (!killYoungerSiblings) continue;
            kills.add(child);
        }
        for (Node kill : kills) {
            testCaseElement.removeChild(kill);
        }
        return found;
    }

    private static void removeAllChildren(Element element) {
        NodeList childNodes = element.getChildNodes();
        while (childNodes.getLength() > 0) {
            element.removeChild(childNodes.item(0));
        }
    }

    private static boolean replaceChildren(Element element, List<Node> children) {
        NodeList childNodes = element.getChildNodes();
        ArrayList<Node> list = new ArrayList<Node>();
        for (Node item : DiffRepository.iterate(childNodes)) {
            if (item.getNodeType() == 3) continue;
            list.add(item);
        }
        if (DiffRepository.equalList(children, list)) {
            return false;
        }
        DiffRepository.removeAllChildren(element);
        children.forEach(element::appendChild);
        return true;
    }

    private static boolean equalList(List<Node> list0, List<Node> list1) {
        return list1.size() == list0.size() && Pair.zip(list1, list0).stream().allMatch(p -> ((Node)p.left).isEqualNode((Node)p.right));
    }

    private static void write(Document doc, Writer w, int indent) {
        XmlOutput out = new XmlOutput(w);
        out.setGlob(true);
        out.setIndentString(Spaces.of((int)indent));
        DiffRepository.writeNode(doc, out);
    }

    private static void writeNode(Node node, XmlOutput out) {
        switch (node.getNodeType()) {
            case 9: {
                out.print("<?xml version=\"1.0\" ?>\n");
                NodeList childNodes = node.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node child = childNodes.item(i);
                    DiffRepository.writeNode(child, out);
                }
                break;
            }
            case 1: {
                int i;
                Element element = (Element)node;
                String tagName = element.getTagName();
                out.beginBeginTag(tagName);
                NamedNodeMap attributeMap = element.getAttributes();
                for (i = 0; i < attributeMap.getLength(); ++i) {
                    Node att = attributeMap.item(i);
                    out.attribute(att.getNodeName(), att.getNodeValue());
                }
                out.endBeginTag(tagName);
                NodeList childNodes = node.getChildNodes();
                for (i = 0; i < childNodes.getLength(); ++i) {
                    Node child = childNodes.item(i);
                    if (child.getNodeType() == 2) continue;
                    DiffRepository.writeNode(child, out);
                }
                out.endTag(tagName);
                break;
            }
            case 2: {
                out.attribute(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 4: {
                CDATASection cdata = (CDATASection)node;
                out.cdata(cdata.getNodeValue(), true);
                break;
            }
            case 3: {
                Text text = (Text)node;
                String wholeText = text.getNodeValue();
                if (DiffRepository.isWhitespace(wholeText)) break;
                out.cdata(wholeText, false);
                break;
            }
            case 8: {
                Comment comment = (Comment)node;
                out.print("<!--" + comment.getNodeValue() + "-->\n");
                break;
            }
            default: {
                throw new RuntimeException("unexpected node type: " + node.getNodeType() + " (" + node + ")");
            }
        }
    }

    private static boolean isWhitespace(String text) {
        int count = text.length();
        block3: for (int i = 0; i < count; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static DiffRepository lookup(Class<?> clazz) {
        return DiffRepository.lookup(clazz, null, null, 2);
    }

    public static DiffRepository lookup(Class<?> clazz, @Nullable DiffRepository baseRepository, @Nullable Filter filter, int indent) {
        Key key = new Key(clazz, baseRepository, filter, indent);
        return (DiffRepository)REPOSITORY_CACHE.getUnchecked((Object)key);
    }

    private static Iterable<Node> iterate(final NodeList nodeList) {
        return new AbstractList<Node>(){

            @Override
            public Node get(int index) {
                return nodeList.item(index);
            }

            @Override
            public int size() {
                return nodeList.getLength();
            }
        };
    }

    private static class Key {
        private final Class<?> clazz;
        private final @Nullable DiffRepository baseRepository;
        private final @Nullable Filter filter;
        private final int indent;

        Key(Class<?> clazz, @Nullable DiffRepository baseRepository, @Nullable Filter filter, int indent) {
            this.clazz = Objects.requireNonNull(clazz, "clazz");
            this.baseRepository = baseRepository;
            this.filter = filter;
            this.indent = indent;
        }

        public int hashCode() {
            return Objects.hash(this.clazz, this.baseRepository, this.filter);
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof Key && this.clazz.equals(((Key)obj).clazz) && Objects.equals(this.baseRepository, ((Key)obj).baseRepository) && Objects.equals(this.filter, ((Key)obj).filter);
        }

        DiffRepository toRepo() {
            URL refFile = DiffRepository.findFile(this.clazz, ".xml");
            String refFilePath = Sources.of((URL)refFile).file().getAbsolutePath();
            String logFilePath = refFilePath.replace("resources", "diffrepo").replace(".xml", "_actual.xml");
            File logFile = new File(logFilePath);
            assert (!refFilePath.equals(logFile.getAbsolutePath()));
            return new DiffRepository(refFile, logFile, this.baseRepository, this.filter, this.indent);
        }
    }

    public static interface Filter {
        public String filter(DiffRepository var1, String var2, String var3, String var4, String var5);
    }
}

