/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.RangeSet;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelValidityChecker;
import org.apache.calcite.rel.hint.Hintable;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.Unsafe;
import org.apache.calcite.util.TestUtil;
import org.apache.calcite.util.Util;
import org.apiguardian.api.API;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.CustomTypeSafeMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.StringContains;

public class Matchers {
    private static final Pattern PATTERN = Pattern.compile(", id = [0-9]+");
    public static final double EPSILON = 1.0E-5;
    private static final ThreadLocal<Object> THREAD_ACTUAL = new ThreadLocal();

    private Matchers() {
    }

    public static Matcher<? super ResultSet> returnsUnordered(String ... lines) {
        final ArrayList expectedList = Lists.newArrayList((Object[])lines);
        Collections.sort(expectedList);
        return new CustomTypeSafeMatcher<ResultSet>(Arrays.toString(lines)){

            protected void describeMismatchSafely(ResultSet item, Description description) {
                Object value = THREAD_ACTUAL.get();
                THREAD_ACTUAL.remove();
                description.appendText("was ").appendValue(value);
            }

            protected boolean matchesSafely(ResultSet resultSet) {
                ArrayList<String> actualList = new ArrayList<String>();
                try {
                    CalciteAssert.toStringList(resultSet, actualList);
                    resultSet.close();
                }
                catch (SQLException e) {
                    throw TestUtil.rethrow(e);
                }
                Collections.sort(actualList);
                THREAD_ACTUAL.set(actualList);
                boolean equals = actualList.equals(expectedList);
                if (!equals) {
                    THREAD_ACTUAL.set(actualList);
                }
                return equals;
            }
        };
    }

    public static <E extends Comparable> Matcher<Iterable<E>> equalsUnordered(E ... lines) {
        final ArrayList expectedList = Lists.newArrayList(Matchers.toStringList(Arrays.asList(lines)));
        Collections.sort(expectedList);
        String description = Util.lines((Iterable)expectedList);
        return new CustomTypeSafeMatcher<Iterable<E>>(description){

            protected void describeMismatchSafely(Iterable<E> actuals, Description description) {
                ArrayList actualList = Lists.newArrayList((Iterable)Matchers.toStringList(actuals));
                Collections.sort(actualList);
                description.appendText("was ").appendValue((Object)Util.lines((Iterable)actualList));
            }

            protected boolean matchesSafely(Iterable<E> actuals) {
                ArrayList actualList = Lists.newArrayList((Iterable)Matchers.toStringList(actuals));
                Collections.sort(actualList);
                return actualList.equals(expectedList);
            }
        };
    }

    private static <E> Iterable<String> toStringList(Iterable<E> items) {
        return (Iterable)StreamSupport.stream(items.spliterator(), false).map(Object::toString).collect(ImmutableList.toImmutableList());
    }

    @Deprecated
    public static <T extends Number> Matcher<T> within(T value, double epsilon) {
        return new IsWithin<T>(value, epsilon);
    }

    public static Matcher<Double> isAlmost(double value) {
        return org.hamcrest.Matchers.closeTo((double)value, (double)1.0E-5);
    }

    public static <T extends Comparable<T>> Matcher<T> between(final T min, final T max) {
        return new CustomTypeSafeMatcher<T>("between " + min + " and " + max){

            protected boolean matchesSafely(T item) {
                return min.compareTo(item) <= 0 && item.compareTo((Comparable)max) <= 0;
            }
        };
    }

    public static <F, T> Matcher<F> compose(Matcher<T> matcher, Function<F, T> f) {
        return new ComposingMatcher<F, T>(matcher, f);
    }

    public static Matcher<String> isLinux(String value) {
        return Matchers.compose(Is.is((Object)value), input -> input == null ? null : Util.toLinux((String)input));
    }

    public static Matcher<RelNode> relIsValid() {
        return new TypeSafeMatcher<RelNode>(){

            public void describeTo(Description description) {
                description.appendText("rel is valid");
            }

            protected boolean matchesSafely(RelNode rel) {
                RelValidityChecker checker = new RelValidityChecker();
                checker.go(rel);
                return checker.invalidCount() == 0;
            }
        };
    }

    public static Matcher<RelNode> hasTree(String value) {
        return Matchers.compose(Is.is((Object)value), input -> Util.toLinux((String)RelOptUtil.toString((RelNode)input)));
    }

    public static Matcher<RelNode> hasFieldNames(final String fieldNames) {
        return new TypeSafeMatcher<RelNode>(){

            public void describeTo(Description description) {
                description.appendText("has fields ").appendText(fieldNames);
            }

            protected boolean matchesSafely(RelNode r) {
                return r.getRowType().getFieldNames().toString().equals(fieldNames);
            }
        };
    }

    public static Matcher<RelNode> inTree(String value) {
        return Matchers.compose(StringContains.containsString((String)value), input -> Util.toLinux((String)RelOptUtil.toString((RelNode)input)));
    }

    public static Matcher<RexNode> hasRex(String value) {
        return Matchers.compose(Is.is((Object)value), input -> Util.toLinux((String)input.toString()));
    }

    public static Matcher<RelNode> hasHints(String value) {
        return Matchers.compose(Is.is((Object)value), input -> input instanceof Hintable ? ((Hintable)input).getHints().toString() : "[]");
    }

    public static Matcher<RangeSet> isRangeSet(String value) {
        return Matchers.compose(Is.is((Object)value), input -> Matchers.sanitizeRangeSet(input.toString()));
    }

    public static String sanitizeRangeSet(String string) {
        return string.replace("\u2025", "..");
    }

    @API(since="1.22", status=API.Status.EXPERIMENTAL)
    public static Matcher<String> containsWithoutNodeIds(String value) {
        return Matchers.compose(StringContains.containsString((String)value), Matchers::trimNodeIds);
    }

    public static Matcher<String> containsStringLinux(String value) {
        return Matchers.compose(StringContains.containsString((String)value), Util::toLinux);
    }

    public static String trimNodeIds(String s) {
        return PATTERN.matcher(s).replaceAll("");
    }

    public static Matcher<? super Throwable> expectThrowable(final Throwable expected) {
        return new BaseMatcher<Throwable>(){

            public boolean matches(Object item) {
                if (!(item instanceof Throwable)) {
                    return false;
                }
                Throwable error = (Throwable)item;
                return expected != null && Objects.equals(error.getClass(), expected.getClass()) && Objects.equals(error.getMessage(), expected.getMessage());
            }

            public void describeTo(Description description) {
                description.appendText("is ").appendText(expected.toString());
            }
        };
    }

    public static Matcher<Charset> isCharset(final String charsetName) {
        return new TypeSafeMatcher<Charset>(){

            public void describeTo(Description description) {
                description.appendText("is charset ").appendText(charsetName);
            }

            protected boolean matchesSafely(Charset item) {
                return item.name().equals(charsetName);
            }
        };
    }

    public static <T> Matcher<Iterable<T>> sortsAs(String value) {
        return Matchers.compose(CoreMatchers.equalTo((Object)value), item -> {
            ArrayList<String> strings = new ArrayList<String>();
            for (Object t : item) {
                strings.add(t.toString());
            }
            Collections.sort(strings);
            return ((Object)strings).toString();
        });
    }

    public static Matcher<Object> primitiveArrayWithSize(final int i) {
        return new CustomTypeSafeMatcher<Object>("array with size " + i){

            protected boolean matchesSafely(Object o) {
                return o.getClass().isArray() && Array.getLength(o) == i;
            }
        };
    }

    @SafeVarargs
    public static <E> Matcher<Object> isListOf(E ... es) {
        return CoreMatchers.is(Arrays.asList(es));
    }

    private static class ComposingMatcher<F, T>
    extends TypeSafeMatcher<F> {
        private final Matcher<T> matcher;
        private final Function<F, T> f;

        ComposingMatcher(Matcher<T> matcher, Function<F, T> f) {
            this.matcher = matcher;
            this.f = f;
        }

        protected boolean matchesSafely(F item) {
            return Unsafe.matches(this.matcher, this.f.apply(item));
        }

        public void describeTo(Description description) {
            this.matcher.describeTo(description);
        }

        protected void describeMismatchSafely(F item, Description mismatchDescription) {
            mismatchDescription.appendText("was ").appendValue(this.f.apply(item));
        }
    }

    public static class IsWithin<T extends Number>
    extends BaseMatcher<T> {
        private final T expectedValue;
        private final double epsilon;

        public IsWithin(T expectedValue, double epsilon) {
            Preconditions.checkArgument((epsilon >= 0.0 ? 1 : 0) != 0);
            this.expectedValue = expectedValue;
            this.epsilon = epsilon;
        }

        public boolean matches(Object actualValue) {
            return IsWithin.isWithin(actualValue, this.expectedValue, this.epsilon);
        }

        public void describeTo(Description description) {
            description.appendValue((Object)(this.expectedValue + " +/-" + this.epsilon));
        }

        private static boolean isWithin(Object actual, Number expected, double epsilon) {
            if (actual == null) {
                return expected == null;
            }
            if (actual.equals(expected)) {
                return true;
            }
            double a = ((Number)actual).doubleValue();
            double min = expected.doubleValue() - epsilon;
            double max = expected.doubleValue() + epsilon;
            return min <= a && a <= max;
        }
    }
}

