/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSortedSet;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.calcite.util.Sources;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.Version;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;

public abstract class TestUtil {
    private static final Pattern LINE_BREAK_PATTERN = Pattern.compile("\r\n|\r|\n");
    private static final Pattern TAB_PATTERN = Pattern.compile("\t");
    private static final String LINE_BREAK = "\\\\n\"" + Util.LINE_SEPARATOR + " + \"";
    private static final String JAVA_VERSION = System.getProperties().getProperty("java.version");
    public static final Version AVATICA_VERSION = Version.of((String)Util.first((Object)System.getProperty("calcite.avatica.version"), (Object)"0"));
    private static final Supplier<Integer> GUAVA_MAJOR_VERSION = Suppliers.memoize(TestUtil::computeGuavaMajorVersion);
    private static final Pattern TRAILING_ZERO_PATTERN = Pattern.compile("-?[0-9]+\\.([0-9]*[1-9])?(00000*[0-9][0-9]?)");
    private static final Pattern TRAILING_NINE_PATTERN = Pattern.compile("-?[0-9]+\\.([0-9]*[0-8])?(99999*[0-9][0-9]?)");

    public static void assertEqualsVerbose(String expected, String actual) {
        Assertions.assertEquals((Object)expected, (Object)actual, () -> "Expected:\n" + expected + "\nActual:\n" + actual + "\nActual java:\n" + TestUtil.toJavaString(actual) + '\n');
    }

    public static void assertThatScientific(String value, Matcher<String> matcher) {
        double d = Double.parseDouble(value);
        MatcherAssert.assertThat((Object)Util.toScientificNotation((Double)d), matcher);
    }

    public static String quoteForJava(String s) {
        s = Util.replace((String)s, (String)"\\", (String)"\\\\");
        s = Util.replace((String)s, (String)"\"", (String)"\\\"");
        s = LINE_BREAK_PATTERN.matcher(s).replaceAll(LINE_BREAK);
        s = TAB_PATTERN.matcher(s).replaceAll("\\\\t");
        s = "\"" + s + "\"";
        String spurious = " + \n\"\"";
        if (s.endsWith(" + \n\"\"")) {
            s = s.substring(0, s.length() - " + \n\"\"".length());
        }
        return s;
    }

    public static String toJavaString(String s) {
        String spurious;
        s = Util.replace((String)s, (String)"\"", (String)"\\\"");
        s = LINE_BREAK_PATTERN.matcher(s).replaceAll(LINE_BREAK);
        s = TAB_PATTERN.matcher(s).replaceAll("\\\\t");
        s = "\"" + s + "\"";
        if (s.endsWith(spurious = "\n \\+ \"\"")) {
            s = s.substring(0, s.length() - spurious.length());
        }
        return s;
    }

    public static String fold(String ... strings) {
        StringBuilder buf = new StringBuilder();
        for (String string : strings) {
            buf.append(string);
            buf.append('\n');
        }
        return buf.toString();
    }

    public static String escapeString(String s) {
        return TestUtil.escapeString(new StringBuilder(), s).toString();
    }

    public static StringBuilder escapeString(StringBuilder buf, String s) {
        buf.append('\"');
        int n = s.length();
        int lastChar = 0;
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    buf.append("\\\\");
                    break;
                }
                case '\"': {
                    buf.append("\\\"");
                    break;
                }
                case '\n': {
                    buf.append("\\n");
                    break;
                }
                case '\r': {
                    if (lastChar == 10) break;
                    buf.append("\\r");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            lastChar = c;
        }
        return buf.append('\"');
    }

    public static String quotePattern(String s) {
        return s.replace("\\", "\\\\").replace(".", "\\.").replace("+", "\\+").replace("{", "\\{").replace("}", "\\}").replace("|", "\\||").replace("$", "\\$").replace("?", "\\?").replace("*", "\\*").replace("(", "\\(").replace(")", "\\)").replace("[", "\\[").replace("]", "\\]").replace("^", "\\^");
    }

    public static String correctRoundedFloat(String s) {
        java.util.regex.Matcher m2;
        if (s == null) {
            return s;
        }
        java.util.regex.Matcher m = TRAILING_ZERO_PATTERN.matcher(s);
        if (m.matches()) {
            s = s.substring(0, s.length() - m.group(2).length());
        }
        if ((m2 = TRAILING_NINE_PATTERN.matcher(s)).matches() && (s = s.substring(0, s.length() - m2.group(2).length())).length() > 0) {
            char c = s.charAt(s.length() - 1);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': {
                    s = s.substring(0, s.length() - 1) + (char)(c + '\u0001');
                    break;
                }
            }
        }
        return s;
    }

    public static int getJavaMajorVersion() {
        return TestUtil.majorVersionFromString(JAVA_VERSION);
    }

    @VisibleForTesting
    static int majorVersionFromString(String version) {
        Objects.requireNonNull(version, "version");
        if (version.startsWith("1.")) {
            String[] versions = version.split("\\.");
            return Integer.parseInt(versions[1]);
        }
        java.util.regex.Matcher matcher = Pattern.compile("^\\d+").matcher(version);
        if (!matcher.lookingAt()) {
            throw new IllegalArgumentException("Can't parse (detect) JDK version from " + version);
        }
        return Integer.parseInt(matcher.group());
    }

    public static int getGuavaMajorVersion() {
        return GUAVA_MAJOR_VERSION.get();
    }

    private static int computeGuavaMajorVersion() {
        return new VersionChecker().tryClass((int)2, (String)"com.google.common.collect.ImmutableList").tryClass((int)14, (String)"com.google.common.reflect.Parameter").tryClass((int)17, (String)"com.google.common.base.VerifyException").tryClass((int)21, (String)"com.google.common.io.RecursiveDeleteOption").tryClass((int)23, (String)"com.google.common.util.concurrent.FluentFuture").tryClass((int)26, (String)"com.google.common.util.concurrent.ExecutionSequencer").bestVersion;
    }

    public static String getJavaVirtualMachineVendor() {
        return System.getProperty("java.vm.vendor");
    }

    public static File getBaseDir(Class<?> klass) {
        URL resource = klass.getResource(klass.getSimpleName() + ".class");
        File classFile = Sources.of((URL)Objects.requireNonNull(resource, "resource")).file();
        File file = classFile.getAbsoluteFile();
        for (int i = 0; i < 42 && !TestUtil.isProjectDir(file); ++i) {
            file = file.getParentFile();
        }
        if (!TestUtil.isProjectDir(file)) {
            Assertions.fail((String)("Could not find pom.xml, build.gradle.kts or gradle.properties. Started with " + classFile.getAbsolutePath() + ", the current path is " + file.getAbsolutePath()));
        }
        return file.getParentFile();
    }

    private static boolean isProjectDir(File dir) {
        return new File(dir, "pom.xml").isFile() || new File(dir, "build.gradle.kts").isFile() || new File(dir, "gradle.properties").isFile();
    }

    public static <E extends Comparable<E>> SortedSet<E> outOfOrderItems(List<E> list) {
        Comparable previous = null;
        ImmutableSortedSet.Builder b = ImmutableSortedSet.naturalOrder();
        for (Comparable e : list) {
            if (previous != null && previous.compareTo(e) > 0) {
                b.add((Object)e);
            }
            previous = e;
        }
        return b.build();
    }

    public static boolean hasMessage(Throwable t, String substring) {
        while (t != null) {
            String message = t.getMessage();
            if (message != null && message.contains(substring)) {
                return true;
            }
            t = t.getCause();
        }
        return false;
    }

    public static <E extends Throwable> RuntimeException rethrow(Throwable e) throws E {
        if (e instanceof InvocationTargetException) {
            e = e.getCause();
        }
        throw e;
    }

    public static <E extends Throwable> RuntimeException rethrow(Throwable e, String message) throws E {
        e.addSuppressed(new ExtraInformation(message));
        throw e;
    }

    public static String printStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    private static class VersionChecker {
        int bestVersion = -1;

        private VersionChecker() {
        }

        VersionChecker tryClass(int version, String className) {
            try {
                Class.forName(className);
                this.bestVersion = Math.max(version, this.bestVersion);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return this;
        }
    }

    private static class ExtraInformation
    extends Throwable {
        ExtraInformation(String message) {
            super(message);
        }
    }
}

