/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.calcite.avatica.ConnectionProperty;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.ConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;

public abstract class ConnectionFactories {
    private static final ConnectionFactory EMPTY = new MapConnectionFactory((ImmutableMap<String, String>)ImmutableMap.of(), (ImmutableList<CalciteAssert.ConnectionPostProcessor>)ImmutableList.of());

    private ConnectionFactories() {
    }

    public static ConnectionFactory empty() {
        return EMPTY;
    }

    public static ConnectionFactory pool(ConnectionFactory connectionFactory) {
        return connectionFactory instanceof PoolingConnectionFactory ? connectionFactory : new PoolingConnectionFactory(connectionFactory);
    }

    public static CalciteAssert.ConnectionPostProcessor add(CalciteAssert.SchemaSpec schemaSpec) {
        return new AddSchemaSpecPostProcessor(schemaSpec);
    }

    public static CalciteAssert.ConnectionPostProcessor add(String name, Schema schema) {
        return new AddSchemaPostProcessor(name, schema);
    }

    public static CalciteAssert.ConnectionPostProcessor setDefault(String schema) {
        return new DefaultSchemaPostProcessor(schema);
    }

    public static CalciteAssert.ConnectionPostProcessor addType(String name, RelProtoDataType protoDataType) {
        return new AddTypePostProcessor(name, protoDataType);
    }

    private static class PoolingConnectionFactory
    implements ConnectionFactory {
        private final PoolingDataSource<PoolableConnection> dataSource;

        PoolingConnectionFactory(ConnectionFactory factory) {
            PoolableConnectionFactory connectionFactory = new PoolableConnectionFactory(factory::createConnection, null);
            connectionFactory.setRollbackOnReturn(false);
            this.dataSource = new PoolingDataSource((ObjectPool)new GenericObjectPool((PooledObjectFactory)connectionFactory));
        }

        @Override
        public Connection createConnection() throws SQLException {
            return this.dataSource.getConnection();
        }
    }

    private static class AddSchemaSpecPostProcessor
    implements CalciteAssert.ConnectionPostProcessor {
        private final CalciteAssert.SchemaSpec schemaSpec;

        AddSchemaSpecPostProcessor(CalciteAssert.SchemaSpec schemaSpec) {
            this.schemaSpec = schemaSpec;
        }

        @Override
        public Connection apply(Connection connection) throws SQLException {
            CalciteConnection con = connection.unwrap(CalciteConnection.class);
            SchemaPlus rootSchema = con.getRootSchema();
            switch (this.schemaSpec) {
                case CLONE_FOODMART: 
                case JDBC_FOODMART_WITH_LATTICE: {
                    CalciteAssert.addSchema(rootSchema, CalciteAssert.SchemaSpec.JDBC_FOODMART);
                }
            }
            CalciteAssert.addSchema(rootSchema, this.schemaSpec);
            con.setSchema(this.schemaSpec.schemaName);
            return connection;
        }
    }

    private static class DefaultSchemaPostProcessor
    implements CalciteAssert.ConnectionPostProcessor {
        private final String name;

        DefaultSchemaPostProcessor(String name) {
            this.name = name;
        }

        @Override
        public Connection apply(Connection connection) throws SQLException {
            connection.setSchema(this.name);
            return connection;
        }
    }

    private static class AddTypePostProcessor
    implements CalciteAssert.ConnectionPostProcessor {
        private final String name;
        private final RelProtoDataType protoDataType;

        AddTypePostProcessor(String name, RelProtoDataType protoDataType) {
            this.name = Objects.requireNonNull(name, "name");
            this.protoDataType = Objects.requireNonNull(protoDataType, "protoDataType");
        }

        @Override
        public Connection apply(Connection connection) throws SQLException {
            CalciteConnection con = connection.unwrap(CalciteConnection.class);
            SchemaPlus rootSchema = con.getRootSchema();
            rootSchema.add(this.name, this.protoDataType);
            return connection;
        }
    }

    private static class AddSchemaPostProcessor
    implements CalciteAssert.ConnectionPostProcessor {
        private final String name;
        private final Schema schema;

        AddSchemaPostProcessor(String name, Schema schema) {
            this.name = Objects.requireNonNull(name, "name");
            this.schema = Objects.requireNonNull(schema, "schema");
        }

        @Override
        public Connection apply(Connection connection) throws SQLException {
            CalciteConnection con = connection.unwrap(CalciteConnection.class);
            SchemaPlus rootSchema = con.getRootSchema();
            rootSchema.add(this.name, this.schema);
            connection.setSchema(this.name);
            return connection;
        }
    }

    private static class MapConnectionFactory
    implements ConnectionFactory {
        private final ImmutableMap<String, String> map;
        private final ImmutableList<CalciteAssert.ConnectionPostProcessor> postProcessors;

        MapConnectionFactory(ImmutableMap<String, String> map, ImmutableList<CalciteAssert.ConnectionPostProcessor> postProcessors) {
            this.map = Objects.requireNonNull(map, "map");
            this.postProcessors = Objects.requireNonNull(postProcessors, "postProcessors");
        }

        public boolean equals(Object obj) {
            return this == obj || obj.getClass() == MapConnectionFactory.class && ((MapConnectionFactory)obj).map.equals(this.map) && ((MapConnectionFactory)obj).postProcessors.equals(this.postProcessors);
        }

        public int hashCode() {
            return Objects.hash(this.map, this.postProcessors);
        }

        @Override
        public Connection createConnection() throws SQLException {
            Properties info = new Properties();
            for (Map.Entry entry : this.map.entrySet()) {
                info.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            Connection connection = DriverManager.getConnection("jdbc:calcite:", info);
            for (CalciteAssert.ConnectionPostProcessor postProcessor : this.postProcessors) {
                connection = postProcessor.apply(connection);
            }
            return connection;
        }

        @Override
        public ConnectionFactory with(String property, Object value) {
            return new MapConnectionFactory((ImmutableMap<String, String>)FlatLists.append(this.map, (Object)property, (Object)value.toString()), this.postProcessors);
        }

        @Override
        public ConnectionFactory with(ConnectionProperty property, Object value) {
            if (!property.type().valid(value, property.valueClass())) {
                throw new IllegalArgumentException();
            }
            return this.with(property.camelName(), (Object)value.toString());
        }

        @Override
        public ConnectionFactory with(CalciteAssert.ConnectionPostProcessor postProcessor) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(this.postProcessors);
            builder.add((Object)postProcessor);
            return new MapConnectionFactory(this.map, (ImmutableList<CalciteAssert.ConnectionPostProcessor>)builder.build());
        }
    }
}

