/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.ContextSqlValidator;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.schema.impl.ViewTable;
import org.apache.calcite.schema.impl.ViewTableMacro;
import org.apache.calcite.server.DdlExecutorImpl;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.ddl.SqlColumnDeclaration;
import org.apache.calcite.sql.ddl.SqlCreateTable;
import org.apache.calcite.sql.ddl.SqlCreateView;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.test.AbstractModifiableTable;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MockDdlExecutor
extends DdlExecutorImpl {
    static Pair<CalciteSchema, String> schema(CalcitePrepare.Context context, boolean mutable, SqlIdentifier id) {
        String name;
        List path;
        if (id.isSimple()) {
            path = context.getDefaultSchemaPath();
            name = id.getSimple();
        } else {
            path = Util.skipLast((List)id.names);
            name = (String)Util.last((List)id.names);
        }
        CalciteSchema schema = mutable ? context.getMutableRootSchema() : context.getRootSchema();
        for (String p : path) {
            schema = Objects.requireNonNull(schema.getSubSchema(p, true));
        }
        return Pair.of((Object)schema, (Object)name);
    }

    static SqlNode renameColumns(@Nullable SqlNodeList columnList, SqlNode query) {
        if (columnList == null) {
            return query;
        }
        SqlParserPos p = query.getParserPosition();
        SqlNodeList selectList = SqlNodeList.SINGLETON_STAR;
        SqlCall from = SqlStdOperatorTable.AS.createCall(p, (List)ImmutableList.builder().add((Object)query).add((Object)new SqlIdentifier("_", p)).addAll((Iterable)columnList).build());
        return new SqlSelect(p, null, selectList, (SqlNode)from, null, null, null, null, null, null, null, null, null);
    }

    public void execute(SqlCreateTable create, CalcitePrepare.Context context) {
        RelDataType queryRowType;
        CalciteSchema schema = Schemas.subSchema((CalciteSchema)context.getRootSchema(), (Iterable)context.getDefaultSchemaPath());
        Objects.requireNonNull(schema, "schema");
        JavaTypeFactory typeFactory = context.getTypeFactory();
        if (create.query != null) {
            String sql = create.query.toSqlString(CalciteSqlDialect.DEFAULT).getSql();
            ViewTableMacro viewTableMacro = ViewTable.viewMacro((SchemaPlus)schema.plus(), (String)sql, (List)schema.path(null), (List)context.getObjectPath(), (Boolean)false);
            TranslatableTable x = viewTableMacro.apply((List)ImmutableList.of());
            queryRowType = x.getRowType((RelDataTypeFactory)typeFactory);
            if (create.columnList != null && queryRowType.getFieldCount() != create.columnList.size()) {
                throw SqlUtil.newContextException((SqlParserPos)create.columnList.getParserPosition(), (Resources.ExInst)Static.RESOURCE.columnCountMismatch());
            }
        } else {
            queryRowType = null;
        }
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        if (create.columnList != null) {
            ContextSqlValidator validator = new ContextSqlValidator(context, false);
            this.forEachNameType(create, (arg_0, arg_1) -> MockDdlExecutor.lambda$execute$0((RelDataTypeFactory.Builder)builder, (SqlValidator)validator, arg_0, arg_1));
        } else {
            if (queryRowType == null) {
                throw SqlUtil.newContextException((SqlParserPos)create.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.createTableRequiresColumnList());
            }
            builder.addAll((Iterable)queryRowType.getFieldList());
        }
        RelDataType rowType = builder.build();
        schema.add(create.name.getSimple(), (Table)new MutableArrayTable(create.name.getSimple(), RelDataTypeImpl.proto((RelDataType)rowType)));
        if (create.query != null) {
            MockDdlExecutor.populate(create.name, create.query, context);
        }
    }

    public void execute(SqlCreateView create, CalcitePrepare.Context context) {
        Pair<CalciteSchema, String> pair = MockDdlExecutor.schema(context, true, create.name);
        SchemaPlus schemaPlus = ((CalciteSchema)pair.left).plus();
        for (Function function : schemaPlus.getFunctions((String)pair.right)) {
            if (!function.getParameters().isEmpty()) continue;
            if (!create.getReplace()) {
                throw SqlUtil.newContextException((SqlParserPos)create.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.viewExists((String)pair.right));
            }
            ((CalciteSchema)pair.left).removeFunction((String)pair.right);
        }
        SqlNode q = MockDdlExecutor.renameColumns(create.columnList, create.query);
        String sql = q.toSqlString(CalciteSqlDialect.DEFAULT).getSql();
        ViewTableMacro viewTableMacro = ViewTable.viewMacro((SchemaPlus)schemaPlus, (String)sql, (List)((CalciteSchema)pair.left).path(null), (List)context.getObjectPath(), (Boolean)false);
        TranslatableTable x = viewTableMacro.apply((List)ImmutableList.of());
        Util.discard((Object)x);
        schemaPlus.add((String)pair.right, (Function)viewTableMacro);
    }

    protected static void populate(SqlIdentifier name, SqlNode query, CalcitePrepare.Context context) {
        FrameworkConfig config = Frameworks.newConfigBuilder().defaultSchema(Objects.requireNonNull(Schemas.subSchema((CalciteSchema)context.getRootSchema(), (Iterable)context.getDefaultSchemaPath())).plus()).build();
        Planner planner = Frameworks.getPlanner((FrameworkConfig)config);
        try {
            StringBuilder buf = new StringBuilder();
            SqlPrettyWriter w = new SqlPrettyWriter(SqlPrettyWriter.config().withDialect(CalciteSqlDialect.DEFAULT).withAlwaysUseParentheses(false), buf);
            buf.append("INSERT INTO ");
            name.unparse((SqlWriter)w, 0, 0);
            buf.append(" ");
            query.unparse((SqlWriter)w, 0, 0);
            String sql = buf.toString();
            SqlNode query1 = planner.parse(sql);
            SqlNode query2 = planner.validate(query1);
            RelRoot r = planner.rel(query2);
            PreparedStatement prepare = context.getRelRunner().prepareStatement(r.rel);
            int rowCount = prepare.executeUpdate();
            Util.discard((int)rowCount);
            prepare.close();
        }
        catch (SQLException | SqlParseException | RelConversionException | ValidationException e) {
            throw Util.throwAsRuntime((Throwable)e);
        }
    }

    protected void forEachNameType(SqlCreateTable createTable, BiConsumer<SqlIdentifier, SqlDataTypeSpec> consumer) {
        Objects.requireNonNull(createTable.columnList).forEach(sqlNode -> {
            if (!(sqlNode instanceof SqlColumnDeclaration)) {
                throw new AssertionError(sqlNode.getClass());
            }
            SqlColumnDeclaration d = (SqlColumnDeclaration)sqlNode;
            consumer.accept(d.name, d.dataType);
        });
    }

    private static /* synthetic */ void lambda$execute$0(RelDataTypeFactory.Builder builder, SqlValidator validator, SqlIdentifier name, SqlDataTypeSpec typeSpec) {
        builder.add(name.getSimple(), typeSpec.deriveType(validator, true));
    }

    private static class MutableArrayTable
    extends AbstractModifiableTable {
        final List list = new ArrayList();
        private final RelProtoDataType protoRowType;

        MutableArrayTable(String name, RelProtoDataType protoRowType) {
            super(name);
            this.protoRowType = protoRowType;
        }

        public Collection getModifiableCollection() {
            return this.list;
        }

        public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
            return new AbstractTableQueryable<T>(queryProvider, schema, (QueryableTable)this, tableName){

                public Enumerator<T> enumerator() {
                    return Linq4j.enumerator((Collection)list);
                }
            };
        }

        public Type getElementType() {
            return Object[].class;
        }

        public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
            return Schemas.tableExpression((SchemaPlus)schema, (Type)this.getElementType(), (String)tableName, (Class)clazz);
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return (RelDataType)this.protoRowType.apply((Object)typeFactory);
        }
    }
}

