/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.io.PatternFilenameFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.hydromatic.quidem.CommandHandler;
import net.hydromatic.quidem.Quidem;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.ConnectionProperty;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.test.ConnectionSpec;
import org.apache.calcite.test.DiffTestCase;
import org.apache.calcite.test.ReflectiveSchemaWithoutRowCount;
import org.apache.calcite.test.schemata.catchall.CatchallSchema;
import org.apache.calcite.util.Closer;
import org.apache.calcite.util.Sources;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class QuidemTest {
    private static final Pattern PATTERN = Pattern.compile("\\.iq$");

    private static @Nullable Object getEnv(String varName) {
        switch (varName) {
            case "jdk18": {
                return System.getProperty("java.version").startsWith("1.8");
            }
            case "fixed": {
                return v -> {
                    switch (v) {
                        case "calcite1045": {
                            return false;
                        }
                        case "calcite1048": {
                            return false;
                        }
                    }
                    return null;
                };
            }
            case "not": {
                return v -> {
                    Object o = QuidemTest.getEnv(v);
                    if (o instanceof Function) {
                        Function f = (Function)o;
                        return v2 -> (Boolean)f.apply(v2) == false;
                    }
                    return null;
                };
            }
        }
        return null;
    }

    private @Nullable Method findMethod(String path) {
        Method m;
        String path1 = path.replace(File.separatorChar, '_');
        String path2 = PATTERN.matcher(path1).replaceAll("");
        String methodName = AvaticaUtils.toCamelCase((String)("test_" + path2));
        try {
            m = this.getClass().getMethod(methodName, String.class);
        }
        catch (NoSuchMethodException e) {
            m = null;
        }
        return m;
    }

    protected static Collection<String> data(String first) {
        URL inUrl = QuidemTest.class.getResource("/" + QuidemTest.n2u(first));
        File firstFile = Sources.of((URL)Objects.requireNonNull(inUrl, "inUrl")).file();
        int commonPrefixLength = firstFile.getAbsolutePath().length() - first.length();
        File dir = firstFile.getParentFile();
        ArrayList<String> paths = new ArrayList<String>();
        PatternFilenameFilter filter = new PatternFilenameFilter(".*\\.iq$");
        for (File f : (File[])Util.first((Object)dir.listFiles((FilenameFilter)filter), (Object)new File[0])) {
            paths.add(f.getAbsolutePath().substring(commonPrefixLength));
        }
        return paths;
    }

    protected void checkRun(String path) throws Exception {
        String diff;
        File outFile;
        File inFile;
        File f = new File(path);
        if (f.isAbsolute()) {
            inFile = f;
            outFile = new File(path + ".out");
        } else {
            URL inUrl = QuidemTest.class.getResource("/" + QuidemTest.n2u(path));
            inFile = Sources.of((URL)Objects.requireNonNull(inUrl, "inUrl")).file();
            outFile = QuidemTest.replaceDir(inFile, "resources", "quidem");
        }
        Util.discard((boolean)outFile.getParentFile().mkdirs());
        try (BufferedReader reader = Util.reader((File)inFile);
             PrintWriter writer = Util.printWriter((File)outFile);
             Closer closer = new Closer();){
            Quidem.Config config = Quidem.configBuilder().withReader((Reader)reader).withWriter((Writer)writer).withConnectionFactory(this.createConnectionFactory()).withCommandHandler(this.createCommandHandler()).withPropertyHandler((propertyName, value) -> {
                boolean b;
                if (propertyName.equals("bindable")) {
                    b = value instanceof Boolean && (Boolean)value != false;
                    closer.add((AutoCloseable)Hook.ENABLE_BINDABLE.addThread(Hook.propertyJ((Object)b)));
                }
                if (propertyName.equals("expand")) {
                    b = value instanceof Boolean && (Boolean)value != false;
                    closer.add((AutoCloseable)Prepare.THREAD_EXPAND.push((Object)b));
                }
                if (propertyName.equals("insubquerythreshold")) {
                    int thresholdValue = ((BigDecimal)value).intValue();
                    closer.add((AutoCloseable)Prepare.THREAD_INSUBQUERY_THRESHOLD.push((Object)thresholdValue));
                }
            }).withEnv(QuidemTest::getEnv).build();
            new Quidem(config).execute();
        }
        if (inFile.length() == 0L) {
            Assertions.fail((String)("Input file was empty: " + inFile + "\n"));
        }
        if (!(diff = DiffTestCase.diff(inFile, outFile)).isEmpty()) {
            Assertions.fail((String)("Files differ: " + outFile + " " + inFile + "\n" + diff));
        }
    }

    private static File replaceDir(File file, String target, String replacement) {
        return new File(QuidemTest.n2u(file.getAbsolutePath()).replace(QuidemTest.n2u('/' + target + '/'), QuidemTest.n2u('/' + replacement + '/')));
    }

    protected CommandHandler createCommandHandler() {
        return Quidem.EMPTY_COMMAND_HANDLER;
    }

    protected Quidem.ConnectionFactory createConnectionFactory() {
        return new QuidemConnectionFactory();
    }

    private static String n2u(String s) {
        return File.separatorChar == '\\' ? s.replace('\\', '/') : s;
    }

    @ParameterizedTest
    @MethodSource(value={"getPath"})
    public void test(String path) throws Exception {
        Method method = this.findMethod(path);
        if (method != null) {
            try {
                method.invoke((Object)this, path);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw e;
            }
        } else {
            this.checkRun(path);
        }
    }

    protected abstract Collection<String> getPath();

    protected static class QuidemConnectionFactory
    implements Quidem.ConnectionFactory {
        protected QuidemConnectionFactory() {
        }

        public Connection connect(String name) throws Exception {
            return this.connect(name, false);
        }

        public Connection connect(String name, boolean reference) throws Exception {
            if (reference) {
                if (name.equals("foodmart")) {
                    ConnectionSpec db = CalciteAssert.DatabaseInstance.HSQLDB.foodmart;
                    Connection connection = DriverManager.getConnection(db.url, db.username, db.password);
                    connection.setSchema("foodmart");
                    return connection;
                }
                return null;
            }
            switch (name) {
                case "hr": {
                    return CalciteAssert.hr().connect();
                }
                case "aux": {
                    return CalciteAssert.hr().with(CalciteAssert.Config.AUX).connect();
                }
                case "foodmart": {
                    return CalciteAssert.that().with(CalciteAssert.Config.FOODMART_CLONE).connect();
                }
                case "geo": {
                    return CalciteAssert.that().with(CalciteAssert.Config.GEO).connect();
                }
                case "scott": {
                    return CalciteAssert.that().with(CalciteAssert.Config.SCOTT).connect();
                }
                case "jdbc_scott": {
                    return CalciteAssert.that().with(CalciteAssert.Config.JDBC_SCOTT).connect();
                }
                case "steelwheels": {
                    return CalciteAssert.that().with(CalciteAssert.SchemaSpec.STEELWHEELS).connect();
                }
                case "jdbc_steelwheels": {
                    return CalciteAssert.that().with(CalciteAssert.SchemaSpec.JDBC_STEELWHEELS).connect();
                }
                case "post": {
                    return CalciteAssert.that().with(CalciteAssert.Config.REGULAR).with(CalciteAssert.SchemaSpec.POST).connect();
                }
                case "post-postgresql": {
                    return CalciteAssert.that().with((ConnectionProperty)CalciteConnectionProperty.FUN, (Object)"standard,postgresql").with(CalciteAssert.Config.REGULAR).with(CalciteAssert.SchemaSpec.POST).connect();
                }
                case "post-big-query": {
                    return CalciteAssert.that().with((ConnectionProperty)CalciteConnectionProperty.FUN, (Object)"standard,bigquery").with(CalciteAssert.Config.REGULAR).with(CalciteAssert.SchemaSpec.POST).connect();
                }
                case "mysqlfunc": {
                    return CalciteAssert.that().with((ConnectionProperty)CalciteConnectionProperty.FUN, (Object)"mysql").with(CalciteAssert.Config.REGULAR).with(CalciteAssert.SchemaSpec.POST).connect();
                }
                case "sparkfunc": {
                    return CalciteAssert.that().with((ConnectionProperty)CalciteConnectionProperty.FUN, (Object)"spark").with(CalciteAssert.Config.REGULAR).with(CalciteAssert.SchemaSpec.POST).connect();
                }
                case "oraclefunc": {
                    return CalciteAssert.that().with((ConnectionProperty)CalciteConnectionProperty.FUN, (Object)"oracle").with(CalciteAssert.Config.REGULAR).connect();
                }
                case "mssqlfunc": {
                    return CalciteAssert.that().with((ConnectionProperty)CalciteConnectionProperty.FUN, (Object)"mssql").with(CalciteAssert.Config.REGULAR).connect();
                }
                case "catchall": {
                    return CalciteAssert.that().with((ConnectionProperty)CalciteConnectionProperty.TIME_ZONE, (Object)"UTC").withSchema("s", (Schema)new ReflectiveSchemaWithoutRowCount(new CatchallSchema())).connect();
                }
                case "orinoco": {
                    return CalciteAssert.that().with(CalciteAssert.SchemaSpec.ORINOCO).connect();
                }
                case "seq": {
                    Connection connection = CalciteAssert.that().withSchema("s", (Schema)new AbstractSchema()).connect();
                    ((SchemaPlus)connection.unwrap(CalciteConnection.class).getRootSchema().subSchemas().get("s")).add("my_seq", (Table)new AbstractTable(){

                        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                            return typeFactory.builder().add("$seq", SqlTypeName.BIGINT).build();
                        }

                        public Schema.TableType getJdbcTableType() {
                            return Schema.TableType.SEQUENCE;
                        }
                    });
                    return connection;
                }
                case "bookstore": {
                    return CalciteAssert.that().with(CalciteAssert.SchemaSpec.BOOKSTORE).connect();
                }
            }
            throw new RuntimeException("unknown connection '" + name + "'");
        }
    }
}

