/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.TestUtil;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.incava.diff.Diff;
import org.incava.diff.Difference;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

public abstract class DiffTestCase {
    private final String testCaseName;
    protected @Nullable File logFile;
    protected @Nullable File refFile;
    protected @Nullable OutputStream logOutputStream;
    private String diffMasks;
    @Nullable Pattern compiledDiffPattern;
    @Nullable java.util.regex.Matcher compiledDiffMatcher;
    private String ignorePatterns;
    @Nullable Pattern compiledIgnorePattern;
    @Nullable java.util.regex.Matcher compiledIgnoreMatcher;
    private boolean verbose;

    protected DiffTestCase(String testCaseName) {
        this.testCaseName = testCaseName;
        this.diffMasks = "";
        this.ignorePatterns = "";
        this.compiledIgnoreMatcher = null;
        this.compiledDiffMatcher = null;
        String verboseVal = System.getProperty(DiffTestCase.class.getName() + ".verbose");
        if (verboseVal != null) {
            this.verbose = true;
        }
    }

    @BeforeEach
    protected void setUp() {
        this.diffMasks = "";
        this.ignorePatterns = "";
        this.compiledIgnoreMatcher = null;
        this.compiledDiffMatcher = null;
    }

    @AfterEach
    protected void tearDown() throws IOException {
        if (this.logOutputStream != null) {
            this.logOutputStream.close();
            this.logOutputStream = null;
        }
    }

    protected Writer openTestLog() throws Exception {
        File testClassDir = new File(this.getTestlogRoot(), ReflectUtil.getUnqualifiedClassName(this.getClass()));
        testClassDir.mkdirs();
        File testLogFile = new File(testClassDir, this.testCaseName);
        return new OutputStreamWriter(this.openTestLogOutputStream(testLogFile), StandardCharsets.UTF_8);
    }

    protected abstract File getTestlogRoot();

    protected OutputStream openTestLogOutputStream(File testFileSansExt) throws IOException {
        assert (this.logOutputStream == null);
        this.logFile = new File(testFileSansExt + ".log");
        this.logFile.delete();
        this.refFile = new File(testFileSansExt + ".ref");
        this.logOutputStream = Files.newOutputStream(this.logFile.toPath(), new OpenOption[0]);
        return this.logOutputStream;
    }

    protected void diffTestLog() throws IOException {
        if (this.logOutputStream == null) {
            throw new IllegalStateException();
        }
        this.logOutputStream.close();
        this.logOutputStream = null;
        if (this.refFile == null) {
            throw new IllegalStateException();
        }
        if (!this.refFile.exists()) {
            Assertions.fail((String)("Reference file " + this.refFile + " does not exist"));
        }
        if (this.logFile == null) {
            throw new IllegalStateException();
        }
        this.diffFile(this.logFile, this.refFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void diffFile(File logFile, File refFile) throws IOException {
        BufferedReader logReader = null;
        BufferedReader refReader = null;
        try {
            String diffMask = System.getProperty("diff.mask", null);
            if (diffMask != null) {
                this.addDiffMask(diffMask);
            }
            if ((diffMask = System.getProperty("diff_mask", null)) != null) {
                this.addDiffMask(diffMask);
            }
            logReader = Util.reader((File)logFile);
            refReader = Util.reader((File)refFile);
            LineNumberReader logLineReader = new LineNumberReader(logReader);
            LineNumberReader refLineReader = new LineNumberReader(refReader);
            while (true) {
                String logLine = logLineReader.readLine();
                String refLine = refLineReader.readLine();
                while (logLine != null && this.matchIgnorePatterns(logLine)) {
                    logLine = logLineReader.readLine();
                }
                while (refLine != null && this.matchIgnorePatterns(refLine)) {
                    refLine = refLineReader.readLine();
                }
                if (logLine == null || refLine == null) {
                    if (logLine != null) {
                        this.diffFail(logFile, logLineReader.getLineNumber());
                    }
                    if (refLine != null) {
                        this.diffFail(logFile, refLineReader.getLineNumber());
                    }
                    break;
                }
                if ((logLine = this.applyDiffMask(logLine)).equals(refLine = this.applyDiffMask(refLine))) continue;
                this.diffFail(logFile, logLineReader.getLineNumber());
            }
        }
        finally {
            if (logReader != null) {
                logReader.close();
            }
            if (refReader != null) {
                refReader.close();
            }
        }
        logFile.delete();
    }

    protected void addDiffMask(String mask) {
        this.diffMasks = this.diffMasks.isEmpty() ? mask : this.diffMasks + "|" + mask;
        this.compiledDiffPattern = Pattern.compile(this.diffMasks);
        this.compiledDiffMatcher = this.compiledDiffPattern.matcher("");
    }

    protected void addIgnorePattern(String javaPattern) {
        this.ignorePatterns = this.ignorePatterns.isEmpty() ? javaPattern : this.ignorePatterns + "|" + javaPattern;
        this.compiledIgnorePattern = Pattern.compile(this.ignorePatterns);
        this.compiledIgnoreMatcher = this.compiledIgnorePattern.matcher("");
    }

    private String applyDiffMask(String s) {
        if (this.compiledDiffMatcher != null) {
            if (this.compiledDiffPattern == null) {
                throw new AssertionError();
            }
            this.compiledDiffMatcher.reset(s);
            if (this.compiledDiffMatcher.find()) {
                return this.compiledDiffPattern.matcher(s).replaceAll("XYZZY");
            }
        }
        return s;
    }

    private boolean matchIgnorePatterns(String s) {
        if (this.compiledIgnoreMatcher != null) {
            this.compiledIgnoreMatcher.reset(s);
            return this.compiledIgnoreMatcher.matches();
        }
        return false;
    }

    private void diffFail(File logFile, int lineNumber) {
        String message = "diff detected at line " + lineNumber + " in " + logFile;
        if (this.verbose) {
            if (this.refFile == null) {
                throw new IllegalStateException();
            }
            if (DiffTestCase.inIde()) {
                MatcherAssert.assertThat((String)message, (Object)DiffTestCase.fileContents(logFile), (Matcher)CoreMatchers.is((Object)DiffTestCase.fileContents(this.refFile)));
            } else {
                String s = DiffTestCase.diff(this.refFile, logFile);
                Assertions.fail((String)(message + '\n' + s + '\n'));
            }
        }
        Assertions.fail((String)message);
    }

    private static boolean inIde() {
        Throwable runtimeException = new Throwable();
        runtimeException.fillInStackTrace();
        StackTraceElement[] stackTrace = runtimeException.getStackTrace();
        StackTraceElement lastStackTraceElement = stackTrace[stackTrace.length - 1];
        if (lastStackTraceElement.getClassName().equals("com.intellij.rt.execution.junit.JUnitStarter") && lastStackTraceElement.getMethodName().equals("main")) {
            return true;
        }
        return lastStackTraceElement.getClassName().equals("com.intellij.rt.execution.application.AppMain") && lastStackTraceElement.getMethodName().equals("main");
    }

    public static String diff(File file1, File file2) {
        List<String> lines1 = DiffTestCase.fileLines(file1);
        List<String> lines2 = DiffTestCase.fileLines(file2);
        return DiffTestCase.diffLines(lines1, lines2);
    }

    public static String diffLines(List<String> lines1, List<String> lines2) {
        Diff differencer = new Diff(lines1, lines2);
        List differences = differencer.execute();
        StringWriter sw = new StringWriter();
        int offset = 0;
        for (Difference d : differences) {
            int i;
            int as = d.getAddedStart() + 1;
            int ae = d.getAddedEnd() + 1;
            int ds = d.getDeletedStart() + 1;
            int de = d.getDeletedEnd() + 1;
            if (ae == 0) {
                if (de == 0) continue;
                sw.append(String.valueOf(ds));
                if (de > ds) {
                    sw.append(",").append(String.valueOf(de));
                }
                sw.append("d").append(String.valueOf(as - 1)).append('\n');
                for (i = ds - 1; i < de; ++i) {
                    sw.append("< ").append(lines1.get(i)).append('\n');
                }
                continue;
            }
            if (de == 0) {
                sw.append(String.valueOf(ds - 1)).append("a").append(String.valueOf(as));
                if (ae > as) {
                    sw.append(",").append(String.valueOf(ae));
                }
                sw.append('\n');
                for (i = as - 1; i < ae; ++i) {
                    sw.append("> ").append(lines2.get(i)).append('\n');
                }
                continue;
            }
            sw.append(String.valueOf(ds));
            if (de > ds) {
                sw.append(",").append(String.valueOf(de));
            }
            sw.append("c").append(String.valueOf(as));
            if (ae > as) {
                sw.append(",").append(String.valueOf(ae));
            }
            sw.append('\n');
            for (i = ds - 1; i < de; ++i) {
                sw.append("< ").append(lines1.get(i)).append('\n');
            }
            sw.append("---\n");
            for (i = as - 1; i < ae; ++i) {
                sw.append("> ").append(lines2.get(i)).append('\n');
            }
            offset = offset + (ae - as) - (de - ds);
        }
        return sw.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> fileLines(File file) {
        ArrayList<String> lines = new ArrayList<String>();
        try (LineNumberReader r = new LineNumberReader(Util.reader((File)file));){
            String line;
            while ((line = r.readLine()) != null) {
                lines.add(line);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw TestUtil.rethrow(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String fileContents(File file) {
        byte[] buf = new byte[2048];
        try (FileInputStream reader = new FileInputStream(file);){
            int readCount;
            ByteArrayOutputStream writer = new ByteArrayOutputStream();
            while ((readCount = reader.read(buf)) >= 0) {
                writer.write(buf, 0, readCount);
            }
            String string = writer.toString(StandardCharsets.UTF_8.name());
            return string;
        }
        catch (IOException e) {
            throw TestUtil.rethrow(e);
        }
    }

    protected void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected void setRefFileDiffMasks() {
        this.addDiffMask("\\$Id.*\\$");
        this.addDiffMask("0: \\bjdbc(:[^:>]+)+:>");
        this.addDiffMask("^(\\.\\s?)+>");
    }
}

