/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.calcite.DataContexts;
import org.apache.calcite.plan.AbstractRelOptPlanner;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.RelHintsPropagator;
import org.apache.calcite.plan.RelOptCostImpl;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexExecutorImpl;
import org.apache.calcite.util.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MockRelOptPlanner
extends AbstractRelOptPlanner {
    private RelNode root;
    private @Nullable RelOptRule rule;
    private RelNode transformationResult;
    private long metadataTimestamp = 0L;

    public MockRelOptPlanner(Context context) {
        super(RelOptCostImpl.FACTORY, context);
        this.setExecutor((RexExecutor)new RexExecutorImpl(DataContexts.EMPTY));
    }

    public void setRoot(RelNode rel) {
        this.root = rel;
    }

    public @Nullable RelNode getRoot() {
        return this.root;
    }

    public void clear() {
        super.clear();
        this.rule = null;
    }

    public List<RelOptRule> getRules() {
        return this.rule == null ? ImmutableList.of() : ImmutableList.of((Object)this.rule);
    }

    public boolean addRule(RelOptRule rule) {
        assert (this.rule == null) : "MockRelOptPlanner only supports a single rule";
        this.rule = rule;
        return false;
    }

    public boolean removeRule(RelOptRule rule) {
        return false;
    }

    public RelNode changeTraits(RelNode rel, RelTraitSet toTraits) {
        return rel;
    }

    public RelNode findBestExp() {
        if (this.rule != null) {
            this.matchRecursive(this.root, null, -1);
        }
        return this.root;
    }

    private boolean matchRecursive(RelNode rel, @Nullable RelNode parent, int ordinalInParent) {
        MockRuleCall call;
        ArrayList<RelNode> bindings = new ArrayList<RelNode>();
        if (MockRelOptPlanner.match(this.rule.getOperand(), rel, bindings) && this.rule.matches((RelOptRuleCall)(call = new MockRuleCall((RelOptPlanner)this, this.rule.getOperand(), bindings.toArray(new RelNode[0]))))) {
            this.rule.onMatch((RelOptRuleCall)call);
        }
        if (this.transformationResult != null) {
            if (parent == null) {
                this.root = this.transformationResult;
            } else {
                parent.replaceInput(ordinalInParent, this.transformationResult);
            }
            return true;
        }
        List children = rel.getInputs();
        for (int i = 0; i < children.size(); ++i) {
            if (!this.matchRecursive((RelNode)children.get(i), rel, i)) continue;
            return true;
        }
        return false;
    }

    private static boolean match(RelOptRuleOperand operand, RelNode rel, List<RelNode> bindings) {
        if (!operand.matches(rel)) {
            return false;
        }
        bindings.add(rel);
        switch (operand.childPolicy) {
            case ANY: {
                return true;
            }
        }
        List childOperands = operand.getChildOperands();
        List childRels = rel.getInputs();
        if (childOperands.size() != childRels.size()) {
            return false;
        }
        for (Pair pair : Pair.zip((List)childOperands, (List)childRels)) {
            if (MockRelOptPlanner.match((RelOptRuleOperand)pair.left, (RelNode)pair.right, bindings)) continue;
            return false;
        }
        return true;
    }

    public RelNode register(RelNode rel, @Nullable RelNode equivRel) {
        return rel;
    }

    public RelNode ensureRegistered(RelNode rel, RelNode equivRel) {
        return rel;
    }

    public boolean isRegistered(RelNode rel) {
        return true;
    }

    @Deprecated
    public long getRelMetadataTimestamp(RelNode rel) {
        return this.metadataTimestamp;
    }

    @Deprecated
    public void setRelMetadataTimestamp(long metadataTimestamp) {
        this.metadataTimestamp = metadataTimestamp;
    }

    private class MockRuleCall
    extends RelOptRuleCall {
        MockRuleCall(RelOptPlanner planner, RelOptRuleOperand operand, RelNode[] rels) {
            super(planner, operand, rels, Collections.emptyMap());
        }

        public void transformTo(RelNode rel, Map<RelNode, RelNode> equiv, RelHintsPropagator handler) {
            MockRelOptPlanner.this.transformationResult = rel;
        }
    }
}

