/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.benchmarks;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@Fork(value=1, jvmArgsPrepend={"-Xmx2048m"})
@Measurement(iterations=10, time=100, timeUnit=TimeUnit.MILLISECONDS)
@Warmup(iterations=10, time=100, timeUnit=TimeUnit.MILLISECONDS)
@Threads(value=1)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.Throughput})
public class StringConstructBenchmark {
    @Benchmark
    public StringBuilder initStringBuilder() {
        return new StringBuilder();
    }

    @Benchmark
    public StringWriter initStringWriter() {
        return new StringWriter();
    }

    @Benchmark
    public PrintWriter initPrintWriter(WriterState writerState) {
        return new PrintWriter(writerState.writer);
    }

    @Benchmark
    public void appendString(Blackhole bh, AppenderState appenderState) throws IOException {
        bh.consume((Object)appenderState.getOrCreateAppender().append("placeholder"));
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(StringConstructBenchmark.class.getName()).detectJvmArgs().build();
        new Runner(opt).run();
    }

    @State(value=Scope.Thread)
    public static class AppenderState {
        @Param(value={"StringBuilder", "StringWriter", "PrintWriter"})
        public String appenderType;
        @Param(value={"1", "256", "512", "1024"})
        public int maxAppends;
        private Appendable appender;
        private int nAppends = 0;

        @Setup(value=Level.Iteration)
        public void setup() {
            this.reset();
        }

        private void reset() {
            this.nAppends = 0;
            if (this.appenderType.equals("StringBuilder")) {
                this.appender = new StringBuilder();
            } else if (this.appenderType.equals("StringWriter")) {
                this.appender = new StringWriter();
            } else if (this.appenderType.equals("PrintWriter")) {
                this.appender = new PrintWriter(new StringWriter());
            } else {
                throw new IllegalStateException("The specified appender type (" + this.appenderType + ") is not supported.");
            }
        }

        Appendable getOrCreateAppender() {
            if (this.nAppends >= this.maxAppends) {
                this.reset();
            }
            ++this.nAppends;
            return this.appender;
        }
    }

    @State(value=Scope.Thread)
    public static class WriterState {
        public Writer writer;

        @Setup(value=Level.Trial)
        public void setup() {
            this.writer = new StringWriter();
        }
    }
}

