package org.apache.camel.component.activemq.converter;

import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.DoubleMap;

/**
 * Source code generated by org.apache.camel:apt
 */
@SuppressWarnings("unchecked")
public final class ActiveMQConverterLoader implements TypeConverterLoader {

    public ActiveMQConverterLoader() {
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        addTypeConverter(registry, org.apache.activemq.command.ActiveMQDestination.class, java.lang.String.class, false,
            (type, exchange, value) -> getActiveMQConverter().toDestination((java.lang.String) value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) { 
        registry.addTypeConverter(toType, fromType, new SimpleTypeConverter(allowNull, method));
    }

    private volatile org.apache.camel.component.activemq.converter.ActiveMQConverter activeMQConverter;
    private org.apache.camel.component.activemq.converter.ActiveMQConverter getActiveMQConverter() {
        if (activeMQConverter == null) {
            synchronized (this) {
                if (activeMQConverter == null) {
                    activeMQConverter = new org.apache.camel.component.activemq.converter.ActiveMQConverter();
                }
            }
        }
        return activeMQConverter;
    }
}
