/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ahc.ws;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class WsEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":httpUri";
    private static final String[] SCHEMES = new String[]{"ahc-ws", "ahc-wss"};
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        for (String s : SCHEMES) {
            if (!s.equals(scheme)) continue;
            return true;
        }
        return false;
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "httpUri", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(19);
        props.add("binding");
        props.add("bridgeEndpoint");
        props.add("bridgeErrorHandler");
        props.add("bufferSize");
        props.add("clientConfig");
        props.add("clientConfigOptions");
        props.add("clientConfigRealmOptions");
        props.add("connectionClose");
        props.add("cookieHandler");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("headerFilterStrategy");
        props.add("httpUri");
        props.add("lazyStartProducer");
        props.add("sendMessageOnError");
        props.add("sslContextParameters");
        props.add("throwExceptionOnFailure");
        props.add("transferException");
        props.add("useStreaming");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
        HashSet<String> prefixes = new HashSet<String>(2);
        prefixes.add("clientConfig.");
        prefixes.add("clientConfig.realm.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableSet(prefixes);
    }
}

