/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ahc.ws;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class WsEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":httpUri";
    private static final String[] SCHEMES = new String[]{"ahc-ws", "ahc-wss"};
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        for (String s : SCHEMES) {
            if (!s.equals(scheme)) continue;
            return true;
        }
        return false;
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "httpUri", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(19);
        props.add("clientConfigOptions");
        props.add("throwExceptionOnFailure");
        props.add("exchangePattern");
        props.add("sslContextParameters");
        props.add("binding");
        props.add("connectionClose");
        props.add("clientConfig");
        props.add("lazyStartProducer");
        props.add("bridgeErrorHandler");
        props.add("useStreaming");
        props.add("httpUri");
        props.add("headerFilterStrategy");
        props.add("transferException");
        props.add("clientConfigRealmOptions");
        props.add("cookieHandler");
        props.add("sendMessageOnError");
        props.add("exceptionHandler");
        props.add("bridgeEndpoint");
        props.add("bufferSize");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

