/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.any23;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Map;
import org.apache.any23.Any23;
import org.apache.any23.configuration.Configuration;
import org.apache.any23.configuration.DefaultConfiguration;
import org.apache.any23.configuration.ModifiableConfiguration;
import org.apache.any23.source.ByteArrayDocumentSource;
import org.apache.any23.source.DocumentSource;
import org.apache.any23.writer.TripleHandler;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.any23.Any23OutputFormat;
import org.apache.camel.dataformat.any23.utils.Any23Utils;
import org.apache.camel.dataformat.any23.writer.RDF4JModelWriter;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.service.ServiceSupport;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;

@Dataformat(value="any23")
public class Any23DataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private Any23 any23;
    private Map<String, String> configurations;
    private List<String> extractors;
    private Any23OutputFormat outputFormat;
    private String baseURI;

    public Any23DataFormat() {
    }

    public Any23DataFormat(String baseURI) {
        this.baseURI = baseURI;
    }

    public Any23DataFormat(Any23OutputFormat outputFormat, String baseURI) {
        this.outputFormat = outputFormat;
        this.baseURI = baseURI;
    }

    public Any23DataFormat(Map<String, String> configurations, Any23OutputFormat outputFormat, String baseURI) {
        this.configurations = configurations;
        this.outputFormat = outputFormat;
        this.baseURI = baseURI;
    }

    public Any23DataFormat(Map<String, String> configurations, List<String> extractors, Any23OutputFormat outputFormat, String baseURI) {
        this.configurations = configurations;
        this.extractors = extractors;
        this.outputFormat = outputFormat;
        this.baseURI = baseURI;
    }

    public String getDataFormatName() {
        return "any23";
    }

    public void marshal(Exchange exchange, Object object, OutputStream outputStream) throws Exception {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        outputStreamWriter.write("<html><script type=\"application/ld+json\">\n");
        outputStreamWriter.flush();
        Model mdl = (Model)object;
        Rio.write((Iterable)mdl, (OutputStream)outputStream, (RDFFormat)RDFFormat.JSONLD);
        outputStreamWriter.write("\n</script></html>");
        outputStreamWriter.flush();
        outputStreamWriter.close();
        outputStream.close();
    }

    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        ByteArrayDocumentSource source = new ByteArrayDocumentSource(inputStream, this.baseURI, null);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TripleHandler handler = Any23Utils.obtainHandler(this.outputFormat, out);
        this.any23.extract((DocumentSource)source, handler);
        handler.close();
        Object respon = this.outputFormat == Any23OutputFormat.RDF4JMODEL ? ((RDF4JModelWriter)handler).getModel() : new String(out.toByteArray());
        return respon;
    }

    protected void doStart() throws Exception {
        ModifiableConfiguration conf = null;
        String[] extrArray = null;
        if (this.extractors != null && !this.extractors.isEmpty()) {
            extrArray = new String[this.extractors.size()];
            extrArray = this.extractors.toArray(extrArray);
        }
        if (this.configurations != null && !this.configurations.isEmpty()) {
            conf = DefaultConfiguration.copy();
            for (Map.Entry<String, String> entry : this.configurations.entrySet()) {
                conf.setProperty(entry.getKey(), entry.getValue());
            }
        }
        if (this.outputFormat == null) {
            this.outputFormat = Any23OutputFormat.RDF4JMODEL;
        }
        if (conf == null && extrArray == null) {
            this.any23 = new Any23();
        } else if (conf != null && extrArray == null) {
            this.any23 = new Any23((Configuration)conf);
        } else if (conf == null && extrArray != null) {
            this.any23 = new Any23(extrArray);
        } else if (conf != null && extrArray != null) {
            this.any23 = new Any23((Configuration)conf, extrArray);
        }
    }

    protected void doStop() throws Exception {
    }

    public Any23 getAny23() {
        return this.any23;
    }

    public Any23DataFormat setAny23(Any23 any23) {
        this.any23 = any23;
        return this;
    }

    public Map<String, String> getConfigurations() {
        return this.configurations;
    }

    public Any23DataFormat setConfigurations(Map<String, String> configurations) {
        this.configurations = configurations;
        return this;
    }

    public List<String> getExtractors() {
        return this.extractors;
    }

    public Any23DataFormat setExtractors(List<String> extractors) {
        this.extractors = extractors;
        return this;
    }

    public Any23OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    public Any23DataFormat setOutputFormat(Any23OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
        return this;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public Any23DataFormat setBaseURI(String baseURI) {
        this.baseURI = baseURI;
        return this;
    }
}

