/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import org.apache.camel.RuntimeCamelException;

public class TypeConversionException
extends RuntimeCamelException {
    private static final long serialVersionUID = -6118520819865759886L;
    private final transient Object value;
    private final transient Class<?> type;

    public TypeConversionException(Object value, Class<?> type, Throwable cause) {
        super(TypeConversionException.createMessage(value, type, cause), cause);
        this.value = value;
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public Class<?> getToType() {
        return this.type;
    }

    public Class<?> getFromType() {
        if (this.value != null) {
            return this.value.getClass();
        }
        return null;
    }

    public static String createMessage(Object value, Class<?> type, Throwable cause) {
        return "Error during type conversion from type: " + (value != null ? value.getClass().getCanonicalName() : null) + " to the required type: " + type.getCanonicalName() + " with value " + value + " due to " + cause.getClass().getName() + ": " + cause.getMessage();
    }
}

