/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.service;

import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceSupport
implements StatefulService {
    protected static final int NEW = 0;
    protected static final int INITIALIZED = 1;
    protected static final int STARTING = 2;
    protected static final int STARTED = 3;
    protected static final int SUSPENDING = 4;
    protected static final int SUSPENDED = 5;
    protected static final int STOPPING = 6;
    protected static final int STOPPED = 7;
    protected static final int SHUTTINGDOWN = 8;
    protected static final int SHUTDOWN = 9;
    protected static final int FAILED = 10;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Object lock = new Object();
    protected volatile int status = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (this.status == 0) {
            Object object = this.lock;
            synchronized (object) {
                if (this.status == 0) {
                    this.log.trace("Initializing service: {}", (Object)this);
                    this.doInit();
                    this.status = 1;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 3) {
                this.log.trace("Service: {} already started", (Object)this);
                return;
            }
            if (this.status == 2) {
                this.log.trace("Service: {} already starting", (Object)this);
                return;
            }
            this.init();
            try {
                this.status = 2;
                this.log.trace("Starting service: {}", (Object)this);
                this.doStart();
                this.status = 3;
                this.log.trace("Service started: {}", (Object)this);
            }
            catch (Exception e) {
                this.status = 10;
                this.log.trace("Error while starting service: " + this, (Throwable)e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 7 || this.status == 8 || this.status == 9) {
                this.log.trace("Service: {} already stopped", (Object)this);
                return;
            }
            if (this.status == 6) {
                this.log.trace("Service: {} already stopping", (Object)this);
                return;
            }
            this.status = 6;
            this.log.trace("Stopping service: {}", (Object)this);
            try {
                this.doStop();
                this.status = 7;
                this.log.trace("Service: {} stopped service", (Object)this);
            }
            catch (Exception e) {
                this.status = 10;
                this.log.trace("Error while stopping service: " + this, (Throwable)e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 5) {
                this.log.trace("Service: {} already suspended", (Object)this);
                return;
            }
            if (this.status == 4) {
                this.log.trace("Service: {} already suspending", (Object)this);
                return;
            }
            this.status = 4;
            this.log.trace("Suspending service: {}", (Object)this);
            try {
                this.doSuspend();
                this.status = 5;
                this.log.trace("Service suspended: {}", (Object)this);
            }
            catch (Exception e) {
                this.status = 10;
                this.log.trace("Error while suspending service: " + this, (Throwable)e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.status != 5) {
                this.log.trace("Service is not suspended: {}", (Object)this);
                return;
            }
            this.status = 2;
            this.log.trace("Resuming service: {}", (Object)this);
            try {
                this.doResume();
                this.status = 3;
                this.log.trace("Service resumed: {}", (Object)this);
            }
            catch (Exception e) {
                this.status = 10;
                this.log.trace("Error while resuming service: " + this, (Throwable)e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == 9) {
                this.log.trace("Service: {} already shut down", (Object)this);
                return;
            }
            if (this.status == 8) {
                this.log.trace("Service: {} already shutting down", (Object)this);
                return;
            }
            this.stop();
            this.status = 9;
            this.log.trace("Shutting down service: {}", (Object)this);
            try {
                this.doShutdown();
                this.log.trace("Service: {} shut down", (Object)this);
                this.status = 9;
            }
            catch (Exception e) {
                this.status = 10;
                this.log.trace("Error shutting down service: " + this, (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public ServiceStatus getStatus() {
        switch (this.status) {
            case 2: {
                return ServiceStatus.Starting;
            }
            case 3: {
                return ServiceStatus.Started;
            }
            case 4: {
                return ServiceStatus.Suspending;
            }
            case 5: {
                return ServiceStatus.Suspended;
            }
            case 6: {
                return ServiceStatus.Stopping;
            }
        }
        return ServiceStatus.Stopped;
    }

    public boolean isNew() {
        return this.status == 0;
    }

    public boolean isInit() {
        return this.status == 1;
    }

    @Override
    public boolean isStarted() {
        return this.status == 3;
    }

    @Override
    public boolean isStarting() {
        return this.status == 2;
    }

    @Override
    public boolean isStopping() {
        return this.status == 6;
    }

    @Override
    public boolean isStopped() {
        return this.status == 7 || this.status == 8 || this.status == 9 || this.status == 10;
    }

    @Override
    public boolean isSuspending() {
        return this.status == 4;
    }

    @Override
    public boolean isSuspended() {
        return this.status == 5;
    }

    @Override
    public boolean isRunAllowed() {
        return this.isStartingOrStarted() || this.isSuspendingOrSuspended();
    }

    public boolean isShutdown() {
        return this.status == 9;
    }

    public boolean isStoppingOrStopped() {
        return this.isStopping() || this.isStopped();
    }

    public boolean isSuspendingOrSuspended() {
        return this.isSuspending() || this.isSuspended();
    }

    public boolean isStartingOrStarted() {
        return this.isStarting() || this.isStarted();
    }

    protected void doInit() {
    }

    protected abstract void doStart() throws Exception;

    protected abstract void doStop() throws Exception;

    protected void doSuspend() throws Exception {
    }

    protected void doResume() throws Exception {
    }

    protected void doShutdown() throws Exception {
    }
}

