/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cloudevents;

import java.util.Collection;
import java.util.Objects;
import org.apache.camel.cloudevents.CloudEvent;
import org.apache.camel.cloudevents.CloudEventAttributes;

public enum CloudEvents implements CloudEvent
{
    v1_0(new CloudEventImpl("1.0", CloudEventAttributes.V1_0_ATTRIBUTES)),
    v1_0_1(new CloudEventImpl("1.0.1", CloudEventAttributes.V1_0_ATTRIBUTES)),
    v1_0_2(new CloudEventImpl("1.0.2", CloudEventAttributes.V1_0_ATTRIBUTES));

    private final CloudEvent instance;

    private CloudEvents(CloudEvent instance) {
        this.instance = instance;
    }

    @Override
    public String version() {
        return this.instance.version();
    }

    @Override
    public Collection<CloudEvent.Attribute> attributes() {
        return this.instance.attributes();
    }

    public static CloudEvent fromSpecVersion(String version) {
        for (CloudEvents event : CloudEvents.values()) {
            if (!Objects.equals(event.version(), version)) continue;
            return event;
        }
        throw new IllegalArgumentException("Cannot find an implementation for CloudEvents spec: " + version);
    }

    private static class CloudEventImpl
    implements CloudEvent {
        private final String version;
        private final Collection<CloudEvent.Attribute> attributes;

        public CloudEventImpl(String version, Collection<CloudEvent.Attribute> attributes) {
            this.version = version;
            this.attributes = attributes;
        }

        @Override
        public String version() {
            return this.version;
        }

        @Override
        public Collection<CloudEvent.Attribute> attributes() {
            return this.attributes;
        }
    }
}

