/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api;

import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.apache.camel.component.as2.api.entity.DispositionNotificationMultipartReportEntity;
import org.apache.camel.component.as2.api.protocol.RequestAsynchronousMDN;
import org.apache.camel.component.as2.api.util.EntityUtils;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.DefaultBHttpClientConnection;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestDate;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.util.Args;

public class AS2AsynchronousMDNManager {
    public static final String CAMEL_AS2_ASYNC_MDN_PREFIX = "camel-as2.async-mdn.";
    public static final String HTTP_REQUEST = "http.request";
    public static final String HTTP_RESPONSE = "http.response";
    public static final String AS2_CONNECTION = "camel-as2.async-mdn.as2-connection";
    public static final String RECIPIENT_ADDRESS = "camel-as2.async-mdn.recipient-address";
    public static final String ASYNCHRONOUS_MDN = "camel-as2.async-mdn.asynchronous-mdn";
    private HttpProcessor httpProcessor;
    private Certificate[] signingCertificateChain;
    private PrivateKey signingPrivateKey;

    public AS2AsynchronousMDNManager(String as2Version, String userAgent, String senderFQDN, Certificate[] signingCertificateChain, PrivateKey signingPrivateKey) {
        this.signingCertificateChain = signingCertificateChain;
        this.signingPrivateKey = signingPrivateKey;
        this.httpProcessor = HttpProcessorBuilder.create().add((HttpRequestInterceptor)new RequestAsynchronousMDN(as2Version, senderFQDN)).add((HttpRequestInterceptor)new RequestTargetHost()).add((HttpRequestInterceptor)new RequestUserAgent(userAgent)).add((HttpRequestInterceptor)new RequestDate()).add((HttpRequestInterceptor)new RequestContent(true)).add((HttpRequestInterceptor)new RequestConnControl()).add((HttpRequestInterceptor)new RequestExpectContinue(true)).build();
    }

    public HttpCoreContext send(DispositionNotificationMultipartReportEntity mdn, String recipientDeliveryAddress) throws HttpException {
        HttpCoreContext httpCoreContext;
        Args.notNull((Object)((Object)mdn), (String)"mdn");
        Args.notNull((Object)recipientDeliveryAddress, (String)"recipientDeliveryAddress");
        URI uri = null;
        try {
            URIBuilder uriBuilder = new URIBuilder(recipientDeliveryAddress);
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new HttpException("Invalid recipient delivery address URL", (Throwable)e);
        }
        String requestUri = this.buildRequestURI(uri);
        int buffSize = 8192;
        DefaultBHttpClientConnection httpConnection = new DefaultBHttpClientConnection(buffSize);
        try {
            HttpResponse response;
            HttpHost targetHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
            Socket socket = new Socket(targetHost.getHostName(), targetHost.getPort());
            httpConnection.bind(socket);
            HttpCoreContext httpContext = HttpCoreContext.create();
            httpContext.setTargetHost(targetHost);
            httpContext.setAttribute(RECIPIENT_ADDRESS, (Object)recipientDeliveryAddress);
            BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", requestUri);
            request.setHeader("Content-Type", mdn.getMainMessageContentType());
            httpContext.setAttribute(HTTP_REQUEST, (Object)request);
            mdn.setMainBody(true);
            EntityUtils.setMessageEntity((HttpMessage)request, (HttpEntity)mdn);
            try {
                httpContext.setAttribute(AS2_CONNECTION, (Object)httpConnection);
                response = this.send(httpConnection, (HttpRequest)request, httpContext);
            }
            catch (IOException e) {
                throw new HttpException("Failed to send http request message", (Throwable)e);
            }
            httpContext.setAttribute(HTTP_RESPONSE, (Object)response);
            httpCoreContext = httpContext;
        }
        catch (Throwable throwable) {
            try {
                try {
                    httpConnection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new HttpException("failed to send MDN", (Throwable)e);
            }
        }
        httpConnection.close();
        return httpCoreContext;
    }

    private HttpResponse send(DefaultBHttpClientConnection httpConnection, HttpRequest request, HttpCoreContext httpContext) throws HttpException, IOException {
        HttpRequestExecutor httpexecutor = new HttpRequestExecutor();
        httpexecutor.preProcess(request, this.httpProcessor, (HttpContext)httpContext);
        HttpResponse response = httpexecutor.execute(request, (HttpClientConnection)httpConnection, (HttpContext)httpContext);
        httpexecutor.postProcess(response, this.httpProcessor, (HttpContext)httpContext);
        return response;
    }

    private String buildRequestURI(URI uri) {
        StringBuilder sb = new StringBuilder();
        if (uri.getPath() != null) {
            sb.append(uri.getPath());
        }
        if (uri.getQuery() != null) {
            sb.append('?');
            sb.append(uri.getQuery());
        }
        if (uri.getFragment() != null) {
            sb.append('#');
            sb.append(uri.getFragment());
        }
        return sb.toString();
    }
}

