/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api;

import java.io.IOException;
import java.net.Socket;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.camel.component.as2.api.io.AS2BHttpClientConnection;
import org.apache.camel.component.as2.api.protocol.RequestAS2;
import org.apache.camel.component.as2.api.protocol.RequestMDN;
import org.apache.camel.util.ObjectHelper;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpConnectionFactory;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestDate;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;

public class AS2ClientConnection {
    private static final int RETRIEVE_FROM_CONNECTION_POOL_TIMEOUT_SECONDS = 5;
    private HttpHost targetHost;
    private HttpProcessor httpProcessor;
    private String as2Version;
    private String userAgent;
    private String clientFqdn;
    private int connectionTimeoutMilliseconds;
    private PoolingHttpClientConnectionManager connectionPoolManager;
    private ConnectionKeepAliveStrategy connectionKeepAliveStrategy;

    public AS2ClientConnection(String as2Version, String userAgent, String clientFqdn, String targetHostName, Integer targetPortNumber, Duration socketTimeout, Duration connectionTimeout, Integer connectionPoolMaxSize, Duration connectionPoolTtl, SSLContext sslContext, HostnameVerifier hostnameVerifier) throws IOException {
        this.as2Version = (String)ObjectHelper.notNull((Object)as2Version, (String)"as2Version");
        this.userAgent = (String)ObjectHelper.notNull((Object)userAgent, (String)"userAgent");
        this.clientFqdn = (String)ObjectHelper.notNull((Object)clientFqdn, (String)"clientFqdn");
        this.targetHost = new HttpHost((String)ObjectHelper.notNull((Object)targetHostName, (String)"targetHostName"), ((Integer)ObjectHelper.notNull((Object)targetPortNumber, (String)"targetPortNumber")).intValue(), sslContext != null ? "https" : "http");
        ObjectHelper.notNull((Object)socketTimeout, (String)"socketTimeout");
        this.connectionTimeoutMilliseconds = (int)((Duration)ObjectHelper.notNull((Object)connectionTimeout, (String)"connectionTimeout")).toMillis();
        ObjectHelper.notNull((Object)connectionPoolMaxSize, (String)"connectionPoolMaxSize");
        ObjectHelper.notNull((Object)connectionPoolTtl, (String)"connectionPoolTtl");
        this.httpProcessor = HttpProcessorBuilder.create().add((HttpRequestInterceptor)new RequestAS2(as2Version, clientFqdn)).add((HttpRequestInterceptor)new RequestMDN()).add((HttpRequestInterceptor)new RequestTargetHost()).add((HttpRequestInterceptor)new RequestUserAgent(this.userAgent)).add((HttpRequestInterceptor)new RequestDate()).add((HttpRequestInterceptor)new RequestContent(true)).add((HttpRequestInterceptor)new RequestConnControl()).add((HttpRequestInterceptor)new RequestExpectContinue(true)).build();
        HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory = new HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection>(){

            public AS2BHttpClientConnection create(HttpRoute route, ConnectionConfig config) {
                return new AS2BHttpClientConnection(UUID.randomUUID().toString(), 8192);
            }
        };
        if (sslContext == null) {
            this.connectionPoolManager = new PoolingHttpClientConnectionManager((HttpConnectionFactory)connFactory);
        } else {
            SSLConnectionSocketFactory sslConnectionSocketFactory = hostnameVerifier == null ? new SSLConnectionSocketFactory(sslContext) : new SSLConnectionSocketFactory(sslContext, hostnameVerifier);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build();
            this.connectionPoolManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry, (HttpConnectionFactory)connFactory);
        }
        this.connectionPoolManager.setMaxTotal(connectionPoolMaxSize.intValue());
        this.connectionPoolManager.setSocketConfig(this.targetHost, SocketConfig.copy((SocketConfig)SocketConfig.DEFAULT).setSoTimeout((int)socketTimeout.toMillis()).build());
        this.connectionKeepAliveStrategy = (response, context) -> {
            int ttl = (int)connectionPoolTtl.toMillis();
            for (Header h : response.getAllHeaders()) {
                HeaderElement headerElement;
                if ("Connection".equalsIgnoreCase(h.getName()) && "Close".equalsIgnoreCase(h.getValue())) {
                    ttl = -1;
                }
                if (!"Keep-Alive".equalsIgnoreCase(h.getName()) || (headerElement = h.getElements()[0]).getValue() == null || !"timeout".equalsIgnoreCase(headerElement.getName())) continue;
                ttl = Integer.parseInt(headerElement.getValue()) * 1000;
            }
            return ttl;
        };
        try (AS2BHttpClientConnection testConnection = new AS2BHttpClientConnection("test", 8192);){
            if (sslContext == null) {
                testConnection.bind(new Socket(this.targetHost.getHostName(), this.targetHost.getPort()));
            } else {
                SSLSocketFactory factory = sslContext.getSocketFactory();
                testConnection.bind(factory.createSocket(this.targetHost.getHostName(), this.targetHost.getPort()));
            }
        }
    }

    public String getAs2Version() {
        return this.as2Version;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getClientFqdn() {
        return this.clientFqdn;
    }

    public HttpResponse send(HttpRequest request, HttpCoreContext httpContext) throws HttpException, IOException, InterruptedException, ExecutionException {
        HttpRoute route = new HttpRoute(this.targetHost);
        httpContext.setTargetHost(this.targetHost);
        HttpClientConnection httpConnection = this.connectionPoolManager.requestConnection(route, null).get(5L, TimeUnit.SECONDS);
        if (!httpConnection.isOpen()) {
            this.connectionPoolManager.connect(httpConnection, route, this.connectionTimeoutMilliseconds, (HttpContext)httpContext);
        }
        HttpRequestExecutor httpexecutor = new HttpRequestExecutor();
        httpexecutor.preProcess(request, this.httpProcessor, (HttpContext)httpContext);
        HttpResponse response = httpexecutor.execute(request, httpConnection, (HttpContext)httpContext);
        httpexecutor.postProcess(response, this.httpProcessor, (HttpContext)httpContext);
        this.connectionPoolManager.routeComplete(httpConnection, route, (HttpContext)httpContext);
        this.connectionPoolManager.releaseConnection(httpConnection, null, this.connectionKeepAliveStrategy.getKeepAliveDuration(response, (HttpContext)httpContext), TimeUnit.MILLISECONDS);
        return response;
    }
}

