/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.entity;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.camel.component.as2.api.CanonicalOutputStream;
import org.apache.camel.component.as2.api.entity.EntityParser;
import org.apache.camel.component.as2.api.entity.MimeEntity;
import org.apache.camel.component.as2.api.util.EntityUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpException;
import org.apache.http.NameValuePair;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicNameValuePair;
import org.bouncycastle.cms.CMSCompressedData;
import org.bouncycastle.cms.CMSCompressedDataGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.operator.InputExpanderProvider;
import org.bouncycastle.operator.OutputCompressor;

public class ApplicationPkcs7MimeCompressedDataEntity
extends MimeEntity {
    private static final String CONTENT_DISPOSITION = "attachment; filename=\"smime.p7z\"";
    private byte[] compressedData;

    public ApplicationPkcs7MimeCompressedDataEntity(MimeEntity entity2Encrypt, CMSCompressedDataGenerator dataGenerator, OutputCompressor compressor, String compressedContentTransferEncoding, boolean isMainBody) throws HttpException {
        this.setContentType(ContentType.create((String)"application/pkcs7-mime", (NameValuePair[])new NameValuePair[]{new BasicNameValuePair("smime-type", "compressed-data"), new BasicNameValuePair("name", "smime.p7z")}));
        this.setContentTransferEncoding(compressedContentTransferEncoding);
        this.addHeader("Content-Disposition", CONTENT_DISPOSITION);
        this.setMainBody(isMainBody);
        try {
            this.compressedData = this.createCompressedData(entity2Encrypt, dataGenerator, compressor);
        }
        catch (Exception e) {
            throw new HttpException("Failed to create encrypted data");
        }
    }

    public ApplicationPkcs7MimeCompressedDataEntity(byte[] compressedData, String compressedContentTransferEncoding, boolean isMainBody) {
        this.compressedData = (byte[])ObjectHelper.notNull((Object)compressedData, (String)"encryptedData");
        this.setContentType(ContentType.create((String)"application/pkcs7-mime", (NameValuePair[])new NameValuePair[]{new BasicNameValuePair("smime-type", "compressed-data"), new BasicNameValuePair("name", "smime.p7z")}));
        this.setContentTransferEncoding(compressedContentTransferEncoding);
        this.addHeader("Content-Disposition", CONTENT_DISPOSITION);
        this.setMainBody(isMainBody);
    }

    public void writeTo(OutputStream outstream) throws IOException {
        MimeEntity.NoCloseOutputStream ncos = new MimeEntity.NoCloseOutputStream(outstream);
        if (!this.isMainBody()) {
            try (CanonicalOutputStream canonicalOutstream = new CanonicalOutputStream(ncos, StandardCharsets.US_ASCII.name());){
                HeaderIterator it = this.headerIterator();
                while (it.hasNext()) {
                    Header header = it.nextHeader();
                    canonicalOutstream.writeln(header.toString());
                }
                canonicalOutstream.writeln();
            }
        }
        String transferEncoding = this.getContentTransferEncoding() == null ? null : this.getContentTransferEncoding().getValue();
        try (OutputStream transferEncodedStream = EntityUtils.encode(ncos, transferEncoding);){
            transferEncodedStream.write(this.compressedData);
        }
        catch (Exception e) {
            throw new IOException("Failed to write to output stream", e);
        }
    }

    public MimeEntity getCompressedEntity(InputExpanderProvider expanderProvider) throws HttpException {
        return EntityParser.parseCompressedEntity(this.compressedData, expanderProvider);
    }

    private byte[] createCompressedData(MimeEntity entity2Encrypt, CMSCompressedDataGenerator compressedDataGenerator, OutputCompressor compressor) throws IOException, CMSException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            entity2Encrypt.writeTo(bos);
            bos.flush();
            CMSProcessableByteArray contentData = new CMSProcessableByteArray(bos.toByteArray());
            CMSCompressedData compressedData = compressedDataGenerator.generate((CMSTypedData)contentData, compressor);
            byte[] byArray = compressedData.getEncoded();
            return byArray;
        }
    }
}

