/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api;

import java.util.Locale;
import java.util.Optional;

public enum AS2MicAlgorithm {
    SHA_1("SHA-1", "sha1"),
    SHA_256("SHA-256", "sha256"),
    SHA_384("SHA-384", "sha384"),
    SHA_512("SHA-512", "sha512"),
    MD5("MD5", "md5");

    private final String jdkAlgorithmName;
    private final String as2AlgorithmName;

    private AS2MicAlgorithm(String jdkAlgorithmName, String as2AlgorithmName) {
        this.jdkAlgorithmName = jdkAlgorithmName;
        this.as2AlgorithmName = as2AlgorithmName;
    }

    public String getJdkAlgorithmName() {
        return this.jdkAlgorithmName;
    }

    public String getAs2AlgorithmName() {
        return this.as2AlgorithmName;
    }

    public static String getJdkAlgorithmName(String as2AlgorithmName) {
        return Optional.ofNullable(as2AlgorithmName).map(alg -> alg.toLowerCase(Locale.US)).map(alg -> alg.replaceAll("-", "")).map(alg -> switch (alg) {
            case "md5" -> "MD5";
            case "sha1" -> "SHA-1";
            case "sha256" -> "SHA-256";
            case "sha384" -> "SHA-384";
            case "sha512" -> "SHA-512";
            default -> null;
        }).orElse(null);
    }

    public static String getAS2AlgorithmName(String jdkAlgorithmName) {
        return Optional.ofNullable(jdkAlgorithmName).map(alg -> alg.toUpperCase(Locale.US)).map(alg -> switch (alg) {
            case "MD5" -> "md5";
            case "SHA-1" -> "sha1";
            case "SHA-256" -> "sha256";
            case "SHA-384" -> "sha384";
            case "SHA-512" -> "sha512";
            default -> null;
        }).orElse(null);
    }
}

