/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.springboot;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.apache.camel.component.as2.AS2Configuration;
import org.apache.camel.component.as2.api.AS2CompressionAlgorithm;
import org.apache.camel.component.as2.api.AS2EncryptionAlgorithm;
import org.apache.camel.component.as2.api.AS2MessageStructure;
import org.apache.camel.component.as2.api.AS2SignatureAlgorithm;
import org.apache.camel.component.as2.internal.AS2ApiName;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.apache.http.entity.ContentType;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="camel.component.as2")
public class AS2ComponentConfiguration
extends ComponentConfigurationPropertiesCommon {
    private Boolean enabled;
    private AS2ConfigurationNestedConfiguration configuration;
    private Boolean resolvePropertyPlaceholders = true;

    public AS2ConfigurationNestedConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(AS2ConfigurationNestedConfiguration configuration) {
        this.configuration = configuration;
    }

    public Boolean getResolvePropertyPlaceholders() {
        return this.resolvePropertyPlaceholders;
    }

    public void setResolvePropertyPlaceholders(Boolean resolvePropertyPlaceholders) {
        this.resolvePropertyPlaceholders = resolvePropertyPlaceholders;
    }

    public static class AS2ConfigurationNestedConfiguration {
        public static final Class CAMEL_NESTED_CLASS = AS2Configuration.class;
        private AS2ApiName apiName;
        private String methodName;
        private String as2Version = "1.1";
        private String userAgent = "Camel AS2 Client Endpoint";
        private String server = "Camel AS2 Server Endpoint";
        private String serverFqdn = "camel.apache.org";
        private String targetHostname;
        private Integer targetPortNumber;
        private String clientFqdn = "camel.apache.org";
        private Integer serverPortNumber;
        private String requestUri = "/";
        private ContentType ediMessageType;
        private String ediMessageTransferEncoding;
        private AS2MessageStructure as2MessageStructure;
        private String subject;
        private String from;
        private String as2From;
        private String as2To;
        private AS2SignatureAlgorithm signingAlgorithm;
        private Certificate[] signingCertificateChain;
        private PrivateKey signingPrivateKey;
        private AS2CompressionAlgorithm compressionAlgorithm;
        private String dispositionNotificationTo;
        private String[] signedReceiptMicAlgorithms;
        private AS2EncryptionAlgorithm encryptingAlgorithm;
        private Certificate[] encryptingCertificateChain;
        private PrivateKey decryptingPrivateKey;
        private String mdnMessageTemplate;

        public AS2ApiName getApiName() {
            return this.apiName;
        }

        public void setApiName(AS2ApiName apiName) {
            this.apiName = apiName;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public String getAs2Version() {
            return this.as2Version;
        }

        public void setAs2Version(String as2Version) {
            this.as2Version = as2Version;
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        public void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        public String getServer() {
            return this.server;
        }

        public void setServer(String server) {
            this.server = server;
        }

        public String getServerFqdn() {
            return this.serverFqdn;
        }

        public void setServerFqdn(String serverFqdn) {
            this.serverFqdn = serverFqdn;
        }

        public String getTargetHostname() {
            return this.targetHostname;
        }

        public void setTargetHostname(String targetHostname) {
            this.targetHostname = targetHostname;
        }

        public Integer getTargetPortNumber() {
            return this.targetPortNumber;
        }

        public void setTargetPortNumber(Integer targetPortNumber) {
            this.targetPortNumber = targetPortNumber;
        }

        public String getClientFqdn() {
            return this.clientFqdn;
        }

        public void setClientFqdn(String clientFqdn) {
            this.clientFqdn = clientFqdn;
        }

        public Integer getServerPortNumber() {
            return this.serverPortNumber;
        }

        public void setServerPortNumber(Integer serverPortNumber) {
            this.serverPortNumber = serverPortNumber;
        }

        public String getRequestUri() {
            return this.requestUri;
        }

        public void setRequestUri(String requestUri) {
            this.requestUri = requestUri;
        }

        public ContentType getEdiMessageType() {
            return this.ediMessageType;
        }

        public void setEdiMessageType(ContentType ediMessageType) {
            this.ediMessageType = ediMessageType;
        }

        public String getEdiMessageTransferEncoding() {
            return this.ediMessageTransferEncoding;
        }

        public void setEdiMessageTransferEncoding(String ediMessageTransferEncoding) {
            this.ediMessageTransferEncoding = ediMessageTransferEncoding;
        }

        public AS2MessageStructure getAs2MessageStructure() {
            return this.as2MessageStructure;
        }

        public void setAs2MessageStructure(AS2MessageStructure as2MessageStructure) {
            this.as2MessageStructure = as2MessageStructure;
        }

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getAs2From() {
            return this.as2From;
        }

        public void setAs2From(String as2From) {
            this.as2From = as2From;
        }

        public String getAs2To() {
            return this.as2To;
        }

        public void setAs2To(String as2To) {
            this.as2To = as2To;
        }

        public AS2SignatureAlgorithm getSigningAlgorithm() {
            return this.signingAlgorithm;
        }

        public void setSigningAlgorithm(AS2SignatureAlgorithm signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
        }

        public Certificate[] getSigningCertificateChain() {
            return this.signingCertificateChain;
        }

        public void setSigningCertificateChain(Certificate[] signingCertificateChain) {
            this.signingCertificateChain = signingCertificateChain;
        }

        public PrivateKey getSigningPrivateKey() {
            return this.signingPrivateKey;
        }

        public void setSigningPrivateKey(PrivateKey signingPrivateKey) {
            this.signingPrivateKey = signingPrivateKey;
        }

        public AS2CompressionAlgorithm getCompressionAlgorithm() {
            return this.compressionAlgorithm;
        }

        public void setCompressionAlgorithm(AS2CompressionAlgorithm compressionAlgorithm) {
            this.compressionAlgorithm = compressionAlgorithm;
        }

        public String getDispositionNotificationTo() {
            return this.dispositionNotificationTo;
        }

        public void setDispositionNotificationTo(String dispositionNotificationTo) {
            this.dispositionNotificationTo = dispositionNotificationTo;
        }

        public String[] getSignedReceiptMicAlgorithms() {
            return this.signedReceiptMicAlgorithms;
        }

        public void setSignedReceiptMicAlgorithms(String[] signedReceiptMicAlgorithms) {
            this.signedReceiptMicAlgorithms = signedReceiptMicAlgorithms;
        }

        public AS2EncryptionAlgorithm getEncryptingAlgorithm() {
            return this.encryptingAlgorithm;
        }

        public void setEncryptingAlgorithm(AS2EncryptionAlgorithm encryptingAlgorithm) {
            this.encryptingAlgorithm = encryptingAlgorithm;
        }

        public Certificate[] getEncryptingCertificateChain() {
            return this.encryptingCertificateChain;
        }

        public void setEncryptingCertificateChain(Certificate[] encryptingCertificateChain) {
            this.encryptingCertificateChain = encryptingCertificateChain;
        }

        public PrivateKey getDecryptingPrivateKey() {
            return this.decryptingPrivateKey;
        }

        public void setDecryptingPrivateKey(PrivateKey decryptingPrivateKey) {
            this.decryptingPrivateKey = decryptingPrivateKey;
        }

        public String getMdnMessageTemplate() {
            return this.mdnMessageTemplate;
        }

        public void setMdnMessageTemplate(String mdnMessageTemplate) {
            this.mdnMessageTemplate = mdnMessageTemplate;
        }
    }
}

