/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class AS2EndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":apiName/methodName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "as2".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "apiName", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "methodName", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(35);
        props.add("server");
        props.add("apiName");
        props.add("as2Version");
        props.add("as2MessageStructure");
        props.add("ediMessageTransferEncoding");
        props.add("encryptingCertificateChain");
        props.add("subject");
        props.add("signingPrivateKey");
        props.add("signedReceiptMicAlgorithms");
        props.add("ediMessage");
        props.add("as2To");
        props.add("as2From");
        props.add("targetHostname");
        props.add("from");
        props.add("serverFqdn");
        props.add("dispositionNotificationTo");
        props.add("requestUriPattern");
        props.add("encryptingAlgorithm");
        props.add("exchangePattern");
        props.add("ediMessageContentType");
        props.add("methodName");
        props.add("serverPortNumber");
        props.add("userAgent");
        props.add("requestUri");
        props.add("clientFqdn");
        props.add("lazyStartProducer");
        props.add("decryptingPrivateKey");
        props.add("signingAlgorithm");
        props.add("compressionAlgorithm");
        props.add("ediMessageType");
        props.add("inBody");
        props.add("mdnMessageTemplate");
        props.add("signingCertificateChain");
        props.add("exceptionHandler");
        props.add("targetPortNumber");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

