/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.as2.AS2Configuration;
import org.apache.camel.component.as2.AS2Endpoint;
import org.apache.camel.component.as2.api.AS2CompressionAlgorithm;
import org.apache.camel.component.as2.api.AS2EncryptionAlgorithm;
import org.apache.camel.component.as2.api.AS2MessageStructure;
import org.apache.camel.component.as2.api.AS2SignatureAlgorithm;
import org.apache.camel.component.as2.internal.AS2ApiName;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.ExtendedPropertyConfigurerGetter;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;
import org.apache.http.entity.ContentType;

public class AS2EndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
ExtendedPropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        AS2Endpoint target = (AS2Endpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "as2from": 
            case "as2From": {
                ((AS2Configuration)target.getConfiguration()).setAs2From((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "as2messagestructure": 
            case "as2MessageStructure": {
                ((AS2Configuration)target.getConfiguration()).setAs2MessageStructure((AS2MessageStructure)AS2EndpointConfigurer.property((CamelContext)camelContext, AS2MessageStructure.class, (Object)value));
                return true;
            }
            case "as2to": 
            case "as2To": {
                ((AS2Configuration)target.getConfiguration()).setAs2To((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "as2version": 
            case "as2Version": {
                ((AS2Configuration)target.getConfiguration()).setAs2Version((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "clientfqdn": 
            case "clientFqdn": {
                ((AS2Configuration)target.getConfiguration()).setClientFqdn((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "compressionalgorithm": 
            case "compressionAlgorithm": {
                ((AS2Configuration)target.getConfiguration()).setCompressionAlgorithm((AS2CompressionAlgorithm)AS2EndpointConfigurer.property((CamelContext)camelContext, AS2CompressionAlgorithm.class, (Object)value));
                return true;
            }
            case "decryptingprivatekey": 
            case "decryptingPrivateKey": {
                ((AS2Configuration)target.getConfiguration()).setDecryptingPrivateKey((PrivateKey)AS2EndpointConfigurer.property((CamelContext)camelContext, PrivateKey.class, (Object)value));
                return true;
            }
            case "dispositionnotificationto": 
            case "dispositionNotificationTo": {
                ((AS2Configuration)target.getConfiguration()).setDispositionNotificationTo((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "edimessagetransferencoding": 
            case "ediMessageTransferEncoding": {
                ((AS2Configuration)target.getConfiguration()).setEdiMessageTransferEncoding((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "edimessagetype": 
            case "ediMessageType": {
                ((AS2Configuration)target.getConfiguration()).setEdiMessageType((ContentType)AS2EndpointConfigurer.property((CamelContext)camelContext, ContentType.class, (Object)value));
                return true;
            }
            case "encryptingalgorithm": 
            case "encryptingAlgorithm": {
                ((AS2Configuration)target.getConfiguration()).setEncryptingAlgorithm((AS2EncryptionAlgorithm)AS2EndpointConfigurer.property((CamelContext)camelContext, AS2EncryptionAlgorithm.class, (Object)value));
                return true;
            }
            case "encryptingcertificatechain": 
            case "encryptingCertificateChain": {
                ((AS2Configuration)target.getConfiguration()).setEncryptingCertificateChain((Certificate[])AS2EndpointConfigurer.property((CamelContext)camelContext, Certificate[].class, (Object)value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler((ExceptionHandler)AS2EndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern((ExchangePattern)AS2EndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "from": {
                ((AS2Configuration)target.getConfiguration()).setFrom((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "inbody": 
            case "inBody": {
                target.setInBody((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)AS2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "mdnmessagetemplate": 
            case "mdnMessageTemplate": {
                ((AS2Configuration)target.getConfiguration()).setMdnMessageTemplate((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "requesturi": 
            case "requestUri": {
                ((AS2Configuration)target.getConfiguration()).setRequestUri((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "server": {
                ((AS2Configuration)target.getConfiguration()).setServer((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "serverfqdn": 
            case "serverFqdn": {
                ((AS2Configuration)target.getConfiguration()).setServerFqdn((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "serverportnumber": 
            case "serverPortNumber": {
                ((AS2Configuration)target.getConfiguration()).setServerPortNumber((Integer)AS2EndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "signedreceiptmicalgorithms": 
            case "signedReceiptMicAlgorithms": {
                ((AS2Configuration)target.getConfiguration()).setSignedReceiptMicAlgorithms((String[])AS2EndpointConfigurer.property((CamelContext)camelContext, String[].class, (Object)value));
                return true;
            }
            case "signingalgorithm": 
            case "signingAlgorithm": {
                ((AS2Configuration)target.getConfiguration()).setSigningAlgorithm((AS2SignatureAlgorithm)AS2EndpointConfigurer.property((CamelContext)camelContext, AS2SignatureAlgorithm.class, (Object)value));
                return true;
            }
            case "signingcertificatechain": 
            case "signingCertificateChain": {
                ((AS2Configuration)target.getConfiguration()).setSigningCertificateChain((Certificate[])AS2EndpointConfigurer.property((CamelContext)camelContext, Certificate[].class, (Object)value));
                return true;
            }
            case "signingprivatekey": 
            case "signingPrivateKey": {
                ((AS2Configuration)target.getConfiguration()).setSigningPrivateKey((PrivateKey)AS2EndpointConfigurer.property((CamelContext)camelContext, PrivateKey.class, (Object)value));
                return true;
            }
            case "subject": {
                ((AS2Configuration)target.getConfiguration()).setSubject((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "targethostname": 
            case "targetHostname": {
                ((AS2Configuration)target.getConfiguration()).setTargetHostname((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "targetportnumber": 
            case "targetPortNumber": {
                ((AS2Configuration)target.getConfiguration()).setTargetPortNumber((Integer)AS2EndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "useragent": 
            case "userAgent": {
                ((AS2Configuration)target.getConfiguration()).setUserAgent((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "as2from": 
            case "as2From": {
                return String.class;
            }
            case "as2messagestructure": 
            case "as2MessageStructure": {
                return AS2MessageStructure.class;
            }
            case "as2to": 
            case "as2To": {
                return String.class;
            }
            case "as2version": 
            case "as2Version": {
                return String.class;
            }
            case "clientfqdn": 
            case "clientFqdn": {
                return String.class;
            }
            case "compressionalgorithm": 
            case "compressionAlgorithm": {
                return AS2CompressionAlgorithm.class;
            }
            case "decryptingprivatekey": 
            case "decryptingPrivateKey": {
                return PrivateKey.class;
            }
            case "dispositionnotificationto": 
            case "dispositionNotificationTo": {
                return String.class;
            }
            case "edimessagetransferencoding": 
            case "ediMessageTransferEncoding": {
                return String.class;
            }
            case "edimessagetype": 
            case "ediMessageType": {
                return ContentType.class;
            }
            case "encryptingalgorithm": 
            case "encryptingAlgorithm": {
                return AS2EncryptionAlgorithm.class;
            }
            case "encryptingcertificatechain": 
            case "encryptingCertificateChain": {
                return Certificate[].class;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return ExceptionHandler.class;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return ExchangePattern.class;
            }
            case "from": {
                return String.class;
            }
            case "inbody": 
            case "inBody": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "mdnmessagetemplate": 
            case "mdnMessageTemplate": {
                return String.class;
            }
            case "requesturi": 
            case "requestUri": {
                return String.class;
            }
            case "server": {
                return String.class;
            }
            case "serverfqdn": 
            case "serverFqdn": {
                return String.class;
            }
            case "serverportnumber": 
            case "serverPortNumber": {
                return Integer.class;
            }
            case "signedreceiptmicalgorithms": 
            case "signedReceiptMicAlgorithms": {
                return String[].class;
            }
            case "signingalgorithm": 
            case "signingAlgorithm": {
                return AS2SignatureAlgorithm.class;
            }
            case "signingcertificatechain": 
            case "signingCertificateChain": {
                return Certificate[].class;
            }
            case "signingprivatekey": 
            case "signingPrivateKey": {
                return PrivateKey.class;
            }
            case "subject": {
                return String.class;
            }
            case "targethostname": 
            case "targetHostname": {
                return String.class;
            }
            case "targetportnumber": 
            case "targetPortNumber": {
                return Integer.class;
            }
            case "useragent": 
            case "userAgent": {
                return String.class;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        AS2Endpoint target = (AS2Endpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "as2from": 
            case "as2From": {
                return ((AS2Configuration)target.getConfiguration()).getAs2From();
            }
            case "as2messagestructure": 
            case "as2MessageStructure": {
                return ((AS2Configuration)target.getConfiguration()).getAs2MessageStructure();
            }
            case "as2to": 
            case "as2To": {
                return ((AS2Configuration)target.getConfiguration()).getAs2To();
            }
            case "as2version": 
            case "as2Version": {
                return ((AS2Configuration)target.getConfiguration()).getAs2Version();
            }
            case "clientfqdn": 
            case "clientFqdn": {
                return ((AS2Configuration)target.getConfiguration()).getClientFqdn();
            }
            case "compressionalgorithm": 
            case "compressionAlgorithm": {
                return ((AS2Configuration)target.getConfiguration()).getCompressionAlgorithm();
            }
            case "decryptingprivatekey": 
            case "decryptingPrivateKey": {
                return ((AS2Configuration)target.getConfiguration()).getDecryptingPrivateKey();
            }
            case "dispositionnotificationto": 
            case "dispositionNotificationTo": {
                return ((AS2Configuration)target.getConfiguration()).getDispositionNotificationTo();
            }
            case "edimessagetransferencoding": 
            case "ediMessageTransferEncoding": {
                return ((AS2Configuration)target.getConfiguration()).getEdiMessageTransferEncoding();
            }
            case "edimessagetype": 
            case "ediMessageType": {
                return ((AS2Configuration)target.getConfiguration()).getEdiMessageType();
            }
            case "encryptingalgorithm": 
            case "encryptingAlgorithm": {
                return ((AS2Configuration)target.getConfiguration()).getEncryptingAlgorithm();
            }
            case "encryptingcertificatechain": 
            case "encryptingCertificateChain": {
                return ((AS2Configuration)target.getConfiguration()).getEncryptingCertificateChain();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "from": {
                return ((AS2Configuration)target.getConfiguration()).getFrom();
            }
            case "inbody": 
            case "inBody": {
                return target.getInBody();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "mdnmessagetemplate": 
            case "mdnMessageTemplate": {
                return ((AS2Configuration)target.getConfiguration()).getMdnMessageTemplate();
            }
            case "requesturi": 
            case "requestUri": {
                return ((AS2Configuration)target.getConfiguration()).getRequestUri();
            }
            case "server": {
                return ((AS2Configuration)target.getConfiguration()).getServer();
            }
            case "serverfqdn": 
            case "serverFqdn": {
                return ((AS2Configuration)target.getConfiguration()).getServerFqdn();
            }
            case "serverportnumber": 
            case "serverPortNumber": {
                return ((AS2Configuration)target.getConfiguration()).getServerPortNumber();
            }
            case "signedreceiptmicalgorithms": 
            case "signedReceiptMicAlgorithms": {
                return ((AS2Configuration)target.getConfiguration()).getSignedReceiptMicAlgorithms();
            }
            case "signingalgorithm": 
            case "signingAlgorithm": {
                return ((AS2Configuration)target.getConfiguration()).getSigningAlgorithm();
            }
            case "signingcertificatechain": 
            case "signingCertificateChain": {
                return ((AS2Configuration)target.getConfiguration()).getSigningCertificateChain();
            }
            case "signingprivatekey": 
            case "signingPrivateKey": {
                return ((AS2Configuration)target.getConfiguration()).getSigningPrivateKey();
            }
            case "subject": {
                return ((AS2Configuration)target.getConfiguration()).getSubject();
            }
            case "targethostname": 
            case "targetHostname": {
                return ((AS2Configuration)target.getConfiguration()).getTargetHostname();
            }
            case "targetportnumber": 
            case "targetPortNumber": {
                return ((AS2Configuration)target.getConfiguration()).getTargetPortNumber();
            }
            case "useragent": 
            case "userAgent": {
                return ((AS2Configuration)target.getConfiguration()).getUserAgent();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("apiName", AS2ApiName.class);
        map.put("methodName", String.class);
        map.put("as2From", String.class);
        map.put("as2MessageStructure", AS2MessageStructure.class);
        map.put("as2To", String.class);
        map.put("as2Version", String.class);
        map.put("clientFqdn", String.class);
        map.put("compressionAlgorithm", AS2CompressionAlgorithm.class);
        map.put("decryptingPrivateKey", PrivateKey.class);
        map.put("dispositionNotificationTo", String.class);
        map.put("ediMessageTransferEncoding", String.class);
        map.put("ediMessageType", ContentType.class);
        map.put("encryptingAlgorithm", AS2EncryptionAlgorithm.class);
        map.put("encryptingCertificateChain", Certificate[].class);
        map.put("from", String.class);
        map.put("inBody", String.class);
        map.put("mdnMessageTemplate", String.class);
        map.put("requestUri", String.class);
        map.put("server", String.class);
        map.put("serverFqdn", String.class);
        map.put("serverPortNumber", Integer.class);
        map.put("signedReceiptMicAlgorithms", String[].class);
        map.put("signingAlgorithm", AS2SignatureAlgorithm.class);
        map.put("signingCertificateChain", Certificate[].class);
        map.put("signingPrivateKey", PrivateKey.class);
        map.put("subject", String.class);
        map.put("targetHostname", String.class);
        map.put("targetPortNumber", Integer.class);
        map.put("userAgent", String.class);
        map.put("exceptionHandler", ExceptionHandler.class);
        map.put("exchangePattern", ExchangePattern.class);
        map.put("lazyStartProducer", Boolean.TYPE);
        ALL_OPTIONS = map;
    }
}

