/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.asn1;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASN1GenericIterator<T>
implements Iterator<T>,
Closeable {
    static final Logger LOGGER = LoggerFactory.getLogger(ASN1GenericIterator.class);
    private volatile ASN1InputStream asn1InputStream;
    private volatile T parent;
    private Class<T> clazz;

    public ASN1GenericIterator(Class<T> clazz, InputStream inputStream) {
        this.asn1InputStream = inputStream instanceof ASN1InputStream ? (ASN1InputStream)inputStream : new ASN1InputStream(inputStream);
        this.parent = null;
        this.clazz = clazz;
    }

    @Override
    public boolean hasNext() {
        try {
            boolean availableDataInCurrentEntry;
            if (this.asn1InputStream == null) {
                return false;
            }
            boolean bl = availableDataInCurrentEntry = this.asn1InputStream.available() > 0;
            if (!availableDataInCurrentEntry) {
                this.parent = this.getNextElement();
                if (this.parent == null) {
                    this.asn1InputStream.close();
                    availableDataInCurrentEntry = false;
                } else {
                    availableDataInCurrentEntry = true;
                }
            }
            return availableDataInCurrentEntry;
        }
        catch (IOException exception) {
            throw new RuntimeCamelException((Throwable)exception);
        }
    }

    private T getNextElement() {
        if (this.asn1InputStream == null) {
            return null;
        }
        try {
            ASN1Primitive current = this.getNextEntry();
            if (current != null) {
                Object instance = ObjectHelper.cast(this.clazz, (Object)this.createGenericTypeObject(current));
                return (T)instance;
            }
            LOGGER.trace("close asn1InputStream");
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeCamelException((Throwable)exception);
        }
    }

    private Object createGenericTypeObject(ASN1Primitive current) throws NoSuchMethodException, IOException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class[] paramIS = new Class[]{InputStream.class};
        Method m = this.clazz.getDeclaredMethod("decode", paramIS);
        ByteArrayInputStream is = new ByteArrayInputStream(current.getEncoded());
        T clazzInstance = this.clazz.newInstance();
        m.invoke(clazzInstance, is);
        return clazzInstance;
    }

    private ASN1Primitive getNextEntry() throws IOException {
        return this.asn1InputStream.readObject();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T next() {
        if (this.parent == null) {
            this.parent = this.getNextElement();
        }
        T answer = this.parent;
        this.parent = null;
        this.checkNullAnswer(answer);
        return answer;
    }

    private void checkNullAnswer(T answer) {
        if (answer == null && this.asn1InputStream != null) {
            IOHelper.close((Closeable)this.asn1InputStream);
            this.asn1InputStream = null;
        }
    }

    @Override
    public void close() throws IOException {
        IOHelper.close((Closeable)this.asn1InputStream);
        this.asn1InputStream = null;
    }
}

