/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.asterisk;

import java.io.IOException;
import org.apache.camel.component.asterisk.CamelAsteriskException;
import org.asteriskjava.manager.AuthenticationFailedException;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.ManagerConnectionFactory;
import org.asteriskjava.manager.ManagerConnectionState;
import org.asteriskjava.manager.ManagerEventListener;
import org.asteriskjava.manager.TimeoutException;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.response.ManagerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsteriskConnection {
    private static final Logger LOG = LoggerFactory.getLogger(AsteriskConnection.class);
    private String host;
    private String username;
    private String password;
    private ManagerConnection managerConnection;

    public AsteriskConnection(String host, String username, String password) {
        this.host = host;
        this.username = username;
        this.password = password;
        this.connect();
    }

    private void connect() {
        if (this.managerConnection == null) {
            LOG.debug("asterisk connection attempt to {} username: {}", (Object)this.host, (Object)this.username);
            ManagerConnectionFactory factory = new ManagerConnectionFactory(this.host, this.username, this.password);
            this.managerConnection = factory.createManagerConnection();
            LOG.debug("asterisk connection established!");
        }
    }

    public void login() throws IllegalStateException, IOException, AuthenticationFailedException, TimeoutException, CamelAsteriskException {
        if (this.managerConnection == null || this.managerConnection.getState() != ManagerConnectionState.DISCONNECTED && this.managerConnection.getState() != ManagerConnectionState.INITIAL) {
            throw new CamelAsteriskException("Login operation, managerConnection is empty!");
        }
        this.managerConnection.login("on");
        LOG.debug("asterisk login done!");
    }

    public void logoff() throws CamelAsteriskException {
        if (this.managerConnection == null || this.managerConnection.getState() != ManagerConnectionState.CONNECTED) {
            throw new CamelAsteriskException("Logoff operation, managerConnection is empty!");
        }
        this.managerConnection.logoff();
        LOG.debug("asterisk logoff done!");
    }

    public void addListener(ManagerEventListener listener) throws CamelAsteriskException {
        if (this.managerConnection == null) {
            throw new CamelAsteriskException("Add listener operation, managerConnection is empty!");
        }
        this.managerConnection.addEventListener(listener);
        LOG.debug("asterisk added listener {}", (Object)listener);
    }

    public ManagerResponse sendAction(ManagerAction action) throws IllegalArgumentException, IllegalStateException, IOException, TimeoutException {
        ManagerResponse response = this.managerConnection.sendAction(action);
        return response;
    }
}

