/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.asterisk;

import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.asterisk.AsteriskEndpoint;
import org.apache.camel.component.asterisk.AsteriskListenerTask;
import org.apache.camel.impl.DefaultConsumer;

public class AsteriskConsumer
extends DefaultConsumer {
    private final AsteriskEndpoint endpoint;
    private final AsteriskListenerTask task;

    public AsteriskConsumer(AsteriskEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.task = new AsteriskListenerTask(endpoint, this);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.log.info("Starting Asterisk AMI Event Listener");
        this.endpoint.addListener(this.task);
        this.endpoint.login();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.log.info("Stopping Asterisk AMI Event Listener");
        this.endpoint.logoff();
    }
}

