/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.asterisk;

import java.io.IOException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.asterisk.AsteriskEndpoint;
import org.apache.camel.component.asterisk.CamelAsteriskException;
import org.apache.camel.impl.DefaultProducer;
import org.asteriskjava.manager.AuthenticationFailedException;
import org.asteriskjava.manager.TimeoutException;
import org.asteriskjava.manager.action.ExtensionStateAction;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.action.QueueStatusAction;
import org.asteriskjava.manager.action.SipPeersAction;
import org.asteriskjava.manager.response.ManagerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsteriskProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(AsteriskProducer.class);
    private AsteriskEndpoint endpoint;

    public AsteriskProducer(AsteriskEndpoint endpoint) throws IllegalStateException, IOException, AuthenticationFailedException, TimeoutException, CamelAsteriskException {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        this.endpoint.login();
    }

    protected void doStop() throws Exception {
        this.endpoint.logoff();
    }

    public void process(Exchange exchange) throws Exception {
        QueueStatusAction action;
        switch (this.endpoint.getAction()) {
            case QUEUE_STATUS: {
                action = new QueueStatusAction();
                break;
            }
            case SIP_PEERS: {
                action = new SipPeersAction();
                break;
            }
            case EXTENSION_STATE: {
                action = new ExtensionStateAction((String)exchange.getIn().getHeader("CamelAsteriskExtension"), (String)exchange.getIn().getHeader("CamelAsteriskContext"));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown action");
            }
        }
        LOG.debug("Asterisk, send action {} ", (Object)this.endpoint.getAction());
        ManagerResponse response = this.endpoint.sendAction((ManagerAction)action);
        exchange.getIn().setBody((Object)response);
    }
}

