/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.asterisk;

import java.io.IOException;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.asterisk.AsteriskActionEnum;
import org.apache.camel.component.asterisk.AsteriskComponent;
import org.apache.camel.component.asterisk.AsteriskConnection;
import org.apache.camel.component.asterisk.AsteriskConsumer;
import org.apache.camel.component.asterisk.AsteriskProducer;
import org.apache.camel.component.asterisk.CamelAsteriskException;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.asteriskjava.manager.AuthenticationFailedException;
import org.asteriskjava.manager.ManagerEventListener;
import org.asteriskjava.manager.TimeoutException;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.response.ManagerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="asterisk", title="Asterisk", syntax="asterisk:name", consumerClass=AsteriskConsumer.class, label="voip")
public class AsteriskEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(AsteriskProducer.class);
    private AsteriskConnection asteriskConnection;
    @UriPath(description="Name of component")
    @Metadata(required="true")
    private String name;
    @UriParam
    private String hostname;
    @UriParam(label="producer")
    private AsteriskActionEnum action;
    @UriParam(secret=true)
    private String username;
    @UriParam(secret=true)
    private String password;

    public AsteriskEndpoint(String uri, AsteriskComponent component) {
        super(uri, (Component)component);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.asteriskConnection = new AsteriskConnection(this.hostname, this.username, this.password);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.asteriskConnection = null;
    }

    public Producer createProducer() throws Exception {
        if (this.action == null) {
            throw new IllegalArgumentException("Missing required action parameter");
        }
        return new AsteriskProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new AsteriskConsumer(this, processor);
    }

    public boolean isSingleton() {
        return false;
    }

    public void addListener(ManagerEventListener listener) throws CamelAsteriskException {
        this.asteriskConnection.addListener(listener);
    }

    public void login() throws IllegalStateException, IOException, AuthenticationFailedException, TimeoutException, CamelAsteriskException {
        this.asteriskConnection.login();
    }

    public void logoff() throws CamelAsteriskException {
        this.asteriskConnection.logoff();
    }

    public Exchange createExchange(ManagerEvent event) {
        Exchange exchange = super.createExchange();
        exchange.getIn().setHeader("CamelAsteriskEventName", (Object)event.getClass().getSimpleName());
        exchange.getIn().setBody((Object)event);
        return exchange;
    }

    public ManagerResponse sendAction(ManagerAction action) throws IllegalArgumentException, IllegalStateException, IOException, TimeoutException {
        return this.asteriskConnection.sendAction(action);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public AsteriskActionEnum getAction() {
        return this.action;
    }

    public void setAction(AsteriskActionEnum action) {
        this.action = action;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

