/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.asterisk;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.asterisk.AsteriskAction;
import org.apache.camel.component.asterisk.AsteriskComponent;
import org.apache.camel.component.asterisk.AsteriskConsumer;
import org.apache.camel.component.asterisk.AsteriskProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.18.0", scheme="asterisk", title="Asterisk", syntax="asterisk:name", consumerClass=AsteriskConsumer.class, label="voip")
public class AsteriskEndpoint
extends DefaultEndpoint {
    @UriPath(description="Name of component")
    @Metadata(required="true")
    private String name;
    @UriParam
    @Metadata(required="true")
    private String hostname;
    @UriParam(label="producer")
    private AsteriskAction action;
    @UriParam(secret=true)
    @Metadata(required="true")
    private String username;
    @UriParam(secret=true)
    @Metadata(required="true")
    private String password;

    public AsteriskEndpoint(String uri, AsteriskComponent component) {
        super(uri, (Component)component);
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.hostname, (String)"hostname");
        ObjectHelper.notNull((Object)this.username, (String)"username");
        ObjectHelper.notNull((Object)this.password, (String)"password");
    }

    public Producer createProducer() throws Exception {
        return new AsteriskProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new AsteriskConsumer(this, processor);
    }

    public boolean isSingleton() {
        return true;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public AsteriskAction getAction() {
        return this.action;
    }

    public void setAction(AsteriskAction action) {
        this.action = action;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

