/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atlasmap;

import io.atlasmap.api.AtlasContextFactory;
import io.atlasmap.core.DefaultAtlasContextFactory;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.atlasmap.AtlasMapEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="atlasmap")
public class AtlasMapComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasMapComponent.class);
    @Metadata(label="advanced")
    private AtlasContextFactory atlasContextFactory;
    @Metadata(label="advanced")
    private String propertiesFile;

    public AtlasContextFactory getAtlasContextFactory() {
        return this.atlasContextFactory;
    }

    public void setAtlasContextFactory(AtlasContextFactory atlasContextFactory) {
        this.atlasContextFactory = atlasContextFactory;
    }

    public void setPropertiesFile(String file) {
        this.propertiesFile = file;
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        boolean cache = (Boolean)this.getAndRemoveParameter(parameters, "contentCache", Boolean.class, Boolean.TRUE);
        String sourceMapName = (String)this.getAndRemoveParameter(parameters, "sourceMapName", String.class);
        String targetMapName = (String)this.getAndRemoveParameter(parameters, "targetMapName", String.class);
        AtlasMapEndpoint.TargetMapMode targetMapMode = (AtlasMapEndpoint.TargetMapMode)((Object)this.getAndRemoveParameter(parameters, "targetMapMode", AtlasMapEndpoint.TargetMapMode.class));
        boolean forceReload = (Boolean)this.getAndRemoveParameter(parameters, "forceAdmReload", Boolean.class, Boolean.FALSE);
        AtlasMapEndpoint endpoint = new AtlasMapEndpoint(uri, this, remaining);
        this.setProperties((Endpoint)endpoint, parameters);
        endpoint.setContentCache(cache);
        endpoint.setSourceMapName(sourceMapName);
        endpoint.setTargetMapName(targetMapName);
        endpoint.setForceReload(forceReload);
        endpoint.setAtlasContextFactory(this.getOrCreateAtlasContextFactory());
        if (targetMapMode != null) {
            endpoint.setTargetMapMode(targetMapMode);
        }
        if (ResourceHelper.isHttpUri((String)remaining)) {
            String remainingAndParameters = ResourceHelper.appendParameters((String)remaining, parameters);
            endpoint.setResourceUri(remainingAndParameters);
        }
        return endpoint;
    }

    private synchronized AtlasContextFactory getOrCreateAtlasContextFactory() throws Exception {
        if (this.atlasContextFactory != null) {
            return this.atlasContextFactory;
        }
        this.atlasContextFactory = DefaultAtlasContextFactory.getInstance();
        this.atlasContextFactory.addClassLoader(this.getCamelContext().getApplicationContextClassLoader());
        if (ObjectHelper.isNotEmpty((Object)this.getPropertiesFile())) {
            Properties properties = new Properties();
            InputStream reader = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getCamelContext(), (String)this.getPropertiesFile());
            try {
                properties.load(reader);
                LOG.info("Loaded the Atlas properties file {}", (Object)this.getPropertiesFile());
            }
            finally {
                IOHelper.close((Closeable)reader, (String)this.getPropertiesFile(), (Logger)LOG);
            }
            LOG.debug("Initializing AtlasContextFactory with properties {}", (Object)properties);
            this.atlasContextFactory.setProperties(properties);
        }
        return this.atlasContextFactory;
    }
}

