/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atlasmap;

import io.atlasmap.api.AtlasContextFactory;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.atlasmap.AtlasMapEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.ResourceHelper;

@Component(value="atlasmap")
public class AtlasMapComponent
extends DefaultComponent {
    @Metadata(label="advanced")
    private AtlasContextFactory atlasContextFactory;

    public AtlasContextFactory getAtlasContextFactory() {
        return this.atlasContextFactory;
    }

    public void setAtlasContextFactory(AtlasContextFactory atlasContextFactory) {
        this.atlasContextFactory = atlasContextFactory;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        boolean cache = (Boolean)this.getAndRemoveParameter(parameters, "contentCache", Boolean.class, Boolean.TRUE);
        String sourceMapName = (String)this.getAndRemoveParameter(parameters, "sourceMapName", String.class);
        String targetMapName = (String)this.getAndRemoveParameter(parameters, "targetMapName", String.class);
        AtlasMapEndpoint.TargetMapMode targetMapMode = (AtlasMapEndpoint.TargetMapMode)((Object)this.getAndRemoveParameter(parameters, "targetMapMode", AtlasMapEndpoint.TargetMapMode.class));
        AtlasMapEndpoint endpoint = new AtlasMapEndpoint(uri, this, remaining);
        this.setProperties((Endpoint)endpoint, parameters);
        endpoint.setContentCache(cache);
        endpoint.setSourceMapName(sourceMapName);
        endpoint.setTargetMapName(targetMapName);
        endpoint.setAtlasContextFactory(this.getAtlasContextFactory());
        if (targetMapMode != null) {
            endpoint.setTargetMapMode(targetMapMode);
        }
        if (ResourceHelper.isHttpUri((String)remaining)) {
            String remainingAndParameters = ResourceHelper.appendParameters((String)remaining, parameters);
            endpoint.setResourceUri(remainingAndParameters);
        }
        return endpoint;
    }
}

