/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atlasmap;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasContextFactory;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.spi.AtlasPropertyStrategy;
import io.atlasmap.v2.Audit;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.DataSourceType;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.component.atlasmap.AtlasMapComponent;
import org.apache.camel.component.atlasmap.CamelAtlasPropertyStrategy;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="3.7.0", scheme="atlasmap", title="AtlasMap", syntax="atlasmap:resourceUri", producerOnly=true, category={Category.TRANSFORMATION})
public class AtlasMapEndpoint
extends ResourceEndpoint {
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String CONTENT_TYPE_XML = "application/xml";
    private static final Logger LOG = LoggerFactory.getLogger(AtlasMapEndpoint.class);
    private AtlasContextFactory atlasContextFactory;
    private AtlasContext atlasContext;
    @UriParam(label="advanced")
    private String propertiesFile;
    @UriParam
    private String sourceMapName;
    @UriParam
    private String targetMapName;
    @UriParam(defaultValue="MAP")
    private TargetMapMode targetMapMode = TargetMapMode.MAP;

    public AtlasMapEndpoint(String uri, AtlasMapComponent component, String resourceUri) {
        super(uri, (Component)component, resourceUri);
    }

    public boolean isSingleton() {
        return true;
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    protected String createEndpointUri() {
        return "atlasmap:" + this.getResourceUri();
    }

    public AtlasContextFactory getAtlasContextFactory() {
        return this.atlasContextFactory;
    }

    public void setAtlasContextFactory(AtlasContextFactory atlasContextFactory) {
        this.atlasContextFactory = atlasContextFactory;
    }

    public AtlasContext getAtlasContext() {
        return this.atlasContext;
    }

    public void setAtlasContext(AtlasContext atlasContext) {
        this.atlasContext = atlasContext;
    }

    public void setPropertiesFile(String file) {
        this.propertiesFile = file;
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setSourceMapName(String name) {
        this.sourceMapName = name;
    }

    public String getSourceMapName() {
        return this.sourceMapName;
    }

    public void setTargetMapName(String name) {
        this.targetMapName = name;
    }

    public String getTargetMapName() {
        return this.targetMapName;
    }

    public void setTargetMapMode(TargetMapMode mode) {
        this.targetMapMode = mode;
    }

    public TargetMapMode getTargetMapMode() {
        return this.targetMapMode;
    }

    public AtlasMapEndpoint findOrCreateEndpoint(String uri, String newResourceUri) {
        String newUri = uri.replace(this.getResourceUri(), newResourceUri);
        this.log.debug("Getting endpoint with URI: {}", (Object)newUri);
        return (AtlasMapEndpoint)this.getCamelContext().getEndpoint(newUri, AtlasMapEndpoint.class);
    }

    protected void onExchange(Exchange exchange) throws Exception {
        Message incomingMessage = exchange.getIn();
        String newResourceUri = (String)incomingMessage.getHeader("CamelAtlasResourceUri", String.class);
        if (newResourceUri != null) {
            incomingMessage.removeHeader("CamelAtlasResourceUri");
            this.log.debug("{} set to {} creating new endpoint to handle exchange", (Object)"CamelAtlasResourceUri", (Object)newResourceUri);
            AtlasMapEndpoint newEndpoint = this.findOrCreateEndpoint(this.getEndpointUri(), newResourceUri);
            newEndpoint.onExchange(exchange);
            return;
        }
        AtlasSession atlasSession = this.getOrCreateAtlasContext(incomingMessage).createSession();
        this.populateSourceDocuments(exchange, atlasSession);
        atlasSession.getAtlasContext().process(atlasSession);
        ArrayList<Audit> errors = new ArrayList<Audit>();
        block4: for (Audit audit : atlasSession.getAudits().getAudit()) {
            switch (audit.getStatus()) {
                case ERROR: {
                    errors.add(audit);
                    continue block4;
                }
                case WARN: {
                    LOG.warn("{}: Document='{}(ID:{})', path='{}'", new Object[]{audit.getMessage(), audit.getDocName(), audit.getDocId(), audit.getPath()});
                    continue block4;
                }
            }
            LOG.info("{}: Document='{}(ID:{})', path='{}'", new Object[]{audit.getMessage(), audit.getDocName(), audit.getDocId(), audit.getPath()});
        }
        if (!errors.isEmpty()) {
            StringBuilder buf = new StringBuilder("Errors: ");
            errors.stream().forEach(a -> buf.append(String.format("[%s: Document='%s(ID:%s)', path='%s'], ", a.getMessage(), a.getDocName(), a.getDocId(), a.getPath())));
            throw new AtlasException(buf.toString());
        }
        this.populateTargetDocuments(atlasSession, exchange);
    }

    private AtlasContext getOrCreateAtlasContext(Message incomingMessage) throws Exception {
        String path = this.getResourceUri();
        ObjectHelper.notNull((Object)path, (String)"mappingUri");
        String content = (String)incomingMessage.getHeader("CamelAtlasMapping", String.class);
        if (content != null) {
            ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes());
            if (this.log.isDebugEnabled()) {
                this.log.debug("Atlas mapping content read from header {} for endpoint {}", (Object)"CamelAtlasMapping", (Object)this.getEndpointUri());
            }
            incomingMessage.removeHeader("CamelAtlasMapping");
            return this.getOrCreateAtlasContextFactory().createContext(AtlasContextFactory.Format.JSON, (InputStream)is);
        }
        if (this.getAtlasContext() != null) {
            return this.getAtlasContext();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Atlas mapping content read from resourceUri: {} for endpoint {}", (Object)path, (Object)this.getEndpointUri());
        }
        this.atlasContext = this.getOrCreateAtlasContextFactory().createContext(path.toLowerCase().endsWith("adm") ? AtlasContextFactory.Format.ADM : AtlasContextFactory.Format.JSON, this.getResourceAsInputStream());
        return this.atlasContext;
    }

    private synchronized AtlasContextFactory getOrCreateAtlasContextFactory() throws Exception {
        if (this.atlasContextFactory != null) {
            return this.atlasContextFactory;
        }
        this.atlasContextFactory = DefaultAtlasContextFactory.getInstance();
        this.atlasContextFactory.addClassLoader(this.getCamelContext().getApplicationContextClassLoader());
        if (ObjectHelper.isNotEmpty((Object)this.getPropertiesFile())) {
            Properties properties = new Properties();
            InputStream reader = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getCamelContext(), (String)this.getPropertiesFile());
            try {
                properties.load(reader);
                this.log.info("Loaded the Atlas properties file {}", (Object)this.getPropertiesFile());
            }
            finally {
                IOHelper.close((Closeable)reader, (String)this.getPropertiesFile(), (Logger)this.log);
            }
            this.log.debug("Initializing AtlasContextFactory with properties {}", (Object)properties);
            this.atlasContextFactory.setProperties(properties);
        }
        return this.atlasContextFactory;
    }

    private void populateSourceDocuments(Exchange exchange, AtlasSession session) {
        if (session.getMapping().getDataSource() == null) {
            return;
        }
        Message inMessage = exchange.getIn();
        CamelAtlasPropertyStrategy propertyStrategy = new CamelAtlasPropertyStrategy();
        propertyStrategy.setCurrentSourceMessage(inMessage);
        propertyStrategy.setTargetMessage(exchange.getMessage());
        propertyStrategy.setExchange(exchange);
        session.setAtlasPropertyStrategy((AtlasPropertyStrategy)propertyStrategy);
        DataSource[] sourceDataSources = (DataSource[])session.getMapping().getDataSource().stream().filter(ds -> ds.getDataSourceType() == DataSourceType.SOURCE).toArray(DataSource[]::new);
        if (sourceDataSources.length == 0) {
            session.setDefaultSourceDocument(inMessage.getBody());
            return;
        }
        if (sourceDataSources.length == 1) {
            String docId = sourceDataSources[0].getId();
            Object payload = this.extractPayload(sourceDataSources[0], inMessage);
            if (docId == null || docId.isEmpty()) {
                session.setDefaultSourceDocument(payload);
            } else {
                session.setSourceDocument(docId, payload);
                propertyStrategy.setSourceMessage(docId, inMessage);
            }
            return;
        }
        Map sourceMessages = null;
        Map sourceDocuments = null;
        if (this.sourceMapName != null) {
            sourceMessages = (Map)exchange.getProperty(this.sourceMapName, Map.class);
        }
        if (sourceMessages == null) {
            Object body = inMessage.getBody();
            if (body instanceof Map) {
                sourceDocuments = (Map)body;
            } else {
                session.setDefaultSourceDocument(body);
            }
        }
        for (DataSource ds2 : sourceDataSources) {
            Object payload;
            String docId = ds2.getId();
            if (docId == null || docId.isEmpty()) {
                payload = this.extractPayload(ds2, inMessage);
                session.setDefaultSourceDocument(payload);
                continue;
            }
            if (sourceMessages != null) {
                payload = this.extractPayload(ds2, (Message)sourceMessages.get(docId));
                session.setSourceDocument(docId, payload);
                propertyStrategy.setSourceMessage(docId, (Message)sourceMessages.get(docId));
                continue;
            }
            if (sourceDocuments != null) {
                payload = sourceDocuments.get(docId);
                session.setSourceDocument(docId, payload);
                continue;
            }
            if (inMessage.getHeaders().containsKey(docId)) {
                payload = inMessage.getHeader(docId);
                session.setSourceDocument(docId, payload);
                continue;
            }
            if (exchange.getProperties().containsKey(docId)) {
                payload = exchange.getProperty(docId);
                session.setSourceDocument(docId, payload);
                continue;
            }
            LOG.warn("Ignoring missing source document: '{}(ID:{})'", (Object)ds2.getName(), (Object)ds2.getId());
        }
    }

    private Object extractPayload(DataSource dataSource, Message message) {
        if (dataSource == null || message == null) {
            return null;
        }
        Object body = null;
        body = dataSource.getUri() != null && !dataSource.getUri().startsWith("atlas:core") && !dataSource.getUri().startsWith("atlas:java") ? message.getBody(String.class) : message.getBody();
        MessageHelper.resetStreamCache((Message)message);
        return body;
    }

    private void populateTargetDocuments(AtlasSession session, Exchange exchange) {
        Message message = exchange.getMessage();
        if (session.getMapping().getDataSource() == null) {
            return;
        }
        DataSource[] targetDataSources = (DataSource[])session.getMapping().getDataSource().stream().filter(ds -> ds.getDataSourceType() == DataSourceType.TARGET).toArray(DataSource[]::new);
        if (targetDataSources.length == 0) {
            Object newBody = session.getDefaultTargetDocument();
            message.setBody(newBody);
            return;
        }
        if (targetDataSources.length == 1) {
            String docId = targetDataSources[0].getId();
            if (docId == null || docId.isEmpty()) {
                Object newBody = session.getDefaultTargetDocument();
                message.setBody(newBody);
            } else {
                Object newBody = session.getTargetDocument(docId);
                message.setBody(newBody);
            }
            this.setContentType(targetDataSources[0], message);
            return;
        }
        HashMap<String, Object> targetDocuments = new HashMap<String, Object>();
        for (DataSource ds2 : targetDataSources) {
            String docId = ds2.getId();
            if (docId == null || docId.isEmpty()) {
                targetDocuments.put("ATLAS_DEFAULT_TARGET_DOC", session.getDefaultTargetDocument());
                Object newBody = session.getDefaultTargetDocument();
                message.setBody(newBody);
                this.setContentType(ds2, message);
                continue;
            }
            targetDocuments.put(docId, session.getTargetDocument(docId));
        }
        switch (this.targetMapMode) {
            case MAP: {
                if (this.targetMapName != null) {
                    exchange.setProperty(this.targetMapName, targetDocuments);
                    break;
                }
                message.setBody(targetDocuments);
                break;
            }
            case MESSAGE_HEADER: {
                targetDocuments.remove("ATLAS_DEFAULT_TARGET_DOC");
                message.getHeaders().putAll(targetDocuments);
                break;
            }
            case EXCHANGE_PROPERTY: {
                targetDocuments.remove("ATLAS_DEFAULT_TARGET_DOC");
                exchange.getProperties().putAll(targetDocuments);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown targetMapMode: " + this.targetMapMode.name());
            }
        }
    }

    private void setContentType(DataSource ds, Message message) {
        if (ds.getUri() == null) {
            return;
        }
        if (ds.getUri().startsWith("atlas:json")) {
            message.setHeader("Content-Type", (Object)CONTENT_TYPE_JSON);
        } else if (ds.getUri().startsWith("atlas:xml")) {
            message.setHeader("Content-Type", (Object)CONTENT_TYPE_XML);
        }
    }

    public static enum TargetMapMode {
        MAP,
        MESSAGE_HEADER,
        EXCHANGE_PROPERTY;

    }
}

