/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atmosphere.websocket;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.component.atmosphere.websocket.WebsocketConsumer;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.servlet.CamelHttpTransportServlet;

public class CamelWebSocketServlet
extends CamelHttpTransportServlet {
    private static final long serialVersionUID = 1764707448550670635L;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.trace("Service: {}", (Object)request);
        HttpConsumer consumer = this.getServletResolveConsumerStrategy().resolve(request, this.getConsumers());
        if (consumer == null) {
            this.log.debug("No consumer to service request {}", (Object)request);
            response.sendError(404);
            return;
        }
        if (consumer.isSuspended()) {
            this.log.debug("Consumer suspended, cannot service request {}", (Object)request);
            response.sendError(503);
            return;
        }
        if (consumer.getEndpoint().getHttpMethodRestrict() != null && !consumer.getEndpoint().getHttpMethodRestrict().equals(request.getMethod())) {
            response.sendError(405);
            return;
        }
        if ("TRACE".equals(request.getMethod()) && !consumer.isTraceEnabled()) {
            response.sendError(405);
            return;
        }
        if (!(consumer instanceof WebsocketConsumer)) {
            this.log.debug("Consumer not supporting websocket {}", (Object)request);
            response.sendError(503);
            return;
        }
        this.log.debug("Dispatching to Websocket Consumer at {}", (Object)consumer.getPath());
        ((WebsocketConsumer)consumer).service(request, response);
    }
}

