/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atmosphere.websocket;

import java.util.List;
import java.util.UUID;
import org.apache.camel.component.atmosphere.websocket.WebSocketStore;
import org.apache.camel.component.atmosphere.websocket.WebsocketConsumer;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketHandler
implements WebSocketProtocol {
    private static final transient Logger LOG = LoggerFactory.getLogger(WebsocketHandler.class);
    protected WebsocketConsumer consumer;
    protected WebSocketStore store;

    public void configure(AtmosphereConfig config) {
    }

    public void onClose(WebSocket webSocket) {
        LOG.info("closing websocket");
        this.store.removeWebSocket(webSocket);
        LOG.info("websocket closed");
    }

    public void onError(WebSocket webSocket, WebSocketProcessor.WebSocketException t) {
        LOG.error("websocket on error", (Throwable)t);
    }

    public void onOpen(WebSocket webSocket) {
        LOG.info("opening websocket");
        String connectionKey = UUID.randomUUID().toString();
        this.store.addWebSocket(connectionKey, webSocket);
        LOG.info("websocket opened");
    }

    public List<AtmosphereRequest> onMessage(WebSocket webSocket, String data) {
        LOG.info("processing text message {}", (Object)data);
        String connectionKey = this.store.getConnectionKey(webSocket);
        this.consumer.sendMessage(connectionKey, data);
        LOG.info("text message sent");
        return null;
    }

    public List<AtmosphereRequest> onMessage(WebSocket webSocket, byte[] data, int offset, int length) {
        LOG.info("processing byte message {}", (Object)data);
        String connectionKey = this.store.getConnectionKey(webSocket);
        if (length < data.length) {
            byte[] rawdata = data;
            data = new byte[length];
            System.arraycopy(rawdata, offset, data, 0, length);
        }
        this.consumer.sendMessage(connectionKey, data);
        LOG.info("byte message sent");
        return null;
    }

    public void setConsumer(WebsocketConsumer consumer) {
        this.consumer = consumer;
        this.store = consumer.getEndpoint().getWebSocketStore();
    }
}

