/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atmosphere.websocket;

import java.io.InputStream;
import java.io.Reader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.atmosphere.websocket.WebsocketEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.atmosphere.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketProducer
extends DefaultProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(WebsocketProducer.class);
    private static ExecutorService executor = Executors.newSingleThreadExecutor();

    public WebsocketProducer(WebsocketEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public WebsocketEndpoint getEndpoint() {
        return (WebsocketEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        Object message = in.getBody();
        if (message == null) {
            LOG.info("Ignoring a null message");
            return;
        }
        if (!(message instanceof String || message instanceof byte[] || message instanceof Reader || message instanceof InputStream)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Using String for unexpected message type {} ", message.getClass());
            }
            message = in.getBody(String.class);
        }
        if (message instanceof Reader) {
            message = in.getBody(String.class);
        } else if (message instanceof InputStream) {
            message = in.getBody(byte[].class);
        }
        this.log.debug("Sending to {}", message);
        if (this.getEndpoint().isSendToAll()) {
            this.log.debug("Sending to all -> {}", message);
            for (final WebSocket websocket : this.getEndpoint().getWebSocketStore().getAllWebSockets()) {
                final Object msg = message;
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        WebsocketProducer.this.sendMessage(websocket, msg);
                    }
                });
            }
        } else {
            String connectionKey = (String)in.getHeader("websocket.connectionKey", String.class);
            if (connectionKey != null) {
                WebSocket websocket = this.getEndpoint().getWebSocketStore().getWebSocket(connectionKey);
                this.log.debug("Sending to connection key {} -> {}", (Object)connectionKey, message);
                this.sendMessage(websocket, message);
            } else {
                throw new IllegalArgumentException("Failed to send message to single connection; connetion key not set.");
            }
        }
    }

    private void sendMessage(WebSocket websocket, Object message) {
        try {
            if (message instanceof String) {
                websocket.write((String)message);
            } else if (message instanceof byte[]) {
                websocket.write((byte[])message, 0, ((byte[])message).length);
            } else {
                LOG.error("unexpected message type {}", message == null ? null : message.getClass());
            }
        }
        catch (Exception e) {
            LOG.error("Error when writing to websocket", (Throwable)e);
        }
    }
}

