/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atmosphere.websocket;

import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import org.apache.camel.component.atmosphere.websocket.WebsocketHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProtocolStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketStreamHandler
extends WebsocketHandler
implements WebSocketProtocolStream {
    private static final transient Logger LOG = LoggerFactory.getLogger(WebsocketStreamHandler.class);

    public List<AtmosphereRequest> onTextStream(WebSocket webSocket, Reader data) {
        LOG.info("processing reader message {}", (Object)data);
        String connectionKey = this.store.getConnectionKey(webSocket);
        this.consumer.sendMessage(connectionKey, data);
        LOG.info("reader message sent");
        return null;
    }

    public List<AtmosphereRequest> onBinaryStream(WebSocket webSocket, InputStream data) {
        LOG.info("processing inputstream message {}", (Object)data);
        String connectionKey = this.store.getConnectionKey(webSocket);
        this.consumer.sendMessage(connectionKey, data);
        LOG.info("reader message sent");
        return null;
    }
}

