/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atmosphere.websocket;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.atmosphere.websocket.WebSocketStore;
import org.apache.camel.component.atmosphere.websocket.WebsocketComponent;
import org.apache.camel.component.atmosphere.websocket.WebsocketConsumer;
import org.apache.camel.component.atmosphere.websocket.WebsocketProducer;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.servlet.ServletComponent;
import org.apache.camel.component.servlet.ServletEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;

@UriEndpoint(scheme="atmosphere-websocket", title="Atmosphere Websocket", syntax="atmosphere-websocket:servicePath", consumerClass=WebsocketConsumer.class, label="http,websocket")
public class WebsocketEndpoint
extends ServletEndpoint {
    private WebSocketStore store;
    @UriPath
    private String servicePath;
    @UriParam(defaultValue="false")
    private boolean sendToAll;
    @UriParam(defaultValue="false")
    private boolean useStreaming;

    public WebsocketEndpoint(String endPointURI, WebsocketComponent component, URI httpUri, HttpClientParams params, HttpConnectionManager httpConnectionManager, HttpClientConfigurer clientConfigurer) throws URISyntaxException {
        super(endPointURI, (ServletComponent)component, httpUri, params, httpConnectionManager, clientConfigurer);
        String name;
        int idx = endPointURI.indexOf(63);
        this.servicePath = name = idx > -1 ? endPointURI.substring(0, idx) : endPointURI;
        this.store = component.getWebSocketStore(this.servicePath);
    }

    public Producer createProducer() throws Exception {
        return new WebsocketProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new WebsocketConsumer(this, processor);
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isSendToAll() {
        return this.sendToAll;
    }

    public void setSendToAll(boolean sendToAll) {
        this.sendToAll = sendToAll;
    }

    public boolean isUseStreaming() {
        return this.useStreaming;
    }

    public void setUseStreaming(boolean useStreaming) {
        this.useStreaming = useStreaming;
    }

    WebSocketStore getWebSocketStore() {
        return this.store;
    }
}

