/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atmosphere.websocket;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.atmosphere.websocket.WebsocketEndpoint;
import org.apache.camel.component.atmosphere.websocket.WebsocketHandler;
import org.apache.camel.component.atmosphere.websocket.WebsocketStreamHandler;
import org.apache.camel.component.servlet.ServletConsumer;
import org.apache.camel.component.servlet.ServletEndpoint;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequestImpl;
import org.atmosphere.cpr.AtmosphereResponseImpl;
import org.atmosphere.websocket.WebSocketProtocol;

public class WebsocketConsumer
extends ServletConsumer {
    private AtmosphereFramework framework;
    private boolean enableEventsResending;
    private Map<String, String> queryMap = new HashMap<String, String>();

    public WebsocketConsumer(WebsocketEndpoint endpoint, Processor processor) {
        super((ServletEndpoint)endpoint, processor);
        this.framework = new AtmosphereFramework(false, true);
        this.framework.setUseNativeImplementation(false);
        this.framework.addInitParameter("org.atmosphere.useWebSocket", "true");
        this.framework.addInitParameter("org.atmosphere.websocket.WebSocketProtocol", endpoint.isUseStreaming() ? WebsocketStreamHandler.class.getName() : WebsocketHandler.class.getName());
        this.framework.addInitParameter("org.atmosphere.websocket.suppressJSR356", "true");
        this.framework.init();
        WebSocketProtocol wsp = this.framework.getWebSocketProtocol();
        if (!(wsp instanceof WebsocketHandler)) {
            throw new IllegalArgumentException("Unexpected WebSocketHandler: " + wsp);
        }
        ((WebsocketHandler)wsp).setConsumer(this);
    }

    public WebsocketEndpoint getEndpoint() {
        return (WebsocketEndpoint)super.getEndpoint();
    }

    void service(HttpServletRequest request, HttpServletResponse response, boolean enableEventsResending) throws IOException, ServletException {
        this.enableEventsResending = enableEventsResending;
        this.queryMap = this.getQueryMap(request.getQueryString());
        this.framework.doCometSupport(AtmosphereRequestImpl.wrap((HttpServletRequest)request), AtmosphereResponseImpl.wrap((HttpServletResponse)response));
    }

    public void sendMessage(String connectionKey, Object message) {
        final Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setHeader("websocket.connectionKey", (Object)connectionKey);
        exchange.getIn().setBody(message);
        this.getAsyncProcessor().process(exchange, new AsyncCallback(){

            public void done(boolean doneSync) {
                if (exchange.getException() != null) {
                    WebsocketConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
                }
            }
        });
    }

    public void sendEventNotification(String connectionKey, int eventType) {
        final Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setHeader("websocket.connectionKey", (Object)connectionKey);
        exchange.getIn().setHeader("websocket.eventType", (Object)eventType);
        for (Map.Entry<String, String> param : this.queryMap.entrySet()) {
            exchange.getIn().setHeader(param.getKey(), (Object)param.getValue());
        }
        this.getAsyncProcessor().process(exchange, new AsyncCallback(){

            public void done(boolean doneSync) {
                if (exchange.getException() != null) {
                    WebsocketConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
                }
            }
        });
    }

    public void sendNotDeliveredMessage(List<String> failedConnectionKeys, Object message) {
        final Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setHeader("websocket.connectionKey.list", failedConnectionKeys);
        exchange.getIn().setHeader("websocket.errorType", (Object)1);
        exchange.getIn().setBody(message);
        this.getAsyncProcessor().process(exchange, new AsyncCallback(){

            public void done(boolean doneSync) {
                if (exchange.getException() != null) {
                    WebsocketConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
                }
            }
        });
    }

    public boolean isEnableEventsResending() {
        return this.enableEventsResending;
    }

    private Map<String, String> getQueryMap(String query) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (query != null) {
            String[] params;
            for (String param : params = query.split("&")) {
                String[] nameval = param.split("=");
                map.put(nameval[0], nameval[1]);
            }
        }
        return map;
    }
}

