/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atmosphere.websocket;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.atmosphere.websocket.WebSocketStore;
import org.apache.camel.component.atmosphere.websocket.WebsocketComponent;
import org.apache.camel.component.atmosphere.websocket.WebsocketConstants;
import org.apache.camel.component.atmosphere.websocket.WebsocketConsumer;
import org.apache.camel.component.atmosphere.websocket.WebsocketProducer;
import org.apache.camel.component.servlet.ServletComponent;
import org.apache.camel.component.servlet.ServletEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(firstVersion="2.14.0", scheme="atmosphere-websocket", extendsScheme="servlet", title="Atmosphere Websocket", syntax="atmosphere-websocket:servicePath", category={Category.WEBSOCKET}, headersClass=WebsocketConstants.class)
@Metadata(excludeProperties="httpUri,contextPath,cookieHandler,connectionClose,authMethod,authMethodPriority,authUsername,authPassword,authDomain,authHost,copyHeaders,httpMethod,ignoreResponseBody,preserveHostHeader,throwExceptionOnFailure,okStatusCodeRange,proxyAuthScheme,proxyAuthMethod,proxyAuthUsername,proxyAuthPassword,proxyAuthHost,proxyAuthPort,proxyAuthDomain,proxyAuthNtHost,proxyAuthScheme,proxyHost,proxyPort")
public class WebsocketEndpoint
extends ServletEndpoint {
    private WebSocketStore store;
    private WebsocketConsumer websocketConsumer;
    @UriPath(description="Name of websocket endpoint")
    @Metadata(required=true)
    private String servicePath;
    @UriParam
    private boolean sendToAll;
    @UriParam
    private boolean useStreaming;

    public WebsocketEndpoint(String endPointURI, WebsocketComponent component, URI httpUri) throws URISyntaxException {
        super(endPointURI, (ServletComponent)component, httpUri);
        String name;
        int idx = endPointURI.indexOf(63);
        this.servicePath = name = idx > -1 ? endPointURI.substring(0, idx) : endPointURI;
        this.store = component.getWebSocketStore(this.servicePath);
    }

    public Producer createProducer() throws Exception {
        return new WebsocketProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        this.websocketConsumer = new WebsocketConsumer(this, processor);
        return this.websocketConsumer;
    }

    public boolean isSendToAll() {
        return this.sendToAll;
    }

    public void setSendToAll(boolean sendToAll) {
        this.sendToAll = sendToAll;
    }

    public boolean isUseStreaming() {
        return this.useStreaming;
    }

    public void setUseStreaming(boolean useStreaming) {
        this.useStreaming = useStreaming;
    }

    WebSocketStore getWebSocketStore() {
        return this.store;
    }

    public WebsocketConsumer getWebsocketConsumer() {
        return this.websocketConsumer;
    }
}

